/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4; fill-column: 100 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

/** Those are the starmath codes for ElementsDockingWindow.hxx.
  *
  * Those codes will be displayed as formulas on the ElementsDockingWindow.
  * The user can then graphically insert them.
  */

#pragma once

#include <rtl/ustring.hxx>

inline constexpr OUString RID_UNDOFORMATNAME = u"Format"_ustr;

// clang-format off
#define RID_PLUSX               u"+<?> "
#define RID_MINUSX              u"-<?> "
#define RID_PLUSMINUSX          u"+-<?> "
#define RID_MINUSPLUSX          u"-+<?> "
#define RID_NEGX                u"neg <?> "
#define RID_XPLUSY              u"<?> + <?> "
#define RID_XMINUSY             u"<?> - <?> "
#define RID_XCDOTY              u"<?> cdot <?> "
#define RID_XTIMESY             u"<?> times <?> "
#define RID_XSYMTIMESY          u"<?> * <?> "
#define RID_XSYMDIVIDEY         u"<?> / <?> "
#define RID_XDIVY               u"<?> div <?> "
#define RID_XOVERY              u"{<?>} over {<?>} "
#define RID_FRACXY              u"frac {<?>} {<?>} "
#define RID_XODIVIDEY           u"<?> odivide <?> "
#define RID_XODOTY              u"<?> odot <?> "
#define RID_XOMINUSY            u"<?> ominus <?> "
#define RID_XOPLUSY             u"<?> oplus <?> "
#define RID_XOTIMESY            u"<?> otimes <?> "
#define RID_XANDY               u"<?> and <?> "
#define RID_XORY                u"<?> or <?> "
#define RID_XEQY                u"<?> = <?> "
#define RID_XNEQY               u"<?> <> <?> "
#define RID_XLTY                u"<?> < <?> "
#define RID_XGTY                u"<?> > <?> "
#define RID_XLEY                u"<?> <= <?> "
#define RID_XGEY                u"<?> >= <?> "
#define RID_XLESLANTY           u"<?> leslant <?> "
#define RID_XGESLANTY           u"<?> geslant <?> "
#define RID_XLLY                u"<?> << <?> "
#define RID_XGGY                u"<?> >> <?> "
#define RID_XDEFY               u"<?> def <?> "
#define RID_XEQUIVY             u"<?> equiv <?> "
#define RID_XAPPROXY            u"<?> approx <?> "
#define RID_XSIMY               u"<?> sim <?> "
#define RID_XSIMEQY             u"<?> simeq <?> "
#define RID_XPROPY              u"<?> prop <?> "
#define RID_XORTHOY             u"<?> ortho <?> "
#define RID_XPARALLELY          u"<?> parallel <?> "
#define RID_XTOWARDY            u"<?> toward <?> "
#define RID_XTRANSLY            u"<?> transl <?> "
#define RID_XTRANSRY            u"<?> transr <?> "
#define RID_XINY                u"<?> in <?> "
#define RID_XNOTINY             u"<?> notin <?> "
#define RID_XOWNSY              u"<?> owns <?> "
#define RID_XUNIONY             u"<?> union <?> "
#define RID_XINTERSECTIONY      u"<?> intersection <?> "
#define RID_XSETMINUSY          u"<?> setminus <?> "
#define RID_XSETQUOTIENTY       u"<?> setquotient <?> "
#define RID_XSUBSETY            u"<?> subset <?> "
#define RID_XSUBSETEQY          u"<?> subseteq <?> "
#define RID_XSUPSETY            u"<?> supset <?> "
#define RID_XSUPSETEQY          u"<?> supseteq <?> "
#define RID_XNSUBSETY           u"<?> nsubset <?> "
#define RID_XNSUBSETEQY         u"<?> nsubseteq <?> "
#define RID_XNSUPSETY           u"<?> nsupset <?> "
#define RID_XNSUPSETEQY         u"<?> nsupseteq <?> "
#define RID_FUNCX               u"func <?>(<?>) "
#define RID_ABSX                u"abs{<?>} "
#define RID_FACTX               u"fact{<?>} "
#define RID_SQRTX               u"sqrt{<?>} "
#define RID_NROOTXY             u"nroot{<?>}{<?>} "
#define RID_EX                  u"func e^{<?>} "
#define RID_EXPX                u"exp(<?>) "
#define RID_LNX                 u"ln(<?>) "
#define RID_LOGX                u"log(<?>) "
#define RID_SINX                u"sin(<?>) "
#define RID_COSX                u"cos(<?>) "
#define RID_TANX                u"tan(<?>) "
#define RID_COTX                u"cot(<?>) "
#define RID_ARCSINX             u"arcsin(<?>) "
#define RID_ARCCOSX             u"arccos(<?>) "
#define RID_ARCTANX             u"arctan(<?>) "
#define RID_ARCCOTX             u"arccot(<?>) "
#define RID_SINHX               u"sinh(<?>) "
#define RID_COSHX               u"cosh(<?>) "
#define RID_TANHX               u"tanh(<?>) "
#define RID_COTHX               u"coth(<?>) "
#define RID_ARSINHX             u"arsinh(<?>) "
#define RID_ARCOSHX             u"arcosh(<?>) "
#define RID_ARTANHX             u"artanh(<?>) "
#define RID_ARCOTHX             u"arcoth(<?>) "
#define RID_OPERX               u"oper oper <?> "
#define RID_OPER_FROMX          u"oper oper from{<?>} <?> "
#define RID_OPER_TOX            u"oper oper to{<?>} <?> "
#define RID_OPER_FROMTOX        u"oper oper from{<?>} to{<?>} <?> "
#define RID_SUMX                u"sum <?> "
#define RID_SUM_FROMX           u"sum from{<?>} <?> "
#define RID_SUM_TOX             u"sum to{<?>} <?> "
#define RID_SUM_FROMTOX         u"sum from{<?>} to{<?>} <?> "
#define RID_MAJX                u"maj <?> "
#define RID_MAJ_FROMX           u"maj from{<?>} <?> "
#define RID_MAJ_TOX             u"maj to{<?>} <?> "
#define RID_MAJ_FROMTOX         u"maj from{<?>} to{<?>} <?> "
#define RID_PRODX               u"prod <?> "
#define RID_PROD_FROMX          u"prod from{<?>} <?> "
#define RID_PROD_TOX            u"prod to{<?>} <?> "
#define RID_PROD_FROMTOX        u"prod from{<?>} to{<?>} <?> "
#define RID_COPRODX             u"coprod <?> "
#define RID_COPROD_FROMX        u"coprod from{<?>} <?> "
#define RID_COPROD_TOX          u"coprod to{<?>} <?> "
#define RID_COPROD_FROMTOX      u"coprod from{<?>} to{<?>} <?> "
#define RID_LIMX                u"lim <?> "
#define RID_LIM_FROMX           u"lim from{<?>} <?> "
#define RID_LIM_TOX             u"lim to{<?>} <?> "
#define RID_LIM_FROMTOX         u"lim from{<?>} to{<?>} <?> "
#define RID_LIMINFX             u"liminf <?> "
#define RID_LIMINF_FROMX        u"liminf from{<?>} <?> "
#define RID_LIMINF_TOX          u"liminf to{<?>} <?> "
#define RID_LIMINF_FROMTOX      u"liminf from{<?>} to{<?>} <?> "
#define RID_LIMSUPX             u"limsup <?> "
#define RID_LIMSUP_FROMX        u"limsup from{<?>} <?> "
#define RID_LIMSUP_TOX          u"limsup to{<?>} <?> "
#define RID_LIMSUP_FROMTOX      u"limsup from{<?>} to{<?>} <?> "
#define RID_HADDX               u"hadd <?> "
#define RID_HADD_FROMX          u"hadd from{<?>} <?> "
#define RID_HADD_TOX            u"hadd to{<?>} <?> "
#define RID_HADD_FROMTOX        u"hadd from{<?>} to{<?>} <?> "
#define RID_EXISTS              u"exists "
#define RID_NOTEXISTS           u"notexists "
#define RID_FORALL              u"forall "
#define RID_INTX                u"int <?> "
#define RID_INT_FROMX           u"int from{<?>} <?> "
#define RID_INT_TOX             u"int to{<?>} <?> "
#define RID_INT_FROMTOX         u"int from{<?>} to{<?>} <?> "
#define RID_IINTX               u"iint <?> "
#define RID_IINT_FROMX          u"iint from{<?>} <?> "
#define RID_IINT_TOX            u"iint to{<?>} <?> "
#define RID_IINT_FROMTOX        u"iint from{<?>} to{<?>} <?> "
#define RID_IIINTX              u"iiint <?> "
#define RID_IIINT_FROMX         u"iiint from{<?>} <?> "
#define RID_IIINT_TOX           u"iiint to{<?>} <?> "
#define RID_IIINT_FROMTOX       u"iiint from{<?>} to{<?>} <?> "
#define RID_LINTX               u"lint <?> "
#define RID_LINT_FROMX          u"lint from{<?>} <?> "
#define RID_LINT_TOX            u"lint to{<?>} <?> "
#define RID_LINT_FROMTOX        u"lint from{<?>} to{<?>} <?> "
#define RID_LLINTX              u"llint <?> "
#define RID_LLINT_FROMX         u"llint from{<?>} <?> "
#define RID_LLINT_TOX           u"llint to{<?>} <?> "
#define RID_LLINT_FROMTOX       u"llint from{<?>} to{<?>} <?> "
#define RID_LLLINTX             u"lllint <?> "
#define RID_LLLINT_FROMX        u"lllint from{<?>} <?> "
#define RID_LLLINT_TOX          u"lllint to{<?>} <?> "
#define RID_LLLINT_FROMTOX      u"lllint from{<?>} to{<?>} <?> "
#define RID_ACUTEX              u"acute <?> "
#define RID_BARX                u"bar <?> "
#define RID_BREVEX              u"breve <?> "
#define RID_CHECKX              u"check <?> "
#define RID_CIRCLEX             u"circle <?> "
#define RID_DOTX                u"dot <?> "
#define RID_DDOTX               u"ddot <?> "
#define RID_DDDOTX              u"dddot <?> "
#define RID_GRAVEX              u"grave <?> "
#define RID_HATX                u"hat <?> "
#define RID_TILDEX              u"tilde <?> "
#define RID_VECX                u"vec <?> "
#define RID_HARPOONX            u"harpoon <?> "
#define RID_UNDERLINEX          u"underline {<?>} "
#define RID_OVERLINEX           u"overline {<?>} "
#define RID_OVERSTRIKEX         u"overstrike {<?>} "
#define RID_PHANTOMX            u"phantom {<?>} "
#define RID_BOLDX               u"bold <?> "
#define RID_ITALX               u"ital <?> "
#define RID_SIZEXY              u"size <?> {<?>} "
#define RID_FONTXY              u"font <?> {<?>} "
#define RID_COLORX_BLACK        u"color black {<?>} "
#define RID_COLORX_BLUE         u"color blue {<?>} "
#define RID_COLORX_GREEN        u"color green {<?>} "
#define RID_COLORX_RED          u"color red {<?>} "
#define RID_COLORX_AQUA         u"color aqua {<?>} "
#define RID_COLORX_FUCHSIA      u"color fuchsia {<?>} "
#define RID_COLORX_GRAY         u"color gray {<?>} "
#define RID_COLORX_LIME         u"color lime {<?>} "
#define RID_COLORX_MAROON       u"color maroon {<?>} "
#define RID_COLORX_NAVY         u"color navy {<?>} "
#define RID_COLORX_OLIVE        u"color olive {<?>} "
#define RID_COLORX_PURPLE       u"color purple {<?>} "
#define RID_COLORX_SILVER       u"color silver {<?>} "
#define RID_COLORX_TEAL         u"color teal {<?>} "
#define RID_COLORX_YELLOW       u"color yellow {<?>} "
#define RID_COLORX_RGB          u"color rgb 0 0 0 {<?>} "
#define RID_COLORX_RGBA         u"color rgba 0 0 0 0 {<?>} "
#define RID_COLORX_HEX          u"color hex 000000 {<?>} "
#define RID_COLORX_CORAL        u"color coral {<?>} "
#define RID_COLORX_CRIMSON      u"color crimson {<?>} "
#define RID_COLORX_MIDNIGHT     u"color midnightblue {<?>} "
#define RID_COLORX_VIOLET       u"color violet {<?>} "
#define RID_COLORX_ORANGE       u"color orange {<?>} "
#define RID_COLORX_ORANGERED    u"color orangered {<?>} "
#define RID_COLORX_SEAGREEN     u"color seagreen {<?>} "
#define RID_COLORX_INDIGO       u"color indigo {<?>} "
#define RID_COLORX_HOTPINK      u"color hotpink {<?>} "
#define RID_COLORX_LAVENDER     u"color lavender {<?>} "
#define RID_COLORX_SNOW         u"color snow {<?>} "
#define RID_LRGROUPX            u"{<?>} "
#define RID_LRPARENTX           u"(<?>) "
#define RID_LRBRACKETX          u"[<?>] "
#define RID_LRDBRACKETX         u"ldbracket <?> rdbracket "
#define RID_LRBRACEX            u"lbrace <?> rbrace "
#define RID_LRANGLEX            u"langle <?> rangle "
#define RID_LRCEILX             u"lceil <?> rceil "
#define RID_LRFLOORX            u"lfloor <?> rfloor "
#define RID_LRLINEX             u"lline <?> rline "
#define RID_LRDLINEX            u"ldline <?> rdline "
#define RID_LMRANGLEXY          u"langle <?> mline <?> rangle "
#define RID_SLRPARENTX          u"left ( <?> right ) "
#define RID_SLRBRACKETX         u"left [ <?> right ] "
#define RID_SLRDBRACKETX        u"left ldbracket <?> right rdbracket "
#define RID_SLRBRACEX           u"left lbrace <?> right rbrace "
#define RID_SLRANGLEX           u"left langle <?> right rangle "
#define RID_SLRCEILX            u"left lceil <?> right rceil "
#define RID_SLRFLOORX           u"left lfloor <?> right rfloor "
#define RID_SLRLINEX            u"left lline <?> right rline "
#define RID_SLRDLINEX           u"left ldline <?> right rdline "
#define RID_SLMRANGLEXY         u"left langle <?> mline <?> right rangle "
#define RID_XOVERBRACEY         u"{<?>} overbrace {<?>} "
#define RID_XUNDERBRACEY        u"{<?>} underbrace {<?>} "
#define RID_EVALX               u"evaluate <?> "
#define RID_EVAL_FROMX          u"evaluate {<?>} from{<?>} "
#define RID_EVAL_TOX            u"evaluate {<?>} to{<?>} "
#define RID_EVAL_FROMTOX        u"evaluate {<?>} from{<?>} to{<?>} "
#define RID_RSUBX               u"<?>_{<?>} "
#define RID_RSUPX               u"<?>^{<?>} "
#define RID_LSUBX               u"<?> lsub{<?>} "
#define RID_LSUPX               u"<?> lsup{<?>} "
#define RID_CSUBX               u"<?> csub{<?>} "
#define RID_CSUPX               u"<?> csup{<?>} "
#define RID_SBLANK              u"` "
#define RID_BLANK               u"~ "
#define RID_NEWLINE             u"newline "
#define RID_BINOMXY             u"binom{<?>}{<?>} "
#define RID_STACK               u"stack{<?> # <?> # <?>} "
#define RID_MATRIX              u"matrix{<?> # <?> ## <?> # <?>} "
#define RID_ALIGNLX             u"alignl <?> "
#define RID_ALIGNCX             u"alignc <?> "
#define RID_ALIGNRX             u"alignr <?> "
#define RID_ALEPH               u"aleph "
#define RID_EMPTYSET            u"emptyset "
#define RID_RE                  u"Re "
#define RID_IM                  u"Im "
#define RID_INFINITY            u"infinity "
#define RID_PARTIAL             u"partial "
#define RID_NABLA               u"nabla "
#define RID_WP                  u"wp "
#define RID_LAPLACE             u"laplace "
#define RID_BACKEPSILON         u"backepsilon "
#define RID_FOURIER             u"fourier "
#define RID_DOTSAXIS            u"dotsaxis "
#define RID_DOTSUP              u"dotsup "
#define RID_DOTSDOWN            u"dotsdown "
#define RID_DOTSLOW             u"dotslow "
#define RID_DOTSVERT            u"dotsvert "
#define RID_XCIRCY              u"<?> circ <?> "
#define RID_XWIDESLASHY         u"{<?>} wideslash {<?>} "
#define RID_XWIDEBSLASHY        u"{<?>} widebslash {<?>} "
#define RID_XDIVIDESY           u"<?> divides <?> "
#define RID_XNDIVIDESY          u"<?> ndivides <?> "
#define RID_DLARROW             u"<?> dlarrow <?> "
#define RID_DLRARROW            u"<?> dlrarrow <?> "
#define RID_DRARROW             u"<?> drarrow <?> "
#define RID_SETN                u"setN "
#define RID_SETZ                u"setZ "
#define RID_SETQ                u"setQ "
#define RID_SETR                u"setR "
#define RID_SETC                u"setC "
#define RID_WIDEHATX            u"widehat {<?>} "
#define RID_WIDETILDEX          u"widetilde {<?>} "
#define RID_WIDEVECX            u"widevec {<?>} "
#define RID_WIDEHARPOONX        u"wideharpoon {<?>} "
#define RID_HBAR                u"hbar "
#define RID_LAMBDABAR           u"lambdabar "
#define RID_LEFTARROW           u"leftarrow "
#define RID_RIGHTARROW          u"rightarrow "
#define RID_UPARROW             u"uparrow "
#define RID_DOWNARROW           u"downarrow "
#define RID_NOSPACE             u"nospace {<?>} "
#define RID_XPRECEDESY          u"<?> prec <?> "
#define RID_XPRECEDESEQUALY     u"<?> preccurlyeq <?> "
#define RID_XPRECEDESEQUIVY     u"<?> precsim <?> "
#define RID_XSUCCEEDSY          u"<?> succ <?> "
#define RID_XSUCCEEDSEQUALY     u"<?> succcurlyeq <?> "
#define RID_XSUCCEEDSEQUIVY     u"<?> succsim <?> "
#define RID_XNOTPRECEDESY       u"<?> nprec <?> "
#define RID_XNOTSUCCEEDSY       u"<?> nsucc <?> "
#define RID_ARALOGX             u"لو(<?>) "
#define RID_ARASINX             u"حا(<?>) "
#define RID_ARACOSX             u"حتا(<?>) "
#define RID_ARATANX             u"طا(<?>) "
#define RID_ARACOTX             u"طتا(<?>) "
#define RID_ARASECX             u"ٯا(<?>) "
#define RID_ARACSCX             u"ٯتا(<?>) "
#define RID_ARASINHX            u"حاز(<?>) "
#define RID_ARACOSHX            u"حتاز(<?>) "
#define RID_ARATANHX            u"طاز(<?>) "
#define RID_ARACOTHX            u"طتاز(<?>) "
#define RID_ARASECHX            u"ٯاز(<?>) "
#define RID_ARACSCHX            u"ٯتاز(<?>) "
#define RID_ARASIN2X            u"جا(<?>) "
#define RID_ARACOS2X            u"جتا(<?>) "
#define RID_ARATAN2X            u"ظا(<?>) "
#define RID_ARACOT2X            u"ظتا(<?>) "
#define RID_ARASEC2X            u"قا(<?>) "
#define RID_ARACSC2X            u"قتا(<?>) "
#define RID_ARASINH2X           u"جاز(<?>) "
#define RID_ARACOSH2X           u"جتاز(<?>) "
#define RID_ARATANH2X           u"ظاز(<?>) "
#define RID_ARACOTH2X           u"ظتاز(<?>) "
#define RID_ARASECH2X           u"قاز(<?>) "
#define RID_ARACSCH2X           u"قتاز(<?>) "
// clang-format on

/* vim:set shiftwidth=4 softtabstop=4 expandtab cinoptions=b1,g0,N-s cinkeys+=0=break: */
