// Code generated by pluginrpc-gen. DO NOT EDIT.

package drivers

import (
	"errors"
	"time"

	"github.com/moby/moby/v2/daemon/volume"
	"github.com/moby/moby/v2/pkg/plugins"
)

const (
	longTimeout  = 2 * time.Minute
	shortTimeout = 1 * time.Minute
)

type client interface {
	CallWithOptions(serviceMethod string, args interface{}, ret interface{}, opts ...func(*plugins.RequestOpts)) error
}

type volumeDriverProxy struct {
	client
}

type volumeDriverProxyCreateRequest struct {
	Name string
	Opts map[string]string
}

type volumeDriverProxyCreateResponse struct {
	Err string
}

// Create a volume with the given name
func (pp *volumeDriverProxy) Create(name string, opts map[string]string) (err error) {
	var (
		req volumeDriverProxyCreateRequest
		ret volumeDriverProxyCreateResponse
	)

	req.Name = name
	req.Opts = opts

	if err = pp.CallWithOptions("VolumeDriver.Create", req, &ret, plugins.WithRequestTimeout(longTimeout)); err != nil {
		return
	}

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyRemoveRequest struct {
	Name string
}

type volumeDriverProxyRemoveResponse struct {
	Err string
}

// Remove the volume with the given name
func (pp *volumeDriverProxy) Remove(name string) (err error) {
	var (
		req volumeDriverProxyRemoveRequest
		ret volumeDriverProxyRemoveResponse
	)

	req.Name = name

	if err = pp.CallWithOptions("VolumeDriver.Remove", req, &ret, plugins.WithRequestTimeout(shortTimeout)); err != nil {
		return
	}

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyPathRequest struct {
	Name string
}

type volumeDriverProxyPathResponse struct {
	Mountpoint string
	Err        string
}

// Path returns the mountpoint of the given volume.
func (pp *volumeDriverProxy) Path(name string) (mountpoint string, err error) {
	var (
		req volumeDriverProxyPathRequest
		ret volumeDriverProxyPathResponse
	)

	req.Name = name

	if err = pp.CallWithOptions("VolumeDriver.Path", req, &ret, plugins.WithRequestTimeout(shortTimeout)); err != nil {
		return
	}

	mountpoint = ret.Mountpoint

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyMountRequest struct {
	Name string
	ID   string
}

type volumeDriverProxyMountResponse struct {
	Mountpoint string
	Err        string
}

// Mount the given volume and return the mountpoint
func (pp *volumeDriverProxy) Mount(name string, id string) (mountpoint string, err error) {
	var (
		req volumeDriverProxyMountRequest
		ret volumeDriverProxyMountResponse
	)

	req.Name = name
	req.ID = id

	if err = pp.CallWithOptions("VolumeDriver.Mount", req, &ret, plugins.WithRequestTimeout(longTimeout)); err != nil {
		return
	}

	mountpoint = ret.Mountpoint

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyUnmountRequest struct {
	Name string
	ID   string
}

type volumeDriverProxyUnmountResponse struct {
	Err string
}

// Unmount the given volume
func (pp *volumeDriverProxy) Unmount(name string, id string) (err error) {
	var (
		req volumeDriverProxyUnmountRequest
		ret volumeDriverProxyUnmountResponse
	)

	req.Name = name
	req.ID = id

	if err = pp.CallWithOptions("VolumeDriver.Unmount", req, &ret, plugins.WithRequestTimeout(shortTimeout)); err != nil {
		return
	}

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyListRequest struct{}

type volumeDriverProxyListResponse struct {
	Volumes []*proxyVolume
	Err     string
}

// List lists all the volumes known to the driver
func (pp *volumeDriverProxy) List() (volumes []*proxyVolume, err error) {
	var (
		req volumeDriverProxyListRequest
		ret volumeDriverProxyListResponse
	)

	if err = pp.CallWithOptions("VolumeDriver.List", req, &ret, plugins.WithRequestTimeout(shortTimeout)); err != nil {
		return
	}

	volumes = ret.Volumes

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyGetRequest struct {
	Name string
}

type volumeDriverProxyGetResponse struct {
	Volume *proxyVolume
	Err    string
}

// Get retrieves the volume with the requested name
func (pp *volumeDriverProxy) Get(name string) (volume *proxyVolume, err error) {
	var (
		req volumeDriverProxyGetRequest
		ret volumeDriverProxyGetResponse
	)

	req.Name = name

	if err = pp.CallWithOptions("VolumeDriver.Get", req, &ret, plugins.WithRequestTimeout(shortTimeout)); err != nil {
		return
	}

	volume = ret.Volume

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}

type volumeDriverProxyCapabilitiesRequest struct{}

type volumeDriverProxyCapabilitiesResponse struct {
	Capabilities volume.Capability
	Err          string
}

// Capabilities gets the list of capabilities of the driver
func (pp *volumeDriverProxy) Capabilities() (capabilities volume.Capability, err error) {
	var (
		req volumeDriverProxyCapabilitiesRequest
		ret volumeDriverProxyCapabilitiesResponse
	)

	if err = pp.CallWithOptions("VolumeDriver.Capabilities", req, &ret, plugins.WithRequestTimeout(shortTimeout)); err != nil {
		return
	}

	capabilities = ret.Capabilities

	if ret.Err != "" {
		err = errors.New(ret.Err)
	}

	return
}
