/*
 *
 *  Copyright (C) 2000 Silicon Graphics, Inc.  All Rights Reserved. 
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program with
 *  other software, or any other product whatsoever.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA  94043, or:
 * 
 *  http://www.sgi.com 
 * 
 *  For further information regarding this notice, see: 
 * 
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 *
 */

#include <cstdlib>
#include "IfAssert.h"
#include "IfShape.h"
#include "IfSorter.h"

IfSorter	*IfSorter::curSorter;	// Saves "this" during qsort

/////////////////////////////////////////////////////////////////////////////
//
// Constructor.
//
/////////////////////////////////////////////////////////////////////////////

IfSorter::IfSorter()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// Destructor.
//
/////////////////////////////////////////////////////////////////////////////

IfSorter::~IfSorter()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// This sorts the given IfShapeList by various properties. The list is
// sorted in place.
//
/////////////////////////////////////////////////////////////////////////////

void
IfSorter::sort(IfShapeList &shapeList)
{
    curSorter = this;
    curShapeList = &shapeList;

    // Use quicksort. This assumes that the shapeList is a contiguous
    // array of pointers to IfShape instances.
    IfShape **shapes = shapeList.getArray();
    qsort(shapes, shapeList.getLength(), sizeof(IfShape *), compareCB);

    // Once the shapes have been sorted, compare all neighbors to
    // determine the level at which they differ
    shapeList[0]->differenceLevel = 0;
    for (int i = 1; i < shapeList.getLength(); i++)
	IfShape::compare(shapeList[i-1], shapeList[i],
		       shapeList[i]->differenceLevel,
		       shapeList[i]->differenceCode);
}

/////////////////////////////////////////////////////////////////////////////
//
// Compares 2 shapes for qsort.
//
/////////////////////////////////////////////////////////////////////////////

int
IfSorter::compare(const IfShape *shape1, const IfShape *shape2)
{
    int level;
    IfShape::DifferenceCode dCode;
    return IfShape::compare(shape1, shape2, level, dCode);
}
