# Set default applications list for GameMaker games.
# USAGE: applications_list_gamemaker
applications_list_gamemaker() {
	printf '%s\n' \
		'APP_MAIN'
}

# Set default binary name for GameMaker games.
# USAGE: application_exe_gamemaker
application_exe_gamemaker() {
	printf '%s' 'runner'
}

# Set pre-run actions common to GameMaker games.
# This is not overridden by setting APP_xxx_PRERUN from game scripts,
# the value of APP_xxx_PRERUN is appended to this list of actions.
# USAGE: application_prerun_gamemaker
application_prerun_gamemaker() {
	cat <<- EOF
	# Work around a crash on Mesa.
	# cf. https://gitlab.freedesktop.org/mesa/mesa/issues/1310
	export radeonsi_sync_compile=true

	# Work around broken support for non-US locales.
	export LC_NUMERIC=C

	EOF
}

