#!/usr/bin/python3
"""
Test Driver for dh-fortran/main.py

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

from click.testing import CliRunner
import dhfortran.main as main
import dhfortran.debhelper as dh


def test_dh_fortran():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, [])
    assert result.exit_code == 0
    # assert result.output == 'Hello Peter!\n'


def test_dh_fortran_get_fc_default_simple():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_default"])
    assert result.exit_code == 0
    assert result.output == "gfortran-15\n"


def test_dh_fortran_get_fc_default_flang():
    runner = CliRunner()
    runner.env["FC"] = "flang-new-21"
    result = runner.invoke(main.dh_fortran, ["get_fc_default"])
    assert result.exit_code == 0
    assert result.output == "flang-21\n"


def test_dh_fortran_get_fc_flags():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_flags"])
    assert result.exit_code == 0
    assert (
        result.output
        == "-g -O2 -ffile-prefix-map=/home/alastair/git/dh-fortran/dhfortran=. -fstack-protector-strong -fstack-clash-protection -mbranch-protection=standard\n"
    )

def test_dh_fortran_get_fc_flags_flang21():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_flags","--fc","flang-21"])
    assert result.exit_code == 0


def test_dh_fortran_get_bad_fc():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_flags","--fc","garbage"])
    assert result.exit_code == 2
    assert result.output == """Usage: dh-fortran get_fc_flags [OPTIONS]
Try 'dh-fortran get_fc_flags --help' for help.

Error: garbage is not a valid compiler executable
"""

def test_dh_fortran_get_fc_exe():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_exe"])
    assert result.exit_code == 0
    assert result.output == "gfortran-15\n"


def test_dh_fortran_get_fc_exe_env():
    runner = CliRunner()
    runner.env["FC"] = "flang-new-21"
    result = runner.invoke(main.dh_fortran, ["get_fc_exe"])
    assert result.exit_code == 0
    assert result.output == "flang-new-21\n"


def test_dh_fortran_get_fc_exe_param():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_exe", "--flavor", "flang21"])
    assert result.exit_code == 0
    assert result.output == "flang-new-21\n"


def test_dh_fortran_get_fc_exe_param():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["get_fc_exe", "--flavor", "flangX"])
    assert result.exit_code == 2


def test_dh_fortran_clean():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["clean"])
    assert result.exit_code == 0


def test_dh_fortran_configure():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["configure"])
    assert result.exit_code == 0


def test_dh_fortran_build():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["build"])
    assert result.exit_code == 0


def test_dh_fortran_install():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["install"])
    assert result.exit_code == 0


def test_dh_fortran_test():
    runner = CliRunner()
    result = runner.invoke(main.dh_fortran, ["test"])
    assert result.exit_code == 0


if __name__ == "__main__":
    import pytest

    pytest.main()
