//go:build !no_grpc

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.20.1
// source: github.com/containerd/containerd/api/services/mounts/v1/mounts.proto

package mounts

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// MountsClient is the client API for Mounts service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MountsClient interface {
	Activate(ctx context.Context, in *ActivateRequest, opts ...grpc.CallOption) (*ActivateResponse, error)
	Deactivate(ctx context.Context, in *DeactivateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error)
	Update(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error)
	List(ctx context.Context, in *ListRequest, opts ...grpc.CallOption) (Mounts_ListClient, error)
}

type mountsClient struct {
	cc grpc.ClientConnInterface
}

func NewMountsClient(cc grpc.ClientConnInterface) MountsClient {
	return &mountsClient{cc}
}

func (c *mountsClient) Activate(ctx context.Context, in *ActivateRequest, opts ...grpc.CallOption) (*ActivateResponse, error) {
	out := new(ActivateResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.mounts.v1.Mounts/Activate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mountsClient) Deactivate(ctx context.Context, in *DeactivateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/containerd.services.mounts.v1.Mounts/Deactivate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mountsClient) Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error) {
	out := new(InfoResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.mounts.v1.Mounts/Info", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mountsClient) Update(ctx context.Context, in *UpdateRequest, opts ...grpc.CallOption) (*UpdateResponse, error) {
	out := new(UpdateResponse)
	err := c.cc.Invoke(ctx, "/containerd.services.mounts.v1.Mounts/Update", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mountsClient) List(ctx context.Context, in *ListRequest, opts ...grpc.CallOption) (Mounts_ListClient, error) {
	stream, err := c.cc.NewStream(ctx, &Mounts_ServiceDesc.Streams[0], "/containerd.services.mounts.v1.Mounts/List", opts...)
	if err != nil {
		return nil, err
	}
	x := &mountsListClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Mounts_ListClient interface {
	Recv() (*ListMessage, error)
	grpc.ClientStream
}

type mountsListClient struct {
	grpc.ClientStream
}

func (x *mountsListClient) Recv() (*ListMessage, error) {
	m := new(ListMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// MountsServer is the server API for Mounts service.
// All implementations must embed UnimplementedMountsServer
// for forward compatibility
type MountsServer interface {
	Activate(context.Context, *ActivateRequest) (*ActivateResponse, error)
	Deactivate(context.Context, *DeactivateRequest) (*emptypb.Empty, error)
	Info(context.Context, *InfoRequest) (*InfoResponse, error)
	Update(context.Context, *UpdateRequest) (*UpdateResponse, error)
	List(*ListRequest, Mounts_ListServer) error
	mustEmbedUnimplementedMountsServer()
}

// UnimplementedMountsServer must be embedded to have forward compatible implementations.
type UnimplementedMountsServer struct {
}

func (UnimplementedMountsServer) Activate(context.Context, *ActivateRequest) (*ActivateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Activate not implemented")
}
func (UnimplementedMountsServer) Deactivate(context.Context, *DeactivateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deactivate not implemented")
}
func (UnimplementedMountsServer) Info(context.Context, *InfoRequest) (*InfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Info not implemented")
}
func (UnimplementedMountsServer) Update(context.Context, *UpdateRequest) (*UpdateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedMountsServer) List(*ListRequest, Mounts_ListServer) error {
	return status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedMountsServer) mustEmbedUnimplementedMountsServer() {}

// UnsafeMountsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MountsServer will
// result in compilation errors.
type UnsafeMountsServer interface {
	mustEmbedUnimplementedMountsServer()
}

func RegisterMountsServer(s grpc.ServiceRegistrar, srv MountsServer) {
	s.RegisterService(&Mounts_ServiceDesc, srv)
}

func _Mounts_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MountsServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.mounts.v1.Mounts/Activate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MountsServer).Activate(ctx, req.(*ActivateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mounts_Deactivate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeactivateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MountsServer).Deactivate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.mounts.v1.Mounts/Deactivate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MountsServer).Deactivate(ctx, req.(*DeactivateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mounts_Info_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MountsServer).Info(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.mounts.v1.Mounts/Info",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MountsServer).Info(ctx, req.(*InfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mounts_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MountsServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/containerd.services.mounts.v1.Mounts/Update",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MountsServer).Update(ctx, req.(*UpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mounts_List_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(MountsServer).List(m, &mountsListServer{stream})
}

type Mounts_ListServer interface {
	Send(*ListMessage) error
	grpc.ServerStream
}

type mountsListServer struct {
	grpc.ServerStream
}

func (x *mountsListServer) Send(m *ListMessage) error {
	return x.ServerStream.SendMsg(m)
}

// Mounts_ServiceDesc is the grpc.ServiceDesc for Mounts service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Mounts_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "containerd.services.mounts.v1.Mounts",
	HandlerType: (*MountsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Activate",
			Handler:    _Mounts_Activate_Handler,
		},
		{
			MethodName: "Deactivate",
			Handler:    _Mounts_Deactivate_Handler,
		},
		{
			MethodName: "Info",
			Handler:    _Mounts_Info_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Mounts_Update_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "List",
			Handler:       _Mounts_List_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "github.com/containerd/containerd/api/services/mounts/v1/mounts.proto",
}
