/******************************************************************************
 *
 * Module Name: dttemplate.h - ACPI table template definitions
 *
 *****************************************************************************/

/******************************************************************************
 *
 * 1. Copyright Notice
 *
 * Some or all of this work - Copyright (c) 1999 - 2025, Intel Corp.
 * All rights reserved.
 *
 * 2. License
 *
 * 2.1. This is your license from Intel Corp. under its intellectual property
 * rights. You may have additional license terms from the party that provided
 * you this software, covering your right to use that party's intellectual
 * property rights.
 *
 * 2.2. Intel grants, free of charge, to any person ("Licensee") obtaining a
 * copy of the source code appearing in this file ("Covered Code") an
 * irrevocable, perpetual, worldwide license under Intel's copyrights in the
 * base code distributed originally by Intel ("Original Intel Code") to copy,
 * make derivatives, distribute, use and display any portion of the Covered
 * Code in any form, with the right to sublicense such rights; and
 *
 * 2.3. Intel grants Licensee a non-exclusive and non-transferable patent
 * license (with the right to sublicense), under only those claims of Intel
 * patents that are infringed by the Original Intel Code, to make, use, sell,
 * offer to sell, and import the Covered Code and derivative works thereof
 * solely to the minimum extent necessary to exercise the above copyright
 * license, and in no event shall the patent license extend to any additions
 * to or modifications of the Original Intel Code. No other license or right
 * is granted directly or by implication, estoppel or otherwise;
 *
 * The above copyright and patent license is granted only if the following
 * conditions are met:
 *
 * 3. Conditions
 *
 * 3.1. Redistribution of Source with Rights to Further Distribute Source.
 * Redistribution of source code of any substantial portion of the Covered
 * Code or modification with rights to further distribute source must include
 * the above Copyright Notice, the above License, this list of Conditions,
 * and the following Disclaimer and Export Compliance provision. In addition,
 * Licensee must cause all Covered Code to which Licensee contributes to
 * contain a file documenting the changes Licensee made to create that Covered
 * Code and the date of any change. Licensee must include in that file the
 * documentation of any changes made by any predecessor Licensee. Licensee
 * must include a prominent statement that the modification is derived,
 * directly or indirectly, from Original Intel Code.
 *
 * 3.2. Redistribution of Source with no Rights to Further Distribute Source.
 * Redistribution of source code of any substantial portion of the Covered
 * Code or modification without rights to further distribute source must
 * include the following Disclaimer and Export Compliance provision in the
 * documentation and/or other materials provided with distribution. In
 * addition, Licensee may not authorize further sublicense of source of any
 * portion of the Covered Code, and must include terms to the effect that the
 * license from Licensee to its licensee is limited to the intellectual
 * property embodied in the software Licensee provides to its licensee, and
 * not to intellectual property embodied in modifications its licensee may
 * make.
 *
 * 3.3. Redistribution of Executable. Redistribution in executable form of any
 * substantial portion of the Covered Code or modification must reproduce the
 * above Copyright Notice, and the following Disclaimer and Export Compliance
 * provision in the documentation and/or other materials provided with the
 * distribution.
 *
 * 3.4. Intel retains all right, title, and interest in and to the Original
 * Intel Code.
 *
 * 3.5. Neither the name Intel nor any other trademark owned or controlled by
 * Intel shall be used in advertising or otherwise to promote the sale, use or
 * other dealings in products derived from or relating to the Covered Code
 * without prior written authorization from Intel.
 *
 * 4. Disclaimer and Export Compliance
 *
 * 4.1. INTEL MAKES NO WARRANTY OF ANY KIND REGARDING ANY SOFTWARE PROVIDED
 * HERE. ANY SOFTWARE ORIGINATING FROM INTEL OR DERIVED FROM INTEL SOFTWARE
 * IS PROVIDED "AS IS," AND INTEL WILL NOT PROVIDE ANY SUPPORT, ASSISTANCE,
 * INSTALLATION, TRAINING OR OTHER SERVICES. INTEL WILL NOT PROVIDE ANY
 * UPDATES, ENHANCEMENTS OR EXTENSIONS. INTEL SPECIFICALLY DISCLAIMS ANY
 * IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGEMENT AND FITNESS FOR A
 * PARTICULAR PURPOSE.
 *
 * 4.2. IN NO EVENT SHALL INTEL HAVE ANY LIABILITY TO LICENSEE, ITS LICENSEES
 * OR ANY OTHER THIRD PARTY, FOR ANY LOST PROFITS, LOST DATA, LOSS OF USE OR
 * COSTS OF PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, OR FOR ANY INDIRECT,
 * SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS AGREEMENT, UNDER ANY
 * CAUSE OF ACTION OR THEORY OF LIABILITY, AND IRRESPECTIVE OF WHETHER INTEL
 * HAS ADVANCE NOTICE OF THE POSSIBILITY OF SUCH DAMAGES. THESE LIMITATIONS
 * SHALL APPLY NOTWITHSTANDING THE FAILURE OF THE ESSENTIAL PURPOSE OF ANY
 * LIMITED REMEDY.
 *
 * 4.3. Licensee shall not export, either directly or indirectly, any of this
 * software or system incorporating such software without first obtaining any
 * required license or other approval from the U. S. Department of Commerce or
 * any other agency or department of the United States Government. In the
 * event Licensee exports any such software from the United States or
 * re-exports any such software from a foreign destination, Licensee shall
 * ensure that the distribution and export/re-export of the software is in
 * compliance with all laws, regulations, orders, or other restrictions of the
 * U.S. Export Administration Regulations. Licensee agrees that neither it nor
 * any of its subsidiaries will export/re-export any technical data, process,
 * software, or service, directly or indirectly, to any country for which the
 * United States government or any agency thereof requires an export license,
 * other governmental approval, or letter of assurance, without first obtaining
 * such license, approval or letter.
 *
 *****************************************************************************
 *
 * Alternatively, you may choose to be licensed under the terms of the
 * following license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Alternatively, you may choose to be licensed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 *****************************************************************************/

#ifndef __DTTEMPLATE_H
#define __DTTEMPLATE_H


/* Templates for ACPI data tables */

const unsigned char TemplateAest[] =
{
    0x41,0x45,0x53,0x54,0x90,0x03,0x00,0x00,  /* 00000000    "AEST...." */
    0x02,0xE6,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x06,0x23,0x20,0x00,0xA0,0x00,0x00,  /* 00000020    "(.# ...." */
    0x2C,0x00,0x00,0x00,0x44,0x00,0x00,0x00,  /* 00000028    ",...D..." */
    0x94,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000038    "....gE#." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0xCD,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000058    "....gE#." */
    0x33,0x33,0x22,0x22,0x00,0x00,0x00,0x00,  /* 00000060    "33""...." */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000068    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000070    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000078    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x01,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x78,  /* 00000098    ".......x" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000a0    "....gE#." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000a8    "....gE#." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000b0    "....gE#." */
    0x01,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x78,  /* 000000b8    ".......x" */
    0x00,0x00,0x00,0x00,0x00,0x94,0x00,0x00,  /* 000000c0    "........" */
    0x2C,0x00,0x00,0x00,0x44,0x00,0x00,0x00,  /* 000000c8    ",...D..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d0    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000d8    "....gE#." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000e0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000e8    "........" */
    0x11,0x11,0x00,0x00,0x01,0x00,0x01,0x00,  /* 000000f0    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000000f8    "....gE#." */
    0x67,0x67,0x67,0x67,0x00,0x00,0x00,0x00,  /* 00000100    "gggg...." */
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000108    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000110    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000118    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x01,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x78,  /* 00000138    ".......x" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000140    "....gE#." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000148    "....gE#." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000150    "....gE#." */
    0x01,0x80,0x00,0x00,0x2C,0x00,0x00,0x00,  /* 00000158    "....,..." */
    0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "0......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000170    "........" */
    0x00,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 00000178    "........" */
    0x67,0x45,0x23,0x01,0xAA,0xAA,0x00,0x00,  /* 00000180    "gE#....." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000188    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000190    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000198    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001a0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001a8    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 000001b0    "........" */
    0x01,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x78,  /* 000001b8    ".......x" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000001c0    "....gE#." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 000001c8    "....gE#." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001d0    "........" */
    0x02,0x84,0x00,0x00,0x2C,0x00,0x00,0x00,  /* 000001d8    "....,..." */
    0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001e0    "4......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001e8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001f0    "........" */
    0x00,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 000001f8    "........" */
    0x67,0x45,0x23,0x01,0x55,0x55,0x55,0x55,  /* 00000200    "gE#.UUUU" */
    0x66,0x66,0x66,0x66,0x01,0x00,0x00,0x00,  /* 00000208    "ffff...." */
    0x03,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 00000210    "........" */
    0x67,0x45,0x23,0x01,0x00,0x00,0x00,0x00,  /* 00000218    "gE#....." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x01,  /* 00000230    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000238    "........" */
    0xEF,0xCD,0xAB,0x78,0xEF,0xCD,0xAB,0x89,  /* 00000240    "...x...." */
    0x67,0x45,0x23,0x01,0xEF,0xCD,0xAB,0x89,  /* 00000248    "gE#....." */
    0x67,0x45,0x23,0x01,0xEF,0xCD,0xAB,0x89,  /* 00000250    "gE#....." */
    0x67,0x45,0x23,0x01,0x03,0x98,0x00,0x00,  /* 00000258    "gE#....." */
    0x2C,0x00,0x00,0x00,0x48,0x00,0x00,0x00,  /* 00000260    ",...H..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000268    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000270    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000278    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000280    "....gE#." */
    0x33,0x33,0x33,0x33,0x22,0x22,0x22,0x22,  /* 00000288    "3333""""" */
    0x44,0x44,0x44,0x44,0x12,0x23,0x34,0x45,  /* 00000290    "DDDD.#4E" */
    0x56,0x67,0x78,0x89,0x9A,0xAB,0xBC,0xCD,  /* 00000298    "Vgx....." */
    0xDE,0xEF,0xFF,0x55,0x01,0x00,0x00,0x00,  /* 000002a0    "...U...." */
    0x02,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x89,  /* 000002a8    "........" */
    0x67,0x45,0x23,0x01,0x00,0x00,0x00,0x00,  /* 000002b0    "gE#....." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000002b8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000002c0    "........" */
    0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x01,  /* 000002c8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000002d0    "........" */
    0xEF,0xCD,0xAB,0x78,0xEF,0xCD,0xAB,0x89,  /* 000002d8    "...x...." */
    0x67,0x45,0x23,0x01,0xEF,0xCD,0xAB,0x89,  /* 000002e0    "gE#....." */
    0x67,0x45,0x23,0x01,0xEF,0xCD,0xAB,0x89,  /* 000002e8    "gE#....." */
    0x67,0x45,0x23,0x01,0x04,0x9C,0x00,0x00,  /* 000002f0    "gE#....." */
    0x2C,0x00,0x00,0x00,0x34,0x00,0x00,0x00,  /* 000002f8    ",...4..." */
    0x84,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000300    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000308    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000310    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000318    "....gE#." */
    0x03,0x00,0x00,0x00,0x88,0x88,0x77,0x77,  /* 00000320    "......ww" */
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000328    "........" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000330    "....gE#." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000338    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000340    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000348    "........" */
    0x11,0x11,0x11,0x01,0x00,0x00,0x00,0x00,  /* 00000350    "........" */
    0x01,0x00,0x00,0x00,0xEF,0xCD,0xAB,0x78,  /* 00000358    ".......x" */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000360    "....gE#." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000368    "....gE#." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000370    "........" */
    0x00,0x00,0x00,0x00,0xBB,0xBB,0xAA,0xAA,  /* 00000378    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,  /* 00000380    "........" */
    0xEF,0xCD,0xAB,0x78,0x00,0x00,0x00,0x00,  /* 00000388    "...x...." */
};

const unsigned char TemplateAgdi[] =
{
    0x41,0x47,0x44,0x49,0x30,0x00,0x00,0x00,  /* 00000000    "AGDI0..." */
    0x01,0xE4,0x41,0x4D,0x50,0x45,0x52,0x45,  /* 00000008    "..AMPERE" */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "..! ...." */
    0x01,0x00,0x00,0x40,0x00,0x00,0x00,0x00   /* 00000028    "...@...." */
};

const unsigned char TemplateApmt[] =
{
    0x41,0x50,0x4D,0x54,0x94,0x00,0x00,0x00,  /* 00000000    "APMT...." */
    0x00,0x79,0x4E,0x56,0x49,0x44,0x49,0x41,  /* 00000008    ".yNVIDIA" */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x38,0x00,0x04,0x03,  /* 00000020    "..! 8..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    ". ......" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    ". ......" */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x6B,0x03,0x00,0x00,0x38,0x00,0x06,0x03,  /* 00000058    "k...8..." */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    ".0......" */
    0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    ".0......" */
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000088    "........" */
    0x6B,0x03,0x00,0x00                       /* 00000090    "k..."     */
};

const unsigned char TemplateAsf[] =
{
    0x41,0x53,0x46,0x21,0x72,0x00,0x00,0x00,  /* 00000000    "ASF!r..." */
    0x10,0x0B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x10,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x14,0x00,  /* 00000030    "........" */
    0x00,0x00,0x01,0x0C,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x02,0x00,0x0C,0x00,0x01,0x04,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x03,0x00,0x17,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x84,0x00,0x07,0x00,0x00,  /* 00000068    "........" */
    0x01,0x00                                 /* 00000070    ".."       */
};

const unsigned char TemplateAspt[] =
{
    0x41,0x53,0x50,0x54,0x88,0x00,0x00,0x00,  /* 00000000    "ASPT...." */
    0x01,0x2D,0x56,0x52,0x54,0x55,0x41,0x4C,  /* 00000008    "..VRTUAL" */
    0x4D,0x49,0x43,0x52,0x4F,0x53,0x46,0x54,  /* 00000010    "MICROSFT" */
    0x01,0x00,0x00,0x00,0x4D,0x53,0x46,0x54,  /* 00000018    "....INTL" */
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000020    " ." ...." */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000028    ".. ....." */
    0x00,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x04,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x08,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x01,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000048    ".. ....." */
    0x10,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x14,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x18,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x02,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000068    ".. ....." */
    0x20,0x00,0xB0,0xFE,0x00,0x00,0x00,0x00,  /* 00000070    " ......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
};

const unsigned char TemplateBdat[] =
{
    0x42,0x44,0x41,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "BDAT0..." */
    0x01,0xED,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x01,0x08,0x00,0x01,  /* 00000020    "1.! ...." */
    0xF0,0xDE,0xBC,0x9A,0x78,0x56,0x34,0x12   /* 00000028    "....xV4." */
};

const unsigned char TemplateBgrt[] =
{
    0x42,0x47,0x52,0x54,0x38,0x00,0x00,0x00,  /* 00000000    "BGRT8..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x23,0x06,0x11,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "#.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateBert[] =
{
    0x42,0x45,0x52,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "BERT0..." */
    0x01,0x15,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateBoot[] =
{
    0x42,0x4F,0x4F,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "BOOT(..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x04,0x06,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00   /* 00000020    "(.. ...." */
};

const unsigned char TemplateCcel[] =
{
    0x43,0x43,0x45,0x4C,0x38,0x00,0x00,0x00,  /* 00000000    "CCEL8..." */
    0x04,0x2E,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x21,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "0.! ...." */
    0xEF,0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,  /* 00000028    "...xV4.." */
    0x78,0x56,0x34,0x12,0xEF,0xCD,0xAB,0x00   /* 00000030    "xV4....." */
};

const unsigned char TemplateCedt[] =
{
    0x43,0x45,0x44,0x54,0x9c,0x01,0x00,0x00,  /* 00000000    "CEDT...." */
    0x01,0x87,0x49,0x4e,0x54,0x45,0x4c,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4d,0x50,0x4c,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4e,0x54,0x4c,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x00,0x00,0x20,0x00,  /* 00000020    "..! .. ." */
    0x00,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000028    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000038    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,  /* 00000040    "...... ." */
    0x01,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000050    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000058    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,  /* 00000060    "...... ." */
    0x02,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000068    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,  /* 00000070    ".....0.." */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000078    "..... .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,  /* 00000080    "...... ." */
    0x03,0x5e,0xba,0x00,0x00,0x00,0x00,0x00,  /* 00000088    ".^......" */
    0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,  /* 00000098    "..... .." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x28,0x00,  /* 000000a0    "......(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000a8    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000b0    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000b8    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 000000c0    "........" */
    0x00,0x5e,0xba,0x00,0x01,0x00,0x28,0x00,  /* 000000c8    ".^....(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d0    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d8    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000e0    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 000000e8    "........" */
    0x01,0x5e,0xba,0x00,0x01,0x00,0x28,0x00,  /* 000000f0    ".^....(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000f8    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 00000110    "........" */
    0x02,0x5e,0xba,0x00,0x01,0x00,0x28,0x00,  /* 00000118    ".^....(." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 00000138    "........" */
    0x03,0x5e,0xba,0x00,0x01,0x00,0x2c,0x00,  /* 00000140    ".^....,." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000158    "........" */
    0x03,0x00,0x00,0x00,0x06,0x00,0x01,0x00,  /* 00000160    "........" */
    0x00,0x5e,0xba,0x00,0x01,0x5e,0xba,0x00,  /* 00000160    ".^...^.." */
    0x01,0x00,0x2c,0x00,0x00,0x00,0x00,0x00,  /* 00000170    "..,....." */
    0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,  /* 00000180    "........" */
    0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000188    "........" */
    0x0a,0x00,0x01,0x00,0x02,0x5e,0xba,0x00,  /* 00000190    ".....^.." */
    0x03,0x5e,0xba,0x00                       /* 00000198    ".^.."     */
};

const unsigned char TemplateCdat[] =
{
    0xE4,0x00,0x00,0x00,0x01,0x0C,0x00,0x00,  /* 00000000    "........" */
    0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,  /* 00000008    "........" */
    0x03,0x00,0x08,0x00,0x04,0x56,0x00,0x00,  /* 00000010    ".....V.." */
    0x00,0x00,0x18,0x00,0xEF,0x01,0x00,0x00,  /* 00000018    "........" */
    0x89,0x67,0x45,0x23,0x01,0x00,0x00,0x00,  /* 00000020    ".gE#...." */
    0xAB,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x03,0x00,0x08,0x00,0x04,0x56,0x00,0x00,  /* 00000030    ".....V.." */
    0x01,0x00,0x18,0x00,0x44,0x04,0x64,0x00,  /* 00000038    "....D.d." */
    0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,0x00,  /* 00000040    "...gE#.." */
    0x33,0x22,0x44,0x33,0x55,0x44,0x00,0x00,  /* 00000048    "3"D3UD.." */
    0x02,0x00,0x14,0x00,0x99,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x78,0x56,0x34,0x12,  /* 00000058    "....xV4." */
    0x55,0x55,0x44,0x44,0x04,0x00,0x18,0x00,  /* 00000060    "UUDD...." */
    0x88,0x32,0x00,0x00,0x77,0x77,0x77,0x77,  /* 00000068    ".2..wwww" */
    0x11,0x11,0x11,0x11,0x88,0x88,0x88,0x88,  /* 00000070    "........" */
    0x22,0x22,0x22,0x22,0x05,0x00,0x20,0x00,  /* 00000078    """"".. ." */
    0x04,0x00,0x00,0x00,0x44,0x44,0x44,0x44,  /* 00000080    "....DDDD" */
    0x33,0x33,0x33,0x33,0x44,0x44,0x55,0x55,  /* 00000088    "3333DDUU" */
    0x66,0x66,0x00,0x00,0x77,0x77,0x88,0x88,  /* 00000090    "ff..ww.." */
    0x99,0x99,0x00,0x00,0x05,0x00,0x18,0x00,  /* 00000098    "........" */
    0x04,0x00,0x00,0x00,0x22,0x22,0x22,0x22,  /* 000000A0    "....""""" */
    0x11,0x11,0x11,0x11,0x34,0x12,0x56,0x78,  /* 000000A8    "....4.Vx" */
    0x11,0x11,0x00,0x00,0x05,0x00,0x30,0x00,  /* 000000B0    "......0." */
    0x08,0x00,0x00,0x00,0x66,0x66,0x66,0x66,  /* 000000B8    "....ffff" */
    0x55,0x55,0x55,0x55,0x44,0x44,0x55,0x55,  /* 000000C0    "UUUUDDUU" */
    0x66,0x66,0x00,0x00,0x77,0x77,0x88,0x88,  /* 000000C8    "ff..ww.." */
    0x99,0x99,0x00,0x00,0xAA,0xAA,0xBB,0xBB,  /* 000000D0    "........" */
    0xCC,0xCC,0x00,0x00,0x55,0x55,0x44,0x44,  /* 000000D8    "....UUDD" */
    0x33,0x33,0x00,0x00                       /* 000000E0    "33.."     */
};

const unsigned char TemplateCpep[] =
{
    0x43,0x50,0x45,0x50,0x34,0x00,0x00,0x00,  /* 00000000    "CPEP4..." */
    0x01,0x0F,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateCsrt[] =
{
    0x43,0x53,0x52,0x54,0x4C,0x01,0x00,0x00,  /* 00000000    "CSRTL..." */
    0x01,0x0D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x14,0x11,0x12,0x20,0x88,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x49,0x4E,0x54,0x4C,0x00,0x00,0x00,0x00,  /* 00000028    "INTL...." */
    0x60,0x9C,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000030    "`......." */
    0x1C,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0xA0,0xB3,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x2A,0x00,0x00,0x00,0x02,0x00,0x06,0x20,  /* 00000048    "*...... " */
    0x00,0x00,0x10,0x00,0xFF,0x0F,0x00,0x00,  /* 00000050    "........" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x01,0x00,  /* 00000058    "........" */
    0x53,0x50,0x49,0x20,0x0C,0x00,0x00,0x00,  /* 00000060    "SPI ...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x30,  /* 00000068    "....CHA0" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000070    "........" */
    0x43,0x48,0x41,0x31,0x0C,0x00,0x00,0x00,  /* 00000078    "CHA1...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x32,  /* 00000080    "....CHA2" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000088    "........" */
    0x43,0x48,0x41,0x33,0x0C,0x00,0x00,0x00,  /* 00000090    "CHA3...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x34,  /* 00000098    "....CHA4" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x43,0x48,0x41,0x35,0xA0,0x00,0x00,0x00,  /* 000000A8    "CHA5...." */
    0x49,0x4E,0x54,0x4C,0x00,0x00,0x00,0x00,  /* 000000B0    "INTL...." */
    0x60,0x9C,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000B8    "`......." */
    0x1C,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x2B,0x00,0x00,0x00,0x02,0x00,0x08,0x20,  /* 000000D0    "+...... " */
    0x10,0x00,0x10,0x00,0xFF,0x0F,0x00,0x00,  /* 000000D8    "........" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x01,0x00,  /* 000000E0    "........" */
    0x49,0x32,0x43,0x20,0x0C,0x00,0x00,0x00,  /* 000000E8    "I2C ...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x30,  /* 000000F0    "....CHA0" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x43,0x48,0x41,0x31,0x0C,0x00,0x00,0x00,  /* 00000100    "CHA1...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x32,  /* 00000108    "....CHA2" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000110    "........" */
    0x43,0x48,0x41,0x33,0x0C,0x00,0x00,0x00,  /* 00000118    "CHA3...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x34,  /* 00000120    "....CHA4" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000128    "........" */
    0x43,0x48,0x41,0x35,0x0C,0x00,0x00,0x00,  /* 00000130    "CHA5...." */
    0x03,0x00,0x00,0x00,0x43,0x48,0x41,0x36,  /* 00000138    "....CHA6" */
    0x0C,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 00000140    "........" */
    0x43,0x48,0x41,0x37                       /* 00000148    "CHA7"     */
};

const unsigned char TemplateDbg2[] =
{
    0x44,0x42,0x47,0x32,0xB2,0x00,0x00,0x00,  /* 00000000    "DBG2...." */
    0x01,0xBA,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x15,0x11,0x13,0x20,0x2C,0x00,0x00,0x00,  /* 00000020    "... ,..." */
    0x02,0x00,0x00,0x00,0xEE,0x3F,0x00,0x02,  /* 00000028    ".....?.." */
    0x09,0x00,0x36,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "..6....." */
    0x00,0x80,0x00,0x00,0x00,0x00,0x16,0x00,  /* 00000038    "........" */
    0x2E,0x00,0x01,0x32,0x00,0x03,0x88,0x77,  /* 00000040    "...2...w" */
    0x66,0x55,0x44,0x33,0x22,0x11,0x01,0x64,  /* 00000048    "fUD3"..d" */
    0x00,0x04,0x11,0x00,0xFF,0xEE,0xDD,0xCC,  /* 00000050    "........" */
    0xBB,0xAA,0x10,0x32,0x54,0x76,0x98,0xBA,  /* 00000058    "...2Tv.." */
    0xDC,0xFE,0x4D,0x79,0x44,0x65,0x76,0x69,  /* 00000060    "..MyDevi" */
    0x63,0x65,0x00,0xEE,0x47,0x00,0x01,0x11,  /* 00000068    "ce..G..." */
    0x00,0x26,0x00,0x10,0x00,0x37,0x00,0x00,  /* 00000070    ".&...7.." */
    0x80,0x00,0x00,0x00,0x00,0x16,0x00,0x22,  /* 00000078    "......."" */
    0x00,0x01,0x64,0x00,0x04,0x11,0x00,0xFF,  /* 00000080    "..d....." */
    0xEE,0xDD,0xCC,0xBB,0xAA,0x98,0xBA,0xDC,  /* 00000088    "........" */
    0xFE,0x5C,0x5C,0x5F,0x53,0x42,0x5F,0x2E,  /* 00000090    ".\\_SB_." */
    0x50,0x43,0x49,0x30,0x2E,0x44,0x42,0x47,  /* 00000098    "PCI0.DBG" */
    0x50,0x00,0x41,0x42,0x43,0x44,0x45,0x46,  /* 000000A0    "P.ABCDEF" */
    0x47,0x48,0x49,0x50,0x51,0x52,0x53,0x54,  /* 000000A8    "GHIPQRST" */
    0x55,0x56                                 /* 000000B0    "UV"       */
};

const unsigned char TemplateDbgp[] =
{
    0x44,0x42,0x47,0x50,0x34,0x00,0x00,0x00,  /* 00000000    "DBGP4..." */
    0x01,0x1A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateDmar[] =
{
    0x44,0x4D,0x41,0x52,0xAC,0x00,0x00,0x00,  /* 00000000    "DMAR...." */
    0x01,0x87,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x2F,0x01,0x00,0x00,  /* 00000020    "..! /..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x18,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x03,0x08,0x00,0x00,0x08,0x00,0x00,0x01,  /* 00000040    "........" */
    0x01,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0xFF,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x02,  /* 00000060    "........" */
    0x02,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x02,0x08,0x00,0x00,0x00,0x00,0x00,0x03,  /* 00000070    "........" */
    0x03,0x00,0x14,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x05,0x00,0x10,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x02,0x06,0x00,0x10,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x02                       /* 000000A8    "...."     */
};

const unsigned char TemplateDrtm[] =
{
    0x44,0x52,0x54,0x4D,0x94,0x00,0x00,0x00,  /* 00000000    "DRTM...." */
    0x01,0xB9,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00                       /* 00000090    "...."     */
};

const unsigned char TemplateEcdt[] =
{
    0x45,0x43,0x44,0x54,0x42,0x00,0x00,0x00,  /* 00000000    "ECDTB..." */
    0x01,0x2D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".-INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x08,0x00,0x00,  /* 00000020    "(.. ...." */
    0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "f......." */
    0x01,0x08,0x00,0x00,0x62,0x00,0x00,0x00,  /* 00000030    "....b..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x09,0x00                                 /* 00000040    ".."       */
};

const unsigned char TemplateEinj[] =
{
    0x45,0x49,0x4E,0x4A,0x30,0x01,0x00,0x00,  /* 00000000    "EINJ0..." */
    0x01,0x09,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x30,0x00,0x00,0x00,  /* 00000020    "(.. 0..." */
    0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000030    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000050    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000068    "........" */
    0x02,0x02,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000070    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000088    "........" */
    0x03,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000A8    "........" */
    0x04,0x03,0x01,0x00,0x00,0x40,0x00,0x04,  /* 000000B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000C8    "........" */
    0x05,0x03,0x01,0x00,0x01,0x10,0x00,0x02,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000E8    "........" */
    0x06,0x01,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000108    "........" */
    0x07,0x00,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000110    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF   /* 00000128    "........" */
};

const unsigned char TemplateErdt[] =
{
    0x45,0x52,0x44,0x54,0x44,0x06,0x00,0x00,  /* 00000000    "ERDTD..." */
    0x01,0x78,0x49,0x4e,0x54,0x45,0x4c,0x00,  /* 00000008    ".xINTEL." */
    0x49,0x4e,0x54,0x45,0x4c,0x20,0x49,0x44,  /* 00000010    "INTEL ID" */
    0x02,0x00,0x00,0x00,0x49,0x4e,0x54,0x4c,  /* 00000018    "....INTL" */
    0x28,0x06,0x23,0x20,0x0f,0x00,0x00,0x00,  /* 00000020    "(.# ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0xd2,0x00,0x01,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x0f,0x01,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0xfc,0xf7,0xff,0x1f,0x00,0x00,  /* 00000058    "........" */
    0x01,0x00,0x01,0x00,0x18,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,  /* 00000068    "........" */
    0x00,0x00,0x08,0x00,0x00,0x00,0x0a,0x00,  /* 00000070    "........" */
    0x00,0x00,0x03,0x00,0x30,0x00,0x00,0x00,  /* 00000078    "....0..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x10,0xfb,0xf7,0xff,0x1f,  /* 00000090    "........" */
    0x00,0x00,0x04,0x00,0x00,0x00,0x08,0x00,  /* 00000098    "........" */
    0x00,0x02,0x00,0x10,0x01,0x00,0x00,0x00,  /* 000000a0    "........" */
    0x00,0x00,0x04,0x00,0x38,0x00,0x00,0x00,  /* 000000a8    "....8..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 000000b0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000b8    "........" */
    0x00,0x00,0x00,0x80,0xfc,0xf7,0xff,0x1f,  /* 000000c0    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x18,0x00,  /* 000000c8    "........" */
    0x10,0x01,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000d8    "........" */
    0x00,0x00,0x05,0x00,0x30,0x00,0x00,0x00,  /* 000000e0    "....0..." */
    0x07,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000e8    "........" */
    0x00,0x00,0x00,0x10,0xfc,0xf7,0xff,0x1f,  /* 000000f0    "........" */
    0x00,0x00,0x00,0x30,0xfc,0xf7,0xff,0x1f,  /* 000000f8    "...0...." */
    0x00,0x00,0x00,0x20,0xfc,0xf7,0xff,0x1f,  /* 00000100    "... ...." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x08,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0xd2,0x00,0x01,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x0f,0x01,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0xec,0xf7,0xff,0x1f,  /* 00000128    "........" */
    0x00,0x00,0x01,0x00,0x01,0x00,0x18,0x00,  /* 00000130    "........" */
    0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,  /* 00000138    "........" */
    0x02,0x01,0x00,0x00,0x08,0x01,0x00,0x00,  /* 00000140    "........" */
    0x0a,0x01,0x00,0x00,0x03,0x00,0x30,0x00,  /* 00000148    "......0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x10,0xeb,0xf7,  /* 00000160    "........" */
    0xff,0x1f,0x00,0x00,0x04,0x00,0x00,0x00,  /* 00000168    "........" */
    0x08,0x00,0x00,0x02,0x00,0x10,0x01,0x00,  /* 00000170    "........" */
    0x00,0x00,0x00,0x00,0x04,0x00,0x38,0x00,  /* 00000178    "......8." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x00,0x00,0x00,0x00,0x80,0xec,0xf7,  /* 00000190    "........" */
    0xff,0x1f,0x00,0x00,0x10,0x00,0x00,0x00,  /* 00000198    "........" */
    0x18,0x00,0x10,0x01,0x00,0x00,0x00,0x00,  /* 000001a0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001a8    "........" */
    0x00,0x00,0x00,0x00,0x05,0x00,0x30,0x00,  /* 000001b0    "......0." */
    0x00,0x00,0x07,0x00,0x01,0x00,0x00,0x00,  /* 000001b8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x10,0xec,0xf7,  /* 000001c0    "........" */
    0xff,0x1f,0x00,0x00,0x00,0x30,0xec,0xf7,  /* 000001c8    ".....0.." */
    0xff,0x1f,0x00,0x00,0x00,0x20,0xec,0xf7,  /* 000001d0    "..... .." */
    0xff,0x1f,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000001d8    "........" */
    0x08,0x00,0x00,0x00,0x00,0x00,0xd2,0x00,  /* 000001e0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001e8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,  /* 000001f0    "........" */
    0x0f,0x01,0x00,0x00,0x00,0x00,0xdc,0xf7,  /* 000001f8    "........" */
    0xff,0x1f,0x00,0x00,0x01,0x00,0x01,0x00,  /* 00000200    "........" */
    0x18,0x00,0x00,0x00,0x02,0x00,0x00,0x02,  /* 00000208    "........" */
    0x00,0x00,0x02,0x02,0x00,0x00,0x08,0x02,  /* 00000210    "........" */
    0x00,0x00,0x0a,0x02,0x00,0x00,0x03,0x00,  /* 00000218    "........" */
    0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "0......." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,  /* 00000230    "........" */
    0xdb,0xf7,0xff,0x1f,0x00,0x00,0x04,0x00,  /* 00000238    "........" */
    0x00,0x00,0x08,0x00,0x00,0x02,0x00,0x10,  /* 00000240    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x04,0x00,  /* 00000248    "........" */
    0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "8......." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,  /* 00000260    "........" */
    0xdc,0xf7,0xff,0x1f,0x00,0x00,0x10,0x00,  /* 00000268    "........" */
    0x00,0x00,0x18,0x00,0x10,0x01,0x00,0x00,  /* 00000270    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000278    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,  /* 00000280    "........" */
    0x30,0x00,0x00,0x00,0x07,0x00,0x01,0x00,  /* 00000288    "0......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,  /* 00000290    "........" */
    0xdc,0xf7,0xff,0x1f,0x00,0x00,0x00,0x30,  /* 00000298    ".......0" */
    0xdc,0xf7,0xff,0x1f,0x00,0x00,0x00,0x20,  /* 000002a0    "....... " */
    0xdc,0xf7,0xff,0x1f,0x00,0x00,0x01,0x00,  /* 000002a8    "........" */
    0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,  /* 000002b0    "........" */
    0xd2,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000002b8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000002c0    "........" */
    0x03,0x00,0x0f,0x01,0x00,0x00,0x00,0x00,  /* 000002c8    "........" */
    0xcc,0xf7,0xff,0x1f,0x00,0x00,0x01,0x00,  /* 000002d0    "........" */
    0x01,0x00,0x18,0x00,0x00,0x00,0x03,0x00,  /* 000002d8    "........" */
    0x00,0x03,0x00,0x00,0x02,0x03,0x00,0x00,  /* 000002e0    "........" */
    0x08,0x03,0x00,0x00,0x0a,0x03,0x00,0x00,  /* 000002e8    "........" */
    0x03,0x00,0x30,0x00,0x00,0x00,0x00,0x00,  /* 000002f0    "..0....." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000002f8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000300    "........" */
    0x00,0x10,0xcb,0xf7,0xff,0x1f,0x00,0x00,  /* 00000308    "........" */
    0x04,0x00,0x00,0x00,0x08,0x00,0x00,0x02,  /* 00000310    "........" */
    0x00,0x10,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000318    "........" */
    0x04,0x00,0x38,0x00,0x00,0x00,0x00,0x00,  /* 00000320    "..8....." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000328    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000330    "........" */
    0x00,0x80,0xcc,0xf7,0xff,0x1f,0x00,0x00,  /* 00000338    "........" */
    0x10,0x00,0x00,0x00,0x18,0x00,0x10,0x01,  /* 00000340    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000348    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000350    "........" */
    0x05,0x00,0x30,0x00,0x00,0x00,0x07,0x00,  /* 00000358    "..0....." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000360    "........" */
    0x00,0x10,0xcc,0xf7,0xff,0x1f,0x00,0x00,  /* 00000368    "........" */
    0x00,0x30,0xcc,0xf7,0xff,0x1f,0x00,0x00,  /* 00000370    ".0......" */
    0x00,0x20,0xcc,0xf7,0xff,0x1f,0x00,0x00,  /* 00000378    ". ......" */
    0x01,0x00,0x00,0x00,0x08,0x00,0x00,0x00,  /* 00000380    "........" */
    0x00,0x00,0x92,0x01,0x02,0x00,0x10,0x00,  /* 00000388    "........" */
    0x0b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000390    "........" */
    0x00,0x00,0x10,0x00,0x7f,0x00,0x00,0x00,  /* 00000398    "........" */
    0x00,0xb0,0xb8,0xf6,0xff,0x1f,0x00,0x00,  /* 000003a0    "........" */
    0x01,0x00,0x02,0x00,0xd8,0x00,0x00,0x00,  /* 000003a8    "........" */
    0x10,0x00,0x01,0x08,0x00,0x00,0x00,0x00,  /* 000003b0    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x00,  /* 000003b8    "........" */
    0x00,0x04,0x01,0x08,0x00,0x00,0x00,0x00,  /* 000003c0    "........" */
    0x02,0x00,0x01,0x08,0x00,0x00,0x00,0x00,  /* 000003c8    "........" */
    0x02,0x01,0x01,0x08,0x00,0x00,0x00,0x00,  /* 000003d0    "........" */
    0x03,0x00,0x02,0x08,0x00,0x00,0x00,0x00,  /* 000003d8    "........" */
    0x04,0x00,0x01,0x0a,0x00,0x00,0x00,0x00,  /* 000003e0    "........" */
    0x04,0x00,0x00,0x00,0x02,0x08,0x00,0x00,  /* 000003e8    "........" */
    0x00,0x00,0x05,0x00,0x01,0x0a,0x00,0x00,  /* 000003f0    "........" */
    0x00,0x00,0x05,0x00,0x00,0x00,0x02,0x08,  /* 000003f8    "........" */
    0x00,0x00,0x00,0x00,0x06,0x00,0x01,0x0a,  /* 00000400    "........" */
    0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,  /* 00000408    "........" */
    0x02,0x08,0x00,0x00,0x00,0x00,0x07,0x00,  /* 00000410    "........" */
    0x01,0x0a,0x00,0x00,0x00,0x00,0x07,0x00,  /* 00000418    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x00,  /* 00000420    "........" */
    0x1f,0x00,0x01,0x08,0x00,0x00,0x00,0x00,  /* 00000428    "........" */
    0x1f,0x04,0x01,0x08,0x00,0x00,0x00,0x00,  /* 00000430    "........" */
    0x1f,0x05,0x01,0x08,0x00,0x00,0x00,0x0d,  /* 00000438    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x0e,  /* 00000440    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x0f,  /* 00000448    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x10,  /* 00000450    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x10,  /* 00000458    "........" */
    0x00,0x04,0x01,0x08,0x00,0x00,0x00,0x60,  /* 00000460    ".......`" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0x60,  /* 00000468    ".......`" */
    0x00,0x04,0x01,0x08,0x00,0x00,0x00,0xb0,  /* 00000470    "........" */
    0x00,0x00,0x01,0x08,0x00,0x00,0x00,0xb0,  /* 00000478    "........" */
    0x00,0x04,0x07,0x00,0x30,0x00,0x00,0x00,  /* 00000480    "....0..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000488    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000490    "........" */
    0x00,0x00,0x00,0xb0,0xb8,0xf6,0xff,0x1f,  /* 00000498    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x05,  /* 000004a0    "........" */
    0x08,0x00,0xf8,0xff,0x07,0x00,0x00,0x00,  /* 000004a8    "........" */
    0x00,0x00,0x08,0x00,0x40,0x00,0x00,0x00,  /* 000004b0    "....@..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 000004b8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000004c0    "........" */
    0x00,0x00,0x00,0xb0,0xb8,0xf6,0xff,0x1f,  /* 000004c8    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x03,  /* 000004d0    "........" */
    0x00,0x04,0x08,0x00,0x08,0x00,0x00,0x00,  /* 000004d8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x28,0xf8,0xff,  /* 000004e0    ".....(.." */
    0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000004e8    "........" */
    0x00,0x00,0x0a,0x00,0x28,0x00,0x00,0x00,  /* 000004f0    "....(..." */
    0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,  /* 000004f8    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000500    "........" */
    0x00,0x00,0x00,0xb0,0xb8,0xf6,0xff,0x1f,  /* 00000508    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x02,  /* 00000510    "........" */
    0x10,0x00,0x00,0x00,0x2a,0x01,0x02,0x00,  /* 00000518    "....*..." */
    0x10,0x00,0x0b,0x08,0x00,0x00,0x00,0x00,  /* 00000520    "........" */
    0x00,0x00,0x00,0x00,0x11,0x00,0x7f,0x00,  /* 00000528    "........" */
    0x00,0x00,0x00,0xb0,0x38,0xf6,0xff,0x1f,  /* 00000530    "....8..." */
    0x00,0x00,0x01,0x00,0x02,0x00,0x70,0x00,  /* 00000538    "......p." */
    0x00,0x00,0x11,0x00,0x01,0x08,0x01,0x00,  /* 00000540    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x01,0x00,  /* 00000548    "........" */
    0x00,0x00,0x00,0x04,0x01,0x08,0x01,0x00,  /* 00000550    "........" */
    0x00,0x00,0x02,0x00,0x01,0x08,0x01,0x00,  /* 00000558    "........" */
    0x00,0x00,0x02,0x01,0x01,0x08,0x01,0x00,  /* 00000560    "........" */
    0x00,0x0d,0x00,0x00,0x01,0x08,0x01,0x00,  /* 00000568    "........" */
    0x00,0x0e,0x00,0x00,0x01,0x08,0x01,0x00,  /* 00000570    "........" */
    0x00,0x0f,0x00,0x00,0x01,0x08,0x01,0x00,  /* 00000578    "........" */
    0x00,0x10,0x00,0x00,0x01,0x08,0x01,0x00,  /* 00000580    "........" */
    0x00,0x10,0x00,0x04,0x01,0x08,0x01,0x00,  /* 00000588    "........" */
    0x00,0x60,0x00,0x00,0x01,0x08,0x01,0x00,  /* 00000590    ".`......" */
    0x00,0x60,0x00,0x04,0x01,0x08,0x01,0x00,  /* 00000598    ".`......" */
    0x00,0xb0,0x00,0x00,0x01,0x08,0x01,0x00,  /* 000005a0    "........" */
    0x00,0xb0,0x00,0x04,0x07,0x00,0x30,0x00,  /* 000005a8    "......0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000005b0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000005b8    "........" */
    0x00,0x00,0x00,0x00,0x00,0xb0,0x38,0xf6,  /* 000005c0    "......8." */
    0xff,0x1f,0x00,0x00,0x10,0x00,0x00,0x00,  /* 000005c8    "........" */
    0x00,0x05,0x08,0x00,0xf8,0xff,0x07,0x00,  /* 000005d0    "........" */
    0x00,0x00,0x00,0x00,0x08,0x00,0x40,0x00,  /* 000005d8    "......@." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000005e0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000005e8    "........" */
    0x00,0x00,0x00,0x00,0x00,0xb0,0x38,0xf6,  /* 000005f0    "......8." */
    0xff,0x1f,0x00,0x00,0x10,0x00,0x00,0x00,  /* 000005f8    "........" */
    0x00,0x03,0x00,0x04,0x08,0x00,0x08,0x00,  /* 00000600    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,  /* 00000608    ".......(" */
    0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,  /* 00000610    "........" */
    0x00,0x00,0x00,0x00,0x0a,0x00,0x28,0x00,  /* 00000618    "......(." */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000620    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000628    "........" */
    0x00,0x00,0x00,0x00,0x00,0xb0,0x38,0xf6,  /* 00000630    "......8." */
    0xff,0x1f,0x00,0x00,0x10,0x00,0x00,0x00,  /* 00000638    "........" */
    0x00,0x02,0x10,0x00,                      /* 00000640    "...."     */
};

const unsigned char TemplateErst[] =
{
    0x45,0x52,0x53,0x54,0x30,0x02,0x00,0x00,  /* 00000000    "ERST0..." */
    0x01,0xAB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x30,0x00,0x00,0x00,  /* 00000020    "(.. 0..." */
    0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000030    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000048    "........" */
    0x01,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000050    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000068    "........" */
    0x02,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000070    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000088    "........" */
    0x03,0x04,0x01,0x00,0x00,0x40,0x00,0x04,  /* 00000090    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000A8    "........" */
    0x04,0x02,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000C8    "........" */
    0x05,0x03,0x00,0x00,0x01,0x08,0x00,0x01,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000000E8    "........" */
    0x06,0x01,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000000F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000108    "........" */
    0x07,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000110    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000128    "........" */
    0x08,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000130    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000148    "........" */
    0x09,0x02,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000150    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000168    "........" */
    0x0A,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000170    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000188    "........" */
    0x0B,0x03,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000190    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000198    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001A8    "........" */
    0x0C,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001B0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001C8    "........" */
    0x0D,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001D0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E0    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 000001E8    "........" */
    0x0E,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 000001F0    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,  /* 00000208    "........" */
    0x0F,0x00,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000210    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF   /* 00000228    "........" */
};

const unsigned char TemplateFacs[] =
{
    0x46,0x41,0x43,0x53,0x40,0x00,0x00,0x00,  /* 00000000    "FACS@..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000008    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000010    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000020    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000038    "........" */
};

/* Version 5 FADT */

const unsigned char TemplateFadt[] =
{
    0x46,0x41,0x43,0x50,0x14,0x01,0x00,0x00,  /* 00000000    "FACP...." */
    0x06,0x8A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x04,0x02,0x01,0x04,0x08,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000070    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x02,  /* 00000090    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x10,0x00,0x02,  /* 000000A8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x00,  /* 000000C0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x01,0x20,0x00,0x03,0x01,0x00,0x00,0x00,  /* 000000D0    ". ......" */
    0x00,0x00,0x00,0x00,0x01,0x40,0x00,0x01,  /* 000000D8    ".....@.." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x01,0x08,0x00,0x01,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00                       /* 00000110    "...."     */
};

const unsigned char TemplateFpdt[] =
{
    0x46,0x50,0x44,0x54,0x64,0x00,0x00,0x00,  /* 00000000    "FPDTd..." */
    0x01,0xBD,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x08,0x11,0x20,0x00,0x00,0x30,0x01,  /* 00000020    "... ..0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x10,0x01,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00                       /* 00000060    "...."     */
};

const unsigned char TemplateGtdt[] =
{
    0x47,0x54,0x44,0x54,0xE8,0x00,0x00,0x00,  /* 00000000    "GTDT...." */
    0x03,0x5D,0x4C,0x49,0x4E,0x41,0x52,0x4F,  /* 00000008    ".]LINARO" */
    0x52,0x54,0x53,0x4D,0x56,0x45,0x56,0x38,  /* 00000010    "RTSMVEV8" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x08,0x01,0x19,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x1D,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x1E,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x1B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000040    "........" */
    0x1A,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x02,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000058    "....`..." */
    0x43,0x00,0x00,0x00,0x21,0x00,0x00,0x00,  /* 00000060    "C...!..." */
    0x00,0x64,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    ".d......" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000070    "........" */
    0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x01,0x1C,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00   /* 000000E0    "........" */
};

const unsigned char TemplateHest[] =
{
    0x48,0x45,0x53,0x54,0x7C,0x02,0x00,0x00,  /* 00000000    "HEST|..." */
    0x01,0x97,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x03,0x03,0x17,0x20,0x04,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x01,  /* 00000088    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 000000F0    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000120    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x09,0x00,0x02,0x00,  /* 00000150    "........" */
    0xFF,0xFF,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000158    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 00000160    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 00000168    ".@......" */
    0x00,0x00,0x00,0x00,0x03,0x1C,0x00,0x00,  /* 00000170    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x10,0x00,0x00,0x09,0x00,0x03,0x00,  /* 00000190    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 00000198    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 000001A0    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 000001A8    ".@......" */
    0x00,0x00,0x00,0x00,0x04,0x1C,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x00,0x10,0x00,0x00,0x0A,0x00,0x03,0x00,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x01,0x00,0x00,0x00,0x00,0x10,0x00,0x00,  /* 000001E0    "........" */
    0x00,0x40,0x00,0x04,0x00,0x00,0x00,0x00,  /* 000001E8    ".@......" */
    0x00,0x00,0x00,0x00,0x04,0x1C,0x00,0x00,  /* 000001F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000208    "........" */
    0x00,0x10,0x00,0x00,0x00,0x40,0x00,0x04,  /* 00000210    ".....@.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x0B,0x00,0x01,0x00,0x00,0x00,0x00,0x01,  /* 00000230    "........" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000238    "........" */
    0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000240    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000248    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000260    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000268    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000270    "........" */
    0x00,0x00,0x00,0x00                       /* 00000278    "...."     */
};

const unsigned char TemplateHmat[] =
{
    0x48,0x4D,0x41,0x54,0x9C,0x00,0x00,0x00,  /* 00000000    "HMAT...." */
    0x02,0x4D,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".MINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x08,0x01,0x19,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x28,0x00,0x00,0x00,  /* 00000028    "....(..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x2A,0x00,0x00,0x00,  /* 00000050    "....*..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x02,0x00,0x00,0x00,0x22,0x00,  /* 00000078    "......"." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x01,0x00,0x00,0x00                       /* 00000098    "...."     */
};

const unsigned char TemplateHpet[] =
{
    0x48,0x50,0x45,0x54,0x38,0x00,0x00,0x00,  /* 00000000    "HPET8..." */
    0x01,0x09,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateIort[] =
{
    0x49,0x4F,0x52,0x54,0x3C,0x02,0x00,0x00,  /* 00000000    "IORT<..." */
    0x05,0xCB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x12,0x21,0x20,0x07,0x00,0x00,0x00,  /* 00000020    "..! ...." */
    0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "4......." */
    0x49,0x4F,0x52,0x54,0x00,0x18,0x00,0x01,  /* 00000030    "IORT...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x01,0x80,0x00,0x04,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000050    "........" */
    0x6C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "l......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x5C,0x5F,0x53,0x42,0x2E,0x50,0x43,  /* 00000068    ".\_SB.PC" */
    0x49,0x30,0x2E,0x44,0x45,0x56,0x30,0x00,  /* 00000070    "I0.DEV0." */
    0x49,0x4F,0x52,0x54,0x3C,0x02,0x00,0x00,  /* 00000078    "IORT<..." */
    0x03,0xF1,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000080    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000088    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000090    "....INTL" */
    0x05,0x01,0x21,0x20,0x07,0x00,0x00,0x00,  /* 00000098    "..! ...." */
    0x34,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "4......." */
    0x49,0x4F,0x52,0x54,0x00,0x18,0x00,0x01,  /* 000000A8    "IORT...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x02,0x38,0x00,0x04,  /* 000000C8    ".....8.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "$......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x03,0x60,0x00,0x03,  /* 00000100    ".....`.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000108    "........" */
    0x4C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "L......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,  /* 00000128    "....<..." */
    0x00,0x00,0x00,0x00,0x4C,0x00,0x00,0x00,  /* 00000130    "....L..." */
    0x00,0x00,0x00,0x00,0x4C,0x00,0x00,0x00,  /* 00000138    "....L..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x04,0x58,0x00,0x04,  /* 00000160    ".....X.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000168    "........" */
    0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000170    "D......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000190    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000198    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x05,0x3C,0x00,0x02,  /* 000001B8    ".....<.." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000001C0    "........" */
    0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "(......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000001F0    "........" */
    0x06,0x44,0x00,0x03,0x00,0x00,0x00,0x00,  /* 000001F8    ".D......" */
    0x01,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000200    "....0..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000208    "........" */
    0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000210    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000218    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000230    "........" */
    0x00,0x00,0x00,0x00                       /* 00000238    "...."     */
};

const unsigned char TemplateIvrs[] =
{
    0x49,0x56,0x52,0x53,0x10,0x02,0x00,0x00,  /* 00000000    "IVRS...." */
    0x02,0x6C,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".lINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x41,0x30,0x20,0x00,  /* 00000020    "1.! A0 ." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x10,0xB0,0x64,0x00,0x02,0x00,0x40,0x00,  /* 00000030    "..d...@." */
    0x00,0x00,0xF0,0xFD,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x6F,0x8F,0x04,0x80,  /* 00000040    "....o..." */
    0x03,0x08,0x00,0x00,0x01,0x08,0x00,0x00,  /* 00000048    "........" */
    0x02,0x08,0x00,0x00,0x04,0xFE,0xFF,0x00,  /* 00000050    "........" */
    0x42,0x00,0xFF,0x00,0x00,0xA5,0x00,0x00,  /* 00000058    "B......." */
    0x43,0x00,0xFF,0x00,0x00,0xA5,0x00,0x00,  /* 00000060    "C......." */
    0x46,0x00,0xFF,0x00,0x44,0x33,0x22,0x11,  /* 00000068    "F...D3"." */
    0x47,0x00,0xFF,0x00,0x44,0x33,0x22,0x11,  /* 00000070    "G...D3"." */
    0x04,0xFF,0xFF,0x00,0x48,0x00,0x00,0x00,  /* 00000078    "....H..." */
    0x00,0xA0,0x00,0x02,0x48,0x00,0x00,0xD7,  /* 00000080    "....H..." */
    0x21,0xA0,0x00,0x01,0x48,0x00,0x00,0x00,  /* 00000088    "!...H..." */
    0x22,0x01,0x00,0x01,0x11,0xB0,0x48,0x00,  /* 00000090    "".....H." */
    0x02,0x00,0x40,0x00,0x00,0x00,0xF0,0xFD,  /* 00000098    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x02,0x04,0x00,0xDE,0x4A,0x25,0x22,  /* 000000A8    ".....J%"" */
    0xEF,0x73,0x6D,0x20,0x00,0x00,0x00,0x00,  /* 000000B0    ".sm ...." */
    0x00,0x00,0x00,0x00,0x03,0x08,0x00,0x00,  /* 000000B8    "........" */
    0x04,0xFE,0xFF,0x00,0x43,0x00,0xFF,0x00,  /* 000000C0    "....C..." */
    0x00,0xA5,0x00,0x00,0x04,0xFF,0xFF,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,  /* 000000D0    "....H..." */
    0x00,0xA0,0x00,0x02,0x40,0xB0,0xD4,0x00,  /* 000000D8    "....@..." */
    0x02,0x00,0x40,0x00,0x00,0x00,0xF0,0xFD,  /* 000000E0    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x02,0x04,0x00,0xDE,0x4A,0x25,0x22,  /* 000000F0    ".....J%"" */
    0xEF,0x73,0x6D,0x20,0x00,0x00,0x00,0x00,  /* 000000F8    ".sm ...." */
    0x00,0x00,0x00,0x00,0x03,0x08,0x00,0x00,  /* 00000100    "........" */
    0x04,0xFE,0xFF,0x00,0x43,0x00,0xFF,0x00,  /* 00000108    "....C..." */
    0x00,0xA5,0x00,0x00,0x04,0xFF,0xFF,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x48,0x00,0x00,0x00,  /* 00000118    "....H..." */
    0x00,0xA0,0x00,0x02,0x48,0x00,0x00,0xD7,  /* 00000120    "....H..." */
    0x21,0xA0,0x00,0x01,0x48,0x00,0x00,0x00,  /* 00000128    "!...H..." */
    0x22,0x01,0x00,0x01,0xF0,0xA5,0x00,0x40,  /* 00000130    ""......@" */
    0x49,0x4E,0x54,0x43,0x30,0x30,0x32,0x30,  /* 00000138    "INTC0020" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x02,0x09,0x5C,0x5F,0x53,0x42,0x2E,0x44,  /* 00000148    "..\_SB.D" */
    0x45,0x56,0x30,0xF0,0xA5,0x00,0x40,0x49,  /* 00000150    "EV0...@I" */
    0x4E,0x54,0x43,0x30,0x30,0x32,0x30,0x00,  /* 00000158    "NTC0020." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,  /* 00000160    "........" */
    0x09,0x5C,0x5F,0x53,0x42,0x2E,0x44,0x45,  /* 00000168    ".\_SB.DE" */
    0x56,0x31,0xF0,0xA5,0x00,0x40,0x49,0x4E,  /* 00000170    "V1...@IN" */
    0x54,0x43,0x30,0x30,0x32,0x30,0x00,0x00,  /* 00000178    "TC0020.." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x09,  /* 00000180    "........" */
    0x5C,0x5F,0x53,0x42,0x2E,0x44,0x45,0x56,  /* 00000188    "\_SB.DEV" */
    0x32,0xF0,0xA5,0x00,0x40,0x49,0x4E,0x54,  /* 00000190    "2...@INT" */
    0x43,0x30,0x30,0x32,0x30,0x00,0x00,0x00,  /* 00000198    "C0020..." */
    0x00,0x00,0x00,0x00,0x00,0x02,0x09,0x5C,  /* 000001A0    ".......\" */
    0x5F,0x53,0x42,0x2E,0x44,0x45,0x56,0x33,  /* 000001A8    "_SB.DEV3" */
    0x20,0x0D,0x20,0x00,0x22,0x11,0x00,0x00,  /* 000001B0    " . ."..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B8    "........" */
    0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,0x00,  /* 000001C0    "..xV4..." */
    0xDC,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001C8    "........" */
    0x21,0x0D,0x20,0x00,0x22,0x11,0x00,0x00,  /* 000001D0    "!. ."..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,0x00,  /* 000001E0    "..xV4..." */
    0xDC,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x22,0x0D,0x20,0x00,0x22,0x11,0x00,0x00,  /* 000001F0    "". ."..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,0x00,  /* 00000200    "..xV4..." */
    0xDC,0xFE,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000208    "........" */
};

const unsigned char TemplateLpit[] =
{
    0x4C,0x50,0x49,0x54,0x94,0x00,0x00,0x00,  /* 00000000    "LPIT...." */
    0x00,0xD8,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "8......." */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x7F,0x40,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    ".@......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "8......." */
    0x00,0x00,0x00,0x00,0x01,0x08,0x00,0x01,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x7F,0x40,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    ".@......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00                       /* 00000090    "...."     */
};

/* MADT with ACPI 6.0 subtables */

const unsigned char TemplateMadt[] =
{
    0x41,0x50,0x49,0x43,0x62,0x02,0x00,0x00,  /* 00000000    "APICb..." */
    0x07,0x44,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".DINTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x06,0x23,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.# ...." */
    0x01,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x01,0x0C,0x01,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x02,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x03,0x08,0x0D,0x00,0x01,0x00,  /* 00000048    "........" */
    0x00,0x00,0x04,0x06,0x00,0x05,0x00,0x01,  /* 00000050    "........" */
    0x05,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x06,0x10,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x07,0x16,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x5C,0x43,0x50,0x55,  /* 00000080    "....\CPU" */
    0x30,0x00,0x08,0x10,0x05,0x00,0x00,0x00,  /* 00000088    "0......." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x01,0x00,  /* 00000090    "........" */
    0x00,0x00,0x09,0x10,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x0A,0x0C,0x05,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x52,  /* 000000B0    ".......R" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x18,  /* 00000100    "........" */
    0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000118    "........" */
    0x0D,0x18,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x0E,0x10,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x0F,0x14,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x10,0x10,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x00,0x11,0x0F,0x01,0x01,  /* 00000168    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,  /* 00000170    "........" */
    0x00,0x00,0x00,0x12,0x17,0x01,0x00,0x14,  /* 00000178    "........" */
    0xE0,0x1F,0x00,0x00,0x00,0x00,0x80,0x00,  /* 00000180    "........" */
    0x02,0x03,0xFF,0xFF,0xFF,0x00,0x00,0x00,  /* 00000188    "........" */
    0x00,0xFF,0x13,0x15,0x01,0x80,0x00,0x00,  /* 00000190    "........" */
    0xFB,0xFD,0x0E,0x00,0x00,0x40,0x00,0x00,  /* 00000198    ".....@.." */
    0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x14,  /* 000001A0    "........" */
    0x0D,0x01,0x03,0x00,0x00,0x00,0x00,0x00,  /* 000001A8    "........" */
    0x00,0x00,0x00,0x00,0x15,0x13,0x01,0x00,  /* 000001B0    "........" */
    0x00,0xF0,0x2F,0x00,0x00,0x00,0x00,0x40,  /* 000001B8    "../....@" */
    0x00,0x00,0x00,0xC0,0x00,0x00,0x00,0x16,  /* 000001C0    "........" */
    0x11,0x01,0x00,0x00,0x00,0x10,0x00,0x00,  /* 000001C8    "........" */
    0x00,0x00,0x00,0x10,0x00,0x00,0x40,0x00,  /* 000001D0    "......@." */
    0x17,0x0E,0x01,0x00,0x20,0x00,0x10,0x00,  /* 000001D8    ".... ..." */
    0x00,0x00,0x00,0x00,0x10,0x13,0x18,0x24,  /* 000001E0    ".......$" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000001E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x28,0x00,0x00,0x00,0x00,0x00,0x10,  /* 00000200    ".(......" */
    0x00,0x00,0x19,0x10,0x01,0x00,0x00,0x00,  /* 00000208    "........" */
    0x00,0x00,0xFF,0x00,0xFF,0x00,0x00,0x00,  /* 00000210    "........" */
    0x00,0x18,0x1A,0x24,0x01,0x00,0x00,0x00,  /* 00000218    "...$...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000220    "........" */
    0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000228    "....`..." */
    0x00,0x00,0x00,0x00,0x00,0x0D,0x00,0x00,  /* 00000230    "........" */
    0x00,0x00,0x00,0x80,0x00,0x00,0x1B,0x24,  /* 00000238    ".......$" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000240    "........" */
    0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,  /* 00000248    "..`....." */
    0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000250    "....`..." */
    0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00                                 /* 00000260    ".."       */
};

const unsigned char TemplateMcfg[] =
{
    0x4D,0x43,0x46,0x47,0x3C,0x00,0x00,0x00,  /* 00000000    "MCFG<..." */
    0x01,0x19,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00                       /* 00000038    "...."     */
};

const unsigned char TemplateMchi[] =
{
    0x4D,0x43,0x48,0x49,0x45,0x00,0x00,0x00,  /* 00000000    "MCHIE..." */
    0x01,0xE4,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x15,0x07,0x00,0x02,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x02,0x08,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00                  /* 00000040    "....."    */
};

const unsigned char TemplateMsdm[] =
{
    0x4D,0x53,0x44,0x4D,0x64,0x00,0x00,0x00,  /* 00000000    "MSDMd..." */
    0x01,0x34,0x49,0x6E,0x74,0x65,0x6C,0x00,  /* 00000008    ".4Intel." */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x03,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x02,0x15,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000028    "........" */
    0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,  /* 00000030    ".... !"#" */
    0x24,0x25,0x26,0x27,0x10,0x0A,0x15,0x16,  /* 00000038    "$%&'...." */
    0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,  /* 00000040    "........" */
    0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,  /* 00000048    ". !"#$%&" */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 00000050    "........" */
    0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,  /* 00000058    "...... !" */
    0x22,0x23,0x24,0x25                       /* 00000060    ""#$%"     */
};

const unsigned char TemplateMpam[] =
{
    0x4D,0x50,0x41,0x4D,0xFC,0x00,0x00,0x00,  /* 00000000    "MPAM...." */
    0x02,0x35,0x48,0x49,0x53,0x49,0x20,0x20,  /* 00000008    ".5HISI  " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x02,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x06,0x23,0x20,0x60,0x00,0x00,0x00,  /* 00000020    "(.# `..." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "2......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x01,0x00,0x00,0x00,0x11,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x01,0x20,0x00,0x00,0x00,  /* 00000070    ".... ..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x78,0x00,0x00,0x00,  /* 00000080    "....x..." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xD0,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "2......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x02,0x00,0x00,0x00,0x12,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00                       /* 000000F8    "...."     */
};

const unsigned char TemplateMpst[] =
{
    0x4D,0x50,0x53,0x54,0xB6,0x00,0x00,0x00,  /* 00000000    "MPST...." */
    0x01,0x77,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".wINTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x09,0x12,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000040    "........" */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,  /* 00000068    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x02,0x00,0x00,0x00,0x01,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 000000B0    "......"   */
};

const unsigned char TemplateMrrm[] =
{
    0x4D,0x52,0x52,0x4D,0xE0,0x00,0x00,0x00,  /* 00000000    "MRRM...." */
    0x01,0x6F,0x49,0x4E,0x54,0x45,0x4C,0x00,  /* 00000008    ".oINTEL." */
    0x49,0x4E,0x54,0x45,0x4C,0x20,0x49,0x44,  /* 00000010    "INTEL ID" */
    0x02,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x06,0x23,0x20,0x02,0x00,0x00,0x00,  /* 00000020    "(.# ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000040    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000060    ".. ....." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0xFF,0x03,0x00,0x00,  /* 00000070    "........" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 00000080    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,  /* 00000090    "........" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,  /* 000000B0    "........" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    ".. ....." */
    0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,  /* 000000D0    "........" */
    0x01,0x00,0x01,0x00,0x00,0x00,0x00,0x00   /* 000000D8    "........" */
};

const unsigned char TemplateMsct[] =
{
    0x4D,0x53,0x43,0x54,0x90,0x00,0x00,0x00,  /* 00000000    "MSCT...." */
    0x01,0xB7,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x38,0x00,0x00,0x00,  /* 00000020    "(.. 8..." */
    0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0xFF,0xFF,0xFF,0xFF,0xFF,0x0F,0x00,0x00,  /* 00000030    "........" */
    0x01,0x16,0x00,0x00,0x00,0x00,0x03,0x00,  /* 00000038    "........" */
    0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x40,0x00,0x00,0x00,0x01,0x16,  /* 00000048    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x01,0x16,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x01,0x16,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000088    "........" */
};

const unsigned char TemplateNfit[] =
{
    0x4E,0x46,0x49,0x54,0x88,0x01,0x00,0x00,  /* 00000000    "NFIT...." */
    0x01,0x81,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x11,0x20,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "..  ...." */
    0x00,0x00,0x40,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "..@....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x30,0x05,0xAF,0x91,0x86,0x5D,0x0E,0x47,  /* 00000038    "0....].G" */
    0xA6,0xB0,0x0A,0x2D,0xB9,0x40,0x82,0x49,  /* 00000040    "...-.@.I" */
    0x00,0x00,0x00,0x7C,0x03,0x00,0x00,0x00,  /* 00000048    "...|...." */
    0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0xEF,0xCD,0xAB,0x78,0x56,0x34,0x12,  /* 00000060    "....xV4." */
    0x01,0x00,0x30,0x00,0x01,0x00,0x00,0x00,  /* 00000068    "..0....." */
    0x04,0x00,0x00,0x00,0x01,0x00,0x01,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x01,0x00,0x03,0x00,0x2A,0x00,0x00,0x00,  /* 00000090    "....*..." */
    0x02,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000098    ".. ....." */
    0x04,0x00,0x00,0x00,0x00,0x01,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x06,0x00,0x00,0x00,0x09,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x03,0x00,0x28,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "..(....." */
    0xB4,0x13,0x5D,0x40,0x91,0x0B,0x29,0x93,  /* 000000C0    "..]@..)." */
    0x67,0xE8,0x23,0x4C,0x00,0x00,0x00,0x88,  /* 000000C8    "g.#L...." */
    0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,  /* 000000D0    ".."3DUfw" */
    0x88,0x99,0xAA,0xBB,0xCC,0xDD,0xEE,0xFF,  /* 000000D8    "........" */
    0x04,0x00,0x50,0x00,0x01,0x00,0x86,0x80,  /* 000000E0    "..P....." */
    0x17,0x20,0x01,0x00,0x86,0x80,0x17,0x20,  /* 000000E8    ". ..... " */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x89,0x00,0x54,0x76,0x01,0x03,0x00,0x01,  /* 000000F8    "..Tv...." */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    ". ......" */
    0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x10,0x80,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x05,0x00,0x28,0x00,0x01,0x00,0x00,0x01,  /* 00000130    "..(....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    ". ......" */
    0x00,0x00,0x00,0xE0,0x0F,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x06,0x00,0x20,0x00,0x01,0x00,0x00,0x00,  /* 00000158    ".. ....." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x18,0x04,0x00,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x18,0x06,0x00,0x00,0x00,  /* 00000170    "........" */
    0x07,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000180    "........" */
};

const unsigned char TemplatePcct[] =
{
    0x50,0x43,0x43,0x54,0xAE,0x02,0x00,0x00,  /* 00000000    "PCCT...." */
    0x01,0xE6,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x25,0x09,0x20,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "%.  ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x3E,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    ".>......" */
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,  /* 00000038    "........" */
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,  /* 00000040    """""""""" */
    0x01,0x32,0x00,0x03,0x33,0x33,0x33,0x33,  /* 00000048    ".2..3333" */
    0x33,0x33,0x33,0x33,0x44,0x44,0x44,0x44,  /* 00000050    "3333DDDD" */
    0x44,0x44,0x44,0x44,0x55,0x55,0x55,0x55,  /* 00000058    "DDDDUUUU" */
    0x55,0x55,0x55,0x55,0x66,0x66,0x66,0x66,  /* 00000060    "UUUUffff" */
    0x77,0x77,0x77,0x77,0x88,0x88,0x01,0x3E,  /* 00000068    "wwww...>" */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x32,  /* 00000080    ".......2" */
    0x00,0x03,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000088    "..DDDDDD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000090    "DDDDDDDD" */
    0x44,0x44,0x55,0x55,0x55,0x55,0x55,0x55,  /* 00000098    "DDUUUUUU" */
    0x55,0x55,0x66,0x66,0x66,0x66,0x77,0x77,  /* 000000A0    "UUffffww" */
    0x77,0x77,0x88,0x88,0x02,0x5A,0x01,0x00,  /* 000000A8    "ww...Z.." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x01,0x32,0x00,0x03,  /* 000000C0    ".....2.." */
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,  /* 000000C8    "DDDDDDDD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,  /* 000000D0    "DDDDDDDD" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55,  /* 000000D8    "UUUUUUUU" */
    0x66,0x66,0x66,0x66,0x77,0x77,0x77,0x77,  /* 000000E0    "ffffwwww" */
    0x88,0x88,0x01,0x32,0x00,0x03,0x33,0x33,  /* 000000E8    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x44,0x44,  /* 000000F0    "333333DD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x55,0x55,  /* 000000F8    "DDDDDDUU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x03,0xA4,  /* 00000100    "UUUUUU.." */
    0x01,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000118    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x44,0x44,  /* 00000120    "333333DD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x55,0x55,  /* 00000128    "DDDDDDUU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x66,0x66,  /* 00000130    "UUUUUUff" */
    0x66,0x66,0x77,0x77,0x77,0x77,0x88,0x88,  /* 00000138    "ffwwww.." */
    0x88,0x88,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000140    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x99,0x99,  /* 00000148    "333333.." */
    0x99,0x99,0x99,0x99,0x99,0x99,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x32,  /* 00000160    ".......2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000168    "..333333" */
    0x33,0x33,0x22,0x22,0x22,0x22,0x22,0x22,  /* 00000170    "33""""""" */
    0x22,0x22,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000178    """.2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000180    "33333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x44,0x44,  /* 00000188    "333333DD" */
    0x44,0x44,0x44,0x44,0x44,0x44,0x01,0x32,  /* 00000190    "DDDDDD.2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000198    "..333333" */
    0x33,0x33,0x55,0x55,0x55,0x55,0x55,0x55,  /* 000001A0    "33UUUUUU" */
    0x55,0x55,0x04,0xA4,0x01,0x00,0x00,0x00,  /* 000001A8    "UU......" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x32,  /* 000001B8    ".......2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 000001C0    "..333333" */
    0x33,0x33,0x44,0x44,0x44,0x44,0x44,0x44,  /* 000001C8    "33DDDDDD" */
    0x44,0x44,0x55,0x55,0x55,0x55,0x55,0x55,  /* 000001D0    "DDUUUUUU" */
    0x55,0x55,0x66,0x66,0x66,0x66,0x77,0x77,  /* 000001D8    "UUffffww" */
    0x77,0x77,0x88,0x88,0x88,0x88,0x01,0x32,  /* 000001E0    "ww.....2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 000001E8    "..333333" */
    0x33,0x33,0x99,0x99,0x99,0x99,0x99,0x99,  /* 000001F0    "33......" */
    0x99,0x99,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0x00,0x00,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000208    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x22,0x22,  /* 00000210    "333333""" */
    0x22,0x22,0x22,0x22,0x22,0x22,0x01,0x32,  /* 00000218    """"""".2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000220    "..333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000228    "33333333" */
    0x33,0x33,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000230    "33DDDDDD" */
    0x44,0x44,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000238    "DD.2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x55,0x55,  /* 00000240    "333333UU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x05,0x60,  /* 00000248    "UUUUUU.`" */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000260    "...2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000268    "33333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000270    "33333333" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x01,0x32,  /* 00000278    "333333.2" */
    0x00,0x03,0x33,0x33,0x33,0x33,0x33,0x33,  /* 00000280    "..333333" */
    0x33,0x33,0x44,0x44,0x44,0x44,0x44,0x44,  /* 00000288    "33DDDDDD" */
    0x44,0x44,0x01,0x32,0x00,0x03,0x33,0x33,  /* 00000290    "DD.2..33" */
    0x33,0x33,0x33,0x33,0x33,0x33,0x55,0x55,  /* 00000298    "333333UU" */
    0x55,0x55,0x55,0x55,0x55,0x55,0x03,0x00,  /* 000002A0    "UUUUUU.." */
    0x00,0x00,0x05,0x00,0x00,0x00             /* 000002A8    "......"   */
};

const unsigned char TemplatePdtt[] =
{
    0x50,0x44,0x54,0x54,0x34,0x00,0x00,0x00,  /* 00000000    "PDTT4..." */
    0x01,0xCB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x08,0x17,0x20,0x04,0x00,0x00,0x00,  /* 00000020    "1.. ...." */
    0x2C,0x00,0x00,0x00,0xAA,0x03,0xBB,0x02,  /* 00000028    ",......." */
    0xCC,0x01,0xDD,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplatePhat [] =
{
    0x50,0x48,0x41,0x54,0xA2,0x00,0x00,0x00,  /* 00000000    "PHAT...." */
    0x01,0xCA,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x22,0x20,0x00,0x00,0x28,0x00,  /* 00000020    "1." ..(." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x30,0x05,0xAF,0x91,0x86,0x5D,0x0E,0x47,  /* 00000030    "0....].G" */
    0xA6,0xB0,0x0A,0x2D,0xB9,0x40,0x82,0x49,  /* 00000038    "...-.@.I" */
    0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,  /* 00000040    "........" */
    0x0C,0x0B,0x0A,0x09,0x01,0x00,0x2E,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x30,0x05,0xAF,0x91,  /* 00000050    "....0..." */
    0x86,0x5D,0x0E,0x47,0xA6,0xB0,0x0A,0x2D,  /* 00000058    ".].G...-" */
    0xB9,0x40,0x82,0x49,0x2A,0x00,0x00,0x00,  /* 00000060    ".@.I*..." */
    0x41,0x00,0x42,0x00,0x43,0x00,0x44,0x00,  /* 00000068    "A.B.C.D." */
    0x45,0x00,0x46,0x00,0x00,0x00,0x01,0x02,  /* 00000070    "E.F....." */
    0x03,0x04,0x00,0x00,0x28,0x00,0x00,0x00,  /* 00000078    "....(..." */
    0x00,0x00,0x01,0x00,0x00,0x00,0x30,0x05,  /* 00000080    "......0." */
    0xAF,0x91,0x86,0x5D,0x0E,0x47,0xA6,0xB0,  /* 00000088    "...].G.." */
    0x0A,0x2D,0xB9,0x40,0x82,0x49,0x08,0x07,  /* 00000090    ".-.@.I.." */
    0x06,0x05,0x04,0x03,0x02,0x01,0x0C,0x0B,  /* 00000098    "........" */
    0x0A,0x09                                 /* 000000A0    ".."       */
};

const unsigned char TemplatePmtt[] =
{
    0x50,0x4D,0x54,0x54,0xBB,0x00,0x00,0x00,  /* 00000000    "PMTT...." */
    0x02,0x2E,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x08,0x00,0x00,0x00,  /* 00000020    "..! ...." */
    0x00,0x00,0x10,0x00,0x0D,0x00,0x00,0x00,  /* 00000028    "........" */
    0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x10,0x00,0x04,0x00,0x00,0x00,  /* 00000038    "........" */
    0x02,0x00,0x00,0x00,0x44,0x44,0x00,0x00,  /* 00000040    "....DD.." */
    0x02,0x00,0x10,0x00,0x04,0x00,0x00,0x00,  /* 00000048    "........" */
    0x01,0x00,0x00,0x00,0x78,0x56,0x34,0x12,  /* 00000050    "....xV4." */
    0xFF,0x00,0x23,0x00,0x0D,0x00,0x00,0x00,  /* 00000058    "..#....." */
    0x03,0x00,0x00,0x00,0x03,0x02,0x01,0x00,  /* 00000060    "........" */
    0x08,0x04,0x07,0x06,0x08,0x09,0x0A,0x0B,  /* 00000068    "........" */
    0x0C,0x0D,0x0E,0x0F,0x55,0x66,0x77,0x88,  /* 00000070    "....Ufw." */
    0x11,0xAA,0xBB,0x00,0x00,0x10,0x00,0x0D,  /* 00000078    "........" */
    0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x01,  /* 00000080    "........" */
    0x00,0x00,0x00,0x01,0x00,0x10,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x02,0x00,0x10,0x00,0x04,  /* 00000098    "........" */
    0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x78,  /* 000000A0    ".......x" */
    0x56,0x34,0x12,0x02,0x00,0x10,0x00,0x04,  /* 000000A8    "V4......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,  /* 000000B0    ".......x" */
    0x56,0x34,0x12                            /* 000000B8    "V4."      */
};

const unsigned char TemplatePptt[] =
{
    0x50,0x50,0x54,0x54,0x72,0x00,0x00,0x00,  /* 00000000    "PPTTr..." */
    0x01,0x86,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x03,0x03,0x17,0x20,0x00,0x18,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x01,0x18,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x02,0x1E,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00                                 /* 00000070    ".."       */
};

const unsigned char TemplatePrmt[] =
{
    0x50,0x52,0x4D,0x54,0xB8,0x02,0x00,0x00,  /* 00000000    "PRMT...." */
    0x00,0x13,0x4F,0x45,0x4D,0x43,0x41,0x20,  /* 00000008    "..OEMCA " */
    0x4F,0x45,0x4D,0x43,0x41,0x20,0x20,0x20,  /* 00000010    "OEMCA   " */
    0x02,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x17,0x07,0x20,0x20,0xA5,0x61,0x6B,0xB6,  /* 00000020    "..  .ak." */
    0x01,0xA1,0x46,0xED,0xA6,0xA3,0xCA,0xC1,  /* 00000028    "..F....." */
    0xC4,0xD1,0x30,0x1E,0x3C,0x00,0x00,0x00,  /* 00000030    "..0.<..." */
    0x04,0x00,0x00,0x00,0x00,0x00,0xAA,0x00,  /* 00000038    "........" */
    0xC2,0xB3,0x52,0x16,0xA1,0xA7,0xAC,0x46,  /* 00000040    "..R....F" */
    0xAF,0x93,0xDD,0x6D,0xEE,0x44,0x66,0x69,  /* 00000048    "...m.Dfi" */
    0x01,0x00,0x00,0x00,0x03,0x00,0x26,0x00,  /* 00000050    "......&." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0x5F,0xAD,  /* 00000060    "....,._." */
    0xF2,0xD5,0x47,0xA3,0x3E,0x4D,0x87,0xBC,  /* 00000068    "..G.>M.." */
    0xC2,0xCE,0x63,0x02,0x9C,0xC8,0x90,0xC2,  /* 00000070    "..c....." */
    0x5E,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "^......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x2C,0x00,0xC3,0xAD,0xE7,0xA9,0xD0,0x8C,  /* 00000090    ",......." */
    0x9A,0x42,0x89,0x15,0x10,0x94,0x6E,0xBD,  /* 00000098    ".B....n." */
    0xE3,0x18,0xC0,0xC2,0x5E,0x8A,0x00,0x00,  /* 000000A0    "....^..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0x14,0xC2,  /* 000000B8    "....,..." */
    0x88,0xB6,0x81,0x40,0xEB,0x4E,0x8D,0x26,  /* 000000C0    "...@.N.&" */
    0x1E,0xB5,0xA3,0xBC,0xF1,0x1A,0xF0,0xC2,  /* 000000C8    "........" */
    0x5E,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D0    "^......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000D8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E0    "........" */
    0x52,0x00,0xA6,0x58,0x2A,0xDC,0x27,0x59,  /* 000000E8    "R..X*.'Y" */
    0x76,0x47,0xB9,0x95,0xD1,0x18,0xA2,0x73,  /* 000000F0    "vG.....s" */
    0x35,0xA2,0x01,0x00,0x00,0x00,0x01,0x00,  /* 000000F8    "5......." */
    0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "&......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x00,  /* 00000108    "......,." */
    0x13,0x2D,0x4F,0x2E,0x40,0x62,0xD0,0x4E,  /* 00000110    ".-O.@b.N" */
    0xA4,0x01,0xC7,0x23,0xFB,0xDC,0x34,0xE8,  /* 00000118    "...#..4." */
    0x90,0x32,0x5E,0x8A,0x00,0x00,0x00,0x00,  /* 00000120    ".2^....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0xF8,0x7F,0x71,0x8A,0x00,0x00,0x00,0x00,  /* 00000130    "..q....." */
    0x00,0x00,0x2E,0x01,0xD7,0x3E,0xF9,0x0E,  /* 00000138    ".....>.." */
    0xAE,0x14,0x5B,0x42,0x92,0x8F,0xB8,0x5A,  /* 00000140    "..[B...Z" */
    0x62,0x13,0xB5,0x7E,0x01,0x00,0x00,0x00,  /* 00000148    "b..~...." */
    0x06,0x00,0x26,0x00,0x00,0x00,0xE0,0x3F,  /* 00000150    "..&....?" */
    0x71,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "q......." */
    0x2C,0x00,0x3C,0xCD,0x20,0x21,0x8B,0x84,  /* 00000160    ",.<. !.." */
    0x8F,0x4D,0xAB,0xBB,0x4B,0x74,0xCE,0x64,  /* 00000168    ".M..Kt.d" */
    0xAC,0x89,0x4C,0xA6,0x5D,0x8A,0x00,0x00,  /* 00000170    "..L.]..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000178    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000180    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0xA7,0x35,  /* 00000188    "....,..5" */
    0x09,0xEA,0x6B,0x50,0x59,0x41,0xBB,0xBB,  /* 00000190    "..kPYA.." */
    0x48,0xDE,0xEE,0xCB,0x6F,0x58,0x34,0xA7,  /* 00000198    "H...oX4." */
    0x5D,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A0    "]......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001B0    "........" */
    0x2C,0x00,0xA9,0xBD,0xD1,0x1B,0x9A,0x90,  /* 000001B8    ",......." */
    0x14,0x46,0x96,0x99,0x25,0xEC,0x0C,0x27,  /* 000001C0    ".F..%..'" */
    0x83,0xF7,0x94,0xA7,0x5D,0x8A,0x00,0x00,  /* 000001C8    "....]..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001D8    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0xE7,0xB4,  /* 000001E0    "....,..." */
    0x28,0x5D,0x67,0x38,0xEE,0x4A,0xAA,0x09,  /* 000001E8    "(]g8.J.." */
    0x51,0xFC,0x28,0x2C,0x3B,0x22,0x9C,0xA6,  /* 000001F0    "Q.(,;".." */
    0x5D,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000001F8    "]......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000200    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000208    "........" */
    0x2C,0x00,0x02,0xB7,0x64,0x4B,0x2B,0x4D,  /* 00000210    ",...dK+M" */
    0xFE,0x4D,0xAC,0x5A,0x0B,0x41,0x10,0xA2,  /* 00000218    ".M.Z.A.." */
    0xCA,0x47,0x48,0xA7,0x5D,0x8A,0x00,0x00,  /* 00000220    ".GH.]..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000228    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000230    "........" */
    0x00,0x00,0x00,0x00,0x2C,0x00,0xDE,0xFD,  /* 00000238    "....,..." */
    0x0E,0x8A,0xD0,0x78,0xF0,0x45,0xAE,0xA0,  /* 00000240    "...x.E.." */
    0xC2,0x82,0x45,0xC7,0xE1,0xDB,0x98,0xA7,  /* 00000248    "..E....." */
    0x5D,0x8A,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000250    "]......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000258    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000260    "........" */
    0x52,0x00,0x2B,0xF4,0x6C,0x5A,0xB4,0x8B,  /* 00000268    "R.+.lZ.." */
    0x2C,0x47,0xA2,0x33,0x5C,0x4D,0xC4,0x03,  /* 00000270    ",G.3\M.." */
    0x3D,0xC7,0x01,0x00,0x00,0x00,0x01,0x00,  /* 00000278    "=......." */
    0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000280    "&......." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x00,  /* 00000288    "......,." */
    0x81,0x60,0x46,0xE1,0x62,0x75,0x0F,0x43,  /* 00000290    ".`F.bu.C" */
    0x89,0x6B,0xB0,0xE5,0x23,0xDC,0x33,0x5A,  /* 00000298    ".k..#.3Z" */
    0x90,0x12,0x5D,0x8A,0x00,0x00,0x00,0x00,  /* 000002A0    "..]....." */
    0xE0,0x5F,0x71,0x8A,0x00,0x00,0x00,0x00,  /* 000002A8    "._q....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 000002B0    "........" */
};

const unsigned char TemplateRasf[] =
{
    0x52,0x41,0x53,0x46,0x30,0x00,0x00,0x00,  /* 00000000    "RASF0..." */
    0x01,0x31,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".1INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x27,0x05,0x16,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "'.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateRas2[] =
{
    0x52,0x41,0x53,0x32,0x38,0x00,0x00,0x00,  /* 00000000    "RAS28..." */
    0x01,0x28,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".(INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x06,0x23,0x20,0x00,0x00,0x02,0x00,  /* 00000020    "(.# ...." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000028    "........" */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00   /* 00000030    "........" */
};

const unsigned char TemplateRgrt[] =
{
    0x52,0x47,0x52,0x54,0x50,0x00,0x00,0x00,  /* 00000000    "RGRTP..." */
    0x01,0x33,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".3INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x01,0x00,0x01,0x00,  /* 00000020    "1.! ...." */
    0xAA,0x01,0x02,0x03,0x04,0x05,0x06,0x07,  /* 00000028    "........" */
    0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,  /* 00000030    "........" */
    0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,  /* 00000038    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 00000040    "........" */
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27   /* 00000048    " !"#$%&'" */
};

const unsigned char TemplateRhct[] =
{
    0x52,0x48,0x43,0x54,0x96,0x00,0x00,0x00,  /* 00000000    "RHCT...." */
    0x01,0x6D,0x4F,0x45,0x4D,0x43,0x41,0x00,  /* 00000008    ".mOEMCA." */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x04,0x04,0x25,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "..% ...." */
    0x80,0x96,0x98,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x04,0x00,0x00,0x00,0x38,0x00,0x00,0x00,  /* 00000030    "....8..." */
    0x00,0x00,0x34,0x00,0x01,0x00,0x2B,0x00,  /* 00000038    "..4...+." */
    0x72,0x76,0x36,0x34,0x69,0x6D,0x61,0x66,  /* 00000040    "rv64imaf" */
    0x64,0x63,0x68,0x5F,0x7A,0x69,0x63,0x73,  /* 00000048    "dch_zics" */
    0x72,0x5F,0x7A,0x69,0x66,0x65,0x6E,0x63,  /* 00000050    "r_zifenc" */
    0x65,0x69,0x5F,0x7A,0x62,0x61,0x5F,0x7A,  /* 00000058    "ei_zba_z" */
    0x62,0x62,0x5F,0x7A,0x62,0x63,0x5F,0x7A,  /* 00000060    "bb_zbc_z" */
    0x62,0x73,0x00,0x00,0x01,0x00,0x0A,0x00,  /* 00000068    "bs......" */
    0x01,0x00,0x00,0x06,0x06,0x06,0x02,0x00,  /* 00000070    "........" */
    0x08,0x00,0x01,0x00,0x00,0x02,0xFF,0xFF,  /* 00000078    "........" */
    0x18,0x00,0x01,0x00,0x03,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x3B,0x00,0x00,0x00,0x6C,0x00,  /* 00000088    "..;...l." */
    0x00,0x00,0x76,0x00,0x00,0x00             /* 00000090    "..v..."   */
};

const unsigned char TemplateRimt[] =
{
    0x52,0x49,0x4d,0x54,0x80,0x00,0x00,0x00,  /* 00000000    "RIMT...." */
    0x01,0xe1,0x42,0x4f,0x43,0x48,0x53,0x20,  /* 00000008    ".pBOCHS " */
    0x42,0x58,0x50,0x43,0x20,0x20,0x20,0x20,  /* 00000010    "BXPC    " */
    0x01,0x00,0x00,0x00,0x42,0x58,0x50,0x43,  /* 00000018    "....INTL" */
    0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,  /* 00000020    "..$ ...." */
    0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "0......." */
    0x00,0x01,0x28,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "..(....." */
    0x52,0x53,0x43,0x56,0x30,0x30,0x30,0x34,  /* 00000038    "RSCV0004" */
    0x00,0x00,0x01,0x03,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x00,  /* 00000050    "......(." */
    0x01,0x01,0x28,0x00,0x00,0x00,0x01,0x00,  /* 00000058    "..(....." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x14,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000078    "0......." */
};

const unsigned char TemplateRsdp[] =
{
    0x52,0x53,0x44,0x20,0x50,0x54,0x52,0x20,  /* 00000000    "RSD PTR " */
    0x43,0x49,0x4E,0x54,0x45,0x4C,0x20,0x02,  /* 00000008    "CINTEL ." */
    0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x00,  /* 00000010    "....$..." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0xDC,0x00,0x00,0x00                       /* 00000020    "...."     */
};

const unsigned char TemplateRsdt[] =
{
    0x52,0x53,0x44,0x54,0x44,0x00,0x00,0x00,  /* 00000000    "RSDTD..." */
    0x01,0xB1,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x10,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x20,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000028    " ...0..." */
    0x40,0x00,0x00,0x00,0x50,0x00,0x00,0x00,  /* 00000030    "@...P..." */
    0x60,0x00,0x00,0x00,0x70,0x00,0x00,0x00,  /* 00000038    "`...p..." */
    0x80,0x00,0x00,0x00                       /* 00000040    "...."     */
};

const unsigned char TemplateS3pt[] =
{
    0x53,0x33,0x50,0x54,0x34,0x00,0x00,0x00,  /* 00000000    "S3PT4..." */
    0x00,0x00,0x18,0x01,0x00,0x00,0x00,0x00,  /* 00000008    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000010    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000018    "........" */
    0x01,0x00,0x14,0x01,0x00,0x00,0x00,0x00,  /* 00000020    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00                       /* 00000030    "...."     */
};

const unsigned char TemplateSbst[] =
{
    0x53,0x42,0x53,0x54,0x30,0x00,0x00,0x00,  /* 00000000    "SBST0..." */
    0x01,0x06,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000028    "........" */
};

const unsigned char TemplateSdei[] =
{
    0x53,0x44,0x45,0x49,0x3e,0x00,0x00,0x00,  /* 00000000    "SDEI>..." */
    0x01,0x59,0x41,0x52,0x4d,0x20,0x20,0x20,  /* 00000008    ".mARM  " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x16,0x20                       /* 00000028    "0.. " */
};

const unsigned char TemplateSdev[] =
{
    0x53,0x44,0x45,0x56,0x89,0x00,0x00,0x00,  /* 00000000    "SDEV...." */
    0x01,0x6E,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".nINTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x00,0x03,0x41,0x00,  /* 00000020    "..! ..A." */
    0x23,0x00,0x16,0x00,0x39,0x00,0x08,0x00,  /* 00000028    "#...9..." */
    0x10,0x00,0x13,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x01,0x00,0x03,0x02,0x05,0x04,0x07,0x06,  /* 00000038    "........" */
    0x09,0x08,0x0A,0x0B,0x0C,0x0D,0x0E,0x5C,  /* 00000040    ".......\" */
    0x5C,0x5F,0x53,0x42,0x5F,0x2E,0x50,0x43,  /* 00000048    "\_SB_.PC" */
    0x49,0x30,0x2E,0x55,0x53,0x42,0x31,0x2E,  /* 00000050    "I0.USB1." */
    0x53,0x55,0x42,0x31,0x00,0x00,0x11,0x22,  /* 00000058    "SUB1..."" */
    0x33,0x44,0x55,0x66,0x77,0x01,0x01,0x24,  /* 00000060    "3DUfw..$" */
    0x00,0x10,0x00,0x20,0x00,0x10,0x00,0x04,  /* 00000068    "... ...." */
    0x00,0x14,0x00,0x10,0x00,0x11,0x22,0x33,  /* 00000070    "......"3" */
    0x44,0xEE,0xDD,0xCC,0xBB,0xAA,0x55,0x66,  /* 00000078    "D.....Uf" */
    0x77,0x88,0x99,0xAA,0xBB,0xCC,0xDD,0xEE,  /* 00000080    "w......." */
    0xFF                                      /* 00000088    "."        */
};

const unsigned char TemplateSlic[] =
{
    0x53,0x4C,0x49,0x43,0x76,0x01,0x00,0x00,  /* 00000000    "SLICv..." */
    0x01,0x07,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x11,0x02,0x11,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x9C,0x00,0x00,0x00,0x06,0x02,0x00,0x00,  /* 00000028    "........" */
    0x00,0x24,0x00,0x00,0x52,0x53,0x41,0x31,  /* 00000030    ".$..RSA1" */
    0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000098    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B8    "........" */
    0x01,0x00,0x00,0x00,0xB6,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x02,0x00,0x49,0x4E,0x54,0x45,  /* 000000C8    "....INTE" */
    0x4C,0x20,0x54,0x45,0x4D,0x50,0x4C,0x41,  /* 000000D0    "L TEMPLA" */
    0x54,0x45,0x57,0x49,0x4E,0x44,0x4F,0x57,  /* 000000D8    "TEWINDOW" */
    0x53,0x20,0x01,0x00,0x02,0x00,0x00,0x00,  /* 000000E0    "S ......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000E8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000F8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000100    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000108    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000110    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000118    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000120    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000128    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000130    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000138    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000140    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000148    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000150    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000158    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000160    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000168    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00             /* 00000170    "......"   */
};

const unsigned char TemplateSlit[] =
{
    0x53,0x4C,0x49,0x54,0xBC,0x01,0x00,0x00,  /* 00000000    "SLIT...." */
    0x01,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x16,0x03,0x11,0x20,0x14,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x0A,0x10,0x16,0x17,  /* 00000028    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 00000030    "........" */
    0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,  /* 00000038    " !"#$%&'" */
    0x10,0x0A,0x15,0x16,0x17,0x18,0x19,0x1A,  /* 00000040    "........" */
    0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,  /* 00000048    "..... !"" */
    0x23,0x24,0x25,0x26,0x16,0x15,0x0A,0x10,  /* 00000050    "#$%&...." */
    0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,  /* 00000058    "........" */
    0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,  /* 00000060    ".. !"#$%" */
    0x17,0x16,0x10,0x0A,0x15,0x16,0x17,0x18,  /* 00000068    "........" */
    0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,  /* 00000070    "....... " */
    0x21,0x22,0x23,0x24,0x18,0x17,0x16,0x15,  /* 00000078    "!"#$...." */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000080    "........" */
    0x1C,0x1D,0x1E,0x1F,0x20,0x21,0x22,0x23,  /* 00000088    ".... !"#" */
    0x19,0x18,0x17,0x16,0x10,0x0A,0x15,0x16,  /* 00000090    "........" */
    0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,  /* 00000098    "........" */
    0x1F,0x20,0x21,0x22,0x1A,0x19,0x18,0x17,  /* 000000A0    ". !"...." */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 000000A8    "........" */
    0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,0x20,0x21,  /* 000000B0    "...... !" */
    0x1B,0x1A,0x19,0x18,0x17,0x16,0x10,0x0A,  /* 000000B8    "........" */
    0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,  /* 000000C0    "........" */
    0x1D,0x1E,0x1F,0x20,0x1C,0x1B,0x1A,0x19,  /* 000000C8    "... ...." */
    0x18,0x17,0x16,0x15,0x0A,0x10,0x16,0x17,  /* 000000D0    "........" */
    0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,  /* 000000D8    "........" */
    0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,  /* 000000E0    "........" */
    0x10,0x0A,0x15,0x16,0x17,0x18,0x19,0x1A,  /* 000000E8    "........" */
    0x1B,0x1C,0x1D,0x1E,0x1E,0x1D,0x1C,0x1B,  /* 000000F0    "........" */
    0x1A,0x19,0x18,0x17,0x16,0x15,0x0A,0x10,  /* 000000F8    "........" */
    0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,  /* 00000100    "........" */
    0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,  /* 00000108    "........" */
    0x17,0x16,0x10,0x0A,0x15,0x16,0x17,0x18,  /* 00000110    "........" */
    0x19,0x1A,0x1B,0x1C,0x20,0x1F,0x1E,0x1D,  /* 00000118    ".... ..." */
    0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,0x15,  /* 00000120    "........" */
    0x0A,0x10,0x16,0x17,0x18,0x19,0x1A,0x1B,  /* 00000128    "........" */
    0x21,0x20,0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,  /* 00000130    "! ......" */
    0x19,0x18,0x17,0x16,0x10,0x0A,0x15,0x16,  /* 00000138    "........" */
    0x17,0x18,0x19,0x1A,0x22,0x21,0x20,0x1F,  /* 00000140    "...."! ." */
    0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,  /* 00000148    "........" */
    0x16,0x15,0x0A,0x10,0x16,0x17,0x18,0x19,  /* 00000150    "........" */
    0x23,0x22,0x21,0x20,0x1F,0x1E,0x1D,0x1C,  /* 00000158    "#"! ...." */
    0x1B,0x1A,0x19,0x18,0x17,0x16,0x10,0x0A,  /* 00000160    "........" */
    0x15,0x16,0x17,0x18,0x24,0x23,0x22,0x21,  /* 00000168    "....$#"!" */
    0x20,0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,  /* 00000170    " ......." */
    0x18,0x17,0x16,0x15,0x0A,0x10,0x16,0x17,  /* 00000178    "........" */
    0x25,0x24,0x23,0x22,0x21,0x20,0x1F,0x1E,  /* 00000180    "%$#"! .." */
    0x1D,0x1C,0x1B,0x1A,0x19,0x18,0x17,0x16,  /* 00000188    "........" */
    0x10,0x0A,0x15,0x16,0x26,0x25,0x24,0x23,  /* 00000190    "....&%$#" */
    0x22,0x21,0x20,0x1F,0x1E,0x1D,0x1C,0x1B,  /* 00000198    ""! ....." */
    0x1A,0x19,0x18,0x17,0x16,0x15,0x0A,0x10,  /* 000001A0    "........" */
    0x27,0x26,0x25,0x24,0x23,0x22,0x21,0x20,  /* 000001A8    "'&%$#"! " */
    0x1F,0x1E,0x1D,0x1C,0x1B,0x1A,0x19,0x18,  /* 000001B0    "........" */
    0x17,0x16,0x10,0x0A                       /* 000001B8    "...."     */
};

const unsigned char TemplateSpcr[] =
{
    0x53,0x50,0x43,0x52,0x5A,0x00,0x00,0x00,  /* 00000000    "SPCRZ..." */
    0x04,0x4E,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x02,0x00,0x58,0x00,  /* 00000050    "......X." */
    0x2E,0x00                                 /* 00000058    ".." */
};

const unsigned char TemplateSpmi[] =
{
    0x53,0x50,0x4D,0x49,0x41,0x00,0x00,0x00,  /* 00000000    "SPMIA..." */
    0x04,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x14,0x01,0x14,0x20,0x00,0x01,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x08,0x00,0x01,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00                                      /* 00000040    "."        */
};

const unsigned char TemplateSrat[] =
{
    0x53,0x52,0x41,0x54,0xD2,0x00,0x00,0x00,  /* 00000000    "SRAT...." */
    0x03,0xB6,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x29,0x06,0x18,0x20,0x01,0x00,0x00,0x00,  /* 00000020    ").. ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x10,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x01,0x28,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    ".(......" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0xFC,0x09,0x00,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x02,0x18,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000078    "........" */
    0x03,0x12,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000080    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 00000088    "........" */
    0x00,0x00,0x04,0x0C,0x00,0x00,0x00,0x00,  /* 00000090    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x20,  /* 00000098    "....... " */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000A8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000B0    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x14,  /* 000000B8    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 000000C0    "........" */
    0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 000000C8    "........" */
    0x00,0x00                                 /* 000000D0    ".."       */
};

const unsigned char TemplateStao[] =
{
    0x53,0x54,0x41,0x4F,0x7E,0x00,0x00,0x00,  /* 00000000    "STAO~..." */
    0x01,0x7F,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x01,0x5C,0x5F,0x53,  /* 00000020    "... .\_S" */
    0x42,0x30,0x2E,0x42,0x55,0x53,0x30,0x2E,  /* 00000028    "B0.BUS0." */
    0x44,0x45,0x56,0x31,0x00,0x5C,0x5F,0x53,  /* 00000030    "DEV1.\_S" */
    0x42,0x30,0x2E,0x42,0x55,0x53,0x30,0x2E,  /* 00000038    "B0.BUS0." */
    0x44,0x45,0x56,0x32,0x00,0x5C,0x5F,0x53,  /* 00000040    "DEV2.\_S" */
    0x42,0x30,0x2E,0x42,0x55,0x53,0x31,0x2E,  /* 00000048    "B0.BUS1." */
    0x44,0x45,0x56,0x31,0x2E,0x44,0x45,0x56,  /* 00000050    "DEV1.DEV" */
    0x32,0x00,0x5C,0x5F,0x53,0x42,0x30,0x2E,  /* 00000058    "2.\_SB0." */
    0x42,0x55,0x53,0x31,0x2E,0x44,0x45,0x56,  /* 00000060    "BUS1.DEV" */
    0x32,0x2E,0x44,0x45,0x56,0x32,0x00,0x5C,  /* 00000068    "2.DEV2.\" */
    0x55,0x53,0x42,0x31,0x2E,0x48,0x55,0x42,  /* 00000070    "USB1.HUB" */
    0x31,0x2E,0x50,0x54,0x31,0x00             /* 00000078    "1.PT1."   */
};

const unsigned char TemplateSvkl[] =
{
    0x53,0x56,0x4B,0x4C,0x48,0x00,0x00,0x00,  /* 00000000    "SVKLH..." */
    0x04,0xDB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x31,0x03,0x21,0x20,0x02,0x00,0x00,0x00,  /* 00000020    "1.! ...." */
    0x00,0x00,0x00,0x00,0x21,0x43,0xAA,0xAA,  /* 00000028    "....!C.." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01,  /* 00000030    "....gE#." */
    0x00,0x00,0x00,0x00,0x21,0x43,0xBB,0xBB,  /* 00000038    "....!C.." */
    0xEF,0xCD,0xAB,0x89,0x67,0x45,0x23,0x01   /* 00000040    "....gE#." */
};

const unsigned char TemplateTcpa[] =
{
    0x54,0x43,0x50,0x41,0x64,0x00,0x00,0x00,  /* 00000000    "TCPAd..." */
    0x02,0xFF,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x80,0x31,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    ".1..INTL" */
    0x19,0x06,0x15,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x11,0x00,0xFF,0xEE,0xDD,0xCC,0xBB,0xAA,  /* 00000030    "........" */
    0x02,0x01,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x03,  /* 00000040    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x03,  /* 00000050    "..... .." */
    0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "........" */
    0x01,0x01,0x01,0x01                       /* 00000060    "...."     */
};

const unsigned char TemplateTdel[] =
{
    0x54,0x44,0x45,0x4C,0x38,0x00,0x00,0x00,  /* 00000000    "TDEL8..." */
    0x04,0x1C,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x30,0x09,0x21,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "0.! ...." */
    0xEF,0xCD,0xAB,0x78,0x56,0x34,0x12,0x00,  /* 00000028    "...xV4.." */
    0x78,0x56,0x34,0x12,0xEF,0xCD,0xAB,0x00   /* 00000030    "xV4....." */
};

const unsigned char TemplateTpm2[] =
{
    0x54,0x50,0x4D,0x32,0x4C,0x00,0x00,0x00,  /* 00000000    "TPM2L..." */
    0x04,0xCB,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x13,0x12,0x18,0x20,0x01,0x00,0x00,0x00,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x08,0x00,0x00,0x00,0x01,0x02,0x03,0x04,  /* 00000030    "........" */
    0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,  /* 00000038    "........" */
    0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "........" */
    0x00,0x00,0x00,0x00                       /* 00000048    "...."     */
};

const unsigned char TemplateUefi[] =
{
    0x55,0x45,0x46,0x49,0x36,0x00,0x00,0x00,  /* 00000000    "UEFI6..." */
    0x01,0x9B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x01,0x02,0x03,  /* 00000020    "(.. ...." */
    0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,  /* 00000028    "........" */
    0x0C,0x0D,0x0E,0x0F,0x00,0x00             /* 00000030    "......"   */
};

const unsigned char TemplateViot[] =
{
    0x56,0x49,0x4F,0x54,0x80,0x00,0x00,0x00,  /* 00000000    "VIOT...." */
    0x00,0x52,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".RINTEL " */
    0x54,0x65,0x6D,0x70,0x6C,0x61,0x74,0x65,  /* 00000010    "Template" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x05,0x01,0x21,0x20,0x04,0x00,0x30,0x00,  /* 00000020    "..! ..0." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x01,0x00,0x18,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,  /* 00000038    "........" */
    0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000040    "`......." */
    0x02,0x00,0x18,0x00,0x00,0x00,0x01,0x00,  /* 00000048    "........" */
    0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,  /* 00000050    "........" */
    0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000058    "p......." */
    0x03,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000060    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000068    "........" */
    0x04,0x00,0x10,0x00,0x00,0x00,0x00,0x00,  /* 00000070    "........" */
    0x00,0x00,0x00,0x1D,0x00,0x00,0x00,0x00   /* 00000078    "........" */
};

const unsigned char TemplateWaet[] =
{
    0x57,0x41,0x45,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "WAET(..." */
    0x01,0x19,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00   /* 00000020    "(.. ...." */
};

const unsigned char TemplateWdat[] =
{
    0x57,0x44,0x41,0x54,0x5C,0x00,0x00,0x00,  /* 00000000    "WDAT\..." */
    0x01,0xE3,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x20,0x00,0x00,0x00,  /* 00000020    "(..  ..." */
    0xFF,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,  /* 00000028    "........" */
    0x58,0x02,0x00,0x00,0xFF,0x03,0x00,0x00,  /* 00000030    "X......." */
    0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000038    "........" */
    0x0E,0x00,0x00,0x00,0x01,0x02,0x00,0x00,  /* 00000040    "........" */
    0x01,0x10,0x00,0x02,0x60,0x04,0x00,0x00,  /* 00000048    "....`..." */
    0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,  /* 00000050    "........" */
    0x01,0x00,0x00,0x00                       /* 00000058    "...."     */
};

const unsigned char TemplateWddt[] =
{
    0x57,0x44,0x44,0x54,0x40,0x00,0x00,0x00,  /* 00000000    "WDDT@..." */
    0x01,0x00,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x01,0xFF,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    "........" */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00   /* 00000038    "........" */
};

const unsigned char TemplateWdrt[] =
{
    0x57,0x44,0x52,0x54,0x47,0x00,0x00,0x00,  /* 00000000    "WDRTG..." */
    0x01,0xB0,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x00,0x20,0x00,0x00,  /* 00000020    "(.. . .." */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000028    "........" */
    0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 00000030    ". ......" */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,  /* 00000038    "........" */
    0x00,0x00,0x00,0x00,0xFF,0xFF,0x00        /* 00000040    "......."  */
};

const unsigned char TemplateWpbt[] =
{
    0x57,0x50,0x42,0x54,0x98,0x00,0x00,0x00,  /* 00000000    "WPBT...." */
    0x01,0x83,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x78,0x56,0x34,0x12,  /* 00000020    "... xV4." */
    0x00,0x00,0x00,0xBB,0x00,0x00,0x00,0xAA,  /* 00000028    "........" */
    0x33,0x88,0x64,0x00,0x34,0x00,0x20,0x00,  /* 00000030    "3.d.4. ." */
    0x73,0x00,0x63,0x00,0x6F,0x00,0x72,0x00,  /* 00000038    "s.c.o.r." */
    0x65,0x00,0x20,0x00,0x61,0x00,0x6E,0x00,  /* 00000040    "e. .a.n." */
    0x64,0x00,0x20,0x00,0x37,0x00,0x20,0x00,  /* 00000048    "d. .7. ." */
    0x79,0x00,0x65,0x00,0x61,0x00,0x72,0x00,  /* 00000050    "y.e.a.r." */
    0x73,0x00,0x20,0x00,0x61,0x00,0x67,0x00,  /* 00000058    "s. .a.g." */
    0x6F,0x00,0x20,0x00,0x6F,0x00,0x75,0x00,  /* 00000060    "o. .o.u." */
    0x72,0x00,0x20,0x00,0x66,0x00,0x61,0x00,  /* 00000068    "r. .f.a." */
    0x74,0x00,0x68,0x00,0x65,0x00,0x72,0x00,  /* 00000070    "t.h.e.r." */
    0x73,0x00,0x20,0x00,0x62,0x00,0x72,0x00,  /* 00000078    "s. .b.r." */
    0x6F,0x00,0x75,0x00,0x67,0x00,0x68,0x00,  /* 00000080    "o.u.g.h." */
    0x74,0x00,0x20,0x00,0x66,0x00,0x6F,0x00,  /* 00000088    "t. .f.o." */
    0x72,0x00,0x74,0x00,0x68,0x00,0x00,0x00   /* 00000090    "r.t.h..." */
};

const unsigned char TemplateWsmt[] =
{
    0x57,0x53,0x4D,0x54,0x28,0x00,0x00,0x00,  /* 00000000    "WSMT(..." */
    0x00,0x08,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x00,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x19,0x01,0x17,0x20,0x05,0x00,0x00,0x00   /* 00000020    "... ...." */
};

const unsigned char TemplateXenv[] =
{
    0x58,0x45,0x4E,0x56,0x39,0x00,0x00,0x00,  /* 00000000    "XENV9..." */
    0x01,0x3A,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    ".:INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x10,0x04,0x15,0x20,0x00,0x00,0x00,0x10,  /* 00000020    "... ...." */
    0x00,0x00,0x00,0x0A,0x00,0x20,0x00,0x00,  /* 00000028    "..... .." */
    0x00,0x00,0x00,0x0B,0x25,0x00,0xBB,0xAA,  /* 00000030    "....%..." */
    0x03                                      /* 00000038    "."        */
};

const unsigned char TemplateXsdt[] =
{
    0x58,0x53,0x44,0x54,0x64,0x00,0x00,0x00,  /* 00000000    "XSDTd..." */
    0x01,0x8B,0x49,0x4E,0x54,0x45,0x4C,0x20,  /* 00000008    "..INTEL " */
    0x54,0x45,0x4D,0x50,0x4C,0x41,0x54,0x45,  /* 00000010    "TEMPLATE" */
    0x01,0x00,0x00,0x00,0x49,0x4E,0x54,0x4C,  /* 00000018    "....INTL" */
    0x28,0x05,0x10,0x20,0x10,0x00,0x00,0x00,  /* 00000020    "(.. ...." */
    0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,  /* 00000028    ".... ..." */
    0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,  /* 00000030    "....0..." */
    0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,  /* 00000038    "....@..." */
    0x00,0x00,0x00,0x00,0x50,0x00,0x00,0x00,  /* 00000040    "....P..." */
    0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,  /* 00000048    "....`..." */
    0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,  /* 00000050    "....p..." */
    0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,  /* 00000058    "........" */
    0x00,0x00,0x00,0x00                       /* 00000060    "...."     */
};

#endif
