# position_telemetry_dialog.py
#
# Copyright 2024 Christopher Talbot
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Adw
from gi.repository import Gtk
import gettext
import meshtastic.mesh_interface
import meshtastic
import os
import base64

import gtk_meshtastic_client.connection_page
import gtk_meshtastic_client.utils as utils

@Gtk.Template(resource_path='/org/kop316/meshtastic/ui/preferences_dialog.ui')
class PreferencesDialog(Adw.PreferencesDialog):
    __gtype_name__ = 'PreferencesDialog'

    print_packets_row = Gtk.Template.Child()
    log_packets_row = Gtk.Template.Child()
    return_sends_message_row = Gtk.Template.Child()
    quit_if_connected_row = Gtk.Template.Child()
    gps_socket_row = Gtk.Template.Child()

    @Gtk.Template.Callback()
    def _cancel_button_clicked_cb(self, button):
        self.close()

    @Gtk.Template.Callback()
    def _save_button_clicked_cb(self, button):
        app = Gtk.Application.get_default()
        app.app_settings.set_print_packets(self.print_packets_row.get_active())
        app.app_settings.set_log_packets(self.log_packets_row.get_active())
        app.app_settings.set_return_sends_message(self.return_sends_message_row.get_active())
        app.app_settings.set_quit_if_connected(self.quit_if_connected_row.get_active())
        app.app_settings.set_create_gps_socket(self.gps_socket_row.get_active())
        self.close()


    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        app = Gtk.Application.get_default()

        self.logger = app.logger
        self.print_packets_row.set_active(app.app_settings.get_print_packets())
        self.log_packets_row.set_active(app.app_settings.get_log_packets())
        self.return_sends_message_row.set_active(app.app_settings.get_return_sends_message())
        self.quit_if_connected_row.set_active(app.app_settings.get_quit_if_connected())
        self.gps_socket_row.set_active(app.app_settings.get_create_gps_socket())
