/*
* Copyright (c) 2023, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     media_user_setting_specific.h
//! \brief    media user setting specific
//!

#ifndef __MEDIA_USER_SETTING_SPECIFIC_H__
#define __MEDIA_USER_SETTING_SPECIFIC_H__

#include "media_user_setting.h"
#include "mos_utilities.h"

inline MOS_STATUS UserFeatureReadValue(
    PMOS_USER_FEATURE_INTERFACE     pOsUserFeatureInterface,
    uint32_t                        valueID,
    PMOS_USER_FEATURE_VALUE_DATA    pValueData,
    MOS_CONTEXT_HANDLE              mosCtx)
{
    return MosUtilities::MosUserFeatureReadValueID(pOsUserFeatureInterface, valueID, pValueData, mosCtx);
}

inline MOS_STATUS UserFeatureWriteValue(
    PMOS_USER_FEATURE_INTERFACE         pOsUserFeatureInterface,
    PMOS_USER_FEATURE_VALUE_WRITE_DATA  pWriteValues,
    uint32_t                            uiNumOfValues,
    MOS_CONTEXT_HANDLE                  mosCtx)
{
    return MosUtilities::MosUserFeatureWriteValuesID(pOsUserFeatureInterface, pWriteValues, uiNumOfValues, mosCtx);
}
#endif