#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;
use Date::Calc;
use CGI;

use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';
require 'Functions/FakeFunctions.pl';
require 'Functions/DateTime.pl';

require 'Functions/_HeartBeat.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our %miss = ();	# 
our $cgi = '';	#

LoadConfig();

$conf{'refresh'} = int( $conf{'refresh'} );
if ( $conf{'refresh'} < 15 ) {$conf{'refresh'} = 15;};

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "refresh: $conf{'refresh'};\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

$cgi = CGI->new();

our $PageTitle = ' - Heart Beat';
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

my $default_heartbeat_nb = $conf{'heartbeat_nb'} || 48;
my $default_max_error_count = $conf{'heartbeat_max_error_count'} || 10;
my $default_delta = $conf{'heartbeat_delta'} || 3600;
my $default_error_margin = $conf{'heartbeat_error_margin'} || 6;

print "<table class=\"bordered\" border=\"0\" align=\"center\" width=\"95%\">\n";

print "<tr>";
print "<td width=\"3%\">&nbsp;</td>";
print "<td align=\"center\" width=\"5%\"><b>AnalyzerId</b></td>";
print "<td align=\"center\" width=\"5%\"><b>Model</b></td>";
print "<td align=\"center\"><b>Name</b></td>";
print "<td align=\"center\"><b>Location</b></td>";
print "<td align=\"center\" width=\"10%\"><b>Address</b></td>";
print "<td align=\"center\" width=\"10%\"><b>DeltaT</b></td>";
print "<td align=\"center\" width=\"12%\"><b>Latest&nbsp;Heart&nbsp;Beat</b></td>";
print "</tr>\n";

my $sql = "SELECT analyzerid,model FROM Prelude_Analyzer WHERE parent_type='H' GROUP BY analyzerid;";
my $sth = $dbh->prepare( $sql );
$sth->execute();
while( my ( $AnalyzerId, $Model ) = $sth->fetchrow_array() )
{
	$Model =~ s/Log Monitoring Lackey/LML/;
	$Model =~ s/\s/&nbsp;/g;

	print "<tr><td colspan=\"8\">&nbsp;</td></tr>\n";

	my $sql;
	my $sth;

	$sql = "SELECT * FROM Prelude_Analyzer WHERE parent_type='H' AND analyzerid=? ORDER BY parent_ident DESC LIMIT 1;";
	$sth = $dbh->prepare( $sql );
	$sth->execute( $AnalyzerId );
	my $HashRef = $sth->fetchrow_hashref();
	my $HeartBeatId = $HashRef->{'parent_ident'};
	$sth->finish();

	$sql = "SELECT time FROM Prelude_CreateTime WHERE parent_type='H' AND parent_ident=?;";
	$sth = $dbh->prepare( $sql );
	$sth->execute( $HeartBeatId );
	my $Time = $sth->fetchrow_array();
	$sth->finish();

	$sql = "SELECT * FROM Prelude_Node WHERE parent_type='H' AND alert_ident=?;";
	$sth = $dbh->prepare( $sql );
	$sth->execute( $HeartBeatId );
	$HashRef = $sth->fetchrow_hashref();
	$sth->finish();

	my $Location = $HashRef->{'location'};
	my $Name = $HashRef->{'name'};
	$Location = ( $Location?$Location:'n/a' );
	$Name = ( $Name?$Name:'n/a' );

	$sql = "SELECT address FROM Prelude_Address WHERE parent_type='H' AND alert_ident=?;";
	$sth = $dbh->prepare( $sql );
	$sth->execute( $HeartBeatId );
	my $Address;
	while ( my $address = $sth->fetchrow_array() )
	{
		if ( $Address )
		{
			$Address .= '<br>'.$address;
		}
		else
		{
			$Address = $address;
		}
	}
	$sth->finish();
	if ( ! $Address ) {$Address = 'n/a';};

	#

	my $OldTime = '';
	my $OldTime2 = 0;

	my $errcount = 0;

	$sql = "SELECT parent_ident FROM Prelude_Analyzer WHERE analyzerid=? AND parent_type='H' ORDER BY parent_ident DESC LIMIT $default_heartbeat_nb;";
	$sth = $dbh->prepare( $sql );
	$sth->execute( $AnalyzerId );

	debug( $sql );

	my @Styles = ( 'odd', 'even' );

	while( ( my $HeartBeatId = $sth->fetchrow_array() ) and ( $errcount < $default_max_error_count ) )
	{
		my $sql = "SELECT time,";
		if ( $conf{'dbtype'} =~ m/^mysql$/i ) {$sql .= 'UNIX_TIMESTAMP(time)+';};
		$sql .= "0 FROM Prelude_CreateTime WHERE parent_ident=? AND parent_type='H';";
		my $sth = $dbh->prepare( $sql );
		$sth->execute( $HeartBeatId );
		my ( $Time, $Time2 ) = $sth->fetchrow_array();
		$sth->finish();

		if ( $conf{'dbtype'} =~ m/^pg$/i )
		{
			  # Possible bug in prelude-manager (space missing between Date & time in timestamp)
			$Time =~ s/(\d{4}-\d{2}-\d{2})\s?(\d{2}:\d{2}:\d{2})/$1 $2/;

			  # Timestamp (AAAA-MM-DD HH:MM:SS) to EPOCH :
			my @Values = split( /\s|[^\d]/, $Time );
			$Time2 = $Values[5];
			$Time2 += $Values[4]*60;
			$Time2 += $Values[3]*60*60;
			$Time2 += $Values[2]*60*60*24;
			$Time2 += $Values[1]*60*60*24*(365.25/12);
			$Time2 += $Values[0]*60*60*24*365.25;
		}

		if ( $OldTime2 )
		{
			my $DeltaS = $OldTime2 - $Time2;
			my $DeltaHMS = convert_s2hms( $DeltaS );

			if ( $DeltaS < ( $default_delta - $default_error_margin ) )
			{
				print "<tr><td colspan=\"8\" class=\"$Styles[$errcount % 2]\">Sensor was restarted prematurely on ".GMT_to_LocalTime($OldTime)." (after $DeltaHMS)</td></tr>\n";
				$errcount ++;
			}
			else
			{
				if ( $DeltaS > ( $default_delta + $default_error_margin ) )
				{
					print "<tr><td colspan=\"8\" class=\"$Styles[$errcount % 2]\">Sensor went down after ".GMT_to_LocalTime($Time)." and went back online on ".GMT_to_LocalTime($OldTime)."</td></tr>\n";
					$errcount ++;
				}
				else
				{
					if ( $conf{'debug'} )
					{
						print "<tr><td colspan=\"8\" class=\"$Styles[$errcount % 2]\">Debug : Sensor said hello on time around ".GMT_to_LocalTime($OldTime)."</td></tr>\n";
					}
				}
			}
		}
		else
		{
			my $Offline = 0;
			my $DeltaS = ( time() - $conf{'GMTdiff'} * 3600 ) - $Time2;
			if ( $DeltaS > ($default_delta+$default_error_margin) ) {$Offline = 1;};

			print "<tr>";
			print "<td><img src=\"images/";
			if ( $Offline )
			{
				print 'high';
			}
			else
			{
				print 'low';
			}
			print ".gif\"></td>";
			print "<td>$AnalyzerId</td>";
			print "<td>$Model</td>";
			print "<td align=\"center\">$Name</td>";
			print "<td align=\"center\">$Location</td>";
			print "<td align=\"center\">$Address</td>";
			print "<td align=\"center\">$default_delta&nbsp;s&nbsp;(+/-&nbsp;".($default_error_margin/2)."&nbsp;s)&nbsp;&nbsp;</td>";
			print "<td>".GMT_to_LocalTime($Time)."</td>";
			print "</tr>\n";

			if ( $Offline )
			{
				print "<tr><td colspan=\"8\" class=\"$Styles[$errcount % 2]\">Sensor went down after ".GMT_to_LocalTime($Time)." and is still offline</td></tr>\n";
				$errcount ++;
			}
		}

		$OldTime = $Time;
		$OldTime2 = $Time2;
	}
	$sth->finish();

	if ( ! $errcount )
	{
		print "<tr><td colspan=\"8\" class=\"$Styles[0]\">No anomaly in the last $default_heartbeat_nb hearbeats (1 heartbeat every $default_delta s average)</td></tr>\n";
	}
}
$sth->finish();

print "</table>\n";

ParseComponent( 'CommonFooter' );
