# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GraphParameterLink(Model):
    """Association link for a graph global parameter to a node in the graph.

    :param node_id: The graph node's identifier
    :type node_id: str
    :param parameter_key: The identifier of the node parameter that the global
     parameter maps to.
    :type parameter_key: str
    """

    _validation = {
        'node_id': {'required': True},
        'parameter_key': {'required': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'parameter_key': {'key': 'parameterKey', 'type': 'str'},
    }

    def __init__(self, node_id, parameter_key):
        self.node_id = node_id
        self.parameter_key = parameter_key
