////////////////////////////////////////////////////////////////
//
// Copyright (C) 2005 Affymetrix, Inc.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License 
// (version 2.1) as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
// for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
//
////////////////////////////////////////////////////////////////


#ifndef _AffymetrixFusionArrayFile_HEADER_
#define _AffymetrixFusionArrayFile_HEADER_

/*! \file FusionArrayFileReader.h This file provides fusion classes for reading array files. */

#include "calvin_files/array/src/ArrayData.h"
//
#include <cstring>
#include <string>
//

namespace affymetrix_fusion_io
{

/*! This class provides the fusion parsing interfaces for reading array files.
 *
 * The array files can be one of the following:
 *  MAS5 EXP files
 *  MAGE-ML XML files generated by the DTT version 1.1 software
 *  MAGE-ML XML files generated by the GDAC Exporter SDK
 *
 * In all cases the parser will populate an array data object.
 */
class FusionArrayFileReader 
{
protected:

	/*! An identifier to the type of data stored in the file */
	affymetrix_calvin_utilities::AffymetrixGuidType dataTypeIdentifier;

public:
	/*! Constructor */
    FusionArrayFileReader();

	/*! Destructor */
    ~FusionArrayFileReader();

	/*! Reads the entire contents of the file.
	 * @param fileName The name of the array file to read.
	 * @param arrayData The array data to read from the file.
	 */
	bool Read(const std::string &fileName, affymetrix_calvin_array::ArrayData &arrayData);

	/*! The identifier of the type of data stored in the file.
	 * @return The identifier of the type of data.
	 */
	const affymetrix_calvin_utilities::AffymetrixGuidType &DataTypeIdentifier() const { return dataTypeIdentifier; }

};

};
#endif // _AffymetrixFusionArrayFile_HEADER_
