////////////////////////////////////////////////////////////////
//
// Copyright (C) 2005 Affymetrix, Inc.
//
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License 
// (version 2.1) as published by the Free Software Foundation.
// 
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
// for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this library; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
//
////////////////////////////////////////////////////////////////


#ifndef _CELAlgorithmParameterNames_HEADER
#define _CELAlgorithmParameterNames_HEADER

/*! \file CELAlgorithmParameterNames.h This file defines a controlled vocabulary for some of the CEL algorithm parameter names.
*/

/*! Defines the cell margin algorithm parameter name. Type: int32_t */
#define CELLMARGIN_PARAM_NAME L"CellMargin"

/*! Defines the upper left corner x grid coordinate algorithm parameter name. Type: float */
#define GRIDULX_PARAM_NAME L"GridULX"

/*! Defines the upper left corner y grid coordinate algorithm parameter name. Type: float */
#define GRIDULY_PARAM_NAME L"GridULY"

/*! Defines the upper right corner x grid coordinate algorithm parameter name. Type: float */
#define GRIDURX_PARAM_NAME L"GridURX"

/*! Defines the upper right corner y grid coordinate algorithm parameter name. Type: float */
#define GRIDURY_PARAM_NAME L"GridURY"

/*! Defines the lower right corner x grid coordinate algorithm parameter name. Type: float */
#define GRIDLRX_PARAM_NAME L"GridLRX"

/*! Defines the lower right corner y grid coordinate algorithm parameter name. Type: float */
#define GRIDLRY_PARAM_NAME L"GridLRY"

/*! Defines the lower left corner x grid coordinate algorithm parameter name. Type: float */
#define GRIDLLX_PARAM_NAME L"GridLLX"

/*! Defines the lower left corner y grid coordinate algorithm parameter name. Type: float */
#define GRIDLLY_PARAM_NAME L"GridLLY"

#endif
