% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkR6.R
\name{checkR6}
\alias{checkR6}
\alias{check_r6}
\alias{assertR6}
\alias{assert_r6}
\alias{testR6}
\alias{test_r6}
\alias{expect_r6}
\title{Check if an argument is an R6 class}
\usage{
checkR6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE
)

check_r6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE
)

assertR6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_r6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE,
  .var.name = vname(x),
  add = NULL
)

testR6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE
)

test_r6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE
)

expect_r6(
  x,
  classes = NULL,
  ordered = FALSE,
  cloneable = NULL,
  public = NULL,
  private = NULL,
  null.ok = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{classes}{[\code{character}]\cr
Class names to check for inheritance with \code{\link[base]{inherits}}.
\code{x} must inherit from all specified classes.}

\item{ordered}{[\code{logical(1)}]\cr
Expect \code{x} to be specialized in provided order.
Default is \code{FALSE}.}

\item{cloneable}{[\code{logical(1)}]\cr
If \code{TRUE}, check that \code{x} has a \code{clone} method. If \code{FALSE}, ensure that
\code{x} is not cloneable.}

\item{public}{[\code{character}]\cr
Names of expected public slots. This includes active bindings.}

\item{private}{[\code{character}]\cr
Names of expected private slots.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertClass}/\code{assert_class} return 
 \code{x} invisibly, whereas
 \code{checkClass}/\code{check_class} and 
 \code{testClass}/\code{test_class} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertClass}/\code{assert_class}
 throws an error message, 
 \code{testClass}/\code{test_class}
 returns \code{FALSE},
 and \code{checkClass}/\code{check_class} 
 return a string with the error message.
 The function \code{expect_class} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is an R6 class
}
\examples{
library(R6)
generator = R6Class("Bar",
  public = list(a = 5),
  private = list(b = 42),
  active = list(c = function() 99)
)
x = generator$new()
checkR6(x, "Bar", cloneable = TRUE, public = "a")
}
\seealso{
Other classes: 
\code{\link{checkClass}()},
\code{\link{checkMultiClass}()}
}
\concept{classes}
