% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinner.R
\name{get_spinner}
\alias{get_spinner}
\title{Character vector to put a spinner on the screen}
\usage{
get_spinner(which = NULL)
}
\arguments{
\item{which}{The name of the chosen spinner. If \code{NULL}, then the default
is used, which can be customized via the \code{cli.spinner_unicode},
\code{cli.spinner_ascii} and \code{cli.spinner} options. (The latter applies to
both Unicode and ASCII displays. These options can be set to the name
of a built-in spinner, or to a list that has an entry called \code{frames},
a character vector of frames.}
}
\value{
A list with entries: \code{name}, \code{interval}: the suggested update
interval in milliseconds and \code{frames}: the character vector of the
spinner's frames.
}
\description{
\code{cli} contains many different spinners, you choose one according to your
taste.
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(cli.spinner = "hearts")
fun <- function() \{
  cli_progress_bar("Spinning")
  for (i in 1:100) \{
    Sys.sleep(4/100)
    cli_progress_update()
  \}
\}
fun()
options(cli.spinner = NULL)
}\if{html}{\out{</div>}}

\if{html}{\figure{get-spinner.svg}}
}
\seealso{
Other spinners: 
\code{\link{demo_spinners}()},
\code{\link{list_spinners}()},
\code{\link{make_spinner}()}
}
\concept{spinners}
