% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week-year-week-day.R
\name{year-week-day-count-between}
\alias{year-week-day-count-between}
\alias{calendar_count_between.clock_year_week_day}
\title{Counting: year-week-day}
\usage{
\method{calendar_count_between}{clock_year_week_day}(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[clock_year_week_day]}

A pair of year-week-day vectors. These will be recycled to their
common size.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
This is an year-week-day method for the \code{\link[=calendar_count_between]{calendar_count_between()}}
generic. It counts the number of \code{precision} units between \code{start} and \code{end}
(i.e., the number of years).
}
\examples{
# Compute the number of whole years between two dates
x <- year_week_day(2001, 1, 2)
y <- year_week_day(2021, 1, c(1, 3))
calendar_count_between(x, y, "year")
}
