% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmcProbabilistic.R
\name{is.TimeReversible}
\alias{is.TimeReversible}
\title{checks if ctmc object is time reversible}
\usage{
is.TimeReversible(ctmc)
}
\arguments{
\item{ctmc}{a ctmc-class object}
}
\value{
Returns a boolean value stating whether ctmc object is time reversible

a boolean value as described above
}
\description{
The function returns checks if provided function is time reversible
}
\examples{
energyStates <- c("sigma", "sigma_star")
byRow <- TRUE
gen <- matrix(data = c(-3, 3,
                       1, -1), nrow = 2,
              byrow = byRow, dimnames = list(energyStates, energyStates))
molecularCTMC <- new("ctmc", states = energyStates, 
                     byrow = byRow, generator = gen, 
                     name = "Molecular Transition Model")
is.TimeReversible(molecularCTMC)

}
\references{
INTRODUCTION TO STOCHASTIC PROCESSES WITH R, ROBERT P. DOBROW, Wiley
}
\author{
Vandit Jain
}
