% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-numeric.R
\name{transform_log}
\alias{transform_log}
\alias{transform_log10}
\alias{transform_log2}
\alias{transform_log1p}
\alias{log_trans}
\alias{log10_trans}
\alias{log2_trans}
\alias{log1p_trans}
\alias{transform_pseudo_log}
\alias{pseudo_log_trans}
\title{Log transformations}
\usage{
transform_log(base = exp(1))

transform_log10()

transform_log2()

transform_log1p()

log_trans(base = exp(1))

log10_trans()

log2_trans()

log1p_trans()

transform_pseudo_log(sigma = 1, base = exp(1))

pseudo_log_trans(sigma = 1, base = exp(1))
}
\arguments{
\item{base}{base of logarithm}

\item{sigma}{Scaling factor for the linear part of pseudo-log transformation.}
}
\description{
\itemize{
\item \code{transform_log()}: \code{log(x)}
\item \code{log1p()}: \code{log(x + 1)}
\item \code{transform_pseudo_log()}:  smoothly transition to linear scale around 0.
}
}
\examples{
plot(transform_log2(), xlim = c(0, 5))
plot(transform_log(), xlim = c(0, 5))
plot(transform_log10(), xlim = c(0, 5))

plot(transform_log(), xlim = c(0, 2))
plot(transform_log1p(), xlim = c(-1, 1))

# The pseudo-log is defined for all real numbers
plot(transform_pseudo_log(), xlim = c(-5, 5))
lines(transform_log(), xlim = c(0, 5), col = "red")

# For large positives numbers it's very close to log
plot(transform_pseudo_log(), xlim = c(1, 20))
lines(transform_log(), xlim = c(1, 20), col = "red")
}
