// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ..
// from ../gir-files
// DO NOT EDIT

use crate::{LockscreenManager,ScreenshotManager};
use glib::{prelude::*,signal::{connect_raw, SignalHandlerId},translate::*};
use std::{boxed::Box as Box_};

glib::wrapper! {
    #[doc(alias = "PhoshShell")]
    pub struct Shell(Object<ffi::PhoshShell, ffi::PhoshShellClass>);

    match fn {
        type_ => || ffi::phosh_shell_get_type(),
    }
}

impl Shell {
        pub const NONE: Option<&'static Shell> = None;
    

    #[doc(alias = "phosh_shell_new")]
    pub fn new() -> Shell {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::phosh_shell_new())
        }
    }

            // rustdoc-stripper-ignore-next
            /// Creates a new builder-pattern struct instance to construct [`Shell`] objects.
            ///
            /// This method returns an instance of [`ShellBuilder`](crate::builders::ShellBuilder) which can be used to create [`Shell`] objects.
            pub fn builder() -> ShellBuilder {
                ShellBuilder::new()
            }
        

    #[doc(alias = "phosh_shell_get_default")]
    #[doc(alias = "get_default")]
    #[allow(clippy::should_implement_trait)]    pub fn default() -> Shell {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_none(ffi::phosh_shell_get_default())
        }
    }
}

impl Default for Shell {
                     fn default() -> Self {
                         Self::new()
                     }
                 }

// rustdoc-stripper-ignore-next
        /// A [builder-pattern] type to construct [`Shell`] objects.
        ///
        /// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ShellBuilder {
            builder: glib::object::ObjectBuilder<'static, Shell>,
        }

        impl ShellBuilder {
        fn new() -> Self {
            Self { builder: glib::object::Object::builder() }
        }

                            pub fn docked(self, docked: bool) -> Self {
                            Self { builder: self.builder.property("docked", docked), }
                        }

                            pub fn locked(self, locked: bool) -> Self {
                            Self { builder: self.builder.property("locked", locked), }
                        }

                            pub fn overview_visible(self, overview_visible: bool) -> Self {
                            Self { builder: self.builder.property("overview-visible", overview_visible), }
                        }

    // rustdoc-stripper-ignore-next
    /// Build the [`Shell`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Shell {
    self.builder.build() }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Shell>> Sealed for T {}
}

pub trait ShellExt: IsA<Shell> + sealed::Sealed + 'static {
    #[doc(alias = "phosh_shell_fade_out")]
    fn fade_out(&self, timeout: u32) {
        unsafe {
            ffi::phosh_shell_fade_out(self.as_ref().to_glib_none().0, timeout);
        }
    }

    #[doc(alias = "phosh_shell_get_locked")]
    #[doc(alias = "get_locked")]
    fn is_locked(&self) -> bool {
        unsafe {
            from_glib(ffi::phosh_shell_get_locked(self.as_ref().to_glib_none().0))
        }
    }

    #[doc(alias = "phosh_shell_get_lockscreen_manager")]
    #[doc(alias = "get_lockscreen_manager")]
    fn lockscreen_manager(&self) -> LockscreenManager {
        unsafe {
            from_glib_none(ffi::phosh_shell_get_lockscreen_manager(self.as_ref().to_glib_none().0))
        }
    }

    #[doc(alias = "phosh_shell_get_lockscreen_type")]
    #[doc(alias = "get_lockscreen_type")]
    fn lockscreen_type(&self) -> glib::types::Type {
        unsafe {
            from_glib(ffi::phosh_shell_get_lockscreen_type(self.as_ref().to_glib_none().0))
        }
    }

    #[doc(alias = "phosh_shell_get_screenshot_manager")]
    #[doc(alias = "get_screenshot_manager")]
    fn screenshot_manager(&self) -> ScreenshotManager {
        unsafe {
            from_glib_none(ffi::phosh_shell_get_screenshot_manager(self.as_ref().to_glib_none().0))
        }
    }

    #[doc(alias = "phosh_shell_get_usable_area")]
    #[doc(alias = "get_usable_area")]
    fn usable_area(&self) -> (i32, i32, i32, i32) {
        unsafe {
            let mut x = std::mem::MaybeUninit::uninit();
            let mut y = std::mem::MaybeUninit::uninit();
            let mut width = std::mem::MaybeUninit::uninit();
            let mut height = std::mem::MaybeUninit::uninit();
            ffi::phosh_shell_get_usable_area(self.as_ref().to_glib_none().0, x.as_mut_ptr(), y.as_mut_ptr(), width.as_mut_ptr(), height.as_mut_ptr());
            (x.assume_init(), y.assume_init(), width.assume_init(), height.assume_init())
        }
    }

    #[doc(alias = "phosh_shell_set_default")]
    fn set_default(&self) {
        unsafe {
            ffi::phosh_shell_set_default(self.as_ref().to_glib_none().0);
        }
    }

    fn is_docked(&self) -> bool {
        ObjectExt::property(self.as_ref(), "docked")
    }

    fn set_docked(&self, docked: bool) {
        ObjectExt::set_property(self.as_ref(),"docked", docked)
    }

    fn set_locked(&self, locked: bool) {
        ObjectExt::set_property(self.as_ref(),"locked", locked)
    }

    #[doc(alias = "overview-visible")]
    fn is_overview_visible(&self) -> bool {
        ObjectExt::property(self.as_ref(), "overview-visible")
    }

    #[doc(alias = "overview-visible")]
    fn set_overview_visible(&self, overview_visible: bool) {
        ObjectExt::set_property(self.as_ref(),"overview-visible", overview_visible)
    }

    #[doc(alias = "ready")]
    fn connect_ready<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn ready_trampoline<P: IsA<Shell>, F: Fn(&P) + 'static>(this: *mut ffi::PhoshShell, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Shell::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"ready\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(ready_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "docked")]
    fn connect_docked_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_docked_trampoline<P: IsA<Shell>, F: Fn(&P) + 'static>(this: *mut ffi::PhoshShell, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Shell::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::docked\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(notify_docked_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "locked")]
    fn connect_locked_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_locked_trampoline<P: IsA<Shell>, F: Fn(&P) + 'static>(this: *mut ffi::PhoshShell, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Shell::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::locked\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(notify_locked_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[doc(alias = "overview-visible")]
    fn connect_overview_visible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_overview_visible_trampoline<P: IsA<Shell>, F: Fn(&P) + 'static>(this: *mut ffi::PhoshShell, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Shell::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::overview-visible\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(notify_overview_visible_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl<O: IsA<Shell>> ShellExt for O {}
