/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.cast;

import adql.db.DBType;
import adql.query.TextPosition;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.cast.StandardTargetType;
import adql.query.operand.function.cast.TargetType;

public class CustomTargetType
implements TargetType {
    protected String typeName;
    protected ADQLOperand[] parameters = null;
    protected DBType returnType = null;
    private TextPosition position = null;

    public CustomTargetType(String typeName) throws NullPointerException {
        this(typeName, null);
    }

    public CustomTargetType(String typeName, ADQLOperand[] parameters) {
        if (typeName == null || typeName.trim().isEmpty()) {
            throw new NullPointerException("Impossible to create a custom datatype without a datatype name!");
        }
        this.typeName = StandardTargetType.normalizeDatatype(typeName);
        try {
            this.returnType = new DBType(StandardTargetType.resolveDatatype(typeName));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (parameters == null || parameters.length == 0) {
            this.parameters = null;
        } else {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                throw new NullPointerException("The " + (i + 1) + "-th parameter of the custom datatype \"" + typeName + "\" is NULL! Null parameters are forbidden inside custom datatype definition.");
            }
            this.parameters = parameters;
        }
    }

    @Override
    public final String getName() {
        return this.typeName;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    @Override
    public final void setPosition(TextPosition newPosition) {
        this.position = newPosition;
    }

    @Override
    public boolean isNumeric() {
        return this.returnType != null ? this.returnType.isNumeric() : true;
    }

    @Override
    public boolean isString() {
        return this.returnType != null ? this.returnType.isString() : true;
    }

    @Override
    public boolean isGeometry() {
        return this.returnType != null ? this.returnType.isGeometry() : true;
    }

    @Override
    public final DBType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(DBType newType) {
        this.returnType = newType;
    }

    @Override
    public int getNbParameters() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return this.parameters == null ? new ADQLOperand[]{} : (ADQLOperand[])this.parameters.clone();
    }

    @Override
    public ADQLOperand getParameter(int indParam) {
        if (this.parameters == null || indParam < 0 || indParam >= this.parameters.length) {
            throw new IndexOutOfBoundsException("Incorrect parameter index: " + indParam + "! Nb max. parameters: " + (this.parameters == null ? 0 : this.parameters.length) + ".");
        }
        return this.parameters[indParam];
    }

    @Override
    public ADQLOperand setParameter(int indParam, ADQLOperand newParam) {
        if (this.parameters == null || indParam < 0 || indParam >= this.parameters.length) {
            throw new IndexOutOfBoundsException("Incorrect parameter index: " + indParam + "! Nb max. parameters: " + (this.parameters == null ? 0 : this.parameters.length) + ".");
        }
        if (newParam == null) {
            throw new NullPointerException("Impossible to remove a custom datatype's parameter!");
        }
        ADQLOperand oldParam = this.parameters[indParam];
        this.parameters[indParam] = newParam;
        return oldParam;
    }

    @Override
    public String toADQL() {
        if (this.parameters == null) {
            return this.typeName;
        }
        StringBuilder adql = new StringBuilder(this.typeName);
        adql.append('(');
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                adql.append(',').append(' ');
            }
            adql.append(this.parameters[i].toADQL());
        }
        adql.append(')');
        return adql.toString();
    }

    @Override
    public TargetType getCopy() throws Exception {
        return new CustomTargetType(this.typeName, this.getParameters());
    }

    public String toString() {
        return this.toADQL();
    }
}

