Tag: multi-arch-same-package-calls-pycompile
Severity: warning
Check: scripts
Explanation: This <code>Multi-Arch: same</code> package uses <code>pycompile</code> or
 <code>py3compile</code> in the specified maintainer script.
 .
 <code>py{,3}compile</code> are tools used to byte-compile Python source
 files. It is typically run on installation of Debian packages that ship
 Python modules. However, they do not support installing several
 architectures of the same package and this is not Multi-Arch: safe.
 .
 If the contents of the package is not architecture dependent, it should
 usually be made binary-all.
 .
 If the contents of the package is architecture dependent, it should
 usually get a dependency on the Python interpreter for the same
 architecture. This is a dependency in the form of <code>python3</code>, not
 an architecture-qualified dependency such as <code>python3:any</code> (which
 can be fulfilled by the Python interpreter for any architecture).
 .
 If a dependency on the Python interpreter for the same architecture
 exists (usually generated by <code>dh-python</code>), the
 <code>Multi-Arch: same</code> has no effect and should be dropped.
See-Also: pycompile(1), py3compile(1), Bug#812228
