/*
 * Copyright 2020 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _gc_9_4_2_SH_MASK_HEADER
#define _gc_9_4_2_SH_MASK_HEADER


// addressBlock: didtind
//DIDT_SQ_CTRL0
#define DIDT_SQ_CTRL0__DIDT_CTRL_EN__SHIFT                                                                    0x0
#define DIDT_SQ_CTRL0__PHASE_OFFSET__SHIFT                                                                    0x1
#define DIDT_SQ_CTRL0__DIDT_CTRL_RST__SHIFT                                                                   0x3
#define DIDT_SQ_CTRL0__DIDT_CLK_EN_OVERRIDE__SHIFT                                                            0x4
#define DIDT_SQ_CTRL0__DIDT_STALL_CTRL_EN__SHIFT                                                              0x5
#define DIDT_SQ_CTRL0__DIDT_TUNING_CTRL_EN__SHIFT                                                             0x6
#define DIDT_SQ_CTRL0__DIDT_STALL_AUTO_RELEASE_EN__SHIFT                                                      0x7
#define DIDT_SQ_CTRL0__DIDT_HI_POWER_THRESHOLD__SHIFT                                                         0x8
#define DIDT_SQ_CTRL0__DIDT_AUTO_MPD_EN__SHIFT                                                                0x18
#define DIDT_SQ_CTRL0__DIDT_STALL_EVENT_EN__SHIFT                                                             0x19
#define DIDT_SQ_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR__SHIFT                                                  0x1a
#define DIDT_SQ_CTRL0__DIDT_RLC_FORCE_STALL_EN__SHIFT                                                         0x1b
#define DIDT_SQ_CTRL0__DIDT_RLC_STALL_LEVEL_SEL__SHIFT                                                        0x1c
#define DIDT_SQ_CTRL0__DIDT_CTRL_EN_MASK                                                                      0x00000001L
#define DIDT_SQ_CTRL0__PHASE_OFFSET_MASK                                                                      0x00000006L
#define DIDT_SQ_CTRL0__DIDT_CTRL_RST_MASK                                                                     0x00000008L
#define DIDT_SQ_CTRL0__DIDT_CLK_EN_OVERRIDE_MASK                                                              0x00000010L
#define DIDT_SQ_CTRL0__DIDT_STALL_CTRL_EN_MASK                                                                0x00000020L
#define DIDT_SQ_CTRL0__DIDT_TUNING_CTRL_EN_MASK                                                               0x00000040L
#define DIDT_SQ_CTRL0__DIDT_STALL_AUTO_RELEASE_EN_MASK                                                        0x00000080L
#define DIDT_SQ_CTRL0__DIDT_HI_POWER_THRESHOLD_MASK                                                           0x00FFFF00L
#define DIDT_SQ_CTRL0__DIDT_AUTO_MPD_EN_MASK                                                                  0x01000000L
#define DIDT_SQ_CTRL0__DIDT_STALL_EVENT_EN_MASK                                                               0x02000000L
#define DIDT_SQ_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR_MASK                                                    0x04000000L
#define DIDT_SQ_CTRL0__DIDT_RLC_FORCE_STALL_EN_MASK                                                           0x08000000L
#define DIDT_SQ_CTRL0__DIDT_RLC_STALL_LEVEL_SEL_MASK                                                          0x10000000L
//DIDT_SQ_CTRL2
#define DIDT_SQ_CTRL2__MAX_POWER_DELTA__SHIFT                                                                 0x0
#define DIDT_SQ_CTRL2__SHORT_TERM_INTERVAL_SIZE__SHIFT                                                        0x10
#define DIDT_SQ_CTRL2__LONG_TERM_INTERVAL_RATIO__SHIFT                                                        0x1b
#define DIDT_SQ_CTRL2__MAX_POWER_DELTA_MASK                                                                   0x00003FFFL
#define DIDT_SQ_CTRL2__SHORT_TERM_INTERVAL_SIZE_MASK                                                          0x03FF0000L
#define DIDT_SQ_CTRL2__LONG_TERM_INTERVAL_RATIO_MASK                                                          0x78000000L
//DIDT_SQ_STALL_CTRL
#define DIDT_SQ_STALL_CTRL__DIDT_STALL_DELAY_HI__SHIFT                                                        0x0
#define DIDT_SQ_STALL_CTRL__DIDT_STALL_DELAY_LO__SHIFT                                                        0x6
#define DIDT_SQ_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI__SHIFT                                                 0xc
#define DIDT_SQ_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO__SHIFT                                                 0x12
#define DIDT_SQ_STALL_CTRL__DIDT_STALL_DELAY_HI_MASK                                                          0x0000003FL
#define DIDT_SQ_STALL_CTRL__DIDT_STALL_DELAY_LO_MASK                                                          0x00000FC0L
#define DIDT_SQ_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI_MASK                                                   0x0003F000L
#define DIDT_SQ_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO_MASK                                                   0x00FC0000L
//DIDT_SQ_TUNING_CTRL
#define DIDT_SQ_TUNING_CTRL__MAX_POWER_DELTA_HI__SHIFT                                                        0x0
#define DIDT_SQ_TUNING_CTRL__MAX_POWER_DELTA_LO__SHIFT                                                        0xe
#define DIDT_SQ_TUNING_CTRL__MAX_POWER_DELTA_HI_MASK                                                          0x00003FFFL
#define DIDT_SQ_TUNING_CTRL__MAX_POWER_DELTA_LO_MASK                                                          0x0FFFC000L
//DIDT_SQ_STALL_AUTO_RELEASE_CTRL
#define DIDT_SQ_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME__SHIFT                                  0x0
#define DIDT_SQ_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME_MASK                                    0x00FFFFFFL
//DIDT_SQ_CTRL3
#define DIDT_SQ_CTRL3__GC_DIDT_ENABLE__SHIFT                                                                  0x0
#define DIDT_SQ_CTRL3__GC_DIDT_CLK_EN_OVERRIDE__SHIFT                                                         0x1
#define DIDT_SQ_CTRL3__THROTTLE_POLICY__SHIFT                                                                 0x2
#define DIDT_SQ_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                    0x4
#define DIDT_SQ_CTRL3__DIDT_POWER_LEVEL_LOWBIT__SHIFT                                                         0x9
#define DIDT_SQ_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS__SHIFT                                                     0xe
#define DIDT_SQ_CTRL3__GC_DIDT_LEVEL_COMB_EN__SHIFT                                                           0x16
#define DIDT_SQ_CTRL3__SE_DIDT_LEVEL_COMB_EN__SHIFT                                                           0x17
#define DIDT_SQ_CTRL3__QUALIFY_STALL_EN__SHIFT                                                                0x18
#define DIDT_SQ_CTRL3__DIDT_STALL_SEL__SHIFT                                                                  0x19
#define DIDT_SQ_CTRL3__DIDT_FORCE_STALL__SHIFT                                                                0x1b
#define DIDT_SQ_CTRL3__DIDT_STALL_DELAY_EN__SHIFT                                                             0x1c
#define DIDT_SQ_CTRL3__GC_DIDT_ENABLE_MASK                                                                    0x00000001L
#define DIDT_SQ_CTRL3__GC_DIDT_CLK_EN_OVERRIDE_MASK                                                           0x00000002L
#define DIDT_SQ_CTRL3__THROTTLE_POLICY_MASK                                                                   0x0000000CL
#define DIDT_SQ_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT_MASK                                                      0x000001F0L
#define DIDT_SQ_CTRL3__DIDT_POWER_LEVEL_LOWBIT_MASK                                                           0x00003E00L
#define DIDT_SQ_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS_MASK                                                       0x003FC000L
#define DIDT_SQ_CTRL3__GC_DIDT_LEVEL_COMB_EN_MASK                                                             0x00400000L
#define DIDT_SQ_CTRL3__SE_DIDT_LEVEL_COMB_EN_MASK                                                             0x00800000L
#define DIDT_SQ_CTRL3__QUALIFY_STALL_EN_MASK                                                                  0x01000000L
#define DIDT_SQ_CTRL3__DIDT_STALL_SEL_MASK                                                                    0x06000000L
#define DIDT_SQ_CTRL3__DIDT_FORCE_STALL_MASK                                                                  0x08000000L
#define DIDT_SQ_CTRL3__DIDT_STALL_DELAY_EN_MASK                                                               0x10000000L
//DIDT_SQ_STALL_PATTERN_1_2
#define DIDT_SQ_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1__SHIFT                                                0x0
#define DIDT_SQ_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2__SHIFT                                                0x10
#define DIDT_SQ_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1_MASK                                                  0x00007FFFL
#define DIDT_SQ_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2_MASK                                                  0x7FFF0000L
//DIDT_SQ_STALL_PATTERN_3_4
#define DIDT_SQ_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3__SHIFT                                                0x0
#define DIDT_SQ_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4__SHIFT                                                0x10
#define DIDT_SQ_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3_MASK                                                  0x00007FFFL
#define DIDT_SQ_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4_MASK                                                  0x7FFF0000L
//DIDT_SQ_STALL_PATTERN_5_6
#define DIDT_SQ_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5__SHIFT                                                0x0
#define DIDT_SQ_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6__SHIFT                                                0x10
#define DIDT_SQ_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5_MASK                                                  0x00007FFFL
#define DIDT_SQ_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6_MASK                                                  0x7FFF0000L
//DIDT_SQ_STALL_PATTERN_7
#define DIDT_SQ_STALL_PATTERN_7__DIDT_STALL_PATTERN_7__SHIFT                                                  0x0
#define DIDT_SQ_STALL_PATTERN_7__DIDT_STALL_PATTERN_7_MASK                                                    0x00007FFFL
//DIDT_SQ_MPD_SCALE_FACTOR
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1__SHIFT                                               0x0
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2__SHIFT                                               0x4
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3__SHIFT                                               0x8
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4__SHIFT                                               0xc
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0__SHIFT                                                     0x10
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1__SHIFT                                                     0x14
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2__SHIFT                                                     0x18
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3__SHIFT                                                     0x1c
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1_MASK                                                 0x0000000FL
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2_MASK                                                 0x000000F0L
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3_MASK                                                 0x00000F00L
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4_MASK                                                 0x0000F000L
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0_MASK                                                       0x000F0000L
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1_MASK                                                       0x00F00000L
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2_MASK                                                       0x0F000000L
#define DIDT_SQ_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3_MASK                                                       0xF0000000L
//DIDT_SQ_THROTTLE_CNTL0
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN__SHIFT                                                  0x0
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL__SHIFT                                                    0x1
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI__SHIFT                                                  0x2
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO__SHIFT                                                  0xd
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN_MASK                                                    0x00000001L
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL_MASK                                                      0x00000002L
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI_MASK                                                    0x00001FFCL
#define DIDT_SQ_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO_MASK                                                    0x00FFE000L
//DIDT_SQ_THROTTLE_CNTL1
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI__SHIFT                                           0x0
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI__SHIFT                                           0x5
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO__SHIFT                                           0xa
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO__SHIFT                                           0xf
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI_MASK                                             0x0000001FL
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI_MASK                                             0x000003E0L
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO_MASK                                             0x00007C00L
#define DIDT_SQ_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO_MASK                                             0x000F8000L
//DIDT_SQ_THROTTLE_CNTL_STATUS
#define DIDT_SQ_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE__SHIFT                                     0x0
#define DIDT_SQ_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE_MASK                                       0x00000003L
//DIDT_SQ_WEIGHT0_3
#define DIDT_SQ_WEIGHT0_3__WEIGHT0__SHIFT                                                                     0x0
#define DIDT_SQ_WEIGHT0_3__WEIGHT1__SHIFT                                                                     0x8
#define DIDT_SQ_WEIGHT0_3__WEIGHT2__SHIFT                                                                     0x10
#define DIDT_SQ_WEIGHT0_3__WEIGHT3__SHIFT                                                                     0x18
#define DIDT_SQ_WEIGHT0_3__WEIGHT0_MASK                                                                       0x000000FFL
#define DIDT_SQ_WEIGHT0_3__WEIGHT1_MASK                                                                       0x0000FF00L
#define DIDT_SQ_WEIGHT0_3__WEIGHT2_MASK                                                                       0x00FF0000L
#define DIDT_SQ_WEIGHT0_3__WEIGHT3_MASK                                                                       0xFF000000L
//DIDT_SQ_WEIGHT4_7
#define DIDT_SQ_WEIGHT4_7__WEIGHT4__SHIFT                                                                     0x0
#define DIDT_SQ_WEIGHT4_7__WEIGHT5__SHIFT                                                                     0x8
#define DIDT_SQ_WEIGHT4_7__WEIGHT6__SHIFT                                                                     0x10
#define DIDT_SQ_WEIGHT4_7__WEIGHT7__SHIFT                                                                     0x18
#define DIDT_SQ_WEIGHT4_7__WEIGHT4_MASK                                                                       0x000000FFL
#define DIDT_SQ_WEIGHT4_7__WEIGHT5_MASK                                                                       0x0000FF00L
#define DIDT_SQ_WEIGHT4_7__WEIGHT6_MASK                                                                       0x00FF0000L
#define DIDT_SQ_WEIGHT4_7__WEIGHT7_MASK                                                                       0xFF000000L
//DIDT_SQ_WEIGHT8_11
#define DIDT_SQ_WEIGHT8_11__WEIGHT8__SHIFT                                                                    0x0
#define DIDT_SQ_WEIGHT8_11__WEIGHT9__SHIFT                                                                    0x8
#define DIDT_SQ_WEIGHT8_11__WEIGHT10__SHIFT                                                                   0x10
#define DIDT_SQ_WEIGHT8_11__WEIGHT11__SHIFT                                                                   0x18
#define DIDT_SQ_WEIGHT8_11__WEIGHT8_MASK                                                                      0x000000FFL
#define DIDT_SQ_WEIGHT8_11__WEIGHT9_MASK                                                                      0x0000FF00L
#define DIDT_SQ_WEIGHT8_11__WEIGHT10_MASK                                                                     0x00FF0000L
#define DIDT_SQ_WEIGHT8_11__WEIGHT11_MASK                                                                     0xFF000000L
//DIDT_SQ_EDC_CTRL
#define DIDT_SQ_EDC_CTRL__EDC_EN__SHIFT                                                                       0x0
#define DIDT_SQ_EDC_CTRL__EDC_SW_RST__SHIFT                                                                   0x1
#define DIDT_SQ_EDC_CTRL__EDC_CLK_EN_OVERRIDE__SHIFT                                                          0x2
#define DIDT_SQ_EDC_CTRL__EDC_FORCE_STALL__SHIFT                                                              0x3
#define DIDT_SQ_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                  0x4
#define DIDT_SQ_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS__SHIFT                                                   0x9
#define DIDT_SQ_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA__SHIFT                                                     0x11
#define DIDT_SQ_EDC_CTRL__GC_EDC_EN__SHIFT                                                                    0x12
#define DIDT_SQ_EDC_CTRL__GC_EDC_STALL_POLICY__SHIFT                                                          0x13
#define DIDT_SQ_EDC_CTRL__GC_EDC_LEVEL_COMB_EN__SHIFT                                                         0x15
#define DIDT_SQ_EDC_CTRL__SE_EDC_LEVEL_COMB_EN__SHIFT                                                         0x16
#define DIDT_SQ_EDC_CTRL__EDC_LEVEL_MODE_SEL__SHIFT                                                           0x17
#define DIDT_SQ_EDC_CTRL__EDC_EN_MASK                                                                         0x00000001L
#define DIDT_SQ_EDC_CTRL__EDC_SW_RST_MASK                                                                     0x00000002L
#define DIDT_SQ_EDC_CTRL__EDC_CLK_EN_OVERRIDE_MASK                                                            0x00000004L
#define DIDT_SQ_EDC_CTRL__EDC_FORCE_STALL_MASK                                                                0x00000008L
#define DIDT_SQ_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT_MASK                                                    0x000001F0L
#define DIDT_SQ_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS_MASK                                                     0x0001FE00L
#define DIDT_SQ_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA_MASK                                                       0x00020000L
#define DIDT_SQ_EDC_CTRL__GC_EDC_EN_MASK                                                                      0x00040000L
#define DIDT_SQ_EDC_CTRL__GC_EDC_STALL_POLICY_MASK                                                            0x00180000L
#define DIDT_SQ_EDC_CTRL__GC_EDC_LEVEL_COMB_EN_MASK                                                           0x00200000L
#define DIDT_SQ_EDC_CTRL__SE_EDC_LEVEL_COMB_EN_MASK                                                           0x00400000L
#define DIDT_SQ_EDC_CTRL__EDC_LEVEL_MODE_SEL_MASK                                                             0x00800000L
//DIDT_SQ_THROTTLE_CTRL
#define DIDT_SQ_THROTTLE_CTRL__GC_EDC_STALL_EN__SHIFT                                                         0x0
#define DIDT_SQ_THROTTLE_CTRL__PCC_STALL_EN__SHIFT                                                            0x1
#define DIDT_SQ_THROTTLE_CTRL__PWRBRK_STALL_EN__SHIFT                                                         0x2
#define DIDT_SQ_THROTTLE_CTRL__GC_EDC_ONLY_MODE__SHIFT                                                        0x3
#define DIDT_SQ_THROTTLE_CTRL__GC_EDC_STALL_EN_MASK                                                           0x00000001L
#define DIDT_SQ_THROTTLE_CTRL__PCC_STALL_EN_MASK                                                              0x00000002L
#define DIDT_SQ_THROTTLE_CTRL__PWRBRK_STALL_EN_MASK                                                           0x00000004L
#define DIDT_SQ_THROTTLE_CTRL__GC_EDC_ONLY_MODE_MASK                                                          0x00000008L
//DIDT_SQ_EDC_STALL_PATTERN_1_2
#define DIDT_SQ_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1__SHIFT                                             0x0
#define DIDT_SQ_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2__SHIFT                                             0x10
#define DIDT_SQ_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1_MASK                                               0x00007FFFL
#define DIDT_SQ_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2_MASK                                               0x7FFF0000L
//DIDT_SQ_EDC_STALL_PATTERN_3_4
#define DIDT_SQ_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3__SHIFT                                             0x0
#define DIDT_SQ_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4__SHIFT                                             0x10
#define DIDT_SQ_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3_MASK                                               0x00007FFFL
#define DIDT_SQ_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4_MASK                                               0x7FFF0000L
//DIDT_SQ_EDC_STALL_PATTERN_5_6
#define DIDT_SQ_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5__SHIFT                                             0x0
#define DIDT_SQ_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6__SHIFT                                             0x10
#define DIDT_SQ_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5_MASK                                               0x00007FFFL
#define DIDT_SQ_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6_MASK                                               0x7FFF0000L
//DIDT_SQ_EDC_STALL_PATTERN_7
#define DIDT_SQ_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7__SHIFT                                               0x0
#define DIDT_SQ_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7_MASK                                                 0x00007FFFL
//DIDT_SQ_EDC_STATUS
#define DIDT_SQ_EDC_STATUS__EDC_FSM_STATE__SHIFT                                                              0x0
#define DIDT_SQ_EDC_STATUS__EDC_THROTTLE_LEVEL__SHIFT                                                         0x1
#define DIDT_SQ_EDC_STATUS__EDC_FSM_STATE_MASK                                                                0x00000001L
#define DIDT_SQ_EDC_STATUS__EDC_THROTTLE_LEVEL_MASK                                                           0x0000000EL
//DIDT_SQ_EDC_STALL_DELAY_1
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ0__SHIFT                                                 0x0
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ1__SHIFT                                                 0x8
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ2__SHIFT                                                 0x10
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ3__SHIFT                                                 0x18
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ0_MASK                                                   0x000000FFL
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ1_MASK                                                   0x0000FF00L
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ2_MASK                                                   0x00FF0000L
#define DIDT_SQ_EDC_STALL_DELAY_1__EDC_STALL_DELAY_SQ3_MASK                                                   0xFF000000L
//DIDT_SQ_EDC_STALL_DELAY_2
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ4__SHIFT                                                 0x0
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ5__SHIFT                                                 0x8
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ6__SHIFT                                                 0x10
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ7__SHIFT                                                 0x18
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ4_MASK                                                   0x000000FFL
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ5_MASK                                                   0x0000FF00L
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ6_MASK                                                   0x00FF0000L
#define DIDT_SQ_EDC_STALL_DELAY_2__EDC_STALL_DELAY_SQ7_MASK                                                   0xFF000000L
//DIDT_SQ_EDC_STALL_DELAY_3
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ8__SHIFT                                                 0x0
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ9__SHIFT                                                 0x8
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ10__SHIFT                                                0x10
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ11__SHIFT                                                0x18
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ8_MASK                                                   0x000000FFL
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ9_MASK                                                   0x0000FF00L
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ10_MASK                                                  0x00FF0000L
#define DIDT_SQ_EDC_STALL_DELAY_3__EDC_STALL_DELAY_SQ11_MASK                                                  0xFF000000L
//DIDT_SQ_EDC_STALL_DELAY_4
#define DIDT_SQ_EDC_STALL_DELAY_4__EDC_STALL_DELAY_SQ12__SHIFT                                                0x0
#define DIDT_SQ_EDC_STALL_DELAY_4__EDC_STALL_DELAY_SQ13__SHIFT                                                0x8
#define DIDT_SQ_EDC_STALL_DELAY_4__EDC_STALL_DELAY_SQ12_MASK                                                  0x000000FFL
#define DIDT_SQ_EDC_STALL_DELAY_4__EDC_STALL_DELAY_SQ13_MASK                                                  0x0000FF00L
//DIDT_SQ_EDC_OVERFLOW
#define DIDT_SQ_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW__SHIFT                                         0x0
#define DIDT_SQ_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER__SHIFT                                      0x1
#define DIDT_SQ_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW_MASK                                           0x00000001L
#define DIDT_SQ_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER_MASK                                        0x0001FFFEL
//DIDT_SQ_EDC_ROLLING_POWER_DELTA
#define DIDT_SQ_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA__SHIFT                                       0x0
#define DIDT_SQ_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA_MASK                                         0xFFFFFFFFL
//DIDT_DB_CTRL0
#define DIDT_DB_CTRL0__DIDT_CTRL_EN__SHIFT                                                                    0x0
#define DIDT_DB_CTRL0__PHASE_OFFSET__SHIFT                                                                    0x1
#define DIDT_DB_CTRL0__DIDT_CTRL_RST__SHIFT                                                                   0x3
#define DIDT_DB_CTRL0__DIDT_CLK_EN_OVERRIDE__SHIFT                                                            0x4
#define DIDT_DB_CTRL0__DIDT_STALL_CTRL_EN__SHIFT                                                              0x5
#define DIDT_DB_CTRL0__DIDT_TUNING_CTRL_EN__SHIFT                                                             0x6
#define DIDT_DB_CTRL0__DIDT_STALL_AUTO_RELEASE_EN__SHIFT                                                      0x7
#define DIDT_DB_CTRL0__DIDT_HI_POWER_THRESHOLD__SHIFT                                                         0x8
#define DIDT_DB_CTRL0__DIDT_AUTO_MPD_EN__SHIFT                                                                0x18
#define DIDT_DB_CTRL0__DIDT_STALL_EVENT_EN__SHIFT                                                             0x19
#define DIDT_DB_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR__SHIFT                                                  0x1a
#define DIDT_DB_CTRL0__DIDT_RLC_FORCE_STALL_EN__SHIFT                                                         0x1b
#define DIDT_DB_CTRL0__DIDT_RLC_STALL_LEVEL_SEL__SHIFT                                                        0x1c
#define DIDT_DB_CTRL0__DIDT_CTRL_EN_MASK                                                                      0x00000001L
#define DIDT_DB_CTRL0__PHASE_OFFSET_MASK                                                                      0x00000006L
#define DIDT_DB_CTRL0__DIDT_CTRL_RST_MASK                                                                     0x00000008L
#define DIDT_DB_CTRL0__DIDT_CLK_EN_OVERRIDE_MASK                                                              0x00000010L
#define DIDT_DB_CTRL0__DIDT_STALL_CTRL_EN_MASK                                                                0x00000020L
#define DIDT_DB_CTRL0__DIDT_TUNING_CTRL_EN_MASK                                                               0x00000040L
#define DIDT_DB_CTRL0__DIDT_STALL_AUTO_RELEASE_EN_MASK                                                        0x00000080L
#define DIDT_DB_CTRL0__DIDT_HI_POWER_THRESHOLD_MASK                                                           0x00FFFF00L
#define DIDT_DB_CTRL0__DIDT_AUTO_MPD_EN_MASK                                                                  0x01000000L
#define DIDT_DB_CTRL0__DIDT_STALL_EVENT_EN_MASK                                                               0x02000000L
#define DIDT_DB_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR_MASK                                                    0x04000000L
#define DIDT_DB_CTRL0__DIDT_RLC_FORCE_STALL_EN_MASK                                                           0x08000000L
#define DIDT_DB_CTRL0__DIDT_RLC_STALL_LEVEL_SEL_MASK                                                          0x10000000L
//DIDT_DB_CTRL2
#define DIDT_DB_CTRL2__MAX_POWER_DELTA__SHIFT                                                                 0x0
#define DIDT_DB_CTRL2__SHORT_TERM_INTERVAL_SIZE__SHIFT                                                        0x10
#define DIDT_DB_CTRL2__LONG_TERM_INTERVAL_RATIO__SHIFT                                                        0x1b
#define DIDT_DB_CTRL2__MAX_POWER_DELTA_MASK                                                                   0x00003FFFL
#define DIDT_DB_CTRL2__SHORT_TERM_INTERVAL_SIZE_MASK                                                          0x03FF0000L
#define DIDT_DB_CTRL2__LONG_TERM_INTERVAL_RATIO_MASK                                                          0x78000000L
//DIDT_DB_STALL_CTRL
#define DIDT_DB_STALL_CTRL__DIDT_STALL_DELAY_HI__SHIFT                                                        0x0
#define DIDT_DB_STALL_CTRL__DIDT_STALL_DELAY_LO__SHIFT                                                        0x6
#define DIDT_DB_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI__SHIFT                                                 0xc
#define DIDT_DB_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO__SHIFT                                                 0x12
#define DIDT_DB_STALL_CTRL__DIDT_STALL_DELAY_HI_MASK                                                          0x0000003FL
#define DIDT_DB_STALL_CTRL__DIDT_STALL_DELAY_LO_MASK                                                          0x00000FC0L
#define DIDT_DB_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI_MASK                                                   0x0003F000L
#define DIDT_DB_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO_MASK                                                   0x00FC0000L
//DIDT_DB_TUNING_CTRL
#define DIDT_DB_TUNING_CTRL__MAX_POWER_DELTA_HI__SHIFT                                                        0x0
#define DIDT_DB_TUNING_CTRL__MAX_POWER_DELTA_LO__SHIFT                                                        0xe
#define DIDT_DB_TUNING_CTRL__MAX_POWER_DELTA_HI_MASK                                                          0x00003FFFL
#define DIDT_DB_TUNING_CTRL__MAX_POWER_DELTA_LO_MASK                                                          0x0FFFC000L
//DIDT_DB_STALL_AUTO_RELEASE_CTRL
#define DIDT_DB_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME__SHIFT                                  0x0
#define DIDT_DB_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME_MASK                                    0x00FFFFFFL
//DIDT_DB_CTRL3
#define DIDT_DB_CTRL3__GC_DIDT_ENABLE__SHIFT                                                                  0x0
#define DIDT_DB_CTRL3__GC_DIDT_CLK_EN_OVERRIDE__SHIFT                                                         0x1
#define DIDT_DB_CTRL3__THROTTLE_POLICY__SHIFT                                                                 0x2
#define DIDT_DB_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                    0x4
#define DIDT_DB_CTRL3__DIDT_POWER_LEVEL_LOWBIT__SHIFT                                                         0x9
#define DIDT_DB_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS__SHIFT                                                     0xe
#define DIDT_DB_CTRL3__GC_DIDT_LEVEL_COMB_EN__SHIFT                                                           0x16
#define DIDT_DB_CTRL3__SE_DIDT_LEVEL_COMB_EN__SHIFT                                                           0x17
#define DIDT_DB_CTRL3__QUALIFY_STALL_EN__SHIFT                                                                0x18
#define DIDT_DB_CTRL3__DIDT_STALL_SEL__SHIFT                                                                  0x19
#define DIDT_DB_CTRL3__DIDT_FORCE_STALL__SHIFT                                                                0x1b
#define DIDT_DB_CTRL3__DIDT_STALL_DELAY_EN__SHIFT                                                             0x1c
#define DIDT_DB_CTRL3__GC_DIDT_ENABLE_MASK                                                                    0x00000001L
#define DIDT_DB_CTRL3__GC_DIDT_CLK_EN_OVERRIDE_MASK                                                           0x00000002L
#define DIDT_DB_CTRL3__THROTTLE_POLICY_MASK                                                                   0x0000000CL
#define DIDT_DB_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT_MASK                                                      0x000001F0L
#define DIDT_DB_CTRL3__DIDT_POWER_LEVEL_LOWBIT_MASK                                                           0x00003E00L
#define DIDT_DB_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS_MASK                                                       0x003FC000L
#define DIDT_DB_CTRL3__GC_DIDT_LEVEL_COMB_EN_MASK                                                             0x00400000L
#define DIDT_DB_CTRL3__SE_DIDT_LEVEL_COMB_EN_MASK                                                             0x00800000L
#define DIDT_DB_CTRL3__QUALIFY_STALL_EN_MASK                                                                  0x01000000L
#define DIDT_DB_CTRL3__DIDT_STALL_SEL_MASK                                                                    0x06000000L
#define DIDT_DB_CTRL3__DIDT_FORCE_STALL_MASK                                                                  0x08000000L
#define DIDT_DB_CTRL3__DIDT_STALL_DELAY_EN_MASK                                                               0x10000000L
//DIDT_DB_STALL_PATTERN_1_2
#define DIDT_DB_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1__SHIFT                                                0x0
#define DIDT_DB_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2__SHIFT                                                0x10
#define DIDT_DB_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1_MASK                                                  0x00007FFFL
#define DIDT_DB_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2_MASK                                                  0x7FFF0000L
//DIDT_DB_STALL_PATTERN_3_4
#define DIDT_DB_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3__SHIFT                                                0x0
#define DIDT_DB_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4__SHIFT                                                0x10
#define DIDT_DB_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3_MASK                                                  0x00007FFFL
#define DIDT_DB_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4_MASK                                                  0x7FFF0000L
//DIDT_DB_STALL_PATTERN_5_6
#define DIDT_DB_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5__SHIFT                                                0x0
#define DIDT_DB_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6__SHIFT                                                0x10
#define DIDT_DB_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5_MASK                                                  0x00007FFFL
#define DIDT_DB_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6_MASK                                                  0x7FFF0000L
//DIDT_DB_STALL_PATTERN_7
#define DIDT_DB_STALL_PATTERN_7__DIDT_STALL_PATTERN_7__SHIFT                                                  0x0
#define DIDT_DB_STALL_PATTERN_7__DIDT_STALL_PATTERN_7_MASK                                                    0x00007FFFL
//DIDT_DB_MPD_SCALE_FACTOR
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1__SHIFT                                               0x0
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2__SHIFT                                               0x4
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3__SHIFT                                               0x8
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4__SHIFT                                               0xc
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0__SHIFT                                                     0x10
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1__SHIFT                                                     0x14
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2__SHIFT                                                     0x18
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3__SHIFT                                                     0x1c
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1_MASK                                                 0x0000000FL
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2_MASK                                                 0x000000F0L
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3_MASK                                                 0x00000F00L
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4_MASK                                                 0x0000F000L
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0_MASK                                                       0x000F0000L
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1_MASK                                                       0x00F00000L
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2_MASK                                                       0x0F000000L
#define DIDT_DB_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3_MASK                                                       0xF0000000L
//DIDT_DB_THROTTLE_CNTL0
#define DIDT_DB_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN__SHIFT                                                  0x0
#define DIDT_DB_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL__SHIFT                                                    0x1
#define DIDT_DB_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI__SHIFT                                                  0x2
#define DIDT_DB_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO__SHIFT                                                  0xd
#define DIDT_DB_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN_MASK                                                    0x00000001L
#define DIDT_DB_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL_MASK                                                      0x00000002L
#define DIDT_DB_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI_MASK                                                    0x00001FFCL
#define DIDT_DB_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO_MASK                                                    0x00FFE000L
//DIDT_DB_THROTTLE_CNTL1
#define DIDT_DB_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI__SHIFT                                           0x0
#define DIDT_DB_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI__SHIFT                                           0x5
#define DIDT_DB_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO__SHIFT                                           0xa
#define DIDT_DB_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO__SHIFT                                           0xf
#define DIDT_DB_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI_MASK                                             0x0000001FL
#define DIDT_DB_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI_MASK                                             0x000003E0L
#define DIDT_DB_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO_MASK                                             0x00007C00L
#define DIDT_DB_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO_MASK                                             0x000F8000L
//DIDT_DB_THROTTLE_CNTL_STATUS
#define DIDT_DB_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE__SHIFT                                     0x0
#define DIDT_DB_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE_MASK                                       0x00000003L
//DIDT_DB_WEIGHT0_3
#define DIDT_DB_WEIGHT0_3__WEIGHT0__SHIFT                                                                     0x0
#define DIDT_DB_WEIGHT0_3__WEIGHT1__SHIFT                                                                     0x8
#define DIDT_DB_WEIGHT0_3__WEIGHT2__SHIFT                                                                     0x10
#define DIDT_DB_WEIGHT0_3__WEIGHT3__SHIFT                                                                     0x18
#define DIDT_DB_WEIGHT0_3__WEIGHT0_MASK                                                                       0x000000FFL
#define DIDT_DB_WEIGHT0_3__WEIGHT1_MASK                                                                       0x0000FF00L
#define DIDT_DB_WEIGHT0_3__WEIGHT2_MASK                                                                       0x00FF0000L
#define DIDT_DB_WEIGHT0_3__WEIGHT3_MASK                                                                       0xFF000000L
//DIDT_DB_WEIGHT4_7
#define DIDT_DB_WEIGHT4_7__WEIGHT4__SHIFT                                                                     0x0
#define DIDT_DB_WEIGHT4_7__WEIGHT5__SHIFT                                                                     0x8
#define DIDT_DB_WEIGHT4_7__WEIGHT6__SHIFT                                                                     0x10
#define DIDT_DB_WEIGHT4_7__WEIGHT7__SHIFT                                                                     0x18
#define DIDT_DB_WEIGHT4_7__WEIGHT4_MASK                                                                       0x000000FFL
#define DIDT_DB_WEIGHT4_7__WEIGHT5_MASK                                                                       0x0000FF00L
#define DIDT_DB_WEIGHT4_7__WEIGHT6_MASK                                                                       0x00FF0000L
#define DIDT_DB_WEIGHT4_7__WEIGHT7_MASK                                                                       0xFF000000L
//DIDT_DB_WEIGHT8_11
#define DIDT_DB_WEIGHT8_11__WEIGHT8__SHIFT                                                                    0x0
#define DIDT_DB_WEIGHT8_11__WEIGHT9__SHIFT                                                                    0x8
#define DIDT_DB_WEIGHT8_11__WEIGHT10__SHIFT                                                                   0x10
#define DIDT_DB_WEIGHT8_11__WEIGHT11__SHIFT                                                                   0x18
#define DIDT_DB_WEIGHT8_11__WEIGHT8_MASK                                                                      0x000000FFL
#define DIDT_DB_WEIGHT8_11__WEIGHT9_MASK                                                                      0x0000FF00L
#define DIDT_DB_WEIGHT8_11__WEIGHT10_MASK                                                                     0x00FF0000L
#define DIDT_DB_WEIGHT8_11__WEIGHT11_MASK                                                                     0xFF000000L
//DIDT_DB_EDC_CTRL
#define DIDT_DB_EDC_CTRL__EDC_EN__SHIFT                                                                       0x0
#define DIDT_DB_EDC_CTRL__EDC_SW_RST__SHIFT                                                                   0x1
#define DIDT_DB_EDC_CTRL__EDC_CLK_EN_OVERRIDE__SHIFT                                                          0x2
#define DIDT_DB_EDC_CTRL__EDC_FORCE_STALL__SHIFT                                                              0x3
#define DIDT_DB_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                  0x4
#define DIDT_DB_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS__SHIFT                                                   0x9
#define DIDT_DB_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA__SHIFT                                                     0x11
#define DIDT_DB_EDC_CTRL__GC_EDC_EN__SHIFT                                                                    0x12
#define DIDT_DB_EDC_CTRL__GC_EDC_STALL_POLICY__SHIFT                                                          0x13
#define DIDT_DB_EDC_CTRL__GC_EDC_LEVEL_COMB_EN__SHIFT                                                         0x15
#define DIDT_DB_EDC_CTRL__SE_EDC_LEVEL_COMB_EN__SHIFT                                                         0x16
#define DIDT_DB_EDC_CTRL__EDC_LEVEL_MODE_SEL__SHIFT                                                           0x17
#define DIDT_DB_EDC_CTRL__EDC_EN_MASK                                                                         0x00000001L
#define DIDT_DB_EDC_CTRL__EDC_SW_RST_MASK                                                                     0x00000002L
#define DIDT_DB_EDC_CTRL__EDC_CLK_EN_OVERRIDE_MASK                                                            0x00000004L
#define DIDT_DB_EDC_CTRL__EDC_FORCE_STALL_MASK                                                                0x00000008L
#define DIDT_DB_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT_MASK                                                    0x000001F0L
#define DIDT_DB_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS_MASK                                                     0x0001FE00L
#define DIDT_DB_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA_MASK                                                       0x00020000L
#define DIDT_DB_EDC_CTRL__GC_EDC_EN_MASK                                                                      0x00040000L
#define DIDT_DB_EDC_CTRL__GC_EDC_STALL_POLICY_MASK                                                            0x00180000L
#define DIDT_DB_EDC_CTRL__GC_EDC_LEVEL_COMB_EN_MASK                                                           0x00200000L
#define DIDT_DB_EDC_CTRL__SE_EDC_LEVEL_COMB_EN_MASK                                                           0x00400000L
#define DIDT_DB_EDC_CTRL__EDC_LEVEL_MODE_SEL_MASK                                                             0x00800000L
//DIDT_DB_THROTTLE_CTRL
#define DIDT_DB_THROTTLE_CTRL__GC_EDC_STALL_EN__SHIFT                                                         0x0
#define DIDT_DB_THROTTLE_CTRL__PCC_STALL_EN__SHIFT                                                            0x1
#define DIDT_DB_THROTTLE_CTRL__PWRBRK_STALL_EN__SHIFT                                                         0x2
#define DIDT_DB_THROTTLE_CTRL__GC_EDC_ONLY_MODE__SHIFT                                                        0x3
#define DIDT_DB_THROTTLE_CTRL__GC_EDC_STALL_EN_MASK                                                           0x00000001L
#define DIDT_DB_THROTTLE_CTRL__PCC_STALL_EN_MASK                                                              0x00000002L
#define DIDT_DB_THROTTLE_CTRL__PWRBRK_STALL_EN_MASK                                                           0x00000004L
#define DIDT_DB_THROTTLE_CTRL__GC_EDC_ONLY_MODE_MASK                                                          0x00000008L
//DIDT_DB_EDC_STALL_PATTERN_1_2
#define DIDT_DB_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1__SHIFT                                             0x0
#define DIDT_DB_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2__SHIFT                                             0x10
#define DIDT_DB_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1_MASK                                               0x00007FFFL
#define DIDT_DB_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2_MASK                                               0x7FFF0000L
//DIDT_DB_EDC_STALL_PATTERN_3_4
#define DIDT_DB_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3__SHIFT                                             0x0
#define DIDT_DB_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4__SHIFT                                             0x10
#define DIDT_DB_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3_MASK                                               0x00007FFFL
#define DIDT_DB_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4_MASK                                               0x7FFF0000L
//DIDT_DB_EDC_STALL_PATTERN_5_6
#define DIDT_DB_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5__SHIFT                                             0x0
#define DIDT_DB_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6__SHIFT                                             0x10
#define DIDT_DB_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5_MASK                                               0x00007FFFL
#define DIDT_DB_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6_MASK                                               0x7FFF0000L
//DIDT_DB_EDC_STALL_PATTERN_7
#define DIDT_DB_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7__SHIFT                                               0x0
#define DIDT_DB_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7_MASK                                                 0x00007FFFL
//DIDT_DB_EDC_STATUS
#define DIDT_DB_EDC_STATUS__EDC_FSM_STATE__SHIFT                                                              0x0
#define DIDT_DB_EDC_STATUS__EDC_THROTTLE_LEVEL__SHIFT                                                         0x1
#define DIDT_DB_EDC_STATUS__EDC_FSM_STATE_MASK                                                                0x00000001L
#define DIDT_DB_EDC_STATUS__EDC_THROTTLE_LEVEL_MASK                                                           0x0000000EL
//DIDT_DB_EDC_STALL_DELAY_1
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB0__SHIFT                                                 0x0
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB1__SHIFT                                                 0x6
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB2__SHIFT                                                 0xc
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB3__SHIFT                                                 0x12
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB0_MASK                                                   0x0000003FL
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB1_MASK                                                   0x00000FC0L
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB2_MASK                                                   0x0003F000L
#define DIDT_DB_EDC_STALL_DELAY_1__EDC_STALL_DELAY_DB3_MASK                                                   0x00FC0000L
//DIDT_DB_EDC_OVERFLOW
#define DIDT_DB_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW__SHIFT                                         0x0
#define DIDT_DB_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER__SHIFT                                      0x1
#define DIDT_DB_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW_MASK                                           0x00000001L
#define DIDT_DB_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER_MASK                                        0x0001FFFEL
//DIDT_DB_EDC_ROLLING_POWER_DELTA
#define DIDT_DB_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA__SHIFT                                       0x0
#define DIDT_DB_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA_MASK                                         0xFFFFFFFFL
//DIDT_TD_CTRL0
#define DIDT_TD_CTRL0__DIDT_CTRL_EN__SHIFT                                                                    0x0
#define DIDT_TD_CTRL0__PHASE_OFFSET__SHIFT                                                                    0x1
#define DIDT_TD_CTRL0__DIDT_CTRL_RST__SHIFT                                                                   0x3
#define DIDT_TD_CTRL0__DIDT_CLK_EN_OVERRIDE__SHIFT                                                            0x4
#define DIDT_TD_CTRL0__DIDT_STALL_CTRL_EN__SHIFT                                                              0x5
#define DIDT_TD_CTRL0__DIDT_TUNING_CTRL_EN__SHIFT                                                             0x6
#define DIDT_TD_CTRL0__DIDT_STALL_AUTO_RELEASE_EN__SHIFT                                                      0x7
#define DIDT_TD_CTRL0__DIDT_HI_POWER_THRESHOLD__SHIFT                                                         0x8
#define DIDT_TD_CTRL0__DIDT_AUTO_MPD_EN__SHIFT                                                                0x18
#define DIDT_TD_CTRL0__DIDT_STALL_EVENT_EN__SHIFT                                                             0x19
#define DIDT_TD_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR__SHIFT                                                  0x1a
#define DIDT_TD_CTRL0__DIDT_RLC_FORCE_STALL_EN__SHIFT                                                         0x1b
#define DIDT_TD_CTRL0__DIDT_RLC_STALL_LEVEL_SEL__SHIFT                                                        0x1c
#define DIDT_TD_CTRL0__DIDT_CTRL_EN_MASK                                                                      0x00000001L
#define DIDT_TD_CTRL0__PHASE_OFFSET_MASK                                                                      0x00000006L
#define DIDT_TD_CTRL0__DIDT_CTRL_RST_MASK                                                                     0x00000008L
#define DIDT_TD_CTRL0__DIDT_CLK_EN_OVERRIDE_MASK                                                              0x00000010L
#define DIDT_TD_CTRL0__DIDT_STALL_CTRL_EN_MASK                                                                0x00000020L
#define DIDT_TD_CTRL0__DIDT_TUNING_CTRL_EN_MASK                                                               0x00000040L
#define DIDT_TD_CTRL0__DIDT_STALL_AUTO_RELEASE_EN_MASK                                                        0x00000080L
#define DIDT_TD_CTRL0__DIDT_HI_POWER_THRESHOLD_MASK                                                           0x00FFFF00L
#define DIDT_TD_CTRL0__DIDT_AUTO_MPD_EN_MASK                                                                  0x01000000L
#define DIDT_TD_CTRL0__DIDT_STALL_EVENT_EN_MASK                                                               0x02000000L
#define DIDT_TD_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR_MASK                                                    0x04000000L
#define DIDT_TD_CTRL0__DIDT_RLC_FORCE_STALL_EN_MASK                                                           0x08000000L
#define DIDT_TD_CTRL0__DIDT_RLC_STALL_LEVEL_SEL_MASK                                                          0x10000000L
//DIDT_TD_CTRL2
#define DIDT_TD_CTRL2__MAX_POWER_DELTA__SHIFT                                                                 0x0
#define DIDT_TD_CTRL2__SHORT_TERM_INTERVAL_SIZE__SHIFT                                                        0x10
#define DIDT_TD_CTRL2__LONG_TERM_INTERVAL_RATIO__SHIFT                                                        0x1b
#define DIDT_TD_CTRL2__MAX_POWER_DELTA_MASK                                                                   0x00003FFFL
#define DIDT_TD_CTRL2__SHORT_TERM_INTERVAL_SIZE_MASK                                                          0x03FF0000L
#define DIDT_TD_CTRL2__LONG_TERM_INTERVAL_RATIO_MASK                                                          0x78000000L
//DIDT_TD_STALL_CTRL
#define DIDT_TD_STALL_CTRL__DIDT_STALL_DELAY_HI__SHIFT                                                        0x0
#define DIDT_TD_STALL_CTRL__DIDT_STALL_DELAY_LO__SHIFT                                                        0x6
#define DIDT_TD_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI__SHIFT                                                 0xc
#define DIDT_TD_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO__SHIFT                                                 0x12
#define DIDT_TD_STALL_CTRL__DIDT_STALL_DELAY_HI_MASK                                                          0x0000003FL
#define DIDT_TD_STALL_CTRL__DIDT_STALL_DELAY_LO_MASK                                                          0x00000FC0L
#define DIDT_TD_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI_MASK                                                   0x0003F000L
#define DIDT_TD_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO_MASK                                                   0x00FC0000L
//DIDT_TD_TUNING_CTRL
#define DIDT_TD_TUNING_CTRL__MAX_POWER_DELTA_HI__SHIFT                                                        0x0
#define DIDT_TD_TUNING_CTRL__MAX_POWER_DELTA_LO__SHIFT                                                        0xe
#define DIDT_TD_TUNING_CTRL__MAX_POWER_DELTA_HI_MASK                                                          0x00003FFFL
#define DIDT_TD_TUNING_CTRL__MAX_POWER_DELTA_LO_MASK                                                          0x0FFFC000L
//DIDT_TD_STALL_AUTO_RELEASE_CTRL
#define DIDT_TD_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME__SHIFT                                  0x0
#define DIDT_TD_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME_MASK                                    0x00FFFFFFL
//DIDT_TD_CTRL3
#define DIDT_TD_CTRL3__GC_DIDT_ENABLE__SHIFT                                                                  0x0
#define DIDT_TD_CTRL3__GC_DIDT_CLK_EN_OVERRIDE__SHIFT                                                         0x1
#define DIDT_TD_CTRL3__THROTTLE_POLICY__SHIFT                                                                 0x2
#define DIDT_TD_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                    0x4
#define DIDT_TD_CTRL3__DIDT_POWER_LEVEL_LOWBIT__SHIFT                                                         0x9
#define DIDT_TD_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS__SHIFT                                                     0xe
#define DIDT_TD_CTRL3__GC_DIDT_LEVEL_COMB_EN__SHIFT                                                           0x16
#define DIDT_TD_CTRL3__SE_DIDT_LEVEL_COMB_EN__SHIFT                                                           0x17
#define DIDT_TD_CTRL3__QUALIFY_STALL_EN__SHIFT                                                                0x18
#define DIDT_TD_CTRL3__DIDT_STALL_SEL__SHIFT                                                                  0x19
#define DIDT_TD_CTRL3__DIDT_FORCE_STALL__SHIFT                                                                0x1b
#define DIDT_TD_CTRL3__DIDT_STALL_DELAY_EN__SHIFT                                                             0x1c
#define DIDT_TD_CTRL3__GC_DIDT_ENABLE_MASK                                                                    0x00000001L
#define DIDT_TD_CTRL3__GC_DIDT_CLK_EN_OVERRIDE_MASK                                                           0x00000002L
#define DIDT_TD_CTRL3__THROTTLE_POLICY_MASK                                                                   0x0000000CL
#define DIDT_TD_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT_MASK                                                      0x000001F0L
#define DIDT_TD_CTRL3__DIDT_POWER_LEVEL_LOWBIT_MASK                                                           0x00003E00L
#define DIDT_TD_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS_MASK                                                       0x003FC000L
#define DIDT_TD_CTRL3__GC_DIDT_LEVEL_COMB_EN_MASK                                                             0x00400000L
#define DIDT_TD_CTRL3__SE_DIDT_LEVEL_COMB_EN_MASK                                                             0x00800000L
#define DIDT_TD_CTRL3__QUALIFY_STALL_EN_MASK                                                                  0x01000000L
#define DIDT_TD_CTRL3__DIDT_STALL_SEL_MASK                                                                    0x06000000L
#define DIDT_TD_CTRL3__DIDT_FORCE_STALL_MASK                                                                  0x08000000L
#define DIDT_TD_CTRL3__DIDT_STALL_DELAY_EN_MASK                                                               0x10000000L
//DIDT_TD_STALL_PATTERN_1_2
#define DIDT_TD_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1__SHIFT                                                0x0
#define DIDT_TD_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2__SHIFT                                                0x10
#define DIDT_TD_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1_MASK                                                  0x00007FFFL
#define DIDT_TD_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2_MASK                                                  0x7FFF0000L
//DIDT_TD_STALL_PATTERN_3_4
#define DIDT_TD_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3__SHIFT                                                0x0
#define DIDT_TD_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4__SHIFT                                                0x10
#define DIDT_TD_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3_MASK                                                  0x00007FFFL
#define DIDT_TD_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4_MASK                                                  0x7FFF0000L
//DIDT_TD_STALL_PATTERN_5_6
#define DIDT_TD_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5__SHIFT                                                0x0
#define DIDT_TD_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6__SHIFT                                                0x10
#define DIDT_TD_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5_MASK                                                  0x00007FFFL
#define DIDT_TD_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6_MASK                                                  0x7FFF0000L
//DIDT_TD_STALL_PATTERN_7
#define DIDT_TD_STALL_PATTERN_7__DIDT_STALL_PATTERN_7__SHIFT                                                  0x0
#define DIDT_TD_STALL_PATTERN_7__DIDT_STALL_PATTERN_7_MASK                                                    0x00007FFFL
//DIDT_TD_MPD_SCALE_FACTOR
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1__SHIFT                                               0x0
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2__SHIFT                                               0x4
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3__SHIFT                                               0x8
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4__SHIFT                                               0xc
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0__SHIFT                                                     0x10
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1__SHIFT                                                     0x14
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2__SHIFT                                                     0x18
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3__SHIFT                                                     0x1c
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1_MASK                                                 0x0000000FL
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2_MASK                                                 0x000000F0L
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3_MASK                                                 0x00000F00L
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4_MASK                                                 0x0000F000L
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0_MASK                                                       0x000F0000L
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1_MASK                                                       0x00F00000L
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2_MASK                                                       0x0F000000L
#define DIDT_TD_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3_MASK                                                       0xF0000000L
//DIDT_TD_THROTTLE_CNTL0
#define DIDT_TD_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN__SHIFT                                                  0x0
#define DIDT_TD_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL__SHIFT                                                    0x1
#define DIDT_TD_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI__SHIFT                                                  0x2
#define DIDT_TD_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO__SHIFT                                                  0xd
#define DIDT_TD_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN_MASK                                                    0x00000001L
#define DIDT_TD_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL_MASK                                                      0x00000002L
#define DIDT_TD_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI_MASK                                                    0x00001FFCL
#define DIDT_TD_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO_MASK                                                    0x00FFE000L
//DIDT_TD_THROTTLE_CNTL1
#define DIDT_TD_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI__SHIFT                                           0x0
#define DIDT_TD_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI__SHIFT                                           0x5
#define DIDT_TD_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO__SHIFT                                           0xa
#define DIDT_TD_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO__SHIFT                                           0xf
#define DIDT_TD_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI_MASK                                             0x0000001FL
#define DIDT_TD_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI_MASK                                             0x000003E0L
#define DIDT_TD_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO_MASK                                             0x00007C00L
#define DIDT_TD_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO_MASK                                             0x000F8000L
//DIDT_TD_THROTTLE_CNTL_STATUS
#define DIDT_TD_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE__SHIFT                                     0x0
#define DIDT_TD_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE_MASK                                       0x00000003L
//DIDT_TD_WEIGHT0_3
#define DIDT_TD_WEIGHT0_3__WEIGHT0__SHIFT                                                                     0x0
#define DIDT_TD_WEIGHT0_3__WEIGHT1__SHIFT                                                                     0x8
#define DIDT_TD_WEIGHT0_3__WEIGHT2__SHIFT                                                                     0x10
#define DIDT_TD_WEIGHT0_3__WEIGHT3__SHIFT                                                                     0x18
#define DIDT_TD_WEIGHT0_3__WEIGHT0_MASK                                                                       0x000000FFL
#define DIDT_TD_WEIGHT0_3__WEIGHT1_MASK                                                                       0x0000FF00L
#define DIDT_TD_WEIGHT0_3__WEIGHT2_MASK                                                                       0x00FF0000L
#define DIDT_TD_WEIGHT0_3__WEIGHT3_MASK                                                                       0xFF000000L
//DIDT_TD_WEIGHT4_7
#define DIDT_TD_WEIGHT4_7__WEIGHT4__SHIFT                                                                     0x0
#define DIDT_TD_WEIGHT4_7__WEIGHT5__SHIFT                                                                     0x8
#define DIDT_TD_WEIGHT4_7__WEIGHT6__SHIFT                                                                     0x10
#define DIDT_TD_WEIGHT4_7__WEIGHT7__SHIFT                                                                     0x18
#define DIDT_TD_WEIGHT4_7__WEIGHT4_MASK                                                                       0x000000FFL
#define DIDT_TD_WEIGHT4_7__WEIGHT5_MASK                                                                       0x0000FF00L
#define DIDT_TD_WEIGHT4_7__WEIGHT6_MASK                                                                       0x00FF0000L
#define DIDT_TD_WEIGHT4_7__WEIGHT7_MASK                                                                       0xFF000000L
//DIDT_TD_WEIGHT8_11
#define DIDT_TD_WEIGHT8_11__WEIGHT8__SHIFT                                                                    0x0
#define DIDT_TD_WEIGHT8_11__WEIGHT9__SHIFT                                                                    0x8
#define DIDT_TD_WEIGHT8_11__WEIGHT10__SHIFT                                                                   0x10
#define DIDT_TD_WEIGHT8_11__WEIGHT11__SHIFT                                                                   0x18
#define DIDT_TD_WEIGHT8_11__WEIGHT8_MASK                                                                      0x000000FFL
#define DIDT_TD_WEIGHT8_11__WEIGHT9_MASK                                                                      0x0000FF00L
#define DIDT_TD_WEIGHT8_11__WEIGHT10_MASK                                                                     0x00FF0000L
#define DIDT_TD_WEIGHT8_11__WEIGHT11_MASK                                                                     0xFF000000L
//DIDT_TD_EDC_CTRL
#define DIDT_TD_EDC_CTRL__EDC_EN__SHIFT                                                                       0x0
#define DIDT_TD_EDC_CTRL__EDC_SW_RST__SHIFT                                                                   0x1
#define DIDT_TD_EDC_CTRL__EDC_CLK_EN_OVERRIDE__SHIFT                                                          0x2
#define DIDT_TD_EDC_CTRL__EDC_FORCE_STALL__SHIFT                                                              0x3
#define DIDT_TD_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                  0x4
#define DIDT_TD_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS__SHIFT                                                   0x9
#define DIDT_TD_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA__SHIFT                                                     0x11
#define DIDT_TD_EDC_CTRL__GC_EDC_EN__SHIFT                                                                    0x12
#define DIDT_TD_EDC_CTRL__GC_EDC_STALL_POLICY__SHIFT                                                          0x13
#define DIDT_TD_EDC_CTRL__GC_EDC_LEVEL_COMB_EN__SHIFT                                                         0x15
#define DIDT_TD_EDC_CTRL__SE_EDC_LEVEL_COMB_EN__SHIFT                                                         0x16
#define DIDT_TD_EDC_CTRL__EDC_LEVEL_MODE_SEL__SHIFT                                                           0x17
#define DIDT_TD_EDC_CTRL__EDC_EN_MASK                                                                         0x00000001L
#define DIDT_TD_EDC_CTRL__EDC_SW_RST_MASK                                                                     0x00000002L
#define DIDT_TD_EDC_CTRL__EDC_CLK_EN_OVERRIDE_MASK                                                            0x00000004L
#define DIDT_TD_EDC_CTRL__EDC_FORCE_STALL_MASK                                                                0x00000008L
#define DIDT_TD_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT_MASK                                                    0x000001F0L
#define DIDT_TD_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS_MASK                                                     0x0001FE00L
#define DIDT_TD_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA_MASK                                                       0x00020000L
#define DIDT_TD_EDC_CTRL__GC_EDC_EN_MASK                                                                      0x00040000L
#define DIDT_TD_EDC_CTRL__GC_EDC_STALL_POLICY_MASK                                                            0x00180000L
#define DIDT_TD_EDC_CTRL__GC_EDC_LEVEL_COMB_EN_MASK                                                           0x00200000L
#define DIDT_TD_EDC_CTRL__SE_EDC_LEVEL_COMB_EN_MASK                                                           0x00400000L
#define DIDT_TD_EDC_CTRL__EDC_LEVEL_MODE_SEL_MASK                                                             0x00800000L
//DIDT_TD_THROTTLE_CTRL
#define DIDT_TD_THROTTLE_CTRL__GC_EDC_STALL_EN__SHIFT                                                         0x0
#define DIDT_TD_THROTTLE_CTRL__PCC_STALL_EN__SHIFT                                                            0x1
#define DIDT_TD_THROTTLE_CTRL__PWRBRK_STALL_EN__SHIFT                                                         0x2
#define DIDT_TD_THROTTLE_CTRL__GC_EDC_ONLY_MODE__SHIFT                                                        0x3
#define DIDT_TD_THROTTLE_CTRL__GC_EDC_STALL_EN_MASK                                                           0x00000001L
#define DIDT_TD_THROTTLE_CTRL__PCC_STALL_EN_MASK                                                              0x00000002L
#define DIDT_TD_THROTTLE_CTRL__PWRBRK_STALL_EN_MASK                                                           0x00000004L
#define DIDT_TD_THROTTLE_CTRL__GC_EDC_ONLY_MODE_MASK                                                          0x00000008L
//DIDT_TD_EDC_STALL_PATTERN_1_2
#define DIDT_TD_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1__SHIFT                                             0x0
#define DIDT_TD_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2__SHIFT                                             0x10
#define DIDT_TD_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1_MASK                                               0x00007FFFL
#define DIDT_TD_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2_MASK                                               0x7FFF0000L
//DIDT_TD_EDC_STALL_PATTERN_3_4
#define DIDT_TD_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3__SHIFT                                             0x0
#define DIDT_TD_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4__SHIFT                                             0x10
#define DIDT_TD_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3_MASK                                               0x00007FFFL
#define DIDT_TD_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4_MASK                                               0x7FFF0000L
//DIDT_TD_EDC_STALL_PATTERN_5_6
#define DIDT_TD_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5__SHIFT                                             0x0
#define DIDT_TD_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6__SHIFT                                             0x10
#define DIDT_TD_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5_MASK                                               0x00007FFFL
#define DIDT_TD_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6_MASK                                               0x7FFF0000L
//DIDT_TD_EDC_STALL_PATTERN_7
#define DIDT_TD_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7__SHIFT                                               0x0
#define DIDT_TD_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7_MASK                                                 0x00007FFFL
//DIDT_TD_EDC_STATUS
#define DIDT_TD_EDC_STATUS__EDC_FSM_STATE__SHIFT                                                              0x0
#define DIDT_TD_EDC_STATUS__EDC_THROTTLE_LEVEL__SHIFT                                                         0x1
#define DIDT_TD_EDC_STATUS__EDC_FSM_STATE_MASK                                                                0x00000001L
#define DIDT_TD_EDC_STATUS__EDC_THROTTLE_LEVEL_MASK                                                           0x0000000EL
//DIDT_TD_EDC_STALL_DELAY_1
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD0__SHIFT                                                 0x0
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD1__SHIFT                                                 0x8
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD2__SHIFT                                                 0x10
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD3__SHIFT                                                 0x18
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD0_MASK                                                   0x000000FFL
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD1_MASK                                                   0x0000FF00L
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD2_MASK                                                   0x00FF0000L
#define DIDT_TD_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TD3_MASK                                                   0xFF000000L
//DIDT_TD_EDC_STALL_DELAY_2
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD4__SHIFT                                                 0x0
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD5__SHIFT                                                 0x8
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD6__SHIFT                                                 0x10
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD7__SHIFT                                                 0x18
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD4_MASK                                                   0x000000FFL
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD5_MASK                                                   0x0000FF00L
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD6_MASK                                                   0x00FF0000L
#define DIDT_TD_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TD7_MASK                                                   0xFF000000L
//DIDT_TD_EDC_STALL_DELAY_3
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD8__SHIFT                                                 0x0
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD9__SHIFT                                                 0x8
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD10__SHIFT                                                0x10
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD11__SHIFT                                                0x18
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD8_MASK                                                   0x000000FFL
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD9_MASK                                                   0x0000FF00L
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD10_MASK                                                  0x00FF0000L
#define DIDT_TD_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TD11_MASK                                                  0xFF000000L
//DIDT_TD_EDC_STALL_DELAY_4
#define DIDT_TD_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TD12__SHIFT                                                0x0
#define DIDT_TD_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TD13__SHIFT                                                0x8
#define DIDT_TD_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TD12_MASK                                                  0x000000FFL
#define DIDT_TD_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TD13_MASK                                                  0x0000FF00L
//DIDT_TD_EDC_OVERFLOW
#define DIDT_TD_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW__SHIFT                                         0x0
#define DIDT_TD_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER__SHIFT                                      0x1
#define DIDT_TD_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW_MASK                                           0x00000001L
#define DIDT_TD_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER_MASK                                        0x0001FFFEL
//DIDT_TD_EDC_ROLLING_POWER_DELTA
#define DIDT_TD_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA__SHIFT                                       0x0
#define DIDT_TD_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA_MASK                                         0xFFFFFFFFL
//DIDT_TCP_CTRL0
#define DIDT_TCP_CTRL0__DIDT_CTRL_EN__SHIFT                                                                   0x0
#define DIDT_TCP_CTRL0__PHASE_OFFSET__SHIFT                                                                   0x1
#define DIDT_TCP_CTRL0__DIDT_CTRL_RST__SHIFT                                                                  0x3
#define DIDT_TCP_CTRL0__DIDT_CLK_EN_OVERRIDE__SHIFT                                                           0x4
#define DIDT_TCP_CTRL0__DIDT_STALL_CTRL_EN__SHIFT                                                             0x5
#define DIDT_TCP_CTRL0__DIDT_TUNING_CTRL_EN__SHIFT                                                            0x6
#define DIDT_TCP_CTRL0__DIDT_STALL_AUTO_RELEASE_EN__SHIFT                                                     0x7
#define DIDT_TCP_CTRL0__DIDT_HI_POWER_THRESHOLD__SHIFT                                                        0x8
#define DIDT_TCP_CTRL0__DIDT_AUTO_MPD_EN__SHIFT                                                               0x18
#define DIDT_TCP_CTRL0__DIDT_STALL_EVENT_EN__SHIFT                                                            0x19
#define DIDT_TCP_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR__SHIFT                                                 0x1a
#define DIDT_TCP_CTRL0__DIDT_RLC_FORCE_STALL_EN__SHIFT                                                        0x1b
#define DIDT_TCP_CTRL0__DIDT_RLC_STALL_LEVEL_SEL__SHIFT                                                       0x1c
#define DIDT_TCP_CTRL0__DIDT_CTRL_EN_MASK                                                                     0x00000001L
#define DIDT_TCP_CTRL0__PHASE_OFFSET_MASK                                                                     0x00000006L
#define DIDT_TCP_CTRL0__DIDT_CTRL_RST_MASK                                                                    0x00000008L
#define DIDT_TCP_CTRL0__DIDT_CLK_EN_OVERRIDE_MASK                                                             0x00000010L
#define DIDT_TCP_CTRL0__DIDT_STALL_CTRL_EN_MASK                                                               0x00000020L
#define DIDT_TCP_CTRL0__DIDT_TUNING_CTRL_EN_MASK                                                              0x00000040L
#define DIDT_TCP_CTRL0__DIDT_STALL_AUTO_RELEASE_EN_MASK                                                       0x00000080L
#define DIDT_TCP_CTRL0__DIDT_HI_POWER_THRESHOLD_MASK                                                          0x00FFFF00L
#define DIDT_TCP_CTRL0__DIDT_AUTO_MPD_EN_MASK                                                                 0x01000000L
#define DIDT_TCP_CTRL0__DIDT_STALL_EVENT_EN_MASK                                                              0x02000000L
#define DIDT_TCP_CTRL0__DIDT_STALL_EVENT_COUNTER_CLEAR_MASK                                                   0x04000000L
#define DIDT_TCP_CTRL0__DIDT_RLC_FORCE_STALL_EN_MASK                                                          0x08000000L
#define DIDT_TCP_CTRL0__DIDT_RLC_STALL_LEVEL_SEL_MASK                                                         0x10000000L
//DIDT_TCP_CTRL2
#define DIDT_TCP_CTRL2__MAX_POWER_DELTA__SHIFT                                                                0x0
#define DIDT_TCP_CTRL2__SHORT_TERM_INTERVAL_SIZE__SHIFT                                                       0x10
#define DIDT_TCP_CTRL2__LONG_TERM_INTERVAL_RATIO__SHIFT                                                       0x1b
#define DIDT_TCP_CTRL2__MAX_POWER_DELTA_MASK                                                                  0x00003FFFL
#define DIDT_TCP_CTRL2__SHORT_TERM_INTERVAL_SIZE_MASK                                                         0x03FF0000L
#define DIDT_TCP_CTRL2__LONG_TERM_INTERVAL_RATIO_MASK                                                         0x78000000L
//DIDT_TCP_STALL_CTRL
#define DIDT_TCP_STALL_CTRL__DIDT_STALL_DELAY_HI__SHIFT                                                       0x0
#define DIDT_TCP_STALL_CTRL__DIDT_STALL_DELAY_LO__SHIFT                                                       0x6
#define DIDT_TCP_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI__SHIFT                                                0xc
#define DIDT_TCP_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO__SHIFT                                                0x12
#define DIDT_TCP_STALL_CTRL__DIDT_STALL_DELAY_HI_MASK                                                         0x0000003FL
#define DIDT_TCP_STALL_CTRL__DIDT_STALL_DELAY_LO_MASK                                                         0x00000FC0L
#define DIDT_TCP_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_HI_MASK                                                  0x0003F000L
#define DIDT_TCP_STALL_CTRL__DIDT_MAX_STALLS_ALLOWED_LO_MASK                                                  0x00FC0000L
//DIDT_TCP_TUNING_CTRL
#define DIDT_TCP_TUNING_CTRL__MAX_POWER_DELTA_HI__SHIFT                                                       0x0
#define DIDT_TCP_TUNING_CTRL__MAX_POWER_DELTA_LO__SHIFT                                                       0xe
#define DIDT_TCP_TUNING_CTRL__MAX_POWER_DELTA_HI_MASK                                                         0x00003FFFL
#define DIDT_TCP_TUNING_CTRL__MAX_POWER_DELTA_LO_MASK                                                         0x0FFFC000L
//DIDT_TCP_STALL_AUTO_RELEASE_CTRL
#define DIDT_TCP_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME__SHIFT                                 0x0
#define DIDT_TCP_STALL_AUTO_RELEASE_CTRL__DIDT_STALL_AUTO_RELEASE_TIME_MASK                                   0x00FFFFFFL
//DIDT_TCP_CTRL3
#define DIDT_TCP_CTRL3__GC_DIDT_ENABLE__SHIFT                                                                 0x0
#define DIDT_TCP_CTRL3__GC_DIDT_CLK_EN_OVERRIDE__SHIFT                                                        0x1
#define DIDT_TCP_CTRL3__THROTTLE_POLICY__SHIFT                                                                0x2
#define DIDT_TCP_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                   0x4
#define DIDT_TCP_CTRL3__DIDT_POWER_LEVEL_LOWBIT__SHIFT                                                        0x9
#define DIDT_TCP_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS__SHIFT                                                    0xe
#define DIDT_TCP_CTRL3__GC_DIDT_LEVEL_COMB_EN__SHIFT                                                          0x16
#define DIDT_TCP_CTRL3__SE_DIDT_LEVEL_COMB_EN__SHIFT                                                          0x17
#define DIDT_TCP_CTRL3__QUALIFY_STALL_EN__SHIFT                                                               0x18
#define DIDT_TCP_CTRL3__DIDT_STALL_SEL__SHIFT                                                                 0x19
#define DIDT_TCP_CTRL3__DIDT_FORCE_STALL__SHIFT                                                               0x1b
#define DIDT_TCP_CTRL3__DIDT_STALL_DELAY_EN__SHIFT                                                            0x1c
#define DIDT_TCP_CTRL3__GC_DIDT_ENABLE_MASK                                                                   0x00000001L
#define DIDT_TCP_CTRL3__GC_DIDT_CLK_EN_OVERRIDE_MASK                                                          0x00000002L
#define DIDT_TCP_CTRL3__THROTTLE_POLICY_MASK                                                                  0x0000000CL
#define DIDT_TCP_CTRL3__DIDT_TRIGGER_THROTTLE_LOWBIT_MASK                                                     0x000001F0L
#define DIDT_TCP_CTRL3__DIDT_POWER_LEVEL_LOWBIT_MASK                                                          0x00003E00L
#define DIDT_TCP_CTRL3__DIDT_STALL_PATTERN_BIT_NUMS_MASK                                                      0x003FC000L
#define DIDT_TCP_CTRL3__GC_DIDT_LEVEL_COMB_EN_MASK                                                            0x00400000L
#define DIDT_TCP_CTRL3__SE_DIDT_LEVEL_COMB_EN_MASK                                                            0x00800000L
#define DIDT_TCP_CTRL3__QUALIFY_STALL_EN_MASK                                                                 0x01000000L
#define DIDT_TCP_CTRL3__DIDT_STALL_SEL_MASK                                                                   0x06000000L
#define DIDT_TCP_CTRL3__DIDT_FORCE_STALL_MASK                                                                 0x08000000L
#define DIDT_TCP_CTRL3__DIDT_STALL_DELAY_EN_MASK                                                              0x10000000L
//DIDT_TCP_STALL_PATTERN_1_2
#define DIDT_TCP_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1__SHIFT                                               0x0
#define DIDT_TCP_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2__SHIFT                                               0x10
#define DIDT_TCP_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_1_MASK                                                 0x00007FFFL
#define DIDT_TCP_STALL_PATTERN_1_2__DIDT_STALL_PATTERN_2_MASK                                                 0x7FFF0000L
//DIDT_TCP_STALL_PATTERN_3_4
#define DIDT_TCP_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3__SHIFT                                               0x0
#define DIDT_TCP_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4__SHIFT                                               0x10
#define DIDT_TCP_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_3_MASK                                                 0x00007FFFL
#define DIDT_TCP_STALL_PATTERN_3_4__DIDT_STALL_PATTERN_4_MASK                                                 0x7FFF0000L
//DIDT_TCP_STALL_PATTERN_5_6
#define DIDT_TCP_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5__SHIFT                                               0x0
#define DIDT_TCP_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6__SHIFT                                               0x10
#define DIDT_TCP_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_5_MASK                                                 0x00007FFFL
#define DIDT_TCP_STALL_PATTERN_5_6__DIDT_STALL_PATTERN_6_MASK                                                 0x7FFF0000L
//DIDT_TCP_STALL_PATTERN_7
#define DIDT_TCP_STALL_PATTERN_7__DIDT_STALL_PATTERN_7__SHIFT                                                 0x0
#define DIDT_TCP_STALL_PATTERN_7__DIDT_STALL_PATTERN_7_MASK                                                   0x00007FFFL
//DIDT_TCP_MPD_SCALE_FACTOR
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1__SHIFT                                              0x0
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2__SHIFT                                              0x4
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3__SHIFT                                              0x8
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4__SHIFT                                              0xc
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0__SHIFT                                                    0x10
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1__SHIFT                                                    0x14
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2__SHIFT                                                    0x18
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3__SHIFT                                                    0x1c
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL1_MASK                                                0x0000000FL
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL2_MASK                                                0x000000F0L
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL3_MASK                                                0x00000F00L
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_RATIO_SCALE_LEVEL4_MASK                                                0x0000F000L
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL0_MASK                                                      0x000F0000L
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL1_MASK                                                      0x00F00000L
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL2_MASK                                                      0x0F000000L
#define DIDT_TCP_MPD_SCALE_FACTOR__MPD_SCALE_LEVEL3_MASK                                                      0xF0000000L
//DIDT_TCP_THROTTLE_CNTL0
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN__SHIFT                                                 0x0
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL__SHIFT                                                   0x1
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI__SHIFT                                                 0x2
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO__SHIFT                                                 0xd
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_THROTTLE_CNTL_EN_MASK                                                   0x00000001L
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_STALL_CNTL_SEL_MASK                                                     0x00000002L
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_HI_MASK                                                   0x00001FFCL
#define DIDT_TCP_THROTTLE_CNTL0__DIDT_RELEASE_DELAY_LO_MASK                                                   0x00FFE000L
//DIDT_TCP_THROTTLE_CNTL1
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI__SHIFT                                          0x0
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI__SHIFT                                          0x5
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO__SHIFT                                          0xa
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO__SHIFT                                          0xf
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_HI_MASK                                            0x0000001FL
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_HI_MASK                                            0x000003E0L
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_BASE_RELEASE_ALLOWED_LO_MASK                                            0x00007C00L
#define DIDT_TCP_THROTTLE_CNTL1__DIDT_INCR_RELEASE_ALLOWED_LO_MASK                                            0x000F8000L
//DIDT_TCP_THROTTLE_CNTL_STATUS
#define DIDT_TCP_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE__SHIFT                                    0x0
#define DIDT_TCP_THROTTLE_CNTL_STATUS__DIDT_THROTTLE_CNTL_FSM_STATE_MASK                                      0x00000003L
//DIDT_TCP_WEIGHT0_3
#define DIDT_TCP_WEIGHT0_3__WEIGHT0__SHIFT                                                                    0x0
#define DIDT_TCP_WEIGHT0_3__WEIGHT1__SHIFT                                                                    0x8
#define DIDT_TCP_WEIGHT0_3__WEIGHT2__SHIFT                                                                    0x10
#define DIDT_TCP_WEIGHT0_3__WEIGHT3__SHIFT                                                                    0x18
#define DIDT_TCP_WEIGHT0_3__WEIGHT0_MASK                                                                      0x000000FFL
#define DIDT_TCP_WEIGHT0_3__WEIGHT1_MASK                                                                      0x0000FF00L
#define DIDT_TCP_WEIGHT0_3__WEIGHT2_MASK                                                                      0x00FF0000L
#define DIDT_TCP_WEIGHT0_3__WEIGHT3_MASK                                                                      0xFF000000L
//DIDT_TCP_WEIGHT4_7
#define DIDT_TCP_WEIGHT4_7__WEIGHT4__SHIFT                                                                    0x0
#define DIDT_TCP_WEIGHT4_7__WEIGHT5__SHIFT                                                                    0x8
#define DIDT_TCP_WEIGHT4_7__WEIGHT6__SHIFT                                                                    0x10
#define DIDT_TCP_WEIGHT4_7__WEIGHT7__SHIFT                                                                    0x18
#define DIDT_TCP_WEIGHT4_7__WEIGHT4_MASK                                                                      0x000000FFL
#define DIDT_TCP_WEIGHT4_7__WEIGHT5_MASK                                                                      0x0000FF00L
#define DIDT_TCP_WEIGHT4_7__WEIGHT6_MASK                                                                      0x00FF0000L
#define DIDT_TCP_WEIGHT4_7__WEIGHT7_MASK                                                                      0xFF000000L
//DIDT_TCP_WEIGHT8_11
#define DIDT_TCP_WEIGHT8_11__WEIGHT8__SHIFT                                                                   0x0
#define DIDT_TCP_WEIGHT8_11__WEIGHT9__SHIFT                                                                   0x8
#define DIDT_TCP_WEIGHT8_11__WEIGHT10__SHIFT                                                                  0x10
#define DIDT_TCP_WEIGHT8_11__WEIGHT11__SHIFT                                                                  0x18
#define DIDT_TCP_WEIGHT8_11__WEIGHT8_MASK                                                                     0x000000FFL
#define DIDT_TCP_WEIGHT8_11__WEIGHT9_MASK                                                                     0x0000FF00L
#define DIDT_TCP_WEIGHT8_11__WEIGHT10_MASK                                                                    0x00FF0000L
#define DIDT_TCP_WEIGHT8_11__WEIGHT11_MASK                                                                    0xFF000000L
//DIDT_TCP_EDC_CTRL
#define DIDT_TCP_EDC_CTRL__EDC_EN__SHIFT                                                                      0x0
#define DIDT_TCP_EDC_CTRL__EDC_SW_RST__SHIFT                                                                  0x1
#define DIDT_TCP_EDC_CTRL__EDC_CLK_EN_OVERRIDE__SHIFT                                                         0x2
#define DIDT_TCP_EDC_CTRL__EDC_FORCE_STALL__SHIFT                                                             0x3
#define DIDT_TCP_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                 0x4
#define DIDT_TCP_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS__SHIFT                                                  0x9
#define DIDT_TCP_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA__SHIFT                                                    0x11
#define DIDT_TCP_EDC_CTRL__GC_EDC_EN__SHIFT                                                                   0x12
#define DIDT_TCP_EDC_CTRL__GC_EDC_STALL_POLICY__SHIFT                                                         0x13
#define DIDT_TCP_EDC_CTRL__GC_EDC_LEVEL_COMB_EN__SHIFT                                                        0x15
#define DIDT_TCP_EDC_CTRL__SE_EDC_LEVEL_COMB_EN__SHIFT                                                        0x16
#define DIDT_TCP_EDC_CTRL__EDC_LEVEL_MODE_SEL__SHIFT                                                          0x17
#define DIDT_TCP_EDC_CTRL__EDC_EN_MASK                                                                        0x00000001L
#define DIDT_TCP_EDC_CTRL__EDC_SW_RST_MASK                                                                    0x00000002L
#define DIDT_TCP_EDC_CTRL__EDC_CLK_EN_OVERRIDE_MASK                                                           0x00000004L
#define DIDT_TCP_EDC_CTRL__EDC_FORCE_STALL_MASK                                                               0x00000008L
#define DIDT_TCP_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT_MASK                                                   0x000001F0L
#define DIDT_TCP_EDC_CTRL__EDC_STALL_PATTERN_BIT_NUMS_MASK                                                    0x0001FE00L
#define DIDT_TCP_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA_MASK                                                      0x00020000L
#define DIDT_TCP_EDC_CTRL__GC_EDC_EN_MASK                                                                     0x00040000L
#define DIDT_TCP_EDC_CTRL__GC_EDC_STALL_POLICY_MASK                                                           0x00180000L
#define DIDT_TCP_EDC_CTRL__GC_EDC_LEVEL_COMB_EN_MASK                                                          0x00200000L
#define DIDT_TCP_EDC_CTRL__SE_EDC_LEVEL_COMB_EN_MASK                                                          0x00400000L
#define DIDT_TCP_EDC_CTRL__EDC_LEVEL_MODE_SEL_MASK                                                            0x00800000L
//DIDT_TCP_THROTTLE_CTRL
#define DIDT_TCP_THROTTLE_CTRL__GC_EDC_STALL_EN__SHIFT                                                        0x0
#define DIDT_TCP_THROTTLE_CTRL__PCC_STALL_EN__SHIFT                                                           0x1
#define DIDT_TCP_THROTTLE_CTRL__PWRBRK_STALL_EN__SHIFT                                                        0x2
#define DIDT_TCP_THROTTLE_CTRL__GC_EDC_ONLY_MODE__SHIFT                                                       0x3
#define DIDT_TCP_THROTTLE_CTRL__GC_EDC_STALL_EN_MASK                                                          0x00000001L
#define DIDT_TCP_THROTTLE_CTRL__PCC_STALL_EN_MASK                                                             0x00000002L
#define DIDT_TCP_THROTTLE_CTRL__PWRBRK_STALL_EN_MASK                                                          0x00000004L
#define DIDT_TCP_THROTTLE_CTRL__GC_EDC_ONLY_MODE_MASK                                                         0x00000008L
//DIDT_TCP_EDC_STALL_PATTERN_1_2
#define DIDT_TCP_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1__SHIFT                                            0x0
#define DIDT_TCP_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2__SHIFT                                            0x10
#define DIDT_TCP_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_1_MASK                                              0x00007FFFL
#define DIDT_TCP_EDC_STALL_PATTERN_1_2__EDC_STALL_PATTERN_2_MASK                                              0x7FFF0000L
//DIDT_TCP_EDC_STALL_PATTERN_3_4
#define DIDT_TCP_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3__SHIFT                                            0x0
#define DIDT_TCP_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4__SHIFT                                            0x10
#define DIDT_TCP_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_3_MASK                                              0x00007FFFL
#define DIDT_TCP_EDC_STALL_PATTERN_3_4__EDC_STALL_PATTERN_4_MASK                                              0x7FFF0000L
//DIDT_TCP_EDC_STALL_PATTERN_5_6
#define DIDT_TCP_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5__SHIFT                                            0x0
#define DIDT_TCP_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6__SHIFT                                            0x10
#define DIDT_TCP_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_5_MASK                                              0x00007FFFL
#define DIDT_TCP_EDC_STALL_PATTERN_5_6__EDC_STALL_PATTERN_6_MASK                                              0x7FFF0000L
//DIDT_TCP_EDC_STALL_PATTERN_7
#define DIDT_TCP_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7__SHIFT                                              0x0
#define DIDT_TCP_EDC_STALL_PATTERN_7__EDC_STALL_PATTERN_7_MASK                                                0x00007FFFL
//DIDT_TCP_EDC_STATUS
#define DIDT_TCP_EDC_STATUS__EDC_FSM_STATE__SHIFT                                                             0x0
#define DIDT_TCP_EDC_STATUS__EDC_THROTTLE_LEVEL__SHIFT                                                        0x1
#define DIDT_TCP_EDC_STATUS__EDC_FSM_STATE_MASK                                                               0x00000001L
#define DIDT_TCP_EDC_STATUS__EDC_THROTTLE_LEVEL_MASK                                                          0x0000000EL
//DIDT_TCP_EDC_STALL_DELAY_1
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP0__SHIFT                                               0x0
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP1__SHIFT                                               0x8
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP2__SHIFT                                               0x10
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP3__SHIFT                                               0x18
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP0_MASK                                                 0x000000FFL
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP1_MASK                                                 0x0000FF00L
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP2_MASK                                                 0x00FF0000L
#define DIDT_TCP_EDC_STALL_DELAY_1__EDC_STALL_DELAY_TCP3_MASK                                                 0xFF000000L
//DIDT_TCP_EDC_STALL_DELAY_2
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP4__SHIFT                                               0x0
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP5__SHIFT                                               0x8
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP6__SHIFT                                               0x10
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP7__SHIFT                                               0x18
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP4_MASK                                                 0x000000FFL
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP5_MASK                                                 0x0000FF00L
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP6_MASK                                                 0x00FF0000L
#define DIDT_TCP_EDC_STALL_DELAY_2__EDC_STALL_DELAY_TCP7_MASK                                                 0xFF000000L
//DIDT_TCP_EDC_STALL_DELAY_3
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP8__SHIFT                                               0x0
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP9__SHIFT                                               0x8
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP10__SHIFT                                              0x10
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP11__SHIFT                                              0x18
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP8_MASK                                                 0x000000FFL
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP9_MASK                                                 0x0000FF00L
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP10_MASK                                                0x00FF0000L
#define DIDT_TCP_EDC_STALL_DELAY_3__EDC_STALL_DELAY_TCP11_MASK                                                0xFF000000L
//DIDT_TCP_EDC_STALL_DELAY_4
#define DIDT_TCP_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TCP12__SHIFT                                              0x0
#define DIDT_TCP_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TCP13__SHIFT                                              0x8
#define DIDT_TCP_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TCP12_MASK                                                0x000000FFL
#define DIDT_TCP_EDC_STALL_DELAY_4__EDC_STALL_DELAY_TCP13_MASK                                                0x0000FF00L
//DIDT_TCP_EDC_OVERFLOW
#define DIDT_TCP_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW__SHIFT                                        0x0
#define DIDT_TCP_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER__SHIFT                                     0x1
#define DIDT_TCP_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW_MASK                                          0x00000001L
#define DIDT_TCP_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER_MASK                                       0x0001FFFEL
//DIDT_TCP_EDC_ROLLING_POWER_DELTA
#define DIDT_TCP_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA__SHIFT                                      0x0
#define DIDT_TCP_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA_MASK                                        0xFFFFFFFFL
//DIDT_SQ_STALL_EVENT_COUNTER
#define DIDT_SQ_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER__SHIFT                                          0x0
#define DIDT_SQ_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER_MASK                                            0xFFFFFFFFL
//DIDT_DB_STALL_EVENT_COUNTER
#define DIDT_DB_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER__SHIFT                                          0x0
#define DIDT_DB_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER_MASK                                            0xFFFFFFFFL
//DIDT_TD_STALL_EVENT_COUNTER
#define DIDT_TD_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER__SHIFT                                          0x0
#define DIDT_TD_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER_MASK                                            0xFFFFFFFFL
//DIDT_TCP_STALL_EVENT_COUNTER
#define DIDT_TCP_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER__SHIFT                                         0x0
#define DIDT_TCP_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER_MASK                                           0xFFFFFFFFL
//DIDT_DBR_STALL_EVENT_COUNTER
#define DIDT_DBR_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER__SHIFT                                         0x0
#define DIDT_DBR_STALL_EVENT_COUNTER__DIDT_STALL_EVENT_COUNTER_MASK                                           0xFFFFFFFFL
//DIDT_SQ_EDC_PCC_PERF_COUNTER
#define DIDT_SQ_EDC_PCC_PERF_COUNTER__PERF_COUNTER__SHIFT                                                     0x0
#define DIDT_SQ_EDC_PCC_PERF_COUNTER__PERF_COUNTER_MASK                                                       0xFFFFFFFFL
//DIDT_TD_EDC_PCC_PERF_COUNTER
#define DIDT_TD_EDC_PCC_PERF_COUNTER__PERF_COUNTER__SHIFT                                                     0x0
#define DIDT_TD_EDC_PCC_PERF_COUNTER__PERF_COUNTER_MASK                                                       0xFFFFFFFFL
//DIDT_TCP_EDC_PCC_PERF_COUNTER
#define DIDT_TCP_EDC_PCC_PERF_COUNTER__PERF_COUNTER__SHIFT                                                    0x0
#define DIDT_TCP_EDC_PCC_PERF_COUNTER__PERF_COUNTER_MASK                                                      0xFFFFFFFFL
//DIDT_DB_EDC_PCC_PERF_COUNTER
#define DIDT_DB_EDC_PCC_PERF_COUNTER__PERF_COUNTER__SHIFT                                                     0x0
#define DIDT_DB_EDC_PCC_PERF_COUNTER__PERF_COUNTER_MASK                                                       0xFFFFFFFFL
//DIDT_DBR_EDC_PCC_PERF_COUNTER
#define DIDT_DBR_EDC_PCC_PERF_COUNTER__PERF_COUNTER__SHIFT                                                    0x0
#define DIDT_DBR_EDC_PCC_PERF_COUNTER__PERF_COUNTER_MASK                                                      0xFFFFFFFFL
//DIDT_SQ_CTRL1
#define DIDT_SQ_CTRL1__MIN_POWER__SHIFT                                                                       0x0
#define DIDT_SQ_CTRL1__MAX_POWER__SHIFT                                                                       0x10
#define DIDT_SQ_CTRL1__MIN_POWER_MASK                                                                         0x0000FFFFL
#define DIDT_SQ_CTRL1__MAX_POWER_MASK                                                                         0xFFFF0000L
//DIDT_SQ_EDC_THRESHOLD
#define DIDT_SQ_EDC_THRESHOLD__EDC_THRESHOLD__SHIFT                                                           0x0
#define DIDT_SQ_EDC_THRESHOLD__EDC_THRESHOLD_MASK                                                             0xFFFFFFFFL
//DIDT_DB_CTRL1
#define DIDT_DB_CTRL1__MIN_POWER__SHIFT                                                                       0x0
#define DIDT_DB_CTRL1__MAX_POWER__SHIFT                                                                       0x10
#define DIDT_DB_CTRL1__MIN_POWER_MASK                                                                         0x0000FFFFL
#define DIDT_DB_CTRL1__MAX_POWER_MASK                                                                         0xFFFF0000L
//DIDT_DB_EDC_THRESHOLD
#define DIDT_DB_EDC_THRESHOLD__EDC_THRESHOLD__SHIFT                                                           0x0
#define DIDT_DB_EDC_THRESHOLD__EDC_THRESHOLD_MASK                                                             0xFFFFFFFFL
//DIDT_TD_CTRL1
#define DIDT_TD_CTRL1__MIN_POWER__SHIFT                                                                       0x0
#define DIDT_TD_CTRL1__MAX_POWER__SHIFT                                                                       0x10
#define DIDT_TD_CTRL1__MIN_POWER_MASK                                                                         0x0000FFFFL
#define DIDT_TD_CTRL1__MAX_POWER_MASK                                                                         0xFFFF0000L
//DIDT_TD_EDC_THRESHOLD
#define DIDT_TD_EDC_THRESHOLD__EDC_THRESHOLD__SHIFT                                                           0x0
#define DIDT_TD_EDC_THRESHOLD__EDC_THRESHOLD_MASK                                                             0xFFFFFFFFL
//DIDT_TCP_CTRL1
#define DIDT_TCP_CTRL1__MIN_POWER__SHIFT                                                                      0x0
#define DIDT_TCP_CTRL1__MAX_POWER__SHIFT                                                                      0x10
#define DIDT_TCP_CTRL1__MIN_POWER_MASK                                                                        0x0000FFFFL
#define DIDT_TCP_CTRL1__MAX_POWER_MASK                                                                        0xFFFF0000L
//DIDT_TCP_EDC_THRESHOLD
#define DIDT_TCP_EDC_THRESHOLD__EDC_THRESHOLD__SHIFT                                                          0x0
#define DIDT_TCP_EDC_THRESHOLD__EDC_THRESHOLD_MASK                                                            0xFFFFFFFFL


// addressBlock: gc_cpdec
//CP_CPC_STATUS
#define CP_CPC_STATUS__MEC1_BUSY__SHIFT                                                                       0x0
#define CP_CPC_STATUS__MEC2_BUSY__SHIFT                                                                       0x1
#define CP_CPC_STATUS__DC0_BUSY__SHIFT                                                                        0x2
#define CP_CPC_STATUS__DC1_BUSY__SHIFT                                                                        0x3
#define CP_CPC_STATUS__RCIU1_BUSY__SHIFT                                                                      0x4
#define CP_CPC_STATUS__RCIU2_BUSY__SHIFT                                                                      0x5
#define CP_CPC_STATUS__ROQ1_BUSY__SHIFT                                                                       0x6
#define CP_CPC_STATUS__ROQ2_BUSY__SHIFT                                                                       0x7
#define CP_CPC_STATUS__TCIU_BUSY__SHIFT                                                                       0xa
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY__SHIFT                                                                0xb
#define CP_CPC_STATUS__QU_BUSY__SHIFT                                                                         0xc
#define CP_CPC_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0xd
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY__SHIFT                                                               0xe
#define CP_CPC_STATUS__CPG_CPC_BUSY__SHIFT                                                                    0x1d
#define CP_CPC_STATUS__CPF_CPC_BUSY__SHIFT                                                                    0x1e
#define CP_CPC_STATUS__CPC_BUSY__SHIFT                                                                        0x1f
#define CP_CPC_STATUS__MEC1_BUSY_MASK                                                                         0x00000001L
#define CP_CPC_STATUS__MEC2_BUSY_MASK                                                                         0x00000002L
#define CP_CPC_STATUS__DC0_BUSY_MASK                                                                          0x00000004L
#define CP_CPC_STATUS__DC1_BUSY_MASK                                                                          0x00000008L
#define CP_CPC_STATUS__RCIU1_BUSY_MASK                                                                        0x00000010L
#define CP_CPC_STATUS__RCIU2_BUSY_MASK                                                                        0x00000020L
#define CP_CPC_STATUS__ROQ1_BUSY_MASK                                                                         0x00000040L
#define CP_CPC_STATUS__ROQ2_BUSY_MASK                                                                         0x00000080L
#define CP_CPC_STATUS__TCIU_BUSY_MASK                                                                         0x00000400L
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY_MASK                                                                  0x00000800L
#define CP_CPC_STATUS__QU_BUSY_MASK                                                                           0x00001000L
#define CP_CPC_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00002000L
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY_MASK                                                                 0x00004000L
#define CP_CPC_STATUS__CPG_CPC_BUSY_MASK                                                                      0x20000000L
#define CP_CPC_STATUS__CPF_CPC_BUSY_MASK                                                                      0x40000000L
#define CP_CPC_STATUS__CPC_BUSY_MASK                                                                          0x80000000L
//CP_CPC_BUSY_STAT
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY__SHIFT                                                          0x1
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY__SHIFT                                                          0x4
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY__SHIFT                                                           0x5
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY__SHIFT                                                           0x6
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x9
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY__SHIFT                                                               0x10
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY__SHIFT                                                          0x11
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY__SHIFT                                                              0x12
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY__SHIFT                                                            0x13
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY__SHIFT                                                          0x14
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY__SHIFT                                                           0x15
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY__SHIFT                                                           0x16
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY__SHIFT                                                                 0x17
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY__SHIFT                                                                0x18
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x19
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY__SHIFT                                                              0x1a
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY__SHIFT                                                              0x1b
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY__SHIFT                                                              0x1c
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY__SHIFT                                                              0x1d
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY_MASK                                                            0x00000002L
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY_MASK                                                            0x00000010L
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY_MASK                                                             0x00000020L
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY_MASK                                                             0x00000040L
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY_MASK                                                        0x00000200L
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY_MASK                                                                0x00002000L
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY_MASK                                                                 0x00010000L
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY_MASK                                                            0x00020000L
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY_MASK                                                                0x00040000L
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY_MASK                                                              0x00080000L
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY_MASK                                                            0x00100000L
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY_MASK                                                             0x00200000L
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY_MASK                                                             0x00400000L
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY_MASK                                                                   0x00800000L
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY_MASK                                                                  0x01000000L
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY_MASK                                                        0x02000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY_MASK                                                                0x04000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY_MASK                                                                0x08000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY_MASK                                                                0x10000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY_MASK                                                                0x20000000L
//CP_CPC_STALLED_STAT1
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL__SHIFT                                                       0x3
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION__SHIFT                                                      0x4
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL__SHIFT                                                       0x6
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET__SHIFT                                                     0x8
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU__SHIFT                                                        0x9
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ__SHIFT                                                   0xa
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA__SHIFT                                                    0xd
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET__SHIFT                                                     0x10
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU__SHIFT                                                        0x11
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ__SHIFT                                                   0x12
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA__SHIFT                                                    0x15
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x16
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x17
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS__SHIFT                                                   0x18
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL_MASK                                                         0x00000008L
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION_MASK                                                        0x00000010L
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL_MASK                                                         0x00000040L
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET_MASK                                                       0x00000100L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_MASK                                                          0x00000200L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ_MASK                                                     0x00000400L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA_MASK                                                      0x00002000L
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET_MASK                                                       0x00010000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_MASK                                                          0x00020000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ_MASK                                                     0x00040000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA_MASK                                                      0x00200000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00400000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00800000L
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS_MASK                                                     0x01000000L
//CP_CPF_STATUS
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY__SHIFT                                                              0x0
#define CP_CPF_STATUS__CSF_BUSY__SHIFT                                                                        0x1
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY__SHIFT                                                                  0x4
#define CP_CPF_STATUS__ROQ_RING_BUSY__SHIFT                                                                   0x5
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY__SHIFT                                                              0x6
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY__SHIFT                                                              0x7
#define CP_CPF_STATUS__ROQ_STATE_BUSY__SHIFT                                                                  0x8
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY__SHIFT                                                                0x9
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                           0xa
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                           0xb
#define CP_CPF_STATUS__SEMAPHORE_BUSY__SHIFT                                                                  0xc
#define CP_CPF_STATUS__INTERRUPT_BUSY__SHIFT                                                                  0xd
#define CP_CPF_STATUS__TCIU_BUSY__SHIFT                                                                       0xe
#define CP_CPF_STATUS__HQD_BUSY__SHIFT                                                                        0xf
#define CP_CPF_STATUS__PRT_BUSY__SHIFT                                                                        0x10
#define CP_CPF_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0x11
#define CP_CPF_STATUS__CPF_GFX_BUSY__SHIFT                                                                    0x1a
#define CP_CPF_STATUS__CPF_CMP_BUSY__SHIFT                                                                    0x1b
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY__SHIFT                                                              0x1c
#define CP_CPF_STATUS__CPC_CPF_BUSY__SHIFT                                                                    0x1e
#define CP_CPF_STATUS__CPF_BUSY__SHIFT                                                                        0x1f
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY_MASK                                                                0x00000001L
#define CP_CPF_STATUS__CSF_BUSY_MASK                                                                          0x00000002L
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY_MASK                                                                    0x00000010L
#define CP_CPF_STATUS__ROQ_RING_BUSY_MASK                                                                     0x00000020L
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY_MASK                                                                0x00000040L
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY_MASK                                                                0x00000080L
#define CP_CPF_STATUS__ROQ_STATE_BUSY_MASK                                                                    0x00000100L
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY_MASK                                                             0x00000400L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY_MASK                                                             0x00000800L
#define CP_CPF_STATUS__SEMAPHORE_BUSY_MASK                                                                    0x00001000L
#define CP_CPF_STATUS__INTERRUPT_BUSY_MASK                                                                    0x00002000L
#define CP_CPF_STATUS__TCIU_BUSY_MASK                                                                         0x00004000L
#define CP_CPF_STATUS__HQD_BUSY_MASK                                                                          0x00008000L
#define CP_CPF_STATUS__PRT_BUSY_MASK                                                                          0x00010000L
#define CP_CPF_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00020000L
#define CP_CPF_STATUS__CPF_GFX_BUSY_MASK                                                                      0x04000000L
#define CP_CPF_STATUS__CPF_CMP_BUSY_MASK                                                                      0x08000000L
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY_MASK                                                                0x30000000L
#define CP_CPF_STATUS__CPC_CPF_BUSY_MASK                                                                      0x40000000L
#define CP_CPF_STATUS__CPF_BUSY_MASK                                                                          0x80000000L
//CP_CPF_BUSY_STAT
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                            0x0
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY__SHIFT                                                                0x1
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY__SHIFT                                                           0x2
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY__SHIFT                                                           0x3
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY__SHIFT                                                               0x4
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY__SHIFT                                                            0x5
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY__SHIFT                                                            0x6
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY__SHIFT                                                             0x7
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY__SHIFT                                                               0x8
#define CP_CPF_BUSY_STAT__OUTSTANDING_READ_TAGS__SHIFT                                                        0x9
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY__SHIFT                                                      0xb
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY__SHIFT                                                            0xc
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY__SHIFT                                                            0xd
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY__SHIFT                                                         0xe
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY__SHIFT                                                      0xf
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY__SHIFT                                                    0x10
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY__SHIFT                                                             0x11
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY__SHIFT                                                          0x12
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY__SHIFT                                                          0x13
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY__SHIFT                                                          0x14
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY__SHIFT                                                         0x15
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY__SHIFT                                                       0x16
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY__SHIFT                                                         0x17
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY__SHIFT                                                           0x18
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY__SHIFT                                                             0x19
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY__SHIFT                                                              0x1a
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY__SHIFT                                                              0x1b
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY__SHIFT                                                              0x1c
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY__SHIFT                                                           0x1d
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY__SHIFT                                                                  0x1e
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY__SHIFT                                                                  0x1f
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                              0x00000001L
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY_MASK                                                                  0x00000002L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY_MASK                                                             0x00000004L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY_MASK                                                             0x00000008L
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY_MASK                                                                 0x00000010L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY_MASK                                                              0x00000020L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY_MASK                                                              0x00000040L
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY_MASK                                                               0x00000080L
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY_MASK                                                                 0x00000100L
#define CP_CPF_BUSY_STAT__OUTSTANDING_READ_TAGS_MASK                                                          0x00000200L
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY_MASK                                                        0x00000800L
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY_MASK                                                              0x00001000L
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY_MASK                                                              0x00002000L
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY_MASK                                                           0x00004000L
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY_MASK                                                        0x00008000L
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY_MASK                                                      0x00010000L
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY_MASK                                                               0x00020000L
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY_MASK                                                            0x00040000L
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY_MASK                                                            0x00080000L
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY_MASK                                                            0x00100000L
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY_MASK                                                           0x00200000L
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY_MASK                                                         0x00400000L
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY_MASK                                                           0x00800000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY_MASK                                                             0x01000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY_MASK                                                               0x02000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY_MASK                                                                0x04000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY_MASK                                                                0x08000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY_MASK                                                                0x10000000L
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY_MASK                                                             0x20000000L
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY_MASK                                                                    0x40000000L
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY_MASK                                                                    0x80000000L
//CP_CPF_STALLED_STAT1
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA__SHIFT                                                       0x0
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA__SHIFT                                                      0x1
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA__SHIFT                                                      0x2
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA__SHIFT                                                      0x3
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE__SHIFT                                                     0x5
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS__SHIFT                                                     0x6
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x7
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x8
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS__SHIFT                                               0x9
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS__SHIFT                                               0xa
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE__SHIFT                                                     0xb
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA_MASK                                                         0x00000001L
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA_MASK                                                        0x00000002L
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA_MASK                                                        0x00000004L
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA_MASK                                                        0x00000008L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE_MASK                                                       0x00000020L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS_MASK                                                       0x00000040L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00000080L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00000100L
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000200L
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000400L
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE_MASK                                                       0x00000800L
//CP_CPC_GRBM_FREE_COUNT
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x0000003FL
//CP_CPC_PRIV_VIOLATION_ADDR
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR__SHIFT                                                0x0
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR_MASK                                                  0x0000FFFFL
//CP_MEC_CNTL
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE__SHIFT                                                             0x4
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET__SHIFT                                                               0x10
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET__SHIFT                                                               0x11
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET__SHIFT                                                               0x12
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET__SHIFT                                                               0x13
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET__SHIFT                                                               0x14
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET__SHIFT                                                               0x15
#define CP_MEC_CNTL__MEC_ME2_HALT__SHIFT                                                                      0x1c
#define CP_MEC_CNTL__MEC_ME2_STEP__SHIFT                                                                      0x1d
#define CP_MEC_CNTL__MEC_ME1_HALT__SHIFT                                                                      0x1e
#define CP_MEC_CNTL__MEC_ME1_STEP__SHIFT                                                                      0x1f
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE_MASK                                                               0x00000010L
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET_MASK                                                                 0x00010000L
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET_MASK                                                                 0x00020000L
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET_MASK                                                                 0x00040000L
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET_MASK                                                                 0x00080000L
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET_MASK                                                                 0x00100000L
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET_MASK                                                                 0x00200000L
#define CP_MEC_CNTL__MEC_ME2_HALT_MASK                                                                        0x10000000L
#define CP_MEC_CNTL__MEC_ME2_STEP_MASK                                                                        0x20000000L
#define CP_MEC_CNTL__MEC_ME1_HALT_MASK                                                                        0x40000000L
#define CP_MEC_CNTL__MEC_ME1_STEP_MASK                                                                        0x80000000L
//CP_MEC_ME1_HEADER_DUMP
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_MEC_ME2_HEADER_DUMP
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_CPC_SCRATCH_INDEX
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX__SHIFT                                                            0x0
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_MASK                                                              0x000001FFL
//CP_CPC_SCRATCH_DATA
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA__SHIFT                                                              0x0
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA_MASK                                                                0xFFFFFFFFL
//CP_CPF_GRBM_FREE_COUNT
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x00000007L
//CP_CPC_HALT_HYST_COUNT
#define CP_CPC_HALT_HYST_COUNT__COUNT__SHIFT                                                                  0x0
#define CP_CPC_HALT_HYST_COUNT__COUNT_MASK                                                                    0x0000000FL
//CP_CE_COMPARE_COUNT
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT__SHIFT                                                             0x0
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_CE_DE_COUNT
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_DE_CE_COUNT
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT__SHIFT                                                             0x0
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_DE_LAST_INVAL_COUNT
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT__SHIFT                                                       0x0
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT_MASK                                                         0xFFFFFFFFL
//CP_DE_DE_COUNT
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_STALLED_STAT3
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                     0x0
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV__SHIFT                                        0x1
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER__SHIFT                                     0x2
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY__SHIFT                                                       0x3
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY__SHIFT                                                       0x4
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY__SHIFT                                                      0x5
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV__SHIFT                                                0x6
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV__SHIFT                                                 0x7
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA__SHIFT                                                    0xa
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER__SHIFT                                                     0xc
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW__SHIFT                                           0xd
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE__SHIFT                                                         0xe
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS__SHIFT                                                         0xf
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0x10
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0x11
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE__SHIFT                                                      0x12
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                      0x13
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS__SHIFT                                                       0x14
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV_MASK                                                       0x00000001L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV_MASK                                          0x00000002L
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER_MASK                                       0x00000004L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY_MASK                                                         0x00000008L
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY_MASK                                                         0x00000010L
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY_MASK                                                        0x00000020L
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV_MASK                                                  0x00000040L
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV_MASK                                                   0x00000080L
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA_MASK                                                      0x00000400L
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_MASK                                                       0x00001000L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW_MASK                                             0x00002000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE_MASK                                                           0x00004000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS_MASK                                                           0x00008000L
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00010000L
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00020000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE_MASK                                                        0x00040000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS_MASK                                                        0x00080000L
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS_MASK                                                         0x00100000L
//CP_STALLED_STAT1
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV__SHIFT                                                   0x0
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV__SHIFT                                                 0x4
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG__SHIFT                                                 0xa
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0xc
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0xd
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA__SHIFT                                                   0xe
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA__SHIFT                                                  0xf
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE__SHIFT                                                     0x17
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE__SHIFT                                                    0x18
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE__SHIFT                                                     0x19
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ__SHIFT                                                      0x1a
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ__SHIFT                                                     0x1b
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ__SHIFT                                                  0x1c
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION__SHIFT                                                 0x1d
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV_MASK                                                     0x00000001L
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_MASK                                                   0x00000010L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG_MASK                                                   0x00000400L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00001000L
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00002000L
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA_MASK                                                     0x00004000L
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA_MASK                                                    0x00008000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE_MASK                                                       0x00800000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE_MASK                                                      0x01000000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE_MASK                                                       0x02000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ_MASK                                                        0x04000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ_MASK                                                       0x08000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ_MASK                                                    0x10000000L
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION_MASK                                                   0x20000000L
//CP_STALLED_STAT2
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                    0x0
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV__SHIFT                                                    0x1
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING__SHIFT                                                    0x4
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING__SHIFT                                                        0x5
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA__SHIFT                                                   0x8
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER__SHIFT                                                        0x9
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER__SHIFT                                                      0xa
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME__SHIFT                                                     0xb
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV__SHIFT                                                       0xc
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV__SHIFT                                                   0xd
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP__SHIFT                                                     0xe
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH__SHIFT                                                  0xf
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x10
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x11
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ__SHIFT                                                     0x12
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                 0x13
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                               0x14
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_SC_EOP_DONE__SHIFT                                                  0x15
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_WR_CONFIRM__SHIFT                                                   0x16
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING__SHIFT                                                0x17
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING__SHIFT                                                   0x18
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE__SHIFT                                                   0x19
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE__SHIFT                                                   0x1a
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM__SHIFT                                                    0x1b
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION__SHIFT                                                      0x1c
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE__SHIFT                                              0x1d
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS__SHIFT                                                   0x1e
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN__SHIFT                                                    0x1f
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV_MASK                                                      0x00000001L
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV_MASK                                                      0x00000002L
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING_MASK                                                      0x00000010L
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING_MASK                                                          0x00000020L
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA_MASK                                                     0x00000100L
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER_MASK                                                          0x00000200L
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER_MASK                                                        0x00000400L
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME_MASK                                                       0x00000800L
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV_MASK                                                         0x00001000L
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV_MASK                                                     0x00002000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP_MASK                                                       0x00004000L
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH_MASK                                                    0x00008000L
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00010000L
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00020000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ_MASK                                                       0x00040000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM_MASK                                                   0x00080000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                 0x00100000L
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_SC_EOP_DONE_MASK                                                    0x00200000L
#define CP_STALLED_STAT2__EOPD_FIFO_NEEDS_WR_CONFIRM_MASK                                                     0x00400000L
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING_MASK                                                  0x00800000L
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING_MASK                                                     0x01000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE_MASK                                                     0x02000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE_MASK                                                     0x04000000L
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM_MASK                                                      0x08000000L
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION_MASK                                                        0x10000000L
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE_MASK                                                0x20000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS_MASK                                                     0x40000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN_MASK                                                      0x80000000L
//CP_BUSY_STAT
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                                0x0
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO__SHIFT                                                               0x6
#define CP_BUSY_STAT__PFP_PARSING_PACKETS__SHIFT                                                              0x7
#define CP_BUSY_STAT__ME_PARSING_PACKETS__SHIFT                                                               0x8
#define CP_BUSY_STAT__RCIU_PFP_BUSY__SHIFT                                                                    0x9
#define CP_BUSY_STAT__RCIU_ME_BUSY__SHIFT                                                                     0xa
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY__SHIFT                                                            0xc
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING__SHIFT                                                           0xd
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS__SHIFT                                                             0xe
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY__SHIFT                                                                 0xf
#define CP_BUSY_STAT__ME_PARSER_BUSY__SHIFT                                                                   0x11
#define CP_BUSY_STAT__EOP_DONE_BUSY__SHIFT                                                                    0x12
#define CP_BUSY_STAT__STRM_OUT_BUSY__SHIFT                                                                    0x13
#define CP_BUSY_STAT__PIPE_STATS_BUSY__SHIFT                                                                  0x14
#define CP_BUSY_STAT__RCIU_CE_BUSY__SHIFT                                                                     0x15
#define CP_BUSY_STAT__CE_PARSING_PACKETS__SHIFT                                                               0x16
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                                  0x00000001L
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO_MASK                                                                 0x00000040L
#define CP_BUSY_STAT__PFP_PARSING_PACKETS_MASK                                                                0x00000080L
#define CP_BUSY_STAT__ME_PARSING_PACKETS_MASK                                                                 0x00000100L
#define CP_BUSY_STAT__RCIU_PFP_BUSY_MASK                                                                      0x00000200L
#define CP_BUSY_STAT__RCIU_ME_BUSY_MASK                                                                       0x00000400L
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY_MASK                                                              0x00001000L
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING_MASK                                                             0x00002000L
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS_MASK                                                               0x00004000L
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY_MASK                                                                   0x00008000L
#define CP_BUSY_STAT__ME_PARSER_BUSY_MASK                                                                     0x00020000L
#define CP_BUSY_STAT__EOP_DONE_BUSY_MASK                                                                      0x00040000L
#define CP_BUSY_STAT__STRM_OUT_BUSY_MASK                                                                      0x00080000L
#define CP_BUSY_STAT__PIPE_STATS_BUSY_MASK                                                                    0x00100000L
#define CP_BUSY_STAT__RCIU_CE_BUSY_MASK                                                                       0x00200000L
#define CP_BUSY_STAT__CE_PARSING_PACKETS_MASK                                                                 0x00400000L
//CP_STAT
#define CP_STAT__ROQ_RING_BUSY__SHIFT                                                                         0x9
#define CP_STAT__ROQ_INDIRECT1_BUSY__SHIFT                                                                    0xa
#define CP_STAT__ROQ_INDIRECT2_BUSY__SHIFT                                                                    0xb
#define CP_STAT__ROQ_STATE_BUSY__SHIFT                                                                        0xc
#define CP_STAT__DC_BUSY__SHIFT                                                                               0xd
#define CP_STAT__UTCL2IU_BUSY__SHIFT                                                                          0xe
#define CP_STAT__PFP_BUSY__SHIFT                                                                              0xf
#define CP_STAT__MEQ_BUSY__SHIFT                                                                              0x10
#define CP_STAT__ME_BUSY__SHIFT                                                                               0x11
#define CP_STAT__QUERY_BUSY__SHIFT                                                                            0x12
#define CP_STAT__SEMAPHORE_BUSY__SHIFT                                                                        0x13
#define CP_STAT__INTERRUPT_BUSY__SHIFT                                                                        0x14
#define CP_STAT__SURFACE_SYNC_BUSY__SHIFT                                                                     0x15
#define CP_STAT__DMA_BUSY__SHIFT                                                                              0x16
#define CP_STAT__RCIU_BUSY__SHIFT                                                                             0x17
#define CP_STAT__SCRATCH_RAM_BUSY__SHIFT                                                                      0x18
#define CP_STAT__CE_BUSY__SHIFT                                                                               0x1a
#define CP_STAT__TCIU_BUSY__SHIFT                                                                             0x1b
#define CP_STAT__ROQ_CE_RING_BUSY__SHIFT                                                                      0x1c
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                                 0x1d
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                                 0x1e
#define CP_STAT__CP_BUSY__SHIFT                                                                               0x1f
#define CP_STAT__ROQ_RING_BUSY_MASK                                                                           0x00000200L
#define CP_STAT__ROQ_INDIRECT1_BUSY_MASK                                                                      0x00000400L
#define CP_STAT__ROQ_INDIRECT2_BUSY_MASK                                                                      0x00000800L
#define CP_STAT__ROQ_STATE_BUSY_MASK                                                                          0x00001000L
#define CP_STAT__DC_BUSY_MASK                                                                                 0x00002000L
#define CP_STAT__UTCL2IU_BUSY_MASK                                                                            0x00004000L
#define CP_STAT__PFP_BUSY_MASK                                                                                0x00008000L
#define CP_STAT__MEQ_BUSY_MASK                                                                                0x00010000L
#define CP_STAT__ME_BUSY_MASK                                                                                 0x00020000L
#define CP_STAT__QUERY_BUSY_MASK                                                                              0x00040000L
#define CP_STAT__SEMAPHORE_BUSY_MASK                                                                          0x00080000L
#define CP_STAT__INTERRUPT_BUSY_MASK                                                                          0x00100000L
#define CP_STAT__SURFACE_SYNC_BUSY_MASK                                                                       0x00200000L
#define CP_STAT__DMA_BUSY_MASK                                                                                0x00400000L
#define CP_STAT__RCIU_BUSY_MASK                                                                               0x00800000L
#define CP_STAT__SCRATCH_RAM_BUSY_MASK                                                                        0x01000000L
#define CP_STAT__CE_BUSY_MASK                                                                                 0x04000000L
#define CP_STAT__TCIU_BUSY_MASK                                                                               0x08000000L
#define CP_STAT__ROQ_CE_RING_BUSY_MASK                                                                        0x10000000L
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY_MASK                                                                   0x20000000L
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY_MASK                                                                   0x40000000L
#define CP_STAT__CP_BUSY_MASK                                                                                 0x80000000L
//CP_ME_HEADER_DUMP
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP__SHIFT                                                              0x0
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_HEADER_DUMP
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP__SHIFT                                                            0x0
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_GRBM_FREE_COUNT
#define CP_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                                 0x0
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS__SHIFT                                                             0x8
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP__SHIFT                                                             0x10
#define CP_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                                   0x0000003FL
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS_MASK                                                               0x00003F00L
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP_MASK                                                               0x003F0000L
//CP_CE_HEADER_DUMP
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP__SHIFT                                                              0x0
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_INSTR_PNTR
#define CP_PFP_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                  0x0
#define CP_PFP_INSTR_PNTR__INSTR_PNTR_MASK                                                                    0x0000FFFFL
//CP_ME_INSTR_PNTR
#define CP_ME_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_ME_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_CE_INSTR_PNTR
#define CP_CE_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_CE_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_MEC1_INSTR_PNTR
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_MEC2_INSTR_PNTR
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_CSF_STAT
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT__SHIFT                                                              0x8
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT_MASK                                                                0x0001FF00L
//CP_ME_CNTL
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE__SHIFT                                                               0x4
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE__SHIFT                                                              0x6
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE__SHIFT                                                               0x8
#define CP_ME_CNTL__CE_PIPE0_RESET__SHIFT                                                                     0x10
#define CP_ME_CNTL__CE_PIPE1_RESET__SHIFT                                                                     0x11
#define CP_ME_CNTL__PFP_PIPE0_RESET__SHIFT                                                                    0x12
#define CP_ME_CNTL__PFP_PIPE1_RESET__SHIFT                                                                    0x13
#define CP_ME_CNTL__ME_PIPE0_RESET__SHIFT                                                                     0x14
#define CP_ME_CNTL__ME_PIPE1_RESET__SHIFT                                                                     0x15
#define CP_ME_CNTL__CE_HALT__SHIFT                                                                            0x18
#define CP_ME_CNTL__CE_STEP__SHIFT                                                                            0x19
#define CP_ME_CNTL__PFP_HALT__SHIFT                                                                           0x1a
#define CP_ME_CNTL__PFP_STEP__SHIFT                                                                           0x1b
#define CP_ME_CNTL__ME_HALT__SHIFT                                                                            0x1c
#define CP_ME_CNTL__ME_STEP__SHIFT                                                                            0x1d
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE_MASK                                                                 0x00000010L
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE_MASK                                                                0x00000040L
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE_MASK                                                                 0x00000100L
#define CP_ME_CNTL__CE_PIPE0_RESET_MASK                                                                       0x00010000L
#define CP_ME_CNTL__CE_PIPE1_RESET_MASK                                                                       0x00020000L
#define CP_ME_CNTL__PFP_PIPE0_RESET_MASK                                                                      0x00040000L
#define CP_ME_CNTL__PFP_PIPE1_RESET_MASK                                                                      0x00080000L
#define CP_ME_CNTL__ME_PIPE0_RESET_MASK                                                                       0x00100000L
#define CP_ME_CNTL__ME_PIPE1_RESET_MASK                                                                       0x00200000L
#define CP_ME_CNTL__CE_HALT_MASK                                                                              0x01000000L
#define CP_ME_CNTL__CE_STEP_MASK                                                                              0x02000000L
#define CP_ME_CNTL__PFP_HALT_MASK                                                                             0x04000000L
#define CP_ME_CNTL__PFP_STEP_MASK                                                                             0x08000000L
#define CP_ME_CNTL__ME_HALT_MASK                                                                              0x10000000L
#define CP_ME_CNTL__ME_STEP_MASK                                                                              0x20000000L
//CP_CNTX_STAT
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS__SHIFT                                                             0x0
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT__SHIFT                                                             0x8
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS__SHIFT                                                              0x14
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT__SHIFT                                                              0x1c
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS_MASK                                                               0x000000FFL
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT_MASK                                                               0x00000700L
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS_MASK                                                                0x0FF00000L
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT_MASK                                                                0x70000000L
//CP_ME_PREEMPTION
#define CP_ME_PREEMPTION__OBSOLETE__SHIFT                                                                     0x0
#define CP_ME_PREEMPTION__OBSOLETE_MASK                                                                       0x00000001L
//CP_ROQ_THRESHOLDS
#define CP_ROQ_THRESHOLDS__IB1_START__SHIFT                                                                   0x0
#define CP_ROQ_THRESHOLDS__IB2_START__SHIFT                                                                   0x8
#define CP_ROQ_THRESHOLDS__IB1_START_MASK                                                                     0x000000FFL
#define CP_ROQ_THRESHOLDS__IB2_START_MASK                                                                     0x0000FF00L
//CP_MEQ_STQ_THRESHOLD
#define CP_MEQ_STQ_THRESHOLD__STQ_START__SHIFT                                                                0x0
#define CP_MEQ_STQ_THRESHOLD__STQ_START_MASK                                                                  0x000000FFL
//CP_RB2_RPTR
#define CP_RB2_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB2_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB1_RPTR
#define CP_RB1_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB1_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB0_RPTR
#define CP_RB0_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB0_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB_RPTR
#define CP_RB_RPTR__RB_RPTR__SHIFT                                                                            0x0
#define CP_RB_RPTR__RB_RPTR_MASK                                                                              0x000FFFFFL
//CP_RB_WPTR_DELAY
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER__SHIFT                                                              0x0
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT__SHIFT                                                              0x1c
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER_MASK                                                                0x0FFFFFFFL
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT_MASK                                                                0xF0000000L
//CP_RB_WPTR_POLL_CNTL
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY__SHIFT                                                           0x0
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                          0x10
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY_MASK                                                             0x0000FFFFL
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                            0xFFFF0000L
//CP_ROQ1_THRESHOLDS
#define CP_ROQ1_THRESHOLDS__RB1_START__SHIFT                                                                  0x0
#define CP_ROQ1_THRESHOLDS__RB2_START__SHIFT                                                                  0x8
#define CP_ROQ1_THRESHOLDS__R0_IB1_START__SHIFT                                                               0x10
#define CP_ROQ1_THRESHOLDS__R1_IB1_START__SHIFT                                                               0x18
#define CP_ROQ1_THRESHOLDS__RB1_START_MASK                                                                    0x000000FFL
#define CP_ROQ1_THRESHOLDS__RB2_START_MASK                                                                    0x0000FF00L
#define CP_ROQ1_THRESHOLDS__R0_IB1_START_MASK                                                                 0x00FF0000L
#define CP_ROQ1_THRESHOLDS__R1_IB1_START_MASK                                                                 0xFF000000L
//CP_ROQ2_THRESHOLDS
#define CP_ROQ2_THRESHOLDS__R2_IB1_START__SHIFT                                                               0x0
#define CP_ROQ2_THRESHOLDS__R0_IB2_START__SHIFT                                                               0x8
#define CP_ROQ2_THRESHOLDS__R1_IB2_START__SHIFT                                                               0x10
#define CP_ROQ2_THRESHOLDS__R2_IB2_START__SHIFT                                                               0x18
#define CP_ROQ2_THRESHOLDS__R2_IB1_START_MASK                                                                 0x000000FFL
#define CP_ROQ2_THRESHOLDS__R0_IB2_START_MASK                                                                 0x0000FF00L
#define CP_ROQ2_THRESHOLDS__R1_IB2_START_MASK                                                                 0x00FF0000L
#define CP_ROQ2_THRESHOLDS__R2_IB2_START_MASK                                                                 0xFF000000L
//CP_STQ_THRESHOLDS
#define CP_STQ_THRESHOLDS__STQ0_START__SHIFT                                                                  0x0
#define CP_STQ_THRESHOLDS__STQ1_START__SHIFT                                                                  0x8
#define CP_STQ_THRESHOLDS__STQ2_START__SHIFT                                                                  0x10
#define CP_STQ_THRESHOLDS__STQ0_START_MASK                                                                    0x000000FFL
#define CP_STQ_THRESHOLDS__STQ1_START_MASK                                                                    0x0000FF00L
#define CP_STQ_THRESHOLDS__STQ2_START_MASK                                                                    0x00FF0000L
//CP_QUEUE_THRESHOLDS
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START__SHIFT                                                             0x0
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START__SHIFT                                                             0x8
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START_MASK                                                               0x0000003FL
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START_MASK                                                               0x00003F00L
//CP_MEQ_THRESHOLDS
#define CP_MEQ_THRESHOLDS__MEQ1_START__SHIFT                                                                  0x0
#define CP_MEQ_THRESHOLDS__MEQ2_START__SHIFT                                                                  0x8
#define CP_MEQ_THRESHOLDS__MEQ1_START_MASK                                                                    0x000000FFL
#define CP_MEQ_THRESHOLDS__MEQ2_START_MASK                                                                    0x0000FF00L
//CP_ROQ_AVAIL
#define CP_ROQ_AVAIL__ROQ_CNT_RING__SHIFT                                                                     0x0
#define CP_ROQ_AVAIL__ROQ_CNT_IB1__SHIFT                                                                      0x10
#define CP_ROQ_AVAIL__ROQ_CNT_RING_MASK                                                                       0x000007FFL
#define CP_ROQ_AVAIL__ROQ_CNT_IB1_MASK                                                                        0x07FF0000L
//CP_STQ_AVAIL
#define CP_STQ_AVAIL__STQ_CNT__SHIFT                                                                          0x0
#define CP_STQ_AVAIL__STQ_CNT_MASK                                                                            0x000001FFL
//CP_ROQ2_AVAIL
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2_MASK                                                                       0x000007FFL
//CP_MEQ_AVAIL
#define CP_MEQ_AVAIL__MEQ_CNT__SHIFT                                                                          0x0
#define CP_MEQ_AVAIL__MEQ_CNT_MASK                                                                            0x000003FFL
//CP_CMD_INDEX
#define CP_CMD_INDEX__CMD_INDEX__SHIFT                                                                        0x0
#define CP_CMD_INDEX__CMD_ME_SEL__SHIFT                                                                       0xc
#define CP_CMD_INDEX__CMD_QUEUE_SEL__SHIFT                                                                    0x10
#define CP_CMD_INDEX__CMD_INDEX_MASK                                                                          0x000007FFL
#define CP_CMD_INDEX__CMD_ME_SEL_MASK                                                                         0x00003000L
#define CP_CMD_INDEX__CMD_QUEUE_SEL_MASK                                                                      0x00070000L
//CP_CMD_DATA
#define CP_CMD_DATA__CMD_DATA__SHIFT                                                                          0x0
#define CP_CMD_DATA__CMD_DATA_MASK                                                                            0xFFFFFFFFL
//CP_ROQ_RB_STAT
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY__SHIFT                                                               0x0
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY__SHIFT                                                               0x10
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY_MASK                                                                 0x000003FFL
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY_MASK                                                                 0x03FF0000L
//CP_ROQ_IB1_STAT
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1__SHIFT                                                            0x0
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1__SHIFT                                                            0x10
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1_MASK                                                              0x000003FFL
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1_MASK                                                              0x03FF0000L
//CP_ROQ_IB2_STAT
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2__SHIFT                                                            0x0
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2__SHIFT                                                            0x10
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2_MASK                                                              0x000003FFL
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2_MASK                                                              0x03FF0000L
//CP_STQ_STAT
#define CP_STQ_STAT__STQ_RPTR__SHIFT                                                                          0x0
#define CP_STQ_STAT__STQ_RPTR_MASK                                                                            0x000003FFL
//CP_STQ_WR_STAT
#define CP_STQ_WR_STAT__STQ_WPTR__SHIFT                                                                       0x0
#define CP_STQ_WR_STAT__STQ_WPTR_MASK                                                                         0x000003FFL
//CP_MEQ_STAT
#define CP_MEQ_STAT__MEQ_RPTR__SHIFT                                                                          0x0
#define CP_MEQ_STAT__MEQ_WPTR__SHIFT                                                                          0x10
#define CP_MEQ_STAT__MEQ_RPTR_MASK                                                                            0x000003FFL
#define CP_MEQ_STAT__MEQ_WPTR_MASK                                                                            0x03FF0000L
//CP_CEQ1_AVAIL
#define CP_CEQ1_AVAIL__CEQ_CNT_RING__SHIFT                                                                    0x0
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1__SHIFT                                                                     0x10
#define CP_CEQ1_AVAIL__CEQ_CNT_RING_MASK                                                                      0x000007FFL
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1_MASK                                                                       0x07FF0000L
//CP_CEQ2_AVAIL
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2_MASK                                                                       0x000007FFL
//CP_CE_ROQ_RB_STAT
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY__SHIFT                                                            0x0
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY__SHIFT                                                            0x10
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY_MASK                                                              0x000003FFL
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY_MASK                                                              0x03FF0000L
//CP_CE_ROQ_IB1_STAT
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1__SHIFT                                                         0x0
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1__SHIFT                                                         0x10
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1_MASK                                                           0x000003FFL
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1_MASK                                                           0x03FF0000L
//CP_CE_ROQ_IB2_STAT
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2__SHIFT                                                         0x0
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2__SHIFT                                                         0x10
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2_MASK                                                           0x000003FFL
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2_MASK                                                           0x03FF0000L
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED__SHIFT                                                     0x16
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                       0x17
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED_MASK                                                       0x00400000L
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                         0x00800000L
//CP_PRIV_VIOLATION_ADDR
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR__SHIFT                                                    0x0
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR_MASK                                                      0x0000FFFFL


// addressBlock: gc_cppdec
//CP_EOPQ_WAIT_TIME
#define CP_EOPQ_WAIT_TIME__WAIT_TIME__SHIFT                                                                   0x0
#define CP_EOPQ_WAIT_TIME__SCALE_COUNT__SHIFT                                                                 0xa
#define CP_EOPQ_WAIT_TIME__WAIT_TIME_MASK                                                                     0x000003FFL
#define CP_EOPQ_WAIT_TIME__SCALE_COUNT_MASK                                                                   0x0003FC00L
//CP_CPC_MGCG_SYNC_CNTL
#define CP_CPC_MGCG_SYNC_CNTL__COOLDOWN_PERIOD__SHIFT                                                         0x0
#define CP_CPC_MGCG_SYNC_CNTL__WARMUP_PERIOD__SHIFT                                                           0x8
#define CP_CPC_MGCG_SYNC_CNTL__COOLDOWN_PERIOD_MASK                                                           0x000000FFL
#define CP_CPC_MGCG_SYNC_CNTL__WARMUP_PERIOD_MASK                                                             0x0000FF00L
//CPC_INT_INFO
#define CPC_INT_INFO__ADDR_HI__SHIFT                                                                          0x0
#define CPC_INT_INFO__TYPE__SHIFT                                                                             0x10
#define CPC_INT_INFO__VMID__SHIFT                                                                             0x14
#define CPC_INT_INFO__QUEUE_ID__SHIFT                                                                         0x1c
#define CPC_INT_INFO__ADDR_HI_MASK                                                                            0x0000FFFFL
#define CPC_INT_INFO__TYPE_MASK                                                                               0x00010000L
#define CPC_INT_INFO__VMID_MASK                                                                               0x00F00000L
#define CPC_INT_INFO__QUEUE_ID_MASK                                                                           0x70000000L
//CP_VIRT_STATUS
#define CP_VIRT_STATUS__VIRT_STATUS__SHIFT                                                                    0x0
#define CP_VIRT_STATUS__VIRT_STATUS_MASK                                                                      0xFFFFFFFFL
//CPC_INT_ADDR
#define CPC_INT_ADDR__ADDR__SHIFT                                                                             0x0
#define CPC_INT_ADDR__ADDR_MASK                                                                               0xFFFFFFFFL
//CPC_INT_PASID
#define CPC_INT_PASID__PASID__SHIFT                                                                           0x0
#define CPC_INT_PASID__PASID_MASK                                                                             0x0000FFFFL
//CP_GFX_ERROR
#define CP_GFX_ERROR__EDC_ERROR_ID__SHIFT                                                                     0x0
#define CP_GFX_ERROR__SUA_ERROR__SHIFT                                                                        0x4
#define CP_GFX_ERROR__RSVD1_ERROR__SHIFT                                                                      0x5
#define CP_GFX_ERROR__RSVD2_ERROR__SHIFT                                                                      0x6
#define CP_GFX_ERROR__SEM_UTCL1_ERROR__SHIFT                                                                  0x7
#define CP_GFX_ERROR__QU_STRM_UTCL1_ERROR__SHIFT                                                              0x8
#define CP_GFX_ERROR__QU_EOP_UTCL1_ERROR__SHIFT                                                               0x9
#define CP_GFX_ERROR__QU_PIPE_UTCL1_ERROR__SHIFT                                                              0xa
#define CP_GFX_ERROR__QU_READ_UTCL1_ERROR__SHIFT                                                              0xb
#define CP_GFX_ERROR__SYNC_MEMRD_UTCL1_ERROR__SHIFT                                                           0xc
#define CP_GFX_ERROR__SYNC_MEMWR_UTCL1_ERROR__SHIFT                                                           0xd
#define CP_GFX_ERROR__SHADOW_UTCL1_ERROR__SHIFT                                                               0xe
#define CP_GFX_ERROR__APPEND_UTCL1_ERROR__SHIFT                                                               0xf
#define CP_GFX_ERROR__CE_DMA_UTCL1_ERROR__SHIFT                                                               0x10
#define CP_GFX_ERROR__PFP_VGTDMA_UTCL1_ERROR__SHIFT                                                           0x11
#define CP_GFX_ERROR__DMA_SRC_UTCL1_ERROR__SHIFT                                                              0x12
#define CP_GFX_ERROR__DMA_DST_UTCL1_ERROR__SHIFT                                                              0x13
#define CP_GFX_ERROR__PFP_TC_UTCL1_ERROR__SHIFT                                                               0x14
#define CP_GFX_ERROR__ME_TC_UTCL1_ERROR__SHIFT                                                                0x15
#define CP_GFX_ERROR__CE_TC_UTCL1_ERROR__SHIFT                                                                0x16
#define CP_GFX_ERROR__PRT_LOD_UTCL1_ERROR__SHIFT                                                              0x17
#define CP_GFX_ERROR__RDPTR_RPT_UTCL1_ERROR__SHIFT                                                            0x18
#define CP_GFX_ERROR__RB_FETCHER_UTCL1_ERROR__SHIFT                                                           0x19
#define CP_GFX_ERROR__I1_FETCHER_UTCL1_ERROR__SHIFT                                                           0x1a
#define CP_GFX_ERROR__I2_FETCHER_UTCL1_ERROR__SHIFT                                                           0x1b
#define CP_GFX_ERROR__C1_FETCHER_UTCL1_ERROR__SHIFT                                                           0x1c
#define CP_GFX_ERROR__C2_FETCHER_UTCL1_ERROR__SHIFT                                                           0x1d
#define CP_GFX_ERROR__ST_FETCHER_UTCL1_ERROR__SHIFT                                                           0x1e
#define CP_GFX_ERROR__CE_INIT_UTCL1_ERROR__SHIFT                                                              0x1f
#define CP_GFX_ERROR__EDC_ERROR_ID_MASK                                                                       0x0000000FL
#define CP_GFX_ERROR__SUA_ERROR_MASK                                                                          0x00000010L
#define CP_GFX_ERROR__RSVD1_ERROR_MASK                                                                        0x00000020L
#define CP_GFX_ERROR__RSVD2_ERROR_MASK                                                                        0x00000040L
#define CP_GFX_ERROR__SEM_UTCL1_ERROR_MASK                                                                    0x00000080L
#define CP_GFX_ERROR__QU_STRM_UTCL1_ERROR_MASK                                                                0x00000100L
#define CP_GFX_ERROR__QU_EOP_UTCL1_ERROR_MASK                                                                 0x00000200L
#define CP_GFX_ERROR__QU_PIPE_UTCL1_ERROR_MASK                                                                0x00000400L
#define CP_GFX_ERROR__QU_READ_UTCL1_ERROR_MASK                                                                0x00000800L
#define CP_GFX_ERROR__SYNC_MEMRD_UTCL1_ERROR_MASK                                                             0x00001000L
#define CP_GFX_ERROR__SYNC_MEMWR_UTCL1_ERROR_MASK                                                             0x00002000L
#define CP_GFX_ERROR__SHADOW_UTCL1_ERROR_MASK                                                                 0x00004000L
#define CP_GFX_ERROR__APPEND_UTCL1_ERROR_MASK                                                                 0x00008000L
#define CP_GFX_ERROR__CE_DMA_UTCL1_ERROR_MASK                                                                 0x00010000L
#define CP_GFX_ERROR__PFP_VGTDMA_UTCL1_ERROR_MASK                                                             0x00020000L
#define CP_GFX_ERROR__DMA_SRC_UTCL1_ERROR_MASK                                                                0x00040000L
#define CP_GFX_ERROR__DMA_DST_UTCL1_ERROR_MASK                                                                0x00080000L
#define CP_GFX_ERROR__PFP_TC_UTCL1_ERROR_MASK                                                                 0x00100000L
#define CP_GFX_ERROR__ME_TC_UTCL1_ERROR_MASK                                                                  0x00200000L
#define CP_GFX_ERROR__CE_TC_UTCL1_ERROR_MASK                                                                  0x00400000L
#define CP_GFX_ERROR__PRT_LOD_UTCL1_ERROR_MASK                                                                0x00800000L
#define CP_GFX_ERROR__RDPTR_RPT_UTCL1_ERROR_MASK                                                              0x01000000L
#define CP_GFX_ERROR__RB_FETCHER_UTCL1_ERROR_MASK                                                             0x02000000L
#define CP_GFX_ERROR__I1_FETCHER_UTCL1_ERROR_MASK                                                             0x04000000L
#define CP_GFX_ERROR__I2_FETCHER_UTCL1_ERROR_MASK                                                             0x08000000L
#define CP_GFX_ERROR__C1_FETCHER_UTCL1_ERROR_MASK                                                             0x10000000L
#define CP_GFX_ERROR__C2_FETCHER_UTCL1_ERROR_MASK                                                             0x20000000L
#define CP_GFX_ERROR__ST_FETCHER_UTCL1_ERROR_MASK                                                             0x40000000L
#define CP_GFX_ERROR__CE_INIT_UTCL1_ERROR_MASK                                                                0x80000000L
//CPG_UTCL1_CNTL
#define CPG_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                           0x0
#define CPG_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                0x17
#define CPG_UTCL1_CNTL__DROP_MODE__SHIFT                                                                      0x18
#define CPG_UTCL1_CNTL__BYPASS__SHIFT                                                                         0x19
#define CPG_UTCL1_CNTL__INVALIDATE__SHIFT                                                                     0x1a
#define CPG_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                0x1b
#define CPG_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                    0x1c
#define CPG_UTCL1_CNTL__FORCE_SD_VMID_DIRTY__SHIFT                                                            0x1d
#define CPG_UTCL1_CNTL__MTYPE_NO_PTE_MODE__SHIFT                                                              0x1e
#define CPG_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                             0x000FFFFFL
#define CPG_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                  0x00800000L
#define CPG_UTCL1_CNTL__DROP_MODE_MASK                                                                        0x01000000L
#define CPG_UTCL1_CNTL__BYPASS_MASK                                                                           0x02000000L
#define CPG_UTCL1_CNTL__INVALIDATE_MASK                                                                       0x04000000L
#define CPG_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                  0x08000000L
#define CPG_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                      0x10000000L
#define CPG_UTCL1_CNTL__FORCE_SD_VMID_DIRTY_MASK                                                              0x20000000L
#define CPG_UTCL1_CNTL__MTYPE_NO_PTE_MODE_MASK                                                                0x40000000L
//CPC_UTCL1_CNTL
#define CPC_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                           0x0
#define CPC_UTCL1_CNTL__DROP_MODE__SHIFT                                                                      0x18
#define CPC_UTCL1_CNTL__BYPASS__SHIFT                                                                         0x19
#define CPC_UTCL1_CNTL__INVALIDATE__SHIFT                                                                     0x1a
#define CPC_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                0x1b
#define CPC_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                    0x1c
#define CPC_UTCL1_CNTL__FORCE_SD_VMID_DIRTY__SHIFT                                                            0x1d
#define CPC_UTCL1_CNTL__MTYPE_NO_PTE_MODE__SHIFT                                                              0x1e
#define CPC_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                             0x000FFFFFL
#define CPC_UTCL1_CNTL__DROP_MODE_MASK                                                                        0x01000000L
#define CPC_UTCL1_CNTL__BYPASS_MASK                                                                           0x02000000L
#define CPC_UTCL1_CNTL__INVALIDATE_MASK                                                                       0x04000000L
#define CPC_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                  0x08000000L
#define CPC_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                      0x10000000L
#define CPC_UTCL1_CNTL__FORCE_SD_VMID_DIRTY_MASK                                                              0x20000000L
#define CPC_UTCL1_CNTL__MTYPE_NO_PTE_MODE_MASK                                                                0x40000000L
//CPF_UTCL1_CNTL
#define CPF_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                           0x0
#define CPF_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                0x17
#define CPF_UTCL1_CNTL__DROP_MODE__SHIFT                                                                      0x18
#define CPF_UTCL1_CNTL__BYPASS__SHIFT                                                                         0x19
#define CPF_UTCL1_CNTL__INVALIDATE__SHIFT                                                                     0x1a
#define CPF_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                0x1b
#define CPF_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                    0x1c
#define CPF_UTCL1_CNTL__FORCE_SD_VMID_DIRTY__SHIFT                                                            0x1d
#define CPF_UTCL1_CNTL__MTYPE_NO_PTE_MODE__SHIFT                                                              0x1e
#define CPF_UTCL1_CNTL__FORCE_NO_EXE__SHIFT                                                                   0x1f
#define CPF_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                             0x000FFFFFL
#define CPF_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                  0x00800000L
#define CPF_UTCL1_CNTL__DROP_MODE_MASK                                                                        0x01000000L
#define CPF_UTCL1_CNTL__BYPASS_MASK                                                                           0x02000000L
#define CPF_UTCL1_CNTL__INVALIDATE_MASK                                                                       0x04000000L
#define CPF_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                  0x08000000L
#define CPF_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                      0x10000000L
#define CPF_UTCL1_CNTL__FORCE_SD_VMID_DIRTY_MASK                                                              0x20000000L
#define CPF_UTCL1_CNTL__MTYPE_NO_PTE_MODE_MASK                                                                0x40000000L
#define CPF_UTCL1_CNTL__FORCE_NO_EXE_MASK                                                                     0x80000000L
//CP_AQL_SMM_STATUS
#define CP_AQL_SMM_STATUS__AQL_QUEUE_SMM__SHIFT                                                               0x0
#define CP_AQL_SMM_STATUS__AQL_QUEUE_SMM_MASK                                                                 0xFFFFFFFFL
//CP_RB0_BASE
#define CP_RB0_BASE__RB_BASE__SHIFT                                                                           0x0
#define CP_RB0_BASE__RB_BASE_MASK                                                                             0xFFFFFFFFL
//CP_RB_BASE
#define CP_RB_BASE__RB_BASE__SHIFT                                                                            0x0
#define CP_RB_BASE__RB_BASE_MASK                                                                              0xFFFFFFFFL
//CP_RB0_CNTL
#define CP_RB0_CNTL__RB_BUFSZ__SHIFT                                                                          0x0
#define CP_RB0_CNTL__RB_BLKSZ__SHIFT                                                                          0x8
#define CP_RB0_CNTL__BUF_SWAP__SHIFT                                                                          0x11
#define CP_RB0_CNTL__MIN_AVAILSZ__SHIFT                                                                       0x14
#define CP_RB0_CNTL__MIN_IB_AVAILSZ__SHIFT                                                                    0x16
#define CP_RB0_CNTL__CACHE_POLICY__SHIFT                                                                      0x18
#define CP_RB0_CNTL__RB_NO_UPDATE__SHIFT                                                                      0x1b
#define CP_RB0_CNTL__RB_RPTR_WR_ENA__SHIFT                                                                    0x1f
#define CP_RB0_CNTL__RB_BUFSZ_MASK                                                                            0x0000003FL
#define CP_RB0_CNTL__RB_BLKSZ_MASK                                                                            0x00003F00L
#define CP_RB0_CNTL__BUF_SWAP_MASK                                                                            0x00060000L
#define CP_RB0_CNTL__MIN_AVAILSZ_MASK                                                                         0x00300000L
#define CP_RB0_CNTL__MIN_IB_AVAILSZ_MASK                                                                      0x00C00000L
#define CP_RB0_CNTL__CACHE_POLICY_MASK                                                                        0x01000000L
#define CP_RB0_CNTL__RB_NO_UPDATE_MASK                                                                        0x08000000L
#define CP_RB0_CNTL__RB_RPTR_WR_ENA_MASK                                                                      0x80000000L
//CP_RB_CNTL
#define CP_RB_CNTL__RB_BUFSZ__SHIFT                                                                           0x0
#define CP_RB_CNTL__RB_BLKSZ__SHIFT                                                                           0x8
#define CP_RB_CNTL__MIN_AVAILSZ__SHIFT                                                                        0x14
#define CP_RB_CNTL__MIN_IB_AVAILSZ__SHIFT                                                                     0x16
#define CP_RB_CNTL__CACHE_POLICY__SHIFT                                                                       0x18
#define CP_RB_CNTL__RB_NO_UPDATE__SHIFT                                                                       0x1b
#define CP_RB_CNTL__RB_RPTR_WR_ENA__SHIFT                                                                     0x1f
#define CP_RB_CNTL__RB_BUFSZ_MASK                                                                             0x0000003FL
#define CP_RB_CNTL__RB_BLKSZ_MASK                                                                             0x00003F00L
#define CP_RB_CNTL__MIN_AVAILSZ_MASK                                                                          0x00300000L
#define CP_RB_CNTL__MIN_IB_AVAILSZ_MASK                                                                       0x00C00000L
#define CP_RB_CNTL__CACHE_POLICY_MASK                                                                         0x01000000L
#define CP_RB_CNTL__RB_NO_UPDATE_MASK                                                                         0x08000000L
#define CP_RB_CNTL__RB_RPTR_WR_ENA_MASK                                                                       0x80000000L
//CP_RB_RPTR_WR
#define CP_RB_RPTR_WR__RB_RPTR_WR__SHIFT                                                                      0x0
#define CP_RB_RPTR_WR__RB_RPTR_WR_MASK                                                                        0x000FFFFFL
//CP_RB0_RPTR_ADDR
#define CP_RB0_RPTR_ADDR__RB_RPTR_ADDR__SHIFT                                                                 0x2
#define CP_RB0_RPTR_ADDR__RB_RPTR_ADDR_MASK                                                                   0xFFFFFFFCL
//CP_RB_RPTR_ADDR
#define CP_RB_RPTR_ADDR__RB_RPTR_ADDR__SHIFT                                                                  0x2
#define CP_RB_RPTR_ADDR__RB_RPTR_ADDR_MASK                                                                    0xFFFFFFFCL
//CP_RB0_RPTR_ADDR_HI
#define CP_RB0_RPTR_ADDR_HI__RB_RPTR_ADDR_HI__SHIFT                                                           0x0
#define CP_RB0_RPTR_ADDR_HI__RB_RPTR_ADDR_HI_MASK                                                             0x0000FFFFL
//CP_RB_RPTR_ADDR_HI
#define CP_RB_RPTR_ADDR_HI__RB_RPTR_ADDR_HI__SHIFT                                                            0x0
#define CP_RB_RPTR_ADDR_HI__RB_RPTR_ADDR_HI_MASK                                                              0x0000FFFFL
//CP_RB0_BUFSZ_MASK
#define CP_RB0_BUFSZ_MASK__DATA__SHIFT                                                                        0x0
#define CP_RB0_BUFSZ_MASK__DATA_MASK                                                                          0x000FFFFFL
//CP_RB_BUFSZ_MASK
#define CP_RB_BUFSZ_MASK__DATA__SHIFT                                                                         0x0
#define CP_RB_BUFSZ_MASK__DATA_MASK                                                                           0x000FFFFFL
//CP_RB_WPTR_POLL_ADDR_LO
#define CP_RB_WPTR_POLL_ADDR_LO__RB_WPTR_POLL_ADDR_LO__SHIFT                                                  0x2
#define CP_RB_WPTR_POLL_ADDR_LO__RB_WPTR_POLL_ADDR_LO_MASK                                                    0xFFFFFFFCL
//CP_RB_WPTR_POLL_ADDR_HI
#define CP_RB_WPTR_POLL_ADDR_HI__RB_WPTR_POLL_ADDR_HI__SHIFT                                                  0x0
#define CP_RB_WPTR_POLL_ADDR_HI__RB_WPTR_POLL_ADDR_HI_MASK                                                    0x0000FFFFL
//CP_INT_CNTL
#define CP_INT_CNTL__CP_VM_DOORBELL_WR_INT_ENABLE__SHIFT                                                      0xb
#define CP_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                           0xe
#define CP_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                                    0x10
#define CP_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                                       0x11
#define CP_INT_CNTL__CMP_BUSY_INT_ENABLE__SHIFT                                                               0x12
#define CP_INT_CNTL__CNTX_BUSY_INT_ENABLE__SHIFT                                                              0x13
#define CP_INT_CNTL__CNTX_EMPTY_INT_ENABLE__SHIFT                                                             0x14
#define CP_INT_CNTL__GFX_IDLE_INT_ENABLE__SHIFT                                                               0x15
#define CP_INT_CNTL__PRIV_INSTR_INT_ENABLE__SHIFT                                                             0x16
#define CP_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                               0x17
#define CP_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                           0x18
#define CP_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                             0x1a
#define CP_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                                     0x1b
#define CP_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                               0x1d
#define CP_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                               0x1e
#define CP_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                               0x1f
#define CP_INT_CNTL__CP_VM_DOORBELL_WR_INT_ENABLE_MASK                                                        0x00000800L
#define CP_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                             0x00004000L
#define CP_INT_CNTL__GPF_INT_ENABLE_MASK                                                                      0x00010000L
#define CP_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                                         0x00020000L
#define CP_INT_CNTL__CMP_BUSY_INT_ENABLE_MASK                                                                 0x00040000L
#define CP_INT_CNTL__CNTX_BUSY_INT_ENABLE_MASK                                                                0x00080000L
#define CP_INT_CNTL__CNTX_EMPTY_INT_ENABLE_MASK                                                               0x00100000L
#define CP_INT_CNTL__GFX_IDLE_INT_ENABLE_MASK                                                                 0x00200000L
#define CP_INT_CNTL__PRIV_INSTR_INT_ENABLE_MASK                                                               0x00400000L
#define CP_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                                 0x00800000L
#define CP_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                             0x01000000L
#define CP_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                               0x04000000L
#define CP_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                                       0x08000000L
#define CP_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                                 0x20000000L
#define CP_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                                 0x40000000L
#define CP_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                                 0x80000000L
//CP_INT_STATUS
#define CP_INT_STATUS__CP_VM_DOORBELL_WR_INT_STAT__SHIFT                                                      0xb
#define CP_INT_STATUS__CP_ECC_ERROR_INT_STAT__SHIFT                                                           0xe
#define CP_INT_STATUS__GPF_INT_STAT__SHIFT                                                                    0x10
#define CP_INT_STATUS__WRM_POLL_TIMEOUT_INT_STAT__SHIFT                                                       0x11
#define CP_INT_STATUS__CMP_BUSY_INT_STAT__SHIFT                                                               0x12
#define CP_INT_STATUS__CNTX_BUSY_INT_STAT__SHIFT                                                              0x13
#define CP_INT_STATUS__CNTX_EMPTY_INT_STAT__SHIFT                                                             0x14
#define CP_INT_STATUS__GFX_IDLE_INT_STAT__SHIFT                                                               0x15
#define CP_INT_STATUS__PRIV_INSTR_INT_STAT__SHIFT                                                             0x16
#define CP_INT_STATUS__PRIV_REG_INT_STAT__SHIFT                                                               0x17
#define CP_INT_STATUS__OPCODE_ERROR_INT_STAT__SHIFT                                                           0x18
#define CP_INT_STATUS__TIME_STAMP_INT_STAT__SHIFT                                                             0x1a
#define CP_INT_STATUS__RESERVED_BIT_ERROR_INT_STAT__SHIFT                                                     0x1b
#define CP_INT_STATUS__GENERIC2_INT_STAT__SHIFT                                                               0x1d
#define CP_INT_STATUS__GENERIC1_INT_STAT__SHIFT                                                               0x1e
#define CP_INT_STATUS__GENERIC0_INT_STAT__SHIFT                                                               0x1f
#define CP_INT_STATUS__CP_VM_DOORBELL_WR_INT_STAT_MASK                                                        0x00000800L
#define CP_INT_STATUS__CP_ECC_ERROR_INT_STAT_MASK                                                             0x00004000L
#define CP_INT_STATUS__GPF_INT_STAT_MASK                                                                      0x00010000L
#define CP_INT_STATUS__WRM_POLL_TIMEOUT_INT_STAT_MASK                                                         0x00020000L
#define CP_INT_STATUS__CMP_BUSY_INT_STAT_MASK                                                                 0x00040000L
#define CP_INT_STATUS__CNTX_BUSY_INT_STAT_MASK                                                                0x00080000L
#define CP_INT_STATUS__CNTX_EMPTY_INT_STAT_MASK                                                               0x00100000L
#define CP_INT_STATUS__GFX_IDLE_INT_STAT_MASK                                                                 0x00200000L
#define CP_INT_STATUS__PRIV_INSTR_INT_STAT_MASK                                                               0x00400000L
#define CP_INT_STATUS__PRIV_REG_INT_STAT_MASK                                                                 0x00800000L
#define CP_INT_STATUS__OPCODE_ERROR_INT_STAT_MASK                                                             0x01000000L
#define CP_INT_STATUS__TIME_STAMP_INT_STAT_MASK                                                               0x04000000L
#define CP_INT_STATUS__RESERVED_BIT_ERROR_INT_STAT_MASK                                                       0x08000000L
#define CP_INT_STATUS__GENERIC2_INT_STAT_MASK                                                                 0x20000000L
#define CP_INT_STATUS__GENERIC1_INT_STAT_MASK                                                                 0x40000000L
#define CP_INT_STATUS__GENERIC0_INT_STAT_MASK                                                                 0x80000000L
//CP_DEVICE_ID
#define CP_DEVICE_ID__DEVICE_ID__SHIFT                                                                        0x0
#define CP_DEVICE_ID__DEVICE_ID_MASK                                                                          0x000000FFL
//CP_ME0_PIPE_PRIORITY_CNTS
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY1_CNT__SHIFT                                                       0x0
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY2A_CNT__SHIFT                                                      0x8
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY2B_CNT__SHIFT                                                      0x10
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY3_CNT__SHIFT                                                       0x18
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY1_CNT_MASK                                                         0x000000FFL
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY2A_CNT_MASK                                                        0x0000FF00L
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY2B_CNT_MASK                                                        0x00FF0000L
#define CP_ME0_PIPE_PRIORITY_CNTS__PRIORITY3_CNT_MASK                                                         0xFF000000L
//CP_RING_PRIORITY_CNTS
#define CP_RING_PRIORITY_CNTS__PRIORITY1_CNT__SHIFT                                                           0x0
#define CP_RING_PRIORITY_CNTS__PRIORITY2A_CNT__SHIFT                                                          0x8
#define CP_RING_PRIORITY_CNTS__PRIORITY2B_CNT__SHIFT                                                          0x10
#define CP_RING_PRIORITY_CNTS__PRIORITY3_CNT__SHIFT                                                           0x18
#define CP_RING_PRIORITY_CNTS__PRIORITY1_CNT_MASK                                                             0x000000FFL
#define CP_RING_PRIORITY_CNTS__PRIORITY2A_CNT_MASK                                                            0x0000FF00L
#define CP_RING_PRIORITY_CNTS__PRIORITY2B_CNT_MASK                                                            0x00FF0000L
#define CP_RING_PRIORITY_CNTS__PRIORITY3_CNT_MASK                                                             0xFF000000L
//CP_ME0_PIPE0_PRIORITY
#define CP_ME0_PIPE0_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME0_PIPE0_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_RING0_PRIORITY
#define CP_RING0_PRIORITY__PRIORITY__SHIFT                                                                    0x0
#define CP_RING0_PRIORITY__PRIORITY_MASK                                                                      0x00000003L
//CP_ME0_PIPE1_PRIORITY
#define CP_ME0_PIPE1_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME0_PIPE1_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_RING1_PRIORITY
#define CP_RING1_PRIORITY__PRIORITY__SHIFT                                                                    0x0
#define CP_RING1_PRIORITY__PRIORITY_MASK                                                                      0x00000003L
//CP_ME0_PIPE2_PRIORITY
#define CP_ME0_PIPE2_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME0_PIPE2_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_RING2_PRIORITY
#define CP_RING2_PRIORITY__PRIORITY__SHIFT                                                                    0x0
#define CP_RING2_PRIORITY__PRIORITY_MASK                                                                      0x00000003L
//CP_FATAL_ERROR
#define CP_FATAL_ERROR__CPF_FATAL_ERROR__SHIFT                                                                0x0
#define CP_FATAL_ERROR__CPG_FATAL_ERROR__SHIFT                                                                0x1
#define CP_FATAL_ERROR__GFX_HALT_PROC__SHIFT                                                                  0x2
#define CP_FATAL_ERROR__DIS_CPG_FATAL_ERROR__SHIFT                                                            0x3
#define CP_FATAL_ERROR__CPG_TAG_FATAL_ERROR_EN__SHIFT                                                         0x4
#define CP_FATAL_ERROR__CPF_FATAL_ERROR_MASK                                                                  0x00000001L
#define CP_FATAL_ERROR__CPG_FATAL_ERROR_MASK                                                                  0x00000002L
#define CP_FATAL_ERROR__GFX_HALT_PROC_MASK                                                                    0x00000004L
#define CP_FATAL_ERROR__DIS_CPG_FATAL_ERROR_MASK                                                              0x00000008L
#define CP_FATAL_ERROR__CPG_TAG_FATAL_ERROR_EN_MASK                                                           0x00000010L
//CP_RB_VMID
#define CP_RB_VMID__RB0_VMID__SHIFT                                                                           0x0
#define CP_RB_VMID__RB1_VMID__SHIFT                                                                           0x8
#define CP_RB_VMID__RB2_VMID__SHIFT                                                                           0x10
#define CP_RB_VMID__RB0_VMID_MASK                                                                             0x0000000FL
#define CP_RB_VMID__RB1_VMID_MASK                                                                             0x00000F00L
#define CP_RB_VMID__RB2_VMID_MASK                                                                             0x000F0000L
//CP_ME0_PIPE0_VMID
#define CP_ME0_PIPE0_VMID__VMID__SHIFT                                                                        0x0
#define CP_ME0_PIPE0_VMID__VMID_MASK                                                                          0x0000000FL
//CP_ME0_PIPE1_VMID
#define CP_ME0_PIPE1_VMID__VMID__SHIFT                                                                        0x0
#define CP_ME0_PIPE1_VMID__VMID_MASK                                                                          0x0000000FL
//CP_RB0_WPTR
#define CP_RB0_WPTR__RB_WPTR__SHIFT                                                                           0x0
#define CP_RB0_WPTR__RB_WPTR_MASK                                                                             0xFFFFFFFFL
//CP_RB_WPTR
#define CP_RB_WPTR__RB_WPTR__SHIFT                                                                            0x0
#define CP_RB_WPTR__RB_WPTR_MASK                                                                              0xFFFFFFFFL
//CP_RB0_WPTR_HI
#define CP_RB0_WPTR_HI__RB_WPTR__SHIFT                                                                        0x0
#define CP_RB0_WPTR_HI__RB_WPTR_MASK                                                                          0xFFFFFFFFL
//CP_RB_WPTR_HI
#define CP_RB_WPTR_HI__RB_WPTR__SHIFT                                                                         0x0
#define CP_RB_WPTR_HI__RB_WPTR_MASK                                                                           0xFFFFFFFFL
//CP_RB1_WPTR
#define CP_RB1_WPTR__RB_WPTR__SHIFT                                                                           0x0
#define CP_RB1_WPTR__RB_WPTR_MASK                                                                             0xFFFFFFFFL
//CP_RB1_WPTR_HI
#define CP_RB1_WPTR_HI__RB_WPTR__SHIFT                                                                        0x0
#define CP_RB1_WPTR_HI__RB_WPTR_MASK                                                                          0xFFFFFFFFL
//CP_RB2_WPTR
#define CP_RB2_WPTR__RB_WPTR__SHIFT                                                                           0x0
#define CP_RB2_WPTR__RB_WPTR_MASK                                                                             0x000FFFFFL
//CP_RB_DOORBELL_CONTROL
#define CP_RB_DOORBELL_CONTROL__DOORBELL_BIF_DROP__SHIFT                                                      0x1
#define CP_RB_DOORBELL_CONTROL__DOORBELL_OFFSET__SHIFT                                                        0x2
#define CP_RB_DOORBELL_CONTROL__DOORBELL_EN__SHIFT                                                            0x1e
#define CP_RB_DOORBELL_CONTROL__DOORBELL_HIT__SHIFT                                                           0x1f
#define CP_RB_DOORBELL_CONTROL__DOORBELL_BIF_DROP_MASK                                                        0x00000002L
#define CP_RB_DOORBELL_CONTROL__DOORBELL_OFFSET_MASK                                                          0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL__DOORBELL_EN_MASK                                                              0x40000000L
#define CP_RB_DOORBELL_CONTROL__DOORBELL_HIT_MASK                                                             0x80000000L
//CP_RB_DOORBELL_RANGE_LOWER
#define CP_RB_DOORBELL_RANGE_LOWER__DOORBELL_RANGE_LOWER__SHIFT                                               0x2
#define CP_RB_DOORBELL_RANGE_LOWER__DOORBELL_RANGE_LOWER_MASK                                                 0x0FFFFFFCL
//CP_RB_DOORBELL_RANGE_UPPER
#define CP_RB_DOORBELL_RANGE_UPPER__DOORBELL_RANGE_UPPER__SHIFT                                               0x2
#define CP_RB_DOORBELL_RANGE_UPPER__DOORBELL_RANGE_UPPER_MASK                                                 0x0FFFFFFCL
//CP_MEC_DOORBELL_RANGE_LOWER
#define CP_MEC_DOORBELL_RANGE_LOWER__DOORBELL_RANGE_LOWER__SHIFT                                              0x2
#define CP_MEC_DOORBELL_RANGE_LOWER__DOORBELL_RANGE_LOWER_MASK                                                0x0FFFFFFCL
//CP_MEC_DOORBELL_RANGE_UPPER
#define CP_MEC_DOORBELL_RANGE_UPPER__DOORBELL_RANGE_UPPER__SHIFT                                              0x2
#define CP_MEC_DOORBELL_RANGE_UPPER__DOORBELL_RANGE_UPPER_MASK                                                0x0FFFFFFCL
//CPG_UTCL1_ERROR
#define CPG_UTCL1_ERROR__ERROR_DETECTED_HALT__SHIFT                                                           0x0
#define CPG_UTCL1_ERROR__ERROR_DETECTED_HALT_MASK                                                             0x00000001L
//CPC_UTCL1_ERROR
#define CPC_UTCL1_ERROR__ERROR_DETECTED_HALT__SHIFT                                                           0x0
#define CPC_UTCL1_ERROR__ERROR_DETECTED_HALT_MASK                                                             0x00000001L
//CP_RB1_BASE
#define CP_RB1_BASE__RB_BASE__SHIFT                                                                           0x0
#define CP_RB1_BASE__RB_BASE_MASK                                                                             0xFFFFFFFFL
//CP_RB1_CNTL
#define CP_RB1_CNTL__RB_BUFSZ__SHIFT                                                                          0x0
#define CP_RB1_CNTL__RB_BLKSZ__SHIFT                                                                          0x8
#define CP_RB1_CNTL__MIN_AVAILSZ__SHIFT                                                                       0x14
#define CP_RB1_CNTL__MIN_IB_AVAILSZ__SHIFT                                                                    0x16
#define CP_RB1_CNTL__CACHE_POLICY__SHIFT                                                                      0x18
#define CP_RB1_CNTL__RB_NO_UPDATE__SHIFT                                                                      0x1b
#define CP_RB1_CNTL__RB_RPTR_WR_ENA__SHIFT                                                                    0x1f
#define CP_RB1_CNTL__RB_BUFSZ_MASK                                                                            0x0000003FL
#define CP_RB1_CNTL__RB_BLKSZ_MASK                                                                            0x00003F00L
#define CP_RB1_CNTL__MIN_AVAILSZ_MASK                                                                         0x00300000L
#define CP_RB1_CNTL__MIN_IB_AVAILSZ_MASK                                                                      0x00C00000L
#define CP_RB1_CNTL__CACHE_POLICY_MASK                                                                        0x01000000L
#define CP_RB1_CNTL__RB_NO_UPDATE_MASK                                                                        0x08000000L
#define CP_RB1_CNTL__RB_RPTR_WR_ENA_MASK                                                                      0x80000000L
//CP_RB1_RPTR_ADDR
#define CP_RB1_RPTR_ADDR__RB_RPTR_ADDR__SHIFT                                                                 0x2
#define CP_RB1_RPTR_ADDR__RB_RPTR_ADDR_MASK                                                                   0xFFFFFFFCL
//CP_RB1_RPTR_ADDR_HI
#define CP_RB1_RPTR_ADDR_HI__RB_RPTR_ADDR_HI__SHIFT                                                           0x0
#define CP_RB1_RPTR_ADDR_HI__RB_RPTR_ADDR_HI_MASK                                                             0x0000FFFFL
//CP_RB2_BASE
#define CP_RB2_BASE__RB_BASE__SHIFT                                                                           0x0
#define CP_RB2_BASE__RB_BASE_MASK                                                                             0xFFFFFFFFL
//CP_RB2_CNTL
#define CP_RB2_CNTL__RB_BUFSZ__SHIFT                                                                          0x0
#define CP_RB2_CNTL__RB_BLKSZ__SHIFT                                                                          0x8
#define CP_RB2_CNTL__MIN_AVAILSZ__SHIFT                                                                       0x14
#define CP_RB2_CNTL__MIN_IB_AVAILSZ__SHIFT                                                                    0x16
#define CP_RB2_CNTL__CACHE_POLICY__SHIFT                                                                      0x18
#define CP_RB2_CNTL__RB_NO_UPDATE__SHIFT                                                                      0x1b
#define CP_RB2_CNTL__RB_RPTR_WR_ENA__SHIFT                                                                    0x1f
#define CP_RB2_CNTL__RB_BUFSZ_MASK                                                                            0x0000003FL
#define CP_RB2_CNTL__RB_BLKSZ_MASK                                                                            0x00003F00L
#define CP_RB2_CNTL__MIN_AVAILSZ_MASK                                                                         0x00300000L
#define CP_RB2_CNTL__MIN_IB_AVAILSZ_MASK                                                                      0x00C00000L
#define CP_RB2_CNTL__CACHE_POLICY_MASK                                                                        0x01000000L
#define CP_RB2_CNTL__RB_NO_UPDATE_MASK                                                                        0x08000000L
#define CP_RB2_CNTL__RB_RPTR_WR_ENA_MASK                                                                      0x80000000L
//CP_RB2_RPTR_ADDR
#define CP_RB2_RPTR_ADDR__RB_RPTR_ADDR__SHIFT                                                                 0x2
#define CP_RB2_RPTR_ADDR__RB_RPTR_ADDR_MASK                                                                   0xFFFFFFFCL
//CP_RB2_RPTR_ADDR_HI
#define CP_RB2_RPTR_ADDR_HI__RB_RPTR_ADDR_HI__SHIFT                                                           0x0
#define CP_RB2_RPTR_ADDR_HI__RB_RPTR_ADDR_HI_MASK                                                             0x0000FFFFL
//CP_RB0_ACTIVE
#define CP_RB0_ACTIVE__ACTIVE__SHIFT                                                                          0x0
#define CP_RB0_ACTIVE__ACTIVE_MASK                                                                            0x00000001L
//CP_RB_ACTIVE
#define CP_RB_ACTIVE__ACTIVE__SHIFT                                                                           0x0
#define CP_RB_ACTIVE__ACTIVE_MASK                                                                             0x00000001L
//CP_INT_CNTL_RING0
#define CP_INT_CNTL_RING0__CP_VM_DOORBELL_WR_INT_ENABLE__SHIFT                                                0xb
#define CP_INT_CNTL_RING0__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                     0xe
#define CP_INT_CNTL_RING0__GPF_INT_ENABLE__SHIFT                                                              0x10
#define CP_INT_CNTL_RING0__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                                 0x11
#define CP_INT_CNTL_RING0__CMP_BUSY_INT_ENABLE__SHIFT                                                         0x12
#define CP_INT_CNTL_RING0__CNTX_BUSY_INT_ENABLE__SHIFT                                                        0x13
#define CP_INT_CNTL_RING0__CNTX_EMPTY_INT_ENABLE__SHIFT                                                       0x14
#define CP_INT_CNTL_RING0__GFX_IDLE_INT_ENABLE__SHIFT                                                         0x15
#define CP_INT_CNTL_RING0__PRIV_INSTR_INT_ENABLE__SHIFT                                                       0x16
#define CP_INT_CNTL_RING0__PRIV_REG_INT_ENABLE__SHIFT                                                         0x17
#define CP_INT_CNTL_RING0__OPCODE_ERROR_INT_ENABLE__SHIFT                                                     0x18
#define CP_INT_CNTL_RING0__TIME_STAMP_INT_ENABLE__SHIFT                                                       0x1a
#define CP_INT_CNTL_RING0__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                               0x1b
#define CP_INT_CNTL_RING0__GENERIC2_INT_ENABLE__SHIFT                                                         0x1d
#define CP_INT_CNTL_RING0__GENERIC1_INT_ENABLE__SHIFT                                                         0x1e
#define CP_INT_CNTL_RING0__GENERIC0_INT_ENABLE__SHIFT                                                         0x1f
#define CP_INT_CNTL_RING0__CP_VM_DOORBELL_WR_INT_ENABLE_MASK                                                  0x00000800L
#define CP_INT_CNTL_RING0__CP_ECC_ERROR_INT_ENABLE_MASK                                                       0x00004000L
#define CP_INT_CNTL_RING0__GPF_INT_ENABLE_MASK                                                                0x00010000L
#define CP_INT_CNTL_RING0__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                                   0x00020000L
#define CP_INT_CNTL_RING0__CMP_BUSY_INT_ENABLE_MASK                                                           0x00040000L
#define CP_INT_CNTL_RING0__CNTX_BUSY_INT_ENABLE_MASK                                                          0x00080000L
#define CP_INT_CNTL_RING0__CNTX_EMPTY_INT_ENABLE_MASK                                                         0x00100000L
#define CP_INT_CNTL_RING0__GFX_IDLE_INT_ENABLE_MASK                                                           0x00200000L
#define CP_INT_CNTL_RING0__PRIV_INSTR_INT_ENABLE_MASK                                                         0x00400000L
#define CP_INT_CNTL_RING0__PRIV_REG_INT_ENABLE_MASK                                                           0x00800000L
#define CP_INT_CNTL_RING0__OPCODE_ERROR_INT_ENABLE_MASK                                                       0x01000000L
#define CP_INT_CNTL_RING0__TIME_STAMP_INT_ENABLE_MASK                                                         0x04000000L
#define CP_INT_CNTL_RING0__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                                 0x08000000L
#define CP_INT_CNTL_RING0__GENERIC2_INT_ENABLE_MASK                                                           0x20000000L
#define CP_INT_CNTL_RING0__GENERIC1_INT_ENABLE_MASK                                                           0x40000000L
#define CP_INT_CNTL_RING0__GENERIC0_INT_ENABLE_MASK                                                           0x80000000L
//CP_INT_CNTL_RING1
#define CP_INT_CNTL_RING1__CP_VM_DOORBELL_WR_INT_ENABLE__SHIFT                                                0xb
#define CP_INT_CNTL_RING1__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                     0xe
#define CP_INT_CNTL_RING1__GPF_INT_ENABLE__SHIFT                                                              0x10
#define CP_INT_CNTL_RING1__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                                 0x11
#define CP_INT_CNTL_RING1__CMP_BUSY_INT_ENABLE__SHIFT                                                         0x12
#define CP_INT_CNTL_RING1__CNTX_BUSY_INT_ENABLE__SHIFT                                                        0x13
#define CP_INT_CNTL_RING1__CNTX_EMPTY_INT_ENABLE__SHIFT                                                       0x14
#define CP_INT_CNTL_RING1__GFX_IDLE_INT_ENABLE__SHIFT                                                         0x15
#define CP_INT_CNTL_RING1__PRIV_INSTR_INT_ENABLE__SHIFT                                                       0x16
#define CP_INT_CNTL_RING1__PRIV_REG_INT_ENABLE__SHIFT                                                         0x17
#define CP_INT_CNTL_RING1__OPCODE_ERROR_INT_ENABLE__SHIFT                                                     0x18
#define CP_INT_CNTL_RING1__TIME_STAMP_INT_ENABLE__SHIFT                                                       0x1a
#define CP_INT_CNTL_RING1__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                               0x1b
#define CP_INT_CNTL_RING1__GENERIC2_INT_ENABLE__SHIFT                                                         0x1d
#define CP_INT_CNTL_RING1__GENERIC1_INT_ENABLE__SHIFT                                                         0x1e
#define CP_INT_CNTL_RING1__GENERIC0_INT_ENABLE__SHIFT                                                         0x1f
#define CP_INT_CNTL_RING1__CP_VM_DOORBELL_WR_INT_ENABLE_MASK                                                  0x00000800L
#define CP_INT_CNTL_RING1__CP_ECC_ERROR_INT_ENABLE_MASK                                                       0x00004000L
#define CP_INT_CNTL_RING1__GPF_INT_ENABLE_MASK                                                                0x00010000L
#define CP_INT_CNTL_RING1__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                                   0x00020000L
#define CP_INT_CNTL_RING1__CMP_BUSY_INT_ENABLE_MASK                                                           0x00040000L
#define CP_INT_CNTL_RING1__CNTX_BUSY_INT_ENABLE_MASK                                                          0x00080000L
#define CP_INT_CNTL_RING1__CNTX_EMPTY_INT_ENABLE_MASK                                                         0x00100000L
#define CP_INT_CNTL_RING1__GFX_IDLE_INT_ENABLE_MASK                                                           0x00200000L
#define CP_INT_CNTL_RING1__PRIV_INSTR_INT_ENABLE_MASK                                                         0x00400000L
#define CP_INT_CNTL_RING1__PRIV_REG_INT_ENABLE_MASK                                                           0x00800000L
#define CP_INT_CNTL_RING1__OPCODE_ERROR_INT_ENABLE_MASK                                                       0x01000000L
#define CP_INT_CNTL_RING1__TIME_STAMP_INT_ENABLE_MASK                                                         0x04000000L
#define CP_INT_CNTL_RING1__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                                 0x08000000L
#define CP_INT_CNTL_RING1__GENERIC2_INT_ENABLE_MASK                                                           0x20000000L
#define CP_INT_CNTL_RING1__GENERIC1_INT_ENABLE_MASK                                                           0x40000000L
#define CP_INT_CNTL_RING1__GENERIC0_INT_ENABLE_MASK                                                           0x80000000L
//CP_INT_CNTL_RING2
#define CP_INT_CNTL_RING2__CP_VM_DOORBELL_WR_INT_ENABLE__SHIFT                                                0xb
#define CP_INT_CNTL_RING2__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                     0xe
#define CP_INT_CNTL_RING2__GPF_INT_ENABLE__SHIFT                                                              0x10
#define CP_INT_CNTL_RING2__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                                 0x11
#define CP_INT_CNTL_RING2__CMP_BUSY_INT_ENABLE__SHIFT                                                         0x12
#define CP_INT_CNTL_RING2__CNTX_BUSY_INT_ENABLE__SHIFT                                                        0x13
#define CP_INT_CNTL_RING2__CNTX_EMPTY_INT_ENABLE__SHIFT                                                       0x14
#define CP_INT_CNTL_RING2__GFX_IDLE_INT_ENABLE__SHIFT                                                         0x15
#define CP_INT_CNTL_RING2__PRIV_INSTR_INT_ENABLE__SHIFT                                                       0x16
#define CP_INT_CNTL_RING2__PRIV_REG_INT_ENABLE__SHIFT                                                         0x17
#define CP_INT_CNTL_RING2__OPCODE_ERROR_INT_ENABLE__SHIFT                                                     0x18
#define CP_INT_CNTL_RING2__TIME_STAMP_INT_ENABLE__SHIFT                                                       0x1a
#define CP_INT_CNTL_RING2__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                               0x1b
#define CP_INT_CNTL_RING2__GENERIC2_INT_ENABLE__SHIFT                                                         0x1d
#define CP_INT_CNTL_RING2__GENERIC1_INT_ENABLE__SHIFT                                                         0x1e
#define CP_INT_CNTL_RING2__GENERIC0_INT_ENABLE__SHIFT                                                         0x1f
#define CP_INT_CNTL_RING2__CP_VM_DOORBELL_WR_INT_ENABLE_MASK                                                  0x00000800L
#define CP_INT_CNTL_RING2__CP_ECC_ERROR_INT_ENABLE_MASK                                                       0x00004000L
#define CP_INT_CNTL_RING2__GPF_INT_ENABLE_MASK                                                                0x00010000L
#define CP_INT_CNTL_RING2__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                                   0x00020000L
#define CP_INT_CNTL_RING2__CMP_BUSY_INT_ENABLE_MASK                                                           0x00040000L
#define CP_INT_CNTL_RING2__CNTX_BUSY_INT_ENABLE_MASK                                                          0x00080000L
#define CP_INT_CNTL_RING2__CNTX_EMPTY_INT_ENABLE_MASK                                                         0x00100000L
#define CP_INT_CNTL_RING2__GFX_IDLE_INT_ENABLE_MASK                                                           0x00200000L
#define CP_INT_CNTL_RING2__PRIV_INSTR_INT_ENABLE_MASK                                                         0x00400000L
#define CP_INT_CNTL_RING2__PRIV_REG_INT_ENABLE_MASK                                                           0x00800000L
#define CP_INT_CNTL_RING2__OPCODE_ERROR_INT_ENABLE_MASK                                                       0x01000000L
#define CP_INT_CNTL_RING2__TIME_STAMP_INT_ENABLE_MASK                                                         0x04000000L
#define CP_INT_CNTL_RING2__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                                 0x08000000L
#define CP_INT_CNTL_RING2__GENERIC2_INT_ENABLE_MASK                                                           0x20000000L
#define CP_INT_CNTL_RING2__GENERIC1_INT_ENABLE_MASK                                                           0x40000000L
#define CP_INT_CNTL_RING2__GENERIC0_INT_ENABLE_MASK                                                           0x80000000L
//CP_INT_STATUS_RING0
#define CP_INT_STATUS_RING0__CP_VM_DOORBELL_WR_INT_STAT__SHIFT                                                0xb
#define CP_INT_STATUS_RING0__CP_ECC_ERROR_INT_STAT__SHIFT                                                     0xe
#define CP_INT_STATUS_RING0__GPF_INT_STAT__SHIFT                                                              0x10
#define CP_INT_STATUS_RING0__WRM_POLL_TIMEOUT_INT_STAT__SHIFT                                                 0x11
#define CP_INT_STATUS_RING0__CMP_BUSY_INT_STAT__SHIFT                                                         0x12
#define CP_INT_STATUS_RING0__GCNTX_BUSY_INT_STAT__SHIFT                                                       0x13
#define CP_INT_STATUS_RING0__CNTX_EMPTY_INT_STAT__SHIFT                                                       0x14
#define CP_INT_STATUS_RING0__GFX_IDLE_INT_STAT__SHIFT                                                         0x15
#define CP_INT_STATUS_RING0__PRIV_INSTR_INT_STAT__SHIFT                                                       0x16
#define CP_INT_STATUS_RING0__PRIV_REG_INT_STAT__SHIFT                                                         0x17
#define CP_INT_STATUS_RING0__OPCODE_ERROR_INT_STAT__SHIFT                                                     0x18
#define CP_INT_STATUS_RING0__TIME_STAMP_INT_STAT__SHIFT                                                       0x1a
#define CP_INT_STATUS_RING0__RESERVED_BIT_ERROR_INT_STAT__SHIFT                                               0x1b
#define CP_INT_STATUS_RING0__GENERIC2_INT_STAT__SHIFT                                                         0x1d
#define CP_INT_STATUS_RING0__GENERIC1_INT_STAT__SHIFT                                                         0x1e
#define CP_INT_STATUS_RING0__GENERIC0_INT_STAT__SHIFT                                                         0x1f
#define CP_INT_STATUS_RING0__CP_VM_DOORBELL_WR_INT_STAT_MASK                                                  0x00000800L
#define CP_INT_STATUS_RING0__CP_ECC_ERROR_INT_STAT_MASK                                                       0x00004000L
#define CP_INT_STATUS_RING0__GPF_INT_STAT_MASK                                                                0x00010000L
#define CP_INT_STATUS_RING0__WRM_POLL_TIMEOUT_INT_STAT_MASK                                                   0x00020000L
#define CP_INT_STATUS_RING0__CMP_BUSY_INT_STAT_MASK                                                           0x00040000L
#define CP_INT_STATUS_RING0__GCNTX_BUSY_INT_STAT_MASK                                                         0x00080000L
#define CP_INT_STATUS_RING0__CNTX_EMPTY_INT_STAT_MASK                                                         0x00100000L
#define CP_INT_STATUS_RING0__GFX_IDLE_INT_STAT_MASK                                                           0x00200000L
#define CP_INT_STATUS_RING0__PRIV_INSTR_INT_STAT_MASK                                                         0x00400000L
#define CP_INT_STATUS_RING0__PRIV_REG_INT_STAT_MASK                                                           0x00800000L
#define CP_INT_STATUS_RING0__OPCODE_ERROR_INT_STAT_MASK                                                       0x01000000L
#define CP_INT_STATUS_RING0__TIME_STAMP_INT_STAT_MASK                                                         0x04000000L
#define CP_INT_STATUS_RING0__RESERVED_BIT_ERROR_INT_STAT_MASK                                                 0x08000000L
#define CP_INT_STATUS_RING0__GENERIC2_INT_STAT_MASK                                                           0x20000000L
#define CP_INT_STATUS_RING0__GENERIC1_INT_STAT_MASK                                                           0x40000000L
#define CP_INT_STATUS_RING0__GENERIC0_INT_STAT_MASK                                                           0x80000000L
//CP_INT_STATUS_RING1
#define CP_INT_STATUS_RING1__CP_VM_DOORBELL_WR_INT_STAT__SHIFT                                                0xb
#define CP_INT_STATUS_RING1__CP_ECC_ERROR_INT_STAT__SHIFT                                                     0xe
#define CP_INT_STATUS_RING1__GPF_INT_STAT__SHIFT                                                              0x10
#define CP_INT_STATUS_RING1__WRM_POLL_TIMEOUT_INT_STAT__SHIFT                                                 0x11
#define CP_INT_STATUS_RING1__CMP_BUSY_INT_STAT__SHIFT                                                         0x12
#define CP_INT_STATUS_RING1__CNTX_BUSY_INT_STAT__SHIFT                                                        0x13
#define CP_INT_STATUS_RING1__CNTX_EMPTY_INT_STAT__SHIFT                                                       0x14
#define CP_INT_STATUS_RING1__GFX_IDLE_INT_STAT__SHIFT                                                         0x15
#define CP_INT_STATUS_RING1__PRIV_INSTR_INT_STAT__SHIFT                                                       0x16
#define CP_INT_STATUS_RING1__PRIV_REG_INT_STAT__SHIFT                                                         0x17
#define CP_INT_STATUS_RING1__OPCODE_ERROR_INT_STAT__SHIFT                                                     0x18
#define CP_INT_STATUS_RING1__TIME_STAMP_INT_STAT__SHIFT                                                       0x1a
#define CP_INT_STATUS_RING1__RESERVED_BIT_ERROR_INT_STAT__SHIFT                                               0x1b
#define CP_INT_STATUS_RING1__GENERIC2_INT_STAT__SHIFT                                                         0x1d
#define CP_INT_STATUS_RING1__GENERIC1_INT_STAT__SHIFT                                                         0x1e
#define CP_INT_STATUS_RING1__GENERIC0_INT_STAT__SHIFT                                                         0x1f
#define CP_INT_STATUS_RING1__CP_VM_DOORBELL_WR_INT_STAT_MASK                                                  0x00000800L
#define CP_INT_STATUS_RING1__CP_ECC_ERROR_INT_STAT_MASK                                                       0x00004000L
#define CP_INT_STATUS_RING1__GPF_INT_STAT_MASK                                                                0x00010000L
#define CP_INT_STATUS_RING1__WRM_POLL_TIMEOUT_INT_STAT_MASK                                                   0x00020000L
#define CP_INT_STATUS_RING1__CMP_BUSY_INT_STAT_MASK                                                           0x00040000L
#define CP_INT_STATUS_RING1__CNTX_BUSY_INT_STAT_MASK                                                          0x00080000L
#define CP_INT_STATUS_RING1__CNTX_EMPTY_INT_STAT_MASK                                                         0x00100000L
#define CP_INT_STATUS_RING1__GFX_IDLE_INT_STAT_MASK                                                           0x00200000L
#define CP_INT_STATUS_RING1__PRIV_INSTR_INT_STAT_MASK                                                         0x00400000L
#define CP_INT_STATUS_RING1__PRIV_REG_INT_STAT_MASK                                                           0x00800000L
#define CP_INT_STATUS_RING1__OPCODE_ERROR_INT_STAT_MASK                                                       0x01000000L
#define CP_INT_STATUS_RING1__TIME_STAMP_INT_STAT_MASK                                                         0x04000000L
#define CP_INT_STATUS_RING1__RESERVED_BIT_ERROR_INT_STAT_MASK                                                 0x08000000L
#define CP_INT_STATUS_RING1__GENERIC2_INT_STAT_MASK                                                           0x20000000L
#define CP_INT_STATUS_RING1__GENERIC1_INT_STAT_MASK                                                           0x40000000L
#define CP_INT_STATUS_RING1__GENERIC0_INT_STAT_MASK                                                           0x80000000L
//CP_INT_STATUS_RING2
#define CP_INT_STATUS_RING2__CP_VM_DOORBELL_WR_INT_STAT__SHIFT                                                0xb
#define CP_INT_STATUS_RING2__CP_ECC_ERROR_INT_STAT__SHIFT                                                     0xe
#define CP_INT_STATUS_RING2__GPF_INT_STAT__SHIFT                                                              0x10
#define CP_INT_STATUS_RING2__WRM_POLL_TIMEOUT_INT_STAT__SHIFT                                                 0x11
#define CP_INT_STATUS_RING2__CMP_BUSY_INT_STAT__SHIFT                                                         0x12
#define CP_INT_STATUS_RING2__CNTX_BUSY_INT_STAT__SHIFT                                                        0x13
#define CP_INT_STATUS_RING2__CNTX_EMPTY_INT_STAT__SHIFT                                                       0x14
#define CP_INT_STATUS_RING2__GFX_IDLE_INT_STAT__SHIFT                                                         0x15
#define CP_INT_STATUS_RING2__PRIV_INSTR_INT_STAT__SHIFT                                                       0x16
#define CP_INT_STATUS_RING2__PRIV_REG_INT_STAT__SHIFT                                                         0x17
#define CP_INT_STATUS_RING2__OPCODE_ERROR_INT_STAT__SHIFT                                                     0x18
#define CP_INT_STATUS_RING2__TIME_STAMP_INT_STAT__SHIFT                                                       0x1a
#define CP_INT_STATUS_RING2__RESERVED_BIT_ERROR_INT_STAT__SHIFT                                               0x1b
#define CP_INT_STATUS_RING2__GENERIC2_INT_STAT__SHIFT                                                         0x1d
#define CP_INT_STATUS_RING2__GENERIC1_INT_STAT__SHIFT                                                         0x1e
#define CP_INT_STATUS_RING2__GENERIC0_INT_STAT__SHIFT                                                         0x1f
#define CP_INT_STATUS_RING2__CP_VM_DOORBELL_WR_INT_STAT_MASK                                                  0x00000800L
#define CP_INT_STATUS_RING2__CP_ECC_ERROR_INT_STAT_MASK                                                       0x00004000L
#define CP_INT_STATUS_RING2__GPF_INT_STAT_MASK                                                                0x00010000L
#define CP_INT_STATUS_RING2__WRM_POLL_TIMEOUT_INT_STAT_MASK                                                   0x00020000L
#define CP_INT_STATUS_RING2__CMP_BUSY_INT_STAT_MASK                                                           0x00040000L
#define CP_INT_STATUS_RING2__CNTX_BUSY_INT_STAT_MASK                                                          0x00080000L
#define CP_INT_STATUS_RING2__CNTX_EMPTY_INT_STAT_MASK                                                         0x00100000L
#define CP_INT_STATUS_RING2__GFX_IDLE_INT_STAT_MASK                                                           0x00200000L
#define CP_INT_STATUS_RING2__PRIV_INSTR_INT_STAT_MASK                                                         0x00400000L
#define CP_INT_STATUS_RING2__PRIV_REG_INT_STAT_MASK                                                           0x00800000L
#define CP_INT_STATUS_RING2__OPCODE_ERROR_INT_STAT_MASK                                                       0x01000000L
#define CP_INT_STATUS_RING2__TIME_STAMP_INT_STAT_MASK                                                         0x04000000L
#define CP_INT_STATUS_RING2__RESERVED_BIT_ERROR_INT_STAT_MASK                                                 0x08000000L
#define CP_INT_STATUS_RING2__GENERIC2_INT_STAT_MASK                                                           0x20000000L
#define CP_INT_STATUS_RING2__GENERIC1_INT_STAT_MASK                                                           0x40000000L
#define CP_INT_STATUS_RING2__GENERIC0_INT_STAT_MASK                                                           0x80000000L
//CP_ME_F32_INTERRUPT
#define CP_ME_F32_INTERRUPT__ECC_ERROR_INT__SHIFT                                                             0x0
#define CP_ME_F32_INTERRUPT__TIME_STAMP_INT__SHIFT                                                            0x1
#define CP_ME_F32_INTERRUPT__ME_F32_INT_2__SHIFT                                                              0x2
#define CP_ME_F32_INTERRUPT__ME_F32_INT_3__SHIFT                                                              0x3
#define CP_ME_F32_INTERRUPT__ECC_ERROR_INT_MASK                                                               0x00000001L
#define CP_ME_F32_INTERRUPT__TIME_STAMP_INT_MASK                                                              0x00000002L
#define CP_ME_F32_INTERRUPT__ME_F32_INT_2_MASK                                                                0x00000004L
#define CP_ME_F32_INTERRUPT__ME_F32_INT_3_MASK                                                                0x00000008L
//CP_PFP_F32_INTERRUPT
#define CP_PFP_F32_INTERRUPT__ECC_ERROR_INT__SHIFT                                                            0x0
#define CP_PFP_F32_INTERRUPT__PRIV_REG_INT__SHIFT                                                             0x1
#define CP_PFP_F32_INTERRUPT__RESERVED_BIT_ERR_INT__SHIFT                                                     0x2
#define CP_PFP_F32_INTERRUPT__PFP_F32_INT_3__SHIFT                                                            0x3
#define CP_PFP_F32_INTERRUPT__ECC_ERROR_INT_MASK                                                              0x00000001L
#define CP_PFP_F32_INTERRUPT__PRIV_REG_INT_MASK                                                               0x00000002L
#define CP_PFP_F32_INTERRUPT__RESERVED_BIT_ERR_INT_MASK                                                       0x00000004L
#define CP_PFP_F32_INTERRUPT__PFP_F32_INT_3_MASK                                                              0x00000008L
//CP_CE_F32_INTERRUPT
#define CP_CE_F32_INTERRUPT__ECC_ERROR_INT__SHIFT                                                             0x0
#define CP_CE_F32_INTERRUPT__RESERVED_BIT_ERR_INT__SHIFT                                                      0x1
#define CP_CE_F32_INTERRUPT__CE_F32_INT_2__SHIFT                                                              0x2
#define CP_CE_F32_INTERRUPT__CE_F32_INT_3__SHIFT                                                              0x3
#define CP_CE_F32_INTERRUPT__ECC_ERROR_INT_MASK                                                               0x00000001L
#define CP_CE_F32_INTERRUPT__RESERVED_BIT_ERR_INT_MASK                                                        0x00000002L
#define CP_CE_F32_INTERRUPT__CE_F32_INT_2_MASK                                                                0x00000004L
#define CP_CE_F32_INTERRUPT__CE_F32_INT_3_MASK                                                                0x00000008L
//CP_MEC1_F32_INTERRUPT
#define CP_MEC1_F32_INTERRUPT__EDC_ROQ_FED_INT__SHIFT                                                         0x0
#define CP_MEC1_F32_INTERRUPT__PRIV_REG_INT__SHIFT                                                            0x1
#define CP_MEC1_F32_INTERRUPT__RESERVED_BIT_ERR_INT__SHIFT                                                    0x2
#define CP_MEC1_F32_INTERRUPT__EDC_TC_FED_INT__SHIFT                                                          0x3
#define CP_MEC1_F32_INTERRUPT__EDC_GDS_FED_INT__SHIFT                                                         0x4
#define CP_MEC1_F32_INTERRUPT__EDC_SCRATCH_FED_INT__SHIFT                                                     0x5
#define CP_MEC1_F32_INTERRUPT__WAVE_RESTORE_INT__SHIFT                                                        0x6
#define CP_MEC1_F32_INTERRUPT__SUA_VIOLATION_INT__SHIFT                                                       0x7
#define CP_MEC1_F32_INTERRUPT__EDC_DMA_FED_INT__SHIFT                                                         0x8
#define CP_MEC1_F32_INTERRUPT__IQ_TIMER_INT__SHIFT                                                            0x9
#define CP_MEC1_F32_INTERRUPT__GPF_INT_CPF__SHIFT                                                             0xa
#define CP_MEC1_F32_INTERRUPT__GPF_INT_DMA__SHIFT                                                             0xb
#define CP_MEC1_F32_INTERRUPT__GPF_INT_CPC__SHIFT                                                             0xc
#define CP_MEC1_F32_INTERRUPT__EDC_SR_MEM_FED_INT__SHIFT                                                      0xd
#define CP_MEC1_F32_INTERRUPT__QUEUE_MESSAGE_INT__SHIFT                                                       0xe
#define CP_MEC1_F32_INTERRUPT__FATAL_EDC_ERROR_INT__SHIFT                                                     0xf
#define CP_MEC1_F32_INTERRUPT__EDC_ROQ_FED_INT_MASK                                                           0x00000001L
#define CP_MEC1_F32_INTERRUPT__PRIV_REG_INT_MASK                                                              0x00000002L
#define CP_MEC1_F32_INTERRUPT__RESERVED_BIT_ERR_INT_MASK                                                      0x00000004L
#define CP_MEC1_F32_INTERRUPT__EDC_TC_FED_INT_MASK                                                            0x00000008L
#define CP_MEC1_F32_INTERRUPT__EDC_GDS_FED_INT_MASK                                                           0x00000010L
#define CP_MEC1_F32_INTERRUPT__EDC_SCRATCH_FED_INT_MASK                                                       0x00000020L
#define CP_MEC1_F32_INTERRUPT__WAVE_RESTORE_INT_MASK                                                          0x00000040L
#define CP_MEC1_F32_INTERRUPT__SUA_VIOLATION_INT_MASK                                                         0x00000080L
#define CP_MEC1_F32_INTERRUPT__EDC_DMA_FED_INT_MASK                                                           0x00000100L
#define CP_MEC1_F32_INTERRUPT__IQ_TIMER_INT_MASK                                                              0x00000200L
#define CP_MEC1_F32_INTERRUPT__GPF_INT_CPF_MASK                                                               0x00000400L
#define CP_MEC1_F32_INTERRUPT__GPF_INT_DMA_MASK                                                               0x00000800L
#define CP_MEC1_F32_INTERRUPT__GPF_INT_CPC_MASK                                                               0x00001000L
#define CP_MEC1_F32_INTERRUPT__EDC_SR_MEM_FED_INT_MASK                                                        0x00002000L
#define CP_MEC1_F32_INTERRUPT__QUEUE_MESSAGE_INT_MASK                                                         0x00004000L
#define CP_MEC1_F32_INTERRUPT__FATAL_EDC_ERROR_INT_MASK                                                       0x00008000L
//CP_MEC2_F32_INTERRUPT
#define CP_MEC2_F32_INTERRUPT__EDC_ROQ_FED_INT__SHIFT                                                         0x0
#define CP_MEC2_F32_INTERRUPT__PRIV_REG_INT__SHIFT                                                            0x1
#define CP_MEC2_F32_INTERRUPT__RESERVED_BIT_ERR_INT__SHIFT                                                    0x2
#define CP_MEC2_F32_INTERRUPT__EDC_TC_FED_INT__SHIFT                                                          0x3
#define CP_MEC2_F32_INTERRUPT__EDC_GDS_FED_INT__SHIFT                                                         0x4
#define CP_MEC2_F32_INTERRUPT__EDC_SCRATCH_FED_INT__SHIFT                                                     0x5
#define CP_MEC2_F32_INTERRUPT__WAVE_RESTORE_INT__SHIFT                                                        0x6
#define CP_MEC2_F32_INTERRUPT__SUA_VIOLATION_INT__SHIFT                                                       0x7
#define CP_MEC2_F32_INTERRUPT__EDC_DMA_FED_INT__SHIFT                                                         0x8
#define CP_MEC2_F32_INTERRUPT__IQ_TIMER_INT__SHIFT                                                            0x9
#define CP_MEC2_F32_INTERRUPT__GPF_INT_CPF__SHIFT                                                             0xa
#define CP_MEC2_F32_INTERRUPT__GPF_INT_DMA__SHIFT                                                             0xb
#define CP_MEC2_F32_INTERRUPT__GPF_INT_CPC__SHIFT                                                             0xc
#define CP_MEC2_F32_INTERRUPT__EDC_SR_MEM_FED_INT__SHIFT                                                      0xd
#define CP_MEC2_F32_INTERRUPT__QUEUE_MESSAGE_INT__SHIFT                                                       0xe
#define CP_MEC2_F32_INTERRUPT__FATAL_EDC_ERROR_INT__SHIFT                                                     0xf
#define CP_MEC2_F32_INTERRUPT__EDC_ROQ_FED_INT_MASK                                                           0x00000001L
#define CP_MEC2_F32_INTERRUPT__PRIV_REG_INT_MASK                                                              0x00000002L
#define CP_MEC2_F32_INTERRUPT__RESERVED_BIT_ERR_INT_MASK                                                      0x00000004L
#define CP_MEC2_F32_INTERRUPT__EDC_TC_FED_INT_MASK                                                            0x00000008L
#define CP_MEC2_F32_INTERRUPT__EDC_GDS_FED_INT_MASK                                                           0x00000010L
#define CP_MEC2_F32_INTERRUPT__EDC_SCRATCH_FED_INT_MASK                                                       0x00000020L
#define CP_MEC2_F32_INTERRUPT__WAVE_RESTORE_INT_MASK                                                          0x00000040L
#define CP_MEC2_F32_INTERRUPT__SUA_VIOLATION_INT_MASK                                                         0x00000080L
#define CP_MEC2_F32_INTERRUPT__EDC_DMA_FED_INT_MASK                                                           0x00000100L
#define CP_MEC2_F32_INTERRUPT__IQ_TIMER_INT_MASK                                                              0x00000200L
#define CP_MEC2_F32_INTERRUPT__GPF_INT_CPF_MASK                                                               0x00000400L
#define CP_MEC2_F32_INTERRUPT__GPF_INT_DMA_MASK                                                               0x00000800L
#define CP_MEC2_F32_INTERRUPT__GPF_INT_CPC_MASK                                                               0x00001000L
#define CP_MEC2_F32_INTERRUPT__EDC_SR_MEM_FED_INT_MASK                                                        0x00002000L
#define CP_MEC2_F32_INTERRUPT__QUEUE_MESSAGE_INT_MASK                                                         0x00004000L
#define CP_MEC2_F32_INTERRUPT__FATAL_EDC_ERROR_INT_MASK                                                       0x00008000L
//CP_PWR_CNTL
#define CP_PWR_CNTL__GFX_CLK_HALT_ME0_PIPE0__SHIFT                                                            0x0
#define CP_PWR_CNTL__GFX_CLK_HALT_ME0_PIPE1__SHIFT                                                            0x1
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE0__SHIFT                                                            0x8
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE1__SHIFT                                                            0x9
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE2__SHIFT                                                            0xa
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE3__SHIFT                                                            0xb
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE0__SHIFT                                                            0x10
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE1__SHIFT                                                            0x11
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE2__SHIFT                                                            0x12
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE3__SHIFT                                                            0x13
#define CP_PWR_CNTL__GFX_CLK_HALT_ME0_PIPE0_MASK                                                              0x00000001L
#define CP_PWR_CNTL__GFX_CLK_HALT_ME0_PIPE1_MASK                                                              0x00000002L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE0_MASK                                                              0x00000100L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE1_MASK                                                              0x00000200L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE2_MASK                                                              0x00000400L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME1_PIPE3_MASK                                                              0x00000800L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE0_MASK                                                              0x00010000L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE1_MASK                                                              0x00020000L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE2_MASK                                                              0x00040000L
#define CP_PWR_CNTL__CMP_CLK_HALT_ME2_PIPE3_MASK                                                              0x00080000L
//CP_MEM_SLP_CNTL
#define CP_MEM_SLP_CNTL__CP_MEM_LS_EN__SHIFT                                                                  0x0
#define CP_MEM_SLP_CNTL__CP_MEM_DS_EN__SHIFT                                                                  0x1
#define CP_MEM_SLP_CNTL__RESERVED__SHIFT                                                                      0x2
#define CP_MEM_SLP_CNTL__CP_LS_DS_BUSY_OVERRIDE__SHIFT                                                        0x7
#define CP_MEM_SLP_CNTL__CP_MEM_LS_ON_DELAY__SHIFT                                                            0x8
#define CP_MEM_SLP_CNTL__CP_MEM_LS_OFF_DELAY__SHIFT                                                           0x10
#define CP_MEM_SLP_CNTL__RESERVED1__SHIFT                                                                     0x18
#define CP_MEM_SLP_CNTL__CP_MEM_LS_EN_MASK                                                                    0x00000001L
#define CP_MEM_SLP_CNTL__CP_MEM_DS_EN_MASK                                                                    0x00000002L
#define CP_MEM_SLP_CNTL__RESERVED_MASK                                                                        0x0000007CL
#define CP_MEM_SLP_CNTL__CP_LS_DS_BUSY_OVERRIDE_MASK                                                          0x00000080L
#define CP_MEM_SLP_CNTL__CP_MEM_LS_ON_DELAY_MASK                                                              0x0000FF00L
#define CP_MEM_SLP_CNTL__CP_MEM_LS_OFF_DELAY_MASK                                                             0x00FF0000L
#define CP_MEM_SLP_CNTL__RESERVED1_MASK                                                                       0xFF000000L
//CP_ECC_DMA_FIRST_OCCURRENCE
#define CP_ECC_DMA_FIRST_OCCURRENCE__INTERFACE__SHIFT                                                         0x0
#define CP_ECC_DMA_FIRST_OCCURRENCE__CLIENT__SHIFT                                                            0x4
#define CP_ECC_DMA_FIRST_OCCURRENCE__ME__SHIFT                                                                0x8
#define CP_ECC_DMA_FIRST_OCCURRENCE__PIPE__SHIFT                                                              0xa
#define CP_ECC_DMA_FIRST_OCCURRENCE__QUEUE__SHIFT                                                             0xc
#define CP_ECC_DMA_FIRST_OCCURRENCE__VMID__SHIFT                                                              0x10
#define CP_ECC_DMA_FIRST_OCCURRENCE__INTERFACE_MASK                                                           0x00000003L
#define CP_ECC_DMA_FIRST_OCCURRENCE__CLIENT_MASK                                                              0x000000F0L
#define CP_ECC_DMA_FIRST_OCCURRENCE__ME_MASK                                                                  0x00000300L
#define CP_ECC_DMA_FIRST_OCCURRENCE__PIPE_MASK                                                                0x00000C00L
#define CP_ECC_DMA_FIRST_OCCURRENCE__QUEUE_MASK                                                               0x00007000L
#define CP_ECC_DMA_FIRST_OCCURRENCE__VMID_MASK                                                                0x000F0000L
//CP_ECC_FIRSTOCCURRENCE
#define CP_ECC_FIRSTOCCURRENCE__INTERFACE__SHIFT                                                              0x0
#define CP_ECC_FIRSTOCCURRENCE__CLIENT__SHIFT                                                                 0x4
#define CP_ECC_FIRSTOCCURRENCE__ME__SHIFT                                                                     0x8
#define CP_ECC_FIRSTOCCURRENCE__PIPE__SHIFT                                                                   0xa
#define CP_ECC_FIRSTOCCURRENCE__QUEUE__SHIFT                                                                  0xc
#define CP_ECC_FIRSTOCCURRENCE__VMID__SHIFT                                                                   0x10
#define CP_ECC_FIRSTOCCURRENCE__INTERFACE_MASK                                                                0x00000003L
#define CP_ECC_FIRSTOCCURRENCE__CLIENT_MASK                                                                   0x000000F0L
#define CP_ECC_FIRSTOCCURRENCE__ME_MASK                                                                       0x00000300L
#define CP_ECC_FIRSTOCCURRENCE__PIPE_MASK                                                                     0x00000C00L
#define CP_ECC_FIRSTOCCURRENCE__QUEUE_MASK                                                                    0x00007000L
#define CP_ECC_FIRSTOCCURRENCE__VMID_MASK                                                                     0x000F0000L
//CP_ECC_FIRSTOCCURRENCE_RING0
#define CP_ECC_FIRSTOCCURRENCE_RING0__OBSOLETE__SHIFT                                                         0x0
#define CP_ECC_FIRSTOCCURRENCE_RING0__OBSOLETE_MASK                                                           0xFFFFFFFFL
//CP_ECC_FIRSTOCCURRENCE_RING1
#define CP_ECC_FIRSTOCCURRENCE_RING1__OBSOLETE__SHIFT                                                         0x0
#define CP_ECC_FIRSTOCCURRENCE_RING1__OBSOLETE_MASK                                                           0xFFFFFFFFL
//CP_ECC_FIRSTOCCURRENCE_RING2
#define CP_ECC_FIRSTOCCURRENCE_RING2__OBSOLETE__SHIFT                                                         0x0
#define CP_ECC_FIRSTOCCURRENCE_RING2__OBSOLETE_MASK                                                           0xFFFFFFFFL
//GB_EDC_MODE
#define GB_EDC_MODE__FORCE_SEC_ON_DED__SHIFT                                                                  0xf
#define GB_EDC_MODE__COUNT_FED_OUT__SHIFT                                                                     0x10
#define GB_EDC_MODE__GATE_FUE__SHIFT                                                                          0x11
#define GB_EDC_MODE__DED_MODE__SHIFT                                                                          0x14
#define GB_EDC_MODE__PROP_FED__SHIFT                                                                          0x1d
#define GB_EDC_MODE__BYPASS__SHIFT                                                                            0x1f
#define GB_EDC_MODE__FORCE_SEC_ON_DED_MASK                                                                    0x00008000L
#define GB_EDC_MODE__COUNT_FED_OUT_MASK                                                                       0x00010000L
#define GB_EDC_MODE__GATE_FUE_MASK                                                                            0x00020000L
#define GB_EDC_MODE__DED_MODE_MASK                                                                            0x00300000L
#define GB_EDC_MODE__PROP_FED_MASK                                                                            0x20000000L
#define GB_EDC_MODE__BYPASS_MASK                                                                              0x80000000L
//CP_PQ_WPTR_POLL_CNTL
#define CP_PQ_WPTR_POLL_CNTL__PERIOD__SHIFT                                                                   0x0
#define CP_PQ_WPTR_POLL_CNTL__DISABLE_PEND_REQ_ONE_SHOT__SHIFT                                                0x1d
#define CP_PQ_WPTR_POLL_CNTL__POLL_ACTIVE__SHIFT                                                              0x1e
#define CP_PQ_WPTR_POLL_CNTL__EN__SHIFT                                                                       0x1f
#define CP_PQ_WPTR_POLL_CNTL__PERIOD_MASK                                                                     0x000000FFL
#define CP_PQ_WPTR_POLL_CNTL__DISABLE_PEND_REQ_ONE_SHOT_MASK                                                  0x20000000L
#define CP_PQ_WPTR_POLL_CNTL__POLL_ACTIVE_MASK                                                                0x40000000L
#define CP_PQ_WPTR_POLL_CNTL__EN_MASK                                                                         0x80000000L
//CP_PQ_WPTR_POLL_CNTL1
#define CP_PQ_WPTR_POLL_CNTL1__QUEUE_MASK__SHIFT                                                              0x0
#define CP_PQ_WPTR_POLL_CNTL1__QUEUE_MASK_MASK                                                                0xFFFFFFFFL
//CP_ME1_PIPE0_INT_CNTL
#define CP_ME1_PIPE0_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME1_PIPE0_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME1_PIPE0_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME1_PIPE0_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME1_PIPE0_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME1_PIPE0_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME1_PIPE0_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME1_PIPE0_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME1_PIPE0_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME1_PIPE0_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME1_PIPE0_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME1_PIPE0_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME1_PIPE0_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME1_PIPE0_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME1_PIPE0_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME1_PIPE0_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME1_PIPE0_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME1_PIPE0_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME1_PIPE0_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME1_PIPE0_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME1_PIPE0_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME1_PIPE0_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME1_PIPE0_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME1_PIPE0_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME1_PIPE0_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME1_PIPE0_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME1_PIPE1_INT_CNTL
#define CP_ME1_PIPE1_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME1_PIPE1_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME1_PIPE1_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME1_PIPE1_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME1_PIPE1_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME1_PIPE1_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME1_PIPE1_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME1_PIPE1_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME1_PIPE1_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME1_PIPE1_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME1_PIPE1_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME1_PIPE1_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME1_PIPE1_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME1_PIPE1_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME1_PIPE1_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME1_PIPE1_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME1_PIPE1_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME1_PIPE1_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME1_PIPE1_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME1_PIPE1_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME1_PIPE1_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME1_PIPE1_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME1_PIPE1_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME1_PIPE1_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME1_PIPE1_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME1_PIPE1_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME1_PIPE2_INT_CNTL
#define CP_ME1_PIPE2_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME1_PIPE2_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME1_PIPE2_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME1_PIPE2_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME1_PIPE2_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME1_PIPE2_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME1_PIPE2_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME1_PIPE2_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME1_PIPE2_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME1_PIPE2_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME1_PIPE2_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME1_PIPE2_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME1_PIPE2_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME1_PIPE2_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME1_PIPE2_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME1_PIPE2_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME1_PIPE2_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME1_PIPE2_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME1_PIPE2_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME1_PIPE2_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME1_PIPE2_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME1_PIPE2_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME1_PIPE2_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME1_PIPE2_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME1_PIPE2_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME1_PIPE2_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME1_PIPE3_INT_CNTL
#define CP_ME1_PIPE3_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME1_PIPE3_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME1_PIPE3_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME1_PIPE3_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME1_PIPE3_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME1_PIPE3_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME1_PIPE3_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME1_PIPE3_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME1_PIPE3_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME1_PIPE3_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME1_PIPE3_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME1_PIPE3_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME1_PIPE3_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME1_PIPE3_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME1_PIPE3_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME1_PIPE3_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME1_PIPE3_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME1_PIPE3_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME1_PIPE3_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME1_PIPE3_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME1_PIPE3_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME1_PIPE3_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME1_PIPE3_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME1_PIPE3_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME1_PIPE3_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME1_PIPE3_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME2_PIPE0_INT_CNTL
#define CP_ME2_PIPE0_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME2_PIPE0_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME2_PIPE0_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME2_PIPE0_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME2_PIPE0_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME2_PIPE0_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME2_PIPE0_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME2_PIPE0_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME2_PIPE0_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME2_PIPE0_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME2_PIPE0_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME2_PIPE0_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME2_PIPE0_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME2_PIPE0_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME2_PIPE0_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME2_PIPE0_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME2_PIPE0_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME2_PIPE0_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME2_PIPE0_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME2_PIPE0_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME2_PIPE0_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME2_PIPE0_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME2_PIPE0_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME2_PIPE0_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME2_PIPE0_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME2_PIPE0_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME2_PIPE1_INT_CNTL
#define CP_ME2_PIPE1_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME2_PIPE1_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME2_PIPE1_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME2_PIPE1_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME2_PIPE1_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME2_PIPE1_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME2_PIPE1_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME2_PIPE1_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME2_PIPE1_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME2_PIPE1_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME2_PIPE1_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME2_PIPE1_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME2_PIPE1_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME2_PIPE1_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME2_PIPE1_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME2_PIPE1_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME2_PIPE1_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME2_PIPE1_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME2_PIPE1_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME2_PIPE1_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME2_PIPE1_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME2_PIPE1_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME2_PIPE1_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME2_PIPE1_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME2_PIPE1_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME2_PIPE1_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME2_PIPE2_INT_CNTL
#define CP_ME2_PIPE2_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME2_PIPE2_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME2_PIPE2_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME2_PIPE2_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME2_PIPE2_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME2_PIPE2_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME2_PIPE2_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME2_PIPE2_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME2_PIPE2_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME2_PIPE2_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME2_PIPE2_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME2_PIPE2_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME2_PIPE2_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME2_PIPE2_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME2_PIPE2_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME2_PIPE2_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME2_PIPE2_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME2_PIPE2_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME2_PIPE2_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME2_PIPE2_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME2_PIPE2_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME2_PIPE2_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME2_PIPE2_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME2_PIPE2_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME2_PIPE2_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME2_PIPE2_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME2_PIPE3_INT_CNTL
#define CP_ME2_PIPE3_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                             0xc
#define CP_ME2_PIPE3_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                              0xd
#define CP_ME2_PIPE3_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                 0xe
#define CP_ME2_PIPE3_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                0xf
#define CP_ME2_PIPE3_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                          0x10
#define CP_ME2_PIPE3_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                             0x11
#define CP_ME2_PIPE3_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                     0x17
#define CP_ME2_PIPE3_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                 0x18
#define CP_ME2_PIPE3_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                   0x1a
#define CP_ME2_PIPE3_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                           0x1b
#define CP_ME2_PIPE3_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                     0x1d
#define CP_ME2_PIPE3_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                     0x1e
#define CP_ME2_PIPE3_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                     0x1f
#define CP_ME2_PIPE3_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                               0x00001000L
#define CP_ME2_PIPE3_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                0x00002000L
#define CP_ME2_PIPE3_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                   0x00004000L
#define CP_ME2_PIPE3_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                  0x00008000L
#define CP_ME2_PIPE3_INT_CNTL__GPF_INT_ENABLE_MASK                                                            0x00010000L
#define CP_ME2_PIPE3_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                               0x00020000L
#define CP_ME2_PIPE3_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                       0x00800000L
#define CP_ME2_PIPE3_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                   0x01000000L
#define CP_ME2_PIPE3_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                     0x04000000L
#define CP_ME2_PIPE3_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                             0x08000000L
#define CP_ME2_PIPE3_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                       0x20000000L
#define CP_ME2_PIPE3_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                       0x40000000L
#define CP_ME2_PIPE3_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                       0x80000000L
//CP_ME1_PIPE0_INT_STATUS
#define CP_ME1_PIPE0_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME1_PIPE0_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME1_PIPE0_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME1_PIPE0_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME1_PIPE0_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME1_PIPE0_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME1_PIPE0_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME1_PIPE0_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME1_PIPE0_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME1_PIPE0_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME1_PIPE0_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME1_PIPE0_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME1_PIPE0_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME1_PIPE0_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME1_PIPE0_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME1_PIPE0_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME1_PIPE0_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME1_PIPE0_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME1_PIPE0_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME1_PIPE0_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME1_PIPE0_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME1_PIPE0_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME1_PIPE0_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME1_PIPE0_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME1_PIPE0_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME1_PIPE0_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME1_PIPE1_INT_STATUS
#define CP_ME1_PIPE1_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME1_PIPE1_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME1_PIPE1_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME1_PIPE1_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME1_PIPE1_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME1_PIPE1_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME1_PIPE1_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME1_PIPE1_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME1_PIPE1_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME1_PIPE1_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME1_PIPE1_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME1_PIPE1_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME1_PIPE1_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME1_PIPE1_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME1_PIPE1_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME1_PIPE1_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME1_PIPE1_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME1_PIPE1_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME1_PIPE1_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME1_PIPE1_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME1_PIPE1_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME1_PIPE1_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME1_PIPE1_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME1_PIPE1_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME1_PIPE1_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME1_PIPE1_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME1_PIPE2_INT_STATUS
#define CP_ME1_PIPE2_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME1_PIPE2_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME1_PIPE2_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME1_PIPE2_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME1_PIPE2_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME1_PIPE2_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME1_PIPE2_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME1_PIPE2_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME1_PIPE2_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME1_PIPE2_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME1_PIPE2_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME1_PIPE2_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME1_PIPE2_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME1_PIPE2_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME1_PIPE2_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME1_PIPE2_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME1_PIPE2_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME1_PIPE2_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME1_PIPE2_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME1_PIPE2_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME1_PIPE2_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME1_PIPE2_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME1_PIPE2_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME1_PIPE2_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME1_PIPE2_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME1_PIPE2_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME1_PIPE3_INT_STATUS
#define CP_ME1_PIPE3_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME1_PIPE3_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME1_PIPE3_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME1_PIPE3_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME1_PIPE3_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME1_PIPE3_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME1_PIPE3_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME1_PIPE3_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME1_PIPE3_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME1_PIPE3_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME1_PIPE3_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME1_PIPE3_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME1_PIPE3_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME1_PIPE3_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME1_PIPE3_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME1_PIPE3_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME1_PIPE3_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME1_PIPE3_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME1_PIPE3_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME1_PIPE3_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME1_PIPE3_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME1_PIPE3_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME1_PIPE3_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME1_PIPE3_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME1_PIPE3_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME1_PIPE3_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME2_PIPE0_INT_STATUS
#define CP_ME2_PIPE0_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME2_PIPE0_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME2_PIPE0_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME2_PIPE0_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME2_PIPE0_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME2_PIPE0_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME2_PIPE0_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME2_PIPE0_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME2_PIPE0_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME2_PIPE0_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME2_PIPE0_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME2_PIPE0_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME2_PIPE0_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME2_PIPE0_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME2_PIPE0_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME2_PIPE0_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME2_PIPE0_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME2_PIPE0_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME2_PIPE0_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME2_PIPE0_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME2_PIPE0_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME2_PIPE0_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME2_PIPE0_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME2_PIPE0_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME2_PIPE0_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME2_PIPE0_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME2_PIPE1_INT_STATUS
#define CP_ME2_PIPE1_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME2_PIPE1_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME2_PIPE1_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME2_PIPE1_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME2_PIPE1_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME2_PIPE1_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME2_PIPE1_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME2_PIPE1_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME2_PIPE1_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME2_PIPE1_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME2_PIPE1_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME2_PIPE1_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME2_PIPE1_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME2_PIPE1_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME2_PIPE1_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME2_PIPE1_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME2_PIPE1_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME2_PIPE1_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME2_PIPE1_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME2_PIPE1_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME2_PIPE1_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME2_PIPE1_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME2_PIPE1_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME2_PIPE1_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME2_PIPE1_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME2_PIPE1_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME2_PIPE2_INT_STATUS
#define CP_ME2_PIPE2_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME2_PIPE2_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME2_PIPE2_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME2_PIPE2_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME2_PIPE2_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME2_PIPE2_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME2_PIPE2_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME2_PIPE2_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME2_PIPE2_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME2_PIPE2_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME2_PIPE2_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME2_PIPE2_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME2_PIPE2_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME2_PIPE2_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME2_PIPE2_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME2_PIPE2_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME2_PIPE2_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME2_PIPE2_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME2_PIPE2_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME2_PIPE2_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME2_PIPE2_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME2_PIPE2_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME2_PIPE2_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME2_PIPE2_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME2_PIPE2_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME2_PIPE2_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
//CP_ME2_PIPE3_INT_STATUS
#define CP_ME2_PIPE3_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                           0xc
#define CP_ME2_PIPE3_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                            0xd
#define CP_ME2_PIPE3_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                               0xe
#define CP_ME2_PIPE3_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                              0xf
#define CP_ME2_PIPE3_INT_STATUS__GPF_INT_STATUS__SHIFT                                                        0x10
#define CP_ME2_PIPE3_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                           0x11
#define CP_ME2_PIPE3_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                   0x17
#define CP_ME2_PIPE3_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                               0x18
#define CP_ME2_PIPE3_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                 0x1a
#define CP_ME2_PIPE3_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                         0x1b
#define CP_ME2_PIPE3_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                   0x1d
#define CP_ME2_PIPE3_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                   0x1e
#define CP_ME2_PIPE3_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                   0x1f
#define CP_ME2_PIPE3_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                             0x00001000L
#define CP_ME2_PIPE3_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                              0x00002000L
#define CP_ME2_PIPE3_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                 0x00004000L
#define CP_ME2_PIPE3_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                0x00008000L
#define CP_ME2_PIPE3_INT_STATUS__GPF_INT_STATUS_MASK                                                          0x00010000L
#define CP_ME2_PIPE3_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                             0x00020000L
#define CP_ME2_PIPE3_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                     0x00800000L
#define CP_ME2_PIPE3_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                 0x01000000L
#define CP_ME2_PIPE3_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                   0x04000000L
#define CP_ME2_PIPE3_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                           0x08000000L
#define CP_ME2_PIPE3_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                     0x20000000L
#define CP_ME2_PIPE3_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                     0x40000000L
#define CP_ME2_PIPE3_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                     0x80000000L
#define CP_ME1_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                   0x17
#define CP_ME1_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                     0x00800000L
#define CP_ME2_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                   0x17
#define CP_ME2_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                     0x00800000L
//CC_GC_EDC_CONFIG
#define CC_GC_EDC_CONFIG__DIS_EDC__SHIFT                                                                      0x1
#define CC_GC_EDC_CONFIG__ENABLE_IRRITATOR_CLK__SHIFT                                                         0x2
#define CC_GC_EDC_CONFIG__DIS_EDC_MASK                                                                        0x00000002L
#define CC_GC_EDC_CONFIG__ENABLE_IRRITATOR_CLK_MASK                                                           0x00000004L
//CP_ME1_PIPE_PRIORITY_CNTS
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY1_CNT__SHIFT                                                       0x0
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY2A_CNT__SHIFT                                                      0x8
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY2B_CNT__SHIFT                                                      0x10
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY3_CNT__SHIFT                                                       0x18
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY1_CNT_MASK                                                         0x000000FFL
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY2A_CNT_MASK                                                        0x0000FF00L
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY2B_CNT_MASK                                                        0x00FF0000L
#define CP_ME1_PIPE_PRIORITY_CNTS__PRIORITY3_CNT_MASK                                                         0xFF000000L
//CP_ME1_PIPE0_PRIORITY
#define CP_ME1_PIPE0_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME1_PIPE0_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME1_PIPE1_PRIORITY
#define CP_ME1_PIPE1_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME1_PIPE1_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME1_PIPE2_PRIORITY
#define CP_ME1_PIPE2_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME1_PIPE2_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME1_PIPE3_PRIORITY
#define CP_ME1_PIPE3_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME1_PIPE3_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME2_PIPE_PRIORITY_CNTS
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY1_CNT__SHIFT                                                       0x0
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY2A_CNT__SHIFT                                                      0x8
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY2B_CNT__SHIFT                                                      0x10
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY3_CNT__SHIFT                                                       0x18
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY1_CNT_MASK                                                         0x000000FFL
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY2A_CNT_MASK                                                        0x0000FF00L
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY2B_CNT_MASK                                                        0x00FF0000L
#define CP_ME2_PIPE_PRIORITY_CNTS__PRIORITY3_CNT_MASK                                                         0xFF000000L
//CP_ME2_PIPE0_PRIORITY
#define CP_ME2_PIPE0_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME2_PIPE0_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME2_PIPE1_PRIORITY
#define CP_ME2_PIPE1_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME2_PIPE1_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME2_PIPE2_PRIORITY
#define CP_ME2_PIPE2_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME2_PIPE2_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_ME2_PIPE3_PRIORITY
#define CP_ME2_PIPE3_PRIORITY__PRIORITY__SHIFT                                                                0x0
#define CP_ME2_PIPE3_PRIORITY__PRIORITY_MASK                                                                  0x00000003L
//CP_CE_PRGRM_CNTR_START
#define CP_CE_PRGRM_CNTR_START__IP_START__SHIFT                                                               0x0
#define CP_CE_PRGRM_CNTR_START__IP_START_MASK                                                                 0x000007FFL
//CP_PFP_PRGRM_CNTR_START
#define CP_PFP_PRGRM_CNTR_START__IP_START__SHIFT                                                              0x0
#define CP_PFP_PRGRM_CNTR_START__IP_START_MASK                                                                0x00001FFFL
//CP_ME_PRGRM_CNTR_START
#define CP_ME_PRGRM_CNTR_START__IP_START__SHIFT                                                               0x0
#define CP_ME_PRGRM_CNTR_START__IP_START_MASK                                                                 0x00000FFFL
//CP_MEC1_PRGRM_CNTR_START
#define CP_MEC1_PRGRM_CNTR_START__IP_START__SHIFT                                                             0x0
#define CP_MEC1_PRGRM_CNTR_START__IP_START_MASK                                                               0x0000FFFFL
//CP_MEC2_PRGRM_CNTR_START
#define CP_MEC2_PRGRM_CNTR_START__IP_START__SHIFT                                                             0x0
#define CP_MEC2_PRGRM_CNTR_START__IP_START_MASK                                                               0x0000FFFFL
//CP_CE_INTR_ROUTINE_START
#define CP_CE_INTR_ROUTINE_START__IR_START__SHIFT                                                             0x0
#define CP_CE_INTR_ROUTINE_START__IR_START_MASK                                                               0x000007FFL
//CP_PFP_INTR_ROUTINE_START
#define CP_PFP_INTR_ROUTINE_START__IR_START__SHIFT                                                            0x0
#define CP_PFP_INTR_ROUTINE_START__IR_START_MASK                                                              0x00001FFFL
//CP_ME_INTR_ROUTINE_START
#define CP_ME_INTR_ROUTINE_START__IR_START__SHIFT                                                             0x0
#define CP_ME_INTR_ROUTINE_START__IR_START_MASK                                                               0x00000FFFL
//CP_MEC1_INTR_ROUTINE_START
#define CP_MEC1_INTR_ROUTINE_START__IR_START__SHIFT                                                           0x0
#define CP_MEC1_INTR_ROUTINE_START__IR_START_MASK                                                             0x0000FFFFL
//CP_MEC2_INTR_ROUTINE_START
#define CP_MEC2_INTR_ROUTINE_START__IR_START__SHIFT                                                           0x0
#define CP_MEC2_INTR_ROUTINE_START__IR_START_MASK                                                             0x0000FFFFL
//CP_CONTEXT_CNTL
#define CP_CONTEXT_CNTL__ME0PIPE0_MAX_WD_CNTX__SHIFT                                                          0x0
#define CP_CONTEXT_CNTL__ME0PIPE0_MAX_PIPE_CNTX__SHIFT                                                        0x4
#define CP_CONTEXT_CNTL__ME0PIPE1_MAX_WD_CNTX__SHIFT                                                          0x10
#define CP_CONTEXT_CNTL__ME0PIPE1_MAX_PIPE_CNTX__SHIFT                                                        0x14
#define CP_CONTEXT_CNTL__ME0PIPE0_MAX_WD_CNTX_MASK                                                            0x00000007L
#define CP_CONTEXT_CNTL__ME0PIPE0_MAX_PIPE_CNTX_MASK                                                          0x00000070L
#define CP_CONTEXT_CNTL__ME0PIPE1_MAX_WD_CNTX_MASK                                                            0x00070000L
#define CP_CONTEXT_CNTL__ME0PIPE1_MAX_PIPE_CNTX_MASK                                                          0x00700000L
//CP_MAX_CONTEXT
#define CP_MAX_CONTEXT__MAX_CONTEXT__SHIFT                                                                    0x0
#define CP_MAX_CONTEXT__MAX_CONTEXT_MASK                                                                      0x00000007L
//CP_IQ_WAIT_TIME1
#define CP_IQ_WAIT_TIME1__IB_OFFLOAD__SHIFT                                                                   0x0
#define CP_IQ_WAIT_TIME1__ATOMIC_OFFLOAD__SHIFT                                                               0x8
#define CP_IQ_WAIT_TIME1__WRM_OFFLOAD__SHIFT                                                                  0x10
#define CP_IQ_WAIT_TIME1__GWS__SHIFT                                                                          0x18
#define CP_IQ_WAIT_TIME1__IB_OFFLOAD_MASK                                                                     0x000000FFL
#define CP_IQ_WAIT_TIME1__ATOMIC_OFFLOAD_MASK                                                                 0x0000FF00L
#define CP_IQ_WAIT_TIME1__WRM_OFFLOAD_MASK                                                                    0x00FF0000L
#define CP_IQ_WAIT_TIME1__GWS_MASK                                                                            0xFF000000L
//CP_IQ_WAIT_TIME2
#define CP_IQ_WAIT_TIME2__QUE_SLEEP__SHIFT                                                                    0x0
#define CP_IQ_WAIT_TIME2__SCH_WAVE__SHIFT                                                                     0x8
#define CP_IQ_WAIT_TIME2__SEM_REARM__SHIFT                                                                    0x10
#define CP_IQ_WAIT_TIME2__DEQ_RETRY__SHIFT                                                                    0x18
#define CP_IQ_WAIT_TIME2__QUE_SLEEP_MASK                                                                      0x000000FFL
#define CP_IQ_WAIT_TIME2__SCH_WAVE_MASK                                                                       0x0000FF00L
#define CP_IQ_WAIT_TIME2__SEM_REARM_MASK                                                                      0x00FF0000L
#define CP_IQ_WAIT_TIME2__DEQ_RETRY_MASK                                                                      0xFF000000L
//CP_RB0_BASE_HI
#define CP_RB0_BASE_HI__RB_BASE_HI__SHIFT                                                                     0x0
#define CP_RB0_BASE_HI__RB_BASE_HI_MASK                                                                       0x000000FFL
//CP_RB1_BASE_HI
#define CP_RB1_BASE_HI__RB_BASE_HI__SHIFT                                                                     0x0
#define CP_RB1_BASE_HI__RB_BASE_HI_MASK                                                                       0x000000FFL
//CP_VMID_RESET
#define CP_VMID_RESET__RESET_REQUEST__SHIFT                                                                   0x0
#define CP_VMID_RESET__RESET_REQUEST_MASK                                                                     0x0000FFFFL
//CPC_INT_CNTL
#define CPC_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE__SHIFT                                                      0xc
#define CPC_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE__SHIFT                                                       0xd
#define CPC_INT_CNTL__CP_ECC_ERROR_INT_ENABLE__SHIFT                                                          0xe
#define CPC_INT_CNTL__SUA_VIOLATION_INT_ENABLE__SHIFT                                                         0xf
#define CPC_INT_CNTL__GPF_INT_ENABLE__SHIFT                                                                   0x10
#define CPC_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE__SHIFT                                                      0x11
#define CPC_INT_CNTL__PRIV_REG_INT_ENABLE__SHIFT                                                              0x17
#define CPC_INT_CNTL__OPCODE_ERROR_INT_ENABLE__SHIFT                                                          0x18
#define CPC_INT_CNTL__TIME_STAMP_INT_ENABLE__SHIFT                                                            0x1a
#define CPC_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE__SHIFT                                                    0x1b
#define CPC_INT_CNTL__GENERIC2_INT_ENABLE__SHIFT                                                              0x1d
#define CPC_INT_CNTL__GENERIC1_INT_ENABLE__SHIFT                                                              0x1e
#define CPC_INT_CNTL__GENERIC0_INT_ENABLE__SHIFT                                                              0x1f
#define CPC_INT_CNTL__CMP_QUERY_STATUS_INT_ENABLE_MASK                                                        0x00001000L
#define CPC_INT_CNTL__DEQUEUE_REQUEST_INT_ENABLE_MASK                                                         0x00002000L
#define CPC_INT_CNTL__CP_ECC_ERROR_INT_ENABLE_MASK                                                            0x00004000L
#define CPC_INT_CNTL__SUA_VIOLATION_INT_ENABLE_MASK                                                           0x00008000L
#define CPC_INT_CNTL__GPF_INT_ENABLE_MASK                                                                     0x00010000L
#define CPC_INT_CNTL__WRM_POLL_TIMEOUT_INT_ENABLE_MASK                                                        0x00020000L
#define CPC_INT_CNTL__PRIV_REG_INT_ENABLE_MASK                                                                0x00800000L
#define CPC_INT_CNTL__OPCODE_ERROR_INT_ENABLE_MASK                                                            0x01000000L
#define CPC_INT_CNTL__TIME_STAMP_INT_ENABLE_MASK                                                              0x04000000L
#define CPC_INT_CNTL__RESERVED_BIT_ERROR_INT_ENABLE_MASK                                                      0x08000000L
#define CPC_INT_CNTL__GENERIC2_INT_ENABLE_MASK                                                                0x20000000L
#define CPC_INT_CNTL__GENERIC1_INT_ENABLE_MASK                                                                0x40000000L
#define CPC_INT_CNTL__GENERIC0_INT_ENABLE_MASK                                                                0x80000000L
//CPC_INT_STATUS
#define CPC_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS__SHIFT                                                    0xc
#define CPC_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS__SHIFT                                                     0xd
#define CPC_INT_STATUS__CP_ECC_ERROR_INT_STATUS__SHIFT                                                        0xe
#define CPC_INT_STATUS__SUA_VIOLATION_INT_STATUS__SHIFT                                                       0xf
#define CPC_INT_STATUS__GPF_INT_STATUS__SHIFT                                                                 0x10
#define CPC_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS__SHIFT                                                    0x11
#define CPC_INT_STATUS__PRIV_REG_INT_STATUS__SHIFT                                                            0x17
#define CPC_INT_STATUS__OPCODE_ERROR_INT_STATUS__SHIFT                                                        0x18
#define CPC_INT_STATUS__TIME_STAMP_INT_STATUS__SHIFT                                                          0x1a
#define CPC_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS__SHIFT                                                  0x1b
#define CPC_INT_STATUS__GENERIC2_INT_STATUS__SHIFT                                                            0x1d
#define CPC_INT_STATUS__GENERIC1_INT_STATUS__SHIFT                                                            0x1e
#define CPC_INT_STATUS__GENERIC0_INT_STATUS__SHIFT                                                            0x1f
#define CPC_INT_STATUS__CMP_QUERY_STATUS_INT_STATUS_MASK                                                      0x00001000L
#define CPC_INT_STATUS__DEQUEUE_REQUEST_INT_STATUS_MASK                                                       0x00002000L
#define CPC_INT_STATUS__CP_ECC_ERROR_INT_STATUS_MASK                                                          0x00004000L
#define CPC_INT_STATUS__SUA_VIOLATION_INT_STATUS_MASK                                                         0x00008000L
#define CPC_INT_STATUS__GPF_INT_STATUS_MASK                                                                   0x00010000L
#define CPC_INT_STATUS__WRM_POLL_TIMEOUT_INT_STATUS_MASK                                                      0x00020000L
#define CPC_INT_STATUS__PRIV_REG_INT_STATUS_MASK                                                              0x00800000L
#define CPC_INT_STATUS__OPCODE_ERROR_INT_STATUS_MASK                                                          0x01000000L
#define CPC_INT_STATUS__TIME_STAMP_INT_STATUS_MASK                                                            0x04000000L
#define CPC_INT_STATUS__RESERVED_BIT_ERROR_INT_STATUS_MASK                                                    0x08000000L
#define CPC_INT_STATUS__GENERIC2_INT_STATUS_MASK                                                              0x20000000L
#define CPC_INT_STATUS__GENERIC1_INT_STATUS_MASK                                                              0x40000000L
#define CPC_INT_STATUS__GENERIC0_INT_STATUS_MASK                                                              0x80000000L
//CP_VMID_PREEMPT
#define CP_VMID_PREEMPT__PREEMPT_REQUEST__SHIFT                                                               0x0
#define CP_VMID_PREEMPT__VIRT_COMMAND__SHIFT                                                                  0x10
#define CP_VMID_PREEMPT__PREEMPT_REQUEST_MASK                                                                 0x0000FFFFL
#define CP_VMID_PREEMPT__VIRT_COMMAND_MASK                                                                    0x000F0000L
//CPC_INT_CNTX_ID
#define CPC_INT_CNTX_ID__CNTX_ID__SHIFT                                                                       0x0
#define CPC_INT_CNTX_ID__CNTX_ID_MASK                                                                         0xFFFFFFFFL
//CP_PQ_STATUS
#define CP_PQ_STATUS__DOORBELL_UPDATED__SHIFT                                                                 0x0
#define CP_PQ_STATUS__DOORBELL_ENABLE__SHIFT                                                                  0x1
#define CP_PQ_STATUS__DOORBELL_UPDATED_MASK                                                                   0x00000001L
#define CP_PQ_STATUS__DOORBELL_ENABLE_MASK                                                                    0x00000002L
//CP_CPC_IC_BASE_LO
#define CP_CPC_IC_BASE_LO__IC_BASE_LO__SHIFT                                                                  0xc
#define CP_CPC_IC_BASE_LO__IC_BASE_LO_MASK                                                                    0xFFFFF000L
//CP_CPC_IC_BASE_HI
#define CP_CPC_IC_BASE_HI__IC_BASE_HI__SHIFT                                                                  0x0
#define CP_CPC_IC_BASE_HI__IC_BASE_HI_MASK                                                                    0x0000FFFFL
//CP_CPC_IC_BASE_CNTL
#define CP_CPC_IC_BASE_CNTL__VMID__SHIFT                                                                      0x0
#define CP_CPC_IC_BASE_CNTL__CACHE_POLICY__SHIFT                                                              0x18
#define CP_CPC_IC_BASE_CNTL__VMID_MASK                                                                        0x0000000FL
#define CP_CPC_IC_BASE_CNTL__CACHE_POLICY_MASK                                                                0x01000000L
//CP_CPC_IC_OP_CNTL
#define CP_CPC_IC_OP_CNTL__INVALIDATE_CACHE__SHIFT                                                            0x0
#define CP_CPC_IC_OP_CNTL__PRIME_ICACHE__SHIFT                                                                0x4
#define CP_CPC_IC_OP_CNTL__ICACHE_PRIMED__SHIFT                                                               0x5
#define CP_CPC_IC_OP_CNTL__ICACHE_INVALIDATED__SHIFT                                                          0x6
#define CP_CPC_IC_OP_CNTL__INVALIDATE_CACHE_MASK                                                              0x00000001L
#define CP_CPC_IC_OP_CNTL__PRIME_ICACHE_MASK                                                                  0x00000010L
#define CP_CPC_IC_OP_CNTL__ICACHE_PRIMED_MASK                                                                 0x00000020L
#define CP_CPC_IC_OP_CNTL__ICACHE_INVALIDATED_MASK                                                            0x00000040L
//CP_MEC1_F32_INT_DIS
#define CP_MEC1_F32_INT_DIS__EDC_ROQ_FED_INT__SHIFT                                                           0x0
#define CP_MEC1_F32_INT_DIS__PRIV_REG_INT__SHIFT                                                              0x1
#define CP_MEC1_F32_INT_DIS__RESERVED_BIT_ERR_INT__SHIFT                                                      0x2
#define CP_MEC1_F32_INT_DIS__EDC_TC_FED_INT__SHIFT                                                            0x3
#define CP_MEC1_F32_INT_DIS__EDC_GDS_FED_INT__SHIFT                                                           0x4
#define CP_MEC1_F32_INT_DIS__EDC_SCRATCH_FED_INT__SHIFT                                                       0x5
#define CP_MEC1_F32_INT_DIS__WAVE_RESTORE_INT__SHIFT                                                          0x6
#define CP_MEC1_F32_INT_DIS__SUA_VIOLATION_INT__SHIFT                                                         0x7
#define CP_MEC1_F32_INT_DIS__EDC_DMA_FED_INT__SHIFT                                                           0x8
#define CP_MEC1_F32_INT_DIS__IQ_TIMER_INT__SHIFT                                                              0x9
#define CP_MEC1_F32_INT_DIS__GPF_INT_CPF__SHIFT                                                               0xa
#define CP_MEC1_F32_INT_DIS__GPF_INT_DMA__SHIFT                                                               0xb
#define CP_MEC1_F32_INT_DIS__GPF_INT_CPC__SHIFT                                                               0xc
#define CP_MEC1_F32_INT_DIS__EDC_SR_MEM_FED_INT__SHIFT                                                        0xd
#define CP_MEC1_F32_INT_DIS__QUEUE_MESSAGE_INT__SHIFT                                                         0xe
#define CP_MEC1_F32_INT_DIS__FATAL_EDC_ERROR_INT__SHIFT                                                       0xf
#define CP_MEC1_F32_INT_DIS__EDC_ROQ_FED_INT_MASK                                                             0x00000001L
#define CP_MEC1_F32_INT_DIS__PRIV_REG_INT_MASK                                                                0x00000002L
#define CP_MEC1_F32_INT_DIS__RESERVED_BIT_ERR_INT_MASK                                                        0x00000004L
#define CP_MEC1_F32_INT_DIS__EDC_TC_FED_INT_MASK                                                              0x00000008L
#define CP_MEC1_F32_INT_DIS__EDC_GDS_FED_INT_MASK                                                             0x00000010L
#define CP_MEC1_F32_INT_DIS__EDC_SCRATCH_FED_INT_MASK                                                         0x00000020L
#define CP_MEC1_F32_INT_DIS__WAVE_RESTORE_INT_MASK                                                            0x00000040L
#define CP_MEC1_F32_INT_DIS__SUA_VIOLATION_INT_MASK                                                           0x00000080L
#define CP_MEC1_F32_INT_DIS__EDC_DMA_FED_INT_MASK                                                             0x00000100L
#define CP_MEC1_F32_INT_DIS__IQ_TIMER_INT_MASK                                                                0x00000200L
#define CP_MEC1_F32_INT_DIS__GPF_INT_CPF_MASK                                                                 0x00000400L
#define CP_MEC1_F32_INT_DIS__GPF_INT_DMA_MASK                                                                 0x00000800L
#define CP_MEC1_F32_INT_DIS__GPF_INT_CPC_MASK                                                                 0x00001000L
#define CP_MEC1_F32_INT_DIS__EDC_SR_MEM_FED_INT_MASK                                                          0x00002000L
#define CP_MEC1_F32_INT_DIS__QUEUE_MESSAGE_INT_MASK                                                           0x00004000L
#define CP_MEC1_F32_INT_DIS__FATAL_EDC_ERROR_INT_MASK                                                         0x00008000L
//CP_MEC2_F32_INT_DIS
#define CP_MEC2_F32_INT_DIS__EDC_ROQ_FED_INT__SHIFT                                                           0x0
#define CP_MEC2_F32_INT_DIS__PRIV_REG_INT__SHIFT                                                              0x1
#define CP_MEC2_F32_INT_DIS__RESERVED_BIT_ERR_INT__SHIFT                                                      0x2
#define CP_MEC2_F32_INT_DIS__EDC_TC_FED_INT__SHIFT                                                            0x3
#define CP_MEC2_F32_INT_DIS__EDC_GDS_FED_INT__SHIFT                                                           0x4
#define CP_MEC2_F32_INT_DIS__EDC_SCRATCH_FED_INT__SHIFT                                                       0x5
#define CP_MEC2_F32_INT_DIS__WAVE_RESTORE_INT__SHIFT                                                          0x6
#define CP_MEC2_F32_INT_DIS__SUA_VIOLATION_INT__SHIFT                                                         0x7
#define CP_MEC2_F32_INT_DIS__EDC_DMA_FED_INT__SHIFT                                                           0x8
#define CP_MEC2_F32_INT_DIS__IQ_TIMER_INT__SHIFT                                                              0x9
#define CP_MEC2_F32_INT_DIS__GPF_INT_CPF__SHIFT                                                               0xa
#define CP_MEC2_F32_INT_DIS__GPF_INT_DMA__SHIFT                                                               0xb
#define CP_MEC2_F32_INT_DIS__GPF_INT_CPC__SHIFT                                                               0xc
#define CP_MEC2_F32_INT_DIS__EDC_SR_MEM_FED_INT__SHIFT                                                        0xd
#define CP_MEC2_F32_INT_DIS__QUEUE_MESSAGE_INT__SHIFT                                                         0xe
#define CP_MEC2_F32_INT_DIS__FATAL_EDC_ERROR_INT__SHIFT                                                       0xf
#define CP_MEC2_F32_INT_DIS__EDC_ROQ_FED_INT_MASK                                                             0x00000001L
#define CP_MEC2_F32_INT_DIS__PRIV_REG_INT_MASK                                                                0x00000002L
#define CP_MEC2_F32_INT_DIS__RESERVED_BIT_ERR_INT_MASK                                                        0x00000004L
#define CP_MEC2_F32_INT_DIS__EDC_TC_FED_INT_MASK                                                              0x00000008L
#define CP_MEC2_F32_INT_DIS__EDC_GDS_FED_INT_MASK                                                             0x00000010L
#define CP_MEC2_F32_INT_DIS__EDC_SCRATCH_FED_INT_MASK                                                         0x00000020L
#define CP_MEC2_F32_INT_DIS__WAVE_RESTORE_INT_MASK                                                            0x00000040L
#define CP_MEC2_F32_INT_DIS__SUA_VIOLATION_INT_MASK                                                           0x00000080L
#define CP_MEC2_F32_INT_DIS__EDC_DMA_FED_INT_MASK                                                             0x00000100L
#define CP_MEC2_F32_INT_DIS__IQ_TIMER_INT_MASK                                                                0x00000200L
#define CP_MEC2_F32_INT_DIS__GPF_INT_CPF_MASK                                                                 0x00000400L
#define CP_MEC2_F32_INT_DIS__GPF_INT_DMA_MASK                                                                 0x00000800L
#define CP_MEC2_F32_INT_DIS__GPF_INT_CPC_MASK                                                                 0x00001000L
#define CP_MEC2_F32_INT_DIS__EDC_SR_MEM_FED_INT_MASK                                                          0x00002000L
#define CP_MEC2_F32_INT_DIS__QUEUE_MESSAGE_INT_MASK                                                           0x00004000L
#define CP_MEC2_F32_INT_DIS__FATAL_EDC_ERROR_INT_MASK                                                         0x00008000L
//CP_VMID_STATUS
#define CP_VMID_STATUS__PREEMPT_DE_STATUS__SHIFT                                                              0x0
#define CP_VMID_STATUS__PREEMPT_CE_STATUS__SHIFT                                                              0x10
#define CP_VMID_STATUS__PREEMPT_DE_STATUS_MASK                                                                0x0000FFFFL
#define CP_VMID_STATUS__PREEMPT_CE_STATUS_MASK                                                                0xFFFF0000L


// addressBlock: gc_cppdec2
//CP_RB_DOORBELL_CONTROL_SCH_0
#define CP_RB_DOORBELL_CONTROL_SCH_0__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_0__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_0__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_0__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_0__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_0__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_1
#define CP_RB_DOORBELL_CONTROL_SCH_1__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_1__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_1__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_1__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_1__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_1__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_2
#define CP_RB_DOORBELL_CONTROL_SCH_2__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_2__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_2__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_2__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_2__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_2__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_3
#define CP_RB_DOORBELL_CONTROL_SCH_3__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_3__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_3__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_3__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_3__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_3__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_4
#define CP_RB_DOORBELL_CONTROL_SCH_4__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_4__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_4__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_4__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_4__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_4__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_5
#define CP_RB_DOORBELL_CONTROL_SCH_5__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_5__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_5__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_5__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_5__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_5__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_6
#define CP_RB_DOORBELL_CONTROL_SCH_6__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_6__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_6__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_6__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_6__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_6__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CONTROL_SCH_7
#define CP_RB_DOORBELL_CONTROL_SCH_7__DOORBELL_OFFSET__SHIFT                                                  0x2
#define CP_RB_DOORBELL_CONTROL_SCH_7__DOORBELL_EN__SHIFT                                                      0x1e
#define CP_RB_DOORBELL_CONTROL_SCH_7__DOORBELL_HIT__SHIFT                                                     0x1f
#define CP_RB_DOORBELL_CONTROL_SCH_7__DOORBELL_OFFSET_MASK                                                    0x0FFFFFFCL
#define CP_RB_DOORBELL_CONTROL_SCH_7__DOORBELL_EN_MASK                                                        0x40000000L
#define CP_RB_DOORBELL_CONTROL_SCH_7__DOORBELL_HIT_MASK                                                       0x80000000L
//CP_RB_DOORBELL_CLEAR
#define CP_RB_DOORBELL_CLEAR__MAPPED_QUEUE__SHIFT                                                             0x0
#define CP_RB_DOORBELL_CLEAR__MAPPED_QUE_DOORBELL_EN_CLEAR__SHIFT                                             0x8
#define CP_RB_DOORBELL_CLEAR__MAPPED_QUE_DOORBELL_HIT_CLEAR__SHIFT                                            0x9
#define CP_RB_DOORBELL_CLEAR__MASTER_DOORBELL_EN_CLEAR__SHIFT                                                 0xa
#define CP_RB_DOORBELL_CLEAR__MASTER_DOORBELL_HIT_CLEAR__SHIFT                                                0xb
#define CP_RB_DOORBELL_CLEAR__QUEUES_DOORBELL_EN_CLEAR__SHIFT                                                 0xc
#define CP_RB_DOORBELL_CLEAR__QUEUES_DOORBELL_HIT_CLEAR__SHIFT                                                0xd
#define CP_RB_DOORBELL_CLEAR__MAPPED_QUEUE_MASK                                                               0x00000007L
#define CP_RB_DOORBELL_CLEAR__MAPPED_QUE_DOORBELL_EN_CLEAR_MASK                                               0x00000100L
#define CP_RB_DOORBELL_CLEAR__MAPPED_QUE_DOORBELL_HIT_CLEAR_MASK                                              0x00000200L
#define CP_RB_DOORBELL_CLEAR__MASTER_DOORBELL_EN_CLEAR_MASK                                                   0x00000400L
#define CP_RB_DOORBELL_CLEAR__MASTER_DOORBELL_HIT_CLEAR_MASK                                                  0x00000800L
#define CP_RB_DOORBELL_CLEAR__QUEUES_DOORBELL_EN_CLEAR_MASK                                                   0x00001000L
#define CP_RB_DOORBELL_CLEAR__QUEUES_DOORBELL_HIT_CLEAR_MASK                                                  0x00002000L
//CPF_EDC_TAG_CNT
#define CPF_EDC_TAG_CNT__DED_COUNT__SHIFT                                                                     0x0
#define CPF_EDC_TAG_CNT__SEC_COUNT__SHIFT                                                                     0x2
#define CPF_EDC_TAG_CNT__DED_COUNT_MASK                                                                       0x00000003L
#define CPF_EDC_TAG_CNT__SEC_COUNT_MASK                                                                       0x0000000CL
//CPF_EDC_ROQ_CNT
#define CPF_EDC_ROQ_CNT__DED_COUNT_ME1__SHIFT                                                                 0x0
#define CPF_EDC_ROQ_CNT__SEC_COUNT_ME1__SHIFT                                                                 0x2
#define CPF_EDC_ROQ_CNT__DED_COUNT_ME2__SHIFT                                                                 0x4
#define CPF_EDC_ROQ_CNT__SEC_COUNT_ME2__SHIFT                                                                 0x6
#define CPF_EDC_ROQ_CNT__DED_COUNT_ME1_MASK                                                                   0x00000003L
#define CPF_EDC_ROQ_CNT__SEC_COUNT_ME1_MASK                                                                   0x0000000CL
#define CPF_EDC_ROQ_CNT__DED_COUNT_ME2_MASK                                                                   0x00000030L
#define CPF_EDC_ROQ_CNT__SEC_COUNT_ME2_MASK                                                                   0x000000C0L
//CPG_EDC_TAG_CNT
#define CPG_EDC_TAG_CNT__DED_COUNT__SHIFT                                                                     0x0
#define CPG_EDC_TAG_CNT__SEC_COUNT__SHIFT                                                                     0x2
#define CPG_EDC_TAG_CNT__DED_COUNT_MASK                                                                       0x00000003L
#define CPG_EDC_TAG_CNT__SEC_COUNT_MASK                                                                       0x0000000CL
//CPG_EDC_DMA_CNT
#define CPG_EDC_DMA_CNT__ROQ_DED_COUNT__SHIFT                                                                 0x0
#define CPG_EDC_DMA_CNT__ROQ_SEC_COUNT__SHIFT                                                                 0x2
#define CPG_EDC_DMA_CNT__TAG_DED_COUNT__SHIFT                                                                 0x4
#define CPG_EDC_DMA_CNT__TAG_SEC_COUNT__SHIFT                                                                 0x6
#define CPG_EDC_DMA_CNT__ROQ_DED_COUNT_MASK                                                                   0x00000003L
#define CPG_EDC_DMA_CNT__ROQ_SEC_COUNT_MASK                                                                   0x0000000CL
#define CPG_EDC_DMA_CNT__TAG_DED_COUNT_MASK                                                                   0x00000030L
#define CPG_EDC_DMA_CNT__TAG_SEC_COUNT_MASK                                                                   0x000000C0L
//CPC_EDC_SCRATCH_CNT
#define CPC_EDC_SCRATCH_CNT__DED_COUNT__SHIFT                                                                 0x0
#define CPC_EDC_SCRATCH_CNT__SEC_COUNT__SHIFT                                                                 0x2
#define CPC_EDC_SCRATCH_CNT__DED_COUNT_MASK                                                                   0x00000003L
#define CPC_EDC_SCRATCH_CNT__SEC_COUNT_MASK                                                                   0x0000000CL
//CPC_EDC_UCODE_CNT
#define CPC_EDC_UCODE_CNT__DED_COUNT__SHIFT                                                                   0x0
#define CPC_EDC_UCODE_CNT__SEC_COUNT__SHIFT                                                                   0x2
#define CPC_EDC_UCODE_CNT__DED_COUNT_MASK                                                                     0x00000003L
#define CPC_EDC_UCODE_CNT__SEC_COUNT_MASK                                                                     0x0000000CL
//DC_EDC_STATE_CNT
#define DC_EDC_STATE_CNT__DED_COUNT_ME1__SHIFT                                                                0x0
#define DC_EDC_STATE_CNT__SEC_COUNT_ME1__SHIFT                                                                0x2
#define DC_EDC_STATE_CNT__DED_COUNT_ME1_MASK                                                                  0x00000003L
#define DC_EDC_STATE_CNT__SEC_COUNT_ME1_MASK                                                                  0x0000000CL
//DC_EDC_CSINVOC_CNT
#define DC_EDC_CSINVOC_CNT__DED_COUNT_ME1__SHIFT                                                              0x0
#define DC_EDC_CSINVOC_CNT__SEC_COUNT_ME1__SHIFT                                                              0x2
#define DC_EDC_CSINVOC_CNT__DED_COUNT1_ME1__SHIFT                                                             0x4
#define DC_EDC_CSINVOC_CNT__SEC_COUNT1_ME1__SHIFT                                                             0x6
#define DC_EDC_CSINVOC_CNT__DED_COUNT_ME1_MASK                                                                0x00000003L
#define DC_EDC_CSINVOC_CNT__SEC_COUNT_ME1_MASK                                                                0x0000000CL
#define DC_EDC_CSINVOC_CNT__DED_COUNT1_ME1_MASK                                                               0x00000030L
#define DC_EDC_CSINVOC_CNT__SEC_COUNT1_ME1_MASK                                                               0x000000C0L
//DC_EDC_RESTORE_CNT
#define DC_EDC_RESTORE_CNT__DED_COUNT_ME1__SHIFT                                                              0x0
#define DC_EDC_RESTORE_CNT__SEC_COUNT_ME1__SHIFT                                                              0x2
#define DC_EDC_RESTORE_CNT__DED_COUNT1_ME1__SHIFT                                                             0x4
#define DC_EDC_RESTORE_CNT__SEC_COUNT1_ME1__SHIFT                                                             0x6
#define DC_EDC_RESTORE_CNT__DED_COUNT_ME1_MASK                                                                0x00000003L
#define DC_EDC_RESTORE_CNT__SEC_COUNT_ME1_MASK                                                                0x0000000CL
#define DC_EDC_RESTORE_CNT__DED_COUNT1_ME1_MASK                                                               0x00000030L
#define DC_EDC_RESTORE_CNT__SEC_COUNT1_ME1_MASK                                                               0x000000C0L
//CP_CPF_DSM_CNTL
#define CP_CPF_DSM_CNTL__CPF0_DSM_IRRITATOR_DATA__SHIFT                                                       0x0
#define CP_CPF_DSM_CNTL__CPF0_ENABLE_SINGLE_WRITE__SHIFT                                                      0x2
#define CP_CPF_DSM_CNTL__CPF1_DSM_IRRITATOR_DATA__SHIFT                                                       0x3
#define CP_CPF_DSM_CNTL__CPF1_ENABLE_SINGLE_WRITE__SHIFT                                                      0x5
#define CP_CPF_DSM_CNTL__CPF2_DSM_IRRITATOR_DATA__SHIFT                                                       0x6
#define CP_CPF_DSM_CNTL__CPF2_ENABLE_SINGLE_WRITE__SHIFT                                                      0x8
#define CP_CPF_DSM_CNTL__CPF0_DSM_IRRITATOR_DATA_MASK                                                         0x00000003L
#define CP_CPF_DSM_CNTL__CPF0_ENABLE_SINGLE_WRITE_MASK                                                        0x00000004L
#define CP_CPF_DSM_CNTL__CPF1_DSM_IRRITATOR_DATA_MASK                                                         0x00000018L
#define CP_CPF_DSM_CNTL__CPF1_ENABLE_SINGLE_WRITE_MASK                                                        0x00000020L
#define CP_CPF_DSM_CNTL__CPF2_DSM_IRRITATOR_DATA_MASK                                                         0x000000C0L
#define CP_CPF_DSM_CNTL__CPF2_ENABLE_SINGLE_WRITE_MASK                                                        0x00000100L
//CP_CPG_DSM_CNTL
#define CP_CPG_DSM_CNTL__CPG0_DSM_IRRITATOR_DATA__SHIFT                                                       0x0
#define CP_CPG_DSM_CNTL__CPG0_ENABLE_SINGLE_WRITE__SHIFT                                                      0x2
#define CP_CPG_DSM_CNTL__CPG1_DSM_IRRITATOR_DATA__SHIFT                                                       0x3
#define CP_CPG_DSM_CNTL__CPG1_ENABLE_SINGLE_WRITE__SHIFT                                                      0x5
#define CP_CPG_DSM_CNTL__CPG2_DSM_IRRITATOR_DATA__SHIFT                                                       0x6
#define CP_CPG_DSM_CNTL__CPG2_ENABLE_SINGLE_WRITE__SHIFT                                                      0x8
#define CP_CPG_DSM_CNTL__CPG0_DSM_IRRITATOR_DATA_MASK                                                         0x00000003L
#define CP_CPG_DSM_CNTL__CPG0_ENABLE_SINGLE_WRITE_MASK                                                        0x00000004L
#define CP_CPG_DSM_CNTL__CPG1_DSM_IRRITATOR_DATA_MASK                                                         0x00000018L
#define CP_CPG_DSM_CNTL__CPG1_ENABLE_SINGLE_WRITE_MASK                                                        0x00000020L
#define CP_CPG_DSM_CNTL__CPG2_DSM_IRRITATOR_DATA_MASK                                                         0x000000C0L
#define CP_CPG_DSM_CNTL__CPG2_ENABLE_SINGLE_WRITE_MASK                                                        0x00000100L
//CP_CPC_DSM_CNTL
#define CP_CPC_DSM_CNTL__CPC0_DSM_IRRITATOR_DATA__SHIFT                                                       0x0
#define CP_CPC_DSM_CNTL__CPC0_ENABLE_SINGLE_WRITE__SHIFT                                                      0x2
#define CP_CPC_DSM_CNTL__CPC1_DSM_IRRITATOR_DATA__SHIFT                                                       0x3
#define CP_CPC_DSM_CNTL__CPC1_ENABLE_SINGLE_WRITE__SHIFT                                                      0x5
#define CP_CPC_DSM_CNTL__CPC2_DSM_IRRITATOR_DATA__SHIFT                                                       0x6
#define CP_CPC_DSM_CNTL__CPC2_ENABLE_SINGLE_WRITE__SHIFT                                                      0x8
#define CP_CPC_DSM_CNTL__CPC3_DSM_IRRITATOR_DATA__SHIFT                                                       0x9
#define CP_CPC_DSM_CNTL__CPC3_ENABLE_SINGLE_WRITE__SHIFT                                                      0xb
#define CP_CPC_DSM_CNTL__CPC4_DSM_IRRITATOR_DATA__SHIFT                                                       0xc
#define CP_CPC_DSM_CNTL__CPC4_ENABLE_SINGLE_WRITE__SHIFT                                                      0xe
#define CP_CPC_DSM_CNTL__CPC5_DSM_IRRITATOR_DATA__SHIFT                                                       0xf
#define CP_CPC_DSM_CNTL__CPC5_ENABLE_SINGLE_WRITE__SHIFT                                                      0x11
#define CP_CPC_DSM_CNTL__CPC6_DSM_IRRITATOR_DATA__SHIFT                                                       0x12
#define CP_CPC_DSM_CNTL__CPC6_ENABLE_SINGLE_WRITE__SHIFT                                                      0x14
#define CP_CPC_DSM_CNTL__CPC7_DSM_IRRITATOR_DATA__SHIFT                                                       0x15
#define CP_CPC_DSM_CNTL__CPC7_ENABLE_SINGLE_WRITE__SHIFT                                                      0x17
#define CP_CPC_DSM_CNTL__CPC8_DSM_IRRITATOR_DATA__SHIFT                                                       0x18
#define CP_CPC_DSM_CNTL__CPC8_ENABLE_SINGLE_WRITE__SHIFT                                                      0x1a
#define CP_CPC_DSM_CNTL__CPC0_DSM_IRRITATOR_DATA_MASK                                                         0x00000003L
#define CP_CPC_DSM_CNTL__CPC0_ENABLE_SINGLE_WRITE_MASK                                                        0x00000004L
#define CP_CPC_DSM_CNTL__CPC1_DSM_IRRITATOR_DATA_MASK                                                         0x00000018L
#define CP_CPC_DSM_CNTL__CPC1_ENABLE_SINGLE_WRITE_MASK                                                        0x00000020L
#define CP_CPC_DSM_CNTL__CPC2_DSM_IRRITATOR_DATA_MASK                                                         0x000000C0L
#define CP_CPC_DSM_CNTL__CPC2_ENABLE_SINGLE_WRITE_MASK                                                        0x00000100L
#define CP_CPC_DSM_CNTL__CPC3_DSM_IRRITATOR_DATA_MASK                                                         0x00000600L
#define CP_CPC_DSM_CNTL__CPC3_ENABLE_SINGLE_WRITE_MASK                                                        0x00000800L
#define CP_CPC_DSM_CNTL__CPC4_DSM_IRRITATOR_DATA_MASK                                                         0x00003000L
#define CP_CPC_DSM_CNTL__CPC4_ENABLE_SINGLE_WRITE_MASK                                                        0x00004000L
#define CP_CPC_DSM_CNTL__CPC5_DSM_IRRITATOR_DATA_MASK                                                         0x00018000L
#define CP_CPC_DSM_CNTL__CPC5_ENABLE_SINGLE_WRITE_MASK                                                        0x00020000L
#define CP_CPC_DSM_CNTL__CPC6_DSM_IRRITATOR_DATA_MASK                                                         0x000C0000L
#define CP_CPC_DSM_CNTL__CPC6_ENABLE_SINGLE_WRITE_MASK                                                        0x00100000L
#define CP_CPC_DSM_CNTL__CPC7_DSM_IRRITATOR_DATA_MASK                                                         0x00600000L
#define CP_CPC_DSM_CNTL__CPC7_ENABLE_SINGLE_WRITE_MASK                                                        0x00800000L
#define CP_CPC_DSM_CNTL__CPC8_DSM_IRRITATOR_DATA_MASK                                                         0x03000000L
#define CP_CPC_DSM_CNTL__CPC8_ENABLE_SINGLE_WRITE_MASK                                                        0x04000000L
//CP_CPF_DSM_CNTL2
#define CP_CPF_DSM_CNTL2__CPF0_ENABLE_ERROR_INJECT__SHIFT                                                     0x0
#define CP_CPF_DSM_CNTL2__CPF0_SELECT_INJECT_DELAY__SHIFT                                                     0x2
#define CP_CPF_DSM_CNTL2__CPF1_ENABLE_ERROR_INJECT__SHIFT                                                     0x3
#define CP_CPF_DSM_CNTL2__CPF1_SELECT_INJECT_DELAY__SHIFT                                                     0x5
#define CP_CPF_DSM_CNTL2__CPF2_ENABLE_ERROR_INJECT__SHIFT                                                     0x6
#define CP_CPF_DSM_CNTL2__CPF2_SELECT_INJECT_DELAY__SHIFT                                                     0x8
#define CP_CPF_DSM_CNTL2__CPF0_ENABLE_ERROR_INJECT_MASK                                                       0x00000003L
#define CP_CPF_DSM_CNTL2__CPF0_SELECT_INJECT_DELAY_MASK                                                       0x00000004L
#define CP_CPF_DSM_CNTL2__CPF1_ENABLE_ERROR_INJECT_MASK                                                       0x00000018L
#define CP_CPF_DSM_CNTL2__CPF1_SELECT_INJECT_DELAY_MASK                                                       0x00000020L
#define CP_CPF_DSM_CNTL2__CPF2_ENABLE_ERROR_INJECT_MASK                                                       0x000000C0L
#define CP_CPF_DSM_CNTL2__CPF2_SELECT_INJECT_DELAY_MASK                                                       0x00000100L
//CP_CPG_DSM_CNTL2
#define CP_CPG_DSM_CNTL2__CPG0_ENABLE_ERROR_INJECT__SHIFT                                                     0x0
#define CP_CPG_DSM_CNTL2__CPG0_SELECT_INJECT_DELAY__SHIFT                                                     0x2
#define CP_CPG_DSM_CNTL2__CPG1_ENABLE_ERROR_INJECT__SHIFT                                                     0x3
#define CP_CPG_DSM_CNTL2__CPG1_SELECT_INJECT_DELAY__SHIFT                                                     0x5
#define CP_CPG_DSM_CNTL2__CPG2_ENABLE_ERROR_INJECT__SHIFT                                                     0x6
#define CP_CPG_DSM_CNTL2__CPG2_SELECT_INJECT_DELAY__SHIFT                                                     0x8
#define CP_CPG_DSM_CNTL2__CPG0_ENABLE_ERROR_INJECT_MASK                                                       0x00000003L
#define CP_CPG_DSM_CNTL2__CPG0_SELECT_INJECT_DELAY_MASK                                                       0x00000004L
#define CP_CPG_DSM_CNTL2__CPG1_ENABLE_ERROR_INJECT_MASK                                                       0x00000018L
#define CP_CPG_DSM_CNTL2__CPG1_SELECT_INJECT_DELAY_MASK                                                       0x00000020L
#define CP_CPG_DSM_CNTL2__CPG2_ENABLE_ERROR_INJECT_MASK                                                       0x000000C0L
#define CP_CPG_DSM_CNTL2__CPG2_SELECT_INJECT_DELAY_MASK                                                       0x00000100L
//CP_CPC_DSM_CNTL2
#define CP_CPC_DSM_CNTL2__CPC0_ENABLE_ERROR_INJECT__SHIFT                                                     0x0
#define CP_CPC_DSM_CNTL2__CPC0_SELECT_INJECT_DELAY__SHIFT                                                     0x2
#define CP_CPC_DSM_CNTL2__CPC1_ENABLE_ERROR_INJECT__SHIFT                                                     0x3
#define CP_CPC_DSM_CNTL2__CPC1_SELECT_INJECT_DELAY__SHIFT                                                     0x5
#define CP_CPC_DSM_CNTL2__CPC2_ENABLE_ERROR_INJECT__SHIFT                                                     0x6
#define CP_CPC_DSM_CNTL2__CPC2_SELECT_INJECT_DELAY__SHIFT                                                     0x8
#define CP_CPC_DSM_CNTL2__CPC3_ENABLE_ERROR_INJECT__SHIFT                                                     0x9
#define CP_CPC_DSM_CNTL2__CPC3_SELECT_INJECT_DELAY__SHIFT                                                     0xb
#define CP_CPC_DSM_CNTL2__CPC4_ENABLE_ERROR_INJECT__SHIFT                                                     0xc
#define CP_CPC_DSM_CNTL2__CPC4_SELECT_INJECT_DELAY__SHIFT                                                     0xe
#define CP_CPC_DSM_CNTL2__CPC5_ENABLE_ERROR_INJECT__SHIFT                                                     0xf
#define CP_CPC_DSM_CNTL2__CPC5_SELECT_INJECT_DELAY__SHIFT                                                     0x11
#define CP_CPC_DSM_CNTL2__CPC6_ENABLE_ERROR_INJECT__SHIFT                                                     0x12
#define CP_CPC_DSM_CNTL2__CPC6_SELECT_INJECT_DELAY__SHIFT                                                     0x14
#define CP_CPC_DSM_CNTL2__CPC7_ENABLE_ERROR_INJECT__SHIFT                                                     0x15
#define CP_CPC_DSM_CNTL2__CPC7_SELECT_INJECT_DELAY__SHIFT                                                     0x17
#define CP_CPC_DSM_CNTL2__CPC8_ENABLE_ERROR_INJECT__SHIFT                                                     0x18
#define CP_CPC_DSM_CNTL2__CPC8_SELECT_INJECT_DELAY__SHIFT                                                     0x1a
#define CP_CPC_DSM_CNTL2__CPC0_ENABLE_ERROR_INJECT_MASK                                                       0x00000003L
#define CP_CPC_DSM_CNTL2__CPC0_SELECT_INJECT_DELAY_MASK                                                       0x00000004L
#define CP_CPC_DSM_CNTL2__CPC1_ENABLE_ERROR_INJECT_MASK                                                       0x00000018L
#define CP_CPC_DSM_CNTL2__CPC1_SELECT_INJECT_DELAY_MASK                                                       0x00000020L
#define CP_CPC_DSM_CNTL2__CPC2_ENABLE_ERROR_INJECT_MASK                                                       0x000000C0L
#define CP_CPC_DSM_CNTL2__CPC2_SELECT_INJECT_DELAY_MASK                                                       0x00000100L
#define CP_CPC_DSM_CNTL2__CPC3_ENABLE_ERROR_INJECT_MASK                                                       0x00000600L
#define CP_CPC_DSM_CNTL2__CPC3_SELECT_INJECT_DELAY_MASK                                                       0x00000800L
#define CP_CPC_DSM_CNTL2__CPC4_ENABLE_ERROR_INJECT_MASK                                                       0x00003000L
#define CP_CPC_DSM_CNTL2__CPC4_SELECT_INJECT_DELAY_MASK                                                       0x00004000L
#define CP_CPC_DSM_CNTL2__CPC5_ENABLE_ERROR_INJECT_MASK                                                       0x00018000L
#define CP_CPC_DSM_CNTL2__CPC5_SELECT_INJECT_DELAY_MASK                                                       0x00020000L
#define CP_CPC_DSM_CNTL2__CPC6_ENABLE_ERROR_INJECT_MASK                                                       0x000C0000L
#define CP_CPC_DSM_CNTL2__CPC6_SELECT_INJECT_DELAY_MASK                                                       0x00100000L
#define CP_CPC_DSM_CNTL2__CPC7_ENABLE_ERROR_INJECT_MASK                                                       0x00600000L
#define CP_CPC_DSM_CNTL2__CPC7_SELECT_INJECT_DELAY_MASK                                                       0x00800000L
#define CP_CPC_DSM_CNTL2__CPC8_ENABLE_ERROR_INJECT_MASK                                                       0x03000000L
#define CP_CPC_DSM_CNTL2__CPC8_SELECT_INJECT_DELAY_MASK                                                       0x04000000L
//CP_CPF_DSM_CNTL2A
#define CP_CPF_DSM_CNTL2A__CPF_INJECT_DELAY__SHIFT                                                            0x0
#define CP_CPF_DSM_CNTL2A__CPF_INJECT_DELAY_MASK                                                              0x0000003FL
//CP_CPG_DSM_CNTL2A
#define CP_CPG_DSM_CNTL2A__CPG_INJECT_DELAY__SHIFT                                                            0x0
#define CP_CPG_DSM_CNTL2A__CPG_INJECT_DELAY_MASK                                                              0x0000003FL
//CP_CPC_DSM_CNTL2A
#define CP_CPC_DSM_CNTL2A__CPC_INJECT_DELAY__SHIFT                                                            0x0
#define CP_CPC_DSM_CNTL2A__CPC_INJECT_DELAY_MASK                                                              0x0000003FL
//CP_EDC_FUE_CNTL
#define CP_EDC_FUE_CNTL__CP_FUE_MASK__SHIFT                                                                   0x0
#define CP_EDC_FUE_CNTL__SPI_FUE_MASK__SHIFT                                                                  0x1
#define CP_EDC_FUE_CNTL__GDS_FUE_MASK__SHIFT                                                                  0x2
#define CP_EDC_FUE_CNTL__TC_RLC_FUE_MASK__SHIFT                                                               0x3
#define CP_EDC_FUE_CNTL__TC_CPG_FUE_MASK__SHIFT                                                               0x4
#define CP_EDC_FUE_CNTL__TCA_FUE_MASK__SHIFT                                                                  0x5
#define CP_EDC_FUE_CNTL__TCC_FUE_MASK__SHIFT                                                                  0x6
#define CP_EDC_FUE_CNTL__UTCL2_FUE_MASK__SHIFT                                                                0x7
#define CP_EDC_FUE_CNTL__CP_FUE_FLAG__SHIFT                                                                   0x10
#define CP_EDC_FUE_CNTL__SPI_FUE_FLAG__SHIFT                                                                  0x11
#define CP_EDC_FUE_CNTL__GDS_FUE_FLAG__SHIFT                                                                  0x12
#define CP_EDC_FUE_CNTL__TC_RLC_FUE_FLAG__SHIFT                                                               0x13
#define CP_EDC_FUE_CNTL__TC_CPG_FUE_FLAG__SHIFT                                                               0x14
#define CP_EDC_FUE_CNTL__TCA_FUE_FLAG__SHIFT                                                                  0x15
#define CP_EDC_FUE_CNTL__TCC_FUE_FLAG__SHIFT                                                                  0x16
#define CP_EDC_FUE_CNTL__UTCL2_FUE_FLAG__SHIFT                                                                0x17
#define CP_EDC_FUE_CNTL__CP_FUE_MASK_MASK                                                                     0x00000001L
#define CP_EDC_FUE_CNTL__SPI_FUE_MASK_MASK                                                                    0x00000002L
#define CP_EDC_FUE_CNTL__GDS_FUE_MASK_MASK                                                                    0x00000004L
#define CP_EDC_FUE_CNTL__TC_RLC_FUE_MASK_MASK                                                                 0x00000008L
#define CP_EDC_FUE_CNTL__TC_CPG_FUE_MASK_MASK                                                                 0x00000010L
#define CP_EDC_FUE_CNTL__TCA_FUE_MASK_MASK                                                                    0x00000020L
#define CP_EDC_FUE_CNTL__TCC_FUE_MASK_MASK                                                                    0x00000040L
#define CP_EDC_FUE_CNTL__UTCL2_FUE_MASK_MASK                                                                  0x00000080L
#define CP_EDC_FUE_CNTL__CP_FUE_FLAG_MASK                                                                     0x00010000L
#define CP_EDC_FUE_CNTL__SPI_FUE_FLAG_MASK                                                                    0x00020000L
#define CP_EDC_FUE_CNTL__GDS_FUE_FLAG_MASK                                                                    0x00040000L
#define CP_EDC_FUE_CNTL__TC_RLC_FUE_FLAG_MASK                                                                 0x00080000L
#define CP_EDC_FUE_CNTL__TC_CPG_FUE_FLAG_MASK                                                                 0x00100000L
#define CP_EDC_FUE_CNTL__TCA_FUE_FLAG_MASK                                                                    0x00200000L
#define CP_EDC_FUE_CNTL__TCC_FUE_FLAG_MASK                                                                    0x00400000L
#define CP_EDC_FUE_CNTL__UTCL2_FUE_FLAG_MASK                                                                  0x00800000L
//CP_GFX_MQD_CONTROL
#define CP_GFX_MQD_CONTROL__VMID__SHIFT                                                                       0x0
#define CP_GFX_MQD_CONTROL__PRIV_STATE__SHIFT                                                                 0x8
#define CP_GFX_MQD_CONTROL__EXE_DISABLE__SHIFT                                                                0x17
#define CP_GFX_MQD_CONTROL__CACHE_POLICY__SHIFT                                                               0x18
#define CP_GFX_MQD_CONTROL__VMID_MASK                                                                         0x0000000FL
#define CP_GFX_MQD_CONTROL__PRIV_STATE_MASK                                                                   0x00000100L
#define CP_GFX_MQD_CONTROL__EXE_DISABLE_MASK                                                                  0x00800000L
#define CP_GFX_MQD_CONTROL__CACHE_POLICY_MASK                                                                 0x01000000L
//CP_GFX_MQD_BASE_ADDR
#define CP_GFX_MQD_BASE_ADDR__BASE_ADDR__SHIFT                                                                0x2
#define CP_GFX_MQD_BASE_ADDR__BASE_ADDR_MASK                                                                  0xFFFFFFFCL
//CP_GFX_MQD_BASE_ADDR_HI
#define CP_GFX_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                          0x0
#define CP_GFX_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                            0x0000FFFFL
//CP_RB_STATUS
#define CP_RB_STATUS__DOORBELL_UPDATED__SHIFT                                                                 0x0
#define CP_RB_STATUS__DOORBELL_ENABLE__SHIFT                                                                  0x1
#define CP_RB_STATUS__DOORBELL_UPDATED_MASK                                                                   0x00000001L
#define CP_RB_STATUS__DOORBELL_ENABLE_MASK                                                                    0x00000002L
//CPG_UTCL1_STATUS
#define CPG_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                               0x0
#define CPG_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                               0x1
#define CPG_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                 0x2
#define CPG_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                0x8
#define CPG_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                0x10
#define CPG_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                  0x18
#define CPG_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                 0x00000001L
#define CPG_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                 0x00000002L
#define CPG_UTCL1_STATUS__PRT_DETECTED_MASK                                                                   0x00000004L
#define CPG_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                  0x00003F00L
#define CPG_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                  0x003F0000L
#define CPG_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                    0x3F000000L
//CPC_UTCL1_STATUS
#define CPC_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                               0x0
#define CPC_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                               0x1
#define CPC_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                 0x2
#define CPC_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                0x8
#define CPC_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                0x10
#define CPC_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                  0x18
#define CPC_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                 0x00000001L
#define CPC_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                 0x00000002L
#define CPC_UTCL1_STATUS__PRT_DETECTED_MASK                                                                   0x00000004L
#define CPC_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                  0x00003F00L
#define CPC_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                  0x003F0000L
#define CPC_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                    0x3F000000L
//CPF_UTCL1_STATUS
#define CPF_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                               0x0
#define CPF_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                               0x1
#define CPF_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                 0x2
#define CPF_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                0x8
#define CPF_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                0x10
#define CPF_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                  0x18
#define CPF_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                 0x00000001L
#define CPF_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                 0x00000002L
#define CPF_UTCL1_STATUS__PRT_DETECTED_MASK                                                                   0x00000004L
#define CPF_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                  0x00003F00L
#define CPF_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                  0x003F0000L
#define CPF_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                    0x3F000000L
//CP_SD_CNTL
#define CP_SD_CNTL__CPF_EN__SHIFT                                                                             0x0
#define CP_SD_CNTL__CPG_EN__SHIFT                                                                             0x1
#define CP_SD_CNTL__CPC_EN__SHIFT                                                                             0x2
#define CP_SD_CNTL__RLC_EN__SHIFT                                                                             0x3
#define CP_SD_CNTL__SPI_EN__SHIFT                                                                             0x4
#define CP_SD_CNTL__WD_EN__SHIFT                                                                              0x5
#define CP_SD_CNTL__IA_EN__SHIFT                                                                              0x6
#define CP_SD_CNTL__PA_EN__SHIFT                                                                              0x7
#define CP_SD_CNTL__RMI_EN__SHIFT                                                                             0x8
#define CP_SD_CNTL__EA_EN__SHIFT                                                                              0x9
#define CP_SD_CNTL__CPF_EN_MASK                                                                               0x00000001L
#define CP_SD_CNTL__CPG_EN_MASK                                                                               0x00000002L
#define CP_SD_CNTL__CPC_EN_MASK                                                                               0x00000004L
#define CP_SD_CNTL__RLC_EN_MASK                                                                               0x00000008L
#define CP_SD_CNTL__SPI_EN_MASK                                                                               0x00000010L
#define CP_SD_CNTL__WD_EN_MASK                                                                                0x00000020L
#define CP_SD_CNTL__IA_EN_MASK                                                                                0x00000040L
#define CP_SD_CNTL__PA_EN_MASK                                                                                0x00000080L
#define CP_SD_CNTL__RMI_EN_MASK                                                                               0x00000100L
#define CP_SD_CNTL__EA_EN_MASK                                                                                0x00000200L
//CP_SOFT_RESET_CNTL
#define CP_SOFT_RESET_CNTL__CMP_ONLY_SOFT_RESET__SHIFT                                                        0x0
#define CP_SOFT_RESET_CNTL__GFX_ONLY_SOFT_RESET__SHIFT                                                        0x1
#define CP_SOFT_RESET_CNTL__CMP_HQD_REG_RESET__SHIFT                                                          0x2
#define CP_SOFT_RESET_CNTL__CMP_INTR_REG_RESET__SHIFT                                                         0x3
#define CP_SOFT_RESET_CNTL__CMP_HQD_QUEUE_DOORBELL_RESET__SHIFT                                               0x4
#define CP_SOFT_RESET_CNTL__GFX_RB_DOORBELL_RESET__SHIFT                                                      0x5
#define CP_SOFT_RESET_CNTL__GFX_INTR_REG_RESET__SHIFT                                                         0x6
#define CP_SOFT_RESET_CNTL__CMP_ONLY_SOFT_RESET_MASK                                                          0x00000001L
#define CP_SOFT_RESET_CNTL__GFX_ONLY_SOFT_RESET_MASK                                                          0x00000002L
#define CP_SOFT_RESET_CNTL__CMP_HQD_REG_RESET_MASK                                                            0x00000004L
#define CP_SOFT_RESET_CNTL__CMP_INTR_REG_RESET_MASK                                                           0x00000008L
#define CP_SOFT_RESET_CNTL__CMP_HQD_QUEUE_DOORBELL_RESET_MASK                                                 0x00000010L
#define CP_SOFT_RESET_CNTL__GFX_RB_DOORBELL_RESET_MASK                                                        0x00000020L
#define CP_SOFT_RESET_CNTL__GFX_INTR_REG_RESET_MASK                                                           0x00000040L
//CP_CPC_GFX_CNTL
#define CP_CPC_GFX_CNTL__QUEUEID__SHIFT                                                                       0x0
#define CP_CPC_GFX_CNTL__PIPEID__SHIFT                                                                        0x3
#define CP_CPC_GFX_CNTL__MEID__SHIFT                                                                          0x5
#define CP_CPC_GFX_CNTL__VALID__SHIFT                                                                         0x7
#define CP_CPC_GFX_CNTL__QUEUEID_MASK                                                                         0x00000007L
#define CP_CPC_GFX_CNTL__PIPEID_MASK                                                                          0x00000018L
#define CP_CPC_GFX_CNTL__MEID_MASK                                                                            0x00000060L
#define CP_CPC_GFX_CNTL__VALID_MASK                                                                           0x00000080L


// addressBlock: gc_cpphqddec
//CP_HQD_GFX_CONTROL
#define CP_HQD_GFX_CONTROL__MESSAGE__SHIFT                                                                    0x0
#define CP_HQD_GFX_CONTROL__MISC__SHIFT                                                                       0x4
#define CP_HQD_GFX_CONTROL__DB_UPDATED_MSG_EN__SHIFT                                                          0xf
#define CP_HQD_GFX_CONTROL__MESSAGE_MASK                                                                      0x0000000FL
#define CP_HQD_GFX_CONTROL__MISC_MASK                                                                         0x00007FF0L
#define CP_HQD_GFX_CONTROL__DB_UPDATED_MSG_EN_MASK                                                            0x00008000L
//CP_HQD_GFX_STATUS
#define CP_HQD_GFX_STATUS__STATUS__SHIFT                                                                      0x0
#define CP_HQD_GFX_STATUS__STATUS_MASK                                                                        0x0000FFFFL
//CP_HPD_ROQ_OFFSETS
#define CP_HPD_ROQ_OFFSETS__IQ_OFFSET__SHIFT                                                                  0x0
#define CP_HPD_ROQ_OFFSETS__PQ_OFFSET__SHIFT                                                                  0x8
#define CP_HPD_ROQ_OFFSETS__IB_OFFSET__SHIFT                                                                  0x10
#define CP_HPD_ROQ_OFFSETS__IQ_OFFSET_MASK                                                                    0x00000007L
#define CP_HPD_ROQ_OFFSETS__PQ_OFFSET_MASK                                                                    0x00003F00L
#define CP_HPD_ROQ_OFFSETS__IB_OFFSET_MASK                                                                    0x003F0000L
//CP_HPD_STATUS0
#define CP_HPD_STATUS0__QUEUE_STATE__SHIFT                                                                    0x0
#define CP_HPD_STATUS0__MAPPED_QUEUE__SHIFT                                                                   0x5
#define CP_HPD_STATUS0__QUEUE_AVAILABLE__SHIFT                                                                0x8
#define CP_HPD_STATUS0__FETCHING_MQD__SHIFT                                                                   0x10
#define CP_HPD_STATUS0__PEND_TXFER_SIZE_PQIB__SHIFT                                                           0x11
#define CP_HPD_STATUS0__PEND_TXFER_SIZE_IQ__SHIFT                                                             0x12
#define CP_HPD_STATUS0__FORCE_QUEUE_STATE__SHIFT                                                              0x14
#define CP_HPD_STATUS0__FORCE_QUEUE__SHIFT                                                                    0x1f
#define CP_HPD_STATUS0__QUEUE_STATE_MASK                                                                      0x0000001FL
#define CP_HPD_STATUS0__MAPPED_QUEUE_MASK                                                                     0x000000E0L
#define CP_HPD_STATUS0__QUEUE_AVAILABLE_MASK                                                                  0x0000FF00L
#define CP_HPD_STATUS0__FETCHING_MQD_MASK                                                                     0x00010000L
#define CP_HPD_STATUS0__PEND_TXFER_SIZE_PQIB_MASK                                                             0x00020000L
#define CP_HPD_STATUS0__PEND_TXFER_SIZE_IQ_MASK                                                               0x00040000L
#define CP_HPD_STATUS0__FORCE_QUEUE_STATE_MASK                                                                0x01F00000L
#define CP_HPD_STATUS0__FORCE_QUEUE_MASK                                                                      0x80000000L
//CP_HPD_UTCL1_CNTL
#define CP_HPD_UTCL1_CNTL__SELECT__SHIFT                                                                      0x0
#define CP_HPD_UTCL1_CNTL__SELECT_MASK                                                                        0x0000000FL
//CP_HPD_UTCL1_ERROR
#define CP_HPD_UTCL1_ERROR__ADDR_HI__SHIFT                                                                    0x0
#define CP_HPD_UTCL1_ERROR__TYPE__SHIFT                                                                       0x10
#define CP_HPD_UTCL1_ERROR__VMID__SHIFT                                                                       0x14
#define CP_HPD_UTCL1_ERROR__ADDR_HI_MASK                                                                      0x0000FFFFL
#define CP_HPD_UTCL1_ERROR__TYPE_MASK                                                                         0x00010000L
#define CP_HPD_UTCL1_ERROR__VMID_MASK                                                                         0x00F00000L
//CP_HPD_UTCL1_ERROR_ADDR
#define CP_HPD_UTCL1_ERROR_ADDR__ADDR__SHIFT                                                                  0xc
#define CP_HPD_UTCL1_ERROR_ADDR__ADDR_MASK                                                                    0xFFFFF000L
//CP_MQD_BASE_ADDR
#define CP_MQD_BASE_ADDR__BASE_ADDR__SHIFT                                                                    0x2
#define CP_MQD_BASE_ADDR__BASE_ADDR_MASK                                                                      0xFFFFFFFCL
//CP_MQD_BASE_ADDR_HI
#define CP_MQD_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                              0x0
#define CP_MQD_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                                0x0000FFFFL
//CP_HQD_ACTIVE
#define CP_HQD_ACTIVE__ACTIVE__SHIFT                                                                          0x0
#define CP_HQD_ACTIVE__BUSY_GATE__SHIFT                                                                       0x1
#define CP_HQD_ACTIVE__ACTIVE_MASK                                                                            0x00000001L
#define CP_HQD_ACTIVE__BUSY_GATE_MASK                                                                         0x00000002L
//CP_HQD_VMID
#define CP_HQD_VMID__VMID__SHIFT                                                                              0x0
#define CP_HQD_VMID__IB_VMID__SHIFT                                                                           0x8
#define CP_HQD_VMID__VQID__SHIFT                                                                              0x10
#define CP_HQD_VMID__VMID_MASK                                                                                0x0000000FL
#define CP_HQD_VMID__IB_VMID_MASK                                                                             0x00000F00L
#define CP_HQD_VMID__VQID_MASK                                                                                0x03FF0000L
//CP_HQD_PERSISTENT_STATE
#define CP_HQD_PERSISTENT_STATE__PRELOAD_REQ__SHIFT                                                           0x0
#define CP_HQD_PERSISTENT_STATE__PRELOAD_SIZE__SHIFT                                                          0x8
#define CP_HQD_PERSISTENT_STATE__WPP_SWITCH_QOS_EN__SHIFT                                                     0x15
#define CP_HQD_PERSISTENT_STATE__IQ_SWITCH_QOS_EN__SHIFT                                                      0x16
#define CP_HQD_PERSISTENT_STATE__IB_SWITCH_QOS_EN__SHIFT                                                      0x17
#define CP_HQD_PERSISTENT_STATE__EOP_SWITCH_QOS_EN__SHIFT                                                     0x18
#define CP_HQD_PERSISTENT_STATE__PQ_SWITCH_QOS_EN__SHIFT                                                      0x19
#define CP_HQD_PERSISTENT_STATE__TC_OFFLOAD_QOS_EN__SHIFT                                                     0x1a
#define CP_HQD_PERSISTENT_STATE__CACHE_FULL_PACKET_EN__SHIFT                                                  0x1b
#define CP_HQD_PERSISTENT_STATE__RESTORE_ACTIVE__SHIFT                                                        0x1c
#define CP_HQD_PERSISTENT_STATE__RELAUNCH_WAVES__SHIFT                                                        0x1d
#define CP_HQD_PERSISTENT_STATE__QSWITCH_MODE__SHIFT                                                          0x1e
#define CP_HQD_PERSISTENT_STATE__DISP_ACTIVE__SHIFT                                                           0x1f
#define CP_HQD_PERSISTENT_STATE__PRELOAD_REQ_MASK                                                             0x00000001L
#define CP_HQD_PERSISTENT_STATE__PRELOAD_SIZE_MASK                                                            0x0003FF00L
#define CP_HQD_PERSISTENT_STATE__WPP_SWITCH_QOS_EN_MASK                                                       0x00200000L
#define CP_HQD_PERSISTENT_STATE__IQ_SWITCH_QOS_EN_MASK                                                        0x00400000L
#define CP_HQD_PERSISTENT_STATE__IB_SWITCH_QOS_EN_MASK                                                        0x00800000L
#define CP_HQD_PERSISTENT_STATE__EOP_SWITCH_QOS_EN_MASK                                                       0x01000000L
#define CP_HQD_PERSISTENT_STATE__PQ_SWITCH_QOS_EN_MASK                                                        0x02000000L
#define CP_HQD_PERSISTENT_STATE__TC_OFFLOAD_QOS_EN_MASK                                                       0x04000000L
#define CP_HQD_PERSISTENT_STATE__CACHE_FULL_PACKET_EN_MASK                                                    0x08000000L
#define CP_HQD_PERSISTENT_STATE__RESTORE_ACTIVE_MASK                                                          0x10000000L
#define CP_HQD_PERSISTENT_STATE__RELAUNCH_WAVES_MASK                                                          0x20000000L
#define CP_HQD_PERSISTENT_STATE__QSWITCH_MODE_MASK                                                            0x40000000L
#define CP_HQD_PERSISTENT_STATE__DISP_ACTIVE_MASK                                                             0x80000000L
//CP_HQD_PIPE_PRIORITY
#define CP_HQD_PIPE_PRIORITY__PIPE_PRIORITY__SHIFT                                                            0x0
#define CP_HQD_PIPE_PRIORITY__PIPE_PRIORITY_MASK                                                              0x00000003L
//CP_HQD_QUEUE_PRIORITY
#define CP_HQD_QUEUE_PRIORITY__PRIORITY_LEVEL__SHIFT                                                          0x0
#define CP_HQD_QUEUE_PRIORITY__PRIORITY_LEVEL_MASK                                                            0x0000000FL
//CP_HQD_QUANTUM
#define CP_HQD_QUANTUM__QUANTUM_EN__SHIFT                                                                     0x0
#define CP_HQD_QUANTUM__QUANTUM_SCALE__SHIFT                                                                  0x4
#define CP_HQD_QUANTUM__QUANTUM_DURATION__SHIFT                                                               0x8
#define CP_HQD_QUANTUM__QUANTUM_ACTIVE__SHIFT                                                                 0x1f
#define CP_HQD_QUANTUM__QUANTUM_EN_MASK                                                                       0x00000001L
#define CP_HQD_QUANTUM__QUANTUM_SCALE_MASK                                                                    0x00000010L
#define CP_HQD_QUANTUM__QUANTUM_DURATION_MASK                                                                 0x00003F00L
#define CP_HQD_QUANTUM__QUANTUM_ACTIVE_MASK                                                                   0x80000000L
//CP_HQD_PQ_BASE
#define CP_HQD_PQ_BASE__ADDR__SHIFT                                                                           0x0
#define CP_HQD_PQ_BASE__ADDR_MASK                                                                             0xFFFFFFFFL
//CP_HQD_PQ_BASE_HI
#define CP_HQD_PQ_BASE_HI__ADDR_HI__SHIFT                                                                     0x0
#define CP_HQD_PQ_BASE_HI__ADDR_HI_MASK                                                                       0x000000FFL
//CP_HQD_PQ_RPTR
#define CP_HQD_PQ_RPTR__CONSUMED_OFFSET__SHIFT                                                                0x0
#define CP_HQD_PQ_RPTR__CONSUMED_OFFSET_MASK                                                                  0xFFFFFFFFL
//CP_HQD_PQ_RPTR_REPORT_ADDR
#define CP_HQD_PQ_RPTR_REPORT_ADDR__RPTR_REPORT_ADDR__SHIFT                                                   0x2
#define CP_HQD_PQ_RPTR_REPORT_ADDR__RPTR_REPORT_ADDR_MASK                                                     0xFFFFFFFCL
//CP_HQD_PQ_RPTR_REPORT_ADDR_HI
#define CP_HQD_PQ_RPTR_REPORT_ADDR_HI__RPTR_REPORT_ADDR_HI__SHIFT                                             0x0
#define CP_HQD_PQ_RPTR_REPORT_ADDR_HI__RPTR_REPORT_ADDR_HI_MASK                                               0x0000FFFFL
//CP_HQD_PQ_WPTR_POLL_ADDR
#define CP_HQD_PQ_WPTR_POLL_ADDR__WPTR_ADDR__SHIFT                                                            0x3
#define CP_HQD_PQ_WPTR_POLL_ADDR__WPTR_ADDR_MASK                                                              0xFFFFFFF8L
//CP_HQD_PQ_WPTR_POLL_ADDR_HI
#define CP_HQD_PQ_WPTR_POLL_ADDR_HI__WPTR_ADDR_HI__SHIFT                                                      0x0
#define CP_HQD_PQ_WPTR_POLL_ADDR_HI__WPTR_ADDR_HI_MASK                                                        0x0000FFFFL
//CP_HQD_PQ_DOORBELL_CONTROL
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_MODE__SHIFT                                                      0x0
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_BIF_DROP__SHIFT                                                  0x1
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_OFFSET__SHIFT                                                    0x2
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_SOURCE__SHIFT                                                    0x1c
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_SCHD_HIT__SHIFT                                                  0x1d
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_EN__SHIFT                                                        0x1e
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_HIT__SHIFT                                                       0x1f
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_MODE_MASK                                                        0x00000001L
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_BIF_DROP_MASK                                                    0x00000002L
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_OFFSET_MASK                                                      0x0FFFFFFCL
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_SOURCE_MASK                                                      0x10000000L
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_SCHD_HIT_MASK                                                    0x20000000L
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_EN_MASK                                                          0x40000000L
#define CP_HQD_PQ_DOORBELL_CONTROL__DOORBELL_HIT_MASK                                                         0x80000000L
//CP_HQD_PQ_CONTROL
#define CP_HQD_PQ_CONTROL__QUEUE_SIZE__SHIFT                                                                  0x0
#define CP_HQD_PQ_CONTROL__WPTR_CARRY__SHIFT                                                                  0x6
#define CP_HQD_PQ_CONTROL__RPTR_CARRY__SHIFT                                                                  0x7
#define CP_HQD_PQ_CONTROL__RPTR_BLOCK_SIZE__SHIFT                                                             0x8
#define CP_HQD_PQ_CONTROL__QUEUE_FULL_EN__SHIFT                                                               0xe
#define CP_HQD_PQ_CONTROL__PQ_EMPTY__SHIFT                                                                    0xf
#define CP_HQD_PQ_CONTROL__WPP_CLAMP_EN__SHIFT                                                                0x10
#define CP_HQD_PQ_CONTROL__ENDIAN_SWAP__SHIFT                                                                 0x11
#define CP_HQD_PQ_CONTROL__MIN_AVAIL_SIZE__SHIFT                                                              0x14
#define CP_HQD_PQ_CONTROL__TMZ__SHIFT                                                                         0x16
#define CP_HQD_PQ_CONTROL__EXE_DISABLE__SHIFT                                                                 0x17
#define CP_HQD_PQ_CONTROL__CACHE_POLICY__SHIFT                                                                0x18
#define CP_HQD_PQ_CONTROL__SLOT_BASED_WPTR__SHIFT                                                             0x19
#define CP_HQD_PQ_CONTROL__NO_UPDATE_RPTR__SHIFT                                                              0x1b
#define CP_HQD_PQ_CONTROL__UNORD_DISPATCH__SHIFT                                                              0x1c
#define CP_HQD_PQ_CONTROL__ROQ_PQ_IB_FLIP__SHIFT                                                              0x1d
#define CP_HQD_PQ_CONTROL__PRIV_STATE__SHIFT                                                                  0x1e
#define CP_HQD_PQ_CONTROL__KMD_QUEUE__SHIFT                                                                   0x1f
#define CP_HQD_PQ_CONTROL__QUEUE_SIZE_MASK                                                                    0x0000003FL
#define CP_HQD_PQ_CONTROL__WPTR_CARRY_MASK                                                                    0x00000040L
#define CP_HQD_PQ_CONTROL__RPTR_CARRY_MASK                                                                    0x00000080L
#define CP_HQD_PQ_CONTROL__RPTR_BLOCK_SIZE_MASK                                                               0x00003F00L
#define CP_HQD_PQ_CONTROL__QUEUE_FULL_EN_MASK                                                                 0x00004000L
#define CP_HQD_PQ_CONTROL__PQ_EMPTY_MASK                                                                      0x00008000L
#define CP_HQD_PQ_CONTROL__WPP_CLAMP_EN_MASK                                                                  0x00010000L
#define CP_HQD_PQ_CONTROL__ENDIAN_SWAP_MASK                                                                   0x00060000L
#define CP_HQD_PQ_CONTROL__MIN_AVAIL_SIZE_MASK                                                                0x00300000L
#define CP_HQD_PQ_CONTROL__TMZ_MASK                                                                           0x00400000L
#define CP_HQD_PQ_CONTROL__EXE_DISABLE_MASK                                                                   0x00800000L
#define CP_HQD_PQ_CONTROL__CACHE_POLICY_MASK                                                                  0x01000000L
#define CP_HQD_PQ_CONTROL__SLOT_BASED_WPTR_MASK                                                               0x06000000L
#define CP_HQD_PQ_CONTROL__NO_UPDATE_RPTR_MASK                                                                0x08000000L
#define CP_HQD_PQ_CONTROL__UNORD_DISPATCH_MASK                                                                0x10000000L
#define CP_HQD_PQ_CONTROL__ROQ_PQ_IB_FLIP_MASK                                                                0x20000000L
#define CP_HQD_PQ_CONTROL__PRIV_STATE_MASK                                                                    0x40000000L
#define CP_HQD_PQ_CONTROL__KMD_QUEUE_MASK                                                                     0x80000000L
//CP_HQD_IB_BASE_ADDR
#define CP_HQD_IB_BASE_ADDR__IB_BASE_ADDR__SHIFT                                                              0x2
#define CP_HQD_IB_BASE_ADDR__IB_BASE_ADDR_MASK                                                                0xFFFFFFFCL
//CP_HQD_IB_BASE_ADDR_HI
#define CP_HQD_IB_BASE_ADDR_HI__IB_BASE_ADDR_HI__SHIFT                                                        0x0
#define CP_HQD_IB_BASE_ADDR_HI__IB_BASE_ADDR_HI_MASK                                                          0x0000FFFFL
//CP_HQD_IB_RPTR
#define CP_HQD_IB_RPTR__CONSUMED_OFFSET__SHIFT                                                                0x0
#define CP_HQD_IB_RPTR__CONSUMED_OFFSET_MASK                                                                  0x000FFFFFL
//CP_HQD_IB_CONTROL
#define CP_HQD_IB_CONTROL__IB_SIZE__SHIFT                                                                     0x0
#define CP_HQD_IB_CONTROL__MIN_IB_AVAIL_SIZE__SHIFT                                                           0x14
#define CP_HQD_IB_CONTROL__IB_EXE_DISABLE__SHIFT                                                              0x17
#define CP_HQD_IB_CONTROL__IB_CACHE_POLICY__SHIFT                                                             0x18
#define CP_HQD_IB_CONTROL__PROCESSING_IB__SHIFT                                                               0x1f
#define CP_HQD_IB_CONTROL__IB_SIZE_MASK                                                                       0x000FFFFFL
#define CP_HQD_IB_CONTROL__MIN_IB_AVAIL_SIZE_MASK                                                             0x00300000L
#define CP_HQD_IB_CONTROL__IB_EXE_DISABLE_MASK                                                                0x00800000L
#define CP_HQD_IB_CONTROL__IB_CACHE_POLICY_MASK                                                               0x01000000L
#define CP_HQD_IB_CONTROL__PROCESSING_IB_MASK                                                                 0x80000000L
//CP_HQD_IQ_TIMER
#define CP_HQD_IQ_TIMER__WAIT_TIME__SHIFT                                                                     0x0
#define CP_HQD_IQ_TIMER__RETRY_TYPE__SHIFT                                                                    0x8
#define CP_HQD_IQ_TIMER__IMMEDIATE_EXPIRE__SHIFT                                                              0xb
#define CP_HQD_IQ_TIMER__INTERRUPT_TYPE__SHIFT                                                                0xc
#define CP_HQD_IQ_TIMER__CLOCK_COUNT__SHIFT                                                                   0xe
#define CP_HQD_IQ_TIMER__INTERRUPT_SIZE__SHIFT                                                                0x10
#define CP_HQD_IQ_TIMER__QUANTUM_TIMER__SHIFT                                                                 0x16
#define CP_HQD_IQ_TIMER__EXE_DISABLE__SHIFT                                                                   0x17
#define CP_HQD_IQ_TIMER__CACHE_POLICY__SHIFT                                                                  0x18
#define CP_HQD_IQ_TIMER__QUEUE_TYPE__SHIFT                                                                    0x19
#define CP_HQD_IQ_TIMER__REARM_TIMER__SHIFT                                                                   0x1c
#define CP_HQD_IQ_TIMER__PROCESS_IQ_EN__SHIFT                                                                 0x1d
#define CP_HQD_IQ_TIMER__PROCESSING_IQ__SHIFT                                                                 0x1e
#define CP_HQD_IQ_TIMER__ACTIVE__SHIFT                                                                        0x1f
#define CP_HQD_IQ_TIMER__WAIT_TIME_MASK                                                                       0x000000FFL
#define CP_HQD_IQ_TIMER__RETRY_TYPE_MASK                                                                      0x00000700L
#define CP_HQD_IQ_TIMER__IMMEDIATE_EXPIRE_MASK                                                                0x00000800L
#define CP_HQD_IQ_TIMER__INTERRUPT_TYPE_MASK                                                                  0x00003000L
#define CP_HQD_IQ_TIMER__CLOCK_COUNT_MASK                                                                     0x0000C000L
#define CP_HQD_IQ_TIMER__INTERRUPT_SIZE_MASK                                                                  0x003F0000L
#define CP_HQD_IQ_TIMER__QUANTUM_TIMER_MASK                                                                   0x00400000L
#define CP_HQD_IQ_TIMER__EXE_DISABLE_MASK                                                                     0x00800000L
#define CP_HQD_IQ_TIMER__CACHE_POLICY_MASK                                                                    0x01000000L
#define CP_HQD_IQ_TIMER__QUEUE_TYPE_MASK                                                                      0x02000000L
#define CP_HQD_IQ_TIMER__REARM_TIMER_MASK                                                                     0x10000000L
#define CP_HQD_IQ_TIMER__PROCESS_IQ_EN_MASK                                                                   0x20000000L
#define CP_HQD_IQ_TIMER__PROCESSING_IQ_MASK                                                                   0x40000000L
#define CP_HQD_IQ_TIMER__ACTIVE_MASK                                                                          0x80000000L
//CP_HQD_IQ_RPTR
#define CP_HQD_IQ_RPTR__OFFSET__SHIFT                                                                         0x0
#define CP_HQD_IQ_RPTR__OFFSET_MASK                                                                           0x0000003FL
//CP_HQD_DEQUEUE_REQUEST
#define CP_HQD_DEQUEUE_REQUEST__DEQUEUE_REQ__SHIFT                                                            0x0
#define CP_HQD_DEQUEUE_REQUEST__IQ_REQ_PEND__SHIFT                                                            0x4
#define CP_HQD_DEQUEUE_REQUEST__DEQUEUE_INT__SHIFT                                                            0x8
#define CP_HQD_DEQUEUE_REQUEST__IQ_REQ_PEND_EN__SHIFT                                                         0x9
#define CP_HQD_DEQUEUE_REQUEST__DEQUEUE_REQ_EN__SHIFT                                                         0xa
#define CP_HQD_DEQUEUE_REQUEST__DEQUEUE_REQ_MASK                                                              0x00000007L
#define CP_HQD_DEQUEUE_REQUEST__IQ_REQ_PEND_MASK                                                              0x00000010L
#define CP_HQD_DEQUEUE_REQUEST__DEQUEUE_INT_MASK                                                              0x00000100L
#define CP_HQD_DEQUEUE_REQUEST__IQ_REQ_PEND_EN_MASK                                                           0x00000200L
#define CP_HQD_DEQUEUE_REQUEST__DEQUEUE_REQ_EN_MASK                                                           0x00000400L
//CP_HQD_DMA_OFFLOAD
#define CP_HQD_DMA_OFFLOAD__DMA_OFFLOAD__SHIFT                                                                0x0
#define CP_HQD_DMA_OFFLOAD__DMA_OFFLOAD_MASK                                                                  0x00000001L
//CP_HQD_OFFLOAD
#define CP_HQD_OFFLOAD__DMA_OFFLOAD__SHIFT                                                                    0x0
#define CP_HQD_OFFLOAD__DMA_OFFLOAD_EN__SHIFT                                                                 0x1
#define CP_HQD_OFFLOAD__AQL_OFFLOAD__SHIFT                                                                    0x2
#define CP_HQD_OFFLOAD__AQL_OFFLOAD_EN__SHIFT                                                                 0x3
#define CP_HQD_OFFLOAD__EOP_OFFLOAD__SHIFT                                                                    0x4
#define CP_HQD_OFFLOAD__EOP_OFFLOAD_EN__SHIFT                                                                 0x5
#define CP_HQD_OFFLOAD__DMA_OFFLOAD_MASK                                                                      0x00000001L
#define CP_HQD_OFFLOAD__DMA_OFFLOAD_EN_MASK                                                                   0x00000002L
#define CP_HQD_OFFLOAD__AQL_OFFLOAD_MASK                                                                      0x00000004L
#define CP_HQD_OFFLOAD__AQL_OFFLOAD_EN_MASK                                                                   0x00000008L
#define CP_HQD_OFFLOAD__EOP_OFFLOAD_MASK                                                                      0x00000010L
#define CP_HQD_OFFLOAD__EOP_OFFLOAD_EN_MASK                                                                   0x00000020L
//CP_HQD_SEMA_CMD
#define CP_HQD_SEMA_CMD__RETRY__SHIFT                                                                         0x0
#define CP_HQD_SEMA_CMD__RESULT__SHIFT                                                                        0x1
#define CP_HQD_SEMA_CMD__RETRY_MASK                                                                           0x00000001L
#define CP_HQD_SEMA_CMD__RESULT_MASK                                                                          0x00000006L
//CP_HQD_MSG_TYPE
#define CP_HQD_MSG_TYPE__ACTION__SHIFT                                                                        0x0
#define CP_HQD_MSG_TYPE__SAVE_STATE__SHIFT                                                                    0x4
#define CP_HQD_MSG_TYPE__ACTION_MASK                                                                          0x00000007L
#define CP_HQD_MSG_TYPE__SAVE_STATE_MASK                                                                      0x00000070L
//CP_HQD_ATOMIC0_PREOP_LO
#define CP_HQD_ATOMIC0_PREOP_LO__ATOMIC0_PREOP_LO__SHIFT                                                      0x0
#define CP_HQD_ATOMIC0_PREOP_LO__ATOMIC0_PREOP_LO_MASK                                                        0xFFFFFFFFL
//CP_HQD_ATOMIC0_PREOP_HI
#define CP_HQD_ATOMIC0_PREOP_HI__ATOMIC0_PREOP_HI__SHIFT                                                      0x0
#define CP_HQD_ATOMIC0_PREOP_HI__ATOMIC0_PREOP_HI_MASK                                                        0xFFFFFFFFL
//CP_HQD_ATOMIC1_PREOP_LO
#define CP_HQD_ATOMIC1_PREOP_LO__ATOMIC1_PREOP_LO__SHIFT                                                      0x0
#define CP_HQD_ATOMIC1_PREOP_LO__ATOMIC1_PREOP_LO_MASK                                                        0xFFFFFFFFL
//CP_HQD_ATOMIC1_PREOP_HI
#define CP_HQD_ATOMIC1_PREOP_HI__ATOMIC1_PREOP_HI__SHIFT                                                      0x0
#define CP_HQD_ATOMIC1_PREOP_HI__ATOMIC1_PREOP_HI_MASK                                                        0xFFFFFFFFL
//CP_HQD_HQ_SCHEDULER0
#define CP_HQD_HQ_SCHEDULER0__SCHEDULER__SHIFT                                                                0x0
#define CP_HQD_HQ_SCHEDULER0__SCHEDULER_MASK                                                                  0xFFFFFFFFL
//CP_HQD_HQ_STATUS0
#define CP_HQD_HQ_STATUS0__DEQUEUE_STATUS__SHIFT                                                              0x0
#define CP_HQD_HQ_STATUS0__DEQUEUE_RETRY_CNT__SHIFT                                                           0x2
#define CP_HQD_HQ_STATUS0__RSV_6_4__SHIFT                                                                     0x4
#define CP_HQD_HQ_STATUS0__SCRATCH_RAM_INIT__SHIFT                                                            0x7
#define CP_HQD_HQ_STATUS0__TCL2_DIRTY__SHIFT                                                                  0x8
#define CP_HQD_HQ_STATUS0__PG_ACTIVATED__SHIFT                                                                0x9
#define CP_HQD_HQ_STATUS0__RSVR_29_10__SHIFT                                                                  0xa
#define CP_HQD_HQ_STATUS0__QUEUE_IDLE__SHIFT                                                                  0x1e
#define CP_HQD_HQ_STATUS0__DB_UPDATED_MSG_EN__SHIFT                                                           0x1f
#define CP_HQD_HQ_STATUS0__DEQUEUE_STATUS_MASK                                                                0x00000003L
#define CP_HQD_HQ_STATUS0__DEQUEUE_RETRY_CNT_MASK                                                             0x0000000CL
#define CP_HQD_HQ_STATUS0__RSV_6_4_MASK                                                                       0x00000070L
#define CP_HQD_HQ_STATUS0__SCRATCH_RAM_INIT_MASK                                                              0x00000080L
#define CP_HQD_HQ_STATUS0__TCL2_DIRTY_MASK                                                                    0x00000100L
#define CP_HQD_HQ_STATUS0__PG_ACTIVATED_MASK                                                                  0x00000200L
#define CP_HQD_HQ_STATUS0__RSVR_29_10_MASK                                                                    0x3FFFFC00L
#define CP_HQD_HQ_STATUS0__QUEUE_IDLE_MASK                                                                    0x40000000L
#define CP_HQD_HQ_STATUS0__DB_UPDATED_MSG_EN_MASK                                                             0x80000000L
//CP_HQD_HQ_CONTROL0
#define CP_HQD_HQ_CONTROL0__CONTROL__SHIFT                                                                    0x0
#define CP_HQD_HQ_CONTROL0__CONTROL_MASK                                                                      0xFFFFFFFFL
//CP_HQD_HQ_SCHEDULER1
#define CP_HQD_HQ_SCHEDULER1__SCHEDULER__SHIFT                                                                0x0
#define CP_HQD_HQ_SCHEDULER1__SCHEDULER_MASK                                                                  0xFFFFFFFFL
//CP_MQD_CONTROL
#define CP_MQD_CONTROL__VMID__SHIFT                                                                           0x0
#define CP_MQD_CONTROL__PRIV_STATE__SHIFT                                                                     0x8
#define CP_MQD_CONTROL__PROCESSING_MQD__SHIFT                                                                 0xc
#define CP_MQD_CONTROL__PROCESSING_MQD_EN__SHIFT                                                              0xd
#define CP_MQD_CONTROL__EXE_DISABLE__SHIFT                                                                    0x17
#define CP_MQD_CONTROL__CACHE_POLICY__SHIFT                                                                   0x18
#define CP_MQD_CONTROL__VMID_MASK                                                                             0x0000000FL
#define CP_MQD_CONTROL__PRIV_STATE_MASK                                                                       0x00000100L
#define CP_MQD_CONTROL__PROCESSING_MQD_MASK                                                                   0x00001000L
#define CP_MQD_CONTROL__PROCESSING_MQD_EN_MASK                                                                0x00002000L
#define CP_MQD_CONTROL__EXE_DISABLE_MASK                                                                      0x00800000L
#define CP_MQD_CONTROL__CACHE_POLICY_MASK                                                                     0x01000000L
//CP_HQD_HQ_STATUS1
#define CP_HQD_HQ_STATUS1__STATUS__SHIFT                                                                      0x0
#define CP_HQD_HQ_STATUS1__STATUS_MASK                                                                        0xFFFFFFFFL
//CP_HQD_HQ_CONTROL1
#define CP_HQD_HQ_CONTROL1__CONTROL__SHIFT                                                                    0x0
#define CP_HQD_HQ_CONTROL1__CONTROL_MASK                                                                      0xFFFFFFFFL
//CP_HQD_EOP_BASE_ADDR
#define CP_HQD_EOP_BASE_ADDR__BASE_ADDR__SHIFT                                                                0x0
#define CP_HQD_EOP_BASE_ADDR__BASE_ADDR_MASK                                                                  0xFFFFFFFFL
//CP_HQD_EOP_BASE_ADDR_HI
#define CP_HQD_EOP_BASE_ADDR_HI__BASE_ADDR_HI__SHIFT                                                          0x0
#define CP_HQD_EOP_BASE_ADDR_HI__BASE_ADDR_HI_MASK                                                            0x000000FFL
//CP_HQD_EOP_CONTROL
#define CP_HQD_EOP_CONTROL__EOP_SIZE__SHIFT                                                                   0x0
#define CP_HQD_EOP_CONTROL__PROCESSING_EOP__SHIFT                                                             0x8
#define CP_HQD_EOP_CONTROL__PROCESS_EOP_EN__SHIFT                                                             0xc
#define CP_HQD_EOP_CONTROL__PROCESSING_EOPIB__SHIFT                                                           0xd
#define CP_HQD_EOP_CONTROL__PROCESS_EOPIB_EN__SHIFT                                                           0xe
#define CP_HQD_EOP_CONTROL__HALT_FETCHER__SHIFT                                                               0x15
#define CP_HQD_EOP_CONTROL__HALT_FETCHER_EN__SHIFT                                                            0x16
#define CP_HQD_EOP_CONTROL__EXE_DISABLE__SHIFT                                                                0x17
#define CP_HQD_EOP_CONTROL__CACHE_POLICY__SHIFT                                                               0x18
#define CP_HQD_EOP_CONTROL__SIG_SEM_RESULT__SHIFT                                                             0x1d
#define CP_HQD_EOP_CONTROL__PEND_SIG_SEM__SHIFT                                                               0x1f
#define CP_HQD_EOP_CONTROL__EOP_SIZE_MASK                                                                     0x0000003FL
#define CP_HQD_EOP_CONTROL__PROCESSING_EOP_MASK                                                               0x00000100L
#define CP_HQD_EOP_CONTROL__PROCESS_EOP_EN_MASK                                                               0x00001000L
#define CP_HQD_EOP_CONTROL__PROCESSING_EOPIB_MASK                                                             0x00002000L
#define CP_HQD_EOP_CONTROL__PROCESS_EOPIB_EN_MASK                                                             0x00004000L
#define CP_HQD_EOP_CONTROL__HALT_FETCHER_MASK                                                                 0x00200000L
#define CP_HQD_EOP_CONTROL__HALT_FETCHER_EN_MASK                                                              0x00400000L
#define CP_HQD_EOP_CONTROL__EXE_DISABLE_MASK                                                                  0x00800000L
#define CP_HQD_EOP_CONTROL__CACHE_POLICY_MASK                                                                 0x01000000L
#define CP_HQD_EOP_CONTROL__SIG_SEM_RESULT_MASK                                                               0x60000000L
#define CP_HQD_EOP_CONTROL__PEND_SIG_SEM_MASK                                                                 0x80000000L
//CP_HQD_EOP_RPTR
#define CP_HQD_EOP_RPTR__RPTR__SHIFT                                                                          0x0
#define CP_HQD_EOP_RPTR__RESET_FETCHER__SHIFT                                                                 0x1c
#define CP_HQD_EOP_RPTR__DEQUEUE_PEND__SHIFT                                                                  0x1d
#define CP_HQD_EOP_RPTR__RPTR_EQ_CSMD_WPTR__SHIFT                                                             0x1e
#define CP_HQD_EOP_RPTR__INIT_FETCHER__SHIFT                                                                  0x1f
#define CP_HQD_EOP_RPTR__RPTR_MASK                                                                            0x00001FFFL
#define CP_HQD_EOP_RPTR__RESET_FETCHER_MASK                                                                   0x10000000L
#define CP_HQD_EOP_RPTR__DEQUEUE_PEND_MASK                                                                    0x20000000L
#define CP_HQD_EOP_RPTR__RPTR_EQ_CSMD_WPTR_MASK                                                               0x40000000L
#define CP_HQD_EOP_RPTR__INIT_FETCHER_MASK                                                                    0x80000000L
//CP_HQD_EOP_WPTR
#define CP_HQD_EOP_WPTR__WPTR__SHIFT                                                                          0x0
#define CP_HQD_EOP_WPTR__EOP_EMPTY__SHIFT                                                                     0xf
#define CP_HQD_EOP_WPTR__EOP_AVAIL__SHIFT                                                                     0x10
#define CP_HQD_EOP_WPTR__WPTR_MASK                                                                            0x00001FFFL
#define CP_HQD_EOP_WPTR__EOP_EMPTY_MASK                                                                       0x00008000L
#define CP_HQD_EOP_WPTR__EOP_AVAIL_MASK                                                                       0x1FFF0000L
//CP_HQD_EOP_EVENTS
#define CP_HQD_EOP_EVENTS__EVENT_COUNT__SHIFT                                                                 0x0
#define CP_HQD_EOP_EVENTS__CS_PARTIAL_FLUSH_PEND__SHIFT                                                       0x10
#define CP_HQD_EOP_EVENTS__EVENT_COUNT_MASK                                                                   0x00000FFFL
#define CP_HQD_EOP_EVENTS__CS_PARTIAL_FLUSH_PEND_MASK                                                         0x00010000L
//CP_HQD_CTX_SAVE_BASE_ADDR_LO
#define CP_HQD_CTX_SAVE_BASE_ADDR_LO__ADDR__SHIFT                                                             0xc
#define CP_HQD_CTX_SAVE_BASE_ADDR_LO__ADDR_MASK                                                               0xFFFFF000L
//CP_HQD_CTX_SAVE_BASE_ADDR_HI
#define CP_HQD_CTX_SAVE_BASE_ADDR_HI__ADDR_HI__SHIFT                                                          0x0
#define CP_HQD_CTX_SAVE_BASE_ADDR_HI__ADDR_HI_MASK                                                            0x0000FFFFL
//CP_HQD_CTX_SAVE_CONTROL
#define CP_HQD_CTX_SAVE_CONTROL__POLICY__SHIFT                                                                0x3
#define CP_HQD_CTX_SAVE_CONTROL__EXE_DISABLE__SHIFT                                                           0x17
#define CP_HQD_CTX_SAVE_CONTROL__POLICY_MASK                                                                  0x00000008L
#define CP_HQD_CTX_SAVE_CONTROL__EXE_DISABLE_MASK                                                             0x00800000L
//CP_HQD_CNTL_STACK_OFFSET
#define CP_HQD_CNTL_STACK_OFFSET__OFFSET__SHIFT                                                               0x2
#define CP_HQD_CNTL_STACK_OFFSET__OFFSET_MASK                                                                 0x0000FFFCL
//CP_HQD_CNTL_STACK_SIZE
#define CP_HQD_CNTL_STACK_SIZE__SIZE__SHIFT                                                                   0xc
#define CP_HQD_CNTL_STACK_SIZE__SIZE_MASK                                                                     0x0000F000L
//CP_HQD_WG_STATE_OFFSET
#define CP_HQD_WG_STATE_OFFSET__OFFSET__SHIFT                                                                 0x2
#define CP_HQD_WG_STATE_OFFSET__OFFSET_MASK                                                                   0x07FFFFFCL
//CP_HQD_CTX_SAVE_SIZE
#define CP_HQD_CTX_SAVE_SIZE__SIZE__SHIFT                                                                     0xc
#define CP_HQD_CTX_SAVE_SIZE__SIZE_MASK                                                                       0x07FFF000L
//CP_HQD_GDS_RESOURCE_STATE
#define CP_HQD_GDS_RESOURCE_STATE__OA_REQUIRED__SHIFT                                                         0x0
#define CP_HQD_GDS_RESOURCE_STATE__OA_ACQUIRED__SHIFT                                                         0x1
#define CP_HQD_GDS_RESOURCE_STATE__GWS_SIZE__SHIFT                                                            0x4
#define CP_HQD_GDS_RESOURCE_STATE__GWS_PNTR__SHIFT                                                            0xc
#define CP_HQD_GDS_RESOURCE_STATE__OA_REQUIRED_MASK                                                           0x00000001L
#define CP_HQD_GDS_RESOURCE_STATE__OA_ACQUIRED_MASK                                                           0x00000002L
#define CP_HQD_GDS_RESOURCE_STATE__GWS_SIZE_MASK                                                              0x000003F0L
#define CP_HQD_GDS_RESOURCE_STATE__GWS_PNTR_MASK                                                              0x0003F000L
//CP_HQD_ERROR
#define CP_HQD_ERROR__EDC_ERROR_ID__SHIFT                                                                     0x0
#define CP_HQD_ERROR__SUA_ERROR__SHIFT                                                                        0x4
#define CP_HQD_ERROR__AQL_ERROR__SHIFT                                                                        0x5
#define CP_HQD_ERROR__PQ_UTCL1_ERROR__SHIFT                                                                   0x8
#define CP_HQD_ERROR__IB_UTCL1_ERROR__SHIFT                                                                   0x9
#define CP_HQD_ERROR__EOP_UTCL1_ERROR__SHIFT                                                                  0xa
#define CP_HQD_ERROR__IQ_UTCL1_ERROR__SHIFT                                                                   0xb
#define CP_HQD_ERROR__RRPT_UTCL1_ERROR__SHIFT                                                                 0xc
#define CP_HQD_ERROR__WPP_UTCL1_ERROR__SHIFT                                                                  0xd
#define CP_HQD_ERROR__SEM_UTCL1_ERROR__SHIFT                                                                  0xe
#define CP_HQD_ERROR__DMA_SRC_UTCL1_ERROR__SHIFT                                                              0xf
#define CP_HQD_ERROR__DMA_DST_UTCL1_ERROR__SHIFT                                                              0x10
#define CP_HQD_ERROR__SR_UTCL1_ERROR__SHIFT                                                                   0x11
#define CP_HQD_ERROR__QU_UTCL1_ERROR__SHIFT                                                                   0x12
#define CP_HQD_ERROR__TC_UTCL1_ERROR__SHIFT                                                                   0x13
#define CP_HQD_ERROR__EDC_ERROR_ID_MASK                                                                       0x0000000FL
#define CP_HQD_ERROR__SUA_ERROR_MASK                                                                          0x00000010L
#define CP_HQD_ERROR__AQL_ERROR_MASK                                                                          0x00000020L
#define CP_HQD_ERROR__PQ_UTCL1_ERROR_MASK                                                                     0x00000100L
#define CP_HQD_ERROR__IB_UTCL1_ERROR_MASK                                                                     0x00000200L
#define CP_HQD_ERROR__EOP_UTCL1_ERROR_MASK                                                                    0x00000400L
#define CP_HQD_ERROR__IQ_UTCL1_ERROR_MASK                                                                     0x00000800L
#define CP_HQD_ERROR__RRPT_UTCL1_ERROR_MASK                                                                   0x00001000L
#define CP_HQD_ERROR__WPP_UTCL1_ERROR_MASK                                                                    0x00002000L
#define CP_HQD_ERROR__SEM_UTCL1_ERROR_MASK                                                                    0x00004000L
#define CP_HQD_ERROR__DMA_SRC_UTCL1_ERROR_MASK                                                                0x00008000L
#define CP_HQD_ERROR__DMA_DST_UTCL1_ERROR_MASK                                                                0x00010000L
#define CP_HQD_ERROR__SR_UTCL1_ERROR_MASK                                                                     0x00020000L
#define CP_HQD_ERROR__QU_UTCL1_ERROR_MASK                                                                     0x00040000L
#define CP_HQD_ERROR__TC_UTCL1_ERROR_MASK                                                                     0x00080000L
//CP_HQD_EOP_WPTR_MEM
#define CP_HQD_EOP_WPTR_MEM__WPTR__SHIFT                                                                      0x0
#define CP_HQD_EOP_WPTR_MEM__WPTR_MASK                                                                        0x00001FFFL
//CP_HQD_AQL_CONTROL
#define CP_HQD_AQL_CONTROL__CONTROL0__SHIFT                                                                   0x0
#define CP_HQD_AQL_CONTROL__CONTROL0_EN__SHIFT                                                                0xf
#define CP_HQD_AQL_CONTROL__CONTROL1__SHIFT                                                                   0x10
#define CP_HQD_AQL_CONTROL__CONTROL1_EN__SHIFT                                                                0x1f
#define CP_HQD_AQL_CONTROL__CONTROL0_MASK                                                                     0x00007FFFL
#define CP_HQD_AQL_CONTROL__CONTROL0_EN_MASK                                                                  0x00008000L
#define CP_HQD_AQL_CONTROL__CONTROL1_MASK                                                                     0x7FFF0000L
#define CP_HQD_AQL_CONTROL__CONTROL1_EN_MASK                                                                  0x80000000L
//CP_HQD_PQ_WPTR_LO
#define CP_HQD_PQ_WPTR_LO__OFFSET__SHIFT                                                                      0x0
#define CP_HQD_PQ_WPTR_LO__OFFSET_MASK                                                                        0xFFFFFFFFL
//CP_HQD_PQ_WPTR_HI
#define CP_HQD_PQ_WPTR_HI__DATA__SHIFT                                                                        0x0
#define CP_HQD_PQ_WPTR_HI__DATA_MASK                                                                          0xFFFFFFFFL




// addressBlock: gc_didtdec
//DIDT_IND_INDEX
#define DIDT_IND_INDEX__DIDT_IND_INDEX__SHIFT                                                                 0x0
#define DIDT_IND_INDEX__DIDT_IND_INDEX_MASK                                                                   0xFFFFFFFFL
//DIDT_IND_DATA
#define DIDT_IND_DATA__DIDT_IND_DATA__SHIFT                                                                   0x0
#define DIDT_IND_DATA__DIDT_IND_DATA_MASK                                                                     0xFFFFFFFFL
//DIDT_INDEX_AUTO_INCR_EN
#define DIDT_INDEX_AUTO_INCR_EN__DIDT_INDEX_AUTO_INCR_EN__SHIFT                                               0x0
#define DIDT_INDEX_AUTO_INCR_EN__DIDT_INDEX_AUTO_INCR_EN_MASK                                                 0x00000001L


// addressBlock: gc_ea_gceadec
//GCEA_DRAM_RD_CLI2GRP_MAP0
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID0_GROUP__SHIFT                                                          0x0
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID1_GROUP__SHIFT                                                          0x2
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID2_GROUP__SHIFT                                                          0x4
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID3_GROUP__SHIFT                                                          0x6
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID4_GROUP__SHIFT                                                          0x8
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID5_GROUP__SHIFT                                                          0xa
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID6_GROUP__SHIFT                                                          0xc
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID7_GROUP__SHIFT                                                          0xe
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID8_GROUP__SHIFT                                                          0x10
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID9_GROUP__SHIFT                                                          0x12
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID10_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID11_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID12_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID13_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID14_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID15_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID0_GROUP_MASK                                                            0x00000003L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID1_GROUP_MASK                                                            0x0000000CL
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID2_GROUP_MASK                                                            0x00000030L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID3_GROUP_MASK                                                            0x000000C0L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID4_GROUP_MASK                                                            0x00000300L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID5_GROUP_MASK                                                            0x00000C00L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID6_GROUP_MASK                                                            0x00003000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID7_GROUP_MASK                                                            0x0000C000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID8_GROUP_MASK                                                            0x00030000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID9_GROUP_MASK                                                            0x000C0000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID10_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID11_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID12_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID13_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID14_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP0__CID15_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_RD_CLI2GRP_MAP1
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID16_GROUP__SHIFT                                                         0x0
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID17_GROUP__SHIFT                                                         0x2
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID18_GROUP__SHIFT                                                         0x4
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID19_GROUP__SHIFT                                                         0x6
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID20_GROUP__SHIFT                                                         0x8
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID21_GROUP__SHIFT                                                         0xa
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID22_GROUP__SHIFT                                                         0xc
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID23_GROUP__SHIFT                                                         0xe
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID24_GROUP__SHIFT                                                         0x10
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID25_GROUP__SHIFT                                                         0x12
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID26_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID27_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID28_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID29_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID30_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID31_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID16_GROUP_MASK                                                           0x00000003L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID17_GROUP_MASK                                                           0x0000000CL
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID18_GROUP_MASK                                                           0x00000030L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID19_GROUP_MASK                                                           0x000000C0L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID20_GROUP_MASK                                                           0x00000300L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID21_GROUP_MASK                                                           0x00000C00L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID22_GROUP_MASK                                                           0x00003000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID23_GROUP_MASK                                                           0x0000C000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID24_GROUP_MASK                                                           0x00030000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID25_GROUP_MASK                                                           0x000C0000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID26_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID27_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID28_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID29_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID30_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_RD_CLI2GRP_MAP1__CID31_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_WR_CLI2GRP_MAP0
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID0_GROUP__SHIFT                                                          0x0
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID1_GROUP__SHIFT                                                          0x2
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID2_GROUP__SHIFT                                                          0x4
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID3_GROUP__SHIFT                                                          0x6
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID4_GROUP__SHIFT                                                          0x8
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID5_GROUP__SHIFT                                                          0xa
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID6_GROUP__SHIFT                                                          0xc
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID7_GROUP__SHIFT                                                          0xe
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID8_GROUP__SHIFT                                                          0x10
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID9_GROUP__SHIFT                                                          0x12
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID10_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID11_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID12_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID13_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID14_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID15_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID0_GROUP_MASK                                                            0x00000003L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID1_GROUP_MASK                                                            0x0000000CL
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID2_GROUP_MASK                                                            0x00000030L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID3_GROUP_MASK                                                            0x000000C0L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID4_GROUP_MASK                                                            0x00000300L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID5_GROUP_MASK                                                            0x00000C00L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID6_GROUP_MASK                                                            0x00003000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID7_GROUP_MASK                                                            0x0000C000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID8_GROUP_MASK                                                            0x00030000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID9_GROUP_MASK                                                            0x000C0000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID10_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID11_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID12_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID13_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID14_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP0__CID15_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_WR_CLI2GRP_MAP1
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID16_GROUP__SHIFT                                                         0x0
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID17_GROUP__SHIFT                                                         0x2
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID18_GROUP__SHIFT                                                         0x4
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID19_GROUP__SHIFT                                                         0x6
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID20_GROUP__SHIFT                                                         0x8
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID21_GROUP__SHIFT                                                         0xa
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID22_GROUP__SHIFT                                                         0xc
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID23_GROUP__SHIFT                                                         0xe
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID24_GROUP__SHIFT                                                         0x10
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID25_GROUP__SHIFT                                                         0x12
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID26_GROUP__SHIFT                                                         0x14
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID27_GROUP__SHIFT                                                         0x16
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID28_GROUP__SHIFT                                                         0x18
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID29_GROUP__SHIFT                                                         0x1a
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID30_GROUP__SHIFT                                                         0x1c
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID31_GROUP__SHIFT                                                         0x1e
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID16_GROUP_MASK                                                           0x00000003L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID17_GROUP_MASK                                                           0x0000000CL
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID18_GROUP_MASK                                                           0x00000030L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID19_GROUP_MASK                                                           0x000000C0L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID20_GROUP_MASK                                                           0x00000300L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID21_GROUP_MASK                                                           0x00000C00L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID22_GROUP_MASK                                                           0x00003000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID23_GROUP_MASK                                                           0x0000C000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID24_GROUP_MASK                                                           0x00030000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID25_GROUP_MASK                                                           0x000C0000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID26_GROUP_MASK                                                           0x00300000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID27_GROUP_MASK                                                           0x00C00000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID28_GROUP_MASK                                                           0x03000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID29_GROUP_MASK                                                           0x0C000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID30_GROUP_MASK                                                           0x30000000L
#define GCEA_DRAM_WR_CLI2GRP_MAP1__CID31_GROUP_MASK                                                           0xC0000000L
//GCEA_DRAM_RD_GRP2VC_MAP
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP0_VC__SHIFT                                                             0x0
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP1_VC__SHIFT                                                             0x3
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP2_VC__SHIFT                                                             0x6
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP3_VC__SHIFT                                                             0x9
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP0_VC_MASK                                                               0x00000007L
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP1_VC_MASK                                                               0x00000038L
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP2_VC_MASK                                                               0x000001C0L
#define GCEA_DRAM_RD_GRP2VC_MAP__GROUP3_VC_MASK                                                               0x00000E00L
//GCEA_DRAM_WR_GRP2VC_MAP
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP0_VC__SHIFT                                                             0x0
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP1_VC__SHIFT                                                             0x3
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP2_VC__SHIFT                                                             0x6
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP3_VC__SHIFT                                                             0x9
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP0_VC_MASK                                                               0x00000007L
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP1_VC_MASK                                                               0x00000038L
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP2_VC_MASK                                                               0x000001C0L
#define GCEA_DRAM_WR_GRP2VC_MAP__GROUP3_VC_MASK                                                               0x00000E00L
//GCEA_DRAM_RD_LAZY
#define GCEA_DRAM_RD_LAZY__GROUP0_DELAY__SHIFT                                                                0x0
#define GCEA_DRAM_RD_LAZY__GROUP1_DELAY__SHIFT                                                                0x3
#define GCEA_DRAM_RD_LAZY__GROUP2_DELAY__SHIFT                                                                0x6
#define GCEA_DRAM_RD_LAZY__GROUP3_DELAY__SHIFT                                                                0x9
#define GCEA_DRAM_RD_LAZY__REQ_ACCUM_THRESH__SHIFT                                                            0xc
#define GCEA_DRAM_RD_LAZY__REQ_ACCUM_TIMEOUT__SHIFT                                                           0x14
#define GCEA_DRAM_RD_LAZY__REQ_ACCUM_IDLEMAX__SHIFT                                                           0x1b
#define GCEA_DRAM_RD_LAZY__GROUP0_DELAY_MASK                                                                  0x00000007L
#define GCEA_DRAM_RD_LAZY__GROUP1_DELAY_MASK                                                                  0x00000038L
#define GCEA_DRAM_RD_LAZY__GROUP2_DELAY_MASK                                                                  0x000001C0L
#define GCEA_DRAM_RD_LAZY__GROUP3_DELAY_MASK                                                                  0x00000E00L
#define GCEA_DRAM_RD_LAZY__REQ_ACCUM_THRESH_MASK                                                              0x0003F000L
#define GCEA_DRAM_RD_LAZY__REQ_ACCUM_TIMEOUT_MASK                                                             0x07F00000L
#define GCEA_DRAM_RD_LAZY__REQ_ACCUM_IDLEMAX_MASK                                                             0x78000000L
//GCEA_DRAM_WR_LAZY
#define GCEA_DRAM_WR_LAZY__GROUP0_DELAY__SHIFT                                                                0x0
#define GCEA_DRAM_WR_LAZY__GROUP1_DELAY__SHIFT                                                                0x3
#define GCEA_DRAM_WR_LAZY__GROUP2_DELAY__SHIFT                                                                0x6
#define GCEA_DRAM_WR_LAZY__GROUP3_DELAY__SHIFT                                                                0x9
#define GCEA_DRAM_WR_LAZY__REQ_ACCUM_THRESH__SHIFT                                                            0xc
#define GCEA_DRAM_WR_LAZY__REQ_ACCUM_TIMEOUT__SHIFT                                                           0x14
#define GCEA_DRAM_WR_LAZY__REQ_ACCUM_IDLEMAX__SHIFT                                                           0x1b
#define GCEA_DRAM_WR_LAZY__GROUP0_DELAY_MASK                                                                  0x00000007L
#define GCEA_DRAM_WR_LAZY__GROUP1_DELAY_MASK                                                                  0x00000038L
#define GCEA_DRAM_WR_LAZY__GROUP2_DELAY_MASK                                                                  0x000001C0L
#define GCEA_DRAM_WR_LAZY__GROUP3_DELAY_MASK                                                                  0x00000E00L
#define GCEA_DRAM_WR_LAZY__REQ_ACCUM_THRESH_MASK                                                              0x0003F000L
#define GCEA_DRAM_WR_LAZY__REQ_ACCUM_TIMEOUT_MASK                                                             0x07F00000L
#define GCEA_DRAM_WR_LAZY__REQ_ACCUM_IDLEMAX_MASK                                                             0x78000000L
//GCEA_DRAM_RD_CAM_CNTL
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP0__SHIFT                                                            0x0
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP1__SHIFT                                                            0x4
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP2__SHIFT                                                            0x8
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP3__SHIFT                                                            0xc
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP0__SHIFT                                                    0x10
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP1__SHIFT                                                    0x13
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP2__SHIFT                                                    0x16
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP3__SHIFT                                                    0x19
#define GCEA_DRAM_RD_CAM_CNTL__REFILL_CHAIN__SHIFT                                                            0x1c
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP0_MASK                                                              0x0000000FL
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP1_MASK                                                              0x000000F0L
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP2_MASK                                                              0x00000F00L
#define GCEA_DRAM_RD_CAM_CNTL__DEPTH_GROUP3_MASK                                                              0x0000F000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP0_MASK                                                      0x00070000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP1_MASK                                                      0x00380000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP2_MASK                                                      0x01C00000L
#define GCEA_DRAM_RD_CAM_CNTL__REORDER_LIMIT_GROUP3_MASK                                                      0x0E000000L
#define GCEA_DRAM_RD_CAM_CNTL__REFILL_CHAIN_MASK                                                              0x10000000L
//GCEA_DRAM_WR_CAM_CNTL
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP0__SHIFT                                                            0x0
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP1__SHIFT                                                            0x4
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP2__SHIFT                                                            0x8
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP3__SHIFT                                                            0xc
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP0__SHIFT                                                    0x10
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP1__SHIFT                                                    0x13
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP2__SHIFT                                                    0x16
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP3__SHIFT                                                    0x19
#define GCEA_DRAM_WR_CAM_CNTL__REFILL_CHAIN__SHIFT                                                            0x1c
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP0_MASK                                                              0x0000000FL
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP1_MASK                                                              0x000000F0L
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP2_MASK                                                              0x00000F00L
#define GCEA_DRAM_WR_CAM_CNTL__DEPTH_GROUP3_MASK                                                              0x0000F000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP0_MASK                                                      0x00070000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP1_MASK                                                      0x00380000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP2_MASK                                                      0x01C00000L
#define GCEA_DRAM_WR_CAM_CNTL__REORDER_LIMIT_GROUP3_MASK                                                      0x0E000000L
#define GCEA_DRAM_WR_CAM_CNTL__REFILL_CHAIN_MASK                                                              0x10000000L
//GCEA_DRAM_PAGE_BURST
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_LO__SHIFT                                                              0x0
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_HI__SHIFT                                                              0x8
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_LO__SHIFT                                                              0x10
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_HI__SHIFT                                                              0x18
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_LO_MASK                                                                0x000000FFL
#define GCEA_DRAM_PAGE_BURST__RD_LIMIT_HI_MASK                                                                0x0000FF00L
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_LO_MASK                                                                0x00FF0000L
#define GCEA_DRAM_PAGE_BURST__WR_LIMIT_HI_MASK                                                                0xFF000000L
//GCEA_DRAM_RD_PRI_AGE
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGING_RATE__SHIFT                                                        0x0
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGING_RATE__SHIFT                                                        0x3
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGING_RATE__SHIFT                                                        0x6
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGING_RATE__SHIFT                                                        0x9
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGE_COEFFICIENT__SHIFT                                                   0xc
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGE_COEFFICIENT__SHIFT                                                   0xf
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGE_COEFFICIENT__SHIFT                                                   0x12
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGE_COEFFICIENT__SHIFT                                                   0x15
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGING_RATE_MASK                                                          0x00000007L
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGING_RATE_MASK                                                          0x00000038L
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGING_RATE_MASK                                                          0x000001C0L
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGING_RATE_MASK                                                          0x00000E00L
#define GCEA_DRAM_RD_PRI_AGE__GROUP0_AGE_COEFFICIENT_MASK                                                     0x00007000L
#define GCEA_DRAM_RD_PRI_AGE__GROUP1_AGE_COEFFICIENT_MASK                                                     0x00038000L
#define GCEA_DRAM_RD_PRI_AGE__GROUP2_AGE_COEFFICIENT_MASK                                                     0x001C0000L
#define GCEA_DRAM_RD_PRI_AGE__GROUP3_AGE_COEFFICIENT_MASK                                                     0x00E00000L
//GCEA_DRAM_WR_PRI_AGE
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGING_RATE__SHIFT                                                        0x0
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGING_RATE__SHIFT                                                        0x3
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGING_RATE__SHIFT                                                        0x6
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGING_RATE__SHIFT                                                        0x9
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGE_COEFFICIENT__SHIFT                                                   0xc
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGE_COEFFICIENT__SHIFT                                                   0xf
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGE_COEFFICIENT__SHIFT                                                   0x12
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGE_COEFFICIENT__SHIFT                                                   0x15
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGING_RATE_MASK                                                          0x00000007L
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGING_RATE_MASK                                                          0x00000038L
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGING_RATE_MASK                                                          0x000001C0L
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGING_RATE_MASK                                                          0x00000E00L
#define GCEA_DRAM_WR_PRI_AGE__GROUP0_AGE_COEFFICIENT_MASK                                                     0x00007000L
#define GCEA_DRAM_WR_PRI_AGE__GROUP1_AGE_COEFFICIENT_MASK                                                     0x00038000L
#define GCEA_DRAM_WR_PRI_AGE__GROUP2_AGE_COEFFICIENT_MASK                                                     0x001C0000L
#define GCEA_DRAM_WR_PRI_AGE__GROUP3_AGE_COEFFICIENT_MASK                                                     0x00E00000L
//GCEA_DRAM_RD_PRI_QUEUING
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_RD_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT_MASK                                             0x00000E00L
//GCEA_DRAM_WR_PRI_QUEUING
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_WR_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT_MASK                                             0x00000E00L
//GCEA_DRAM_RD_PRI_FIXED
#define GCEA_DRAM_RD_PRI_FIXED__GROUP0_FIXED_COEFFICIENT__SHIFT                                               0x0
#define GCEA_DRAM_RD_PRI_FIXED__GROUP1_FIXED_COEFFICIENT__SHIFT                                               0x3
#define GCEA_DRAM_RD_PRI_FIXED__GROUP2_FIXED_COEFFICIENT__SHIFT                                               0x6
#define GCEA_DRAM_RD_PRI_FIXED__GROUP3_FIXED_COEFFICIENT__SHIFT                                               0x9
#define GCEA_DRAM_RD_PRI_FIXED__GROUP0_FIXED_COEFFICIENT_MASK                                                 0x00000007L
#define GCEA_DRAM_RD_PRI_FIXED__GROUP1_FIXED_COEFFICIENT_MASK                                                 0x00000038L
#define GCEA_DRAM_RD_PRI_FIXED__GROUP2_FIXED_COEFFICIENT_MASK                                                 0x000001C0L
#define GCEA_DRAM_RD_PRI_FIXED__GROUP3_FIXED_COEFFICIENT_MASK                                                 0x00000E00L
//GCEA_DRAM_WR_PRI_FIXED
#define GCEA_DRAM_WR_PRI_FIXED__GROUP0_FIXED_COEFFICIENT__SHIFT                                               0x0
#define GCEA_DRAM_WR_PRI_FIXED__GROUP1_FIXED_COEFFICIENT__SHIFT                                               0x3
#define GCEA_DRAM_WR_PRI_FIXED__GROUP2_FIXED_COEFFICIENT__SHIFT                                               0x6
#define GCEA_DRAM_WR_PRI_FIXED__GROUP3_FIXED_COEFFICIENT__SHIFT                                               0x9
#define GCEA_DRAM_WR_PRI_FIXED__GROUP0_FIXED_COEFFICIENT_MASK                                                 0x00000007L
#define GCEA_DRAM_WR_PRI_FIXED__GROUP1_FIXED_COEFFICIENT_MASK                                                 0x00000038L
#define GCEA_DRAM_WR_PRI_FIXED__GROUP2_FIXED_COEFFICIENT_MASK                                                 0x000001C0L
#define GCEA_DRAM_WR_PRI_FIXED__GROUP3_FIXED_COEFFICIENT_MASK                                                 0x00000E00L
//GCEA_DRAM_RD_PRI_URGENCY
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_MODE__SHIFT                                                  0xc
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_MODE__SHIFT                                                  0xd
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_MODE__SHIFT                                                  0xe
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_MODE__SHIFT                                                  0xf
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT_MASK                                             0x00000E00L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP0_URGENCY_MODE_MASK                                                    0x00001000L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP1_URGENCY_MODE_MASK                                                    0x00002000L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP2_URGENCY_MODE_MASK                                                    0x00004000L
#define GCEA_DRAM_RD_PRI_URGENCY__GROUP3_URGENCY_MODE_MASK                                                    0x00008000L
//GCEA_DRAM_WR_PRI_URGENCY
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT__SHIFT                                           0x0
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT__SHIFT                                           0x3
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT__SHIFT                                           0x6
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT__SHIFT                                           0x9
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_MODE__SHIFT                                                  0xc
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_MODE__SHIFT                                                  0xd
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_MODE__SHIFT                                                  0xe
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_MODE__SHIFT                                                  0xf
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT_MASK                                             0x00000007L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT_MASK                                             0x00000038L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT_MASK                                             0x000001C0L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT_MASK                                             0x00000E00L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP0_URGENCY_MODE_MASK                                                    0x00001000L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP1_URGENCY_MODE_MASK                                                    0x00002000L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP2_URGENCY_MODE_MASK                                                    0x00004000L
#define GCEA_DRAM_WR_PRI_URGENCY__GROUP3_URGENCY_MODE_MASK                                                    0x00008000L
//GCEA_DRAM_RD_PRI_QUANT_PRI1
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_RD_PRI_QUANT_PRI1__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_RD_PRI_QUANT_PRI2
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_RD_PRI_QUANT_PRI2__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_RD_PRI_QUANT_PRI3
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_RD_PRI_QUANT_PRI3__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_WR_PRI_QUANT_PRI1
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_WR_PRI_QUANT_PRI1__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_WR_PRI_QUANT_PRI2
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_WR_PRI_QUANT_PRI2__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_DRAM_WR_PRI_QUANT_PRI3
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP0_THRESHOLD__SHIFT                                                  0x0
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP1_THRESHOLD__SHIFT                                                  0x8
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP2_THRESHOLD__SHIFT                                                  0x10
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP3_THRESHOLD__SHIFT                                                  0x18
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP0_THRESHOLD_MASK                                                    0x000000FFL
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP1_THRESHOLD_MASK                                                    0x0000FF00L
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP2_THRESHOLD_MASK                                                    0x00FF0000L
#define GCEA_DRAM_WR_PRI_QUANT_PRI3__GROUP3_THRESHOLD_MASK                                                    0xFF000000L
//GCEA_ADDRNORM_BASE_ADDR0
#define GCEA_ADDRNORM_BASE_ADDR0__ADDR_RNG_VAL__SHIFT                                                         0x0
#define GCEA_ADDRNORM_BASE_ADDR0__LGCY_MMIO_HOLE_EN__SHIFT                                                    0x1
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_CHAN__SHIFT                                                       0x2
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_DIES__SHIFT                                                       0x7
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_SOCKETS__SHIFT                                                    0x8
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_ADDR_SEL__SHIFT                                                       0x9
#define GCEA_ADDRNORM_BASE_ADDR0__BASE_ADDR__SHIFT                                                            0xc
#define GCEA_ADDRNORM_BASE_ADDR0__ADDR_RNG_VAL_MASK                                                           0x00000001L
#define GCEA_ADDRNORM_BASE_ADDR0__LGCY_MMIO_HOLE_EN_MASK                                                      0x00000002L
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_CHAN_MASK                                                         0x0000007CL
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_DIES_MASK                                                         0x00000080L
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_NUM_SOCKETS_MASK                                                      0x00000100L
#define GCEA_ADDRNORM_BASE_ADDR0__INTLV_ADDR_SEL_MASK                                                         0x00000E00L
#define GCEA_ADDRNORM_BASE_ADDR0__BASE_ADDR_MASK                                                              0xFFFFF000L
//GCEA_ADDRNORM_LIMIT_ADDR0
#define GCEA_ADDRNORM_LIMIT_ADDR0__DST_FABRIC_ID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_LIMIT_ADDR0__LIMIT_ADDR__SHIFT                                                          0xc
#define GCEA_ADDRNORM_LIMIT_ADDR0__DST_FABRIC_ID_MASK                                                         0x0000001FL
#define GCEA_ADDRNORM_LIMIT_ADDR0__LIMIT_ADDR_MASK                                                            0xFFFFF000L
//GCEA_ADDRNORM_BASE_ADDR1
#define GCEA_ADDRNORM_BASE_ADDR1__ADDR_RNG_VAL__SHIFT                                                         0x0
#define GCEA_ADDRNORM_BASE_ADDR1__LGCY_MMIO_HOLE_EN__SHIFT                                                    0x1
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_CHAN__SHIFT                                                       0x2
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_DIES__SHIFT                                                       0x7
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_SOCKETS__SHIFT                                                    0x8
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_ADDR_SEL__SHIFT                                                       0x9
#define GCEA_ADDRNORM_BASE_ADDR1__BASE_ADDR__SHIFT                                                            0xc
#define GCEA_ADDRNORM_BASE_ADDR1__ADDR_RNG_VAL_MASK                                                           0x00000001L
#define GCEA_ADDRNORM_BASE_ADDR1__LGCY_MMIO_HOLE_EN_MASK                                                      0x00000002L
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_CHAN_MASK                                                         0x0000007CL
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_DIES_MASK                                                         0x00000080L
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_NUM_SOCKETS_MASK                                                      0x00000100L
#define GCEA_ADDRNORM_BASE_ADDR1__INTLV_ADDR_SEL_MASK                                                         0x00000E00L
#define GCEA_ADDRNORM_BASE_ADDR1__BASE_ADDR_MASK                                                              0xFFFFF000L
//GCEA_ADDRNORM_LIMIT_ADDR1
#define GCEA_ADDRNORM_LIMIT_ADDR1__DST_FABRIC_ID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_LIMIT_ADDR1__LIMIT_ADDR__SHIFT                                                          0xc
#define GCEA_ADDRNORM_LIMIT_ADDR1__DST_FABRIC_ID_MASK                                                         0x0000001FL
#define GCEA_ADDRNORM_LIMIT_ADDR1__LIMIT_ADDR_MASK                                                            0xFFFFF000L
//GCEA_ADDRNORM_OFFSET_ADDR1
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET_EN__SHIFT                                                  0x0
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET__SHIFT                                                     0xc
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET_EN_MASK                                                    0x00000001L
#define GCEA_ADDRNORM_OFFSET_ADDR1__HI_ADDR_OFFSET_MASK                                                       0x00FFF000L
//GCEA_ADDRNORM_BASE_ADDR2
#define GCEA_ADDRNORM_BASE_ADDR2__ADDR_RNG_VAL__SHIFT                                                         0x0
#define GCEA_ADDRNORM_BASE_ADDR2__LGCY_MMIO_HOLE_EN__SHIFT                                                    0x1
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_NUM_CHAN__SHIFT                                                       0x2
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_NUM_DIES__SHIFT                                                       0x7
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_NUM_SOCKETS__SHIFT                                                    0x8
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_ADDR_SEL__SHIFT                                                       0x9
#define GCEA_ADDRNORM_BASE_ADDR2__BASE_ADDR__SHIFT                                                            0xc
#define GCEA_ADDRNORM_BASE_ADDR2__ADDR_RNG_VAL_MASK                                                           0x00000001L
#define GCEA_ADDRNORM_BASE_ADDR2__LGCY_MMIO_HOLE_EN_MASK                                                      0x00000002L
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_NUM_CHAN_MASK                                                         0x0000007CL
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_NUM_DIES_MASK                                                         0x00000080L
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_NUM_SOCKETS_MASK                                                      0x00000100L
#define GCEA_ADDRNORM_BASE_ADDR2__INTLV_ADDR_SEL_MASK                                                         0x00000E00L
#define GCEA_ADDRNORM_BASE_ADDR2__BASE_ADDR_MASK                                                              0xFFFFF000L
//GCEA_ADDRNORM_LIMIT_ADDR2
#define GCEA_ADDRNORM_LIMIT_ADDR2__DST_FABRIC_ID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_LIMIT_ADDR2__LIMIT_ADDR__SHIFT                                                          0xc
#define GCEA_ADDRNORM_LIMIT_ADDR2__DST_FABRIC_ID_MASK                                                         0x0000001FL
#define GCEA_ADDRNORM_LIMIT_ADDR2__LIMIT_ADDR_MASK                                                            0xFFFFF000L
//GCEA_ADDRNORM_BASE_ADDR3
#define GCEA_ADDRNORM_BASE_ADDR3__ADDR_RNG_VAL__SHIFT                                                         0x0
#define GCEA_ADDRNORM_BASE_ADDR3__LGCY_MMIO_HOLE_EN__SHIFT                                                    0x1
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_NUM_CHAN__SHIFT                                                       0x2
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_NUM_DIES__SHIFT                                                       0x7
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_NUM_SOCKETS__SHIFT                                                    0x8
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_ADDR_SEL__SHIFT                                                       0x9
#define GCEA_ADDRNORM_BASE_ADDR3__BASE_ADDR__SHIFT                                                            0xc
#define GCEA_ADDRNORM_BASE_ADDR3__ADDR_RNG_VAL_MASK                                                           0x00000001L
#define GCEA_ADDRNORM_BASE_ADDR3__LGCY_MMIO_HOLE_EN_MASK                                                      0x00000002L
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_NUM_CHAN_MASK                                                         0x0000007CL
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_NUM_DIES_MASK                                                         0x00000080L
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_NUM_SOCKETS_MASK                                                      0x00000100L
#define GCEA_ADDRNORM_BASE_ADDR3__INTLV_ADDR_SEL_MASK                                                         0x00000E00L
#define GCEA_ADDRNORM_BASE_ADDR3__BASE_ADDR_MASK                                                              0xFFFFF000L
//GCEA_ADDRNORM_LIMIT_ADDR3
#define GCEA_ADDRNORM_LIMIT_ADDR3__DST_FABRIC_ID__SHIFT                                                       0x0
#define GCEA_ADDRNORM_LIMIT_ADDR3__LIMIT_ADDR__SHIFT                                                          0xc
#define GCEA_ADDRNORM_LIMIT_ADDR3__DST_FABRIC_ID_MASK                                                         0x0000001FL
#define GCEA_ADDRNORM_LIMIT_ADDR3__LIMIT_ADDR_MASK                                                            0xFFFFF000L
//GCEA_ADDRNORM_OFFSET_ADDR3
#define GCEA_ADDRNORM_OFFSET_ADDR3__HI_ADDR_OFFSET_EN__SHIFT                                                  0x0
#define GCEA_ADDRNORM_OFFSET_ADDR3__HI_ADDR_OFFSET__SHIFT                                                     0xc
#define GCEA_ADDRNORM_OFFSET_ADDR3__HI_ADDR_OFFSET_EN_MASK                                                    0x00000001L
#define GCEA_ADDRNORM_OFFSET_ADDR3__HI_ADDR_OFFSET_MASK                                                       0x00FFF000L
//GCEA_ADDRNORM_MEGABASE_ADDR0
#define GCEA_ADDRNORM_MEGABASE_ADDR0__ADDR_RNG_VAL__SHIFT                                                     0x0
#define GCEA_ADDRNORM_MEGABASE_ADDR0__LGCY_MMIO_HOLE_EN__SHIFT                                                0x1
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_NUM_CHAN__SHIFT                                                   0x2
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_NUM_DIES__SHIFT                                                   0x7
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_NUM_SOCKETS__SHIFT                                                0x8
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_ADDR_SEL__SHIFT                                                   0x9
#define GCEA_ADDRNORM_MEGABASE_ADDR0__BASE_ADDR__SHIFT                                                        0xc
#define GCEA_ADDRNORM_MEGABASE_ADDR0__ADDR_RNG_VAL_MASK                                                       0x00000001L
#define GCEA_ADDRNORM_MEGABASE_ADDR0__LGCY_MMIO_HOLE_EN_MASK                                                  0x00000002L
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_NUM_CHAN_MASK                                                     0x0000007CL
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_NUM_DIES_MASK                                                     0x00000080L
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_NUM_SOCKETS_MASK                                                  0x00000100L
#define GCEA_ADDRNORM_MEGABASE_ADDR0__INTLV_ADDR_SEL_MASK                                                     0x00000E00L
#define GCEA_ADDRNORM_MEGABASE_ADDR0__BASE_ADDR_MASK                                                          0xFFFFF000L
//GCEA_ADDRNORM_MEGALIMIT_ADDR0
#define GCEA_ADDRNORM_MEGALIMIT_ADDR0__DST_FABRIC_ID__SHIFT                                                   0x0
#define GCEA_ADDRNORM_MEGALIMIT_ADDR0__LIMIT_ADDR__SHIFT                                                      0xc
#define GCEA_ADDRNORM_MEGALIMIT_ADDR0__DST_FABRIC_ID_MASK                                                     0x0000001FL
#define GCEA_ADDRNORM_MEGALIMIT_ADDR0__LIMIT_ADDR_MASK                                                        0xFFFFF000L
//GCEA_ADDRNORM_MEGABASE_ADDR1
#define GCEA_ADDRNORM_MEGABASE_ADDR1__ADDR_RNG_VAL__SHIFT                                                     0x0
#define GCEA_ADDRNORM_MEGABASE_ADDR1__LGCY_MMIO_HOLE_EN__SHIFT                                                0x1
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_NUM_CHAN__SHIFT                                                   0x2
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_NUM_DIES__SHIFT                                                   0x7
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_NUM_SOCKETS__SHIFT                                                0x8
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_ADDR_SEL__SHIFT                                                   0x9
#define GCEA_ADDRNORM_MEGABASE_ADDR1__BASE_ADDR__SHIFT                                                        0xc
#define GCEA_ADDRNORM_MEGABASE_ADDR1__ADDR_RNG_VAL_MASK                                                       0x00000001L
#define GCEA_ADDRNORM_MEGABASE_ADDR1__LGCY_MMIO_HOLE_EN_MASK                                                  0x00000002L
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_NUM_CHAN_MASK                                                     0x0000007CL
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_NUM_DIES_MASK                                                     0x00000080L
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_NUM_SOCKETS_MASK                                                  0x00000100L
#define GCEA_ADDRNORM_MEGABASE_ADDR1__INTLV_ADDR_SEL_MASK                                                     0x00000E00L
#define GCEA_ADDRNORM_MEGABASE_ADDR1__BASE_ADDR_MASK                                                          0xFFFFF000L
//GCEA_ADDRNORM_MEGALIMIT_ADDR1
#define GCEA_ADDRNORM_MEGALIMIT_ADDR1__DST_FABRIC_ID__SHIFT                                                   0x0
#define GCEA_ADDRNORM_MEGALIMIT_ADDR1__LIMIT_ADDR__SHIFT                                                      0xc
#define GCEA_ADDRNORM_MEGALIMIT_ADDR1__DST_FABRIC_ID_MASK                                                     0x0000001FL
#define GCEA_ADDRNORM_MEGALIMIT_ADDR1__LIMIT_ADDR_MASK                                                        0xFFFFF000L
//GCEA_ADDRNORMDRAM_HOLE_CNTL
#define GCEA_ADDRNORMDRAM_HOLE_CNTL__DRAM_HOLE_VALID__SHIFT                                                   0x0
#define GCEA_ADDRNORMDRAM_HOLE_CNTL__DRAM_HOLE_OFFSET__SHIFT                                                  0x7
#define GCEA_ADDRNORMDRAM_HOLE_CNTL__DRAM_HOLE_VALID_MASK                                                     0x00000001L
#define GCEA_ADDRNORMDRAM_HOLE_CNTL__DRAM_HOLE_OFFSET_MASK                                                    0x0000FF80L
//GCEA_ADDRNORMGMI_HOLE_CNTL
#define GCEA_ADDRNORMGMI_HOLE_CNTL__DRAM_HOLE_VALID__SHIFT                                                    0x0
#define GCEA_ADDRNORMGMI_HOLE_CNTL__DRAM_HOLE_OFFSET__SHIFT                                                   0x7
#define GCEA_ADDRNORMGMI_HOLE_CNTL__DRAM_HOLE_VALID_MASK                                                      0x00000001L
#define GCEA_ADDRNORMGMI_HOLE_CNTL__DRAM_HOLE_OFFSET_MASK                                                     0x0000FF80L
//GCEA_ADDRNORMDRAM_NP2_CHANNEL_CFG
#define GCEA_ADDRNORMDRAM_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE0__SHIFT                                         0x0
#define GCEA_ADDRNORMDRAM_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE1__SHIFT                                         0x6
#define GCEA_ADDRNORMDRAM_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE0_MASK                                           0x0000003FL
#define GCEA_ADDRNORMDRAM_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE1_MASK                                           0x00000FC0L
//GCEA_ADDRNORMGMI_NP2_CHANNEL_CFG
#define GCEA_ADDRNORMGMI_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE2__SHIFT                                          0x0
#define GCEA_ADDRNORMGMI_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE3__SHIFT                                          0x6
#define GCEA_ADDRNORMGMI_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE2_MASK                                            0x0000003FL
#define GCEA_ADDRNORMGMI_NP2_CHANNEL_CFG__LOG2_ADDR64K_SPACE3_MASK                                            0x00000FC0L
//GCEA_ADDRDEC_BANK_CFG
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_DRAM__SHIFT                                                          0x0
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_GMI__SHIFT                                                           0x6
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_DRAM__SHIFT                                                      0xc
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_GMI__SHIFT                                                       0xf
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_DRAM__SHIFT                                               0x12
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_GMI__SHIFT                                                0x13
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_DRAM_MASK                                                            0x0000003FL
#define GCEA_ADDRDEC_BANK_CFG__BANK_MASK_GMI_MASK                                                             0x00000FC0L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_DRAM_MASK                                                        0x00007000L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_SEL_GMI_MASK                                                         0x00038000L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_DRAM_MASK                                                 0x00040000L
#define GCEA_ADDRDEC_BANK_CFG__BANKGROUP_INTERLEAVE_GMI_MASK                                                  0x00080000L
//GCEA_ADDRDEC_MISC_CFG
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN1__SHIFT                                                                 0x1
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN2__SHIFT                                                                 0x2
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_DRAM__SHIFT                                                           0x8
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_GMI__SHIFT                                                            0x9
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_DRAM__SHIFT                                                            0xc
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_GMI__SHIFT                                                             0x11
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_DRAM__SHIFT                                                            0x16
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_GMI__SHIFT                                                             0x18
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_DRAM__SHIFT                                                            0x1a
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_GMI__SHIFT                                                             0x1d
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN0_MASK                                                                   0x00000001L
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN1_MASK                                                                   0x00000002L
#define GCEA_ADDRDEC_MISC_CFG__VCM_EN2_MASK                                                                   0x00000004L
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_DRAM_MASK                                                             0x00000100L
#define GCEA_ADDRDEC_MISC_CFG__PCH_MASK_GMI_MASK                                                              0x00000200L
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_DRAM_MASK                                                              0x0001F000L
#define GCEA_ADDRDEC_MISC_CFG__CH_MASK_GMI_MASK                                                               0x003E0000L
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_DRAM_MASK                                                              0x00C00000L
#define GCEA_ADDRDEC_MISC_CFG__CS_MASK_GMI_MASK                                                               0x03000000L
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_DRAM_MASK                                                              0x1C000000L
#define GCEA_ADDRDEC_MISC_CFG__RM_MASK_GMI_MASK                                                               0xE0000000L
//GCEA_ADDRDECDRAM_HARVEST_ENABLE
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_EN__SHIFT                                                   0x0
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_VAL__SHIFT                                                  0x1
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_EN__SHIFT                                                   0x2
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_VAL__SHIFT                                                  0x3
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B5_EN__SHIFT                                                   0x4
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B5_VAL__SHIFT                                                  0x5
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_EN_MASK                                                     0x00000001L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B3_VAL_MASK                                                    0x00000002L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_EN_MASK                                                     0x00000004L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B4_VAL_MASK                                                    0x00000008L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B5_EN_MASK                                                     0x00000010L
#define GCEA_ADDRDECDRAM_HARVEST_ENABLE__FORCE_B5_VAL_MASK                                                    0x00000020L
//GCEA_ADDRDECGMI_HARVEST_ENABLE
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B3_EN__SHIFT                                                    0x0
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B3_VAL__SHIFT                                                   0x1
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B4_EN__SHIFT                                                    0x2
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B4_VAL__SHIFT                                                   0x3
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B5_EN__SHIFT                                                    0x4
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B5_VAL__SHIFT                                                   0x5
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B3_EN_MASK                                                      0x00000001L
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B3_VAL_MASK                                                     0x00000002L
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B4_EN_MASK                                                      0x00000004L
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B4_VAL_MASK                                                     0x00000008L
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B5_EN_MASK                                                      0x00000010L
#define GCEA_ADDRDECGMI_HARVEST_ENABLE__FORCE_B5_VAL_MASK                                                     0x00000020L
//GCEA_ADDRDEC0_BASE_ADDR_CS0
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS0__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_CS1
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS1__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_CS2
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS2__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_CS3
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_CS3__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS0__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS1__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS2
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS2__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_BASE_ADDR_SECCS3
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC0_BASE_ADDR_SECCS3__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_CS01
#define GCEA_ADDRDEC0_ADDR_MASK_CS01__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC0_ADDR_MASK_CS01__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_CS23
#define GCEA_ADDRDEC0_ADDR_MASK_CS23__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC0_ADDR_MASK_CS23__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_SECCS01
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS01__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS01__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_MASK_SECCS23
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS23__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC0_ADDR_MASK_SECCS23__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC0_ADDR_CFG_CS01
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANK_GROUPS__SHIFT                                                   0x1
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__HI_COL_EN__SHIFT                                                         0x1f
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANK_GROUPS_MASK                                                     0x0000000EL
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__NUM_BANKS_MASK                                                           0x00300000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS01__HI_COL_EN_MASK                                                           0x80000000L
//GCEA_ADDRDEC0_ADDR_CFG_CS23
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANK_GROUPS__SHIFT                                                   0x1
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__HI_COL_EN__SHIFT                                                         0x1f
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANK_GROUPS_MASK                                                     0x0000000EL
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__NUM_BANKS_MASK                                                           0x00300000L
#define GCEA_ADDRDEC0_ADDR_CFG_CS23__HI_COL_EN_MASK                                                           0x80000000L
//GCEA_ADDRDEC0_ADDR_SEL_CS01
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__BANK4_MASK                                                               0x001F0000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS01__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_ADDR_SEL_CS23
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__BANK4_MASK                                                               0x001F0000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_ADDR_SEL_CS23__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_ADDR_SEL2_CS01
#define GCEA_ADDRDEC0_ADDR_SEL2_CS01__BANK5__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_ADDR_SEL2_CS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC0_ADDR_SEL2_CS01__BANK5_MASK                                                              0x0000001FL
#define GCEA_ADDRDEC0_ADDR_SEL2_CS01__CHAN_BIT_MASK                                                           0x0000F000L
//GCEA_ADDRDEC0_ADDR_SEL2_CS23
#define GCEA_ADDRDEC0_ADDR_SEL2_CS23__BANK5__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_ADDR_SEL2_CS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC0_ADDR_SEL2_CS23__BANK5_MASK                                                              0x0000001FL
#define GCEA_ADDRDEC0_ADDR_SEL2_CS23__CHAN_BIT_MASK                                                           0x0000F000L
//GCEA_ADDRDEC0_COL_SEL_LO_CS01
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS01__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_LO_CS23
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_LO_CS23__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_HI_CS01
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS01__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC0_COL_SEL_HI_CS23
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC0_COL_SEL_HI_CS23__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC0_RM_SEL_CS01
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC0_RM_SEL_CS01__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_CS01__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_CS01__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_CS01__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC0_RM_SEL_CS23
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC0_RM_SEL_CS23__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_CS23__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_CS23__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_CS23__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC0_RM_SEL_SECCS01
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC0_RM_SEL_SECCS23
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC0_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC1_BASE_ADDR_CS0
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_CS0__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_CS1
#define GCEA_ADDRDEC1_BASE_ADDR_CS1__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC1_BASE_ADDR_CS1__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC1_BASE_ADDR_CS1__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_CS1__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_CS2
#define GCEA_ADDRDEC1_BASE_ADDR_CS2__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC1_BASE_ADDR_CS2__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC1_BASE_ADDR_CS2__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_CS2__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_CS3
#define GCEA_ADDRDEC1_BASE_ADDR_CS3__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC1_BASE_ADDR_CS3__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC1_BASE_ADDR_CS3__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_CS3__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_SECCS0
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS0__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS0__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS0__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS0__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_SECCS1
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS1__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS1__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS1__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS1__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_SECCS2
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS2__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS2__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS2__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS2__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC1_BASE_ADDR_SECCS3
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS3__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS3__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS3__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC1_BASE_ADDR_SECCS3__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC1_ADDR_MASK_CS01
#define GCEA_ADDRDEC1_ADDR_MASK_CS01__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC1_ADDR_MASK_CS01__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC1_ADDR_MASK_CS23
#define GCEA_ADDRDEC1_ADDR_MASK_CS23__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC1_ADDR_MASK_CS23__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC1_ADDR_MASK_SECCS01
#define GCEA_ADDRDEC1_ADDR_MASK_SECCS01__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC1_ADDR_MASK_SECCS01__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC1_ADDR_MASK_SECCS23
#define GCEA_ADDRDEC1_ADDR_MASK_SECCS23__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC1_ADDR_MASK_SECCS23__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC1_ADDR_CFG_CS01
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_BANK_GROUPS__SHIFT                                                   0x1
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__HI_COL_EN__SHIFT                                                         0x1f
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_BANK_GROUPS_MASK                                                     0x0000000EL
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__NUM_BANKS_MASK                                                           0x00300000L
#define GCEA_ADDRDEC1_ADDR_CFG_CS01__HI_COL_EN_MASK                                                           0x80000000L
//GCEA_ADDRDEC1_ADDR_CFG_CS23
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_BANK_GROUPS__SHIFT                                                   0x1
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__HI_COL_EN__SHIFT                                                         0x1f
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_BANK_GROUPS_MASK                                                     0x0000000EL
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__NUM_BANKS_MASK                                                           0x00300000L
#define GCEA_ADDRDEC1_ADDR_CFG_CS23__HI_COL_EN_MASK                                                           0x80000000L
//GCEA_ADDRDEC1_ADDR_SEL_CS01
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__BANK4_MASK                                                               0x001F0000L
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC1_ADDR_SEL_CS01__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC1_ADDR_SEL_CS23
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__BANK4_MASK                                                               0x001F0000L
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC1_ADDR_SEL_CS23__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC1_ADDR_SEL2_CS01
#define GCEA_ADDRDEC1_ADDR_SEL2_CS01__BANK5__SHIFT                                                            0x0
#define GCEA_ADDRDEC1_ADDR_SEL2_CS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC1_ADDR_SEL2_CS01__BANK5_MASK                                                              0x0000001FL
#define GCEA_ADDRDEC1_ADDR_SEL2_CS01__CHAN_BIT_MASK                                                           0x0000F000L
//GCEA_ADDRDEC1_ADDR_SEL2_CS23
#define GCEA_ADDRDEC1_ADDR_SEL2_CS23__BANK5__SHIFT                                                            0x0
#define GCEA_ADDRDEC1_ADDR_SEL2_CS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC1_ADDR_SEL2_CS23__BANK5_MASK                                                              0x0000001FL
#define GCEA_ADDRDEC1_ADDR_SEL2_CS23__CHAN_BIT_MASK                                                           0x0000F000L
//GCEA_ADDRDEC1_COL_SEL_LO_CS01
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS01__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC1_COL_SEL_LO_CS23
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC1_COL_SEL_LO_CS23__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC1_COL_SEL_HI_CS01
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS01__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC1_COL_SEL_HI_CS23
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC1_COL_SEL_HI_CS23__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC1_RM_SEL_CS01
#define GCEA_ADDRDEC1_RM_SEL_CS01__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC1_RM_SEL_CS01__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC1_RM_SEL_CS01__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC1_RM_SEL_CS01__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC1_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC1_RM_SEL_CS01__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC1_RM_SEL_CS01__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC1_RM_SEL_CS01__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC1_RM_SEL_CS01__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC1_RM_SEL_CS01__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC1_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC1_RM_SEL_CS01__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC1_RM_SEL_CS23
#define GCEA_ADDRDEC1_RM_SEL_CS23__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC1_RM_SEL_CS23__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC1_RM_SEL_CS23__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC1_RM_SEL_CS23__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC1_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC1_RM_SEL_CS23__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC1_RM_SEL_CS23__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC1_RM_SEL_CS23__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC1_RM_SEL_CS23__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC1_RM_SEL_CS23__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC1_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC1_RM_SEL_CS23__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC1_RM_SEL_SECCS01
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC1_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC1_RM_SEL_SECCS23
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC1_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC2_BASE_ADDR_CS0
#define GCEA_ADDRDEC2_BASE_ADDR_CS0__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC2_BASE_ADDR_CS0__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC2_BASE_ADDR_CS0__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_CS0__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_CS1
#define GCEA_ADDRDEC2_BASE_ADDR_CS1__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC2_BASE_ADDR_CS1__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC2_BASE_ADDR_CS1__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_CS1__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_CS2
#define GCEA_ADDRDEC2_BASE_ADDR_CS2__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC2_BASE_ADDR_CS2__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC2_BASE_ADDR_CS2__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_CS2__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_CS3
#define GCEA_ADDRDEC2_BASE_ADDR_CS3__CS_EN__SHIFT                                                             0x0
#define GCEA_ADDRDEC2_BASE_ADDR_CS3__BASE_ADDR__SHIFT                                                         0x1
#define GCEA_ADDRDEC2_BASE_ADDR_CS3__CS_EN_MASK                                                               0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_CS3__BASE_ADDR_MASK                                                           0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_SECCS0
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS0__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS0__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS0__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS0__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_SECCS1
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS1__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS1__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS1__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS1__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_SECCS2
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS2__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS2__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS2__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS2__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC2_BASE_ADDR_SECCS3
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS3__CS_EN__SHIFT                                                          0x0
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS3__BASE_ADDR__SHIFT                                                      0x1
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS3__CS_EN_MASK                                                            0x00000001L
#define GCEA_ADDRDEC2_BASE_ADDR_SECCS3__BASE_ADDR_MASK                                                        0xFFFFFFFEL
//GCEA_ADDRDEC2_ADDR_MASK_CS01
#define GCEA_ADDRDEC2_ADDR_MASK_CS01__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC2_ADDR_MASK_CS01__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC2_ADDR_MASK_CS23
#define GCEA_ADDRDEC2_ADDR_MASK_CS23__ADDR_MASK__SHIFT                                                        0x1
#define GCEA_ADDRDEC2_ADDR_MASK_CS23__ADDR_MASK_MASK                                                          0xFFFFFFFEL
//GCEA_ADDRDEC2_ADDR_MASK_SECCS01
#define GCEA_ADDRDEC2_ADDR_MASK_SECCS01__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC2_ADDR_MASK_SECCS01__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC2_ADDR_MASK_SECCS23
#define GCEA_ADDRDEC2_ADDR_MASK_SECCS23__ADDR_MASK__SHIFT                                                     0x1
#define GCEA_ADDRDEC2_ADDR_MASK_SECCS23__ADDR_MASK_MASK                                                       0xFFFFFFFEL
//GCEA_ADDRDEC2_ADDR_CFG_CS01
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_BANK_GROUPS__SHIFT                                                   0x1
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__HI_COL_EN__SHIFT                                                         0x1f
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_BANK_GROUPS_MASK                                                     0x0000000EL
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__NUM_BANKS_MASK                                                           0x00300000L
#define GCEA_ADDRDEC2_ADDR_CFG_CS01__HI_COL_EN_MASK                                                           0x80000000L
//GCEA_ADDRDEC2_ADDR_CFG_CS23
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_BANK_GROUPS__SHIFT                                                   0x1
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_RM__SHIFT                                                            0x4
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_ROW_LO__SHIFT                                                        0x8
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_ROW_HI__SHIFT                                                        0xc
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_COL__SHIFT                                                           0x10
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_BANKS__SHIFT                                                         0x14
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__HI_COL_EN__SHIFT                                                         0x1f
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_BANK_GROUPS_MASK                                                     0x0000000EL
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_RM_MASK                                                              0x00000030L
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_ROW_LO_MASK                                                          0x00000F00L
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_ROW_HI_MASK                                                          0x0000F000L
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_COL_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__NUM_BANKS_MASK                                                           0x00300000L
#define GCEA_ADDRDEC2_ADDR_CFG_CS23__HI_COL_EN_MASK                                                           0x80000000L
//GCEA_ADDRDEC2_ADDR_SEL_CS01
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__BANK4_MASK                                                               0x001F0000L
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC2_ADDR_SEL_CS01__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC2_ADDR_SEL_CS23
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK0__SHIFT                                                             0x0
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK1__SHIFT                                                             0x4
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK2__SHIFT                                                             0x8
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK3__SHIFT                                                             0xc
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK4__SHIFT                                                             0x10
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__ROW_LO__SHIFT                                                            0x18
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__ROW_HI__SHIFT                                                            0x1c
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK0_MASK                                                               0x0000000FL
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK1_MASK                                                               0x000000F0L
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK2_MASK                                                               0x00000F00L
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK3_MASK                                                               0x0000F000L
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__BANK4_MASK                                                               0x001F0000L
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__ROW_LO_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC2_ADDR_SEL_CS23__ROW_HI_MASK                                                              0xF0000000L
//GCEA_ADDRDEC2_ADDR_SEL2_CS01
#define GCEA_ADDRDEC2_ADDR_SEL2_CS01__BANK5__SHIFT                                                            0x0
#define GCEA_ADDRDEC2_ADDR_SEL2_CS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC2_ADDR_SEL2_CS01__BANK5_MASK                                                              0x0000001FL
#define GCEA_ADDRDEC2_ADDR_SEL2_CS01__CHAN_BIT_MASK                                                           0x0000F000L
//GCEA_ADDRDEC2_ADDR_SEL2_CS23
#define GCEA_ADDRDEC2_ADDR_SEL2_CS23__BANK5__SHIFT                                                            0x0
#define GCEA_ADDRDEC2_ADDR_SEL2_CS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC2_ADDR_SEL2_CS23__BANK5_MASK                                                              0x0000001FL
#define GCEA_ADDRDEC2_ADDR_SEL2_CS23__CHAN_BIT_MASK                                                           0x0000F000L
//GCEA_ADDRDEC2_COL_SEL_LO_CS01
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS01__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC2_COL_SEL_LO_CS23
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL0__SHIFT                                                            0x0
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL1__SHIFT                                                            0x4
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL2__SHIFT                                                            0x8
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL3__SHIFT                                                            0xc
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL4__SHIFT                                                            0x10
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL5__SHIFT                                                            0x14
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL6__SHIFT                                                            0x18
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL7__SHIFT                                                            0x1c
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL0_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL1_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL2_MASK                                                              0x00000F00L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL3_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL4_MASK                                                              0x000F0000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL5_MASK                                                              0x00F00000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL6_MASK                                                              0x0F000000L
#define GCEA_ADDRDEC2_COL_SEL_LO_CS23__COL7_MASK                                                              0xF0000000L
//GCEA_ADDRDEC2_COL_SEL_HI_CS01
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS01__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC2_COL_SEL_HI_CS23
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL8__SHIFT                                                            0x0
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL9__SHIFT                                                            0x4
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL10__SHIFT                                                           0x8
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL11__SHIFT                                                           0xc
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL12__SHIFT                                                           0x10
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL13__SHIFT                                                           0x14
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL14__SHIFT                                                           0x18
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL15__SHIFT                                                           0x1c
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL8_MASK                                                              0x0000000FL
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL9_MASK                                                              0x000000F0L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL10_MASK                                                             0x00000F00L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL11_MASK                                                             0x0000F000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL12_MASK                                                             0x000F0000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL13_MASK                                                             0x00F00000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL14_MASK                                                             0x0F000000L
#define GCEA_ADDRDEC2_COL_SEL_HI_CS23__COL15_MASK                                                             0xF0000000L
//GCEA_ADDRDEC2_RM_SEL_CS01
#define GCEA_ADDRDEC2_RM_SEL_CS01__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC2_RM_SEL_CS01__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC2_RM_SEL_CS01__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC2_RM_SEL_CS01__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC2_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC2_RM_SEL_CS01__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC2_RM_SEL_CS01__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC2_RM_SEL_CS01__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC2_RM_SEL_CS01__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC2_RM_SEL_CS01__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC2_RM_SEL_CS01__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC2_RM_SEL_CS01__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC2_RM_SEL_CS23
#define GCEA_ADDRDEC2_RM_SEL_CS23__RM0__SHIFT                                                                 0x0
#define GCEA_ADDRDEC2_RM_SEL_CS23__RM1__SHIFT                                                                 0x4
#define GCEA_ADDRDEC2_RM_SEL_CS23__RM2__SHIFT                                                                 0x8
#define GCEA_ADDRDEC2_RM_SEL_CS23__CHAN_BIT__SHIFT                                                            0xc
#define GCEA_ADDRDEC2_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN__SHIFT                                                0x10
#define GCEA_ADDRDEC2_RM_SEL_CS23__INVERT_ROW_MSBS_ODD__SHIFT                                                 0x12
#define GCEA_ADDRDEC2_RM_SEL_CS23__RM0_MASK                                                                   0x0000000FL
#define GCEA_ADDRDEC2_RM_SEL_CS23__RM1_MASK                                                                   0x000000F0L
#define GCEA_ADDRDEC2_RM_SEL_CS23__RM2_MASK                                                                   0x00000F00L
#define GCEA_ADDRDEC2_RM_SEL_CS23__CHAN_BIT_MASK                                                              0x0000F000L
#define GCEA_ADDRDEC2_RM_SEL_CS23__INVERT_ROW_MSBS_EVEN_MASK                                                  0x00030000L
#define GCEA_ADDRDEC2_RM_SEL_CS23__INVERT_ROW_MSBS_ODD_MASK                                                   0x000C0000L
//GCEA_ADDRDEC2_RM_SEL_SECCS01
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC2_RM_SEL_SECCS01__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRDEC2_RM_SEL_SECCS23
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__RM0__SHIFT                                                              0x0
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__RM1__SHIFT                                                              0x4
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__RM2__SHIFT                                                              0x8
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__CHAN_BIT__SHIFT                                                         0xc
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN__SHIFT                                             0x10
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD__SHIFT                                              0x12
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__RM0_MASK                                                                0x0000000FL
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__RM1_MASK                                                                0x000000F0L
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__RM2_MASK                                                                0x00000F00L
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__CHAN_BIT_MASK                                                           0x0000F000L
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__INVERT_ROW_MSBS_EVEN_MASK                                               0x00030000L
#define GCEA_ADDRDEC2_RM_SEL_SECCS23__INVERT_ROW_MSBS_ODD_MASK                                                0x000C0000L
//GCEA_ADDRNORMDRAM_GLOBAL_CNTL
//GCEA_ADDRNORMGMI_GLOBAL_CNTL
//GCEA_ADDRNORM_MEGACONTROL_ADDR0
#define GCEA_ADDRNORM_MEGACONTROL_ADDR0__LOG2_DIE_ADDR64K_SPACE__SHIFT                                        0x0
#define GCEA_ADDRNORM_MEGACONTROL_ADDR0__LOG2_DIE_ADDR64K_SPACE_MASK                                          0x0000003FL
//GCEA_ADDRNORM_MEGACONTROL_ADDR1
#define GCEA_ADDRNORM_MEGACONTROL_ADDR1__LOG2_DIE_ADDR64K_SPACE__SHIFT                                        0x0
#define GCEA_ADDRNORM_MEGACONTROL_ADDR1__LOG2_DIE_ADDR64K_SPACE_MASK                                          0x0000003FL
//GCEA_ADDRNORMDRAM_MASKING
#define GCEA_ADDRNORMDRAM_MASKING__ADDRHI_MASK__SHIFT                                                         0x0
#define GCEA_ADDRNORMDRAM_MASKING__ADDRHI_MASK_MASK                                                           0x00000FFFL
//GCEA_ADDRNORMGMI_MASKING
#define GCEA_ADDRNORMGMI_MASKING__ADDRHI_MASK__SHIFT                                                          0x0
#define GCEA_ADDRNORMGMI_MASKING__ADDRHI_MASK_MASK                                                            0x00000FFFL
//GCEA_IO_RD_CLI2GRP_MAP0
#define GCEA_IO_RD_CLI2GRP_MAP0__CID0_GROUP__SHIFT                                                            0x0
#define GCEA_IO_RD_CLI2GRP_MAP0__CID1_GROUP__SHIFT                                                            0x2
#define GCEA_IO_RD_CLI2GRP_MAP0__CID2_GROUP__SHIFT                                                            0x4
#define GCEA_IO_RD_CLI2GRP_MAP0__CID3_GROUP__SHIFT                                                            0x6
#define GCEA_IO_RD_CLI2GRP_MAP0__CID4_GROUP__SHIFT                                                            0x8
#define GCEA_IO_RD_CLI2GRP_MAP0__CID5_GROUP__SHIFT                                                            0xa
#define GCEA_IO_RD_CLI2GRP_MAP0__CID6_GROUP__SHIFT                                                            0xc
#define GCEA_IO_RD_CLI2GRP_MAP0__CID7_GROUP__SHIFT                                                            0xe
#define GCEA_IO_RD_CLI2GRP_MAP0__CID8_GROUP__SHIFT                                                            0x10
#define GCEA_IO_RD_CLI2GRP_MAP0__CID9_GROUP__SHIFT                                                            0x12
#define GCEA_IO_RD_CLI2GRP_MAP0__CID10_GROUP__SHIFT                                                           0x14
#define GCEA_IO_RD_CLI2GRP_MAP0__CID11_GROUP__SHIFT                                                           0x16
#define GCEA_IO_RD_CLI2GRP_MAP0__CID12_GROUP__SHIFT                                                           0x18
#define GCEA_IO_RD_CLI2GRP_MAP0__CID13_GROUP__SHIFT                                                           0x1a
#define GCEA_IO_RD_CLI2GRP_MAP0__CID14_GROUP__SHIFT                                                           0x1c
#define GCEA_IO_RD_CLI2GRP_MAP0__CID15_GROUP__SHIFT                                                           0x1e
#define GCEA_IO_RD_CLI2GRP_MAP0__CID0_GROUP_MASK                                                              0x00000003L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID1_GROUP_MASK                                                              0x0000000CL
#define GCEA_IO_RD_CLI2GRP_MAP0__CID2_GROUP_MASK                                                              0x00000030L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID3_GROUP_MASK                                                              0x000000C0L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID4_GROUP_MASK                                                              0x00000300L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID5_GROUP_MASK                                                              0x00000C00L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID6_GROUP_MASK                                                              0x00003000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID7_GROUP_MASK                                                              0x0000C000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID8_GROUP_MASK                                                              0x00030000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID9_GROUP_MASK                                                              0x000C0000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID10_GROUP_MASK                                                             0x00300000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID11_GROUP_MASK                                                             0x00C00000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID12_GROUP_MASK                                                             0x03000000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID13_GROUP_MASK                                                             0x0C000000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID14_GROUP_MASK                                                             0x30000000L
#define GCEA_IO_RD_CLI2GRP_MAP0__CID15_GROUP_MASK                                                             0xC0000000L
//GCEA_IO_RD_CLI2GRP_MAP1
#define GCEA_IO_RD_CLI2GRP_MAP1__CID16_GROUP__SHIFT                                                           0x0
#define GCEA_IO_RD_CLI2GRP_MAP1__CID17_GROUP__SHIFT                                                           0x2
#define GCEA_IO_RD_CLI2GRP_MAP1__CID18_GROUP__SHIFT                                                           0x4
#define GCEA_IO_RD_CLI2GRP_MAP1__CID19_GROUP__SHIFT                                                           0x6
#define GCEA_IO_RD_CLI2GRP_MAP1__CID20_GROUP__SHIFT                                                           0x8
#define GCEA_IO_RD_CLI2GRP_MAP1__CID21_GROUP__SHIFT                                                           0xa
#define GCEA_IO_RD_CLI2GRP_MAP1__CID22_GROUP__SHIFT                                                           0xc
#define GCEA_IO_RD_CLI2GRP_MAP1__CID23_GROUP__SHIFT                                                           0xe
#define GCEA_IO_RD_CLI2GRP_MAP1__CID24_GROUP__SHIFT                                                           0x10
#define GCEA_IO_RD_CLI2GRP_MAP1__CID25_GROUP__SHIFT                                                           0x12
#define GCEA_IO_RD_CLI2GRP_MAP1__CID26_GROUP__SHIFT                                                           0x14
#define GCEA_IO_RD_CLI2GRP_MAP1__CID27_GROUP__SHIFT                                                           0x16
#define GCEA_IO_RD_CLI2GRP_MAP1__CID28_GROUP__SHIFT                                                           0x18
#define GCEA_IO_RD_CLI2GRP_MAP1__CID29_GROUP__SHIFT                                                           0x1a
#define GCEA_IO_RD_CLI2GRP_MAP1__CID30_GROUP__SHIFT                                                           0x1c
#define GCEA_IO_RD_CLI2GRP_MAP1__CID31_GROUP__SHIFT                                                           0x1e
#define GCEA_IO_RD_CLI2GRP_MAP1__CID16_GROUP_MASK                                                             0x00000003L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID17_GROUP_MASK                                                             0x0000000CL
#define GCEA_IO_RD_CLI2GRP_MAP1__CID18_GROUP_MASK                                                             0x00000030L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID19_GROUP_MASK                                                             0x000000C0L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID20_GROUP_MASK                                                             0x00000300L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID21_GROUP_MASK                                                             0x00000C00L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID22_GROUP_MASK                                                             0x00003000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID23_GROUP_MASK                                                             0x0000C000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID24_GROUP_MASK                                                             0x00030000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID25_GROUP_MASK                                                             0x000C0000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID26_GROUP_MASK                                                             0x00300000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID27_GROUP_MASK                                                             0x00C00000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID28_GROUP_MASK                                                             0x03000000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID29_GROUP_MASK                                                             0x0C000000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID30_GROUP_MASK                                                             0x30000000L
#define GCEA_IO_RD_CLI2GRP_MAP1__CID31_GROUP_MASK                                                             0xC0000000L
//GCEA_IO_WR_CLI2GRP_MAP0
#define GCEA_IO_WR_CLI2GRP_MAP0__CID0_GROUP__SHIFT                                                            0x0
#define GCEA_IO_WR_CLI2GRP_MAP0__CID1_GROUP__SHIFT                                                            0x2
#define GCEA_IO_WR_CLI2GRP_MAP0__CID2_GROUP__SHIFT                                                            0x4
#define GCEA_IO_WR_CLI2GRP_MAP0__CID3_GROUP__SHIFT                                                            0x6
#define GCEA_IO_WR_CLI2GRP_MAP0__CID4_GROUP__SHIFT                                                            0x8
#define GCEA_IO_WR_CLI2GRP_MAP0__CID5_GROUP__SHIFT                                                            0xa
#define GCEA_IO_WR_CLI2GRP_MAP0__CID6_GROUP__SHIFT                                                            0xc
#define GCEA_IO_WR_CLI2GRP_MAP0__CID7_GROUP__SHIFT                                                            0xe
#define GCEA_IO_WR_CLI2GRP_MAP0__CID8_GROUP__SHIFT                                                            0x10
#define GCEA_IO_WR_CLI2GRP_MAP0__CID9_GROUP__SHIFT                                                            0x12
#define GCEA_IO_WR_CLI2GRP_MAP0__CID10_GROUP__SHIFT                                                           0x14
#define GCEA_IO_WR_CLI2GRP_MAP0__CID11_GROUP__SHIFT                                                           0x16
#define GCEA_IO_WR_CLI2GRP_MAP0__CID12_GROUP__SHIFT                                                           0x18
#define GCEA_IO_WR_CLI2GRP_MAP0__CID13_GROUP__SHIFT                                                           0x1a
#define GCEA_IO_WR_CLI2GRP_MAP0__CID14_GROUP__SHIFT                                                           0x1c
#define GCEA_IO_WR_CLI2GRP_MAP0__CID15_GROUP__SHIFT                                                           0x1e
#define GCEA_IO_WR_CLI2GRP_MAP0__CID0_GROUP_MASK                                                              0x00000003L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID1_GROUP_MASK                                                              0x0000000CL
#define GCEA_IO_WR_CLI2GRP_MAP0__CID2_GROUP_MASK                                                              0x00000030L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID3_GROUP_MASK                                                              0x000000C0L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID4_GROUP_MASK                                                              0x00000300L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID5_GROUP_MASK                                                              0x00000C00L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID6_GROUP_MASK                                                              0x00003000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID7_GROUP_MASK                                                              0x0000C000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID8_GROUP_MASK                                                              0x00030000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID9_GROUP_MASK                                                              0x000C0000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID10_GROUP_MASK                                                             0x00300000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID11_GROUP_MASK                                                             0x00C00000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID12_GROUP_MASK                                                             0x03000000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID13_GROUP_MASK                                                             0x0C000000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID14_GROUP_MASK                                                             0x30000000L
#define GCEA_IO_WR_CLI2GRP_MAP0__CID15_GROUP_MASK                                                             0xC0000000L
//GCEA_IO_WR_CLI2GRP_MAP1
#define GCEA_IO_WR_CLI2GRP_MAP1__CID16_GROUP__SHIFT                                                           0x0
#define GCEA_IO_WR_CLI2GRP_MAP1__CID17_GROUP__SHIFT                                                           0x2
#define GCEA_IO_WR_CLI2GRP_MAP1__CID18_GROUP__SHIFT                                                           0x4
#define GCEA_IO_WR_CLI2GRP_MAP1__CID19_GROUP__SHIFT                                                           0x6
#define GCEA_IO_WR_CLI2GRP_MAP1__CID20_GROUP__SHIFT                                                           0x8
#define GCEA_IO_WR_CLI2GRP_MAP1__CID21_GROUP__SHIFT                                                           0xa
#define GCEA_IO_WR_CLI2GRP_MAP1__CID22_GROUP__SHIFT                                                           0xc
#define GCEA_IO_WR_CLI2GRP_MAP1__CID23_GROUP__SHIFT                                                           0xe
#define GCEA_IO_WR_CLI2GRP_MAP1__CID24_GROUP__SHIFT                                                           0x10
#define GCEA_IO_WR_CLI2GRP_MAP1__CID25_GROUP__SHIFT                                                           0x12
#define GCEA_IO_WR_CLI2GRP_MAP1__CID26_GROUP__SHIFT                                                           0x14
#define GCEA_IO_WR_CLI2GRP_MAP1__CID27_GROUP__SHIFT                                                           0x16
#define GCEA_IO_WR_CLI2GRP_MAP1__CID28_GROUP__SHIFT                                                           0x18
#define GCEA_IO_WR_CLI2GRP_MAP1__CID29_GROUP__SHIFT                                                           0x1a
#define GCEA_IO_WR_CLI2GRP_MAP1__CID30_GROUP__SHIFT                                                           0x1c
#define GCEA_IO_WR_CLI2GRP_MAP1__CID31_GROUP__SHIFT                                                           0x1e
#define GCEA_IO_WR_CLI2GRP_MAP1__CID16_GROUP_MASK                                                             0x00000003L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID17_GROUP_MASK                                                             0x0000000CL
#define GCEA_IO_WR_CLI2GRP_MAP1__CID18_GROUP_MASK                                                             0x00000030L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID19_GROUP_MASK                                                             0x000000C0L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID20_GROUP_MASK                                                             0x00000300L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID21_GROUP_MASK                                                             0x00000C00L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID22_GROUP_MASK                                                             0x00003000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID23_GROUP_MASK                                                             0x0000C000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID24_GROUP_MASK                                                             0x00030000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID25_GROUP_MASK                                                             0x000C0000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID26_GROUP_MASK                                                             0x00300000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID27_GROUP_MASK                                                             0x00C00000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID28_GROUP_MASK                                                             0x03000000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID29_GROUP_MASK                                                             0x0C000000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID30_GROUP_MASK                                                             0x30000000L
#define GCEA_IO_WR_CLI2GRP_MAP1__CID31_GROUP_MASK                                                             0xC0000000L
//GCEA_IO_RD_COMBINE_FLUSH
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP0_TIMER__SHIFT                                                         0x0
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP1_TIMER__SHIFT                                                         0x4
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP2_TIMER__SHIFT                                                         0x8
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP3_TIMER__SHIFT                                                         0xc
#define GCEA_IO_RD_COMBINE_FLUSH__COMB_MODE__SHIFT                                                            0x10
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP0_TIMER_MASK                                                           0x0000000FL
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP1_TIMER_MASK                                                           0x000000F0L
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP2_TIMER_MASK                                                           0x00000F00L
#define GCEA_IO_RD_COMBINE_FLUSH__GROUP3_TIMER_MASK                                                           0x0000F000L
#define GCEA_IO_RD_COMBINE_FLUSH__COMB_MODE_MASK                                                              0x00030000L
//GCEA_IO_WR_COMBINE_FLUSH
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP0_TIMER__SHIFT                                                         0x0
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP1_TIMER__SHIFT                                                         0x4
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP2_TIMER__SHIFT                                                         0x8
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP3_TIMER__SHIFT                                                         0xc
#define GCEA_IO_WR_COMBINE_FLUSH__COMB_MODE__SHIFT                                                            0x10
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP0_TIMER_MASK                                                           0x0000000FL
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP1_TIMER_MASK                                                           0x000000F0L
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP2_TIMER_MASK                                                           0x00000F00L
#define GCEA_IO_WR_COMBINE_FLUSH__GROUP3_TIMER_MASK                                                           0x0000F000L
#define GCEA_IO_WR_COMBINE_FLUSH__COMB_MODE_MASK                                                              0x00030000L
//GCEA_IO_GROUP_BURST
#define GCEA_IO_GROUP_BURST__RD_LIMIT_LO__SHIFT                                                               0x0
#define GCEA_IO_GROUP_BURST__RD_LIMIT_HI__SHIFT                                                               0x8
#define GCEA_IO_GROUP_BURST__WR_LIMIT_LO__SHIFT                                                               0x10
#define GCEA_IO_GROUP_BURST__WR_LIMIT_HI__SHIFT                                                               0x18
#define GCEA_IO_GROUP_BURST__RD_LIMIT_LO_MASK                                                                 0x000000FFL
#define GCEA_IO_GROUP_BURST__RD_LIMIT_HI_MASK                                                                 0x0000FF00L
#define GCEA_IO_GROUP_BURST__WR_LIMIT_LO_MASK                                                                 0x00FF0000L
#define GCEA_IO_GROUP_BURST__WR_LIMIT_HI_MASK                                                                 0xFF000000L
//GCEA_IO_RD_PRI_AGE
#define GCEA_IO_RD_PRI_AGE__GROUP0_AGING_RATE__SHIFT                                                          0x0
#define GCEA_IO_RD_PRI_AGE__GROUP1_AGING_RATE__SHIFT                                                          0x3
#define GCEA_IO_RD_PRI_AGE__GROUP2_AGING_RATE__SHIFT                                                          0x6
#define GCEA_IO_RD_PRI_AGE__GROUP3_AGING_RATE__SHIFT                                                          0x9
#define GCEA_IO_RD_PRI_AGE__GROUP0_AGE_COEFFICIENT__SHIFT                                                     0xc
#define GCEA_IO_RD_PRI_AGE__GROUP1_AGE_COEFFICIENT__SHIFT                                                     0xf
#define GCEA_IO_RD_PRI_AGE__GROUP2_AGE_COEFFICIENT__SHIFT                                                     0x12
#define GCEA_IO_RD_PRI_AGE__GROUP3_AGE_COEFFICIENT__SHIFT                                                     0x15
#define GCEA_IO_RD_PRI_AGE__GROUP0_AGING_RATE_MASK                                                            0x00000007L
#define GCEA_IO_RD_PRI_AGE__GROUP1_AGING_RATE_MASK                                                            0x00000038L
#define GCEA_IO_RD_PRI_AGE__GROUP2_AGING_RATE_MASK                                                            0x000001C0L
#define GCEA_IO_RD_PRI_AGE__GROUP3_AGING_RATE_MASK                                                            0x00000E00L
#define GCEA_IO_RD_PRI_AGE__GROUP0_AGE_COEFFICIENT_MASK                                                       0x00007000L
#define GCEA_IO_RD_PRI_AGE__GROUP1_AGE_COEFFICIENT_MASK                                                       0x00038000L
#define GCEA_IO_RD_PRI_AGE__GROUP2_AGE_COEFFICIENT_MASK                                                       0x001C0000L
#define GCEA_IO_RD_PRI_AGE__GROUP3_AGE_COEFFICIENT_MASK                                                       0x00E00000L
//GCEA_IO_WR_PRI_AGE
#define GCEA_IO_WR_PRI_AGE__GROUP0_AGING_RATE__SHIFT                                                          0x0
#define GCEA_IO_WR_PRI_AGE__GROUP1_AGING_RATE__SHIFT                                                          0x3
#define GCEA_IO_WR_PRI_AGE__GROUP2_AGING_RATE__SHIFT                                                          0x6
#define GCEA_IO_WR_PRI_AGE__GROUP3_AGING_RATE__SHIFT                                                          0x9
#define GCEA_IO_WR_PRI_AGE__GROUP0_AGE_COEFFICIENT__SHIFT                                                     0xc
#define GCEA_IO_WR_PRI_AGE__GROUP1_AGE_COEFFICIENT__SHIFT                                                     0xf
#define GCEA_IO_WR_PRI_AGE__GROUP2_AGE_COEFFICIENT__SHIFT                                                     0x12
#define GCEA_IO_WR_PRI_AGE__GROUP3_AGE_COEFFICIENT__SHIFT                                                     0x15
#define GCEA_IO_WR_PRI_AGE__GROUP0_AGING_RATE_MASK                                                            0x00000007L
#define GCEA_IO_WR_PRI_AGE__GROUP1_AGING_RATE_MASK                                                            0x00000038L
#define GCEA_IO_WR_PRI_AGE__GROUP2_AGING_RATE_MASK                                                            0x000001C0L
#define GCEA_IO_WR_PRI_AGE__GROUP3_AGING_RATE_MASK                                                            0x00000E00L
#define GCEA_IO_WR_PRI_AGE__GROUP0_AGE_COEFFICIENT_MASK                                                       0x00007000L
#define GCEA_IO_WR_PRI_AGE__GROUP1_AGE_COEFFICIENT_MASK                                                       0x00038000L
#define GCEA_IO_WR_PRI_AGE__GROUP2_AGE_COEFFICIENT_MASK                                                       0x001C0000L
#define GCEA_IO_WR_PRI_AGE__GROUP3_AGE_COEFFICIENT_MASK                                                       0x00E00000L
//GCEA_IO_RD_PRI_QUEUING
#define GCEA_IO_RD_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT__SHIFT                                             0x0
#define GCEA_IO_RD_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT__SHIFT                                             0x3
#define GCEA_IO_RD_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT__SHIFT                                             0x6
#define GCEA_IO_RD_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT__SHIFT                                             0x9
#define GCEA_IO_RD_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT_MASK                                               0x00000007L
#define GCEA_IO_RD_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT_MASK                                               0x00000038L
#define GCEA_IO_RD_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT_MASK                                               0x000001C0L
#define GCEA_IO_RD_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT_MASK                                               0x00000E00L
//GCEA_IO_WR_PRI_QUEUING
#define GCEA_IO_WR_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT__SHIFT                                             0x0
#define GCEA_IO_WR_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT__SHIFT                                             0x3
#define GCEA_IO_WR_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT__SHIFT                                             0x6
#define GCEA_IO_WR_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT__SHIFT                                             0x9
#define GCEA_IO_WR_PRI_QUEUING__GROUP0_QUEUING_COEFFICIENT_MASK                                               0x00000007L
#define GCEA_IO_WR_PRI_QUEUING__GROUP1_QUEUING_COEFFICIENT_MASK                                               0x00000038L
#define GCEA_IO_WR_PRI_QUEUING__GROUP2_QUEUING_COEFFICIENT_MASK                                               0x000001C0L
#define GCEA_IO_WR_PRI_QUEUING__GROUP3_QUEUING_COEFFICIENT_MASK                                               0x00000E00L
//GCEA_IO_RD_PRI_FIXED
#define GCEA_IO_RD_PRI_FIXED__GROUP0_FIXED_COEFFICIENT__SHIFT                                                 0x0
#define GCEA_IO_RD_PRI_FIXED__GROUP1_FIXED_COEFFICIENT__SHIFT                                                 0x3
#define GCEA_IO_RD_PRI_FIXED__GROUP2_FIXED_COEFFICIENT__SHIFT                                                 0x6
#define GCEA_IO_RD_PRI_FIXED__GROUP3_FIXED_COEFFICIENT__SHIFT                                                 0x9
#define GCEA_IO_RD_PRI_FIXED__GROUP0_FIXED_COEFFICIENT_MASK                                                   0x00000007L
#define GCEA_IO_RD_PRI_FIXED__GROUP1_FIXED_COEFFICIENT_MASK                                                   0x00000038L
#define GCEA_IO_RD_PRI_FIXED__GROUP2_FIXED_COEFFICIENT_MASK                                                   0x000001C0L
#define GCEA_IO_RD_PRI_FIXED__GROUP3_FIXED_COEFFICIENT_MASK                                                   0x00000E00L
//GCEA_IO_WR_PRI_FIXED
#define GCEA_IO_WR_PRI_FIXED__GROUP0_FIXED_COEFFICIENT__SHIFT                                                 0x0
#define GCEA_IO_WR_PRI_FIXED__GROUP1_FIXED_COEFFICIENT__SHIFT                                                 0x3
#define GCEA_IO_WR_PRI_FIXED__GROUP2_FIXED_COEFFICIENT__SHIFT                                                 0x6
#define GCEA_IO_WR_PRI_FIXED__GROUP3_FIXED_COEFFICIENT__SHIFT                                                 0x9
#define GCEA_IO_WR_PRI_FIXED__GROUP0_FIXED_COEFFICIENT_MASK                                                   0x00000007L
#define GCEA_IO_WR_PRI_FIXED__GROUP1_FIXED_COEFFICIENT_MASK                                                   0x00000038L
#define GCEA_IO_WR_PRI_FIXED__GROUP2_FIXED_COEFFICIENT_MASK                                                   0x000001C0L
#define GCEA_IO_WR_PRI_FIXED__GROUP3_FIXED_COEFFICIENT_MASK                                                   0x00000E00L
//GCEA_IO_RD_PRI_URGENCY
#define GCEA_IO_RD_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT__SHIFT                                             0x0
#define GCEA_IO_RD_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT__SHIFT                                             0x3
#define GCEA_IO_RD_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT__SHIFT                                             0x6
#define GCEA_IO_RD_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT__SHIFT                                             0x9
#define GCEA_IO_RD_PRI_URGENCY__GROUP0_URGENCY_MODE__SHIFT                                                    0xc
#define GCEA_IO_RD_PRI_URGENCY__GROUP1_URGENCY_MODE__SHIFT                                                    0xd
#define GCEA_IO_RD_PRI_URGENCY__GROUP2_URGENCY_MODE__SHIFT                                                    0xe
#define GCEA_IO_RD_PRI_URGENCY__GROUP3_URGENCY_MODE__SHIFT                                                    0xf
#define GCEA_IO_RD_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT_MASK                                               0x00000007L
#define GCEA_IO_RD_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT_MASK                                               0x00000038L
#define GCEA_IO_RD_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT_MASK                                               0x000001C0L
#define GCEA_IO_RD_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT_MASK                                               0x00000E00L
#define GCEA_IO_RD_PRI_URGENCY__GROUP0_URGENCY_MODE_MASK                                                      0x00001000L
#define GCEA_IO_RD_PRI_URGENCY__GROUP1_URGENCY_MODE_MASK                                                      0x00002000L
#define GCEA_IO_RD_PRI_URGENCY__GROUP2_URGENCY_MODE_MASK                                                      0x00004000L
#define GCEA_IO_RD_PRI_URGENCY__GROUP3_URGENCY_MODE_MASK                                                      0x00008000L
//GCEA_IO_WR_PRI_URGENCY
#define GCEA_IO_WR_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT__SHIFT                                             0x0
#define GCEA_IO_WR_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT__SHIFT                                             0x3
#define GCEA_IO_WR_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT__SHIFT                                             0x6
#define GCEA_IO_WR_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT__SHIFT                                             0x9
#define GCEA_IO_WR_PRI_URGENCY__GROUP0_URGENCY_MODE__SHIFT                                                    0xc
#define GCEA_IO_WR_PRI_URGENCY__GROUP1_URGENCY_MODE__SHIFT                                                    0xd
#define GCEA_IO_WR_PRI_URGENCY__GROUP2_URGENCY_MODE__SHIFT                                                    0xe
#define GCEA_IO_WR_PRI_URGENCY__GROUP3_URGENCY_MODE__SHIFT                                                    0xf
#define GCEA_IO_WR_PRI_URGENCY__GROUP0_URGENCY_COEFFICIENT_MASK                                               0x00000007L
#define GCEA_IO_WR_PRI_URGENCY__GROUP1_URGENCY_COEFFICIENT_MASK                                               0x00000038L
#define GCEA_IO_WR_PRI_URGENCY__GROUP2_URGENCY_COEFFICIENT_MASK                                               0x000001C0L
#define GCEA_IO_WR_PRI_URGENCY__GROUP3_URGENCY_COEFFICIENT_MASK                                               0x00000E00L
#define GCEA_IO_WR_PRI_URGENCY__GROUP0_URGENCY_MODE_MASK                                                      0x00001000L
#define GCEA_IO_WR_PRI_URGENCY__GROUP1_URGENCY_MODE_MASK                                                      0x00002000L
#define GCEA_IO_WR_PRI_URGENCY__GROUP2_URGENCY_MODE_MASK                                                      0x00004000L
#define GCEA_IO_WR_PRI_URGENCY__GROUP3_URGENCY_MODE_MASK                                                      0x00008000L
//GCEA_IO_RD_PRI_URGENCY_MASKING
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID0_MASK__SHIFT                                                      0x0
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID1_MASK__SHIFT                                                      0x1
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID2_MASK__SHIFT                                                      0x2
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID3_MASK__SHIFT                                                      0x3
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID4_MASK__SHIFT                                                      0x4
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID5_MASK__SHIFT                                                      0x5
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID6_MASK__SHIFT                                                      0x6
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID7_MASK__SHIFT                                                      0x7
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID8_MASK__SHIFT                                                      0x8
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID9_MASK__SHIFT                                                      0x9
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID10_MASK__SHIFT                                                     0xa
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID11_MASK__SHIFT                                                     0xb
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID12_MASK__SHIFT                                                     0xc
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID13_MASK__SHIFT                                                     0xd
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID14_MASK__SHIFT                                                     0xe
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID15_MASK__SHIFT                                                     0xf
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID16_MASK__SHIFT                                                     0x10
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID17_MASK__SHIFT                                                     0x11
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID18_MASK__SHIFT                                                     0x12
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID19_MASK__SHIFT                                                     0x13
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID20_MASK__SHIFT                                                     0x14
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID21_MASK__SHIFT                                                     0x15
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID22_MASK__SHIFT                                                     0x16
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID23_MASK__SHIFT                                                     0x17
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID24_MASK__SHIFT                                                     0x18
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID25_MASK__SHIFT                                                     0x19
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID26_MASK__SHIFT                                                     0x1a
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID27_MASK__SHIFT                                                     0x1b
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID28_MASK__SHIFT                                                     0x1c
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID29_MASK__SHIFT                                                     0x1d
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID30_MASK__SHIFT                                                     0x1e
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID31_MASK__SHIFT                                                     0x1f
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID0_MASK_MASK                                                        0x00000001L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID1_MASK_MASK                                                        0x00000002L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID2_MASK_MASK                                                        0x00000004L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID3_MASK_MASK                                                        0x00000008L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID4_MASK_MASK                                                        0x00000010L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID5_MASK_MASK                                                        0x00000020L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID6_MASK_MASK                                                        0x00000040L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID7_MASK_MASK                                                        0x00000080L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID8_MASK_MASK                                                        0x00000100L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID9_MASK_MASK                                                        0x00000200L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID10_MASK_MASK                                                       0x00000400L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID11_MASK_MASK                                                       0x00000800L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID12_MASK_MASK                                                       0x00001000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID13_MASK_MASK                                                       0x00002000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID14_MASK_MASK                                                       0x00004000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID15_MASK_MASK                                                       0x00008000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID16_MASK_MASK                                                       0x00010000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID17_MASK_MASK                                                       0x00020000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID18_MASK_MASK                                                       0x00040000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID19_MASK_MASK                                                       0x00080000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID20_MASK_MASK                                                       0x00100000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID21_MASK_MASK                                                       0x00200000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID22_MASK_MASK                                                       0x00400000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID23_MASK_MASK                                                       0x00800000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID24_MASK_MASK                                                       0x01000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID25_MASK_MASK                                                       0x02000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID26_MASK_MASK                                                       0x04000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID27_MASK_MASK                                                       0x08000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID28_MASK_MASK                                                       0x10000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID29_MASK_MASK                                                       0x20000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID30_MASK_MASK                                                       0x40000000L
#define GCEA_IO_RD_PRI_URGENCY_MASKING__CID31_MASK_MASK                                                       0x80000000L
//GCEA_IO_WR_PRI_URGENCY_MASKING
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID0_MASK__SHIFT                                                      0x0
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID1_MASK__SHIFT                                                      0x1
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID2_MASK__SHIFT                                                      0x2
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID3_MASK__SHIFT                                                      0x3
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID4_MASK__SHIFT                                                      0x4
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID5_MASK__SHIFT                                                      0x5
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID6_MASK__SHIFT                                                      0x6
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID7_MASK__SHIFT                                                      0x7
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID8_MASK__SHIFT                                                      0x8
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID9_MASK__SHIFT                                                      0x9
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID10_MASK__SHIFT                                                     0xa
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID11_MASK__SHIFT                                                     0xb
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID12_MASK__SHIFT                                                     0xc
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID13_MASK__SHIFT                                                     0xd
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID14_MASK__SHIFT                                                     0xe
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID15_MASK__SHIFT                                                     0xf
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID16_MASK__SHIFT                                                     0x10
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID17_MASK__SHIFT                                                     0x11
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID18_MASK__SHIFT                                                     0x12
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID19_MASK__SHIFT                                                     0x13
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID20_MASK__SHIFT                                                     0x14
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID21_MASK__SHIFT                                                     0x15
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID22_MASK__SHIFT                                                     0x16
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID23_MASK__SHIFT                                                     0x17
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID24_MASK__SHIFT                                                     0x18
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID25_MASK__SHIFT                                                     0x19
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID26_MASK__SHIFT                                                     0x1a
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID27_MASK__SHIFT                                                     0x1b
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID28_MASK__SHIFT                                                     0x1c
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID29_MASK__SHIFT                                                     0x1d
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID30_MASK__SHIFT                                                     0x1e
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID31_MASK__SHIFT                                                     0x1f
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID0_MASK_MASK                                                        0x00000001L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID1_MASK_MASK                                                        0x00000002L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID2_MASK_MASK                                                        0x00000004L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID3_MASK_MASK                                                        0x00000008L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID4_MASK_MASK                                                        0x00000010L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID5_MASK_MASK                                                        0x00000020L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID6_MASK_MASK                                                        0x00000040L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID7_MASK_MASK                                                        0x00000080L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID8_MASK_MASK                                                        0x00000100L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID9_MASK_MASK                                                        0x00000200L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID10_MASK_MASK                                                       0x00000400L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID11_MASK_MASK                                                       0x00000800L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID12_MASK_MASK                                                       0x00001000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID13_MASK_MASK                                                       0x00002000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID14_MASK_MASK                                                       0x00004000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID15_MASK_MASK                                                       0x00008000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID16_MASK_MASK                                                       0x00010000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID17_MASK_MASK                                                       0x00020000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID18_MASK_MASK                                                       0x00040000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID19_MASK_MASK                                                       0x00080000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID20_MASK_MASK                                                       0x00100000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID21_MASK_MASK                                                       0x00200000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID22_MASK_MASK                                                       0x00400000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID23_MASK_MASK                                                       0x00800000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID24_MASK_MASK                                                       0x01000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID25_MASK_MASK                                                       0x02000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID26_MASK_MASK                                                       0x04000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID27_MASK_MASK                                                       0x08000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID28_MASK_MASK                                                       0x10000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID29_MASK_MASK                                                       0x20000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID30_MASK_MASK                                                       0x40000000L
#define GCEA_IO_WR_PRI_URGENCY_MASKING__CID31_MASK_MASK                                                       0x80000000L
//GCEA_IO_RD_PRI_QUANT_PRI1
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP0_THRESHOLD__SHIFT                                                    0x0
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP1_THRESHOLD__SHIFT                                                    0x8
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP2_THRESHOLD__SHIFT                                                    0x10
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP3_THRESHOLD__SHIFT                                                    0x18
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP0_THRESHOLD_MASK                                                      0x000000FFL
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP1_THRESHOLD_MASK                                                      0x0000FF00L
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP2_THRESHOLD_MASK                                                      0x00FF0000L
#define GCEA_IO_RD_PRI_QUANT_PRI1__GROUP3_THRESHOLD_MASK                                                      0xFF000000L
//GCEA_IO_RD_PRI_QUANT_PRI2
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP0_THRESHOLD__SHIFT                                                    0x0
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP1_THRESHOLD__SHIFT                                                    0x8
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP2_THRESHOLD__SHIFT                                                    0x10
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP3_THRESHOLD__SHIFT                                                    0x18
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP0_THRESHOLD_MASK                                                      0x000000FFL
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP1_THRESHOLD_MASK                                                      0x0000FF00L
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP2_THRESHOLD_MASK                                                      0x00FF0000L
#define GCEA_IO_RD_PRI_QUANT_PRI2__GROUP3_THRESHOLD_MASK                                                      0xFF000000L
//GCEA_IO_RD_PRI_QUANT_PRI3
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP0_THRESHOLD__SHIFT                                                    0x0
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP1_THRESHOLD__SHIFT                                                    0x8
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP2_THRESHOLD__SHIFT                                                    0x10
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP3_THRESHOLD__SHIFT                                                    0x18
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP0_THRESHOLD_MASK                                                      0x000000FFL
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP1_THRESHOLD_MASK                                                      0x0000FF00L
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP2_THRESHOLD_MASK                                                      0x00FF0000L
#define GCEA_IO_RD_PRI_QUANT_PRI3__GROUP3_THRESHOLD_MASK                                                      0xFF000000L
//GCEA_IO_WR_PRI_QUANT_PRI1
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP0_THRESHOLD__SHIFT                                                    0x0
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP1_THRESHOLD__SHIFT                                                    0x8
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP2_THRESHOLD__SHIFT                                                    0x10
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP3_THRESHOLD__SHIFT                                                    0x18
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP0_THRESHOLD_MASK                                                      0x000000FFL
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP1_THRESHOLD_MASK                                                      0x0000FF00L
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP2_THRESHOLD_MASK                                                      0x00FF0000L
#define GCEA_IO_WR_PRI_QUANT_PRI1__GROUP3_THRESHOLD_MASK                                                      0xFF000000L
//GCEA_IO_WR_PRI_QUANT_PRI2
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP0_THRESHOLD__SHIFT                                                    0x0
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP1_THRESHOLD__SHIFT                                                    0x8
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP2_THRESHOLD__SHIFT                                                    0x10
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP3_THRESHOLD__SHIFT                                                    0x18
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP0_THRESHOLD_MASK                                                      0x000000FFL
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP1_THRESHOLD_MASK                                                      0x0000FF00L
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP2_THRESHOLD_MASK                                                      0x00FF0000L
#define GCEA_IO_WR_PRI_QUANT_PRI2__GROUP3_THRESHOLD_MASK                                                      0xFF000000L
//GCEA_IO_WR_PRI_QUANT_PRI3
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP0_THRESHOLD__SHIFT                                                    0x0
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP1_THRESHOLD__SHIFT                                                    0x8
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP2_THRESHOLD__SHIFT                                                    0x10
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP3_THRESHOLD__SHIFT                                                    0x18
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP0_THRESHOLD_MASK                                                      0x000000FFL
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP1_THRESHOLD_MASK                                                      0x0000FF00L
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP2_THRESHOLD_MASK                                                      0x00FF0000L
#define GCEA_IO_WR_PRI_QUANT_PRI3__GROUP3_THRESHOLD_MASK                                                      0xFF000000L
//GCEA_MISC
#define GCEA_MISC__RELATIVE_PRI_IN_DRAM_RD_ARB__SHIFT                                                         0x0
#define GCEA_MISC__RELATIVE_PRI_IN_DRAM_WR_ARB__SHIFT                                                         0x1
#define GCEA_MISC__RELATIVE_PRI_IN_GMI_RD_ARB__SHIFT                                                          0x2
#define GCEA_MISC__RELATIVE_PRI_IN_GMI_WR_ARB__SHIFT                                                          0x3
#define GCEA_MISC__RELATIVE_PRI_IN_IO_RD_ARB__SHIFT                                                           0x4
#define GCEA_MISC__RELATIVE_PRI_IN_IO_WR_ARB__SHIFT                                                           0x5
#define GCEA_MISC__EARLYWRRET_ENABLE_VC0__SHIFT                                                               0x6
#define GCEA_MISC__EARLYWRRET_ENABLE_VC1__SHIFT                                                               0x7
#define GCEA_MISC__EARLYWRRET_ENABLE_VC2__SHIFT                                                               0x8
#define GCEA_MISC__EARLYWRRET_ENABLE_VC3__SHIFT                                                               0x9
#define GCEA_MISC__EARLYWRRET_ENABLE_VC4__SHIFT                                                               0xa
#define GCEA_MISC__EARLYWRRET_ENABLE_VC5__SHIFT                                                               0xb
#define GCEA_MISC__EARLYWRRET_ENABLE_VC6__SHIFT                                                               0xc
#define GCEA_MISC__EARLYWRRET_ENABLE_VC7__SHIFT                                                               0xd
#define GCEA_MISC__EARLY_SDP_ORIGDATA__SHIFT                                                                  0xe
#define GCEA_MISC__LINKMGR_DYNAMIC_MODE__SHIFT                                                                0xf
#define GCEA_MISC__LINKMGR_HALT_THRESHOLD__SHIFT                                                              0x11
#define GCEA_MISC__LINKMGR_RECONNECT_DELAY__SHIFT                                                             0x13
#define GCEA_MISC__LINKMGR_IDLE_THRESHOLD__SHIFT                                                              0x15
#define GCEA_MISC__FAVOUR_MIDCHAIN_CS_IN_DRAM_ARB__SHIFT                                                      0x1a
#define GCEA_MISC__FAVOUR_MIDCHAIN_CS_IN_GMI_ARB__SHIFT                                                       0x1b
#define GCEA_MISC__FAVOUR_LAST_CS_IN_DRAM_ARB__SHIFT                                                          0x1c
#define GCEA_MISC__FAVOUR_LAST_CS_IN_GMI_ARB__SHIFT                                                           0x1d
#define GCEA_MISC__SWITCH_CS_ON_W2R_IN_DRAM_ARB__SHIFT                                                        0x1e
#define GCEA_MISC__SWITCH_CS_ON_W2R_IN_GMI_ARB__SHIFT                                                         0x1f
#define GCEA_MISC__RELATIVE_PRI_IN_DRAM_RD_ARB_MASK                                                           0x00000001L
#define GCEA_MISC__RELATIVE_PRI_IN_DRAM_WR_ARB_MASK                                                           0x00000002L
#define GCEA_MISC__RELATIVE_PRI_IN_GMI_RD_ARB_MASK                                                            0x00000004L
#define GCEA_MISC__RELATIVE_PRI_IN_GMI_WR_ARB_MASK                                                            0x00000008L
#define GCEA_MISC__RELATIVE_PRI_IN_IO_RD_ARB_MASK                                                             0x00000010L
#define GCEA_MISC__RELATIVE_PRI_IN_IO_WR_ARB_MASK                                                             0x00000020L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC0_MASK                                                                 0x00000040L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC1_MASK                                                                 0x00000080L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC2_MASK                                                                 0x00000100L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC3_MASK                                                                 0x00000200L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC4_MASK                                                                 0x00000400L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC5_MASK                                                                 0x00000800L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC6_MASK                                                                 0x00001000L
#define GCEA_MISC__EARLYWRRET_ENABLE_VC7_MASK                                                                 0x00002000L
#define GCEA_MISC__EARLY_SDP_ORIGDATA_MASK                                                                    0x00004000L
#define GCEA_MISC__LINKMGR_DYNAMIC_MODE_MASK                                                                  0x00018000L
#define GCEA_MISC__LINKMGR_HALT_THRESHOLD_MASK                                                                0x00060000L
#define GCEA_MISC__LINKMGR_RECONNECT_DELAY_MASK                                                               0x00180000L
#define GCEA_MISC__LINKMGR_IDLE_THRESHOLD_MASK                                                                0x03E00000L
#define GCEA_MISC__FAVOUR_MIDCHAIN_CS_IN_DRAM_ARB_MASK                                                        0x04000000L
#define GCEA_MISC__FAVOUR_MIDCHAIN_CS_IN_GMI_ARB_MASK                                                         0x08000000L
#define GCEA_MISC__FAVOUR_LAST_CS_IN_DRAM_ARB_MASK                                                            0x10000000L
#define GCEA_MISC__FAVOUR_LAST_CS_IN_GMI_ARB_MASK                                                             0x20000000L
#define GCEA_MISC__SWITCH_CS_ON_W2R_IN_DRAM_ARB_MASK                                                          0x40000000L
#define GCEA_MISC__SWITCH_CS_ON_W2R_IN_GMI_ARB_MASK                                                           0x80000000L
//GCEA_LATENCY_SAMPLING
#define GCEA_LATENCY_SAMPLING__SAMPLER0_DRAM__SHIFT                                                           0x0
#define GCEA_LATENCY_SAMPLING__SAMPLER1_DRAM__SHIFT                                                           0x1
#define GCEA_LATENCY_SAMPLING__SAMPLER0_GMI__SHIFT                                                            0x2
#define GCEA_LATENCY_SAMPLING__SAMPLER1_GMI__SHIFT                                                            0x3
#define GCEA_LATENCY_SAMPLING__SAMPLER0_IO__SHIFT                                                             0x4
#define GCEA_LATENCY_SAMPLING__SAMPLER1_IO__SHIFT                                                             0x5
#define GCEA_LATENCY_SAMPLING__SAMPLER0_READ__SHIFT                                                           0x6
#define GCEA_LATENCY_SAMPLING__SAMPLER1_READ__SHIFT                                                           0x7
#define GCEA_LATENCY_SAMPLING__SAMPLER0_WRITE__SHIFT                                                          0x8
#define GCEA_LATENCY_SAMPLING__SAMPLER1_WRITE__SHIFT                                                          0x9
#define GCEA_LATENCY_SAMPLING__SAMPLER0_ATOMIC_RET__SHIFT                                                     0xa
#define GCEA_LATENCY_SAMPLING__SAMPLER1_ATOMIC_RET__SHIFT                                                     0xb
#define GCEA_LATENCY_SAMPLING__SAMPLER0_ATOMIC_NORET__SHIFT                                                   0xc
#define GCEA_LATENCY_SAMPLING__SAMPLER1_ATOMIC_NORET__SHIFT                                                   0xd
#define GCEA_LATENCY_SAMPLING__SAMPLER0_VC__SHIFT                                                             0xe
#define GCEA_LATENCY_SAMPLING__SAMPLER1_VC__SHIFT                                                             0x16
#define GCEA_LATENCY_SAMPLING__SAMPLER0_DRAM_MASK                                                             0x00000001L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_DRAM_MASK                                                             0x00000002L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_GMI_MASK                                                              0x00000004L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_GMI_MASK                                                              0x00000008L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_IO_MASK                                                               0x00000010L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_IO_MASK                                                               0x00000020L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_READ_MASK                                                             0x00000040L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_READ_MASK                                                             0x00000080L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_WRITE_MASK                                                            0x00000100L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_WRITE_MASK                                                            0x00000200L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_ATOMIC_RET_MASK                                                       0x00000400L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_ATOMIC_RET_MASK                                                       0x00000800L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_ATOMIC_NORET_MASK                                                     0x00001000L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_ATOMIC_NORET_MASK                                                     0x00002000L
#define GCEA_LATENCY_SAMPLING__SAMPLER0_VC_MASK                                                               0x003FC000L
#define GCEA_LATENCY_SAMPLING__SAMPLER1_VC_MASK                                                               0x3FC00000L
//GCEA_PERFCOUNTER_LO
#define GCEA_PERFCOUNTER_LO__COUNTER_LO__SHIFT                                                                0x0
#define GCEA_PERFCOUNTER_LO__COUNTER_LO_MASK                                                                  0xFFFFFFFFL
//GCEA_PERFCOUNTER_HI
#define GCEA_PERFCOUNTER_HI__COUNTER_HI__SHIFT                                                                0x0
#define GCEA_PERFCOUNTER_HI__COMPARE_VALUE__SHIFT                                                             0x10
#define GCEA_PERFCOUNTER_HI__COUNTER_HI_MASK                                                                  0x0000FFFFL
#define GCEA_PERFCOUNTER_HI__COMPARE_VALUE_MASK                                                               0xFFFF0000L
//GCEA_PERFCOUNTER0_CFG
#define GCEA_PERFCOUNTER0_CFG__PERF_SEL__SHIFT                                                                0x0
#define GCEA_PERFCOUNTER0_CFG__PERF_SEL_END__SHIFT                                                            0x8
#define GCEA_PERFCOUNTER0_CFG__PERF_MODE__SHIFT                                                               0x18
#define GCEA_PERFCOUNTER0_CFG__ENABLE__SHIFT                                                                  0x1c
#define GCEA_PERFCOUNTER0_CFG__CLEAR__SHIFT                                                                   0x1d
#define GCEA_PERFCOUNTER0_CFG__PERF_SEL_MASK                                                                  0x000000FFL
#define GCEA_PERFCOUNTER0_CFG__PERF_SEL_END_MASK                                                              0x0000FF00L
#define GCEA_PERFCOUNTER0_CFG__PERF_MODE_MASK                                                                 0x0F000000L
#define GCEA_PERFCOUNTER0_CFG__ENABLE_MASK                                                                    0x10000000L
#define GCEA_PERFCOUNTER0_CFG__CLEAR_MASK                                                                     0x20000000L
//GCEA_PERFCOUNTER1_CFG
#define GCEA_PERFCOUNTER1_CFG__PERF_SEL__SHIFT                                                                0x0
#define GCEA_PERFCOUNTER1_CFG__PERF_SEL_END__SHIFT                                                            0x8
#define GCEA_PERFCOUNTER1_CFG__PERF_MODE__SHIFT                                                               0x18
#define GCEA_PERFCOUNTER1_CFG__ENABLE__SHIFT                                                                  0x1c
#define GCEA_PERFCOUNTER1_CFG__CLEAR__SHIFT                                                                   0x1d
#define GCEA_PERFCOUNTER1_CFG__PERF_SEL_MASK                                                                  0x000000FFL
#define GCEA_PERFCOUNTER1_CFG__PERF_SEL_END_MASK                                                              0x0000FF00L
#define GCEA_PERFCOUNTER1_CFG__PERF_MODE_MASK                                                                 0x0F000000L
#define GCEA_PERFCOUNTER1_CFG__ENABLE_MASK                                                                    0x10000000L
#define GCEA_PERFCOUNTER1_CFG__CLEAR_MASK                                                                     0x20000000L


// addressBlock: gc_ea_gceadec2
//GCEA_PERFCOUNTER_RSLT_CNTL
#define GCEA_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT__SHIFT                                                0x0
#define GCEA_PERFCOUNTER_RSLT_CNTL__START_TRIGGER__SHIFT                                                      0x8
#define GCEA_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER__SHIFT                                                       0x10
#define GCEA_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY__SHIFT                                                         0x18
#define GCEA_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL__SHIFT                                                          0x19
#define GCEA_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE__SHIFT                                               0x1a
#define GCEA_PERFCOUNTER_RSLT_CNTL__PERF_COUNTER_SELECT_MASK                                                  0x0000000FL
#define GCEA_PERFCOUNTER_RSLT_CNTL__START_TRIGGER_MASK                                                        0x0000FF00L
#define GCEA_PERFCOUNTER_RSLT_CNTL__STOP_TRIGGER_MASK                                                         0x00FF0000L
#define GCEA_PERFCOUNTER_RSLT_CNTL__ENABLE_ANY_MASK                                                           0x01000000L
#define GCEA_PERFCOUNTER_RSLT_CNTL__CLEAR_ALL_MASK                                                            0x02000000L
#define GCEA_PERFCOUNTER_RSLT_CNTL__STOP_ALL_ON_SATURATE_MASK                                                 0x04000000L
//GCEA_EDC_CNT
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_SEC_COUNT__SHIFT                                                          0x0
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_DED_COUNT__SHIFT                                                          0x2
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_SEC_COUNT__SHIFT                                                          0x4
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_DED_COUNT__SHIFT                                                          0x6
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_SEC_COUNT__SHIFT                                                         0x8
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_DED_COUNT__SHIFT                                                         0xa
#define GCEA_EDC_CNT__RRET_TAGMEM_SEC_COUNT__SHIFT                                                            0xc
#define GCEA_EDC_CNT__RRET_TAGMEM_DED_COUNT__SHIFT                                                            0xe
#define GCEA_EDC_CNT__WRET_TAGMEM_SEC_COUNT__SHIFT                                                            0x10
#define GCEA_EDC_CNT__WRET_TAGMEM_DED_COUNT__SHIFT                                                            0x12
#define GCEA_EDC_CNT__IOWR_DATAMEM_SEC_COUNT__SHIFT                                                           0x14
#define GCEA_EDC_CNT__IOWR_DATAMEM_DED_COUNT__SHIFT                                                           0x16
#define GCEA_EDC_CNT__DRAMRD_PAGEMEM_SED_COUNT__SHIFT                                                         0x18
#define GCEA_EDC_CNT__DRAMWR_PAGEMEM_SED_COUNT__SHIFT                                                         0x1a
#define GCEA_EDC_CNT__IORD_CMDMEM_SED_COUNT__SHIFT                                                            0x1c
#define GCEA_EDC_CNT__IOWR_CMDMEM_SED_COUNT__SHIFT                                                            0x1e
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_SEC_COUNT_MASK                                                            0x00000003L
#define GCEA_EDC_CNT__DRAMRD_CMDMEM_DED_COUNT_MASK                                                            0x0000000CL
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_SEC_COUNT_MASK                                                            0x00000030L
#define GCEA_EDC_CNT__DRAMWR_CMDMEM_DED_COUNT_MASK                                                            0x000000C0L
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_SEC_COUNT_MASK                                                           0x00000300L
#define GCEA_EDC_CNT__DRAMWR_DATAMEM_DED_COUNT_MASK                                                           0x00000C00L
#define GCEA_EDC_CNT__RRET_TAGMEM_SEC_COUNT_MASK                                                              0x00003000L
#define GCEA_EDC_CNT__RRET_TAGMEM_DED_COUNT_MASK                                                              0x0000C000L
#define GCEA_EDC_CNT__WRET_TAGMEM_SEC_COUNT_MASK                                                              0x00030000L
#define GCEA_EDC_CNT__WRET_TAGMEM_DED_COUNT_MASK                                                              0x000C0000L
#define GCEA_EDC_CNT__IOWR_DATAMEM_SEC_COUNT_MASK                                                             0x00300000L
#define GCEA_EDC_CNT__IOWR_DATAMEM_DED_COUNT_MASK                                                             0x00C00000L
#define GCEA_EDC_CNT__DRAMRD_PAGEMEM_SED_COUNT_MASK                                                           0x03000000L
#define GCEA_EDC_CNT__DRAMWR_PAGEMEM_SED_COUNT_MASK                                                           0x0C000000L
#define GCEA_EDC_CNT__IORD_CMDMEM_SED_COUNT_MASK                                                              0x30000000L
#define GCEA_EDC_CNT__IOWR_CMDMEM_SED_COUNT_MASK                                                              0xC0000000L
//GCEA_EDC_CNT2
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_SEC_COUNT__SHIFT                                                          0x0
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_DED_COUNT__SHIFT                                                          0x2
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_SEC_COUNT__SHIFT                                                          0x4
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_DED_COUNT__SHIFT                                                          0x6
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_SEC_COUNT__SHIFT                                                         0x8
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_DED_COUNT__SHIFT                                                         0xa
#define GCEA_EDC_CNT2__GMIRD_PAGEMEM_SED_COUNT__SHIFT                                                         0xc
#define GCEA_EDC_CNT2__GMIWR_PAGEMEM_SED_COUNT__SHIFT                                                         0xe
#define GCEA_EDC_CNT2__MAM_D0MEM_SED_COUNT__SHIFT                                                             0x10
#define GCEA_EDC_CNT2__MAM_D1MEM_SED_COUNT__SHIFT                                                             0x12
#define GCEA_EDC_CNT2__MAM_D2MEM_SED_COUNT__SHIFT                                                             0x14
#define GCEA_EDC_CNT2__MAM_D3MEM_SED_COUNT__SHIFT                                                             0x16
#define GCEA_EDC_CNT2__MAM_D0MEM_DED_COUNT__SHIFT                                                             0x18
#define GCEA_EDC_CNT2__MAM_D1MEM_DED_COUNT__SHIFT                                                             0x1a
#define GCEA_EDC_CNT2__MAM_D2MEM_DED_COUNT__SHIFT                                                             0x1c
#define GCEA_EDC_CNT2__MAM_D3MEM_DED_COUNT__SHIFT                                                             0x1e
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_SEC_COUNT_MASK                                                            0x00000003L
#define GCEA_EDC_CNT2__GMIRD_CMDMEM_DED_COUNT_MASK                                                            0x0000000CL
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_SEC_COUNT_MASK                                                            0x00000030L
#define GCEA_EDC_CNT2__GMIWR_CMDMEM_DED_COUNT_MASK                                                            0x000000C0L
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_SEC_COUNT_MASK                                                           0x00000300L
#define GCEA_EDC_CNT2__GMIWR_DATAMEM_DED_COUNT_MASK                                                           0x00000C00L
#define GCEA_EDC_CNT2__GMIRD_PAGEMEM_SED_COUNT_MASK                                                           0x00003000L
#define GCEA_EDC_CNT2__GMIWR_PAGEMEM_SED_COUNT_MASK                                                           0x0000C000L
#define GCEA_EDC_CNT2__MAM_D0MEM_SED_COUNT_MASK                                                               0x00030000L
#define GCEA_EDC_CNT2__MAM_D1MEM_SED_COUNT_MASK                                                               0x000C0000L
#define GCEA_EDC_CNT2__MAM_D2MEM_SED_COUNT_MASK                                                               0x00300000L
#define GCEA_EDC_CNT2__MAM_D3MEM_SED_COUNT_MASK                                                               0x00C00000L
#define GCEA_EDC_CNT2__MAM_D0MEM_DED_COUNT_MASK                                                               0x03000000L
#define GCEA_EDC_CNT2__MAM_D1MEM_DED_COUNT_MASK                                                               0x0C000000L
#define GCEA_EDC_CNT2__MAM_D2MEM_DED_COUNT_MASK                                                               0x30000000L
#define GCEA_EDC_CNT2__MAM_D3MEM_DED_COUNT_MASK                                                               0xC0000000L
//GCEA_DSM_CNTL
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                0x0
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0x2
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                0x3
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0x5
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_DSM_IRRITATOR_DATA__SHIFT                                               0x6
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define GCEA_DSM_CNTL__RRET_TAGMEM_DSM_IRRITATOR_DATA__SHIFT                                                  0x9
#define GCEA_DSM_CNTL__RRET_TAGMEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xb
#define GCEA_DSM_CNTL__WRET_TAGMEM_DSM_IRRITATOR_DATA__SHIFT                                                  0xc
#define GCEA_DSM_CNTL__WRET_TAGMEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xe
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0xf
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0x11
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0x12
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0x14
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_DSM_IRRITATOR_DATA__SHIFT                                                0x15
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0x17
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00000003L
#define GCEA_DSM_CNTL__DRAMRD_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00000004L
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00000018L
#define GCEA_DSM_CNTL__DRAMWR_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00000020L
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_DSM_IRRITATOR_DATA_MASK                                                 0x000000C0L
#define GCEA_DSM_CNTL__DRAMWR_DATAMEM_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define GCEA_DSM_CNTL__RRET_TAGMEM_DSM_IRRITATOR_DATA_MASK                                                    0x00000600L
#define GCEA_DSM_CNTL__RRET_TAGMEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00000800L
#define GCEA_DSM_CNTL__WRET_TAGMEM_DSM_IRRITATOR_DATA_MASK                                                    0x00003000L
#define GCEA_DSM_CNTL__WRET_TAGMEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00004000L
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x00018000L
#define GCEA_DSM_CNTL__GMIRD_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00020000L
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x000C0000L
#define GCEA_DSM_CNTL__GMIWR_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00100000L
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00600000L
#define GCEA_DSM_CNTL__GMIWR_DATAMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00800000L
//GCEA_DSM_CNTLA
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                              0x0
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                             0x2
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                              0x3
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                             0x5
#define GCEA_DSM_CNTLA__IORD_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0x6
#define GCEA_DSM_CNTLA__IORD_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0x8
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_DSM_IRRITATOR_DATA__SHIFT                                                 0x9
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_ENABLE_SINGLE_WRITE__SHIFT                                                0xb
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_DSM_IRRITATOR_DATA__SHIFT                                                0xc
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_ENABLE_SINGLE_WRITE__SHIFT                                               0xe
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                               0xf
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                              0x11
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_DSM_IRRITATOR_DATA__SHIFT                                               0x12
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_ENABLE_SINGLE_WRITE__SHIFT                                              0x14
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                0x00000003L
#define GCEA_DSM_CNTLA__DRAMRD_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                               0x00000004L
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                0x00000018L
#define GCEA_DSM_CNTLA__DRAMWR_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                               0x00000020L
#define GCEA_DSM_CNTLA__IORD_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x000000C0L
#define GCEA_DSM_CNTLA__IORD_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00000100L
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_DSM_IRRITATOR_DATA_MASK                                                   0x00000600L
#define GCEA_DSM_CNTLA__IOWR_CMDMEM_ENABLE_SINGLE_WRITE_MASK                                                  0x00000800L
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_DSM_IRRITATOR_DATA_MASK                                                  0x00003000L
#define GCEA_DSM_CNTLA__IOWR_DATAMEM_ENABLE_SINGLE_WRITE_MASK                                                 0x00004000L
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                 0x00018000L
#define GCEA_DSM_CNTLA__GMIRD_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                                0x00020000L
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_DSM_IRRITATOR_DATA_MASK                                                 0x000C0000L
#define GCEA_DSM_CNTLA__GMIWR_PAGEMEM_ENABLE_SINGLE_WRITE_MASK                                                0x00100000L
//GCEA_DSM_CNTLB
//GCEA_DSM_CNTL2
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                              0x0
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                              0x2
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                              0x3
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                              0x5
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define GCEA_DSM_CNTL2__RRET_TAGMEM_ENABLE_ERROR_INJECT__SHIFT                                                0x9
#define GCEA_DSM_CNTL2__RRET_TAGMEM_SELECT_INJECT_DELAY__SHIFT                                                0xb
#define GCEA_DSM_CNTL2__WRET_TAGMEM_ENABLE_ERROR_INJECT__SHIFT                                                0xc
#define GCEA_DSM_CNTL2__WRET_TAGMEM_SELECT_INJECT_DELAY__SHIFT                                                0xe
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0xf
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0x11
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0x12
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0x14
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_ENABLE_ERROR_INJECT__SHIFT                                              0x15
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_SELECT_INJECT_DELAY__SHIFT                                              0x17
#define GCEA_DSM_CNTL2__INJECT_DELAY__SHIFT                                                                   0x1a
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                0x00000003L
#define GCEA_DSM_CNTL2__DRAMRD_CMDMEM_SELECT_INJECT_DELAY_MASK                                                0x00000004L
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                0x00000018L
#define GCEA_DSM_CNTL2__DRAMWR_CMDMEM_SELECT_INJECT_DELAY_MASK                                                0x00000020L
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define GCEA_DSM_CNTL2__DRAMWR_DATAMEM_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define GCEA_DSM_CNTL2__RRET_TAGMEM_ENABLE_ERROR_INJECT_MASK                                                  0x00000600L
#define GCEA_DSM_CNTL2__RRET_TAGMEM_SELECT_INJECT_DELAY_MASK                                                  0x00000800L
#define GCEA_DSM_CNTL2__WRET_TAGMEM_ENABLE_ERROR_INJECT_MASK                                                  0x00003000L
#define GCEA_DSM_CNTL2__WRET_TAGMEM_SELECT_INJECT_DELAY_MASK                                                  0x00004000L
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x00018000L
#define GCEA_DSM_CNTL2__GMIRD_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00020000L
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x000C0000L
#define GCEA_DSM_CNTL2__GMIWR_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00100000L
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_ENABLE_ERROR_INJECT_MASK                                                0x00600000L
#define GCEA_DSM_CNTL2__GMIWR_DATAMEM_SELECT_INJECT_DELAY_MASK                                                0x00800000L
#define GCEA_DSM_CNTL2__INJECT_DELAY_MASK                                                                     0xFC000000L
//GCEA_DSM_CNTL2A
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                            0x0
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                            0x2
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                            0x3
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                            0x5
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0x6
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0x8
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_ENABLE_ERROR_INJECT__SHIFT                                               0x9
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_SELECT_INJECT_DELAY__SHIFT                                               0xb
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_ENABLE_ERROR_INJECT__SHIFT                                              0xc
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_SELECT_INJECT_DELAY__SHIFT                                              0xe
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                             0xf
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                             0x11
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_ENABLE_ERROR_INJECT__SHIFT                                             0x12
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_SELECT_INJECT_DELAY__SHIFT                                             0x14
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                              0x00000003L
#define GCEA_DSM_CNTL2A__DRAMRD_PAGEMEM_SELECT_INJECT_DELAY_MASK                                              0x00000004L
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                              0x00000018L
#define GCEA_DSM_CNTL2A__DRAMWR_PAGEMEM_SELECT_INJECT_DELAY_MASK                                              0x00000020L
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x000000C0L
#define GCEA_DSM_CNTL2A__IORD_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00000100L
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_ENABLE_ERROR_INJECT_MASK                                                 0x00000600L
#define GCEA_DSM_CNTL2A__IOWR_CMDMEM_SELECT_INJECT_DELAY_MASK                                                 0x00000800L
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_ENABLE_ERROR_INJECT_MASK                                                0x00003000L
#define GCEA_DSM_CNTL2A__IOWR_DATAMEM_SELECT_INJECT_DELAY_MASK                                                0x00004000L
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                               0x00018000L
#define GCEA_DSM_CNTL2A__GMIRD_PAGEMEM_SELECT_INJECT_DELAY_MASK                                               0x00020000L
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_ENABLE_ERROR_INJECT_MASK                                               0x000C0000L
#define GCEA_DSM_CNTL2A__GMIWR_PAGEMEM_SELECT_INJECT_DELAY_MASK                                               0x00100000L
//GCEA_DSM_CNTL2B
//GCEA_TCC_XBR_CREDITS
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_LIMIT__SHIFT                                                            0x0
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_RESERVE__SHIFT                                                          0x6
#define GCEA_TCC_XBR_CREDITS__IO_RD_LIMIT__SHIFT                                                              0x8
#define GCEA_TCC_XBR_CREDITS__IO_RD_RESERVE__SHIFT                                                            0xe
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_LIMIT__SHIFT                                                            0x10
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_RESERVE__SHIFT                                                          0x16
#define GCEA_TCC_XBR_CREDITS__IO_WR_LIMIT__SHIFT                                                              0x18
#define GCEA_TCC_XBR_CREDITS__IO_WR_RESERVE__SHIFT                                                            0x1e
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_LIMIT_MASK                                                              0x0000003FL
#define GCEA_TCC_XBR_CREDITS__DRAM_RD_RESERVE_MASK                                                            0x000000C0L
#define GCEA_TCC_XBR_CREDITS__IO_RD_LIMIT_MASK                                                                0x00003F00L
#define GCEA_TCC_XBR_CREDITS__IO_RD_RESERVE_MASK                                                              0x0000C000L
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_LIMIT_MASK                                                              0x003F0000L
#define GCEA_TCC_XBR_CREDITS__DRAM_WR_RESERVE_MASK                                                            0x00C00000L
#define GCEA_TCC_XBR_CREDITS__IO_WR_LIMIT_MASK                                                                0x3F000000L
#define GCEA_TCC_XBR_CREDITS__IO_WR_RESERVE_MASK                                                              0xC0000000L
//GCEA_TCC_XBR_MAXBURST
#define GCEA_TCC_XBR_MAXBURST__DRAM_RD__SHIFT                                                                 0x0
#define GCEA_TCC_XBR_MAXBURST__IO_RD__SHIFT                                                                   0x4
#define GCEA_TCC_XBR_MAXBURST__DRAM_WR__SHIFT                                                                 0x8
#define GCEA_TCC_XBR_MAXBURST__IO_WR__SHIFT                                                                   0xc
#define GCEA_TCC_XBR_MAXBURST__DRAM_RD_MASK                                                                   0x0000000FL
#define GCEA_TCC_XBR_MAXBURST__IO_RD_MASK                                                                     0x000000F0L
#define GCEA_TCC_XBR_MAXBURST__DRAM_WR_MASK                                                                   0x00000F00L
#define GCEA_TCC_XBR_MAXBURST__IO_WR_MASK                                                                     0x0000F000L
//GCEA_PROBE_CNTL
#define GCEA_PROBE_CNTL__REQ2RSP_DELAY__SHIFT                                                                 0x0
#define GCEA_PROBE_CNTL__PRB_FILTER_DISABLE__SHIFT                                                            0x5
#define GCEA_PROBE_CNTL__REQ2RSP_DELAY_MASK                                                                   0x0000001FL
#define GCEA_PROBE_CNTL__PRB_FILTER_DISABLE_MASK                                                              0x00000020L
//GCEA_PROBE_MAP
#define GCEA_PROBE_MAP__CHADDR0_TO_RIGHTTCC__SHIFT                                                            0x0
#define GCEA_PROBE_MAP__CHADDR1_TO_RIGHTTCC__SHIFT                                                            0x1
#define GCEA_PROBE_MAP__CHADDR2_TO_RIGHTTCC__SHIFT                                                            0x2
#define GCEA_PROBE_MAP__CHADDR3_TO_RIGHTTCC__SHIFT                                                            0x3
#define GCEA_PROBE_MAP__CHADDR4_TO_RIGHTTCC__SHIFT                                                            0x4
#define GCEA_PROBE_MAP__CHADDR5_TO_RIGHTTCC__SHIFT                                                            0x5
#define GCEA_PROBE_MAP__CHADDR6_TO_RIGHTTCC__SHIFT                                                            0x6
#define GCEA_PROBE_MAP__CHADDR7_TO_RIGHTTCC__SHIFT                                                            0x7
#define GCEA_PROBE_MAP__CHADDR8_TO_RIGHTTCC__SHIFT                                                            0x8
#define GCEA_PROBE_MAP__CHADDR9_TO_RIGHTTCC__SHIFT                                                            0x9
#define GCEA_PROBE_MAP__CHADDR10_TO_RIGHTTCC__SHIFT                                                           0xa
#define GCEA_PROBE_MAP__CHADDR11_TO_RIGHTTCC__SHIFT                                                           0xb
#define GCEA_PROBE_MAP__CHADDR12_TO_RIGHTTCC__SHIFT                                                           0xc
#define GCEA_PROBE_MAP__CHADDR13_TO_RIGHTTCC__SHIFT                                                           0xd
#define GCEA_PROBE_MAP__CHADDR14_TO_RIGHTTCC__SHIFT                                                           0xe
#define GCEA_PROBE_MAP__CHADDR15_TO_RIGHTTCC__SHIFT                                                           0xf
#define GCEA_PROBE_MAP__INTLV_SIZE__SHIFT                                                                     0x10
#define GCEA_PROBE_MAP__CHADDR0_TO_RIGHTTCC_MASK                                                              0x00000001L
#define GCEA_PROBE_MAP__CHADDR1_TO_RIGHTTCC_MASK                                                              0x00000002L
#define GCEA_PROBE_MAP__CHADDR2_TO_RIGHTTCC_MASK                                                              0x00000004L
#define GCEA_PROBE_MAP__CHADDR3_TO_RIGHTTCC_MASK                                                              0x00000008L
#define GCEA_PROBE_MAP__CHADDR4_TO_RIGHTTCC_MASK                                                              0x00000010L
#define GCEA_PROBE_MAP__CHADDR5_TO_RIGHTTCC_MASK                                                              0x00000020L
#define GCEA_PROBE_MAP__CHADDR6_TO_RIGHTTCC_MASK                                                              0x00000040L
#define GCEA_PROBE_MAP__CHADDR7_TO_RIGHTTCC_MASK                                                              0x00000080L
#define GCEA_PROBE_MAP__CHADDR8_TO_RIGHTTCC_MASK                                                              0x00000100L
#define GCEA_PROBE_MAP__CHADDR9_TO_RIGHTTCC_MASK                                                              0x00000200L
#define GCEA_PROBE_MAP__CHADDR10_TO_RIGHTTCC_MASK                                                             0x00000400L
#define GCEA_PROBE_MAP__CHADDR11_TO_RIGHTTCC_MASK                                                             0x00000800L
#define GCEA_PROBE_MAP__CHADDR12_TO_RIGHTTCC_MASK                                                             0x00001000L
#define GCEA_PROBE_MAP__CHADDR13_TO_RIGHTTCC_MASK                                                             0x00002000L
#define GCEA_PROBE_MAP__CHADDR14_TO_RIGHTTCC_MASK                                                             0x00004000L
#define GCEA_PROBE_MAP__CHADDR15_TO_RIGHTTCC_MASK                                                             0x00008000L
#define GCEA_PROBE_MAP__INTLV_SIZE_MASK                                                                       0x00030000L
//GCEA_ERR_STATUS
#define GCEA_ERR_STATUS__SDP_RDRSP_STATUS__SHIFT                                                              0x0
#define GCEA_ERR_STATUS__SDP_WRRSP_STATUS__SHIFT                                                              0x4
#define GCEA_ERR_STATUS__SDP_RDRSP_DATASTATUS__SHIFT                                                          0x8
#define GCEA_ERR_STATUS__SDP_RDRSP_DATAPARITY_ERROR__SHIFT                                                    0xa
#define GCEA_ERR_STATUS__CLEAR_ERROR_STATUS__SHIFT                                                            0xb
#define GCEA_ERR_STATUS__BUSY_ON_ERROR__SHIFT                                                                 0xc
#define GCEA_ERR_STATUS__FUE_FLAG__SHIFT                                                                      0xd
#define GCEA_ERR_STATUS__IGNORE_RDRSP_FED__SHIFT                                                              0xe
#define GCEA_ERR_STATUS__INTERRUPT_ON_FATAL__SHIFT                                                            0xf
#define GCEA_ERR_STATUS__INTERRUPT_IGNORE_CLI_FATAL__SHIFT                                                    0x10
#define GCEA_ERR_STATUS__LEVEL_INTERRUPT__SHIFT                                                               0x11
#define GCEA_ERR_STATUS__SDP_RDRSP_STATUS_MASK                                                                0x0000000FL
#define GCEA_ERR_STATUS__SDP_WRRSP_STATUS_MASK                                                                0x000000F0L
#define GCEA_ERR_STATUS__SDP_RDRSP_DATASTATUS_MASK                                                            0x00000300L
#define GCEA_ERR_STATUS__SDP_RDRSP_DATAPARITY_ERROR_MASK                                                      0x00000400L
#define GCEA_ERR_STATUS__CLEAR_ERROR_STATUS_MASK                                                              0x00000800L
#define GCEA_ERR_STATUS__BUSY_ON_ERROR_MASK                                                                   0x00001000L
#define GCEA_ERR_STATUS__FUE_FLAG_MASK                                                                        0x00002000L
#define GCEA_ERR_STATUS__IGNORE_RDRSP_FED_MASK                                                                0x00004000L
#define GCEA_ERR_STATUS__INTERRUPT_ON_FATAL_MASK                                                              0x00008000L
#define GCEA_ERR_STATUS__INTERRUPT_IGNORE_CLI_FATAL_MASK                                                      0x00010000L
#define GCEA_ERR_STATUS__LEVEL_INTERRUPT_MASK                                                                 0x00020000L
//GCEA_MISC2
#define GCEA_MISC2__CSGROUP_SWAP_IN_DRAM_ARB__SHIFT                                                           0x0
#define GCEA_MISC2__CSGROUP_SWAP_IN_GMI_ARB__SHIFT                                                            0x1
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_DRAM__SHIFT                                                        0x2
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_GMI__SHIFT                                                         0x7
#define GCEA_MISC2__IO_RDWR_PRIORITY_ENABLE__SHIFT                                                            0xc
#define GCEA_MISC2__BLOCK_REQUESTS__SHIFT                                                                     0xd
#define GCEA_MISC2__REQUESTS_BLOCKED__SHIFT                                                                   0xe
#define GCEA_MISC2__FGCLKEN_OVERRIDE__SHIFT                                                                   0xf
#define GCEA_MISC2__CSGROUP_SWAP_IN_DRAM_ARB_MASK                                                             0x00000001L
#define GCEA_MISC2__CSGROUP_SWAP_IN_GMI_ARB_MASK                                                              0x00000002L
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_DRAM_MASK                                                          0x0000007CL
#define GCEA_MISC2__CSGRP_BURST_LIMIT_DATA_GMI_MASK                                                           0x00000F80L
#define GCEA_MISC2__IO_RDWR_PRIORITY_ENABLE_MASK                                                              0x00001000L
#define GCEA_MISC2__BLOCK_REQUESTS_MASK                                                                       0x00002000L
#define GCEA_MISC2__REQUESTS_BLOCKED_MASK                                                                     0x00004000L
#define GCEA_MISC2__FGCLKEN_OVERRIDE_MASK                                                                     0x00008000L
//GCEA_DRAM_BANK_ARB
#define GCEA_DRAM_BANK_ARB__AGEBASED_BANKARB__SHIFT                                                           0x0
#define GCEA_DRAM_BANK_ARB__BANK_STAY_AWAY_CYCLIM__SHIFT                                                      0x1
#define GCEA_DRAM_BANK_ARB__BANK_STAY_AWAY_REQLIM__SHIFT                                                      0x9
#define GCEA_DRAM_BANK_ARB__BANK_STAY_AWAY_STALLMODE__SHIFT                                                   0xf
#define GCEA_DRAM_BANK_ARB__DISABLE_STALLMODE_FIX__SHIFT                                                      0x10
#define GCEA_DRAM_BANK_ARB__AGEBASED_BANKARB_MASK                                                             0x00000001L
#define GCEA_DRAM_BANK_ARB__BANK_STAY_AWAY_CYCLIM_MASK                                                        0x000001FEL
#define GCEA_DRAM_BANK_ARB__BANK_STAY_AWAY_REQLIM_MASK                                                        0x00007E00L
#define GCEA_DRAM_BANK_ARB__BANK_STAY_AWAY_STALLMODE_MASK                                                     0x00008000L
#define GCEA_DRAM_BANK_ARB__DISABLE_STALLMODE_FIX_MASK                                                        0x00010000L
//GCEA_ADDRDEC_SELECT
#define GCEA_ADDRDEC_SELECT__DRAM_ADDRDEC_CHANNEL_START__SHIFT                                                0x0
#define GCEA_ADDRDEC_SELECT__DRAM_ADDRDEC_CHANNEL_END__SHIFT                                                  0x5
#define GCEA_ADDRDEC_SELECT__GMI_ADDRDEC_CHANNEL_START__SHIFT                                                 0xa
#define GCEA_ADDRDEC_SELECT__GMI_ADDRDEC_CHANNEL_END__SHIFT                                                   0xf
#define GCEA_ADDRDEC_SELECT__DRAM_ADDRDEC_CHANNEL_START_MASK                                                  0x0000001FL
#define GCEA_ADDRDEC_SELECT__DRAM_ADDRDEC_CHANNEL_END_MASK                                                    0x000003E0L
#define GCEA_ADDRDEC_SELECT__GMI_ADDRDEC_CHANNEL_START_MASK                                                   0x00007C00L
#define GCEA_ADDRDEC_SELECT__GMI_ADDRDEC_CHANNEL_END_MASK                                                     0x000F8000L
//GCEA_EDC_CNT3
#define GCEA_EDC_CNT3__DRAMRD_PAGEMEM_DED_COUNT__SHIFT                                                        0x0
#define GCEA_EDC_CNT3__DRAMWR_PAGEMEM_DED_COUNT__SHIFT                                                        0x2
#define GCEA_EDC_CNT3__IORD_CMDMEM_DED_COUNT__SHIFT                                                           0x4
#define GCEA_EDC_CNT3__IOWR_CMDMEM_DED_COUNT__SHIFT                                                           0x6
#define GCEA_EDC_CNT3__GMIRD_PAGEMEM_DED_COUNT__SHIFT                                                         0x8
#define GCEA_EDC_CNT3__GMIWR_PAGEMEM_DED_COUNT__SHIFT                                                         0xa
#define GCEA_EDC_CNT3__MAM_A0MEM_SEC_COUNT__SHIFT                                                             0xc
#define GCEA_EDC_CNT3__MAM_A0MEM_DED_COUNT__SHIFT                                                             0xe
#define GCEA_EDC_CNT3__MAM_A1MEM_SEC_COUNT__SHIFT                                                             0x10
#define GCEA_EDC_CNT3__MAM_A1MEM_DED_COUNT__SHIFT                                                             0x12
#define GCEA_EDC_CNT3__MAM_A2MEM_SEC_COUNT__SHIFT                                                             0x14
#define GCEA_EDC_CNT3__MAM_A2MEM_DED_COUNT__SHIFT                                                             0x16
#define GCEA_EDC_CNT3__MAM_A3MEM_SEC_COUNT__SHIFT                                                             0x18
#define GCEA_EDC_CNT3__MAM_A3MEM_DED_COUNT__SHIFT                                                             0x1a
#define GCEA_EDC_CNT3__MAM_AFMEM_SEC_COUNT__SHIFT                                                             0x1c
#define GCEA_EDC_CNT3__MAM_AFMEM_DED_COUNT__SHIFT                                                             0x1e
#define GCEA_EDC_CNT3__DRAMRD_PAGEMEM_DED_COUNT_MASK                                                          0x00000003L
#define GCEA_EDC_CNT3__DRAMWR_PAGEMEM_DED_COUNT_MASK                                                          0x0000000CL
#define GCEA_EDC_CNT3__IORD_CMDMEM_DED_COUNT_MASK                                                             0x00000030L
#define GCEA_EDC_CNT3__IOWR_CMDMEM_DED_COUNT_MASK                                                             0x000000C0L
#define GCEA_EDC_CNT3__GMIRD_PAGEMEM_DED_COUNT_MASK                                                           0x00000300L
#define GCEA_EDC_CNT3__GMIWR_PAGEMEM_DED_COUNT_MASK                                                           0x00000C00L
#define GCEA_EDC_CNT3__MAM_A0MEM_SEC_COUNT_MASK                                                               0x00003000L
#define GCEA_EDC_CNT3__MAM_A0MEM_DED_COUNT_MASK                                                               0x0000C000L
#define GCEA_EDC_CNT3__MAM_A1MEM_SEC_COUNT_MASK                                                               0x00030000L
#define GCEA_EDC_CNT3__MAM_A1MEM_DED_COUNT_MASK                                                               0x000C0000L
#define GCEA_EDC_CNT3__MAM_A2MEM_SEC_COUNT_MASK                                                               0x00300000L
#define GCEA_EDC_CNT3__MAM_A2MEM_DED_COUNT_MASK                                                               0x00C00000L
#define GCEA_EDC_CNT3__MAM_A3MEM_SEC_COUNT_MASK                                                               0x03000000L
#define GCEA_EDC_CNT3__MAM_A3MEM_DED_COUNT_MASK                                                               0x0C000000L
#define GCEA_EDC_CNT3__MAM_AFMEM_SEC_COUNT_MASK                                                               0x30000000L
#define GCEA_EDC_CNT3__MAM_AFMEM_DED_COUNT_MASK                                                               0xC0000000L

// addressBlock: gc_ea_pwrdec
//GCEA_CGTT_CLK_CTRL
#define GCEA_CGTT_CLK_CTRL__ON_DELAY__SHIFT                                                                   0x0
#define GCEA_CGTT_CLK_CTRL__OFF_HYSTERESIS__SHIFT                                                             0x4
#define GCEA_CGTT_CLK_CTRL__SPARE0__SHIFT                                                                     0xc
#define GCEA_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_WRITE__SHIFT                                                  0x14
#define GCEA_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_READ__SHIFT                                                   0x15
#define GCEA_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_RETURN__SHIFT                                                 0x16
#define GCEA_CGTT_CLK_CTRL__SPARE1__SHIFT                                                                     0x17
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_WRITE__SHIFT                                                        0x1c
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_READ__SHIFT                                                         0x1d
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_RETURN__SHIFT                                                       0x1e
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_REGISTER__SHIFT                                                     0x1f
#define GCEA_CGTT_CLK_CTRL__ON_DELAY_MASK                                                                     0x0000000FL
#define GCEA_CGTT_CLK_CTRL__OFF_HYSTERESIS_MASK                                                               0x00000FF0L
#define GCEA_CGTT_CLK_CTRL__SPARE0_MASK                                                                       0x000FF000L
#define GCEA_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_WRITE_MASK                                                    0x00100000L
#define GCEA_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_READ_MASK                                                     0x00200000L
#define GCEA_CGTT_CLK_CTRL__SOFT_STALL_OVERRIDE_RETURN_MASK                                                   0x00400000L
#define GCEA_CGTT_CLK_CTRL__SPARE1_MASK                                                                       0x0F800000L
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_WRITE_MASK                                                          0x10000000L
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_READ_MASK                                                           0x20000000L
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_RETURN_MASK                                                         0x40000000L
#define GCEA_CGTT_CLK_CTRL__SOFT_OVERRIDE_REGISTER_MASK                                                       0x80000000L


// addressBlock: gc_gccacdec
//GC_CAC_CTRL_1
#define GC_CAC_CTRL_1__CAC_WINDOW__SHIFT                                                                      0x0
#define GC_CAC_CTRL_1__TDP_WINDOW__SHIFT                                                                      0x18
#define GC_CAC_CTRL_1__CAC_WINDOW_MASK                                                                        0x00FFFFFFL
#define GC_CAC_CTRL_1__TDP_WINDOW_MASK                                                                        0xFF000000L
//GC_CAC_CTRL_2
#define GC_CAC_CTRL_2__CAC_ENABLE__SHIFT                                                                      0x0
#define GC_CAC_CTRL_2__CAC_SOFT_CTRL_ENABLE__SHIFT                                                            0x1
#define GC_CAC_CTRL_2__GC_LCAC_ENABLE__SHIFT                                                                  0x2
#define GC_CAC_CTRL_2__SE_LCAC_ENABLE__SHIFT                                                                  0x3
#define GC_CAC_CTRL_2__CAC_ENABLE_MASK                                                                        0x00000001L
#define GC_CAC_CTRL_2__CAC_SOFT_CTRL_ENABLE_MASK                                                              0x00000002L
#define GC_CAC_CTRL_2__GC_LCAC_ENABLE_MASK                                                                    0x00000004L
#define GC_CAC_CTRL_2__SE_LCAC_ENABLE_MASK                                                                    0x00000008L
//GC_CAC_INDEX_AUTO_INCR_EN
#define GC_CAC_INDEX_AUTO_INCR_EN__GC_CAC_INDEX_AUTO_INCR_EN__SHIFT                                           0x0
#define GC_CAC_INDEX_AUTO_INCR_EN__GC_CAC_INDEX_AUTO_INCR_EN_MASK                                             0x00000001L
//GC_CAC_AGGR_LOWER
#define GC_CAC_AGGR_LOWER__AGGR_31_0__SHIFT                                                                   0x0
#define GC_CAC_AGGR_LOWER__AGGR_31_0_MASK                                                                     0xFFFFFFFFL
//GC_CAC_AGGR_UPPER
#define GC_CAC_AGGR_UPPER__AGGR_63_32__SHIFT                                                                  0x0
#define GC_CAC_AGGR_UPPER__AGGR_63_32_MASK                                                                    0xFFFFFFFFL
//GC_EDC_PERF_COUNTER
#define GC_EDC_PERF_COUNTER__EDC_PERF_COUNTER__SHIFT                                                          0x0
#define GC_EDC_PERF_COUNTER__EDC_PERF_COUNTER_MASK                                                            0xFFFFFFFFL
//PCC_PERF_COUNTER
#define PCC_PERF_COUNTER__PCC_PERF_COUNTER__SHIFT                                                             0x0
#define PCC_PERF_COUNTER__PCC_PERF_COUNTER_MASK                                                               0xFFFFFFFFL
//GC_CAC_SOFT_CTRL
#define GC_CAC_SOFT_CTRL__SOFT_SNAP__SHIFT                                                                    0x0
#define GC_CAC_SOFT_CTRL__SOFT_SNAP_MASK                                                                      0x00000001L
//GC_DIDT_CTRL0
#define GC_DIDT_CTRL0__DIDT_CTRL_EN__SHIFT                                                                    0x0
#define GC_DIDT_CTRL0__PHASE_OFFSET__SHIFT                                                                    0x1
#define GC_DIDT_CTRL0__DIDT_SW_RST__SHIFT                                                                     0x3
#define GC_DIDT_CTRL0__DIDT_CLK_EN_OVERRIDE__SHIFT                                                            0x4
#define GC_DIDT_CTRL0__DIDT_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                    0x5
#define GC_DIDT_CTRL0__DIDT_CTRL_EN_MASK                                                                      0x00000001L
#define GC_DIDT_CTRL0__PHASE_OFFSET_MASK                                                                      0x00000006L
#define GC_DIDT_CTRL0__DIDT_SW_RST_MASK                                                                       0x00000008L
#define GC_DIDT_CTRL0__DIDT_CLK_EN_OVERRIDE_MASK                                                              0x00000010L
#define GC_DIDT_CTRL0__DIDT_TRIGGER_THROTTLE_LOWBIT_MASK                                                      0x000001E0L
//GC_DIDT_CTRL1
#define GC_DIDT_CTRL1__MIN_POWER__SHIFT                                                                       0x0
#define GC_DIDT_CTRL1__MAX_POWER__SHIFT                                                                       0x10
#define GC_DIDT_CTRL1__MIN_POWER_MASK                                                                         0x0000FFFFL
#define GC_DIDT_CTRL1__MAX_POWER_MASK                                                                         0xFFFF0000L
//GC_DIDT_CTRL2
#define GC_DIDT_CTRL2__MAX_POWER_DELTA__SHIFT                                                                 0x0
#define GC_DIDT_CTRL2__SHORT_TERM_INTERVAL_SIZE__SHIFT                                                        0x10
#define GC_DIDT_CTRL2__LONG_TERM_INTERVAL_RATIO__SHIFT                                                        0x1b
#define GC_DIDT_CTRL2__MAX_POWER_DELTA_MASK                                                                   0x00003FFFL
#define GC_DIDT_CTRL2__SHORT_TERM_INTERVAL_SIZE_MASK                                                          0x03FF0000L
#define GC_DIDT_CTRL2__LONG_TERM_INTERVAL_RATIO_MASK                                                          0x78000000L
//GC_DIDT_WEIGHT
#define GC_DIDT_WEIGHT__SQ_WEIGHT__SHIFT                                                                      0x0
#define GC_DIDT_WEIGHT__DB_WEIGHT__SHIFT                                                                      0x8
#define GC_DIDT_WEIGHT__TD_WEIGHT__SHIFT                                                                      0x10
#define GC_DIDT_WEIGHT__TCP_WEIGHT__SHIFT                                                                     0x18
#define GC_DIDT_WEIGHT__SQ_WEIGHT_MASK                                                                        0x000000FFL
#define GC_DIDT_WEIGHT__DB_WEIGHT_MASK                                                                        0x0000FF00L
#define GC_DIDT_WEIGHT__TD_WEIGHT_MASK                                                                        0x00FF0000L
#define GC_DIDT_WEIGHT__TCP_WEIGHT_MASK                                                                       0xFF000000L
//GC_THROTTLE_CTRL1
#define GC_THROTTLE_CTRL1__PCC_FP_PROGRAM_STEP_EN__SHIFT                                                      0x0
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MIN_STEP__SHIFT                                                        0x1
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MAX_STEP__SHIFT                                                        0x5
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_UPWARDS_STEP_SIZE__SHIFT                                               0xa
#define GC_THROTTLE_CTRL1__PATTERN_EXTEND_EN__SHIFT                                                           0xd
#define GC_THROTTLE_CTRL1__PATTERN_EXTEND_MODE__SHIFT                                                         0xe
#define GC_THROTTLE_CTRL1__FIXED_PATTERN_SELECT__SHIFT                                                        0x11
#define GC_THROTTLE_CTRL1__FP_PATTERN_CLAMP_EN__SHIFT                                                         0x13
#define GC_THROTTLE_CTRL1__PWRBRK_STALL_EN__SHIFT                                                             0x14
#define GC_THROTTLE_CTRL1__PWRBRK_OVERRIDE__SHIFT                                                             0x15
#define GC_THROTTLE_CTRL1__PWRBRK_POLARITY_CNTL__SHIFT                                                        0x16
#define GC_THROTTLE_CTRL1__PWRBRK_PERF_COUNTER_EN__SHIFT                                                      0x17
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_UPWARDS_STEP_SIZE__SHIFT                                            0x18
#define GC_THROTTLE_CTRL1__PCC_FP_PROGRAM_STEP_EN_MASK                                                        0x00000001L
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MIN_STEP_MASK                                                          0x0000001EL
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_MAX_STEP_MASK                                                          0x000003E0L
#define GC_THROTTLE_CTRL1__PCC_PROGRAM_UPWARDS_STEP_SIZE_MASK                                                 0x00001C00L
#define GC_THROTTLE_CTRL1__PATTERN_EXTEND_EN_MASK                                                             0x00002000L
#define GC_THROTTLE_CTRL1__PATTERN_EXTEND_MODE_MASK                                                           0x0001C000L
#define GC_THROTTLE_CTRL1__FIXED_PATTERN_SELECT_MASK                                                          0x00060000L
#define GC_THROTTLE_CTRL1__FP_PATTERN_CLAMP_EN_MASK                                                           0x00080000L
#define GC_THROTTLE_CTRL1__PWRBRK_STALL_EN_MASK                                                               0x00100000L
#define GC_THROTTLE_CTRL1__PWRBRK_OVERRIDE_MASK                                                               0x00200000L
#define GC_THROTTLE_CTRL1__PWRBRK_POLARITY_CNTL_MASK                                                          0x00400000L
#define GC_THROTTLE_CTRL1__PWRBRK_PERF_COUNTER_EN_MASK                                                        0x00800000L
#define GC_THROTTLE_CTRL1__PWRBRK_PROGRAM_UPWARDS_STEP_SIZE_MASK                                              0x07000000L
//GC_EDC_CTRL
#define GC_EDC_CTRL__EDC_EN__SHIFT                                                                            0x0
#define GC_EDC_CTRL__EDC_SW_RST__SHIFT                                                                        0x1
#define GC_EDC_CTRL__EDC_CLK_EN_OVERRIDE__SHIFT                                                               0x2
#define GC_EDC_CTRL__EDC_FORCE_STALL__SHIFT                                                                   0x3
#define GC_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT__SHIFT                                                       0x4
#define GC_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA__SHIFT                                                          0x9
#define GC_EDC_CTRL__GC_EDC_ONLY_MODE__SHIFT                                                                  0xb
#define GC_EDC_CTRL__EDC_THROTTLE_PATTERN_BIT_NUMS__SHIFT                                                     0xc
#define GC_EDC_CTRL__PCC_THROTTLE_PATTERN_BIT_NUMS__SHIFT                                                     0x10
#define GC_EDC_CTRL__RELEASE_STEP_INTERVAL__SHIFT                                                             0x14
#define GC_EDC_CTRL__EDC_LEVEL_SEL__SHIFT                                                                     0x1e
#define GC_EDC_CTRL__PCC_DITHER_MODE__SHIFT                                                                   0x1f
#define GC_EDC_CTRL__EDC_EN_MASK                                                                              0x00000001L
#define GC_EDC_CTRL__EDC_SW_RST_MASK                                                                          0x00000002L
#define GC_EDC_CTRL__EDC_CLK_EN_OVERRIDE_MASK                                                                 0x00000004L
#define GC_EDC_CTRL__EDC_FORCE_STALL_MASK                                                                     0x00000008L
#define GC_EDC_CTRL__EDC_TRIGGER_THROTTLE_LOWBIT_MASK                                                         0x000001F0L
#define GC_EDC_CTRL__EDC_ALLOW_WRITE_PWRDELTA_MASK                                                            0x00000200L
#define GC_EDC_CTRL__GC_EDC_ONLY_MODE_MASK                                                                    0x00000800L
#define GC_EDC_CTRL__EDC_THROTTLE_PATTERN_BIT_NUMS_MASK                                                       0x0000F000L
#define GC_EDC_CTRL__PCC_THROTTLE_PATTERN_BIT_NUMS_MASK                                                       0x000F0000L
#define GC_EDC_CTRL__RELEASE_STEP_INTERVAL_MASK                                                               0x3FF00000L
#define GC_EDC_CTRL__EDC_LEVEL_SEL_MASK                                                                       0x40000000L
#define GC_EDC_CTRL__PCC_DITHER_MODE_MASK                                                                     0x80000000L
//GC_EDC_THRESHOLD
#define GC_EDC_THRESHOLD__EDC_THRESHOLD__SHIFT                                                                0x0
#define GC_EDC_THRESHOLD__EDC_THRESHOLD_MASK                                                                  0xFFFFFFFFL
//GC_EDC_STATUS
#define GC_EDC_STATUS__EDC_THROTTLE_LEVEL__SHIFT                                                              0x0
#define GC_EDC_STATUS__THROTTLE_PATTERN_INDEX__SHIFT                                                          0x3
#define GC_EDC_STATUS__EDC_THROTTLE_LEVEL_MASK                                                                0x00000007L
#define GC_EDC_STATUS__THROTTLE_PATTERN_INDEX_MASK                                                            0x000001F8L
//GC_EDC_OVERFLOW
#define GC_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW__SHIFT                                              0x0
#define GC_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER__SHIFT                                           0x1
#define GC_EDC_OVERFLOW__EDC_ROLLING_POWER_DELTA_OVERFLOW_MASK                                                0x00000001L
#define GC_EDC_OVERFLOW__EDC_THROTTLE_LEVEL_OVERFLOW_COUNTER_MASK                                             0x0001FFFEL
//GC_EDC_ROLLING_POWER_DELTA
#define GC_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA__SHIFT                                            0x0
#define GC_EDC_ROLLING_POWER_DELTA__EDC_ROLLING_POWER_DELTA_MASK                                              0xFFFFFFFFL
//GC_EDC_CTRL1
#define GC_EDC_CTRL1__PSM_THROTTLE_SRC_SEL__SHIFT                                                             0x0
#define GC_EDC_CTRL1__THROTTLE_SRC0_MASK__SHIFT                                                               0x4
#define GC_EDC_CTRL1__THROTTLE_SRC1_MASK__SHIFT                                                               0x5
#define GC_EDC_CTRL1__THROTTLE_SRC2_MASK__SHIFT                                                               0x6
#define GC_EDC_CTRL1__THROTTLE_SRC3_MASK__SHIFT                                                               0x7
#define GC_EDC_CTRL1__THROTTLE_SRC4_MASK__SHIFT                                                               0x8
#define GC_EDC_CTRL1__THROTTLE_SRC5_MASK__SHIFT                                                               0x9
#define GC_EDC_CTRL1__THROTTLE_SRC6_MASK__SHIFT                                                               0xa
#define GC_EDC_CTRL1__THROTTLE_SRC7_MASK__SHIFT                                                               0xb
#define GC_EDC_CTRL1__PSM_THROTTLE_SRC_SEL_MASK                                                               0x0000000FL
#define GC_EDC_CTRL1__THROTTLE_SRC0_MASK_MASK                                                                 0x00000010L
#define GC_EDC_CTRL1__THROTTLE_SRC1_MASK_MASK                                                                 0x00000020L
#define GC_EDC_CTRL1__THROTTLE_SRC2_MASK_MASK                                                                 0x00000040L
#define GC_EDC_CTRL1__THROTTLE_SRC3_MASK_MASK                                                                 0x00000080L
#define GC_EDC_CTRL1__THROTTLE_SRC4_MASK_MASK                                                                 0x00000100L
#define GC_EDC_CTRL1__THROTTLE_SRC5_MASK_MASK                                                                 0x00000200L
#define GC_EDC_CTRL1__THROTTLE_SRC6_MASK_MASK                                                                 0x00000400L
#define GC_EDC_CTRL1__THROTTLE_SRC7_MASK_MASK                                                                 0x00000800L
//GC_THROTTLE_CTRL2
#define GC_THROTTLE_CTRL2__PWRBRK_FP_PROGRAM_STEP_EN__SHIFT                                                   0x0
#define GC_THROTTLE_CTRL2__PWRBRK_PROGRAM_MIN_STEP__SHIFT                                                     0x1
#define GC_THROTTLE_CTRL2__PWRBRK_PROGRAM_MAX_STEP__SHIFT                                                     0x5
#define GC_THROTTLE_CTRL2__PWRBRK_FP_PROGRAM_STEP_EN_MASK                                                     0x00000001L
#define GC_THROTTLE_CTRL2__PWRBRK_PROGRAM_MIN_STEP_MASK                                                       0x0000001EL
#define GC_THROTTLE_CTRL2__PWRBRK_PROGRAM_MAX_STEP_MASK                                                       0x000003E0L
//PWRBRK_PERF_COUNTER
#define PWRBRK_PERF_COUNTER__PWRBRK_PERF_COUNTER__SHIFT                                                       0x0
#define PWRBRK_PERF_COUNTER__PWRBRK_PERF_COUNTER_MASK                                                         0xFFFFFFFFL
//GC_THROTTLE_CTRL
#define GC_THROTTLE_CTRL__THROTTLE_CTRL_SW_RST__SHIFT                                                         0x0
#define GC_THROTTLE_CTRL__GC_EDC_STALL_EN__SHIFT                                                              0x1
#define GC_THROTTLE_CTRL__PCC_STALL_EN__SHIFT                                                                 0x2
#define GC_THROTTLE_CTRL__PATTERN_MODE__SHIFT                                                                 0x3
#define GC_THROTTLE_CTRL__GC_EDC_OVERRIDE__SHIFT                                                              0x4
#define GC_THROTTLE_CTRL__NON_DITHER__SHIFT                                                                   0x5
#define GC_THROTTLE_CTRL__PCC_OVERRIDE__SHIFT                                                                 0x7
#define GC_THROTTLE_CTRL__GC_EDC_PERF_COUNTER_EN__SHIFT                                                       0x8
#define GC_THROTTLE_CTRL__PCC_PERF_COUNTER_EN__SHIFT                                                          0x9
#define GC_THROTTLE_CTRL__PCC_THROT_INCR_STEP_INTERVAL__SHIFT                                                 0xa
#define GC_THROTTLE_CTRL__PCC_FIXED_PATTERN_MIN__SHIFT                                                        0x14
#define GC_THROTTLE_CTRL__PCC_FIXED_PATTERN_MAX__SHIFT                                                        0x19
#define GC_THROTTLE_CTRL__INST_THROT_INCR__SHIFT                                                              0x1e
#define GC_THROTTLE_CTRL__INST_THROT_DECR__SHIFT                                                              0x1f
#define GC_THROTTLE_CTRL__THROTTLE_CTRL_SW_RST_MASK                                                           0x00000001L
#define GC_THROTTLE_CTRL__GC_EDC_STALL_EN_MASK                                                                0x00000002L
#define GC_THROTTLE_CTRL__PCC_STALL_EN_MASK                                                                   0x00000004L
#define GC_THROTTLE_CTRL__PATTERN_MODE_MASK                                                                   0x00000008L
#define GC_THROTTLE_CTRL__GC_EDC_OVERRIDE_MASK                                                                0x00000010L
#define GC_THROTTLE_CTRL__NON_DITHER_MASK                                                                     0x00000020L
#define GC_THROTTLE_CTRL__PCC_OVERRIDE_MASK                                                                   0x00000080L
#define GC_THROTTLE_CTRL__GC_EDC_PERF_COUNTER_EN_MASK                                                         0x00000100L
#define GC_THROTTLE_CTRL__PCC_PERF_COUNTER_EN_MASK                                                            0x00000200L
#define GC_THROTTLE_CTRL__PCC_THROT_INCR_STEP_INTERVAL_MASK                                                   0x000FFC00L
#define GC_THROTTLE_CTRL__PCC_FIXED_PATTERN_MIN_MASK                                                          0x01F00000L
#define GC_THROTTLE_CTRL__PCC_FIXED_PATTERN_MAX_MASK                                                          0x3E000000L
#define GC_THROTTLE_CTRL__INST_THROT_INCR_MASK                                                                0x40000000L
#define GC_THROTTLE_CTRL__INST_THROT_DECR_MASK                                                                0x80000000L
//GC_CAC_IND_INDEX
#define GC_CAC_IND_INDEX__GC_CAC_IND_ADDR__SHIFT                                                              0x0
#define GC_CAC_IND_INDEX__GC_CAC_IND_ADDR_MASK                                                                0xFFFFFFFFL
//GC_CAC_IND_DATA
#define GC_CAC_IND_DATA__GC_CAC_IND_DATA__SHIFT                                                               0x0
#define GC_CAC_IND_DATA__GC_CAC_IND_DATA_MASK                                                                 0xFFFFFFFFL
//SE_CAC_IND_INDEX
#define SE_CAC_IND_INDEX__SE_CAC_IND_ADDR__SHIFT                                                              0x0
#define SE_CAC_IND_INDEX__SE_CAC_IND_ADDR_MASK                                                                0xFFFFFFFFL
//SE_CAC_IND_DATA
#define SE_CAC_IND_DATA__SE_CAC_IND_DATA__SHIFT                                                               0x0
#define SE_CAC_IND_DATA__SE_CAC_IND_DATA_MASK                                                                 0xFFFFFFFFL




// addressBlock: gc_gdsdec
//GDS_CONFIG
#define GDS_CONFIG__SH0_GPR_PHASE_SEL__SHIFT                                                                  0x1
#define GDS_CONFIG__SH1_GPR_PHASE_SEL__SHIFT                                                                  0x3
#define GDS_CONFIG__SH2_GPR_PHASE_SEL__SHIFT                                                                  0x5
#define GDS_CONFIG__SH3_GPR_PHASE_SEL__SHIFT                                                                  0x7
#define GDS_CONFIG__SH4_GPR_PHASE_SEL__SHIFT                                                                  0x9
#define GDS_CONFIG__SH5_GPR_PHASE_SEL__SHIFT                                                                  0xb
#define GDS_CONFIG__SH6_GPR_PHASE_SEL__SHIFT                                                                  0xd
#define GDS_CONFIG__SH7_GPR_PHASE_SEL__SHIFT                                                                  0xf
#define GDS_CONFIG__SH0_GPR_PHASE_SEL_MASK                                                                    0x00000006L
#define GDS_CONFIG__SH1_GPR_PHASE_SEL_MASK                                                                    0x00000018L
#define GDS_CONFIG__SH2_GPR_PHASE_SEL_MASK                                                                    0x00000060L
#define GDS_CONFIG__SH3_GPR_PHASE_SEL_MASK                                                                    0x00000180L
#define GDS_CONFIG__SH4_GPR_PHASE_SEL_MASK                                                                    0x00000600L
#define GDS_CONFIG__SH5_GPR_PHASE_SEL_MASK                                                                    0x00001800L
#define GDS_CONFIG__SH6_GPR_PHASE_SEL_MASK                                                                    0x00006000L
#define GDS_CONFIG__SH7_GPR_PHASE_SEL_MASK                                                                    0x00018000L
//GDS_CNTL_STATUS
#define GDS_CNTL_STATUS__GDS_BUSY__SHIFT                                                                      0x0
#define GDS_CNTL_STATUS__GRBM_WBUF_BUSY__SHIFT                                                                0x1
#define GDS_CNTL_STATUS__ORD_APP_BUSY__SHIFT                                                                  0x2
#define GDS_CNTL_STATUS__DS_BANK_CONFLICT__SHIFT                                                              0x3
#define GDS_CNTL_STATUS__DS_ADDR_CONFLICT__SHIFT                                                              0x4
#define GDS_CNTL_STATUS__DS_WR_CLAMP__SHIFT                                                                   0x5
#define GDS_CNTL_STATUS__DS_RD_CLAMP__SHIFT                                                                   0x6
#define GDS_CNTL_STATUS__GRBM_RBUF_BUSY__SHIFT                                                                0x7
#define GDS_CNTL_STATUS__DS_BUSY__SHIFT                                                                       0x8
#define GDS_CNTL_STATUS__GWS_BUSY__SHIFT                                                                      0x9
#define GDS_CNTL_STATUS__ORD_FIFO_BUSY__SHIFT                                                                 0xa
#define GDS_CNTL_STATUS__CREDIT_BUSY0__SHIFT                                                                  0xb
#define GDS_CNTL_STATUS__CREDIT_BUSY1__SHIFT                                                                  0xc
#define GDS_CNTL_STATUS__CREDIT_BUSY2__SHIFT                                                                  0xd
#define GDS_CNTL_STATUS__CREDIT_BUSY3__SHIFT                                                                  0xe
#define GDS_CNTL_STATUS__CREDIT_BUSY4__SHIFT                                                                  0xf
#define GDS_CNTL_STATUS__CREDIT_BUSY5__SHIFT                                                                  0x10
#define GDS_CNTL_STATUS__CREDIT_BUSY6__SHIFT                                                                  0x11
#define GDS_CNTL_STATUS__CREDIT_BUSY7__SHIFT                                                                  0x12
#define GDS_CNTL_STATUS__GDS_BUSY_MASK                                                                        0x00000001L
#define GDS_CNTL_STATUS__GRBM_WBUF_BUSY_MASK                                                                  0x00000002L
#define GDS_CNTL_STATUS__ORD_APP_BUSY_MASK                                                                    0x00000004L
#define GDS_CNTL_STATUS__DS_BANK_CONFLICT_MASK                                                                0x00000008L
#define GDS_CNTL_STATUS__DS_ADDR_CONFLICT_MASK                                                                0x00000010L
#define GDS_CNTL_STATUS__DS_WR_CLAMP_MASK                                                                     0x00000020L
#define GDS_CNTL_STATUS__DS_RD_CLAMP_MASK                                                                     0x00000040L
#define GDS_CNTL_STATUS__GRBM_RBUF_BUSY_MASK                                                                  0x00000080L
#define GDS_CNTL_STATUS__DS_BUSY_MASK                                                                         0x00000100L
#define GDS_CNTL_STATUS__GWS_BUSY_MASK                                                                        0x00000200L
#define GDS_CNTL_STATUS__ORD_FIFO_BUSY_MASK                                                                   0x00000400L
#define GDS_CNTL_STATUS__CREDIT_BUSY0_MASK                                                                    0x00000800L
#define GDS_CNTL_STATUS__CREDIT_BUSY1_MASK                                                                    0x00001000L
#define GDS_CNTL_STATUS__CREDIT_BUSY2_MASK                                                                    0x00002000L
#define GDS_CNTL_STATUS__CREDIT_BUSY3_MASK                                                                    0x00004000L
#define GDS_CNTL_STATUS__CREDIT_BUSY4_MASK                                                                    0x00008000L
#define GDS_CNTL_STATUS__CREDIT_BUSY5_MASK                                                                    0x00010000L
#define GDS_CNTL_STATUS__CREDIT_BUSY6_MASK                                                                    0x00020000L
#define GDS_CNTL_STATUS__CREDIT_BUSY7_MASK                                                                    0x00040000L
//GDS_ENHANCE2
#define GDS_ENHANCE2__MISC__SHIFT                                                                             0x0
#define GDS_ENHANCE2__GDS_TD_INTERFACES_FGCG_OVERRIDE__SHIFT                                                  0x10
#define GDS_ENHANCE2__GDS_PHY_CMD_RAM_FGCG_OVERRIDE__SHIFT                                                    0x11
#define GDS_ENHANCE2__GDS_FED_IN_PROPAGATE__SHIFT                                                             0x12
#define GDS_ENHANCE2__UNUSED__SHIFT                                                                           0x13
#define GDS_ENHANCE2__MISC_MASK                                                                               0x0000FFFFL
#define GDS_ENHANCE2__GDS_TD_INTERFACES_FGCG_OVERRIDE_MASK                                                    0x00010000L
#define GDS_ENHANCE2__GDS_PHY_CMD_RAM_FGCG_OVERRIDE_MASK                                                      0x00020000L
#define GDS_ENHANCE2__GDS_FED_IN_PROPAGATE_MASK                                                               0x00040000L
#define GDS_ENHANCE2__UNUSED_MASK                                                                             0xFFF80000L
//GDS_PROTECTION_FAULT
#define GDS_PROTECTION_FAULT__WRITE_DIS__SHIFT                                                                0x0
#define GDS_PROTECTION_FAULT__FAULT_DETECTED__SHIFT                                                           0x1
#define GDS_PROTECTION_FAULT__GRBM__SHIFT                                                                     0x2
#define GDS_PROTECTION_FAULT__SH_ID__SHIFT                                                                    0x3
#define GDS_PROTECTION_FAULT__CU_ID__SHIFT                                                                    0x6
#define GDS_PROTECTION_FAULT__SIMD_ID__SHIFT                                                                  0xa
#define GDS_PROTECTION_FAULT__WAVE_ID__SHIFT                                                                  0xc
#define GDS_PROTECTION_FAULT__ADDRESS__SHIFT                                                                  0x10
#define GDS_PROTECTION_FAULT__WRITE_DIS_MASK                                                                  0x00000001L
#define GDS_PROTECTION_FAULT__FAULT_DETECTED_MASK                                                             0x00000002L
#define GDS_PROTECTION_FAULT__GRBM_MASK                                                                       0x00000004L
#define GDS_PROTECTION_FAULT__SH_ID_MASK                                                                      0x00000038L
#define GDS_PROTECTION_FAULT__CU_ID_MASK                                                                      0x000003C0L
#define GDS_PROTECTION_FAULT__SIMD_ID_MASK                                                                    0x00000C00L
#define GDS_PROTECTION_FAULT__WAVE_ID_MASK                                                                    0x0000F000L
#define GDS_PROTECTION_FAULT__ADDRESS_MASK                                                                    0xFFFF0000L
//GDS_VM_PROTECTION_FAULT
#define GDS_VM_PROTECTION_FAULT__WRITE_DIS__SHIFT                                                             0x0
#define GDS_VM_PROTECTION_FAULT__FAULT_DETECTED__SHIFT                                                        0x1
#define GDS_VM_PROTECTION_FAULT__GWS__SHIFT                                                                   0x2
#define GDS_VM_PROTECTION_FAULT__OA__SHIFT                                                                    0x3
#define GDS_VM_PROTECTION_FAULT__GRBM__SHIFT                                                                  0x4
#define GDS_VM_PROTECTION_FAULT__TMZ__SHIFT                                                                   0x5
#define GDS_VM_PROTECTION_FAULT__VMID__SHIFT                                                                  0x8
#define GDS_VM_PROTECTION_FAULT__ADDRESS__SHIFT                                                               0x10
#define GDS_VM_PROTECTION_FAULT__WRITE_DIS_MASK                                                               0x00000001L
#define GDS_VM_PROTECTION_FAULT__FAULT_DETECTED_MASK                                                          0x00000002L
#define GDS_VM_PROTECTION_FAULT__GWS_MASK                                                                     0x00000004L
#define GDS_VM_PROTECTION_FAULT__OA_MASK                                                                      0x00000008L
#define GDS_VM_PROTECTION_FAULT__GRBM_MASK                                                                    0x00000010L
#define GDS_VM_PROTECTION_FAULT__TMZ_MASK                                                                     0x00000020L
#define GDS_VM_PROTECTION_FAULT__VMID_MASK                                                                    0x00000F00L
#define GDS_VM_PROTECTION_FAULT__ADDRESS_MASK                                                                 0xFFFF0000L
//GDS_EDC_CNT
#define GDS_EDC_CNT__GDS_MEM_DED__SHIFT                                                                       0x0
#define GDS_EDC_CNT__GDS_MEM_SEC__SHIFT                                                                       0x4
#define GDS_EDC_CNT__UNUSED__SHIFT                                                                            0x6
#define GDS_EDC_CNT__GDS_MEM_DED_MASK                                                                         0x00000003L
#define GDS_EDC_CNT__GDS_MEM_SEC_MASK                                                                         0x00000030L
#define GDS_EDC_CNT__UNUSED_MASK                                                                              0xFFFFFFC0L
//GDS_EDC_GRBM_CNT
#define GDS_EDC_GRBM_CNT__DED__SHIFT                                                                          0x0
#define GDS_EDC_GRBM_CNT__SEC__SHIFT                                                                          0x2
#define GDS_EDC_GRBM_CNT__UNUSED__SHIFT                                                                       0x4
#define GDS_EDC_GRBM_CNT__DED_MASK                                                                            0x00000003L
#define GDS_EDC_GRBM_CNT__SEC_MASK                                                                            0x0000000CL
#define GDS_EDC_GRBM_CNT__UNUSED_MASK                                                                         0xFFFFFFF0L
//GDS_EDC_OA_DED
#define GDS_EDC_OA_DED__ME0_GFXHP3D_PIX_DED__SHIFT                                                            0x0
#define GDS_EDC_OA_DED__ME0_GFXHP3D_VTX_DED__SHIFT                                                            0x1
#define GDS_EDC_OA_DED__ME0_CS_DED__SHIFT                                                                     0x2
#define GDS_EDC_OA_DED__ME0_GFXHP3D_GS_DED__SHIFT                                                             0x3
#define GDS_EDC_OA_DED__ME1_PIPE0_DED__SHIFT                                                                  0x4
#define GDS_EDC_OA_DED__ME1_PIPE1_DED__SHIFT                                                                  0x5
#define GDS_EDC_OA_DED__ME1_PIPE2_DED__SHIFT                                                                  0x6
#define GDS_EDC_OA_DED__ME1_PIPE3_DED__SHIFT                                                                  0x7
#define GDS_EDC_OA_DED__ME2_PIPE0_DED__SHIFT                                                                  0x8
#define GDS_EDC_OA_DED__ME2_PIPE1_DED__SHIFT                                                                  0x9
#define GDS_EDC_OA_DED__ME2_PIPE2_DED__SHIFT                                                                  0xa
#define GDS_EDC_OA_DED__ME2_PIPE3_DED__SHIFT                                                                  0xb
#define GDS_EDC_OA_DED__UNUSED1__SHIFT                                                                        0xc
#define GDS_EDC_OA_DED__ME0_GFXHP3D_PIX_DED_MASK                                                              0x00000001L
#define GDS_EDC_OA_DED__ME0_GFXHP3D_VTX_DED_MASK                                                              0x00000002L
#define GDS_EDC_OA_DED__ME0_CS_DED_MASK                                                                       0x00000004L
#define GDS_EDC_OA_DED__ME0_GFXHP3D_GS_DED_MASK                                                               0x00000008L
#define GDS_EDC_OA_DED__ME1_PIPE0_DED_MASK                                                                    0x00000010L
#define GDS_EDC_OA_DED__ME1_PIPE1_DED_MASK                                                                    0x00000020L
#define GDS_EDC_OA_DED__ME1_PIPE2_DED_MASK                                                                    0x00000040L
#define GDS_EDC_OA_DED__ME1_PIPE3_DED_MASK                                                                    0x00000080L
#define GDS_EDC_OA_DED__ME2_PIPE0_DED_MASK                                                                    0x00000100L
#define GDS_EDC_OA_DED__ME2_PIPE1_DED_MASK                                                                    0x00000200L
#define GDS_EDC_OA_DED__ME2_PIPE2_DED_MASK                                                                    0x00000400L
#define GDS_EDC_OA_DED__ME2_PIPE3_DED_MASK                                                                    0x00000800L
#define GDS_EDC_OA_DED__UNUSED1_MASK                                                                          0xFFFFF000L
//GDS_DSM_CNTL
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_0__SHIFT                                                 0x0
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_1__SHIFT                                                 0x1
#define GDS_DSM_CNTL__GDS_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                      0x2
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_0__SHIFT                                         0x3
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_1__SHIFT                                         0x4
#define GDS_DSM_CNTL__GDS_INPUT_QUEUE_ENABLE_SINGLE_WRITE__SHIFT                                              0x5
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_0__SHIFT                                         0x6
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_1__SHIFT                                         0x7
#define GDS_DSM_CNTL__GDS_PHY_CMD_RAM_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_0__SHIFT                                        0x9
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_1__SHIFT                                        0xa
#define GDS_DSM_CNTL__GDS_PHY_DATA_RAM_ENABLE_SINGLE_WRITE__SHIFT                                             0xb
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_0__SHIFT                                            0xc
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_1__SHIFT                                            0xd
#define GDS_DSM_CNTL__GDS_PIPE_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xe
#define GDS_DSM_CNTL__UNUSED__SHIFT                                                                           0xf
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_0_MASK                                                   0x00000001L
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_1_MASK                                                   0x00000002L
#define GDS_DSM_CNTL__GDS_MEM_ENABLE_SINGLE_WRITE_MASK                                                        0x00000004L
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_0_MASK                                           0x00000008L
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_1_MASK                                           0x00000010L
#define GDS_DSM_CNTL__GDS_INPUT_QUEUE_ENABLE_SINGLE_WRITE_MASK                                                0x00000020L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_0_MASK                                           0x00000040L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_1_MASK                                           0x00000080L
#define GDS_DSM_CNTL__GDS_PHY_CMD_RAM_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_0_MASK                                          0x00000200L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_1_MASK                                          0x00000400L
#define GDS_DSM_CNTL__GDS_PHY_DATA_RAM_ENABLE_SINGLE_WRITE_MASK                                               0x00000800L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_0_MASK                                              0x00001000L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_1_MASK                                              0x00002000L
#define GDS_DSM_CNTL__GDS_PIPE_MEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00004000L
#define GDS_DSM_CNTL__UNUSED_MASK                                                                             0xFFFF8000L
//GDS_EDC_OA_PHY_CNT
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_SEC__SHIFT                                                        0x0
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_DED__SHIFT                                                        0x2
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_SEC__SHIFT                                                        0x4
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_DED__SHIFT                                                        0x6
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_SEC__SHIFT                                                       0x8
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_DED__SHIFT                                                       0xa
#define GDS_EDC_OA_PHY_CNT__UNUSED1__SHIFT                                                                    0xc
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_SEC_MASK                                                          0x00000003L
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_DED_MASK                                                          0x0000000CL
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_SEC_MASK                                                          0x00000030L
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_DED_MASK                                                          0x000000C0L
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_SEC_MASK                                                         0x00000300L
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_DED_MASK                                                         0x00000C00L
#define GDS_EDC_OA_PHY_CNT__UNUSED1_MASK                                                                      0xFFFFF000L
//GDS_EDC_OA_PIPE_CNT
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_SEC__SHIFT                                                    0x0
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_DED__SHIFT                                                    0x2
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_SEC__SHIFT                                                    0x4
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_DED__SHIFT                                                    0x6
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_SEC__SHIFT                                                    0x8
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_DED__SHIFT                                                    0xa
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_SEC__SHIFT                                                    0xc
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_DED__SHIFT                                                    0xe
#define GDS_EDC_OA_PIPE_CNT__UNUSED__SHIFT                                                                    0x10
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_SEC_MASK                                                      0x00000003L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_DED_MASK                                                      0x0000000CL
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_SEC_MASK                                                      0x00000030L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_DED_MASK                                                      0x000000C0L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_SEC_MASK                                                      0x00000300L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_DED_MASK                                                      0x00000C00L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_SEC_MASK                                                      0x00003000L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_DED_MASK                                                      0x0000C000L
#define GDS_EDC_OA_PIPE_CNT__UNUSED_MASK                                                                      0xFFFF0000L
//GDS_DSM_CNTL2
#define GDS_DSM_CNTL2__GDS_MEM_ENABLE_ERROR_INJECT__SHIFT                                                     0x0
#define GDS_DSM_CNTL2__GDS_MEM_SELECT_INJECT_DELAY__SHIFT                                                     0x2
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_ENABLE_ERROR_INJECT__SHIFT                                             0x3
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_SELECT_INJECT_DELAY__SHIFT                                             0x5
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_ENABLE_ERROR_INJECT__SHIFT                                            0x9
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_SELECT_INJECT_DELAY__SHIFT                                            0xb
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_ENABLE_ERROR_INJECT__SHIFT                                                0xc
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_SELECT_INJECT_DELAY__SHIFT                                                0xe
#define GDS_DSM_CNTL2__UNUSED__SHIFT                                                                          0xf
#define GDS_DSM_CNTL2__GDS_INJECT_DELAY__SHIFT                                                                0x1a
#define GDS_DSM_CNTL2__GDS_MEM_ENABLE_ERROR_INJECT_MASK                                                       0x00000003L
#define GDS_DSM_CNTL2__GDS_MEM_SELECT_INJECT_DELAY_MASK                                                       0x00000004L
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_ENABLE_ERROR_INJECT_MASK                                               0x00000018L
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_SELECT_INJECT_DELAY_MASK                                               0x00000020L
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_ENABLE_ERROR_INJECT_MASK                                              0x00000600L
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_SELECT_INJECT_DELAY_MASK                                              0x00000800L
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_ENABLE_ERROR_INJECT_MASK                                                  0x00003000L
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_SELECT_INJECT_DELAY_MASK                                                  0x00004000L
#define GDS_DSM_CNTL2__UNUSED_MASK                                                                            0x03FF8000L
#define GDS_DSM_CNTL2__GDS_INJECT_DELAY_MASK                                                                  0xFC000000L
//GDS_WD_GDS_CSB
#define GDS_WD_GDS_CSB__COUNTER__SHIFT                                                                        0x0
#define GDS_WD_GDS_CSB__UNUSED__SHIFT                                                                         0xd
#define GDS_WD_GDS_CSB__COUNTER_MASK                                                                          0x00001FFFL
#define GDS_WD_GDS_CSB__UNUSED_MASK                                                                           0xFFFFE000L


// addressBlock: gc_gdspdec
//GDS_VMID0_BASE
#define GDS_VMID0_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID0_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID0_SIZE
#define GDS_VMID0_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID0_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID1_BASE
#define GDS_VMID1_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID1_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID1_SIZE
#define GDS_VMID1_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID1_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID2_BASE
#define GDS_VMID2_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID2_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID2_SIZE
#define GDS_VMID2_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID2_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID3_BASE
#define GDS_VMID3_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID3_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID3_SIZE
#define GDS_VMID3_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID3_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID4_BASE
#define GDS_VMID4_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID4_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID4_SIZE
#define GDS_VMID4_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID4_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID5_BASE
#define GDS_VMID5_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID5_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID5_SIZE
#define GDS_VMID5_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID5_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID6_BASE
#define GDS_VMID6_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID6_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID6_SIZE
#define GDS_VMID6_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID6_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID7_BASE
#define GDS_VMID7_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID7_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID7_SIZE
#define GDS_VMID7_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID7_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID8_BASE
#define GDS_VMID8_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID8_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID8_SIZE
#define GDS_VMID8_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID8_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID9_BASE
#define GDS_VMID9_BASE__BASE__SHIFT                                                                           0x0
#define GDS_VMID9_BASE__BASE_MASK                                                                             0x0000FFFFL
//GDS_VMID9_SIZE
#define GDS_VMID9_SIZE__SIZE__SHIFT                                                                           0x0
#define GDS_VMID9_SIZE__SIZE_MASK                                                                             0x0001FFFFL
//GDS_VMID10_BASE
#define GDS_VMID10_BASE__BASE__SHIFT                                                                          0x0
#define GDS_VMID10_BASE__BASE_MASK                                                                            0x0000FFFFL
//GDS_VMID10_SIZE
#define GDS_VMID10_SIZE__SIZE__SHIFT                                                                          0x0
#define GDS_VMID10_SIZE__SIZE_MASK                                                                            0x0001FFFFL
//GDS_VMID11_BASE
#define GDS_VMID11_BASE__BASE__SHIFT                                                                          0x0
#define GDS_VMID11_BASE__BASE_MASK                                                                            0x0000FFFFL
//GDS_VMID11_SIZE
#define GDS_VMID11_SIZE__SIZE__SHIFT                                                                          0x0
#define GDS_VMID11_SIZE__SIZE_MASK                                                                            0x0001FFFFL
//GDS_VMID12_BASE
#define GDS_VMID12_BASE__BASE__SHIFT                                                                          0x0
#define GDS_VMID12_BASE__BASE_MASK                                                                            0x0000FFFFL
//GDS_VMID12_SIZE
#define GDS_VMID12_SIZE__SIZE__SHIFT                                                                          0x0
#define GDS_VMID12_SIZE__SIZE_MASK                                                                            0x0001FFFFL
//GDS_VMID13_BASE
#define GDS_VMID13_BASE__BASE__SHIFT                                                                          0x0
#define GDS_VMID13_BASE__BASE_MASK                                                                            0x0000FFFFL
//GDS_VMID13_SIZE
#define GDS_VMID13_SIZE__SIZE__SHIFT                                                                          0x0
#define GDS_VMID13_SIZE__SIZE_MASK                                                                            0x0001FFFFL
//GDS_VMID14_BASE
#define GDS_VMID14_BASE__BASE__SHIFT                                                                          0x0
#define GDS_VMID14_BASE__BASE_MASK                                                                            0x0000FFFFL
//GDS_VMID14_SIZE
#define GDS_VMID14_SIZE__SIZE__SHIFT                                                                          0x0
#define GDS_VMID14_SIZE__SIZE_MASK                                                                            0x0001FFFFL
//GDS_VMID15_BASE
#define GDS_VMID15_BASE__BASE__SHIFT                                                                          0x0
#define GDS_VMID15_BASE__BASE_MASK                                                                            0x0000FFFFL
//GDS_VMID15_SIZE
#define GDS_VMID15_SIZE__SIZE__SHIFT                                                                          0x0
#define GDS_VMID15_SIZE__SIZE_MASK                                                                            0x0001FFFFL
//GDS_GWS_VMID0
#define GDS_GWS_VMID0__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID0__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID0__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID0__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID1
#define GDS_GWS_VMID1__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID1__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID1__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID1__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID2
#define GDS_GWS_VMID2__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID2__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID2__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID2__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID3
#define GDS_GWS_VMID3__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID3__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID3__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID3__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID4
#define GDS_GWS_VMID4__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID4__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID4__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID4__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID5
#define GDS_GWS_VMID5__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID5__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID5__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID5__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID6
#define GDS_GWS_VMID6__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID6__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID6__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID6__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID7
#define GDS_GWS_VMID7__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID7__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID7__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID7__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID8
#define GDS_GWS_VMID8__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID8__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID8__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID8__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID9
#define GDS_GWS_VMID9__BASE__SHIFT                                                                            0x0
#define GDS_GWS_VMID9__SIZE__SHIFT                                                                            0x10
#define GDS_GWS_VMID9__BASE_MASK                                                                              0x0000003FL
#define GDS_GWS_VMID9__SIZE_MASK                                                                              0x007F0000L
//GDS_GWS_VMID10
#define GDS_GWS_VMID10__BASE__SHIFT                                                                           0x0
#define GDS_GWS_VMID10__SIZE__SHIFT                                                                           0x10
#define GDS_GWS_VMID10__BASE_MASK                                                                             0x0000003FL
#define GDS_GWS_VMID10__SIZE_MASK                                                                             0x007F0000L
//GDS_GWS_VMID11
#define GDS_GWS_VMID11__BASE__SHIFT                                                                           0x0
#define GDS_GWS_VMID11__SIZE__SHIFT                                                                           0x10
#define GDS_GWS_VMID11__BASE_MASK                                                                             0x0000003FL
#define GDS_GWS_VMID11__SIZE_MASK                                                                             0x007F0000L
//GDS_GWS_VMID12
#define GDS_GWS_VMID12__BASE__SHIFT                                                                           0x0
#define GDS_GWS_VMID12__SIZE__SHIFT                                                                           0x10
#define GDS_GWS_VMID12__BASE_MASK                                                                             0x0000003FL
#define GDS_GWS_VMID12__SIZE_MASK                                                                             0x007F0000L
//GDS_GWS_VMID13
#define GDS_GWS_VMID13__BASE__SHIFT                                                                           0x0
#define GDS_GWS_VMID13__SIZE__SHIFT                                                                           0x10
#define GDS_GWS_VMID13__BASE_MASK                                                                             0x0000003FL
#define GDS_GWS_VMID13__SIZE_MASK                                                                             0x007F0000L
//GDS_GWS_VMID14
#define GDS_GWS_VMID14__BASE__SHIFT                                                                           0x0
#define GDS_GWS_VMID14__SIZE__SHIFT                                                                           0x10
#define GDS_GWS_VMID14__BASE_MASK                                                                             0x0000003FL
#define GDS_GWS_VMID14__SIZE_MASK                                                                             0x007F0000L
//GDS_GWS_VMID15
#define GDS_GWS_VMID15__BASE__SHIFT                                                                           0x0
#define GDS_GWS_VMID15__SIZE__SHIFT                                                                           0x10
#define GDS_GWS_VMID15__BASE_MASK                                                                             0x0000003FL
#define GDS_GWS_VMID15__SIZE_MASK                                                                             0x007F0000L
//GDS_OA_VMID0
#define GDS_OA_VMID0__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID0__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID0__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID0__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID1
#define GDS_OA_VMID1__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID1__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID1__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID1__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID2
#define GDS_OA_VMID2__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID2__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID2__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID2__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID3
#define GDS_OA_VMID3__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID3__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID3__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID3__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID4
#define GDS_OA_VMID4__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID4__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID4__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID4__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID5
#define GDS_OA_VMID5__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID5__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID5__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID5__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID6
#define GDS_OA_VMID6__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID6__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID6__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID6__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID7
#define GDS_OA_VMID7__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID7__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID7__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID7__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID8
#define GDS_OA_VMID8__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID8__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID8__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID8__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID9
#define GDS_OA_VMID9__MASK__SHIFT                                                                             0x0
#define GDS_OA_VMID9__UNUSED__SHIFT                                                                           0x10
#define GDS_OA_VMID9__MASK_MASK                                                                               0x0000FFFFL
#define GDS_OA_VMID9__UNUSED_MASK                                                                             0xFFFF0000L
//GDS_OA_VMID10
#define GDS_OA_VMID10__MASK__SHIFT                                                                            0x0
#define GDS_OA_VMID10__UNUSED__SHIFT                                                                          0x10
#define GDS_OA_VMID10__MASK_MASK                                                                              0x0000FFFFL
#define GDS_OA_VMID10__UNUSED_MASK                                                                            0xFFFF0000L
//GDS_OA_VMID11
#define GDS_OA_VMID11__MASK__SHIFT                                                                            0x0
#define GDS_OA_VMID11__UNUSED__SHIFT                                                                          0x10
#define GDS_OA_VMID11__MASK_MASK                                                                              0x0000FFFFL
#define GDS_OA_VMID11__UNUSED_MASK                                                                            0xFFFF0000L
//GDS_OA_VMID12
#define GDS_OA_VMID12__MASK__SHIFT                                                                            0x0
#define GDS_OA_VMID12__UNUSED__SHIFT                                                                          0x10
#define GDS_OA_VMID12__MASK_MASK                                                                              0x0000FFFFL
#define GDS_OA_VMID12__UNUSED_MASK                                                                            0xFFFF0000L
//GDS_OA_VMID13
#define GDS_OA_VMID13__MASK__SHIFT                                                                            0x0
#define GDS_OA_VMID13__UNUSED__SHIFT                                                                          0x10
#define GDS_OA_VMID13__MASK_MASK                                                                              0x0000FFFFL
#define GDS_OA_VMID13__UNUSED_MASK                                                                            0xFFFF0000L
//GDS_OA_VMID14
#define GDS_OA_VMID14__MASK__SHIFT                                                                            0x0
#define GDS_OA_VMID14__UNUSED__SHIFT                                                                          0x10
#define GDS_OA_VMID14__MASK_MASK                                                                              0x0000FFFFL
#define GDS_OA_VMID14__UNUSED_MASK                                                                            0xFFFF0000L
//GDS_OA_VMID15
#define GDS_OA_VMID15__MASK__SHIFT                                                                            0x0
#define GDS_OA_VMID15__UNUSED__SHIFT                                                                          0x10
#define GDS_OA_VMID15__MASK_MASK                                                                              0x0000FFFFL
#define GDS_OA_VMID15__UNUSED_MASK                                                                            0xFFFF0000L
//GDS_GWS_RESET0
#define GDS_GWS_RESET0__RESOURCE0_RESET__SHIFT                                                                0x0
#define GDS_GWS_RESET0__RESOURCE1_RESET__SHIFT                                                                0x1
#define GDS_GWS_RESET0__RESOURCE2_RESET__SHIFT                                                                0x2
#define GDS_GWS_RESET0__RESOURCE3_RESET__SHIFT                                                                0x3
#define GDS_GWS_RESET0__RESOURCE4_RESET__SHIFT                                                                0x4
#define GDS_GWS_RESET0__RESOURCE5_RESET__SHIFT                                                                0x5
#define GDS_GWS_RESET0__RESOURCE6_RESET__SHIFT                                                                0x6
#define GDS_GWS_RESET0__RESOURCE7_RESET__SHIFT                                                                0x7
#define GDS_GWS_RESET0__RESOURCE8_RESET__SHIFT                                                                0x8
#define GDS_GWS_RESET0__RESOURCE9_RESET__SHIFT                                                                0x9
#define GDS_GWS_RESET0__RESOURCE10_RESET__SHIFT                                                               0xa
#define GDS_GWS_RESET0__RESOURCE11_RESET__SHIFT                                                               0xb
#define GDS_GWS_RESET0__RESOURCE12_RESET__SHIFT                                                               0xc
#define GDS_GWS_RESET0__RESOURCE13_RESET__SHIFT                                                               0xd
#define GDS_GWS_RESET0__RESOURCE14_RESET__SHIFT                                                               0xe
#define GDS_GWS_RESET0__RESOURCE15_RESET__SHIFT                                                               0xf
#define GDS_GWS_RESET0__RESOURCE16_RESET__SHIFT                                                               0x10
#define GDS_GWS_RESET0__RESOURCE17_RESET__SHIFT                                                               0x11
#define GDS_GWS_RESET0__RESOURCE18_RESET__SHIFT                                                               0x12
#define GDS_GWS_RESET0__RESOURCE19_RESET__SHIFT                                                               0x13
#define GDS_GWS_RESET0__RESOURCE20_RESET__SHIFT                                                               0x14
#define GDS_GWS_RESET0__RESOURCE21_RESET__SHIFT                                                               0x15
#define GDS_GWS_RESET0__RESOURCE22_RESET__SHIFT                                                               0x16
#define GDS_GWS_RESET0__RESOURCE23_RESET__SHIFT                                                               0x17
#define GDS_GWS_RESET0__RESOURCE24_RESET__SHIFT                                                               0x18
#define GDS_GWS_RESET0__RESOURCE25_RESET__SHIFT                                                               0x19
#define GDS_GWS_RESET0__RESOURCE26_RESET__SHIFT                                                               0x1a
#define GDS_GWS_RESET0__RESOURCE27_RESET__SHIFT                                                               0x1b
#define GDS_GWS_RESET0__RESOURCE28_RESET__SHIFT                                                               0x1c
#define GDS_GWS_RESET0__RESOURCE29_RESET__SHIFT                                                               0x1d
#define GDS_GWS_RESET0__RESOURCE30_RESET__SHIFT                                                               0x1e
#define GDS_GWS_RESET0__RESOURCE31_RESET__SHIFT                                                               0x1f
#define GDS_GWS_RESET0__RESOURCE0_RESET_MASK                                                                  0x00000001L
#define GDS_GWS_RESET0__RESOURCE1_RESET_MASK                                                                  0x00000002L
#define GDS_GWS_RESET0__RESOURCE2_RESET_MASK                                                                  0x00000004L
#define GDS_GWS_RESET0__RESOURCE3_RESET_MASK                                                                  0x00000008L
#define GDS_GWS_RESET0__RESOURCE4_RESET_MASK                                                                  0x00000010L
#define GDS_GWS_RESET0__RESOURCE5_RESET_MASK                                                                  0x00000020L
#define GDS_GWS_RESET0__RESOURCE6_RESET_MASK                                                                  0x00000040L
#define GDS_GWS_RESET0__RESOURCE7_RESET_MASK                                                                  0x00000080L
#define GDS_GWS_RESET0__RESOURCE8_RESET_MASK                                                                  0x00000100L
#define GDS_GWS_RESET0__RESOURCE9_RESET_MASK                                                                  0x00000200L
#define GDS_GWS_RESET0__RESOURCE10_RESET_MASK                                                                 0x00000400L
#define GDS_GWS_RESET0__RESOURCE11_RESET_MASK                                                                 0x00000800L
#define GDS_GWS_RESET0__RESOURCE12_RESET_MASK                                                                 0x00001000L
#define GDS_GWS_RESET0__RESOURCE13_RESET_MASK                                                                 0x00002000L
#define GDS_GWS_RESET0__RESOURCE14_RESET_MASK                                                                 0x00004000L
#define GDS_GWS_RESET0__RESOURCE15_RESET_MASK                                                                 0x00008000L
#define GDS_GWS_RESET0__RESOURCE16_RESET_MASK                                                                 0x00010000L
#define GDS_GWS_RESET0__RESOURCE17_RESET_MASK                                                                 0x00020000L
#define GDS_GWS_RESET0__RESOURCE18_RESET_MASK                                                                 0x00040000L
#define GDS_GWS_RESET0__RESOURCE19_RESET_MASK                                                                 0x00080000L
#define GDS_GWS_RESET0__RESOURCE20_RESET_MASK                                                                 0x00100000L
#define GDS_GWS_RESET0__RESOURCE21_RESET_MASK                                                                 0x00200000L
#define GDS_GWS_RESET0__RESOURCE22_RESET_MASK                                                                 0x00400000L
#define GDS_GWS_RESET0__RESOURCE23_RESET_MASK                                                                 0x00800000L
#define GDS_GWS_RESET0__RESOURCE24_RESET_MASK                                                                 0x01000000L
#define GDS_GWS_RESET0__RESOURCE25_RESET_MASK                                                                 0x02000000L
#define GDS_GWS_RESET0__RESOURCE26_RESET_MASK                                                                 0x04000000L
#define GDS_GWS_RESET0__RESOURCE27_RESET_MASK                                                                 0x08000000L
#define GDS_GWS_RESET0__RESOURCE28_RESET_MASK                                                                 0x10000000L
#define GDS_GWS_RESET0__RESOURCE29_RESET_MASK                                                                 0x20000000L
#define GDS_GWS_RESET0__RESOURCE30_RESET_MASK                                                                 0x40000000L
#define GDS_GWS_RESET0__RESOURCE31_RESET_MASK                                                                 0x80000000L
//GDS_GWS_RESET1
#define GDS_GWS_RESET1__RESOURCE32_RESET__SHIFT                                                               0x0
#define GDS_GWS_RESET1__RESOURCE33_RESET__SHIFT                                                               0x1
#define GDS_GWS_RESET1__RESOURCE34_RESET__SHIFT                                                               0x2
#define GDS_GWS_RESET1__RESOURCE35_RESET__SHIFT                                                               0x3
#define GDS_GWS_RESET1__RESOURCE36_RESET__SHIFT                                                               0x4
#define GDS_GWS_RESET1__RESOURCE37_RESET__SHIFT                                                               0x5
#define GDS_GWS_RESET1__RESOURCE38_RESET__SHIFT                                                               0x6
#define GDS_GWS_RESET1__RESOURCE39_RESET__SHIFT                                                               0x7
#define GDS_GWS_RESET1__RESOURCE40_RESET__SHIFT                                                               0x8
#define GDS_GWS_RESET1__RESOURCE41_RESET__SHIFT                                                               0x9
#define GDS_GWS_RESET1__RESOURCE42_RESET__SHIFT                                                               0xa
#define GDS_GWS_RESET1__RESOURCE43_RESET__SHIFT                                                               0xb
#define GDS_GWS_RESET1__RESOURCE44_RESET__SHIFT                                                               0xc
#define GDS_GWS_RESET1__RESOURCE45_RESET__SHIFT                                                               0xd
#define GDS_GWS_RESET1__RESOURCE46_RESET__SHIFT                                                               0xe
#define GDS_GWS_RESET1__RESOURCE47_RESET__SHIFT                                                               0xf
#define GDS_GWS_RESET1__RESOURCE48_RESET__SHIFT                                                               0x10
#define GDS_GWS_RESET1__RESOURCE49_RESET__SHIFT                                                               0x11
#define GDS_GWS_RESET1__RESOURCE50_RESET__SHIFT                                                               0x12
#define GDS_GWS_RESET1__RESOURCE51_RESET__SHIFT                                                               0x13
#define GDS_GWS_RESET1__RESOURCE52_RESET__SHIFT                                                               0x14
#define GDS_GWS_RESET1__RESOURCE53_RESET__SHIFT                                                               0x15
#define GDS_GWS_RESET1__RESOURCE54_RESET__SHIFT                                                               0x16
#define GDS_GWS_RESET1__RESOURCE55_RESET__SHIFT                                                               0x17
#define GDS_GWS_RESET1__RESOURCE56_RESET__SHIFT                                                               0x18
#define GDS_GWS_RESET1__RESOURCE57_RESET__SHIFT                                                               0x19
#define GDS_GWS_RESET1__RESOURCE58_RESET__SHIFT                                                               0x1a
#define GDS_GWS_RESET1__RESOURCE59_RESET__SHIFT                                                               0x1b
#define GDS_GWS_RESET1__RESOURCE60_RESET__SHIFT                                                               0x1c
#define GDS_GWS_RESET1__RESOURCE61_RESET__SHIFT                                                               0x1d
#define GDS_GWS_RESET1__RESOURCE62_RESET__SHIFT                                                               0x1e
#define GDS_GWS_RESET1__RESOURCE63_RESET__SHIFT                                                               0x1f
#define GDS_GWS_RESET1__RESOURCE32_RESET_MASK                                                                 0x00000001L
#define GDS_GWS_RESET1__RESOURCE33_RESET_MASK                                                                 0x00000002L
#define GDS_GWS_RESET1__RESOURCE34_RESET_MASK                                                                 0x00000004L
#define GDS_GWS_RESET1__RESOURCE35_RESET_MASK                                                                 0x00000008L
#define GDS_GWS_RESET1__RESOURCE36_RESET_MASK                                                                 0x00000010L
#define GDS_GWS_RESET1__RESOURCE37_RESET_MASK                                                                 0x00000020L
#define GDS_GWS_RESET1__RESOURCE38_RESET_MASK                                                                 0x00000040L
#define GDS_GWS_RESET1__RESOURCE39_RESET_MASK                                                                 0x00000080L
#define GDS_GWS_RESET1__RESOURCE40_RESET_MASK                                                                 0x00000100L
#define GDS_GWS_RESET1__RESOURCE41_RESET_MASK                                                                 0x00000200L
#define GDS_GWS_RESET1__RESOURCE42_RESET_MASK                                                                 0x00000400L
#define GDS_GWS_RESET1__RESOURCE43_RESET_MASK                                                                 0x00000800L
#define GDS_GWS_RESET1__RESOURCE44_RESET_MASK                                                                 0x00001000L
#define GDS_GWS_RESET1__RESOURCE45_RESET_MASK                                                                 0x00002000L
#define GDS_GWS_RESET1__RESOURCE46_RESET_MASK                                                                 0x00004000L
#define GDS_GWS_RESET1__RESOURCE47_RESET_MASK                                                                 0x00008000L
#define GDS_GWS_RESET1__RESOURCE48_RESET_MASK                                                                 0x00010000L
#define GDS_GWS_RESET1__RESOURCE49_RESET_MASK                                                                 0x00020000L
#define GDS_GWS_RESET1__RESOURCE50_RESET_MASK                                                                 0x00040000L
#define GDS_GWS_RESET1__RESOURCE51_RESET_MASK                                                                 0x00080000L
#define GDS_GWS_RESET1__RESOURCE52_RESET_MASK                                                                 0x00100000L
#define GDS_GWS_RESET1__RESOURCE53_RESET_MASK                                                                 0x00200000L
#define GDS_GWS_RESET1__RESOURCE54_RESET_MASK                                                                 0x00400000L
#define GDS_GWS_RESET1__RESOURCE55_RESET_MASK                                                                 0x00800000L
#define GDS_GWS_RESET1__RESOURCE56_RESET_MASK                                                                 0x01000000L
#define GDS_GWS_RESET1__RESOURCE57_RESET_MASK                                                                 0x02000000L
#define GDS_GWS_RESET1__RESOURCE58_RESET_MASK                                                                 0x04000000L
#define GDS_GWS_RESET1__RESOURCE59_RESET_MASK                                                                 0x08000000L
#define GDS_GWS_RESET1__RESOURCE60_RESET_MASK                                                                 0x10000000L
#define GDS_GWS_RESET1__RESOURCE61_RESET_MASK                                                                 0x20000000L
#define GDS_GWS_RESET1__RESOURCE62_RESET_MASK                                                                 0x40000000L
#define GDS_GWS_RESET1__RESOURCE63_RESET_MASK                                                                 0x80000000L
//GDS_GWS_RESOURCE_RESET
#define GDS_GWS_RESOURCE_RESET__RESET__SHIFT                                                                  0x0
#define GDS_GWS_RESOURCE_RESET__RESOURCE_ID__SHIFT                                                            0x8
#define GDS_GWS_RESOURCE_RESET__RESET_MASK                                                                    0x00000001L
#define GDS_GWS_RESOURCE_RESET__RESOURCE_ID_MASK                                                              0x0000FF00L
//GDS_COMPUTE_MAX_WAVE_ID
#define GDS_COMPUTE_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                           0x0
#define GDS_COMPUTE_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                             0x00000FFFL
//GDS_OA_RESET_MASK
#define GDS_OA_RESET_MASK__ME0_GFXHP3D_PIX_RESET__SHIFT                                                       0x0
#define GDS_OA_RESET_MASK__ME0_GFXHP3D_VTX_RESET__SHIFT                                                       0x1
#define GDS_OA_RESET_MASK__ME0_CS_RESET__SHIFT                                                                0x2
#define GDS_OA_RESET_MASK__ME0_GFXHP3D_GS_RESET__SHIFT                                                        0x3
#define GDS_OA_RESET_MASK__ME1_PIPE0_RESET__SHIFT                                                             0x4
#define GDS_OA_RESET_MASK__ME1_PIPE1_RESET__SHIFT                                                             0x5
#define GDS_OA_RESET_MASK__ME1_PIPE2_RESET__SHIFT                                                             0x6
#define GDS_OA_RESET_MASK__ME1_PIPE3_RESET__SHIFT                                                             0x7
#define GDS_OA_RESET_MASK__ME2_PIPE0_RESET__SHIFT                                                             0x8
#define GDS_OA_RESET_MASK__ME2_PIPE1_RESET__SHIFT                                                             0x9
#define GDS_OA_RESET_MASK__ME2_PIPE2_RESET__SHIFT                                                             0xa
#define GDS_OA_RESET_MASK__ME2_PIPE3_RESET__SHIFT                                                             0xb
#define GDS_OA_RESET_MASK__UNUSED1__SHIFT                                                                     0xc
#define GDS_OA_RESET_MASK__ME0_GFXHP3D_PIX_RESET_MASK                                                         0x00000001L
#define GDS_OA_RESET_MASK__ME0_GFXHP3D_VTX_RESET_MASK                                                         0x00000002L
#define GDS_OA_RESET_MASK__ME0_CS_RESET_MASK                                                                  0x00000004L
#define GDS_OA_RESET_MASK__ME0_GFXHP3D_GS_RESET_MASK                                                          0x00000008L
#define GDS_OA_RESET_MASK__ME1_PIPE0_RESET_MASK                                                               0x00000010L
#define GDS_OA_RESET_MASK__ME1_PIPE1_RESET_MASK                                                               0x00000020L
#define GDS_OA_RESET_MASK__ME1_PIPE2_RESET_MASK                                                               0x00000040L
#define GDS_OA_RESET_MASK__ME1_PIPE3_RESET_MASK                                                               0x00000080L
#define GDS_OA_RESET_MASK__ME2_PIPE0_RESET_MASK                                                               0x00000100L
#define GDS_OA_RESET_MASK__ME2_PIPE1_RESET_MASK                                                               0x00000200L
#define GDS_OA_RESET_MASK__ME2_PIPE2_RESET_MASK                                                               0x00000400L
#define GDS_OA_RESET_MASK__ME2_PIPE3_RESET_MASK                                                               0x00000800L
#define GDS_OA_RESET_MASK__UNUSED1_MASK                                                                       0xFFFFF000L
//GDS_OA_RESET
#define GDS_OA_RESET__RESET__SHIFT                                                                            0x0
#define GDS_OA_RESET__PIPE_ID__SHIFT                                                                          0x8
#define GDS_OA_RESET__RESET_MASK                                                                              0x00000001L
#define GDS_OA_RESET__PIPE_ID_MASK                                                                            0x0000FF00L
//GDS_ENHANCE
#define GDS_ENHANCE__MISC__SHIFT                                                                              0x0
#define GDS_ENHANCE__AUTO_INC_INDEX__SHIFT                                                                    0x10
#define GDS_ENHANCE__CGPG_RESTORE__SHIFT                                                                      0x11
#define GDS_ENHANCE__RD_BUF_TAG_MISS__SHIFT                                                                   0x12
#define GDS_ENHANCE__GDSA_PC_CGTS_DIS__SHIFT                                                                  0x13
#define GDS_ENHANCE__GDSO_PC_CGTS_DIS__SHIFT                                                                  0x14
#define GDS_ENHANCE__WD_GDS_CSB_OVERRIDE__SHIFT                                                               0x15
#define GDS_ENHANCE__GDS_CLK_ENHANCE_DIS__SHIFT                                                               0x16
#define GDS_ENHANCE__DS_MEM_CLK_GATE_DIS__SHIFT                                                               0x17
#define GDS_ENHANCE__UNUSED__SHIFT                                                                            0x18
#define GDS_ENHANCE__MISC_MASK                                                                                0x0000FFFFL
#define GDS_ENHANCE__AUTO_INC_INDEX_MASK                                                                      0x00010000L
#define GDS_ENHANCE__CGPG_RESTORE_MASK                                                                        0x00020000L
#define GDS_ENHANCE__RD_BUF_TAG_MISS_MASK                                                                     0x00040000L
#define GDS_ENHANCE__GDSA_PC_CGTS_DIS_MASK                                                                    0x00080000L
#define GDS_ENHANCE__GDSO_PC_CGTS_DIS_MASK                                                                    0x00100000L
#define GDS_ENHANCE__WD_GDS_CSB_OVERRIDE_MASK                                                                 0x00200000L
#define GDS_ENHANCE__GDS_CLK_ENHANCE_DIS_MASK                                                                 0x00400000L
#define GDS_ENHANCE__DS_MEM_CLK_GATE_DIS_MASK                                                                 0x00800000L
#define GDS_ENHANCE__UNUSED_MASK                                                                              0xFF000000L
//GDS_OA_CGPG_RESTORE
#define GDS_OA_CGPG_RESTORE__VMID__SHIFT                                                                      0x0
#define GDS_OA_CGPG_RESTORE__MEID__SHIFT                                                                      0x8
#define GDS_OA_CGPG_RESTORE__PIPEID__SHIFT                                                                    0xc
#define GDS_OA_CGPG_RESTORE__QUEUEID__SHIFT                                                                   0x10
#define GDS_OA_CGPG_RESTORE__UNUSED__SHIFT                                                                    0x14
#define GDS_OA_CGPG_RESTORE__VMID_MASK                                                                        0x000000FFL
#define GDS_OA_CGPG_RESTORE__MEID_MASK                                                                        0x00000F00L
#define GDS_OA_CGPG_RESTORE__PIPEID_MASK                                                                      0x0000F000L
#define GDS_OA_CGPG_RESTORE__QUEUEID_MASK                                                                     0x000F0000L
#define GDS_OA_CGPG_RESTORE__UNUSED_MASK                                                                      0xFFF00000L
//GDS_CS_CTXSW_STATUS
#define GDS_CS_CTXSW_STATUS__R__SHIFT                                                                         0x0
#define GDS_CS_CTXSW_STATUS__W__SHIFT                                                                         0x1
#define GDS_CS_CTXSW_STATUS__UNUSED__SHIFT                                                                    0x2
#define GDS_CS_CTXSW_STATUS__R_MASK                                                                           0x00000001L
#define GDS_CS_CTXSW_STATUS__W_MASK                                                                           0x00000002L
#define GDS_CS_CTXSW_STATUS__UNUSED_MASK                                                                      0xFFFFFFFCL
//GDS_CS_CTXSW_CNT0
#define GDS_CS_CTXSW_CNT0__UPDN__SHIFT                                                                        0x0
#define GDS_CS_CTXSW_CNT0__PTR__SHIFT                                                                         0x10
#define GDS_CS_CTXSW_CNT0__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_CS_CTXSW_CNT0__PTR_MASK                                                                           0xFFFF0000L
//GDS_CS_CTXSW_CNT1
#define GDS_CS_CTXSW_CNT1__UPDN__SHIFT                                                                        0x0
#define GDS_CS_CTXSW_CNT1__PTR__SHIFT                                                                         0x10
#define GDS_CS_CTXSW_CNT1__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_CS_CTXSW_CNT1__PTR_MASK                                                                           0xFFFF0000L
//GDS_CS_CTXSW_CNT2
#define GDS_CS_CTXSW_CNT2__UPDN__SHIFT                                                                        0x0
#define GDS_CS_CTXSW_CNT2__PTR__SHIFT                                                                         0x10
#define GDS_CS_CTXSW_CNT2__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_CS_CTXSW_CNT2__PTR_MASK                                                                           0xFFFF0000L
//GDS_CS_CTXSW_CNT3
#define GDS_CS_CTXSW_CNT3__UPDN__SHIFT                                                                        0x0
#define GDS_CS_CTXSW_CNT3__PTR__SHIFT                                                                         0x10
#define GDS_CS_CTXSW_CNT3__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_CS_CTXSW_CNT3__PTR_MASK                                                                           0xFFFF0000L
//GDS_GFX_CTXSW_STATUS
#define GDS_GFX_CTXSW_STATUS__R__SHIFT                                                                        0x0
#define GDS_GFX_CTXSW_STATUS__W__SHIFT                                                                        0x1
#define GDS_GFX_CTXSW_STATUS__UNUSED__SHIFT                                                                   0x2
#define GDS_GFX_CTXSW_STATUS__R_MASK                                                                          0x00000001L
#define GDS_GFX_CTXSW_STATUS__W_MASK                                                                          0x00000002L
#define GDS_GFX_CTXSW_STATUS__UNUSED_MASK                                                                     0xFFFFFFFCL
//GDS_VS_CTXSW_CNT0
#define GDS_VS_CTXSW_CNT0__UPDN__SHIFT                                                                        0x0
#define GDS_VS_CTXSW_CNT0__PTR__SHIFT                                                                         0x10
#define GDS_VS_CTXSW_CNT0__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_VS_CTXSW_CNT0__PTR_MASK                                                                           0xFFFF0000L
//GDS_VS_CTXSW_CNT1
#define GDS_VS_CTXSW_CNT1__UPDN__SHIFT                                                                        0x0
#define GDS_VS_CTXSW_CNT1__PTR__SHIFT                                                                         0x10
#define GDS_VS_CTXSW_CNT1__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_VS_CTXSW_CNT1__PTR_MASK                                                                           0xFFFF0000L
//GDS_VS_CTXSW_CNT2
#define GDS_VS_CTXSW_CNT2__UPDN__SHIFT                                                                        0x0
#define GDS_VS_CTXSW_CNT2__PTR__SHIFT                                                                         0x10
#define GDS_VS_CTXSW_CNT2__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_VS_CTXSW_CNT2__PTR_MASK                                                                           0xFFFF0000L
//GDS_VS_CTXSW_CNT3
#define GDS_VS_CTXSW_CNT3__UPDN__SHIFT                                                                        0x0
#define GDS_VS_CTXSW_CNT3__PTR__SHIFT                                                                         0x10
#define GDS_VS_CTXSW_CNT3__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_VS_CTXSW_CNT3__PTR_MASK                                                                           0xFFFF0000L
//GDS_PS0_CTXSW_CNT0
#define GDS_PS0_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS0_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS0_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS0_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS0_CTXSW_CNT1
#define GDS_PS0_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS0_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS0_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS0_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS0_CTXSW_CNT2
#define GDS_PS0_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS0_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS0_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS0_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS0_CTXSW_CNT3
#define GDS_PS0_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS0_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS0_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS0_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS1_CTXSW_CNT0
#define GDS_PS1_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS1_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS1_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS1_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS1_CTXSW_CNT1
#define GDS_PS1_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS1_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS1_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS1_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS1_CTXSW_CNT2
#define GDS_PS1_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS1_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS1_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS1_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS1_CTXSW_CNT3
#define GDS_PS1_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS1_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS1_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS1_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS2_CTXSW_CNT0
#define GDS_PS2_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS2_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS2_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS2_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS2_CTXSW_CNT1
#define GDS_PS2_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS2_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS2_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS2_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS2_CTXSW_CNT2
#define GDS_PS2_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS2_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS2_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS2_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS2_CTXSW_CNT3
#define GDS_PS2_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS2_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS2_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS2_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS3_CTXSW_CNT0
#define GDS_PS3_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS3_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS3_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS3_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS3_CTXSW_CNT1
#define GDS_PS3_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS3_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS3_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS3_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS3_CTXSW_CNT2
#define GDS_PS3_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS3_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS3_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS3_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS3_CTXSW_CNT3
#define GDS_PS3_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS3_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS3_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS3_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS4_CTXSW_CNT0
#define GDS_PS4_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS4_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS4_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS4_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS4_CTXSW_CNT1
#define GDS_PS4_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS4_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS4_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS4_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS4_CTXSW_CNT2
#define GDS_PS4_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS4_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS4_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS4_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS4_CTXSW_CNT3
#define GDS_PS4_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS4_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS4_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS4_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS5_CTXSW_CNT0
#define GDS_PS5_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS5_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS5_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS5_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS5_CTXSW_CNT1
#define GDS_PS5_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS5_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS5_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS5_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS5_CTXSW_CNT2
#define GDS_PS5_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS5_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS5_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS5_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS5_CTXSW_CNT3
#define GDS_PS5_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS5_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS5_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS5_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS6_CTXSW_CNT0
#define GDS_PS6_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS6_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS6_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS6_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS6_CTXSW_CNT1
#define GDS_PS6_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS6_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS6_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS6_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS6_CTXSW_CNT2
#define GDS_PS6_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS6_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS6_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS6_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS6_CTXSW_CNT3
#define GDS_PS6_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS6_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS6_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS6_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS7_CTXSW_CNT0
#define GDS_PS7_CTXSW_CNT0__UPDN__SHIFT                                                                       0x0
#define GDS_PS7_CTXSW_CNT0__PTR__SHIFT                                                                        0x10
#define GDS_PS7_CTXSW_CNT0__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS7_CTXSW_CNT0__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS7_CTXSW_CNT1
#define GDS_PS7_CTXSW_CNT1__UPDN__SHIFT                                                                       0x0
#define GDS_PS7_CTXSW_CNT1__PTR__SHIFT                                                                        0x10
#define GDS_PS7_CTXSW_CNT1__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS7_CTXSW_CNT1__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS7_CTXSW_CNT2
#define GDS_PS7_CTXSW_CNT2__UPDN__SHIFT                                                                       0x0
#define GDS_PS7_CTXSW_CNT2__PTR__SHIFT                                                                        0x10
#define GDS_PS7_CTXSW_CNT2__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS7_CTXSW_CNT2__PTR_MASK                                                                          0xFFFF0000L
//GDS_PS7_CTXSW_CNT3
#define GDS_PS7_CTXSW_CNT3__UPDN__SHIFT                                                                       0x0
#define GDS_PS7_CTXSW_CNT3__PTR__SHIFT                                                                        0x10
#define GDS_PS7_CTXSW_CNT3__UPDN_MASK                                                                         0x0000FFFFL
#define GDS_PS7_CTXSW_CNT3__PTR_MASK                                                                          0xFFFF0000L
//GDS_GS_CTXSW_CNT0
#define GDS_GS_CTXSW_CNT0__UPDN__SHIFT                                                                        0x0
#define GDS_GS_CTXSW_CNT0__PTR__SHIFT                                                                         0x10
#define GDS_GS_CTXSW_CNT0__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_GS_CTXSW_CNT0__PTR_MASK                                                                           0xFFFF0000L
//GDS_GS_CTXSW_CNT1
#define GDS_GS_CTXSW_CNT1__UPDN__SHIFT                                                                        0x0
#define GDS_GS_CTXSW_CNT1__PTR__SHIFT                                                                         0x10
#define GDS_GS_CTXSW_CNT1__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_GS_CTXSW_CNT1__PTR_MASK                                                                           0xFFFF0000L
//GDS_GS_CTXSW_CNT2
#define GDS_GS_CTXSW_CNT2__UPDN__SHIFT                                                                        0x0
#define GDS_GS_CTXSW_CNT2__PTR__SHIFT                                                                         0x10
#define GDS_GS_CTXSW_CNT2__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_GS_CTXSW_CNT2__PTR_MASK                                                                           0xFFFF0000L
//GDS_GS_CTXSW_CNT3
#define GDS_GS_CTXSW_CNT3__UPDN__SHIFT                                                                        0x0
#define GDS_GS_CTXSW_CNT3__PTR__SHIFT                                                                         0x10
#define GDS_GS_CTXSW_CNT3__UPDN_MASK                                                                          0x0000FFFFL
#define GDS_GS_CTXSW_CNT3__PTR_MASK                                                                           0xFFFF0000L


// addressBlock: gc_gfxdec0
//DB_RENDER_CONTROL
#define DB_RENDER_CONTROL__DEPTH_CLEAR_ENABLE__SHIFT                                                          0x0
#define DB_RENDER_CONTROL__STENCIL_CLEAR_ENABLE__SHIFT                                                        0x1
#define DB_RENDER_CONTROL__DEPTH_COPY__SHIFT                                                                  0x2
#define DB_RENDER_CONTROL__STENCIL_COPY__SHIFT                                                                0x3
#define DB_RENDER_CONTROL__RESUMMARIZE_ENABLE__SHIFT                                                          0x4
#define DB_RENDER_CONTROL__STENCIL_COMPRESS_DISABLE__SHIFT                                                    0x5
#define DB_RENDER_CONTROL__DEPTH_COMPRESS_DISABLE__SHIFT                                                      0x6
#define DB_RENDER_CONTROL__COPY_CENTROID__SHIFT                                                               0x7
#define DB_RENDER_CONTROL__COPY_SAMPLE__SHIFT                                                                 0x8
#define DB_RENDER_CONTROL__DECOMPRESS_ENABLE__SHIFT                                                           0xc
#define DB_RENDER_CONTROL__DEPTH_CLEAR_ENABLE_MASK                                                            0x00000001L
#define DB_RENDER_CONTROL__STENCIL_CLEAR_ENABLE_MASK                                                          0x00000002L
#define DB_RENDER_CONTROL__DEPTH_COPY_MASK                                                                    0x00000004L
#define DB_RENDER_CONTROL__STENCIL_COPY_MASK                                                                  0x00000008L
#define DB_RENDER_CONTROL__RESUMMARIZE_ENABLE_MASK                                                            0x00000010L
#define DB_RENDER_CONTROL__STENCIL_COMPRESS_DISABLE_MASK                                                      0x00000020L
#define DB_RENDER_CONTROL__DEPTH_COMPRESS_DISABLE_MASK                                                        0x00000040L
#define DB_RENDER_CONTROL__COPY_CENTROID_MASK                                                                 0x00000080L
#define DB_RENDER_CONTROL__COPY_SAMPLE_MASK                                                                   0x00000F00L
#define DB_RENDER_CONTROL__DECOMPRESS_ENABLE_MASK                                                             0x00001000L
//DB_COUNT_CONTROL
#define DB_COUNT_CONTROL__ZPASS_INCREMENT_DISABLE__SHIFT                                                      0x0
#define DB_COUNT_CONTROL__PERFECT_ZPASS_COUNTS__SHIFT                                                         0x1
#define DB_COUNT_CONTROL__SAMPLE_RATE__SHIFT                                                                  0x4
#define DB_COUNT_CONTROL__ZPASS_ENABLE__SHIFT                                                                 0x8
#define DB_COUNT_CONTROL__ZFAIL_ENABLE__SHIFT                                                                 0xc
#define DB_COUNT_CONTROL__SFAIL_ENABLE__SHIFT                                                                 0x10
#define DB_COUNT_CONTROL__DBFAIL_ENABLE__SHIFT                                                                0x14
#define DB_COUNT_CONTROL__SLICE_EVEN_ENABLE__SHIFT                                                            0x18
#define DB_COUNT_CONTROL__SLICE_ODD_ENABLE__SHIFT                                                             0x1c
#define DB_COUNT_CONTROL__ZPASS_INCREMENT_DISABLE_MASK                                                        0x00000001L
#define DB_COUNT_CONTROL__PERFECT_ZPASS_COUNTS_MASK                                                           0x00000002L
#define DB_COUNT_CONTROL__SAMPLE_RATE_MASK                                                                    0x00000070L
#define DB_COUNT_CONTROL__ZPASS_ENABLE_MASK                                                                   0x00000F00L
#define DB_COUNT_CONTROL__ZFAIL_ENABLE_MASK                                                                   0x0000F000L
#define DB_COUNT_CONTROL__SFAIL_ENABLE_MASK                                                                   0x000F0000L
#define DB_COUNT_CONTROL__DBFAIL_ENABLE_MASK                                                                  0x00F00000L
#define DB_COUNT_CONTROL__SLICE_EVEN_ENABLE_MASK                                                              0x0F000000L
#define DB_COUNT_CONTROL__SLICE_ODD_ENABLE_MASK                                                               0xF0000000L
//DB_DEPTH_VIEW
#define DB_DEPTH_VIEW__SLICE_START__SHIFT                                                                     0x0
#define DB_DEPTH_VIEW__SLICE_MAX__SHIFT                                                                       0xd
#define DB_DEPTH_VIEW__Z_READ_ONLY__SHIFT                                                                     0x18
#define DB_DEPTH_VIEW__STENCIL_READ_ONLY__SHIFT                                                               0x19
#define DB_DEPTH_VIEW__MIPID__SHIFT                                                                           0x1a
#define DB_DEPTH_VIEW__SLICE_START_MASK                                                                       0x000007FFL
#define DB_DEPTH_VIEW__SLICE_MAX_MASK                                                                         0x00FFE000L
#define DB_DEPTH_VIEW__Z_READ_ONLY_MASK                                                                       0x01000000L
#define DB_DEPTH_VIEW__STENCIL_READ_ONLY_MASK                                                                 0x02000000L
#define DB_DEPTH_VIEW__MIPID_MASK                                                                             0x3C000000L
//DB_RENDER_OVERRIDE
#define DB_RENDER_OVERRIDE__FORCE_HIZ_ENABLE__SHIFT                                                           0x0
#define DB_RENDER_OVERRIDE__FORCE_HIS_ENABLE0__SHIFT                                                          0x2
#define DB_RENDER_OVERRIDE__FORCE_HIS_ENABLE1__SHIFT                                                          0x4
#define DB_RENDER_OVERRIDE__FORCE_SHADER_Z_ORDER__SHIFT                                                       0x6
#define DB_RENDER_OVERRIDE__FAST_Z_DISABLE__SHIFT                                                             0x7
#define DB_RENDER_OVERRIDE__FAST_STENCIL_DISABLE__SHIFT                                                       0x8
#define DB_RENDER_OVERRIDE__NOOP_CULL_DISABLE__SHIFT                                                          0x9
#define DB_RENDER_OVERRIDE__FORCE_COLOR_KILL__SHIFT                                                           0xa
#define DB_RENDER_OVERRIDE__FORCE_Z_READ__SHIFT                                                               0xb
#define DB_RENDER_OVERRIDE__FORCE_STENCIL_READ__SHIFT                                                         0xc
#define DB_RENDER_OVERRIDE__FORCE_FULL_Z_RANGE__SHIFT                                                         0xd
#define DB_RENDER_OVERRIDE__FORCE_QC_SMASK_CONFLICT__SHIFT                                                    0xf
#define DB_RENDER_OVERRIDE__DISABLE_VIEWPORT_CLAMP__SHIFT                                                     0x10
#define DB_RENDER_OVERRIDE__IGNORE_SC_ZRANGE__SHIFT                                                           0x11
#define DB_RENDER_OVERRIDE__DISABLE_FULLY_COVERED__SHIFT                                                      0x12
#define DB_RENDER_OVERRIDE__FORCE_Z_LIMIT_SUMM__SHIFT                                                         0x13
#define DB_RENDER_OVERRIDE__MAX_TILES_IN_DTT__SHIFT                                                           0x15
#define DB_RENDER_OVERRIDE__DISABLE_TILE_RATE_TILES__SHIFT                                                    0x1a
#define DB_RENDER_OVERRIDE__FORCE_Z_DIRTY__SHIFT                                                              0x1b
#define DB_RENDER_OVERRIDE__FORCE_STENCIL_DIRTY__SHIFT                                                        0x1c
#define DB_RENDER_OVERRIDE__FORCE_Z_VALID__SHIFT                                                              0x1d
#define DB_RENDER_OVERRIDE__FORCE_STENCIL_VALID__SHIFT                                                        0x1e
#define DB_RENDER_OVERRIDE__PRESERVE_COMPRESSION__SHIFT                                                       0x1f
#define DB_RENDER_OVERRIDE__FORCE_HIZ_ENABLE_MASK                                                             0x00000003L
#define DB_RENDER_OVERRIDE__FORCE_HIS_ENABLE0_MASK                                                            0x0000000CL
#define DB_RENDER_OVERRIDE__FORCE_HIS_ENABLE1_MASK                                                            0x00000030L
#define DB_RENDER_OVERRIDE__FORCE_SHADER_Z_ORDER_MASK                                                         0x00000040L
#define DB_RENDER_OVERRIDE__FAST_Z_DISABLE_MASK                                                               0x00000080L
#define DB_RENDER_OVERRIDE__FAST_STENCIL_DISABLE_MASK                                                         0x00000100L
#define DB_RENDER_OVERRIDE__NOOP_CULL_DISABLE_MASK                                                            0x00000200L
#define DB_RENDER_OVERRIDE__FORCE_COLOR_KILL_MASK                                                             0x00000400L
#define DB_RENDER_OVERRIDE__FORCE_Z_READ_MASK                                                                 0x00000800L
#define DB_RENDER_OVERRIDE__FORCE_STENCIL_READ_MASK                                                           0x00001000L
#define DB_RENDER_OVERRIDE__FORCE_FULL_Z_RANGE_MASK                                                           0x00006000L
#define DB_RENDER_OVERRIDE__FORCE_QC_SMASK_CONFLICT_MASK                                                      0x00008000L
#define DB_RENDER_OVERRIDE__DISABLE_VIEWPORT_CLAMP_MASK                                                       0x00010000L
#define DB_RENDER_OVERRIDE__IGNORE_SC_ZRANGE_MASK                                                             0x00020000L
#define DB_RENDER_OVERRIDE__DISABLE_FULLY_COVERED_MASK                                                        0x00040000L
#define DB_RENDER_OVERRIDE__FORCE_Z_LIMIT_SUMM_MASK                                                           0x00180000L
#define DB_RENDER_OVERRIDE__MAX_TILES_IN_DTT_MASK                                                             0x03E00000L
#define DB_RENDER_OVERRIDE__DISABLE_TILE_RATE_TILES_MASK                                                      0x04000000L
#define DB_RENDER_OVERRIDE__FORCE_Z_DIRTY_MASK                                                                0x08000000L
#define DB_RENDER_OVERRIDE__FORCE_STENCIL_DIRTY_MASK                                                          0x10000000L
#define DB_RENDER_OVERRIDE__FORCE_Z_VALID_MASK                                                                0x20000000L
#define DB_RENDER_OVERRIDE__FORCE_STENCIL_VALID_MASK                                                          0x40000000L
#define DB_RENDER_OVERRIDE__PRESERVE_COMPRESSION_MASK                                                         0x80000000L
//DB_RENDER_OVERRIDE2
#define DB_RENDER_OVERRIDE2__PARTIAL_SQUAD_LAUNCH_CONTROL__SHIFT                                              0x0
#define DB_RENDER_OVERRIDE2__PARTIAL_SQUAD_LAUNCH_COUNTDOWN__SHIFT                                            0x2
#define DB_RENDER_OVERRIDE2__DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION__SHIFT                                       0x5
#define DB_RENDER_OVERRIDE2__DISABLE_SMEM_EXPCLEAR_OPTIMIZATION__SHIFT                                        0x6
#define DB_RENDER_OVERRIDE2__DISABLE_COLOR_ON_VALIDATION__SHIFT                                               0x7
#define DB_RENDER_OVERRIDE2__DECOMPRESS_Z_ON_FLUSH__SHIFT                                                     0x8
#define DB_RENDER_OVERRIDE2__DISABLE_REG_SNOOP__SHIFT                                                         0x9
#define DB_RENDER_OVERRIDE2__DEPTH_BOUNDS_HIER_DEPTH_DISABLE__SHIFT                                           0xa
#define DB_RENDER_OVERRIDE2__SEPARATE_HIZS_FUNC_ENABLE__SHIFT                                                 0xb
#define DB_RENDER_OVERRIDE2__HIZ_ZFUNC__SHIFT                                                                 0xc
#define DB_RENDER_OVERRIDE2__HIS_SFUNC_FF__SHIFT                                                              0xf
#define DB_RENDER_OVERRIDE2__HIS_SFUNC_BF__SHIFT                                                              0x12
#define DB_RENDER_OVERRIDE2__PRESERVE_ZRANGE__SHIFT                                                           0x15
#define DB_RENDER_OVERRIDE2__PRESERVE_SRESULTS__SHIFT                                                         0x16
#define DB_RENDER_OVERRIDE2__DISABLE_FAST_PASS__SHIFT                                                         0x17
#define DB_RENDER_OVERRIDE2__ALLOW_PARTIAL_RES_HIER_KILL__SHIFT                                               0x19
#define DB_RENDER_OVERRIDE2__PARTIAL_SQUAD_LAUNCH_CONTROL_MASK                                                0x00000003L
#define DB_RENDER_OVERRIDE2__PARTIAL_SQUAD_LAUNCH_COUNTDOWN_MASK                                              0x0000001CL
#define DB_RENDER_OVERRIDE2__DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION_MASK                                         0x00000020L
#define DB_RENDER_OVERRIDE2__DISABLE_SMEM_EXPCLEAR_OPTIMIZATION_MASK                                          0x00000040L
#define DB_RENDER_OVERRIDE2__DISABLE_COLOR_ON_VALIDATION_MASK                                                 0x00000080L
#define DB_RENDER_OVERRIDE2__DECOMPRESS_Z_ON_FLUSH_MASK                                                       0x00000100L
#define DB_RENDER_OVERRIDE2__DISABLE_REG_SNOOP_MASK                                                           0x00000200L
#define DB_RENDER_OVERRIDE2__DEPTH_BOUNDS_HIER_DEPTH_DISABLE_MASK                                             0x00000400L
#define DB_RENDER_OVERRIDE2__SEPARATE_HIZS_FUNC_ENABLE_MASK                                                   0x00000800L
#define DB_RENDER_OVERRIDE2__HIZ_ZFUNC_MASK                                                                   0x00007000L
#define DB_RENDER_OVERRIDE2__HIS_SFUNC_FF_MASK                                                                0x00038000L
#define DB_RENDER_OVERRIDE2__HIS_SFUNC_BF_MASK                                                                0x001C0000L
#define DB_RENDER_OVERRIDE2__PRESERVE_ZRANGE_MASK                                                             0x00200000L
#define DB_RENDER_OVERRIDE2__PRESERVE_SRESULTS_MASK                                                           0x00400000L
#define DB_RENDER_OVERRIDE2__DISABLE_FAST_PASS_MASK                                                           0x00800000L
#define DB_RENDER_OVERRIDE2__ALLOW_PARTIAL_RES_HIER_KILL_MASK                                                 0x02000000L
//DB_HTILE_DATA_BASE
#define DB_HTILE_DATA_BASE__BASE_256B__SHIFT                                                                  0x0
#define DB_HTILE_DATA_BASE__BASE_256B_MASK                                                                    0xFFFFFFFFL
//DB_HTILE_DATA_BASE_HI
#define DB_HTILE_DATA_BASE_HI__BASE_HI__SHIFT                                                                 0x0
#define DB_HTILE_DATA_BASE_HI__BASE_HI_MASK                                                                   0x000000FFL
//DB_DEPTH_SIZE
#define DB_DEPTH_SIZE__X_MAX__SHIFT                                                                           0x0
#define DB_DEPTH_SIZE__Y_MAX__SHIFT                                                                           0x10
#define DB_DEPTH_SIZE__X_MAX_MASK                                                                             0x00003FFFL
#define DB_DEPTH_SIZE__Y_MAX_MASK                                                                             0x3FFF0000L
//DB_DEPTH_BOUNDS_MIN
#define DB_DEPTH_BOUNDS_MIN__MIN__SHIFT                                                                       0x0
#define DB_DEPTH_BOUNDS_MIN__MIN_MASK                                                                         0xFFFFFFFFL
//DB_DEPTH_BOUNDS_MAX
#define DB_DEPTH_BOUNDS_MAX__MAX__SHIFT                                                                       0x0
#define DB_DEPTH_BOUNDS_MAX__MAX_MASK                                                                         0xFFFFFFFFL
//DB_STENCIL_CLEAR
#define DB_STENCIL_CLEAR__CLEAR__SHIFT                                                                        0x0
#define DB_STENCIL_CLEAR__CLEAR_MASK                                                                          0x000000FFL
//DB_DEPTH_CLEAR
#define DB_DEPTH_CLEAR__DEPTH_CLEAR__SHIFT                                                                    0x0
#define DB_DEPTH_CLEAR__DEPTH_CLEAR_MASK                                                                      0xFFFFFFFFL
//PA_SC_SCREEN_SCISSOR_TL
#define PA_SC_SCREEN_SCISSOR_TL__TL_X__SHIFT                                                                  0x0
#define PA_SC_SCREEN_SCISSOR_TL__TL_Y__SHIFT                                                                  0x10
#define PA_SC_SCREEN_SCISSOR_TL__TL_X_MASK                                                                    0x0000FFFFL
#define PA_SC_SCREEN_SCISSOR_TL__TL_Y_MASK                                                                    0xFFFF0000L
//PA_SC_SCREEN_SCISSOR_BR
#define PA_SC_SCREEN_SCISSOR_BR__BR_X__SHIFT                                                                  0x0
#define PA_SC_SCREEN_SCISSOR_BR__BR_Y__SHIFT                                                                  0x10
#define PA_SC_SCREEN_SCISSOR_BR__BR_X_MASK                                                                    0x0000FFFFL
#define PA_SC_SCREEN_SCISSOR_BR__BR_Y_MASK                                                                    0xFFFF0000L
//DB_Z_INFO
#define DB_Z_INFO__FORMAT__SHIFT                                                                              0x0
#define DB_Z_INFO__NUM_SAMPLES__SHIFT                                                                         0x2
#define DB_Z_INFO__SW_MODE__SHIFT                                                                             0x4
#define DB_Z_INFO__PARTIALLY_RESIDENT__SHIFT                                                                  0xc
#define DB_Z_INFO__FAULT_BEHAVIOR__SHIFT                                                                      0xd
#define DB_Z_INFO__ITERATE_FLUSH__SHIFT                                                                       0xf
#define DB_Z_INFO__MAXMIP__SHIFT                                                                              0x10
#define DB_Z_INFO__DECOMPRESS_ON_N_ZPLANES__SHIFT                                                             0x17
#define DB_Z_INFO__ALLOW_EXPCLEAR__SHIFT                                                                      0x1b
#define DB_Z_INFO__READ_SIZE__SHIFT                                                                           0x1c
#define DB_Z_INFO__TILE_SURFACE_ENABLE__SHIFT                                                                 0x1d
#define DB_Z_INFO__CLEAR_DISALLOWED__SHIFT                                                                    0x1e
#define DB_Z_INFO__ZRANGE_PRECISION__SHIFT                                                                    0x1f
#define DB_Z_INFO__FORMAT_MASK                                                                                0x00000003L
#define DB_Z_INFO__NUM_SAMPLES_MASK                                                                           0x0000000CL
#define DB_Z_INFO__SW_MODE_MASK                                                                               0x000001F0L
#define DB_Z_INFO__PARTIALLY_RESIDENT_MASK                                                                    0x00001000L
#define DB_Z_INFO__FAULT_BEHAVIOR_MASK                                                                        0x00006000L
#define DB_Z_INFO__ITERATE_FLUSH_MASK                                                                         0x00008000L
#define DB_Z_INFO__MAXMIP_MASK                                                                                0x000F0000L
#define DB_Z_INFO__DECOMPRESS_ON_N_ZPLANES_MASK                                                               0x07800000L
#define DB_Z_INFO__ALLOW_EXPCLEAR_MASK                                                                        0x08000000L
#define DB_Z_INFO__READ_SIZE_MASK                                                                             0x10000000L
#define DB_Z_INFO__TILE_SURFACE_ENABLE_MASK                                                                   0x20000000L
#define DB_Z_INFO__CLEAR_DISALLOWED_MASK                                                                      0x40000000L
#define DB_Z_INFO__ZRANGE_PRECISION_MASK                                                                      0x80000000L
//DB_STENCIL_INFO
#define DB_STENCIL_INFO__FORMAT__SHIFT                                                                        0x0
#define DB_STENCIL_INFO__SW_MODE__SHIFT                                                                       0x4
#define DB_STENCIL_INFO__PARTIALLY_RESIDENT__SHIFT                                                            0xc
#define DB_STENCIL_INFO__FAULT_BEHAVIOR__SHIFT                                                                0xd
#define DB_STENCIL_INFO__ITERATE_FLUSH__SHIFT                                                                 0xf
#define DB_STENCIL_INFO__ALLOW_EXPCLEAR__SHIFT                                                                0x1b
#define DB_STENCIL_INFO__TILE_STENCIL_DISABLE__SHIFT                                                          0x1d
#define DB_STENCIL_INFO__CLEAR_DISALLOWED__SHIFT                                                              0x1e
#define DB_STENCIL_INFO__FORMAT_MASK                                                                          0x00000001L
#define DB_STENCIL_INFO__SW_MODE_MASK                                                                         0x000001F0L
#define DB_STENCIL_INFO__PARTIALLY_RESIDENT_MASK                                                              0x00001000L
#define DB_STENCIL_INFO__FAULT_BEHAVIOR_MASK                                                                  0x00006000L
#define DB_STENCIL_INFO__ITERATE_FLUSH_MASK                                                                   0x00008000L
#define DB_STENCIL_INFO__ALLOW_EXPCLEAR_MASK                                                                  0x08000000L
#define DB_STENCIL_INFO__TILE_STENCIL_DISABLE_MASK                                                            0x20000000L
#define DB_STENCIL_INFO__CLEAR_DISALLOWED_MASK                                                                0x40000000L
//DB_Z_READ_BASE
#define DB_Z_READ_BASE__BASE_256B__SHIFT                                                                      0x0
#define DB_Z_READ_BASE__BASE_256B_MASK                                                                        0xFFFFFFFFL
//DB_Z_READ_BASE_HI
#define DB_Z_READ_BASE_HI__BASE_HI__SHIFT                                                                     0x0
#define DB_Z_READ_BASE_HI__BASE_HI_MASK                                                                       0x000000FFL
//DB_STENCIL_READ_BASE
#define DB_STENCIL_READ_BASE__BASE_256B__SHIFT                                                                0x0
#define DB_STENCIL_READ_BASE__BASE_256B_MASK                                                                  0xFFFFFFFFL
//DB_STENCIL_READ_BASE_HI
#define DB_STENCIL_READ_BASE_HI__BASE_HI__SHIFT                                                               0x0
#define DB_STENCIL_READ_BASE_HI__BASE_HI_MASK                                                                 0x000000FFL
//DB_Z_WRITE_BASE
#define DB_Z_WRITE_BASE__BASE_256B__SHIFT                                                                     0x0
#define DB_Z_WRITE_BASE__BASE_256B_MASK                                                                       0xFFFFFFFFL
//DB_Z_WRITE_BASE_HI
#define DB_Z_WRITE_BASE_HI__BASE_HI__SHIFT                                                                    0x0
#define DB_Z_WRITE_BASE_HI__BASE_HI_MASK                                                                      0x000000FFL
//DB_STENCIL_WRITE_BASE
#define DB_STENCIL_WRITE_BASE__BASE_256B__SHIFT                                                               0x0
#define DB_STENCIL_WRITE_BASE__BASE_256B_MASK                                                                 0xFFFFFFFFL
//DB_STENCIL_WRITE_BASE_HI
#define DB_STENCIL_WRITE_BASE_HI__BASE_HI__SHIFT                                                              0x0
#define DB_STENCIL_WRITE_BASE_HI__BASE_HI_MASK                                                                0x000000FFL
//DB_DFSM_CONTROL
#define DB_DFSM_CONTROL__PUNCHOUT_MODE__SHIFT                                                                 0x0
#define DB_DFSM_CONTROL__POPS_DRAIN_PS_ON_OVERLAP__SHIFT                                                      0x2
#define DB_DFSM_CONTROL__DISALLOW_OVERFLOW__SHIFT                                                             0x3
#define DB_DFSM_CONTROL__PUNCHOUT_MODE_MASK                                                                   0x00000003L
#define DB_DFSM_CONTROL__POPS_DRAIN_PS_ON_OVERLAP_MASK                                                        0x00000004L
#define DB_DFSM_CONTROL__DISALLOW_OVERFLOW_MASK                                                               0x00000008L
//DB_Z_INFO2
#define DB_Z_INFO2__EPITCH__SHIFT                                                                             0x0
#define DB_Z_INFO2__EPITCH_MASK                                                                               0x0000FFFFL
//DB_STENCIL_INFO2
#define DB_STENCIL_INFO2__EPITCH__SHIFT                                                                       0x0
#define DB_STENCIL_INFO2__EPITCH_MASK                                                                         0x0000FFFFL
//COHER_DEST_BASE_HI_0
#define COHER_DEST_BASE_HI_0__DEST_BASE_HI_256B__SHIFT                                                        0x0
#define COHER_DEST_BASE_HI_0__DEST_BASE_HI_256B_MASK                                                          0x000000FFL
//COHER_DEST_BASE_HI_1
#define COHER_DEST_BASE_HI_1__DEST_BASE_HI_256B__SHIFT                                                        0x0
#define COHER_DEST_BASE_HI_1__DEST_BASE_HI_256B_MASK                                                          0x000000FFL
//COHER_DEST_BASE_HI_2
#define COHER_DEST_BASE_HI_2__DEST_BASE_HI_256B__SHIFT                                                        0x0
#define COHER_DEST_BASE_HI_2__DEST_BASE_HI_256B_MASK                                                          0x000000FFL
//COHER_DEST_BASE_HI_3
#define COHER_DEST_BASE_HI_3__DEST_BASE_HI_256B__SHIFT                                                        0x0
#define COHER_DEST_BASE_HI_3__DEST_BASE_HI_256B_MASK                                                          0x000000FFL
//COHER_DEST_BASE_2
#define COHER_DEST_BASE_2__DEST_BASE_256B__SHIFT                                                              0x0
#define COHER_DEST_BASE_2__DEST_BASE_256B_MASK                                                                0xFFFFFFFFL
//COHER_DEST_BASE_3
#define COHER_DEST_BASE_3__DEST_BASE_256B__SHIFT                                                              0x0
#define COHER_DEST_BASE_3__DEST_BASE_256B_MASK                                                                0xFFFFFFFFL
//PA_SC_WINDOW_OFFSET
#define PA_SC_WINDOW_OFFSET__WINDOW_X_OFFSET__SHIFT                                                           0x0
#define PA_SC_WINDOW_OFFSET__WINDOW_Y_OFFSET__SHIFT                                                           0x10
#define PA_SC_WINDOW_OFFSET__WINDOW_X_OFFSET_MASK                                                             0x0000FFFFL
#define PA_SC_WINDOW_OFFSET__WINDOW_Y_OFFSET_MASK                                                             0xFFFF0000L
//PA_SC_WINDOW_SCISSOR_TL
#define PA_SC_WINDOW_SCISSOR_TL__TL_X__SHIFT                                                                  0x0
#define PA_SC_WINDOW_SCISSOR_TL__TL_Y__SHIFT                                                                  0x10
#define PA_SC_WINDOW_SCISSOR_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                 0x1f
#define PA_SC_WINDOW_SCISSOR_TL__TL_X_MASK                                                                    0x00007FFFL
#define PA_SC_WINDOW_SCISSOR_TL__TL_Y_MASK                                                                    0x7FFF0000L
#define PA_SC_WINDOW_SCISSOR_TL__WINDOW_OFFSET_DISABLE_MASK                                                   0x80000000L
//PA_SC_WINDOW_SCISSOR_BR
#define PA_SC_WINDOW_SCISSOR_BR__BR_X__SHIFT                                                                  0x0
#define PA_SC_WINDOW_SCISSOR_BR__BR_Y__SHIFT                                                                  0x10
#define PA_SC_WINDOW_SCISSOR_BR__BR_X_MASK                                                                    0x00007FFFL
#define PA_SC_WINDOW_SCISSOR_BR__BR_Y_MASK                                                                    0x7FFF0000L
//PA_SC_CLIPRECT_RULE
#define PA_SC_CLIPRECT_RULE__CLIP_RULE__SHIFT                                                                 0x0
#define PA_SC_CLIPRECT_RULE__CLIP_RULE_MASK                                                                   0x0000FFFFL
//PA_SC_CLIPRECT_0_TL
#define PA_SC_CLIPRECT_0_TL__TL_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_0_TL__TL_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_0_TL__TL_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_0_TL__TL_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_0_BR
#define PA_SC_CLIPRECT_0_BR__BR_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_0_BR__BR_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_0_BR__BR_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_0_BR__BR_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_1_TL
#define PA_SC_CLIPRECT_1_TL__TL_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_1_TL__TL_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_1_TL__TL_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_1_TL__TL_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_1_BR
#define PA_SC_CLIPRECT_1_BR__BR_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_1_BR__BR_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_1_BR__BR_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_1_BR__BR_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_2_TL
#define PA_SC_CLIPRECT_2_TL__TL_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_2_TL__TL_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_2_TL__TL_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_2_TL__TL_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_2_BR
#define PA_SC_CLIPRECT_2_BR__BR_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_2_BR__BR_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_2_BR__BR_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_2_BR__BR_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_3_TL
#define PA_SC_CLIPRECT_3_TL__TL_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_3_TL__TL_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_3_TL__TL_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_3_TL__TL_Y_MASK                                                                        0x7FFF0000L
//PA_SC_CLIPRECT_3_BR
#define PA_SC_CLIPRECT_3_BR__BR_X__SHIFT                                                                      0x0
#define PA_SC_CLIPRECT_3_BR__BR_Y__SHIFT                                                                      0x10
#define PA_SC_CLIPRECT_3_BR__BR_X_MASK                                                                        0x00007FFFL
#define PA_SC_CLIPRECT_3_BR__BR_Y_MASK                                                                        0x7FFF0000L
//PA_SC_EDGERULE
#define PA_SC_EDGERULE__ER_TRI__SHIFT                                                                         0x0
#define PA_SC_EDGERULE__ER_POINT__SHIFT                                                                       0x4
#define PA_SC_EDGERULE__ER_RECT__SHIFT                                                                        0x8
#define PA_SC_EDGERULE__ER_LINE_LR__SHIFT                                                                     0xc
#define PA_SC_EDGERULE__ER_LINE_RL__SHIFT                                                                     0x12
#define PA_SC_EDGERULE__ER_LINE_TB__SHIFT                                                                     0x18
#define PA_SC_EDGERULE__ER_LINE_BT__SHIFT                                                                     0x1c
#define PA_SC_EDGERULE__ER_TRI_MASK                                                                           0x0000000FL
#define PA_SC_EDGERULE__ER_POINT_MASK                                                                         0x000000F0L
#define PA_SC_EDGERULE__ER_RECT_MASK                                                                          0x00000F00L
#define PA_SC_EDGERULE__ER_LINE_LR_MASK                                                                       0x0003F000L
#define PA_SC_EDGERULE__ER_LINE_RL_MASK                                                                       0x00FC0000L
#define PA_SC_EDGERULE__ER_LINE_TB_MASK                                                                       0x0F000000L
#define PA_SC_EDGERULE__ER_LINE_BT_MASK                                                                       0xF0000000L
//PA_SU_HARDWARE_SCREEN_OFFSET
#define PA_SU_HARDWARE_SCREEN_OFFSET__HW_SCREEN_OFFSET_X__SHIFT                                               0x0
#define PA_SU_HARDWARE_SCREEN_OFFSET__HW_SCREEN_OFFSET_Y__SHIFT                                               0x10
#define PA_SU_HARDWARE_SCREEN_OFFSET__HW_SCREEN_OFFSET_X_MASK                                                 0x000001FFL
#define PA_SU_HARDWARE_SCREEN_OFFSET__HW_SCREEN_OFFSET_Y_MASK                                                 0x01FF0000L
//CB_TARGET_MASK
#define CB_TARGET_MASK__TARGET0_ENABLE__SHIFT                                                                 0x0
#define CB_TARGET_MASK__TARGET1_ENABLE__SHIFT                                                                 0x4
#define CB_TARGET_MASK__TARGET2_ENABLE__SHIFT                                                                 0x8
#define CB_TARGET_MASK__TARGET3_ENABLE__SHIFT                                                                 0xc
#define CB_TARGET_MASK__TARGET4_ENABLE__SHIFT                                                                 0x10
#define CB_TARGET_MASK__TARGET5_ENABLE__SHIFT                                                                 0x14
#define CB_TARGET_MASK__TARGET6_ENABLE__SHIFT                                                                 0x18
#define CB_TARGET_MASK__TARGET7_ENABLE__SHIFT                                                                 0x1c
#define CB_TARGET_MASK__TARGET0_ENABLE_MASK                                                                   0x0000000FL
#define CB_TARGET_MASK__TARGET1_ENABLE_MASK                                                                   0x000000F0L
#define CB_TARGET_MASK__TARGET2_ENABLE_MASK                                                                   0x00000F00L
#define CB_TARGET_MASK__TARGET3_ENABLE_MASK                                                                   0x0000F000L
#define CB_TARGET_MASK__TARGET4_ENABLE_MASK                                                                   0x000F0000L
#define CB_TARGET_MASK__TARGET5_ENABLE_MASK                                                                   0x00F00000L
#define CB_TARGET_MASK__TARGET6_ENABLE_MASK                                                                   0x0F000000L
#define CB_TARGET_MASK__TARGET7_ENABLE_MASK                                                                   0xF0000000L
//CB_SHADER_MASK
#define CB_SHADER_MASK__OUTPUT0_ENABLE__SHIFT                                                                 0x0
#define CB_SHADER_MASK__OUTPUT1_ENABLE__SHIFT                                                                 0x4
#define CB_SHADER_MASK__OUTPUT2_ENABLE__SHIFT                                                                 0x8
#define CB_SHADER_MASK__OUTPUT3_ENABLE__SHIFT                                                                 0xc
#define CB_SHADER_MASK__OUTPUT4_ENABLE__SHIFT                                                                 0x10
#define CB_SHADER_MASK__OUTPUT5_ENABLE__SHIFT                                                                 0x14
#define CB_SHADER_MASK__OUTPUT6_ENABLE__SHIFT                                                                 0x18
#define CB_SHADER_MASK__OUTPUT7_ENABLE__SHIFT                                                                 0x1c
#define CB_SHADER_MASK__OUTPUT0_ENABLE_MASK                                                                   0x0000000FL
#define CB_SHADER_MASK__OUTPUT1_ENABLE_MASK                                                                   0x000000F0L
#define CB_SHADER_MASK__OUTPUT2_ENABLE_MASK                                                                   0x00000F00L
#define CB_SHADER_MASK__OUTPUT3_ENABLE_MASK                                                                   0x0000F000L
#define CB_SHADER_MASK__OUTPUT4_ENABLE_MASK                                                                   0x000F0000L
#define CB_SHADER_MASK__OUTPUT5_ENABLE_MASK                                                                   0x00F00000L
#define CB_SHADER_MASK__OUTPUT6_ENABLE_MASK                                                                   0x0F000000L
#define CB_SHADER_MASK__OUTPUT7_ENABLE_MASK                                                                   0xF0000000L
//PA_SC_GENERIC_SCISSOR_TL
#define PA_SC_GENERIC_SCISSOR_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_GENERIC_SCISSOR_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_GENERIC_SCISSOR_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_GENERIC_SCISSOR_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_GENERIC_SCISSOR_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_GENERIC_SCISSOR_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_GENERIC_SCISSOR_BR
#define PA_SC_GENERIC_SCISSOR_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_GENERIC_SCISSOR_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_GENERIC_SCISSOR_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_GENERIC_SCISSOR_BR__BR_Y_MASK                                                                   0x7FFF0000L
//COHER_DEST_BASE_0
#define COHER_DEST_BASE_0__DEST_BASE_256B__SHIFT                                                              0x0
#define COHER_DEST_BASE_0__DEST_BASE_256B_MASK                                                                0xFFFFFFFFL
//COHER_DEST_BASE_1
#define COHER_DEST_BASE_1__DEST_BASE_256B__SHIFT                                                              0x0
#define COHER_DEST_BASE_1__DEST_BASE_256B_MASK                                                                0xFFFFFFFFL
//PA_SC_VPORT_SCISSOR_0_TL
#define PA_SC_VPORT_SCISSOR_0_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_0_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_0_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_0_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_0_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_0_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_0_BR
#define PA_SC_VPORT_SCISSOR_0_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_0_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_0_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_0_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_1_TL
#define PA_SC_VPORT_SCISSOR_1_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_1_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_1_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_1_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_1_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_1_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_1_BR
#define PA_SC_VPORT_SCISSOR_1_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_1_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_1_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_1_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_2_TL
#define PA_SC_VPORT_SCISSOR_2_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_2_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_2_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_2_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_2_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_2_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_2_BR
#define PA_SC_VPORT_SCISSOR_2_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_2_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_2_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_2_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_3_TL
#define PA_SC_VPORT_SCISSOR_3_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_3_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_3_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_3_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_3_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_3_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_3_BR
#define PA_SC_VPORT_SCISSOR_3_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_3_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_3_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_3_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_4_TL
#define PA_SC_VPORT_SCISSOR_4_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_4_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_4_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_4_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_4_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_4_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_4_BR
#define PA_SC_VPORT_SCISSOR_4_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_4_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_4_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_4_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_5_TL
#define PA_SC_VPORT_SCISSOR_5_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_5_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_5_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_5_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_5_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_5_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_5_BR
#define PA_SC_VPORT_SCISSOR_5_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_5_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_5_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_5_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_6_TL
#define PA_SC_VPORT_SCISSOR_6_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_6_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_6_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_6_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_6_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_6_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_6_BR
#define PA_SC_VPORT_SCISSOR_6_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_6_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_6_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_6_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_7_TL
#define PA_SC_VPORT_SCISSOR_7_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_7_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_7_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_7_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_7_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_7_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_7_BR
#define PA_SC_VPORT_SCISSOR_7_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_7_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_7_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_7_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_8_TL
#define PA_SC_VPORT_SCISSOR_8_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_8_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_8_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_8_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_8_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_8_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_8_BR
#define PA_SC_VPORT_SCISSOR_8_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_8_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_8_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_8_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_9_TL
#define PA_SC_VPORT_SCISSOR_9_TL__TL_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_9_TL__TL_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_9_TL__WINDOW_OFFSET_DISABLE__SHIFT                                                0x1f
#define PA_SC_VPORT_SCISSOR_9_TL__TL_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_9_TL__TL_Y_MASK                                                                   0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_9_TL__WINDOW_OFFSET_DISABLE_MASK                                                  0x80000000L
//PA_SC_VPORT_SCISSOR_9_BR
#define PA_SC_VPORT_SCISSOR_9_BR__BR_X__SHIFT                                                                 0x0
#define PA_SC_VPORT_SCISSOR_9_BR__BR_Y__SHIFT                                                                 0x10
#define PA_SC_VPORT_SCISSOR_9_BR__BR_X_MASK                                                                   0x00007FFFL
#define PA_SC_VPORT_SCISSOR_9_BR__BR_Y_MASK                                                                   0x7FFF0000L
//PA_SC_VPORT_SCISSOR_10_TL
#define PA_SC_VPORT_SCISSOR_10_TL__TL_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_10_TL__TL_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_10_TL__WINDOW_OFFSET_DISABLE__SHIFT                                               0x1f
#define PA_SC_VPORT_SCISSOR_10_TL__TL_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_10_TL__TL_Y_MASK                                                                  0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_10_TL__WINDOW_OFFSET_DISABLE_MASK                                                 0x80000000L
//PA_SC_VPORT_SCISSOR_10_BR
#define PA_SC_VPORT_SCISSOR_10_BR__BR_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_10_BR__BR_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_10_BR__BR_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_10_BR__BR_Y_MASK                                                                  0x7FFF0000L
//PA_SC_VPORT_SCISSOR_11_TL
#define PA_SC_VPORT_SCISSOR_11_TL__TL_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_11_TL__TL_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_11_TL__WINDOW_OFFSET_DISABLE__SHIFT                                               0x1f
#define PA_SC_VPORT_SCISSOR_11_TL__TL_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_11_TL__TL_Y_MASK                                                                  0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_11_TL__WINDOW_OFFSET_DISABLE_MASK                                                 0x80000000L
//PA_SC_VPORT_SCISSOR_11_BR
#define PA_SC_VPORT_SCISSOR_11_BR__BR_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_11_BR__BR_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_11_BR__BR_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_11_BR__BR_Y_MASK                                                                  0x7FFF0000L
//PA_SC_VPORT_SCISSOR_12_TL
#define PA_SC_VPORT_SCISSOR_12_TL__TL_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_12_TL__TL_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_12_TL__WINDOW_OFFSET_DISABLE__SHIFT                                               0x1f
#define PA_SC_VPORT_SCISSOR_12_TL__TL_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_12_TL__TL_Y_MASK                                                                  0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_12_TL__WINDOW_OFFSET_DISABLE_MASK                                                 0x80000000L
//PA_SC_VPORT_SCISSOR_12_BR
#define PA_SC_VPORT_SCISSOR_12_BR__BR_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_12_BR__BR_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_12_BR__BR_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_12_BR__BR_Y_MASK                                                                  0x7FFF0000L
//PA_SC_VPORT_SCISSOR_13_TL
#define PA_SC_VPORT_SCISSOR_13_TL__TL_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_13_TL__TL_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_13_TL__WINDOW_OFFSET_DISABLE__SHIFT                                               0x1f
#define PA_SC_VPORT_SCISSOR_13_TL__TL_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_13_TL__TL_Y_MASK                                                                  0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_13_TL__WINDOW_OFFSET_DISABLE_MASK                                                 0x80000000L
//PA_SC_VPORT_SCISSOR_13_BR
#define PA_SC_VPORT_SCISSOR_13_BR__BR_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_13_BR__BR_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_13_BR__BR_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_13_BR__BR_Y_MASK                                                                  0x7FFF0000L
//PA_SC_VPORT_SCISSOR_14_TL
#define PA_SC_VPORT_SCISSOR_14_TL__TL_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_14_TL__TL_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_14_TL__WINDOW_OFFSET_DISABLE__SHIFT                                               0x1f
#define PA_SC_VPORT_SCISSOR_14_TL__TL_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_14_TL__TL_Y_MASK                                                                  0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_14_TL__WINDOW_OFFSET_DISABLE_MASK                                                 0x80000000L
//PA_SC_VPORT_SCISSOR_14_BR
#define PA_SC_VPORT_SCISSOR_14_BR__BR_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_14_BR__BR_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_14_BR__BR_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_14_BR__BR_Y_MASK                                                                  0x7FFF0000L
//PA_SC_VPORT_SCISSOR_15_TL
#define PA_SC_VPORT_SCISSOR_15_TL__TL_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_15_TL__TL_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_15_TL__WINDOW_OFFSET_DISABLE__SHIFT                                               0x1f
#define PA_SC_VPORT_SCISSOR_15_TL__TL_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_15_TL__TL_Y_MASK                                                                  0x7FFF0000L
#define PA_SC_VPORT_SCISSOR_15_TL__WINDOW_OFFSET_DISABLE_MASK                                                 0x80000000L
//PA_SC_VPORT_SCISSOR_15_BR
#define PA_SC_VPORT_SCISSOR_15_BR__BR_X__SHIFT                                                                0x0
#define PA_SC_VPORT_SCISSOR_15_BR__BR_Y__SHIFT                                                                0x10
#define PA_SC_VPORT_SCISSOR_15_BR__BR_X_MASK                                                                  0x00007FFFL
#define PA_SC_VPORT_SCISSOR_15_BR__BR_Y_MASK                                                                  0x7FFF0000L
//PA_SC_VPORT_ZMIN_0
#define PA_SC_VPORT_ZMIN_0__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_0__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_0
#define PA_SC_VPORT_ZMAX_0__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_0__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_1
#define PA_SC_VPORT_ZMIN_1__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_1__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_1
#define PA_SC_VPORT_ZMAX_1__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_1__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_2
#define PA_SC_VPORT_ZMIN_2__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_2__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_2
#define PA_SC_VPORT_ZMAX_2__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_2__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_3
#define PA_SC_VPORT_ZMIN_3__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_3__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_3
#define PA_SC_VPORT_ZMAX_3__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_3__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_4
#define PA_SC_VPORT_ZMIN_4__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_4__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_4
#define PA_SC_VPORT_ZMAX_4__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_4__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_5
#define PA_SC_VPORT_ZMIN_5__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_5__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_5
#define PA_SC_VPORT_ZMAX_5__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_5__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_6
#define PA_SC_VPORT_ZMIN_6__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_6__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_6
#define PA_SC_VPORT_ZMAX_6__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_6__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_7
#define PA_SC_VPORT_ZMIN_7__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_7__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_7
#define PA_SC_VPORT_ZMAX_7__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_7__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_8
#define PA_SC_VPORT_ZMIN_8__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_8__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_8
#define PA_SC_VPORT_ZMAX_8__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_8__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_9
#define PA_SC_VPORT_ZMIN_9__VPORT_ZMIN__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMIN_9__VPORT_ZMIN_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_9
#define PA_SC_VPORT_ZMAX_9__VPORT_ZMAX__SHIFT                                                                 0x0
#define PA_SC_VPORT_ZMAX_9__VPORT_ZMAX_MASK                                                                   0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_10
#define PA_SC_VPORT_ZMIN_10__VPORT_ZMIN__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMIN_10__VPORT_ZMIN_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_10
#define PA_SC_VPORT_ZMAX_10__VPORT_ZMAX__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMAX_10__VPORT_ZMAX_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_11
#define PA_SC_VPORT_ZMIN_11__VPORT_ZMIN__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMIN_11__VPORT_ZMIN_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_11
#define PA_SC_VPORT_ZMAX_11__VPORT_ZMAX__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMAX_11__VPORT_ZMAX_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_12
#define PA_SC_VPORT_ZMIN_12__VPORT_ZMIN__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMIN_12__VPORT_ZMIN_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_12
#define PA_SC_VPORT_ZMAX_12__VPORT_ZMAX__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMAX_12__VPORT_ZMAX_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_13
#define PA_SC_VPORT_ZMIN_13__VPORT_ZMIN__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMIN_13__VPORT_ZMIN_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_13
#define PA_SC_VPORT_ZMAX_13__VPORT_ZMAX__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMAX_13__VPORT_ZMAX_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_14
#define PA_SC_VPORT_ZMIN_14__VPORT_ZMIN__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMIN_14__VPORT_ZMIN_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_14
#define PA_SC_VPORT_ZMAX_14__VPORT_ZMAX__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMAX_14__VPORT_ZMAX_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMIN_15
#define PA_SC_VPORT_ZMIN_15__VPORT_ZMIN__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMIN_15__VPORT_ZMIN_MASK                                                                  0xFFFFFFFFL
//PA_SC_VPORT_ZMAX_15
#define PA_SC_VPORT_ZMAX_15__VPORT_ZMAX__SHIFT                                                                0x0
#define PA_SC_VPORT_ZMAX_15__VPORT_ZMAX_MASK                                                                  0xFFFFFFFFL
//PA_SC_RASTER_CONFIG
#define PA_SC_RASTER_CONFIG__RB_MAP_PKR0__SHIFT                                                               0x0
#define PA_SC_RASTER_CONFIG__RB_MAP_PKR1__SHIFT                                                               0x2
#define PA_SC_RASTER_CONFIG__RB_XSEL2__SHIFT                                                                  0x4
#define PA_SC_RASTER_CONFIG__RB_XSEL__SHIFT                                                                   0x6
#define PA_SC_RASTER_CONFIG__RB_YSEL__SHIFT                                                                   0x7
#define PA_SC_RASTER_CONFIG__PKR_MAP__SHIFT                                                                   0x8
#define PA_SC_RASTER_CONFIG__PKR_XSEL__SHIFT                                                                  0xa
#define PA_SC_RASTER_CONFIG__PKR_YSEL__SHIFT                                                                  0xc
#define PA_SC_RASTER_CONFIG__PKR_XSEL2__SHIFT                                                                 0xe
#define PA_SC_RASTER_CONFIG__SC_MAP__SHIFT                                                                    0x10
#define PA_SC_RASTER_CONFIG__SC_XSEL__SHIFT                                                                   0x12
#define PA_SC_RASTER_CONFIG__SC_YSEL__SHIFT                                                                   0x14
#define PA_SC_RASTER_CONFIG__SE_MAP__SHIFT                                                                    0x18
#define PA_SC_RASTER_CONFIG__SE_XSEL__SHIFT                                                                   0x1a
#define PA_SC_RASTER_CONFIG__SE_YSEL__SHIFT                                                                   0x1d
#define PA_SC_RASTER_CONFIG__RB_MAP_PKR0_MASK                                                                 0x00000003L
#define PA_SC_RASTER_CONFIG__RB_MAP_PKR1_MASK                                                                 0x0000000CL
#define PA_SC_RASTER_CONFIG__RB_XSEL2_MASK                                                                    0x00000030L
#define PA_SC_RASTER_CONFIG__RB_XSEL_MASK                                                                     0x00000040L
#define PA_SC_RASTER_CONFIG__RB_YSEL_MASK                                                                     0x00000080L
#define PA_SC_RASTER_CONFIG__PKR_MAP_MASK                                                                     0x00000300L
#define PA_SC_RASTER_CONFIG__PKR_XSEL_MASK                                                                    0x00000C00L
#define PA_SC_RASTER_CONFIG__PKR_YSEL_MASK                                                                    0x00003000L
#define PA_SC_RASTER_CONFIG__PKR_XSEL2_MASK                                                                   0x0000C000L
#define PA_SC_RASTER_CONFIG__SC_MAP_MASK                                                                      0x00030000L
#define PA_SC_RASTER_CONFIG__SC_XSEL_MASK                                                                     0x000C0000L
#define PA_SC_RASTER_CONFIG__SC_YSEL_MASK                                                                     0x00300000L
#define PA_SC_RASTER_CONFIG__SE_MAP_MASK                                                                      0x03000000L
#define PA_SC_RASTER_CONFIG__SE_XSEL_MASK                                                                     0x1C000000L
#define PA_SC_RASTER_CONFIG__SE_YSEL_MASK                                                                     0xE0000000L
//PA_SC_RASTER_CONFIG_1
#define PA_SC_RASTER_CONFIG_1__SE_PAIR_MAP__SHIFT                                                             0x0
#define PA_SC_RASTER_CONFIG_1__SE_PAIR_XSEL__SHIFT                                                            0x2
#define PA_SC_RASTER_CONFIG_1__SE_PAIR_YSEL__SHIFT                                                            0x5
#define PA_SC_RASTER_CONFIG_1__SE_PAIR_MAP_MASK                                                               0x00000003L
#define PA_SC_RASTER_CONFIG_1__SE_PAIR_XSEL_MASK                                                              0x0000001CL
#define PA_SC_RASTER_CONFIG_1__SE_PAIR_YSEL_MASK                                                              0x000000E0L
//PA_SC_SCREEN_EXTENT_CONTROL
#define PA_SC_SCREEN_EXTENT_CONTROL__SLICE_EVEN_ENABLE__SHIFT                                                 0x0
#define PA_SC_SCREEN_EXTENT_CONTROL__SLICE_ODD_ENABLE__SHIFT                                                  0x2
#define PA_SC_SCREEN_EXTENT_CONTROL__SLICE_EVEN_ENABLE_MASK                                                   0x00000003L
#define PA_SC_SCREEN_EXTENT_CONTROL__SLICE_ODD_ENABLE_MASK                                                    0x0000000CL
//PA_SC_TILE_STEERING_OVERRIDE
#define PA_SC_TILE_STEERING_OVERRIDE__ENABLE__SHIFT                                                           0x0
#define PA_SC_TILE_STEERING_OVERRIDE__NUM_SE__SHIFT                                                           0x1
#define PA_SC_TILE_STEERING_OVERRIDE__NUM_RB_PER_SE__SHIFT                                                    0x5
#define PA_SC_TILE_STEERING_OVERRIDE__ENABLE_MASK                                                             0x00000001L
#define PA_SC_TILE_STEERING_OVERRIDE__NUM_SE_MASK                                                             0x00000006L
#define PA_SC_TILE_STEERING_OVERRIDE__NUM_RB_PER_SE_MASK                                                      0x00000060L
//CP_PERFMON_CNTX_CNTL
#define CP_PERFMON_CNTX_CNTL__PERFMON_ENABLE__SHIFT                                                           0x1f
#define CP_PERFMON_CNTX_CNTL__PERFMON_ENABLE_MASK                                                             0x80000000L
//CP_PIPEID
#define CP_PIPEID__PIPE_ID__SHIFT                                                                             0x0
#define CP_PIPEID__PIPE_ID_MASK                                                                               0x00000003L
//CP_RINGID
#define CP_RINGID__RINGID__SHIFT                                                                              0x0
#define CP_RINGID__RINGID_MASK                                                                                0x00000003L
//CP_VMID
#define CP_VMID__VMID__SHIFT                                                                                  0x0
#define CP_VMID__VMID_MASK                                                                                    0x0000000FL
//PA_SC_RIGHT_VERT_GRID
#define PA_SC_RIGHT_VERT_GRID__LEFT_QTR__SHIFT                                                                0x0
#define PA_SC_RIGHT_VERT_GRID__LEFT_HALF__SHIFT                                                               0x8
#define PA_SC_RIGHT_VERT_GRID__RIGHT_HALF__SHIFT                                                              0x10
#define PA_SC_RIGHT_VERT_GRID__RIGHT_QTR__SHIFT                                                               0x18
#define PA_SC_RIGHT_VERT_GRID__LEFT_QTR_MASK                                                                  0x000000FFL
#define PA_SC_RIGHT_VERT_GRID__LEFT_HALF_MASK                                                                 0x0000FF00L
#define PA_SC_RIGHT_VERT_GRID__RIGHT_HALF_MASK                                                                0x00FF0000L
#define PA_SC_RIGHT_VERT_GRID__RIGHT_QTR_MASK                                                                 0xFF000000L
//PA_SC_LEFT_VERT_GRID
#define PA_SC_LEFT_VERT_GRID__LEFT_QTR__SHIFT                                                                 0x0
#define PA_SC_LEFT_VERT_GRID__LEFT_HALF__SHIFT                                                                0x8
#define PA_SC_LEFT_VERT_GRID__RIGHT_HALF__SHIFT                                                               0x10
#define PA_SC_LEFT_VERT_GRID__RIGHT_QTR__SHIFT                                                                0x18
#define PA_SC_LEFT_VERT_GRID__LEFT_QTR_MASK                                                                   0x000000FFL
#define PA_SC_LEFT_VERT_GRID__LEFT_HALF_MASK                                                                  0x0000FF00L
#define PA_SC_LEFT_VERT_GRID__RIGHT_HALF_MASK                                                                 0x00FF0000L
#define PA_SC_LEFT_VERT_GRID__RIGHT_QTR_MASK                                                                  0xFF000000L
//PA_SC_HORIZ_GRID
#define PA_SC_HORIZ_GRID__TOP_QTR__SHIFT                                                                      0x0
#define PA_SC_HORIZ_GRID__TOP_HALF__SHIFT                                                                     0x8
#define PA_SC_HORIZ_GRID__BOT_HALF__SHIFT                                                                     0x10
#define PA_SC_HORIZ_GRID__BOT_QTR__SHIFT                                                                      0x18
#define PA_SC_HORIZ_GRID__TOP_QTR_MASK                                                                        0x000000FFL
#define PA_SC_HORIZ_GRID__TOP_HALF_MASK                                                                       0x0000FF00L
#define PA_SC_HORIZ_GRID__BOT_HALF_MASK                                                                       0x00FF0000L
#define PA_SC_HORIZ_GRID__BOT_QTR_MASK                                                                        0xFF000000L
//VGT_MULTI_PRIM_IB_RESET_INDX
#define VGT_MULTI_PRIM_IB_RESET_INDX__RESET_INDX__SHIFT                                                       0x0
#define VGT_MULTI_PRIM_IB_RESET_INDX__RESET_INDX_MASK                                                         0xFFFFFFFFL
//CB_BLEND_RED
#define CB_BLEND_RED__BLEND_RED__SHIFT                                                                        0x0
#define CB_BLEND_RED__BLEND_RED_MASK                                                                          0xFFFFFFFFL
//CB_BLEND_GREEN
#define CB_BLEND_GREEN__BLEND_GREEN__SHIFT                                                                    0x0
#define CB_BLEND_GREEN__BLEND_GREEN_MASK                                                                      0xFFFFFFFFL
//CB_BLEND_BLUE
#define CB_BLEND_BLUE__BLEND_BLUE__SHIFT                                                                      0x0
#define CB_BLEND_BLUE__BLEND_BLUE_MASK                                                                        0xFFFFFFFFL
//CB_BLEND_ALPHA
#define CB_BLEND_ALPHA__BLEND_ALPHA__SHIFT                                                                    0x0
#define CB_BLEND_ALPHA__BLEND_ALPHA_MASK                                                                      0xFFFFFFFFL
//CB_DCC_CONTROL
#define CB_DCC_CONTROL__OVERWRITE_COMBINER_DISABLE__SHIFT                                                     0x0
#define CB_DCC_CONTROL__OVERWRITE_COMBINER_MRT_SHARING_DISABLE__SHIFT                                         0x1
#define CB_DCC_CONTROL__OVERWRITE_COMBINER_WATERMARK__SHIFT                                                   0x2
#define CB_DCC_CONTROL__DISABLE_CONSTANT_ENCODE_AC01__SHIFT                                                   0x8
#define CB_DCC_CONTROL__DISABLE_CONSTANT_ENCODE_SINGLE__SHIFT                                                 0x9
#define CB_DCC_CONTROL__DISABLE_CONSTANT_ENCODE_REG__SHIFT                                                    0xa
#define CB_DCC_CONTROL__DISABLE_ELIMFC_SKIP_OF_AC01__SHIFT                                                    0xc
#define CB_DCC_CONTROL__DISABLE_ELIMFC_SKIP_OF_SINGLE__SHIFT                                                  0xd
#define CB_DCC_CONTROL__ENABLE_ELIMFC_SKIP_OF_REG__SHIFT                                                      0xe
#define CB_DCC_CONTROL__OVERWRITE_COMBINER_DISABLE_MASK                                                       0x00000001L
#define CB_DCC_CONTROL__OVERWRITE_COMBINER_MRT_SHARING_DISABLE_MASK                                           0x00000002L
#define CB_DCC_CONTROL__OVERWRITE_COMBINER_WATERMARK_MASK                                                     0x0000007CL
#define CB_DCC_CONTROL__DISABLE_CONSTANT_ENCODE_AC01_MASK                                                     0x00000100L
#define CB_DCC_CONTROL__DISABLE_CONSTANT_ENCODE_SINGLE_MASK                                                   0x00000200L
#define CB_DCC_CONTROL__DISABLE_CONSTANT_ENCODE_REG_MASK                                                      0x00000400L
#define CB_DCC_CONTROL__DISABLE_ELIMFC_SKIP_OF_AC01_MASK                                                      0x00001000L
#define CB_DCC_CONTROL__DISABLE_ELIMFC_SKIP_OF_SINGLE_MASK                                                    0x00002000L
#define CB_DCC_CONTROL__ENABLE_ELIMFC_SKIP_OF_REG_MASK                                                        0x00004000L
//DB_STENCIL_CONTROL
#define DB_STENCIL_CONTROL__STENCILFAIL__SHIFT                                                                0x0
#define DB_STENCIL_CONTROL__STENCILZPASS__SHIFT                                                               0x4
#define DB_STENCIL_CONTROL__STENCILZFAIL__SHIFT                                                               0x8
#define DB_STENCIL_CONTROL__STENCILFAIL_BF__SHIFT                                                             0xc
#define DB_STENCIL_CONTROL__STENCILZPASS_BF__SHIFT                                                            0x10
#define DB_STENCIL_CONTROL__STENCILZFAIL_BF__SHIFT                                                            0x14
#define DB_STENCIL_CONTROL__STENCILFAIL_MASK                                                                  0x0000000FL
#define DB_STENCIL_CONTROL__STENCILZPASS_MASK                                                                 0x000000F0L
#define DB_STENCIL_CONTROL__STENCILZFAIL_MASK                                                                 0x00000F00L
#define DB_STENCIL_CONTROL__STENCILFAIL_BF_MASK                                                               0x0000F000L
#define DB_STENCIL_CONTROL__STENCILZPASS_BF_MASK                                                              0x000F0000L
#define DB_STENCIL_CONTROL__STENCILZFAIL_BF_MASK                                                              0x00F00000L
//DB_STENCILREFMASK
#define DB_STENCILREFMASK__STENCILTESTVAL__SHIFT                                                              0x0
#define DB_STENCILREFMASK__STENCILMASK__SHIFT                                                                 0x8
#define DB_STENCILREFMASK__STENCILWRITEMASK__SHIFT                                                            0x10
#define DB_STENCILREFMASK__STENCILOPVAL__SHIFT                                                                0x18
#define DB_STENCILREFMASK__STENCILTESTVAL_MASK                                                                0x000000FFL
#define DB_STENCILREFMASK__STENCILMASK_MASK                                                                   0x0000FF00L
#define DB_STENCILREFMASK__STENCILWRITEMASK_MASK                                                              0x00FF0000L
#define DB_STENCILREFMASK__STENCILOPVAL_MASK                                                                  0xFF000000L
//DB_STENCILREFMASK_BF
#define DB_STENCILREFMASK_BF__STENCILTESTVAL_BF__SHIFT                                                        0x0
#define DB_STENCILREFMASK_BF__STENCILMASK_BF__SHIFT                                                           0x8
#define DB_STENCILREFMASK_BF__STENCILWRITEMASK_BF__SHIFT                                                      0x10
#define DB_STENCILREFMASK_BF__STENCILOPVAL_BF__SHIFT                                                          0x18
#define DB_STENCILREFMASK_BF__STENCILTESTVAL_BF_MASK                                                          0x000000FFL
#define DB_STENCILREFMASK_BF__STENCILMASK_BF_MASK                                                             0x0000FF00L
#define DB_STENCILREFMASK_BF__STENCILWRITEMASK_BF_MASK                                                        0x00FF0000L
#define DB_STENCILREFMASK_BF__STENCILOPVAL_BF_MASK                                                            0xFF000000L
//PA_CL_VPORT_XSCALE
#define PA_CL_VPORT_XSCALE__VPORT_XSCALE__SHIFT                                                               0x0
#define PA_CL_VPORT_XSCALE__VPORT_XSCALE_MASK                                                                 0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET
#define PA_CL_VPORT_XOFFSET__VPORT_XOFFSET__SHIFT                                                             0x0
#define PA_CL_VPORT_XOFFSET__VPORT_XOFFSET_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YSCALE
#define PA_CL_VPORT_YSCALE__VPORT_YSCALE__SHIFT                                                               0x0
#define PA_CL_VPORT_YSCALE__VPORT_YSCALE_MASK                                                                 0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET
#define PA_CL_VPORT_YOFFSET__VPORT_YOFFSET__SHIFT                                                             0x0
#define PA_CL_VPORT_YOFFSET__VPORT_YOFFSET_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE
#define PA_CL_VPORT_ZSCALE__VPORT_ZSCALE__SHIFT                                                               0x0
#define PA_CL_VPORT_ZSCALE__VPORT_ZSCALE_MASK                                                                 0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET
#define PA_CL_VPORT_ZOFFSET__VPORT_ZOFFSET__SHIFT                                                             0x0
#define PA_CL_VPORT_ZOFFSET__VPORT_ZOFFSET_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_1
#define PA_CL_VPORT_XSCALE_1__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_1__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_1
#define PA_CL_VPORT_XOFFSET_1__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_1__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_1
#define PA_CL_VPORT_YSCALE_1__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_1__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_1
#define PA_CL_VPORT_YOFFSET_1__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_1__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_1
#define PA_CL_VPORT_ZSCALE_1__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_1__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_1
#define PA_CL_VPORT_ZOFFSET_1__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_1__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_2
#define PA_CL_VPORT_XSCALE_2__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_2__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_2
#define PA_CL_VPORT_XOFFSET_2__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_2__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_2
#define PA_CL_VPORT_YSCALE_2__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_2__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_2
#define PA_CL_VPORT_YOFFSET_2__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_2__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_2
#define PA_CL_VPORT_ZSCALE_2__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_2__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_2
#define PA_CL_VPORT_ZOFFSET_2__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_2__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_3
#define PA_CL_VPORT_XSCALE_3__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_3__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_3
#define PA_CL_VPORT_XOFFSET_3__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_3__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_3
#define PA_CL_VPORT_YSCALE_3__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_3__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_3
#define PA_CL_VPORT_YOFFSET_3__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_3__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_3
#define PA_CL_VPORT_ZSCALE_3__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_3__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_3
#define PA_CL_VPORT_ZOFFSET_3__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_3__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_4
#define PA_CL_VPORT_XSCALE_4__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_4__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_4
#define PA_CL_VPORT_XOFFSET_4__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_4__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_4
#define PA_CL_VPORT_YSCALE_4__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_4__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_4
#define PA_CL_VPORT_YOFFSET_4__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_4__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_4
#define PA_CL_VPORT_ZSCALE_4__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_4__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_4
#define PA_CL_VPORT_ZOFFSET_4__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_4__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_5
#define PA_CL_VPORT_XSCALE_5__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_5__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_5
#define PA_CL_VPORT_XOFFSET_5__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_5__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_5
#define PA_CL_VPORT_YSCALE_5__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_5__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_5
#define PA_CL_VPORT_YOFFSET_5__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_5__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_5
#define PA_CL_VPORT_ZSCALE_5__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_5__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_5
#define PA_CL_VPORT_ZOFFSET_5__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_5__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_6
#define PA_CL_VPORT_XSCALE_6__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_6__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_6
#define PA_CL_VPORT_XOFFSET_6__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_6__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_6
#define PA_CL_VPORT_YSCALE_6__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_6__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_6
#define PA_CL_VPORT_YOFFSET_6__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_6__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_6
#define PA_CL_VPORT_ZSCALE_6__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_6__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_6
#define PA_CL_VPORT_ZOFFSET_6__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_6__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_7
#define PA_CL_VPORT_XSCALE_7__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_7__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_7
#define PA_CL_VPORT_XOFFSET_7__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_7__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_7
#define PA_CL_VPORT_YSCALE_7__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_7__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_7
#define PA_CL_VPORT_YOFFSET_7__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_7__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_7
#define PA_CL_VPORT_ZSCALE_7__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_7__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_7
#define PA_CL_VPORT_ZOFFSET_7__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_7__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_8
#define PA_CL_VPORT_XSCALE_8__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_8__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_8
#define PA_CL_VPORT_XOFFSET_8__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_8__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_8
#define PA_CL_VPORT_YSCALE_8__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_8__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_8
#define PA_CL_VPORT_YOFFSET_8__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_8__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_8
#define PA_CL_VPORT_ZSCALE_8__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_8__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_8
#define PA_CL_VPORT_ZOFFSET_8__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_8__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_9
#define PA_CL_VPORT_XSCALE_9__VPORT_XSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_XSCALE_9__VPORT_XSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_9
#define PA_CL_VPORT_XOFFSET_9__VPORT_XOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_XOFFSET_9__VPORT_XOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_9
#define PA_CL_VPORT_YSCALE_9__VPORT_YSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_YSCALE_9__VPORT_YSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_9
#define PA_CL_VPORT_YOFFSET_9__VPORT_YOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_YOFFSET_9__VPORT_YOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_9
#define PA_CL_VPORT_ZSCALE_9__VPORT_ZSCALE__SHIFT                                                             0x0
#define PA_CL_VPORT_ZSCALE_9__VPORT_ZSCALE_MASK                                                               0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_9
#define PA_CL_VPORT_ZOFFSET_9__VPORT_ZOFFSET__SHIFT                                                           0x0
#define PA_CL_VPORT_ZOFFSET_9__VPORT_ZOFFSET_MASK                                                             0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_10
#define PA_CL_VPORT_XSCALE_10__VPORT_XSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_XSCALE_10__VPORT_XSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_10
#define PA_CL_VPORT_XOFFSET_10__VPORT_XOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_XOFFSET_10__VPORT_XOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_10
#define PA_CL_VPORT_YSCALE_10__VPORT_YSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_YSCALE_10__VPORT_YSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_10
#define PA_CL_VPORT_YOFFSET_10__VPORT_YOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_YOFFSET_10__VPORT_YOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_10
#define PA_CL_VPORT_ZSCALE_10__VPORT_ZSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_ZSCALE_10__VPORT_ZSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_10
#define PA_CL_VPORT_ZOFFSET_10__VPORT_ZOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_ZOFFSET_10__VPORT_ZOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_11
#define PA_CL_VPORT_XSCALE_11__VPORT_XSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_XSCALE_11__VPORT_XSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_11
#define PA_CL_VPORT_XOFFSET_11__VPORT_XOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_XOFFSET_11__VPORT_XOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_11
#define PA_CL_VPORT_YSCALE_11__VPORT_YSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_YSCALE_11__VPORT_YSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_11
#define PA_CL_VPORT_YOFFSET_11__VPORT_YOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_YOFFSET_11__VPORT_YOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_11
#define PA_CL_VPORT_ZSCALE_11__VPORT_ZSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_ZSCALE_11__VPORT_ZSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_11
#define PA_CL_VPORT_ZOFFSET_11__VPORT_ZOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_ZOFFSET_11__VPORT_ZOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_12
#define PA_CL_VPORT_XSCALE_12__VPORT_XSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_XSCALE_12__VPORT_XSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_12
#define PA_CL_VPORT_XOFFSET_12__VPORT_XOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_XOFFSET_12__VPORT_XOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_12
#define PA_CL_VPORT_YSCALE_12__VPORT_YSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_YSCALE_12__VPORT_YSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_12
#define PA_CL_VPORT_YOFFSET_12__VPORT_YOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_YOFFSET_12__VPORT_YOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_12
#define PA_CL_VPORT_ZSCALE_12__VPORT_ZSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_ZSCALE_12__VPORT_ZSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_12
#define PA_CL_VPORT_ZOFFSET_12__VPORT_ZOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_ZOFFSET_12__VPORT_ZOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_13
#define PA_CL_VPORT_XSCALE_13__VPORT_XSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_XSCALE_13__VPORT_XSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_13
#define PA_CL_VPORT_XOFFSET_13__VPORT_XOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_XOFFSET_13__VPORT_XOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_13
#define PA_CL_VPORT_YSCALE_13__VPORT_YSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_YSCALE_13__VPORT_YSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_13
#define PA_CL_VPORT_YOFFSET_13__VPORT_YOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_YOFFSET_13__VPORT_YOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_13
#define PA_CL_VPORT_ZSCALE_13__VPORT_ZSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_ZSCALE_13__VPORT_ZSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_13
#define PA_CL_VPORT_ZOFFSET_13__VPORT_ZOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_ZOFFSET_13__VPORT_ZOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_14
#define PA_CL_VPORT_XSCALE_14__VPORT_XSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_XSCALE_14__VPORT_XSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_14
#define PA_CL_VPORT_XOFFSET_14__VPORT_XOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_XOFFSET_14__VPORT_XOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_14
#define PA_CL_VPORT_YSCALE_14__VPORT_YSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_YSCALE_14__VPORT_YSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_14
#define PA_CL_VPORT_YOFFSET_14__VPORT_YOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_YOFFSET_14__VPORT_YOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_14
#define PA_CL_VPORT_ZSCALE_14__VPORT_ZSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_ZSCALE_14__VPORT_ZSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_14
#define PA_CL_VPORT_ZOFFSET_14__VPORT_ZOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_ZOFFSET_14__VPORT_ZOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_XSCALE_15
#define PA_CL_VPORT_XSCALE_15__VPORT_XSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_XSCALE_15__VPORT_XSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_XOFFSET_15
#define PA_CL_VPORT_XOFFSET_15__VPORT_XOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_XOFFSET_15__VPORT_XOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_YSCALE_15
#define PA_CL_VPORT_YSCALE_15__VPORT_YSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_YSCALE_15__VPORT_YSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_YOFFSET_15
#define PA_CL_VPORT_YOFFSET_15__VPORT_YOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_YOFFSET_15__VPORT_YOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_VPORT_ZSCALE_15
#define PA_CL_VPORT_ZSCALE_15__VPORT_ZSCALE__SHIFT                                                            0x0
#define PA_CL_VPORT_ZSCALE_15__VPORT_ZSCALE_MASK                                                              0xFFFFFFFFL
//PA_CL_VPORT_ZOFFSET_15
#define PA_CL_VPORT_ZOFFSET_15__VPORT_ZOFFSET__SHIFT                                                          0x0
#define PA_CL_VPORT_ZOFFSET_15__VPORT_ZOFFSET_MASK                                                            0xFFFFFFFFL
//PA_CL_UCP_0_X
#define PA_CL_UCP_0_X__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_0_X__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_0_Y
#define PA_CL_UCP_0_Y__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_0_Y__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_0_Z
#define PA_CL_UCP_0_Z__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_0_Z__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_0_W
#define PA_CL_UCP_0_W__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_0_W__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_1_X
#define PA_CL_UCP_1_X__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_1_X__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_1_Y
#define PA_CL_UCP_1_Y__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_1_Y__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_1_Z
#define PA_CL_UCP_1_Z__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_1_Z__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_1_W
#define PA_CL_UCP_1_W__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_1_W__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_2_X
#define PA_CL_UCP_2_X__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_2_X__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_2_Y
#define PA_CL_UCP_2_Y__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_2_Y__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_2_Z
#define PA_CL_UCP_2_Z__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_2_Z__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_2_W
#define PA_CL_UCP_2_W__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_2_W__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_3_X
#define PA_CL_UCP_3_X__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_3_X__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_3_Y
#define PA_CL_UCP_3_Y__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_3_Y__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_3_Z
#define PA_CL_UCP_3_Z__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_3_Z__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_3_W
#define PA_CL_UCP_3_W__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_3_W__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_4_X
#define PA_CL_UCP_4_X__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_4_X__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_4_Y
#define PA_CL_UCP_4_Y__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_4_Y__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_4_Z
#define PA_CL_UCP_4_Z__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_4_Z__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_4_W
#define PA_CL_UCP_4_W__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_4_W__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_5_X
#define PA_CL_UCP_5_X__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_5_X__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_5_Y
#define PA_CL_UCP_5_Y__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_5_Y__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_5_Z
#define PA_CL_UCP_5_Z__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_5_Z__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_UCP_5_W
#define PA_CL_UCP_5_W__DATA_REGISTER__SHIFT                                                                   0x0
#define PA_CL_UCP_5_W__DATA_REGISTER_MASK                                                                     0xFFFFFFFFL
//PA_CL_PROG_NEAR_CLIP_Z
#define PA_CL_PROG_NEAR_CLIP_Z__DATA_REGISTER__SHIFT                                                          0x0
#define PA_CL_PROG_NEAR_CLIP_Z__DATA_REGISTER_MASK                                                            0xFFFFFFFFL
//SPI_PS_INPUT_CNTL_0
#define SPI_PS_INPUT_CNTL_0__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_0__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_0__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_0__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_0__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_0__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_0__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_0__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_0__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_0__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_0__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_0__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_0__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_0__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_0__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_0__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_0__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_0__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_0__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_0__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_0__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_0__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_0__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_0__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_1
#define SPI_PS_INPUT_CNTL_1__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_1__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_1__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_1__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_1__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_1__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_1__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_1__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_1__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_1__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_1__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_1__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_1__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_1__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_1__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_1__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_1__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_1__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_1__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_1__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_1__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_1__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_1__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_1__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_2
#define SPI_PS_INPUT_CNTL_2__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_2__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_2__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_2__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_2__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_2__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_2__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_2__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_2__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_2__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_2__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_2__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_2__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_2__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_2__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_2__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_2__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_2__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_2__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_2__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_2__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_2__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_2__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_2__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_3
#define SPI_PS_INPUT_CNTL_3__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_3__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_3__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_3__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_3__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_3__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_3__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_3__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_3__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_3__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_3__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_3__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_3__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_3__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_3__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_3__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_3__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_3__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_3__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_3__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_3__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_3__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_3__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_3__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_4
#define SPI_PS_INPUT_CNTL_4__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_4__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_4__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_4__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_4__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_4__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_4__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_4__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_4__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_4__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_4__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_4__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_4__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_4__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_4__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_4__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_4__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_4__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_4__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_4__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_4__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_4__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_4__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_4__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_5
#define SPI_PS_INPUT_CNTL_5__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_5__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_5__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_5__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_5__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_5__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_5__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_5__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_5__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_5__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_5__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_5__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_5__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_5__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_5__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_5__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_5__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_5__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_5__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_5__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_5__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_5__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_5__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_5__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_6
#define SPI_PS_INPUT_CNTL_6__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_6__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_6__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_6__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_6__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_6__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_6__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_6__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_6__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_6__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_6__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_6__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_6__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_6__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_6__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_6__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_6__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_6__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_6__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_6__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_6__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_6__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_6__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_6__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_7
#define SPI_PS_INPUT_CNTL_7__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_7__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_7__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_7__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_7__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_7__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_7__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_7__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_7__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_7__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_7__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_7__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_7__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_7__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_7__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_7__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_7__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_7__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_7__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_7__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_7__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_7__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_7__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_7__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_8
#define SPI_PS_INPUT_CNTL_8__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_8__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_8__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_8__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_8__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_8__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_8__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_8__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_8__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_8__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_8__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_8__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_8__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_8__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_8__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_8__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_8__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_8__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_8__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_8__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_8__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_8__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_8__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_8__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_9
#define SPI_PS_INPUT_CNTL_9__OFFSET__SHIFT                                                                    0x0
#define SPI_PS_INPUT_CNTL_9__DEFAULT_VAL__SHIFT                                                               0x8
#define SPI_PS_INPUT_CNTL_9__FLAT_SHADE__SHIFT                                                                0xa
#define SPI_PS_INPUT_CNTL_9__CYL_WRAP__SHIFT                                                                  0xd
#define SPI_PS_INPUT_CNTL_9__PT_SPRITE_TEX__SHIFT                                                             0x11
#define SPI_PS_INPUT_CNTL_9__DUP__SHIFT                                                                       0x12
#define SPI_PS_INPUT_CNTL_9__FP16_INTERP_MODE__SHIFT                                                          0x13
#define SPI_PS_INPUT_CNTL_9__USE_DEFAULT_ATTR1__SHIFT                                                         0x14
#define SPI_PS_INPUT_CNTL_9__DEFAULT_VAL_ATTR1__SHIFT                                                         0x15
#define SPI_PS_INPUT_CNTL_9__PT_SPRITE_TEX_ATTR1__SHIFT                                                       0x17
#define SPI_PS_INPUT_CNTL_9__ATTR0_VALID__SHIFT                                                               0x18
#define SPI_PS_INPUT_CNTL_9__ATTR1_VALID__SHIFT                                                               0x19
#define SPI_PS_INPUT_CNTL_9__OFFSET_MASK                                                                      0x0000003FL
#define SPI_PS_INPUT_CNTL_9__DEFAULT_VAL_MASK                                                                 0x00000300L
#define SPI_PS_INPUT_CNTL_9__FLAT_SHADE_MASK                                                                  0x00000400L
#define SPI_PS_INPUT_CNTL_9__CYL_WRAP_MASK                                                                    0x0001E000L
#define SPI_PS_INPUT_CNTL_9__PT_SPRITE_TEX_MASK                                                               0x00020000L
#define SPI_PS_INPUT_CNTL_9__DUP_MASK                                                                         0x00040000L
#define SPI_PS_INPUT_CNTL_9__FP16_INTERP_MODE_MASK                                                            0x00080000L
#define SPI_PS_INPUT_CNTL_9__USE_DEFAULT_ATTR1_MASK                                                           0x00100000L
#define SPI_PS_INPUT_CNTL_9__DEFAULT_VAL_ATTR1_MASK                                                           0x00600000L
#define SPI_PS_INPUT_CNTL_9__PT_SPRITE_TEX_ATTR1_MASK                                                         0x00800000L
#define SPI_PS_INPUT_CNTL_9__ATTR0_VALID_MASK                                                                 0x01000000L
#define SPI_PS_INPUT_CNTL_9__ATTR1_VALID_MASK                                                                 0x02000000L
//SPI_PS_INPUT_CNTL_10
#define SPI_PS_INPUT_CNTL_10__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_10__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_10__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_10__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_10__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_10__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_10__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_10__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_10__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_10__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_10__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_10__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_10__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_10__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_10__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_10__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_10__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_10__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_10__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_10__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_10__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_10__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_10__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_10__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_11
#define SPI_PS_INPUT_CNTL_11__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_11__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_11__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_11__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_11__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_11__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_11__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_11__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_11__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_11__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_11__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_11__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_11__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_11__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_11__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_11__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_11__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_11__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_11__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_11__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_11__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_11__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_11__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_11__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_12
#define SPI_PS_INPUT_CNTL_12__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_12__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_12__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_12__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_12__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_12__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_12__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_12__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_12__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_12__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_12__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_12__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_12__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_12__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_12__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_12__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_12__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_12__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_12__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_12__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_12__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_12__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_12__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_12__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_13
#define SPI_PS_INPUT_CNTL_13__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_13__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_13__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_13__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_13__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_13__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_13__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_13__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_13__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_13__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_13__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_13__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_13__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_13__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_13__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_13__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_13__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_13__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_13__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_13__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_13__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_13__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_13__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_13__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_14
#define SPI_PS_INPUT_CNTL_14__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_14__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_14__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_14__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_14__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_14__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_14__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_14__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_14__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_14__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_14__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_14__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_14__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_14__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_14__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_14__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_14__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_14__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_14__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_14__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_14__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_14__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_14__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_14__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_15
#define SPI_PS_INPUT_CNTL_15__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_15__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_15__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_15__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_15__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_15__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_15__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_15__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_15__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_15__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_15__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_15__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_15__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_15__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_15__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_15__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_15__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_15__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_15__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_15__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_15__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_15__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_15__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_15__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_16
#define SPI_PS_INPUT_CNTL_16__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_16__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_16__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_16__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_16__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_16__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_16__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_16__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_16__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_16__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_16__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_16__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_16__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_16__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_16__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_16__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_16__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_16__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_16__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_16__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_16__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_16__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_16__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_16__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_17
#define SPI_PS_INPUT_CNTL_17__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_17__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_17__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_17__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_17__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_17__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_17__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_17__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_17__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_17__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_17__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_17__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_17__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT_CNTL_17__DEFAULT_VAL_MASK                                                                0x00000300L
#define SPI_PS_INPUT_CNTL_17__FLAT_SHADE_MASK                                                                 0x00000400L
#define SPI_PS_INPUT_CNTL_17__CYL_WRAP_MASK                                                                   0x0001E000L
#define SPI_PS_INPUT_CNTL_17__PT_SPRITE_TEX_MASK                                                              0x00020000L
#define SPI_PS_INPUT_CNTL_17__DUP_MASK                                                                        0x00040000L
#define SPI_PS_INPUT_CNTL_17__FP16_INTERP_MODE_MASK                                                           0x00080000L
#define SPI_PS_INPUT_CNTL_17__USE_DEFAULT_ATTR1_MASK                                                          0x00100000L
#define SPI_PS_INPUT_CNTL_17__DEFAULT_VAL_ATTR1_MASK                                                          0x00600000L
#define SPI_PS_INPUT_CNTL_17__PT_SPRITE_TEX_ATTR1_MASK                                                        0x00800000L
#define SPI_PS_INPUT_CNTL_17__ATTR0_VALID_MASK                                                                0x01000000L
#define SPI_PS_INPUT_CNTL_17__ATTR1_VALID_MASK                                                                0x02000000L
//SPI_PS_INPUT_CNTL_18
#define SPI_PS_INPUT_CNTL_18__OFFSET__SHIFT                                                                   0x0
#define SPI_PS_INPUT_CNTL_18__DEFAULT_VAL__SHIFT                                                              0x8
#define SPI_PS_INPUT_CNTL_18__FLAT_SHADE__SHIFT                                                               0xa
#define SPI_PS_INPUT_CNTL_18__CYL_WRAP__SHIFT                                                                 0xd
#define SPI_PS_INPUT_CNTL_18__PT_SPRITE_TEX__SHIFT                                                            0x11
#define SPI_PS_INPUT_CNTL_18__DUP__SHIFT                                                                      0x12
#define SPI_PS_INPUT_CNTL_18__FP16_INTERP_MODE__SHIFT                                                         0x13
#define SPI_PS_INPUT_CNTL_18__USE_DEFAULT_ATTR1__SHIFT                                                        0x14
#define SPI_PS_INPUT_CNTL_18__DEFAULT_VAL_ATTR1__SHIFT                                                        0x15
#define SPI_PS_INPUT_CNTL_18__PT_SPRITE_TEX_ATTR1__SHIFT                                                      0x17
#define SPI_PS_INPUT_CNTL_18__ATTR0_VALID__SHIFT                                                              0x18
#define SPI_PS_INPUT_CNTL_18__ATTR1_VALID__SHIFT                                                              0x19
#define SPI_PS_INPUT_CNTL_18__OFFSET_MASK                                                                     0x0000003FL
#define SPI_PS_INPUT