// RUN: %clang_cc1 -triple x86_64-unknown-unknown -fclang-abi-compat=7.0 -std=c++17 -ast-dump=json %s | FileCheck %s

void f() {
  auto IsNotGenericLambda = [](){};
  auto IsGenericLambda = [](auto){};
}

struct CanPassInRegisters {
  CanPassInRegisters(const CanPassInRegisters&) = default;
};

struct CantPassInRegisters {
  CantPassInRegisters(const CantPassInRegisters&) = delete;
};

struct IsEmpty {
};

struct IsNotEmpty {
  int a;
};

struct IsAggregate {
  int a;
};

struct IsNotAggregate {
private:
  int a;
};

struct IsStandardLayout {
  void f();
};

struct IsNotStandardLayout {
  virtual void f();
};

struct IsTriviallyCopyable {
};

struct IsNotTriviallyCopyable {
  IsNotTriviallyCopyable(const IsNotTriviallyCopyable&) {}
};

struct IsPOD {
  int a;
};

struct IsNotPOD {
  int &a;
};

struct IsTrivial {
  IsTrivial() = default;
};

struct IsNotTrivial {
  IsNotTrivial() {}
};

struct IsPolymorphic {
  virtual void f();
};

struct IsNotPolymorphic {
  void f();
};

struct IsAbstract {
  virtual void f() = 0;
};

struct IsNotAbstract {
  virtual void f();
};

struct IsLiteral {
  ~IsLiteral() = default;
};

struct IsNotLiteral {
  ~IsNotLiteral() {}
};

struct HasUserDeclaredConstructor {
  HasUserDeclaredConstructor() {}
};

struct HasNoUserDeclaredConstructor {
};

struct HasConstexprNonCopyMoveConstructor {
  constexpr HasConstexprNonCopyMoveConstructor() {}
};

struct HasNoConstexprNonCopyMoveConstructor {
  HasNoConstexprNonCopyMoveConstructor() {}
};

struct HasMutableFields {
  mutable int i;
};

struct HasNoMutableFields {
  int i;
};

struct HasVariantMembers {
  union {
    int i;
  };
};

struct HasNoVariantMembers {
};

struct AllowsConstDefaultInit {
  int i = 12;
};

struct DoesNotAllowConstDefaultInit {
  int i;
};

// NOTE: CHECK lines have been autogenerated by gen_ast_dump_json_test.py
// using --filters=CXXRecordDecl

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "name": "__NSConstantString_tag"
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "name": "__va_list_tag"
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 157,
// CHECK-NEXT:   "col": 29,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 157,
// CHECK-NEXT:    "col": 29,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 157,
// CHECK-NEXT:    "col": 29,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "isImplicit": true,
// CHECK-NEXT:  "tagUsed": "class",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLambda": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 157,
// CHECK-NEXT:     "col": 29,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 160,
// CHECK-NEXT:      "col": 32,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 162,
// CHECK-NEXT:      "col": 34,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "operator()",
// CHECK-NEXT:    "mangledName": "_ZZ1fvENK3$_0clEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void () const"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 161,
// CHECK-NEXT:        "col": 33,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 162,
// CHECK-NEXT:        "col": 34,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConversionDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 157,
// CHECK-NEXT:     "col": 29,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 157,
// CHECK-NEXT:      "col": 29,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 162,
// CHECK-NEXT:      "col": 34,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator void (*)()",
// CHECK-NEXT:    "mangledName": "_ZZ1fvENK3$_0cvPFvvEEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void (*() const noexcept)()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 157,
// CHECK-NEXT:     "col": 29,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 157,
// CHECK-NEXT:      "col": 29,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 162,
// CHECK-NEXT:      "col": 34,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__invoke",
// CHECK-NEXT:    "mangledName": "_ZZ1fvEN3$_08__invokeEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "storageClass": "static",
// CHECK-NEXT:    "inline": true
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 157,
// CHECK-NEXT:     "col": 29,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 157,
// CHECK-NEXT:      "col": 29,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 157,
// CHECK-NEXT:      "col": 29,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "~",
// CHECK-NEXT:    "mangledName": "_ZZ1fvEN3$_0D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void () noexcept"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 190,
// CHECK-NEXT:   "col": 26,
// CHECK-NEXT:   "tokLen": 1
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 190,
// CHECK-NEXT:    "col": 26,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 190,
// CHECK-NEXT:    "col": 26,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "isImplicit": true,
// CHECK-NEXT:  "tagUsed": "class",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isGenericLambda": true,
// CHECK-NEXT:   "isLambda": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 190,
// CHECK-NEXT:     "col": 26,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 199,
// CHECK-NEXT:      "col": 35,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "operator()",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 197,
// CHECK-NEXT:       "col": 33,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 193,
// CHECK-NEXT:        "col": 29,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 197,
// CHECK-NEXT:        "col": 33,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "auto:1",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXMethodDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 190,
// CHECK-NEXT:       "col": 26,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 197,
// CHECK-NEXT:        "col": 33,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 199,
// CHECK-NEXT:        "col": 35,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "operator()",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "auto (auto) const"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true,
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 197,
// CHECK-NEXT:         "col": 33,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 193,
// CHECK-NEXT:          "col": 29,
// CHECK-NEXT:          "tokLen": 4
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 193,
// CHECK-NEXT:          "col": 29,
// CHECK-NEXT:          "tokLen": 4
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "auto"
// CHECK-NEXT:        }
// CHECK-NEXT:       },
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "CompoundStmt",
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 198,
// CHECK-NEXT:          "col": 34,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 199,
// CHECK-NEXT:          "col": 35,
// CHECK-NEXT:          "tokLen": 1
// CHECK-NEXT:         }
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 190,
// CHECK-NEXT:     "col": 26,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 199,
// CHECK-NEXT:      "col": 35,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator auto (*)(type-parameter-0-0)",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 197,
// CHECK-NEXT:       "col": 33,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 193,
// CHECK-NEXT:        "col": 29,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 197,
// CHECK-NEXT:        "col": 33,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "auto:1",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXConversionDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 190,
// CHECK-NEXT:       "col": 26,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 190,
// CHECK-NEXT:        "col": 26,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 199,
// CHECK-NEXT:        "col": 35,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "operator auto (*)(type-parameter-0-0)",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "auto (*() const noexcept)(auto)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "constexpr": true
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FunctionTemplateDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 190,
// CHECK-NEXT:     "col": 26,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {},
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 199,
// CHECK-NEXT:      "col": 35,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "__invoke",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "TemplateTypeParmDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 197,
// CHECK-NEXT:       "col": 33,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 193,
// CHECK-NEXT:        "col": 29,
// CHECK-NEXT:        "tokLen": 4
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 197,
// CHECK-NEXT:        "col": 33,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "auto:1",
// CHECK-NEXT:      "tagUsed": "class",
// CHECK-NEXT:      "depth": 0,
// CHECK-NEXT:      "index": 0
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CXXMethodDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 190,
// CHECK-NEXT:       "col": 26,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 190,
// CHECK-NEXT:        "col": 26,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 199,
// CHECK-NEXT:        "col": 35,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "isImplicit": true,
// CHECK-NEXT:      "name": "__invoke",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "auto (auto)"
// CHECK-NEXT:      },
// CHECK-NEXT:      "storageClass": "static",
// CHECK-NEXT:      "inline": true,
// CHECK-NEXT:      "inner": [
// CHECK-NEXT:       {
// CHECK-NEXT:        "id": "0x{{.*}}",
// CHECK-NEXT:        "kind": "ParmVarDecl",
// CHECK-NEXT:        "loc": {
// CHECK-NEXT:         "offset": 197,
// CHECK-NEXT:         "col": 33,
// CHECK-NEXT:         "tokLen": 1
// CHECK-NEXT:        },
// CHECK-NEXT:        "range": {
// CHECK-NEXT:         "begin": {
// CHECK-NEXT:          "offset": 193,
// CHECK-NEXT:          "col": 29,
// CHECK-NEXT:          "tokLen": 4
// CHECK-NEXT:         },
// CHECK-NEXT:         "end": {
// CHECK-NEXT:          "offset": 193,
// CHECK-NEXT:          "col": 29,
// CHECK-NEXT:          "tokLen": 4
// CHECK-NEXT:         }
// CHECK-NEXT:        },
// CHECK-NEXT:        "type": {
// CHECK-NEXT:         "qualType": "auto"
// CHECK-NEXT:        }
// CHECK-NEXT:       }
// CHECK-NEXT:      ]
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 190,
// CHECK-NEXT:     "col": 26,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 190,
// CHECK-NEXT:      "col": 26,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 190,
// CHECK-NEXT:      "col": 26,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "~",
// CHECK-NEXT:    "mangledName": "_ZZ1fvEN3$_1D1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void () noexcept"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 212,
// CHECK-NEXT:   "line": 8,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 18
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 205,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 292,
// CHECK-NEXT:    "line": 10,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "CanPassInRegisters",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "trivial": true,
// CHECK-NEXT:    "userDeclared": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 212,
// CHECK-NEXT:     "line": 8,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 18
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 205,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 212,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 18
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "CanPassInRegisters",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 235,
// CHECK-NEXT:     "line": 9,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 18
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 235,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 18
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 289,
// CHECK-NEXT:      "col": 57,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "CanPassInRegisters",
// CHECK-NEXT:    "mangledName": "_ZN18CanPassInRegistersC1ERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void (const CanPassInRegisters &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 279,
// CHECK-NEXT:       "col": 47,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 254,
// CHECK-NEXT:        "col": 22,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 278,
// CHECK-NEXT:        "col": 46,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const CanPassInRegisters &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 303,
// CHECK-NEXT:   "line": 12,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 19
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 296,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 385,
// CHECK-NEXT:    "line": 14,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "CantPassInRegisters",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "trivial": true,
// CHECK-NEXT:    "userDeclared": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 303,
// CHECK-NEXT:     "line": 12,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 296,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 303,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "CantPassInRegisters",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 327,
// CHECK-NEXT:     "line": 13,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 327,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 382,
// CHECK-NEXT:      "col": 58,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "CantPassInRegisters",
// CHECK-NEXT:    "mangledName": "_ZN19CantPassInRegistersC1ERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void (const CantPassInRegisters &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "explicitlyDeleted": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 373,
// CHECK-NEXT:       "col": 49,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 347,
// CHECK-NEXT:        "col": 23,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 372,
// CHECK-NEXT:        "col": 48,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const CantPassInRegisters &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 396,
// CHECK-NEXT:   "line": 16,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 7
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 389,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 406,
// CHECK-NEXT:    "line": 17,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsEmpty",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 396,
// CHECK-NEXT:     "line": 16,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 7
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 389,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 396,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsEmpty",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 417,
// CHECK-NEXT:   "line": 19,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 10
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 410,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 439,
// CHECK-NEXT:    "line": 21,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotEmpty",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 417,
// CHECK-NEXT:     "line": 19,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 410,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 417,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsNotEmpty",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 436,
// CHECK-NEXT:     "line": 20,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 432,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 436,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 450,
// CHECK-NEXT:   "line": 23,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 11
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 443,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 473,
// CHECK-NEXT:    "line": 25,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsAggregate",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 450,
// CHECK-NEXT:     "line": 23,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 11
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 443,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 450,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 11
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsAggregate",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 470,
// CHECK-NEXT:     "line": 24,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 466,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 470,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 484,
// CHECK-NEXT:   "line": 27,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 14
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 477,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 519,
// CHECK-NEXT:    "line": 30,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotAggregate",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 484,
// CHECK-NEXT:     "line": 27,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 14
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 477,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 484,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 14
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsNotAggregate",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "AccessSpecDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 501,
// CHECK-NEXT:     "line": 28,
// CHECK-NEXT:     "col": 1,
// CHECK-NEXT:     "tokLen": 7
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 501,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 508,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "access": "private"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 516,
// CHECK-NEXT:     "line": 29,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 512,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 516,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 530,
// CHECK-NEXT:   "line": 32,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 16
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 523,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 561,
// CHECK-NEXT:    "line": 34,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsStandardLayout",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 530,
// CHECK-NEXT:     "line": 32,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 16
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 523,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 530,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 16
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsStandardLayout",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 556,
// CHECK-NEXT:     "line": 33,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 551,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 4
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 558,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "mangledName": "_ZN16IsStandardLayout1fEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 572,
// CHECK-NEXT:   "line": 36,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 19
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 565,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 614,
// CHECK-NEXT:    "line": 38,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotStandardLayout",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPolymorphic": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 572,
// CHECK-NEXT:     "line": 36,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 565,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsNotStandardLayout",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 609,
// CHECK-NEXT:     "line": 37,
// CHECK-NEXT:     "col": 16,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 596,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 611,
// CHECK-NEXT:      "col": 18,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "mangledName": "_ZN19IsNotStandardLayout1fEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "virtual": true
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 572,
// CHECK-NEXT:     "line": 36,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN19IsNotStandardLayoutaSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsNotStandardLayout &(const IsNotStandardLayout &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 572,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 19
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 572,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 19
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 572,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 19
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const IsNotStandardLayout &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 572,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN19IsNotStandardLayoutaSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsNotStandardLayout &(IsNotStandardLayout &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 572,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 19
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 572,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 19
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 572,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 19
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "IsNotStandardLayout &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 572,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 572,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~IsNotStandardLayout",
// CHECK-NEXT:    "mangledName": "_ZN19IsNotStandardLayoutD1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 625,
// CHECK-NEXT:   "line": 40,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 19
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 618,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 647,
// CHECK-NEXT:    "line": 41,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsTriviallyCopyable",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 625,
// CHECK-NEXT:     "line": 40,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 618,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 625,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsTriviallyCopyable",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 658,
// CHECK-NEXT:   "line": 43,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 22
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 651,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 742,
// CHECK-NEXT:    "line": 45,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotTriviallyCopyable",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "userDeclared": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 658,
// CHECK-NEXT:     "line": 43,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 22
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 651,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 658,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 22
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "IsNotTriviallyCopyable",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 685,
// CHECK-NEXT:     "line": 44,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 22
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 685,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 22
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 740,
// CHECK-NEXT:      "col": 58,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "IsNotTriviallyCopyable",
// CHECK-NEXT:    "mangledName": "_ZN22IsNotTriviallyCopyableC1ERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void (const IsNotTriviallyCopyable &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 737,
// CHECK-NEXT:       "col": 55,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 708,
// CHECK-NEXT:        "col": 26,
// CHECK-NEXT:        "tokLen": 5
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 736,
// CHECK-NEXT:        "col": 54,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const IsNotTriviallyCopyable &"
// CHECK-NEXT:      }
// CHECK-NEXT:     },
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 739,
// CHECK-NEXT:        "col": 57,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 740,
// CHECK-NEXT:        "col": 58,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 753,
// CHECK-NEXT:   "line": 47,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 5
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 746,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 770,
// CHECK-NEXT:    "line": 49,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsPOD",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 753,
// CHECK-NEXT:     "line": 47,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 746,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 753,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsPOD",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 767,
// CHECK-NEXT:     "line": 48,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 763,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 767,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 781,
// CHECK-NEXT:   "line": 51,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 8
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 774,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 802,
// CHECK-NEXT:    "line": 53,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotPOD",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 781,
// CHECK-NEXT:     "line": 51,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 8
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 774,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 781,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 8
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsNotPOD",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 799,
// CHECK-NEXT:     "line": 52,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 794,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 799,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "a",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int &"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 813,
// CHECK-NEXT:   "line": 55,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 9
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 806,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 850,
// CHECK-NEXT:    "line": 57,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsTrivial",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 813,
// CHECK-NEXT:     "line": 55,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 9
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 806,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 813,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 9
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "IsTrivial",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 827,
// CHECK-NEXT:     "line": 56,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 9
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 827,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 9
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 847,
// CHECK-NEXT:      "col": 23,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "IsTrivial",
// CHECK-NEXT:    "mangledName": "_ZN9IsTrivialC1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 861,
// CHECK-NEXT:   "line": 59,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 12
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 854,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 896,
// CHECK-NEXT:    "line": 61,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotTrivial",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "userProvided": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 861,
// CHECK-NEXT:     "line": 59,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 12
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 854,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 861,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 12
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "IsNotTrivial",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 878,
// CHECK-NEXT:     "line": 60,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 12
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 878,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 12
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 894,
// CHECK-NEXT:      "col": 19,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "IsNotTrivial",
// CHECK-NEXT:    "mangledName": "_ZN12IsNotTrivialC1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 893,
// CHECK-NEXT:        "col": 18,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 894,
// CHECK-NEXT:        "col": 19,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 907,
// CHECK-NEXT:   "line": 63,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 13
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 900,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 943,
// CHECK-NEXT:    "line": 65,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsPolymorphic",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPolymorphic": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 907,
// CHECK-NEXT:     "line": 63,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 900,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsPolymorphic",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 938,
// CHECK-NEXT:     "line": 64,
// CHECK-NEXT:     "col": 16,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 925,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 940,
// CHECK-NEXT:      "col": 18,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "mangledName": "_ZN13IsPolymorphic1fEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "virtual": true
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 907,
// CHECK-NEXT:     "line": 63,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN13IsPolymorphicaSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsPolymorphic &(const IsPolymorphic &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 907,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 13
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 907,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 907,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const IsPolymorphic &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 907,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN13IsPolymorphicaSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsPolymorphic &(IsPolymorphic &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 907,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 13
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 907,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 907,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "IsPolymorphic &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 907,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 907,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~IsPolymorphic",
// CHECK-NEXT:    "mangledName": "_ZN13IsPolymorphicD1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 954,
// CHECK-NEXT:   "line": 67,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 16
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 947,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 985,
// CHECK-NEXT:    "line": 69,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotPolymorphic",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 954,
// CHECK-NEXT:     "line": 67,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 16
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 947,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 954,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 16
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsNotPolymorphic",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 980,
// CHECK-NEXT:     "line": 68,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 975,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 4
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 982,
// CHECK-NEXT:      "col": 10,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "mangledName": "_ZN16IsNotPolymorphic1fEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 996,
// CHECK-NEXT:   "line": 71,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 10
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 989,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1033,
// CHECK-NEXT:    "line": 73,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsAbstract",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAbstract": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPolymorphic": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 996,
// CHECK-NEXT:     "line": 71,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 989,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsAbstract",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1024,
// CHECK-NEXT:     "line": 72,
// CHECK-NEXT:     "col": 16,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1011,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1030,
// CHECK-NEXT:      "col": 22,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "mangledName": "_ZN10IsAbstract1fEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "virtual": true,
// CHECK-NEXT:    "pure": true
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 996,
// CHECK-NEXT:     "line": 71,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN10IsAbstractaSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsAbstract &(const IsAbstract &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 996,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 10
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 996,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 10
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 996,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 10
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const IsAbstract &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 996,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN10IsAbstractaSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsAbstract &(IsAbstract &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 996,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 10
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 996,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 10
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 996,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 10
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "IsAbstract &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 996,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 10
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 996,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 10
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~IsAbstract",
// CHECK-NEXT:    "mangledName": "_ZN10IsAbstractD1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1044,
// CHECK-NEXT:   "line": 75,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 13
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1037,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1080,
// CHECK-NEXT:    "line": 77,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotAbstract",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPolymorphic": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "simple": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1044,
// CHECK-NEXT:     "line": 75,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1037,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "IsNotAbstract",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1075,
// CHECK-NEXT:     "line": 76,
// CHECK-NEXT:     "col": 16,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1062,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1077,
// CHECK-NEXT:      "col": 18,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "f",
// CHECK-NEXT:    "mangledName": "_ZN13IsNotAbstract1fEv",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "virtual": true
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1044,
// CHECK-NEXT:     "line": 75,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN13IsNotAbstractaSERKS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsNotAbstract &(const IsNotAbstract &)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1044,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 13
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1044,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1044,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "const IsNotAbstract &"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXMethodDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1044,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "operator=",
// CHECK-NEXT:    "mangledName": "_ZN13IsNotAbstractaSEOS_",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "IsNotAbstract &(IsNotAbstract &&)"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default",
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "ParmVarDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1044,
// CHECK-NEXT:       "col": 8,
// CHECK-NEXT:       "tokLen": 13
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1044,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1044,
// CHECK-NEXT:        "col": 8,
// CHECK-NEXT:        "tokLen": 13
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "IsNotAbstract &&"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1044,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 13
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1044,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 13
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "~IsNotAbstract",
// CHECK-NEXT:    "mangledName": "_ZN13IsNotAbstractD1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inline": true,
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1091,
// CHECK-NEXT:   "line": 79,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 9
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1084,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1129,
// CHECK-NEXT:    "line": 81,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsLiteral",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "trivial": true,
// CHECK-NEXT:    "userDeclared": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1091,
// CHECK-NEXT:     "line": 79,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 9
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1084,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1091,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 9
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "IsLiteral",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1105,
// CHECK-NEXT:     "line": 80,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1105,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1126,
// CHECK-NEXT:      "col": 24,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "~IsLiteral",
// CHECK-NEXT:    "mangledName": "_ZN9IsLiteralD1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "explicitlyDefaulted": "default"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1140,
// CHECK-NEXT:   "line": 83,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 12
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1133,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1176,
// CHECK-NEXT:    "line": 85,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "IsNotLiteral",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "userDeclared": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "moveAssign": {},
// CHECK-NEXT:   "moveCtor": {}
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1140,
// CHECK-NEXT:     "line": 83,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 12
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1133,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1140,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 12
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "IsNotLiteral",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXDestructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1157,
// CHECK-NEXT:     "line": 84,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1157,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1174,
// CHECK-NEXT:      "col": 20,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "~IsNotLiteral",
// CHECK-NEXT:    "mangledName": "_ZN12IsNotLiteralD1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void () noexcept"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1173,
// CHECK-NEXT:        "col": 19,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1174,
// CHECK-NEXT:        "col": 20,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1187,
// CHECK-NEXT:   "line": 87,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 26
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1180,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1250,
// CHECK-NEXT:    "line": 89,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasUserDeclaredConstructor",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "userProvided": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1187,
// CHECK-NEXT:     "line": 87,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 26
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1180,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1187,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 26
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "HasUserDeclaredConstructor",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1218,
// CHECK-NEXT:     "line": 88,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 26
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1218,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 26
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1248,
// CHECK-NEXT:      "col": 33,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "HasUserDeclaredConstructor",
// CHECK-NEXT:    "mangledName": "_ZN26HasUserDeclaredConstructorC1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1247,
// CHECK-NEXT:        "col": 32,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1248,
// CHECK-NEXT:        "col": 33,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1261,
// CHECK-NEXT:   "line": 91,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 28
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1254,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1292,
// CHECK-NEXT:    "line": 92,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasNoUserDeclaredConstructor",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1261,
// CHECK-NEXT:     "line": 91,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 28
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1254,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1261,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 28
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "HasNoUserDeclaredConstructor",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1303,
// CHECK-NEXT:   "line": 94,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 34
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1296,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1392,
// CHECK-NEXT:    "line": 96,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasConstexprNonCopyMoveConstructor",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "userProvided": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1303,
// CHECK-NEXT:     "line": 94,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 34
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1296,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1303,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 34
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "HasConstexprNonCopyMoveConstructor",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1352,
// CHECK-NEXT:     "line": 95,
// CHECK-NEXT:     "col": 13,
// CHECK-NEXT:     "tokLen": 34
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1342,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 9
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1390,
// CHECK-NEXT:      "col": 51,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "HasConstexprNonCopyMoveConstructor",
// CHECK-NEXT:    "mangledName": "_ZN34HasConstexprNonCopyMoveConstructorC1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "constexpr": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1389,
// CHECK-NEXT:        "col": 50,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1390,
// CHECK-NEXT:        "col": 51,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1403,
// CHECK-NEXT:   "line": 98,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 36
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1396,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1486,
// CHECK-NEXT:    "line": 100,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasNoConstexprNonCopyMoveConstructor",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "nonTrivial": true,
// CHECK-NEXT:    "userProvided": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasUserDeclaredConstructor": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1403,
// CHECK-NEXT:     "line": 98,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 36
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1396,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1403,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 36
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "isReferenced": true,
// CHECK-NEXT:    "name": "HasNoConstexprNonCopyMoveConstructor",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXConstructorDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1444,
// CHECK-NEXT:     "line": 99,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 36
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1444,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 36
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1484,
// CHECK-NEXT:      "col": 43,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "HasNoConstexprNonCopyMoveConstructor",
// CHECK-NEXT:    "mangledName": "_ZN36HasNoConstexprNonCopyMoveConstructorC1Ev",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "void ()"
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "CompoundStmt",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1483,
// CHECK-NEXT:        "col": 42,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1484,
// CHECK-NEXT:        "col": 43,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1497,
// CHECK-NEXT:   "line": 102,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 16
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1490,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1533,
// CHECK-NEXT:    "line": 104,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasMutableFields",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasMutableFields": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1497,
// CHECK-NEXT:     "line": 102,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 16
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1490,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1497,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 16
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "HasMutableFields",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1530,
// CHECK-NEXT:     "line": 103,
// CHECK-NEXT:     "col": 15,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1518,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 7
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1530,
// CHECK-NEXT:      "col": 15,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "i",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "mutable": true
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1544,
// CHECK-NEXT:   "line": 106,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 18
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1537,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1574,
// CHECK-NEXT:    "line": 108,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasNoMutableFields",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1544,
// CHECK-NEXT:     "line": 106,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 18
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1537,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1544,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 18
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "HasNoMutableFields",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1571,
// CHECK-NEXT:     "line": 107,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1567,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1571,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "i",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1585,
// CHECK-NEXT:   "line": 110,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 17
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1578,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1631,
// CHECK-NEXT:    "line": 114,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasVariantMembers",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasVariantMembers": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1585,
// CHECK-NEXT:     "line": 110,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 17
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1578,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1585,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 17
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "HasVariantMembers",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1607,
// CHECK-NEXT:     "line": 111,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1607,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1628,
// CHECK-NEXT:      "line": 113,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "tagUsed": "union",
// CHECK-NEXT:    "completeDefinition": true,
// CHECK-NEXT:    "definitionData": {
// CHECK-NEXT:     "canPassInRegisters": true,
// CHECK-NEXT:     "copyAssign": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "copyCtor": {
// CHECK-NEXT:      "hasConstParam": true,
// CHECK-NEXT:      "implicitHasConstParam": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "defaultCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "dtor": {
// CHECK-NEXT:      "irrelevant": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "hasVariantMembers": true,
// CHECK-NEXT:     "isAggregate": true,
// CHECK-NEXT:     "isLiteral": true,
// CHECK-NEXT:     "isPOD": true,
// CHECK-NEXT:     "isStandardLayout": true,
// CHECK-NEXT:     "isTrivial": true,
// CHECK-NEXT:     "isTriviallyCopyable": true,
// CHECK-NEXT:     "moveAssign": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     },
// CHECK-NEXT:     "moveCtor": {
// CHECK-NEXT:      "exists": true,
// CHECK-NEXT:      "needsImplicit": true,
// CHECK-NEXT:      "simple": true,
// CHECK-NEXT:      "trivial": true
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "FieldDecl",
// CHECK-NEXT:      "loc": {
// CHECK-NEXT:       "offset": 1623,
// CHECK-NEXT:       "line": 112,
// CHECK-NEXT:       "col": 9,
// CHECK-NEXT:       "tokLen": 1
// CHECK-NEXT:      },
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1619,
// CHECK-NEXT:        "col": 5,
// CHECK-NEXT:        "tokLen": 3
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1623,
// CHECK-NEXT:        "col": 9,
// CHECK-NEXT:        "tokLen": 1
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "name": "i",
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      }
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1607,
// CHECK-NEXT:     "line": 111,
// CHECK-NEXT:     "col": 3,
// CHECK-NEXT:     "tokLen": 5
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1607,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1607,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 5
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "HasVariantMembers::(anonymous union at {{.*}}:111:3)"
// CHECK-NEXT:    }
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "IndirectFieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1623,
// CHECK-NEXT:     "line": 112,
// CHECK-NEXT:     "col": 9,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1623,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1623,
// CHECK-NEXT:      "col": 9,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "i"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1642,
// CHECK-NEXT:   "line": 116,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 19
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1635,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1664,
// CHECK-NEXT:    "line": 117,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "HasNoVariantMembers",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isEmpty": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1642,
// CHECK-NEXT:     "line": 116,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 19
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1635,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1642,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 19
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "HasNoVariantMembers",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1675,
// CHECK-NEXT:   "line": 119,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 22
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1668,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1714,
// CHECK-NEXT:    "line": 121,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "AllowsConstDefaultInit",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canConstDefaultInit": true,
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "defaultedIsConstexpr": true,
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "isConstexpr": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "nonTrivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "hasConstexprNonCopyMoveConstructor": true,
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1675,
// CHECK-NEXT:     "line": 119,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 22
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1668,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1675,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 22
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "AllowsConstDefaultInit",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1706,
// CHECK-NEXT:     "line": 120,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1702,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1710,
// CHECK-NEXT:      "col": 11,
// CHECK-NEXT:      "tokLen": 2
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "i",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    },
// CHECK-NEXT:    "hasInClassInitializer": true,
// CHECK-NEXT:    "inner": [
// CHECK-NEXT:     {
// CHECK-NEXT:      "id": "0x{{.*}}",
// CHECK-NEXT:      "kind": "IntegerLiteral",
// CHECK-NEXT:      "range": {
// CHECK-NEXT:       "begin": {
// CHECK-NEXT:        "offset": 1710,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       },
// CHECK-NEXT:       "end": {
// CHECK-NEXT:        "offset": 1710,
// CHECK-NEXT:        "col": 11,
// CHECK-NEXT:        "tokLen": 2
// CHECK-NEXT:       }
// CHECK-NEXT:      },
// CHECK-NEXT:      "type": {
// CHECK-NEXT:       "qualType": "int"
// CHECK-NEXT:      },
// CHECK-NEXT:      "valueCategory": "prvalue",
// CHECK-NEXT:      "value": "12"
// CHECK-NEXT:     }
// CHECK-NEXT:    ]
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }

// CHECK-NOT: {{^}}Dumping
// CHECK:  "kind": "CXXRecordDecl",
// CHECK-NEXT:  "loc": {
// CHECK-NEXT:   "offset": 1725,
// CHECK-NEXT:   "line": 123,
// CHECK-NEXT:   "col": 8,
// CHECK-NEXT:   "tokLen": 28
// CHECK-NEXT:  },
// CHECK-NEXT:  "range": {
// CHECK-NEXT:   "begin": {
// CHECK-NEXT:    "offset": 1718,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 6
// CHECK-NEXT:   },
// CHECK-NEXT:   "end": {
// CHECK-NEXT:    "offset": 1765,
// CHECK-NEXT:    "line": 125,
// CHECK-NEXT:    "col": 1,
// CHECK-NEXT:    "tokLen": 1
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "name": "DoesNotAllowConstDefaultInit",
// CHECK-NEXT:  "tagUsed": "struct",
// CHECK-NEXT:  "completeDefinition": true,
// CHECK-NEXT:  "definitionData": {
// CHECK-NEXT:   "canPassInRegisters": true,
// CHECK-NEXT:   "copyAssign": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "copyCtor": {
// CHECK-NEXT:    "hasConstParam": true,
// CHECK-NEXT:    "implicitHasConstParam": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "defaultCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "dtor": {
// CHECK-NEXT:    "irrelevant": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "isAggregate": true,
// CHECK-NEXT:   "isLiteral": true,
// CHECK-NEXT:   "isPOD": true,
// CHECK-NEXT:   "isStandardLayout": true,
// CHECK-NEXT:   "isTrivial": true,
// CHECK-NEXT:   "isTriviallyCopyable": true,
// CHECK-NEXT:   "moveAssign": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   },
// CHECK-NEXT:   "moveCtor": {
// CHECK-NEXT:    "exists": true,
// CHECK-NEXT:    "needsImplicit": true,
// CHECK-NEXT:    "simple": true,
// CHECK-NEXT:    "trivial": true
// CHECK-NEXT:   }
// CHECK-NEXT:  },
// CHECK-NEXT:  "inner": [
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "CXXRecordDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1725,
// CHECK-NEXT:     "line": 123,
// CHECK-NEXT:     "col": 8,
// CHECK-NEXT:     "tokLen": 28
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1718,
// CHECK-NEXT:      "col": 1,
// CHECK-NEXT:      "tokLen": 6
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1725,
// CHECK-NEXT:      "col": 8,
// CHECK-NEXT:      "tokLen": 28
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "isImplicit": true,
// CHECK-NEXT:    "name": "DoesNotAllowConstDefaultInit",
// CHECK-NEXT:    "tagUsed": "struct"
// CHECK-NEXT:   },
// CHECK-NEXT:   {
// CHECK-NEXT:    "id": "0x{{.*}}",
// CHECK-NEXT:    "kind": "FieldDecl",
// CHECK-NEXT:    "loc": {
// CHECK-NEXT:     "offset": 1762,
// CHECK-NEXT:     "line": 124,
// CHECK-NEXT:     "col": 7,
// CHECK-NEXT:     "tokLen": 1
// CHECK-NEXT:    },
// CHECK-NEXT:    "range": {
// CHECK-NEXT:     "begin": {
// CHECK-NEXT:      "offset": 1758,
// CHECK-NEXT:      "col": 3,
// CHECK-NEXT:      "tokLen": 3
// CHECK-NEXT:     },
// CHECK-NEXT:     "end": {
// CHECK-NEXT:      "offset": 1762,
// CHECK-NEXT:      "col": 7,
// CHECK-NEXT:      "tokLen": 1
// CHECK-NEXT:     }
// CHECK-NEXT:    },
// CHECK-NEXT:    "name": "i",
// CHECK-NEXT:    "type": {
// CHECK-NEXT:     "qualType": "int"
// CHECK-NEXT:    }
// CHECK-NEXT:   }
// CHECK-NEXT:  ]
// CHECK-NEXT: }
