#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Adventures of Wolf and Hood - A Jigsaw Tale
# send your bug reports to contact@dotslashplay.it
###

script_version=20241108.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='the-adventures-of-wolf-and-hood-a-jigsaw-tale'
GAME_NAME='The Adventures of Wolf and Hood - A Jigsaw Tale'

ARCHIVE_BASE_0_NAME='the-adventures-of-wolf-and-hood-a-jigsaw-tale-for-linux.zip'
ARCHIVE_BASE_0_MD5='a85bc8da1c3e313fdfe9e920754d982f'
ARCHIVE_BASE_0_SIZE='457093'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_URL='https://stone-baked-games.itch.io/the-adventures-of-wolf-and-hood-a-jigsaw-tale'

UNITY3D_NAME='Wolf and Hood - a Jigsaw Tale'
## TODO: Check if the Steam library is required
UNITY3D_PLUGINS='
libsteam_api.so'

CONTENT_PATH_DEFAULT='.'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
