!{\src2tex{textfont=tt}}
!!****f* ABINIT/rhohxc
!! NAME
!! rhohxc
!!
!! FUNCTION
!! Start from the density (nsppol=1), the spin-density (nsppol=2),
!! or the spin-density matrix (nsppol==4), and
!! compute Hartree (if option>=1) and xc correlation potential and energies.
!! Eventually compute xc kernel (if option=2 or =-2).
!! Actually, directly call rhohxc_coll if nsppol=1 or 2, and find
!! magnetisation direction if nsppol=4, and call rhohxc_coll with
!! the corresponding collinear density.
!! Use an approximation, in this respect : the magnitude of the
!! magnetisation is assigned to the spin up density. This has no
!! effect on the LDA, but the GGAs might be affected.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR, MF, GZ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=all input variables in this dataset
!!   | intxc=0 for old quadrature; 1 for new improved quadrature
!!   | ixc= choice of exchange-correlation scheme
!!  gsqcut=cutoff value on G**2 for sphere inside fft box.
!! (gsqcut=(boxcut**2)*ecut/(2.d0*(Pi**2))
!!  izero=if 1, unbalanced components of Vhartree(g) have to be set to zero
!!  mpi_enreg=informations about MPI parallelization
!!  nfft=(effective) number of FFT grid points (for this processor)
!!  ngfft(18)=contain all needed information about 3D FFT, see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  nhat(nfft,nspden*nhatdim)= -PAW only- compensation density
!!  nhatdim= -PAW only- 0 if nhat array is not used ; 1 otherwise
!!  nhatgr(nfft,nspden,3*nhatgrdim)= -PAW only- cartesian gradients of compensation density
!!  nhatgrdim= -PAW only- 0 if nhatgr array is not used ; 1 otherwise
!!  nkxc=second dimension of the kxc array. If /=0,
!!   the exchange-correlation kernel must be computed.
!!  nspden=number of spin-density components
!!  n3xccc=dimension of the xccc3d array (0 or nfft or cplx*nfft).
!!  option=0 for xc only (exc, vxc, strsxc),
!!         1 for Hxc (idem + vhartr) ,
!!         2 for Hxc and kxc (no paramagnetic part if nspden=1)
!!         3 for Hxc, kxc and k3xc
!!        -1 return (no xc terms for positron)
!!        -2 for Hxc and kxc (with paramagnetic part if nspden=1)
!!  rhog(2,nfft)=electron density in G space
!!  rhor(nfft,nspden)=electron density in real space in electrons/bohr**3
!!   (total in first half and spin-up in second half if nspden=2)
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  usexcnhat= -PAW only- 1 if nhat density has to be taken into account in Vxc
!!  xccc3d(n3xccc)=3D core electron density for XC core correction (bohr^-3)
!!
!! OUTPUT
!!  enxc=returned exchange and correlation energy (hartree).
!!
!!  k3xc(nfft)=third derivative of the XC energy functional of the density,
!!    at each point of the real space grid (only in the LDA,
!!    non-spin-polarized)
!!
!!  kxc(nfft,nkxc)=exchange and correlation kernel
!!     (returned only if nkxc/=0 and abs(option)=2 )
!!   allowed if LDAs ixc=0...9 :
!!    if nspden==1 and option==2 : return kxc(:,1)= d2Exc/drho2
!!       that is 1/2 ( d2Exc/drho_up drho_up + d2Exc/drho_up drho_dn )
!!    if nspden==1 and option=-2 : also return kxc(:,2)= d2Exc/drho_up drho_dn
!!    if nspden==2, return  kxc(:,1)=d2Exc/drho_up drho_up
!!                          kxc(:,2)=d2Exc/drho_up drho_dn
!!                          kxc(:,3)=d2Exc/drho_dn drho_dn
!!   allowed also if GGAs ixc=11, 12, 14, and 15
!!    for the time being, treat all cases as spin-polarized, with nkxc=23
!!    kxc(:,1)= d2Ex/drho_up drho_up
!!    kxc(:,2)= d2Ex/drho_dn drho_dn
!!    kxc(:,3)= dEx/d(abs(grad(rho_up))) / abs(grad(rho_up))
!!    kxc(:,4)= dEx/d(abs(grad(rho_dn))) / abs(grad(rho_dn))
!!    kxc(:,5)= d2Ex/d(abs(grad(rho_up))) drho_up / abs(grad(rho_up))
!!    kxc(:,6)= d2Ex/d(abs(grad(rho_dn))) drho_dn / abs(grad(rho_dn))
!!    kxc(:,7)= 1/abs(grad(rho_up)) * d/drho_up (dEx/d(abs(grad(rho_up))) /abs(grad(rho_up)))
!!    kxc(:,8)= 1/abs(grad(rho_dn)) * d/drho_dn (dEx/d(abs(grad(rho_dn))) /abs(grad(rho_dn)))
!!    kxc(:,9)= d2Ec/drho_up drho_up
!!    kxc(:,10)=d2Ec/drho_up drho_dn
!!    kxc(:,11)=d2Ec/drho_dn drho_dn
!!    kxc(:,12)=dEc/d(abs(grad(rho))) / abs(grad(rho))
!!    kxc(:,13)=d2Ec/d(abs(grad(rho))) drho_up / abs(grad(rho))
!!    kxc(:,14)=d2Ec/d(abs(grad(rho))) drho_dn / abs(grad(rho))
!!    kxc(:,15)=1/abs(grad(rho)) * d/drho (dEc/d(abs(grad(rho))) /abs(grad(rho)))
!!    kxc(:,16)=rho_up
!!    kxc(:,17)=rho_dn
!!    kxc(:,18)=gradx(rho_up)
!!    kxc(:,19)=gradx(rho_dn)
!!    kxc(:,20)=grady(rho_up)
!!    kxc(:,21)=grady(rho_dn)
!!    kxc(:,22)=gradz(rho_up)
!!    kxc(:,23)=gradz(rho_dn)
!!
!!  strsxc(6)= contribution of xc to stress tensor (hartree/bohr^3),
!!   given in order (1,1), (2,2), (3,3), (3,2), (3,1), (2,1).
!!   Explicitely : strsxc(mu,nu) = (1/N) Sum(i=1,N)
!!    ( delta(mu,nu) * [  exc(i)rhotot(i)
!!               - drhoexc_drho(up,i)*rhor(up,i)-drhoexc_drho(dn,i)*rhor(dn,i)]
!!     - gradrho(up,mu)*gradrho(up,nu) * drhoexc_dgradrho(up,i) / gradrho(up,i)
!!     - gradrho(dn,mu)*gradrho(dn,nu) * drhoexc_dgradrho(dn,i) / gradrho(dn,i) )
!!  vhartr(nfft)=Hartree potential (returned if option/=0)
!!  vxc(nfft,nspden)=xc potential (spin up in first half and spin down in
!!   second half if nspden=2)
!!  (if nspden=4, vxc(1:4)=vxc11,vxc22,Re(Vxc12),Im(Vxc12),1 and 2 refers to up and down)
!!  vxcavg=<Vxc>=unit cell average of Vxc = (1/ucvol) Int [Vxc(r) d^3 r].
!!
!! NOTES
!! * See rhohxc_coll for the explanation of ixc values.
!! * Because rhohxc uses optional arguments, an interface to it
!!  has been defined in the defs_xc module, and is used by the parent
!!  routines.
!!
!! PARENTS
!!      afterscfloop,cvxclda,energy,kxc_alda,nonlinear,outscfcv,prcref,respfn
!!      rhotov,setvtr
!!
!! CHILDREN
!!      leave_new,rhohxc_coll,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine rhohxc(dtset,enxc,gsqcut,izero,kxc,mpi_enreg,nfft,ngfft,&
& nhat,nhatdim,nhatgr,nhatgrdim,nkxc,nspden,n3xccc,option,rhog,rhor,rprimd,strsxc,&
& usexcnhat,vhartr,vxc,vxcavg,xccc3d,k3xc)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_13xc, except_this_one => rhohxc
#else
 use defs_xc, except_this_one => rhohxc
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: izero,n3xccc,nfft,nhatdim,nhatgrdim,nkxc,nspden,option
 integer,intent(in) :: usexcnhat
 real(dp),intent(in) :: gsqcut
 real(dp),intent(out) :: enxc,vxcavg
 type(MPI_type),intent(inout) :: mpi_enreg
 type(dataset_type),intent(in) :: dtset
!arrays
 integer,intent(in) :: ngfft(18)
 real(dp),intent(in) :: nhat(nfft,nspden*nhatdim)
 real(dp),intent(in) :: nhatgr(nfft,nspden,3*nhatgrdim),rhog(2,nfft)
 real(dp),intent(in) :: rhor(nfft,nspden),rprimd(3,3),xccc3d(n3xccc)
 real(dp),intent(out) :: kxc(nfft,nkxc),strsxc(6),vhartr(nfft),vxc(nfft,nspden)
 real(dp),intent(out),optional :: k3xc(1:nfft)

!Local variables-------------------------------
!scalars
 integer :: ifft,nspden_diag
 real(dp) :: dvdn,dvdz,factor
 character(len=500) :: message
!arrays
 real(dp),allocatable :: m_norm(:),rhor_diag(:,:),vxc_diag(:,:)

!Interfaces------------------------------------
! interface
!subroutine rhohxc_coll(enxc,gsqcut,intxc,ixc,izero,kxc,mpi_enreg,nfft,ngfft,&
!&   nhat,nhatdim,nhatgr,nhatgrdim,nkxc,nspden,n3xccc,option,rhog,rhor,rprimd, &
!&   strsxc,usexcnhat,vhartr,vxc,vxcavg,xccc3d,k3xc)
!   use defs_basis
!   use defs_datatypes
!   integer :: intxc,ixc,izero,nfft,nhatdim,nhatgrdim,nkxc,nspden,n3xccc,option,usexcnhat
!   integer :: ngfft(18)
!   real(dp) :: enxc,gsqcut,vxcavg
!   real(dp) :: kxc(nfft,nkxc),nhat(nfft,nspden*nhatdim),nhatgr(nfft,nspden,3*nhatgrdim),&
!&   rhog(2,nfft),rhor(nfft,nspden),&
!&   rprimd(3,3),strsxc(6),vhartr(nfft),vxc(nfft,nspden),xccc3d(n3xccc)
!   real(dp), intent(out), optional::k3xc(1:nfft)
! type(MPI_type) :: mpi_enreg
!end subroutine rhohxc_coll
! end interface

! *************************************************************************

! DEBUG
! write(6,*)' rhohxc : enter with option, nspden ',option,nspden
! ENDDEBUG

 if(nspden/=1 .and. nspden/=2 .and. nspden/=4)then
  write(message, '(a,a,a,a,a,a,i5)' ) ch10,&
&  ' rhohxc :  BUG -',ch10,&
&  '  The only allowed values of nspden are 1, 2, or 4,',ch10,&
&  '  while the argument nspden=',nspden
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 if ((option==3).and.(dtset%ixc/=7).and.(dtset%ixc/=3)) then
  write(message, '(a,a,a,a,a,a,i5)' ) ch10,&
&  ' rhohxc :  ERROR -',ch10,&
&  '  Third-order xc kernel can only be computed for ixc = 3 or ixc =7,',ch10,&
&  '  while it is found to be',dtset%ixc
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if


 if(nspden==4 .and. abs(option)==2)then
  write(message, '(6a)' ) ch10,&
&  ' rhohxc :  BUG -',ch10,&
&  '  When nspden==4, the absolute value of option cannot be 2 ',ch10,&
&  '  that is, no computation of XC kernel yet.'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

 if(option/=-1) then

  if(nspden /= 4) then

   if (option == 3) then

    call rhohxc_coll(dtset, enxc,gsqcut,izero,kxc,mpi_enreg,nfft,ngfft,&
&    nhat,nhatdim,nhatgr,nhatgrdim,nkxc,nspden,n3xccc,option,rhog,rhor,rprimd,&
&    strsxc,usexcnhat,vhartr,vxc,vxcavg,xccc3d,k3xc=k3xc)

   else
    call rhohxc_coll(dtset, enxc,gsqcut,izero,kxc,mpi_enreg,nfft,ngfft,&
&    nhat,nhatdim,nhatgr,nhatgrdim,nkxc,nspden,n3xccc,option,rhog,rhor,rprimd,&
&    strsxc,usexcnhat,vhartr,vxc,vxcavg,xccc3d)

   end if

  else if(nspden==4) then

   nspden_diag=2
   allocate(rhor_diag(nfft,nspden_diag),vxc_diag(nfft,nspden_diag))
   allocate(m_norm(nfft))

!$OMP PARALLEL DO PRIVATE(ifft) &
!$OMP&SHARED(nfft,rhor_diag,rhor,m_norm)
   do ifft=1,nfft
    rhor_diag(ifft,1)=rhor(ifft,1)
    m_norm(ifft)=sqrt(rhor(ifft,2)**2+rhor(ifft,3)**2+rhor(ifft,4)**2)
    rhor_diag(ifft,2)=(rhor_diag(ifft,1)+m_norm(ifft))*half
   end do
!$OMP END PARALLEL DO

   call rhohxc_coll(dtset, enxc,gsqcut,izero,kxc,mpi_enreg,nfft,ngfft,&
&   nhat,nhatdim,nhatgr,nhatgrdim,nkxc,nspden_diag,n3xccc,option,rhog,rhor_diag,rprimd,&
&   strsxc,usexcnhat,vhartr,vxc_diag,vxcavg,xccc3d)

!$OMP PARALLEL DO PRIVATE(dvdn,dvdz,ifft) &
!$OMP&SHARED(nfft,vxc,vxc_diag,m_norm)
   do ifft=1,nfft
    dvdn=(vxc_diag(ifft,1)+vxc_diag(ifft,2))*half
    dvdz=(vxc_diag(ifft,1)-vxc_diag(ifft,2))*half
    if(m_norm(ifft)>rhor(ifft,1)*tol10+tol14)then
     factor=dvdz/m_norm(ifft)
    else
     factor=zero
    end if
    vxc(ifft,1)=dvdn+rhor(ifft,4)*factor
    vxc(ifft,2)=dvdn-rhor(ifft,4)*factor
    vxc(ifft,3)= rhor(ifft,2)*factor
    vxc(ifft,4)=-rhor(ifft,3)*factor
   end do
!$OMP END PARALLEL DO

!DEBUG
!  write(6,*)'rhor',rhor(1,:)
!  write(6,*)'rhordiag',rhor_diag(1,:)
!  write(6,*)' vxc',vxc(1,:)
!  write(6,*)' vxcdiag',vxc_diag(1,1),vxc_diag(1,2)
!  stop
!ENDDEBUG

   deallocate(rhor_diag,vxc_diag,m_norm)

  end if

 else ! option=-1

  enxc=zero
  vxc(:,:)=zero
  vxcavg=zero
  strsxc(:)=zero

 end if

end subroutine rhohxc
!!***
