!{\src2tex{textfont=tt}}
!!****p* ABINIT/anascr
!! NAME
!! anascr
!!
!! FUNCTION
!!  Tool for analysis the inverse dielectric matrix stored in 
!!  the SCR file. It can be used to:
!!  a) Analyse selected columns of $\epsilon^{-1}_{G Gp}(q,\w)$ for a fixed 
!!     q point and $\w$
!!  b) Analyse the frequency dependency of $\epsilon^{-1}_{G Gp}(q,\w)$ for a
!!     fixed q point and (G,Gp) pair 
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2007 ABINIT group (MG)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  Main program 
!!
!! OUTPUT
!!  Write on an external  file  
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!      hdr_clean,hdr_io,hdr_io_netcdf,herald,int2char4,leave_new,memerr,wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

program anascr

 use defs_basis
 use defs_datatypes
 use defs_infos

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_11util
 use interfaces_13io_mpi
 use interfaces_14iowfdenpot
 use interfaces_15gw
#else
 use defs_interfaces
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------

!Local variables-------------------------------
!scalars
 integer,parameter :: unitem1=111,unt=211
 integer :: fform,ic,ig,igp,ig1a,ig2a,ii,io,ios,iprompt,iq,iqa,istat,itask,iwa,nbnds,ncol,nomega,npwvec
 integer :: npwwfn,nq,nqa,rdwr,readnetcdf,step
 logical :: filexist
 character(len=4) :: tagq,tagw
 character(len=24) :: codename
 character(len=500) :: message
 character(len=fnlen) :: filem1,fname,fname_default
 type(hdr_type) :: hdr
!arrays
 integer,allocatable :: gvec(:,:)
 real(dp),allocatable :: q(:,:)
 complex(dpc),allocatable :: epsm1(:,:),omega(:)
 character(len=80) :: titem1(2)

! *************************************************************************
 
!DEBUG
!write(std_out,*)' anascr : enter '
!ENDDEBUG

 codename='ANASCR'//repeat(' ',18)
 call herald(codename,abinit_version,std_out)

 do   
  write(message,'(a)')' Enter name of screening file: '
  call wrtout(6,message,'COLL')
  read(*,*)filem1
  filem1=trim(filem1)

!Checking the existence of data file
  inquire(file=filem1,exist=filexist)
  if (.not. filexist) then
   write(message,'(4a)')ch10,&
&  ' ERROR-  missing data file: ',trim(filem1),ch10
   call wrtout(6,message,'COLL')
   cycle
   !call leave_new('COLL')
  end if
  open(file=filem1,unit=unitem1,status='old',form='unformatted',iostat=ios)
  if (ios/=0) then 
   write(message,'(4a)')ch10,&
&   ' ERROR- opening file ',trim(filem1),ch10
   call wrtout(6,message,'COLL')
   cycle
   !call leave_new('COLL')
  end if
  exit
 end do

!Read the header of the file
 rdwr=1
 readnetcdf = 0 !should make EM1 a netcdf file as well
 if (readnetcdf == 0) then
  call hdr_io(fform,hdr,rdwr,unitem1)
 else if (readnetcdf == 1) then
  call hdr_io_netcdf(fform,hdr,rdwr,unitem1)
 end if

 if(fform/=1002) then
  write(message,'(3a)')ch10,&
&  'ERROR- Unknown file format found ',ch10
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if 

!Echo part of the header
 rdwr=4 
 call hdr_io(fform,hdr,rdwr,6)

 read(unitem1)titem1
 write(message,'(2a,1x,5a)')ch10,ch10,titem1(1),ch10,titem1(2),ch10,ch10
 call wrtout(6,message,'COLL')

 read(unitem1)npwvec,npwwfn,nbnds,nq,nomega

 write(message,'(a,i8)')' Number of G vectors in epsilon^-1     ',npwvec
  call wrtout(6,message,'COLL')
 write(message,'(a,i8)')' Number of G vectors for wavefunctions ',npwwfn
  call wrtout(6,message,'COLL')
 write(message,'(a,i8)')' Number of bands                       ',nbnds
  call wrtout(6,message,'COLL')
 write(message,'(a,i8)')' Number of q-points                    ',nq
  call wrtout(6,message,'COLL')
 write(message,'(a,i8,2a)')' Number of evaluated frequencies       ',nomega,ch10,ch10
  call wrtout(6,message,'COLL')
 
 allocate(gvec(3,npwvec))
 read(unitem1)gvec(1:3,1:npwvec)

 write(message,'(3a)')ch10,' G vectors in epsilon^-1 and corresponding indexes:',ch10
 call wrtout(6,message,'COLL')
 do ig=1,npwvec
  write(*,'(3(1x,i5,a,3x,a,3(i5,2x),a))',advance='no')ig,'*','(',gvec(:,ig),')'
  if (mod(ig,3)==0)write(*,*) 
 end do

 allocate (q(3,nq))
 read(unitem1) q(1:3,1:nq)

 allocate (omega(1:nomega))
 read(unitem1) omega(1:nomega)

 write(*,'(/,a,/,(i3,3f14.6))')&
& ' q-points [reciprocal lattice units]:',(iq,(q(ii,iq),ii=1,3),iq=1,nq)
  !call wrtout(6,message,'COLL')
 write(*,'(/,a,/,(i3,2f7.2))')&
& ' frequencies omega [eV]:',(io,omega(io)*Ha_eV,io=1,nomega)
  !call wrtout(6,message,'COLL')

 call hdr_clean(hdr)
!------------------------------------------------------------------------

 do 

  write(message,'(2a)')ch10,' What is your choice? Type:'
   call wrtout(6,message,'COLL')
  write(message,'(a)')'  0 => exit'
   call wrtout(6,message,'COLL')
  write(message,'(a)')'  1 => q-point    (analyze epsilon^-1 in a single q-point)'
   call wrtout(6,message,'COLL')
  write(message,'(a)')'  2 => frequency  (analyze frequency dependency of epsilon^-1)'
   call wrtout(6,message,'COLL')

  read(*,*) itask
  select case(itask)

  case(1) !single q-point analysis

   !call skip_hdr_scr(unitem1,readnetcdf) 

   !Re-Read the header of the file
   rewind(unitem1)
   rdwr=1
   !should make EM1 a netcdf file as well
   call hdr_io(fform,hdr,rdwr,unitem1)
   call hdr_clean(hdr)
   
   read(unitem1) !skip titem1
   read(unitem1) npwvec,npwwfn,nbnds,nq,nomega
   read(unitem1) !skip gvec
   read(unitem1) !skip q
   read(unitem1) !skip omega

   do 
    write(message,'(2a)')ch10,' Enter index of the required q-point' 
    call wrtout(6,message,'COLL')
    read(*,*)iqa
    if (iqa > nq .or. iqa<=0) then 
     write(message,'(2a)')ch10,' Wrong value for q-point index'
     call wrtout(6,message,'COLL')
     cycle
    else 
     exit
    end if 
   end do 

   do 
    write(message,'(2a)')ch10,' Enter index of the required frequency' 
    call wrtout(6,message,'COLL')
    read(*,*)iwa
    if (iwa > nomega .or. iwa<=0) then
     write(message,'(2a)')ch10,' Wrong values for frequency index'
     call wrtout(6,message,'COLL')
     cycle
    else 
     exit
    end if 
   end do 

   call int2char4(iqa,tagq)
   call int2char4(iwa,tagw)
   fname_default=trim(filem1)//'_em1_Q'//tagq//'_w'//tagw
   fname=trim(fname_default)

   do 
    inquire(file=fname,exist=filexist)
    if (filexist) then
     write(message,'(6a)')ch10,&
&     ' file: ',trim(fname),' already exists! ',ch10,&
&     ' overwrite? (0=default=no, 1=yes)'
     call wrtout(6,message,'COLL')
     read(*,*)iprompt 
     if (iprompt==1) exit 
     write(message,'(2a)')ch10,'  Enter the name of a new output file: '
     call wrtout(06,message,'COLL')
     read(*,*) fname
    else 
     exit 
    end if                                                 
   end do 

   open(unit=unt,file=fname,status='unknown',iostat=ios)
    if (ios/=0) then 
     write(message,'(4a)')ch10,&
&     ' ERROR- opening file ',trim(fname),ch10
      call wrtout(6,message,'COLL')
      call leave_new('COLL')
    end if

   do  
    write(message,'(2a,i8,a)')ch10,' Enter step for G  [ Max = ',npwvec,' ]'
    call wrtout(06,message,'COLL')
    read(*,*)step
    if(step<=0 .or. step > npwvec) then 
     write(message,'(2a)')ch10,' Wrong values for G index'
     call wrtout(6,message,'COLL')
     cycle
    end if 
    ncol=int(npwvec/step)+1
    exit
   end do 
   
   write(message,'(a,i3,a)')' Writing ',ncol,' columns '
   call wrtout(6,message,'COLL')
   !write(*,'(1x,i4)')(ic,ic=1,npwvec,step)
  
   !write info on the output file
   write(unt,'(2a,/,a,i5)')&
&   '# epsilon^-1 matrix read from file : ',trim(filem1),&
&   '# Number of G vectors : ',npwvec
   if (ncol>1) then 
    write(unt,'(a)')'# Norm of diagonal elements and selected columns '
    write(unt,'(a)',advance='no')'# Row   Diagonal'  
    do ic=1,npwvec,step
     write(unt,'(i8,2x)',advance='no')ic
    end do
    write(unt,'(/)')
   else
    write(unt,'(a)')'# Norm of diagonal elements'
    write(unt,'(a,/)')'# Row   Diagonal'  
   end if

   allocate(epsm1(npwvec,npwvec),stat=istat)
   if(istat/=0) then
    call memerr('anascr','epsm1',npwvec**2,'dpc')
   end if
    
   !read epsilon^-1
   do iq=1,nq
    do io=1,nomega
     read(unitem1) epsm1(1:npwvec,1:npwvec)
     !find required q-points and frequency 
     if (iq==iqa .and. io==iwa) then
      do ig=1,npwvec
       !modulus of diagonal elements 
       write(unt,'(1x,i4,2x,f8.5)',advance='no')ig,(abs(epsm1(ig,ig)))
       do ic=1,npwvec,step
        write(unt,'(2x,f8.5)',advance='no')(abs(epsm1(ig,ic)))
       end do
       write(unt,*)
      end do
     end if
    end do
   end do 
   
   deallocate(epsm1)
   close(unt)   

  case(2) 

   !call skip_hdr_scr(unitem1,readnetcdf) 

   !Re-Read the header of the file
   rewind(unitem1)
   rdwr=1
   !should make EM1 a netcdf file as well
   call hdr_io(fform,hdr,rdwr,unitem1)
    
   call hdr_clean(hdr)
   
   read(unitem1) !skip titem1
   read(unitem1) npwvec,npwwfn,nbnds,nq,nomega
   read(unitem1) !skip gvec
   read(unitem1) !skip q
   read(unitem1) !skip omega

   do 
    write(message,'(2a)')ch10,'  Enter (G, G'') index' 
    call wrtout(6,message,'COLL')
    read(*,*)ig1a,ig2a
    if ( (ig1a > npwvec .or. ig1a <= 0) .or.      &
&        (ig2a > npwvec .or. ig2a <= 0)     ) then 
     write(message,'(3a)')ch10,'  Wrong value for G index',ch10
     call wrtout(6,message,'COLL')
     cycle
    else 
     write(message,'(4a,2(1x,i5,a,3i5,2a))')ch10,&
&     '  Analyzing em1 at ',ch10,ch10, &
&     ig1a,'* (',gvec(:,ig1a),')',ch10,&
&     ig2a,'* (',gvec(:,ig2a),')',ch10
     call wrtout(6,message,'COLL')
     exit
    end if 
   end do 

   do 
    write(message,'(a)')'  Enter index of the required q-point'
    call wrtout(6,message,'COLL')
    read(*,*)iqa
    if (iqa > nq .or. iqa<=0) then 
     write(message,'(3a)')ch10,'  Wrong value for q-point index',ch10
     call wrtout(6,message,'COLL')
     cycle
    else 
     exit
    end if 
   end do 

   allocate(epsm1(npwvec,npwvec),stat=istat)
   if(istat/=0) then
    call memerr('anascr','epsm1',npwvec**2,'dpc')
   end if
   
   write(*,'(1x,a,4x,a,/)')'     omega [eV]     ','    Re        Im   '
   !read epsilon^-1
   !find required G-G\prime pair 
   do iq=1,nq
    do io=1,nomega
     read(unitem1) epsm1(1:npwvec,1:npwvec)
     if (iq==iqa) then
       !note ev units
       write(*,'(1x,2(f8.5,2x),4x,2(f8.5,2x))')&
&       Ha_ev*omega(io),real(epsm1(ig1a,ig2a)),aimag(epsm1(ig1a,ig2a))
     end if
    end do
   end do 

   deallocate(epsm1)

   case(0)
    write(message,'(2a)')ch10,' Exit requested by user'
    call wrtout(6,message,'COLL')
    exit

   case default
    cycle

  end select
 end do

 write(message,'(5a)')ch10,' Analysis completed',ch10,&
&                          ' Thank you for using me',ch10
 call wrtout(6,message,'COLL')                                                                  

 close(unitem1)
 deallocate(omega)
 stop 
 end program anascr
