/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 19:49:16 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class EmblStreamFeature_ESTest extends EmblStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      // Undeclared exception!
      try { 
        EmblStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = null;
      try {
        emblStreamFeature0 = new EmblStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PublicDBStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      Key key0 = mock(Key.class, new ViolatedAssumptionAnswer());
      Location location0 = mock(Location.class, new ViolatedAssumptionAnswer());
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature(key0, location0, (QualifierVector) null);
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      EmblStreamFeature emblStreamFeature1 = new EmblStreamFeature(emblStreamFeature0);
      assertFalse(emblStreamFeature1.equals((Object)emblStreamFeature0));
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = mock(LinePushBackReader.class, new ViolatedAssumptionAnswer());
      doReturn((String) null).when(linePushBackReader0).readLine();
      EmblStreamFeature emblStreamFeature0 = EmblStreamFeature.readFromStream(linePushBackReader0);
      assertNull(emblStreamFeature0);
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      Feature feature0 = emblStreamFeature0.copy();
      assertNotSame(feature0, emblStreamFeature0);
  }
}
