/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.RuleBasedCollator;
import java.util.Comparator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.sort.SubstringMatcher;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class Contains
extends CollatingFunction {
    public static final int CONTAINS = 0;
    public static final int STARTSWITH = 1;
    public static final int ENDSWITH = 2;
    public static final int AFTER = 3;
    public static final int BEFORE = 4;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue;
        Comparator comparator = this.getCollator(2, xPathContext);
        AtomicValue atomicValue2 = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            atomicValue2 = StringValue.EMPTY_STRING;
        }
        if ((atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext)) == null) {
            atomicValue = StringValue.EMPTY_STRING;
        }
        String string = atomicValue2.getStringValue();
        String string2 = atomicValue.getStringValue();
        if (comparator instanceof RuleBasedCollator) {
            comparator = new RuleBasedSubstringMatcher((RuleBasedCollator)comparator);
        }
        if (comparator instanceof SubstringMatcher) {
            switch (this.operation) {
                case 0: {
                    return BooleanValue.get(((SubstringMatcher)comparator).contains(string, string2));
                }
                case 1: {
                    return BooleanValue.get(((SubstringMatcher)comparator).startsWith(string, string2));
                }
                case 2: {
                    return BooleanValue.get(((SubstringMatcher)comparator).endsWith(string, string2));
                }
                case 3: {
                    return StringValue.makeStringValue(((SubstringMatcher)comparator).substringAfter(string, string2));
                }
                case 4: {
                    return StringValue.makeStringValue(((SubstringMatcher)comparator).substringBefore(string, string2));
                }
            }
            throw new UnsupportedOperationException("Unknown operation " + this.operation);
        }
        this.dynamicError("The collation requested for " + this.getDisplayName(xPathContext.getNamePool()) + " does not support substring matching", "FOCH0004", xPathContext);
        return null;
    }
}

