﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System.Diagnostics.CodeAnalysis;
// No way to Marshal an array of SafeHandles to an array of IntPtrs for MsgWaitForMultipleObjects
[module: SuppressMessage("Microsoft.Reliability", "CA2001:AvoidCallingProblematicMethods", Scope = "member", Target = "MS.Internal.AutomationProxies.Misc.MsgWaitForMultipleObjects(Microsoft.Win32.SafeHandles.SafeWaitHandle,System.Boolean,System.Int32,System.Int32):System.Int32", MessageId = "System.Runtime.InteropServices.SafeHandle.DangerousGetHandle")]
// The rule doesn't apply to non-public namespaces
[module: SuppressMessage("Microsoft.MSInternal", "CA904:DeclareTypesInMicrosoftOrSystemNamespace", Scope="namespace", Target="MS.Win32")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="StringTable.resources", MessageId="Prt")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="StringTable.resources", MessageId="Scn")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="StringTable.resources", MessageId="Rq")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="StringTable.resources", MessageId="Lk")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="StringTable.resources", MessageId="Scr")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope = "member", Target = "MS.Internal.AutomationProxies.EventManager._hwndLast")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.ProxyHwnd._controlLabel")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.MSAAWinEventWrap+WinEvent._hwnd")]
// The rule doesn't apply if the resource isn't owned by this code (these are mainly hwnds)
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.Accessible._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsTreeView+TreeViewItem._hItem")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.GroupManager._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsRebar+RebarBandItem._hwndBand")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WinEventTracker+EventCreateParams._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsMenu+MenuItem._hmenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsMenu+MenuItem+MSAAMENUINFO.pszWText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.GroupManager+Group._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsComboBox._hwndEx")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.ClickablePoint._hwndDesktop")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.ClickablePoint._hwndProgman")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.ProxySimple._hwndDesktop")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.ProxySimple._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.GroupManager+SortGroups._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.GroupManager+SortGroupItems._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsMenu._hmenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WinEventTracker+EventHookParams._winEventHook")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.WindowsMenu+MenuParentInfo._hwndParent")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Internal.AutomationProxies.MsaaNativeProvider._hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUITEMINFO.hbmpChecked")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUITEMINFO.hbmpItem")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUITEMINFO.dwItemData")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUITEMINFO.dwTypeData")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUITEMINFO.hSubMenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUITEMINFO.hbmpUnchecked")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TCITEM.pszText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TCITEM.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TOOLINFO.pszText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TOOLINFO.hinst")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TOOLINFO.hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TOOLINFO.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TVHITTESTINFO.hItem")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TVITEM.pszText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TVITEM.hItem")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TVITEM.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+LITEM.szURL")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+LITEM.szID")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVGROUP.pszHeader")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVGROUP.pszFooter")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+SYSTEM_INFO.dwActiveProcessorMask")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+SYSTEM_INFO.lpMinimumApplicationAddress")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+SYSTEM_INFO.lpMaximumApplicationAddress")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+REBARBANDINFO.hbmBack")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+REBARBANDINFO.hwndChild")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+REBARBANDINFO.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+REBARBANDINFO.lpText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+COMBOBOXINFO.hwndCombo")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+COMBOBOXINFO.hwndList")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+COMBOBOXINFO.hwndItem")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+KEYBDINPUT.dwExtraInfo")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+HDITEM.pszText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+HDITEM.hbm")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+HDITEM.pvFilter")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+HDITEM.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+GUITHREADINFO.hwndActive")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+GUITHREADINFO.hwndCapture")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+GUITHREADINFO.hwndFocus")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+GUITHREADINFO.hwndCaret")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+GUITHREADINFO.hwndMenuOwner")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+GUITHREADINFO.hwndMoveSize")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUBARINFO.hwndMenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MENUBARINFO.hMenu")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MSG.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MSG.wParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MSG.hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+NMHDR.hwndFrom")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+FORMATETC.ptd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+STGMEDIUM.pUnkForRelease")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+STGMEDIUM.hGlobal")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVITEM_V6.pszText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVITEM_V6.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVITEM_V6.puColumns")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+ENUMTOOLTIPWINDOWINFO.hwnd")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVITEM.pszText")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+LVITEM.lParam")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+MOUSEINPUT.dwExtraInfo")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.NativeMethods+TBBUTTON.iString")]
[module: SuppressMessage("Microsoft.Reliability", "CA2006:UseSafeHandleToEncapsulateNativeResources", Scope="member", Target="MS.Win32.UnsafeNativeMethods+ENUMCHILDWINDOWFROMRECT.hwnd")]
// The rule doesn't apply if the resource isn't owned by this code (these are mainly hwnds)
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.Accessible")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.GroupManager")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.ProxyHwnd")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.WindowsComboBox")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.WindowsMenu+MenuItem+MSAAMENUINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.WindowsRebar+RebarBandItem")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Internal.AutomationProxies.WinEventTracker+EventHookParams")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+MENUITEMINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+TCITEM")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+TOOLINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+TVHITTESTINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+TVITEM")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.UnsafeNativeMethods+LITEM")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+LVGROUP")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+SYSTEM_INFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+REBARBANDINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+COMBOBOXINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+KEYBDINPUT")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+HDITEM")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+GUITHREADINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+MENUBARINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+MSG")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+NMHDR")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.UnsafeNativeMethods+FORMATETC")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.UnsafeNativeMethods+STGMEDIUM")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+LVITEM_V6")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.UnsafeNativeMethods+ENUMTOOLTIPWINDOWINFO")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+LVITEM")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.UnsafeNativeMethods+ENUMCHILDWINDOWFROMRECT")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+MOUSEINPUT")]
[module: SuppressMessage("Microsoft.Design", "CA1049:TypesThatOwnNativeResourcesShouldBeDisposable", Scope="type", Target="MS.Win32.NativeMethods+TBBUTTON")]
// No threading issue here
[module: SuppressMessage( "Microsoft.Usage", "CA2211:NonConstantFieldsShouldNotBeVisible", Scope = "member", Target = "UIAutomationClientsideProviders.UIAutomationClientSideProviders.ClientSideProviderDescriptionTable" )]
// Spelling is correct for this usage
[module: SuppressMessage( "Microsoft.Naming", "CA1704:IdentifiersShouldBeSpelledCorrectly", Scope = "namespace", Target = "UIAutomationClientsideProviders" )]
// This is non-public code
[module: SuppressMessage( "Microsoft.MSInternal", "CA904:DeclareTypesInMicrosoftOrSystemNamespace", Scope = "namespace", Target = "UIAutomationClientsideProviders" )]
[module: SuppressMessage( "Microsoft.Naming", "CA1724:TypeNamesShouldNotMatchNamespaces", Scope = "type", Target = "UIAutomationClientsideProviders.UIAutomationClientSideProviders" )]
