'''OpenGL extension EXT.blend_color

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.blend_color to provide a more 
Python-friendly API

Overview (from the spec)
	
	Blending capability is extended by defining a constant color that can
	be included in blending equations.  A typical usage is blending two
	RGB images.  Without the constant blend factor, one image must have
	an alpha channel with each pixel set to the desired blend factor.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/blend_color.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.EXT.blend_color import *
from OpenGL.raw.GL.EXT.blend_color import _EXTENSION_NAME

def glInitBlendColorEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION