/*
 *  
 *  $Id: showhistorytool.cpp $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-14 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "imageprinttool.h"
#include <api/ivista.h>
#include <export/contracts/iimageexportcontract.h>
#include <main/gui/toolsystem/wxmenuitemtool.h>
#include <main/gui/print/printmanager.h>


#include <wx/cmndata.h>


//----------------------------------------------------------------------
namespace GNC {
	namespace GUI {
		class wxImagePrintEventHandler: public wxDefaultEvtHandlerTool
		{
		public:
			wxImagePrintEventHandler(wxEvtHandler* pParent, GNC::ImagePrintTool* pTool): wxDefaultEvtHandlerTool(pParent, pTool)
			{
				m_pImagePrint = pTool;
			}

			virtual ~wxImagePrintEventHandler()
			{
			}

			virtual void OnUpdateUI(wxUpdateUIEvent &event)
			{
				wxDefaultEvtHandlerTool::OnUpdateUI(event);
				if (event.GetEnabled()) {
					event.Enable(m_pImagePrint->IsEnabled());
				}
			}
			GNC::ImagePrintTool* m_pImagePrint;
		};

	}
}

GNC::GCS::ITool* GNC::ImagePrintTool::NewTool()
{
	return new GNC::ImagePrintTool(m_pPrintData);
}

GNC::ImagePrintTool::ImagePrintTool()
{
	m_pPrintData = new wxPrintData();
}

GNC::ImagePrintTool::ImagePrintTool(GNC::GCS::Ptr<wxPrintData>& pPrintData): m_pPrintData(pPrintData)
{
	if (!m_pPrintData.IsValid()) {
		m_pPrintData = new wxPrintData();
	}
}
GNC::ImagePrintTool::~ImagePrintTool()
{
}
		
bool GNC::ImagePrintTool::ExecuteAction()
{	
	#if defined(USE_PATCHED_LIBS)
	wxString title = wxString::FromUTF8(ExportContract->GetView()->GetTitulo().c_str());	
	GNC::GCS::Ptr<GNC::GCS::IImageExportDelegate> pDelegate(ExportContract->GetNewExportDelegate());
	GNC::GCS::Printing::DialogoImpresion* frame = new GNC::GCS::Printing::DialogoImpresion(ExportContract->GetView()->GetWindow(), pDelegate,title,m_pPrintData.GetRawPointer());
	if (ExportContract->GetView()->GetWindow() != NULL) {
		//set position relative to view window...
		wxPoint position = ExportContract->GetView()->GetWindow()->GetPosition();
		wxPoint screeenPosition = ExportContract->GetView()->GetWindow()->ClientToScreen(position);
		screeenPosition.x += 20;
		screeenPosition.y += 20;
		frame->SetPosition(screeenPosition);
	}
	frame->Show(true);
	#endif
	return true;
}

void GNC::ImagePrintTool::AppendToolIn(wxEvtHandler* pParent, wxMenu* pMenu)
{
	if (AppendsInMenu()) {
		GNC::GUI::wxImagePrintEventHandler* evtHandler = new GNC::GUI::wxImagePrintEventHandler(pParent, this);
		pMenu->Append(new GNC::GUI::wxMenuItemTool(pMenu, ID, wxString::FromUTF8(Name.c_str()),Icon, evtHandler));
	}
}

bool GNC::ImagePrintTool::IsEnabled()
{
	return ExportContract->CanBeExported();
}
