// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the description of a specific Amazon File Cache resource, if a
// FileCacheIds value is provided for that cache. Otherwise, it returns
// descriptions of all caches owned by your Amazon Web Services account in the
// Amazon Web Services Region of the endpoint that you're calling. When retrieving
// all cache descriptions, you can optionally specify the MaxResults parameter to
// limit the number of descriptions in a response. If more cache descriptions
// remain, the operation returns a NextToken value in the response. In this case,
// send a later request with the NextToken request parameter set to the value of
// NextToken from the last response. This operation is used in an iterative process
// to retrieve a list of your cache descriptions. DescribeFileCaches is called
// first without a NextToken value. Then the operation continues to be called with
// the NextToken parameter set to the value of the last NextToken value until a
// response has no NextToken . When using this operation, keep the following in
// mind:
//   - The implementation might return fewer than MaxResults cache descriptions
//     while still including a NextToken value.
//   - The order of caches returned in the response of one DescribeFileCaches call
//     and the order of caches returned across the responses of a multicall iteration
//     is unspecified.
func (c *Client) DescribeFileCaches(ctx context.Context, params *DescribeFileCachesInput, optFns ...func(*Options)) (*DescribeFileCachesOutput, error) {
	if params == nil {
		params = &DescribeFileCachesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFileCaches", params, optFns, c.addOperationDescribeFileCachesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFileCachesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFileCachesInput struct {

	// IDs of the caches whose descriptions you want to retrieve (String).
	FileCacheIds []string

	// The maximum number of resources to return in the response. This value must be
	// an integer greater than zero.
	MaxResults *int32

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing the
	// request, where the previous NextToken value left off.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeFileCachesOutput struct {

	// The response object for the DescribeFileCaches operation.
	FileCaches []types.FileCache

	// (Optional) Opaque pagination token returned from a previous operation (String).
	// If present, this token indicates from what point you can continue processing the
	// request, where the previous NextToken value left off.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFileCachesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFileCaches{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFileCaches{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFileCaches"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFileCaches(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeFileCachesAPIClient is a client that implements the DescribeFileCaches
// operation.
type DescribeFileCachesAPIClient interface {
	DescribeFileCaches(context.Context, *DescribeFileCachesInput, ...func(*Options)) (*DescribeFileCachesOutput, error)
}

var _ DescribeFileCachesAPIClient = (*Client)(nil)

// DescribeFileCachesPaginatorOptions is the paginator options for
// DescribeFileCaches
type DescribeFileCachesPaginatorOptions struct {
	// The maximum number of resources to return in the response. This value must be
	// an integer greater than zero.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeFileCachesPaginator is a paginator for DescribeFileCaches
type DescribeFileCachesPaginator struct {
	options   DescribeFileCachesPaginatorOptions
	client    DescribeFileCachesAPIClient
	params    *DescribeFileCachesInput
	nextToken *string
	firstPage bool
}

// NewDescribeFileCachesPaginator returns a new DescribeFileCachesPaginator
func NewDescribeFileCachesPaginator(client DescribeFileCachesAPIClient, params *DescribeFileCachesInput, optFns ...func(*DescribeFileCachesPaginatorOptions)) *DescribeFileCachesPaginator {
	if params == nil {
		params = &DescribeFileCachesInput{}
	}

	options := DescribeFileCachesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeFileCachesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeFileCachesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeFileCaches page.
func (p *DescribeFileCachesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeFileCachesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeFileCaches(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeFileCaches(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFileCaches",
	}
}
