/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains interfaces for BiMap API.
 * <p>
 *      A BiMap is a map that allows users to look up key-value pairs from either direction. Uniqueness is enforced on both the keys and values.
 * </p>
 * <p>
 *     This package contains 3 interfaces:
 * <ul>
 *     <li>
 *          {@link com.gs.collections.api.bimap.BiMap} - contains the common API for Mutable and Immutable BiMap.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.api.bimap.MutableBiMap} - a BiMap whose contents can be altered after initialization.
 *     </li>
 *     <li>
 *          {@link com.gs.collections.api.bimap.ImmutableBiMap} - a BiMap whose contents cannot be altered after initialization.
 *     </li>
 * </ul>
 * </p>
 */
package com.gs.collections.api.bimap;
