doc ///
	Key
	    getMultiplicationMatrix
	    (getMultiplicationMatrix, Ring, Thing)
	    (getMultiplicationMatrix, Ring, Ideal, Thing)
	Headline
	    Computes the matrix over a $k$-basis for multiplication by an element in a finite dimensional $k$-algebra
	Usage
		getMultiplicationMatrix(C,a)
		getMultiplicationMatrix(S,I,b)
	Inputs 
	    C: Ring
			a finite dimensional $k$-algebra
	    a: Thing
	        an element in @TT("C")@
	    S: Ring
	    	a polynomial ring
	    I: Ideal
	        an ideal in the polynomial ring @TT("S")@
	    b: Thing
	    	an element in @TT("S")@
	Outputs
	   : Matrix
	    	the matrix representation over a basis for multiplication by the given element
	Description
		Text
	  		For an algebra @TT("C")@ over a field $k$ or a polynomial ring @TT("S")@ and an ideal @TT("I")@, this function generates a matrix with entries in $k$ representing multiplication by the user-prescribed element in @TT("C")@ or @TT("S/I")@ respectively.

			We compute the multiplication matrix of the element @TT("1+a*b+b*c+c*a")@ in the algebra @TT("L[a,b,c]/(a^2,b^2,c^2)")@, where @TT("L")@ is the cyclotomic extension $\mathbb{Q}(\zeta_{7})$ represented as the quotient of the polynomial ring $\mathbb{Q}[x]$ by the ideal generated by the polynomial $x^6+x^5+x^4+x^3+x^2+x+1$. The multiplication matrix is computed over @TT("L")@ with respect to the basis $\{1,a,b,c\}$.
		Example 
			L = QQ[x]/(x^6+x^5+x^4+x^3+x^2+x+1);
			F = toField L;
			getMultiplicationMatrix(F[a,b,c], ideal(a^2,b^2,c^2),1+a*b+b*c+c*a)
		Text
	 		Alternatively for a $k$-algebra @TT("C")@, we can compute the multiplication matrix of an element @TT("b")@ with respect to a basis of @TT("C")@. 
		Example
			R = QQ[x,y]/(x^2+y^2+1, 3*x+2);
			getMultiplicationMatrix(R, 1+y*x^2)
	SeeAlso
	    getTrace
	    getNorm
///

doc ///
	Key
		getTrace
		(getTrace, Ring, Thing)
		(getTrace, Ring, Ideal, Thing)  
	Headline
		Computes the trace over $k$ for an element in a finite dimensional $k$ -algebra 
	Usage
		getTrace(C,a)
		getTrace(S,I,b)
	Inputs 
	    C: Ring
			a finite dimensional $k$-algebra
	    a: Thing
	        an element in @TT("C")@
	    S: Ring
	    	a polynomial ring
	    I: Ideal
	        an ideal in the polynomial ring @TT("S")@
	    b: Thing
	    	an element in @TT("S")@   
	Outputs 
	   : RingElement
	        the trace over $k$ for an element in the algebra
	Description
	    Text
	    	For an element in an algebra @TT("C")@ over a field $k$ or a polynomial ring @TT("S")@ and an ideal @TT("I")@, this function computes the trace over $k$ as the trace of the @TO2(getMultiplicationMatrix, "getMultiplicationMatrix")@ of the element. 
	    Example 
			L = QQ[x]/(x^6+x^5+x^4+x^3+x^2+x+1);
			F = toField L;
			getTrace(F[a,b,c], ideal(a^2,b^2,c^2),1+a*b+b*c+c*a)
			R = QQ[x,y]/(x^2+y^2+1, 3*x+2);
			getTrace(R, 1+y*x^2)
	SeeAlso
	    getMultiplicationMatrix
	    getNorm
		transferGW
///

	
doc ///
	Key
	    getNorm
	    (getNorm, Ring, Thing)
	    (getNorm, Ring, Ideal, Thing)
	Headline
	    Computes the norm over $k$ for an element in a finite dimensional $k$-algebra
	Usage
	    getNorm(C,a)
            getNorm(S,I,b)
	Inputs 
	    C: Ring
			a finite dimensional $k$-algebra
	    a: Thing
	        an element in @TT("C")@
	    S: Ring
	    	a polynomial ring
	    I: Ideal
	        an ideal in the polynomial ring @TT("S")@
	    b: Thing
	    	an element in @TT("S")@
		
	Outputs 
	   : RingElement
	        the norm over $k$ for an element in the algebra
	Description
	    Text
	    	For an element in an algebra @TT("C")@ over a field $k$ or a polynomial ring @TT("S")@ and an ideal @TT("I")@, this function computes the norm over $k$ as the determinant of the @TO2(getMultiplicationMatrix, "getMultiplicationMatrix")@ of the element. 
	    Example 
			L = QQ[x]/(x^6+x^5+x^4+x^3+x^2+x+1);
			F = toField L;
			getNorm(F[a,b,c], ideal(a^2,b^2,c^2),1+a*b+b*c+c*a)
			R = QQ[x,y]/(x^2+y^2+1, 3*x+2);
			getNorm(R, 1+y*x^2)
	SeeAlso
	    getMultiplicationMatrix
	    getTrace
///
