/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class BuiltInAtomicType
implements AtomicType,
Serializable {
    int fingerprint;
    int baseFingerprint;
    int primitiveFingerprint;
    boolean ordered = false;
    public static BuiltInAtomicType ANY_ATOMIC = BuiltInAtomicType.makeAtomicType(632, AnySimpleType.getInstance(), true);
    public static BuiltInAtomicType NUMERIC = BuiltInAtomicType.makeAtomicType(635, ANY_ATOMIC, true);
    public static BuiltInAtomicType STRING = BuiltInAtomicType.makeAtomicType(513, ANY_ATOMIC, true);
    public static BuiltInAtomicType BOOLEAN = BuiltInAtomicType.makeAtomicType(514, ANY_ATOMIC, true);
    public static BuiltInAtomicType DURATION = BuiltInAtomicType.makeAtomicType(518, ANY_ATOMIC, false);
    public static BuiltInAtomicType DATE_TIME = BuiltInAtomicType.makeAtomicType(519, ANY_ATOMIC, true);
    public static BuiltInAtomicType DATE = BuiltInAtomicType.makeAtomicType(521, ANY_ATOMIC, true);
    public static BuiltInAtomicType TIME = BuiltInAtomicType.makeAtomicType(520, ANY_ATOMIC, true);
    public static BuiltInAtomicType G_YEAR_MONTH = BuiltInAtomicType.makeAtomicType(522, ANY_ATOMIC, false);
    public static BuiltInAtomicType G_MONTH = BuiltInAtomicType.makeAtomicType(526, ANY_ATOMIC, false);
    public static BuiltInAtomicType G_MONTH_DAY = BuiltInAtomicType.makeAtomicType(524, ANY_ATOMIC, false);
    public static BuiltInAtomicType G_YEAR = BuiltInAtomicType.makeAtomicType(523, ANY_ATOMIC, false);
    public static BuiltInAtomicType G_DAY = BuiltInAtomicType.makeAtomicType(525, ANY_ATOMIC, false);
    public static BuiltInAtomicType HEX_BINARY = BuiltInAtomicType.makeAtomicType(527, ANY_ATOMIC, false);
    public static BuiltInAtomicType BASE64_BINARY = BuiltInAtomicType.makeAtomicType(528, ANY_ATOMIC, false);
    public static BuiltInAtomicType ANY_URI = BuiltInAtomicType.makeAtomicType(529, ANY_ATOMIC, true);
    public static BuiltInAtomicType QNAME = BuiltInAtomicType.makeAtomicType(530, ANY_ATOMIC, false);
    public static BuiltInAtomicType NOTATION = BuiltInAtomicType.makeAtomicType(531, ANY_ATOMIC, false);
    public static BuiltInAtomicType UNTYPED_ATOMIC = BuiltInAtomicType.makeAtomicType(631, ANY_ATOMIC, true);
    public static BuiltInAtomicType DECIMAL = BuiltInAtomicType.makeAtomicType(515, NUMERIC, true);
    public static BuiltInAtomicType FLOAT = BuiltInAtomicType.makeAtomicType(516, NUMERIC, true);
    public static BuiltInAtomicType DOUBLE = BuiltInAtomicType.makeAtomicType(517, NUMERIC, true);
    public static BuiltInAtomicType INTEGER = BuiltInAtomicType.makeAtomicType(532, DECIMAL, true);
    public static BuiltInAtomicType NON_POSITIVE_INTEGER = BuiltInAtomicType.makeAtomicType(533, INTEGER, true);
    public static BuiltInAtomicType NEGATIVE_INTEGER = BuiltInAtomicType.makeAtomicType(534, NON_POSITIVE_INTEGER, true);
    public static BuiltInAtomicType LONG = BuiltInAtomicType.makeAtomicType(535, INTEGER, true);
    public static BuiltInAtomicType INT = BuiltInAtomicType.makeAtomicType(536, LONG, true);
    public static BuiltInAtomicType SHORT = BuiltInAtomicType.makeAtomicType(537, INT, true);
    public static BuiltInAtomicType BYTE = BuiltInAtomicType.makeAtomicType(538, SHORT, true);
    public static BuiltInAtomicType NON_NEGATIVE_INTEGER = BuiltInAtomicType.makeAtomicType(539, INTEGER, true);
    public static BuiltInAtomicType POSITIVE_INTEGER = BuiltInAtomicType.makeAtomicType(540, NON_NEGATIVE_INTEGER, true);
    public static BuiltInAtomicType UNSIGNED_LONG = BuiltInAtomicType.makeAtomicType(541, NON_NEGATIVE_INTEGER, true);
    public static BuiltInAtomicType UNSIGNED_INT = BuiltInAtomicType.makeAtomicType(542, UNSIGNED_LONG, true);
    public static BuiltInAtomicType UNSIGNED_SHORT = BuiltInAtomicType.makeAtomicType(543, UNSIGNED_INT, true);
    public static BuiltInAtomicType UNSIGNED_BYTE = BuiltInAtomicType.makeAtomicType(544, UNSIGNED_SHORT, true);
    public static BuiltInAtomicType YEAR_MONTH_DURATION = BuiltInAtomicType.makeAtomicType(633, DURATION, true);
    public static BuiltInAtomicType DAY_TIME_DURATION = BuiltInAtomicType.makeAtomicType(634, DURATION, true);
    public static BuiltInAtomicType NORMALIZED_STRING = BuiltInAtomicType.makeAtomicType(553, STRING, true);
    public static BuiltInAtomicType TOKEN = BuiltInAtomicType.makeAtomicType(554, NORMALIZED_STRING, true);
    public static BuiltInAtomicType LANGUAGE = BuiltInAtomicType.makeAtomicType(555, TOKEN, true);
    public static BuiltInAtomicType NAME = BuiltInAtomicType.makeAtomicType(558, TOKEN, true);
    public static BuiltInAtomicType NMTOKEN = BuiltInAtomicType.makeAtomicType(556, TOKEN, true);
    public static BuiltInAtomicType NCNAME = BuiltInAtomicType.makeAtomicType(559, NAME, true);
    public static BuiltInAtomicType ID = BuiltInAtomicType.makeAtomicType(560, NCNAME, true);
    public static BuiltInAtomicType IDREF = BuiltInAtomicType.makeAtomicType(561, NCNAME, true);
    public static BuiltInAtomicType ENTITY = BuiltInAtomicType.makeAtomicType(563, NCNAME, true);
    public static BuiltInAtomicType DATE_TIME_STAMP = BuiltInAtomicType.makeAtomicType(565, DATE_TIME, true);

    private BuiltInAtomicType(int fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getName() {
        if (this.fingerprint == 635) {
            return "numeric";
        }
        return StandardNames.getLocalName(this.fingerprint);
    }

    public String getTargetNamespace() {
        return "http://www.w3.org/2001/XMLSchema";
    }

    public boolean isAbstract() {
        switch (this.fingerprint) {
            case 531: 
            case 573: 
            case 632: 
            case 635: {
                return true;
            }
        }
        return false;
    }

    public boolean isExternalType() {
        return false;
    }

    public boolean isBuiltInType() {
        return true;
    }

    public StructuredQName getTypeName() {
        return new StructuredQName(StandardNames.getPrefix(this.fingerprint), StandardNames.getURI(this.fingerprint), StandardNames.getLocalName(this.fingerprint));
    }

    public int getRedefinitionLevel() {
        return 0;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public String getSystemId() {
        return null;
    }

    public boolean isPrimitiveNumeric() {
        switch (this.fingerprint) {
            case 515: 
            case 516: 
            case 517: 
            case 532: 
            case 635: {
                return true;
            }
        }
        return false;
    }

    public AtomicType getCommonAtomicType() {
        return this;
    }

    public final int getValidationStatus() {
        return 3;
    }

    public final int getBlock() {
        return 0;
    }

    public final int getDerivationMethod() {
        return 1;
    }

    public final boolean allowsDerivation(int derivation) {
        return true;
    }

    public final void setBaseTypeFingerprint(int baseFingerprint) {
        this.baseFingerprint = baseFingerprint;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getNameCode() {
        return this.fingerprint;
    }

    public StructuredQName getQualifiedName() {
        return new StructuredQName("xs", "http://www.w3.org/2001/XMLSchema", StandardNames.getLocalName(this.fingerprint));
    }

    public String getDisplayName() {
        if (this.fingerprint == 635) {
            return "numeric";
        }
        return StandardNames.getDisplayName(this.fingerprint);
    }

    public boolean isPrimitiveType() {
        return Type.isPrimitiveType(this.fingerprint);
    }

    public final boolean isComplexType() {
        return false;
    }

    public boolean isAnonymousType() {
        return false;
    }

    public final SchemaType getBaseType() {
        if (this.baseFingerprint == -1) {
            return null;
        }
        return BuiltInType.getSchemaType(this.baseFingerprint);
    }

    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof AtomicValue) {
            AtomicValue value = (AtomicValue)item;
            if (value.getPrimitiveType() == this) {
                return true;
            }
            AtomicType type = value.getTypeLabel();
            if (type.getFingerprint() == this.getFingerprint()) {
                return true;
            }
            TypeHierarchy th = config.getTypeHierarchy();
            boolean ok = th.isSubType(type, this);
            if (ok) {
                return true;
            }
            if (allowURIPromotion && this.getFingerprint() == 513 && th.isSubType(type, ANY_URI)) {
                return true;
            }
        }
        return false;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        SchemaType base = this.getBaseType();
        if (base instanceof AnySimpleType) {
            return AnyItemType.getInstance();
        }
        return (ItemType)((Object)base);
    }

    public ItemType getPrimitiveItemType() {
        if (this.isPrimitiveType()) {
            return this;
        }
        ItemType s = (ItemType)((Object)this.getBaseType());
        if (s.isAtomicType()) {
            return s.getPrimitiveItemType();
        }
        return this;
    }

    public int getPrimitiveType() {
        return this.primitiveFingerprint;
    }

    public boolean isAllowedInBasicXSLT() {
        return this.isPrimitiveType() && this.getFingerprint() != 531;
    }

    public boolean isAllowedInXSD10() {
        return this.getFingerprint() != 565;
    }

    public String toString(NamePool pool) {
        return this.getDisplayName();
    }

    public AtomicType getAtomizedItemType() {
        return this;
    }

    public boolean isAtomizable() {
        return true;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    public boolean isSameType(SchemaType other) {
        return other.getFingerprint() == this.getFingerprint();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
        if (type != AnySimpleType.getInstance() && !this.isSameType(type)) {
            SchemaType base = this.getBaseType();
            if (base == null) {
                throw new SchemaException("Type " + this.getDescription() + " is not validly derived from " + type.getDescription());
            }
            try {
                base.checkTypeDerivationIsOK(type, block);
            }
            catch (SchemaException se) {
                throw new SchemaException("Type " + this.getDescription() + " is not validly derived from " + type.getDescription());
            }
        }
    }

    public final boolean isSimpleType() {
        return true;
    }

    public boolean isAtomicType() {
        return true;
    }

    public boolean isIdType() {
        return this.fingerprint == 560;
    }

    public boolean isIdRefType() {
        return this.fingerprint == 561;
    }

    public boolean isListType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public int getWhitespaceAction(TypeHierarchy th) {
        switch (this.getFingerprint()) {
            case 513: {
                return 0;
            }
            case 553: {
                return 1;
            }
        }
        return 2;
    }

    public SchemaType getBuiltInBaseType() {
        BuiltInAtomicType base;
        for (base = this; base != null && base.getFingerprint() > 1023; base = (BuiltInAtomicType)base.getBaseType()) {
        }
        return base;
    }

    public boolean isNamespaceSensitive() {
        BuiltInAtomicType base = this;
        int fp = base.getFingerprint();
        while (fp > 1023) {
            base = (BuiltInAtomicType)base.getBaseType();
            fp = base.getFingerprint();
        }
        return fp == 530 || fp == 531;
    }

    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, NameChecker nameChecker) {
        int f = this.getFingerprint();
        if (f == 513 || f == 573 || f == 631 || f == 632) {
            return null;
        }
        ValidationFailure result = null;
        if (this.isNamespaceSensitive()) {
            if (nsResolver == null) {
                throw new UnsupportedOperationException("Cannot validate a QName without a namespace resolver");
            }
            try {
                String[] parts = nameChecker.getQNameParts(Whitespace.trimWhitespace(value));
                String uri = nsResolver.getURIForPrefix(parts[0], true);
                if (uri == null) {
                    result = new ValidationFailure("Namespace prefix " + Err.wrap(parts[0]) + " has not been declared");
                }
                new QNameValue(parts[0], uri, parts[1], QNAME, nameChecker);
            }
            catch (QNameException err) {
                result = new ValidationFailure("Invalid lexical QName " + Err.wrap(value));
            }
            catch (XPathException err) {
                result = new ValidationFailure(err.getMessage());
            }
        } else {
            ConversionResult v = StringValue.convertStringToBuiltInType(value, this, nameChecker);
            if (v instanceof ValidationFailure) {
                result = (ValidationFailure)v;
            }
        }
        return result;
    }

    public final SequenceIterator getTypedValue(NodeInfo node) throws XPathException {
        try {
            CharSequence stringValue = node.getStringValueCS();
            if (stringValue.length() == 0 && node.isNilled()) {
                return EmptyIterator.getInstance();
            }
            return this.getTypedValue(stringValue, new InscopeNamespaceResolver(node), node.getConfiguration().getNameChecker());
        }
        catch (ValidationException err) {
            throw new XPathException("Internal error: value doesn't match its type annotation. " + err.getMessage());
        }
    }

    public Value atomize(NodeInfo node) throws XPathException {
        CharSequence stringValue = node.getStringValueCS();
        if (stringValue.length() == 0 && node.isNilled()) {
            return EmptySequence.getInstance();
        }
        if (this.fingerprint == 513) {
            return StringValue.makeStringValue(stringValue);
        }
        if (this.fingerprint == 631) {
            return new UntypedAtomicValue(stringValue);
        }
        NameChecker checker = node.getConfiguration().getNameChecker();
        if (this.isNamespaceSensitive()) {
            try {
                InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(node);
                String[] parts = checker.getQNameParts(Whitespace.trimWhitespace(stringValue));
                String uri = resolver.getURIForPrefix(parts[0], true);
                if (uri == null) {
                    throw new ValidationException("Namespace prefix " + Err.wrap(parts[0]) + " has not been declared");
                }
                return new QNameValue(parts[0], uri, parts[1], QNAME, checker);
            }
            catch (QNameException err) {
                throw new ValidationException("Invalid lexical QName " + Err.wrap(stringValue));
            }
            catch (XPathException err) {
                throw new ValidationException(err.getMessage());
            }
        }
        return StringValue.convertStringToBuiltInType(stringValue, this, checker).asAtomic();
    }

    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver, NameChecker nameChecker) throws ValidationException {
        if (this.fingerprint == 513) {
            return SingletonIterator.makeIterator(StringValue.makeStringValue(value));
        }
        if (this.fingerprint == 631) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(value));
        }
        if (this.fingerprint == 530 || this.fingerprint == 531) {
            try {
                String[] parts = nameChecker.getQNameParts(Whitespace.trimWhitespace(value));
                String uri = resolver.getURIForPrefix(parts[0], true);
                if (uri == null) {
                    throw new ValidationException("Namespace prefix " + Err.wrap(parts[0]) + " has not been declared");
                }
                return SingletonIterator.makeIterator(this.fingerprint == 530 ? new QNameValue(parts[0], uri, parts[1], this, nameChecker) : new NotationValue(parts[0], uri, parts[1], nameChecker));
            }
            catch (QNameException err) {
                throw new ValidationException("Invalid lexical QName " + Err.wrap(value));
            }
            catch (XPathException err) {
                throw new ValidationException(err.getMessage());
            }
        }
        AtomicValue val = StringValue.convertStringToBuiltInType(value, this, nameChecker).asAtomic();
        return SingletonIterator.makeIterator(val);
    }

    public boolean equals(Object obj) {
        return obj instanceof BuiltInAtomicType && this.getFingerprint() == ((BuiltInAtomicType)obj).getFingerprint();
    }

    public int hashCode() {
        return this.getFingerprint();
    }

    public ValidationFailure validate(AtomicValue primValue, CharSequence lexicalValue, NameChecker checker) {
        switch (this.fingerprint) {
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: 
            case 531: 
            case 532: 
            case 631: 
            case 635: {
                return null;
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                return ((IntegerValue)primValue).validateAgainstSubType(this);
            }
            case 633: 
            case 634: {
                return null;
            }
            case 553: 
            case 554: 
            case 555: 
            case 556: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                return StringValue.validate(this, primValue.getStringValueCS(), checker);
            }
        }
        throw new IllegalArgumentException();
    }

    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) throws XPathException {
        BuiltInAtomicType.analyzeContentExpression(this, expression, env, kind);
    }

    public static void analyzeContentExpression(SimpleType simpleType, Expression expression, StaticContext env, int kind) throws XPathException {
        if (kind == 1) {
            expression.checkPermittedContents(simpleType, env, true);
        } else if (kind == 2 && (expression instanceof ValueOf || expression instanceof Literal)) {
            expression.checkPermittedContents(simpleType, env, true);
        }
    }

    private static BuiltInAtomicType makeAtomicType(int fingerprint, SimpleType baseType, boolean ordered) {
        BuiltInAtomicType t = new BuiltInAtomicType(fingerprint);
        t.setBaseTypeFingerprint(baseType.getFingerprint());
        t.primitiveFingerprint = t.isPrimitiveType() ? fingerprint : ((AtomicType)baseType).getPrimitiveType();
        t.ordered = ordered;
        BuiltInType.register(fingerprint, t);
        return t;
    }

    public CharSequence preprocess(CharSequence input) {
        return input;
    }

    public CharSequence postprocess(CharSequence input) throws ValidationException {
        return input;
    }
}

