///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <core/Core.h>
#include <core/plugins/PluginClassDescriptor.h>
#include <core/plugins/PluginClass.h>
#include <core/plugins/Plugin.h>
#include <core/undo/UndoManager.h>
#include <core/data/ObjectSaveStream.h>
#include <core/data/ObjectLoadStream.h>

namespace Core {

NativePluginClassInfo PluginClass::__pluginClassInfo(NULL, &PluginClass::staticMetaObject, NULL, NULL, NULL);
PluginClassDescriptor* PluginClass::pluginClassDescriptor() const
{
	return __pluginClassInfo.descriptor();
}

/******************************************************************************
* Deletes this object.
******************************************************************************/
void PluginClass::autoDeleteObject()
{
	CHECK_OBJECT_POINTER(this);

	// Do not delete the object if it is locked.
	if(getPluginClassFlag(FLAG_OBJECT_LOCKED)) return;

	// Delete myself now.
	delete this;
}

/******************************************************************************
* Saves the class' contents to the given stream.
******************************************************************************/
void PluginClass::saveToStream(ObjectSaveStream& stream)
{
	// Serialize the object flags.
	stream.writeEnum(getPluginClassFlags());
}

/******************************************************************************
* Loads the class' contents from the given stream.
******************************************************************************/
void PluginClass::loadFromStream(ObjectLoadStream& stream)
{
	// Restore the serialized object flags.
	PluginClassFlags f;
	stream.readEnum(f);
	// Preserve the loading flag.
	this->flags = f | FLAG_OBJ_BEING_LOADED;
}

};
