# Developer Notes

This document provides information useful to developers working on confluent-kafka-python.


## Build

    $ python -m build

If librdkafka is installed in a non-standard location provide the include and library directories with:

    $ C_INCLUDE_PATH=/path/to/include LIBRARY_PATH=/path/to/lib python -m build

**Note**: On Windows the variables for Visual Studio are named INCLUDE and LIB 

## Generate Documentation

Install docs dependencies:

    $ pip install .[docs]

Build HTML docs:

    $ make docs

Documentation will be generated in `docs/_build/`.

or:

    $ python setup.py build_sphinx

Documentation will be generated in  `build/sphinx/html`.

## Unasync -- maintaining sync versions of async code

    $ python tools/unasync.py

    # Run the script with the --check flag to ensure the sync code is up to date
    $ python tools/unasync.py --check

If you make any changes to the async code (in `src/confluent_kafka/schema_registry/_async` and `tests/integration/schema_registry/_async`), you **must** run this script to generate the sync counter parts (in `src/confluent_kafka/schema_registry/_sync` and `tests/integration/schema_registry/_sync`). Otherwise, this script will be run in CI with the --check flag and fail the build.


## Tests


See [tests/README.md](tests/README.md) for instructions on how to run tests.

