\name{sequenceToLaTeX}
\alias{sequenceToLaTeX}
\alias{sequenceToLaTeX.BooleanNetwork}
\alias{sequenceToLaTeX.data.frame}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Create LaTeX table of state sequences
}
\description{
Exports tables of state sequences (corresponding to the plot generated by \code{\link{plotSequence}} with \code{mode="table"}) to a LaTeX document.
}
\usage{
sequenceToLaTeX(network, 
                startState,
                includeAttractorStates = c("all","first","none"),
                sequence,
                title = "",
                grouping = list(), 
                plotFixed = TRUE,
                onColor="[gray]{0.9}",
                offColor="[gray]{0.6}", 
                highlightAttractor=TRUE,
                reverse = FALSE,                
                file="sequence.tex")
}

  \arguments{
     \item{network}{
	  An object of class \code{BooleanNetwork} or \code{SymbolicBooleanNetwork} for which a sequence of state transitions is calculated
  }

  \item{startState}{
  The start state of the sequence
  }
  
  \item{includeAttractorStates}{
  Specifies whether the actual attractor states are included in the table or not (see also \code{\link{getPathToAttractor}}). If \code{includeAttractorStates = "all"} (which is the default behaviour), the sequence ends when the attractor was traversed once. If \code{includeAttractorStates = "first"}, only the first state of attractor is added to the sequence. If {includeAttractorStates = "none"}, the sequence ends with the last non-attractor state. 
  }
  
  \item{sequence}{
  The alternative call to \code{sequenceToLaTeX} requires the specification of the sequence itself instead of the network and the start state. The sequence must be provided as a data frame with the genes in the columns and the successive states in the rows. For example, sequences can be obtained using \code{\link{getPathToAttractor}} or \code{\link{getAttractorSequence}} (however, the specialized function \code{\link{attractorsToLaTeX}} exists for attractors).
  }
  
  \item{title}{
	An optional title for the table
}
  
  \item{plotFixed}{If this is true, genes with fixed values are included in the plot. Otherwise, these genes are not shown.
}
  
  \item{grouping}{This optional parameter specifies a structure to form groups of genes in the table. This is a list with the following elements: 
 \describe{
  	\item{class}{A vector of names for the groups. These names will be printed in the region belonging to the group in the tabke.}  	
  	\item{index}{A list with the same length as \code{class}. Each element is a vector of gene names or gene indices belonging to the group.}}
}

  \item{onColor}{
	An optional color value for the 1/ON values in the table. Defaults to dark grey.
}
  \item{offColor}{
	An optional color value for the 0/OFF values in the table. Defaults to light grey.	
}

 \item{highlightAttractor}{
If set to true, the attractor states are highlighted in the plot by drawing a line at the begin of the attractor and labeling the states correspondingly. Information on the attractor must be supplied in the attribute \code{attractor} of the sequence, which is a vector of indices of the states that belong to the attractor. This attribute is usually present if the sequence was obtained using \code{\link{getPathToAttractor}}.
}

  \item{reverse}{
Specifies the order of the genes in the plot. By default, the first gene is placed in the first row of the table. If \code{reverse=TRUE}, the first gene in the network is placed in the bottom row of the table. 
}

  \item{file}{
	The file to which the LaTeX document is written. Defaults to "sequence.tex".
}

}
\details{
This function creates a LaTeX table that visualizes a sequence of states in a synchronous network. 
The output file does not contain a document header and requires the inclusion of the packages \code{tabularx} and \code{colortbl}. The tables have the genes in the rows and the successive states of the sequence in the columns. If not specified otherwise, cells of the table are light grey for 0/OFF values and dark grey for 1/ON values. If \code{grouping} is set, the genes are rearranged according to the indices in the group, horizontal separation lines are plotted between the groups, and the group names are printed.

The function can be called with different types of inputs: The user can specify the parameters \code{network}, \code{startState} and \code{includeAttractorStates}), in which case \code{\link{getPathToAttractor}} is called to obtain the sequence. Alternatively, the sequence can be supplied directly as a data frame in the \code{sequence} parameter.
}
\value{
Returns a matrix corresponding to the table. The matrix has the genes in the rows and the states of the attractors in the columns. If \code{sequence} was supplied, this corresponds to the transposed input whose rows may be rearranged if \code{grouping} was set.
}
\seealso{
\code{\link{attractorsToLaTeX}}, \code{\link{plotSequence}}, \code{\link{plotAttractors}}, \code{\link{getPathToAttractor}}, \code{\link{getAttractorSequence}}.
}
\examples{
\dontrun{
# load example data
data(cellcycle)

# alternative 1: supply network and start state
# and export sequence to LaTeX
sequenceToLaTeX(network=cellcycle, 
                startState=rep(1,10), 
                includeAttractorStates="all",
                file="sequence.txt")

# alternative 2: calculate sequence in advance
sequence <- getPathToAttractor(cellcycle, 
                               state=rep(1,10), 
                               includeAttractorStates="all")

sequenceToLaTeX(sequence=sequence, 
                file="sequence.txt")
}
}
