% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_df.R
\name{get_node_df}
\alias{get_node_df}
\title{Get a node data frame from a graph}
\usage{
get_node_df(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A node data frame.
}
\description{
From a graph, obtain a node data frame with all current node attributes.
}
\examples{
# Create a graph
graph <-
  create_graph() \%>\%
  add_n_nodes(
    n = 1,
    type = "a") \%>\%
  select_last_nodes_created() \%>\%
  add_n_nodes_ws(
    n = 5,
    direction = "from",
    type = "b") \%>\%
  select_nodes_by_id(
    nodes = 1) \%>\%
  set_node_attrs_ws(
    node_attr = value,
    value = 25.3) \%>\%
  clear_selection() \%>\%
  select_nodes_by_id(
    nodes = 2:4) \%>\%
  set_node_attrs_ws(
    node_attr = color,
    value = "grey70") \%>\%
  invert_selection() \%>\%
  set_node_attrs_ws(
    node_attr = color,
    value = "grey80") \%>\%
  clear_selection()

# Get the graph's internal node
# data frame (ndf)
graph \%>\%
  get_node_df()

}
