% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_last_edges_created.R
\name{select_last_edges_created}
\alias{select_last_edges_created}
\title{Select the last set of edges created in a graph}
\usage{
select_last_edges_created(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Select the last edges that were created in a graph object of class
\code{dgr_graph}. This function should ideally be used just after creating the
edges to be selected.
}
\examples{
# Create a graph and add a cycle and then
# a tree in 2 separate function calls
graph <-
  create_graph() \%>\%
  add_cycle(
    n = 3,
    rel = "a") \%>\%
  add_balanced_tree(
    k = 2, h = 2,
    rel = "b")

# Select the last edges created (all edges
# from the tree) and then set their edge
# color to be `red`
graph <-
  graph \%>\%
  select_last_edges_created() \%>\%
  set_edge_attrs_ws(
    edge_attr = color,
    value = "red") \%>\%
  clear_selection()

# Display the graph's internal edge
# data frame to verify the change
graph \%>\% get_edge_df()

}
