% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/looic.R
\name{looic}
\alias{looic}
\title{LOO-related Indices for Bayesian regressions.}
\usage{
looic(model)
}
\arguments{
\item{model}{A Bayesian regression model.}
}
\value{
A list with four elements, the ELPD, LOOIC and their standard errors.
}
\description{
Compute LOOIC (leave-one-out cross-validation (LOO) information
  criterion) and ELPD (expected log predictive density) for Bayesian regressions.
}
\examples{
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ wt + cyl, data = mtcars, chains = 1, iter = 500, refresh = 0)
  looic(model)
}
}
