use strict;
use warnings;

use RT::Test tests => undef;

# A privileged user, but with no privs
my $bad = RT::Test->load_or_create_user(
    Name => 'testing',
    EmailAddress => 'test@example.com',
    Password => 'password',
);
ok( $bad, "Got a user object back" );
ok( $bad->id, "Successfully created a user" );


# A ticket CF
my $obj = RT::Test->load_or_create_custom_field(
    Name  => "Private CF",
    Type  => "Freeform",
    Queue => 0,
);

my ($t) = RT::Test->create_tickets( {},
    { Subject => 'Testing' }
);
ok($t->id, "Created a ticket");

# Add a txn on it
my ($cfid) = $t->AddCustomFieldValue(
    Field => $obj->Id,
    Value => "hidden-value"
);
ok($cfid, "Got CF id $cfid");
my $update_id = $t->Transactions->Last->Id;

# Somebody else shouldn't be able to see the old and new values
my ($base, $m) = RT::Test->started_ok;
$m->post_ok("$base/REST/1.0/transaction/$update_id", [
    user    => 'testing',
    pass    => 'password',
    format  => 'l',
]);
$m->content_lacks("hidden-value");

# Make a transaction on a user
my $root = RT::Test->load_or_create_user( Name => "root" );
$root->SetHomePhone("hidden-value");
$update_id = $root->Transactions->Last->Id;

# Which should also be hidden from random privileged users
$m->post_ok("$base/REST/1.0/transaction/$update_id", [
    user    => 'testing',
    pass    => 'password',
    format  => 'l',
]);
$m->content_lacks("hidden-value");

undef $m;
done_testing;
