#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "taylor.icc"
#include "stokes_dirichlet_dg.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2], "vector");
  space Qh (omega, argv[2]);
  form a, b, c, mp;
  field lh, kh;
  stokes_dirichlet_dg (Xh, Qh, a, b, c, mp, lh, kh);
  field uh (Xh, 0), ph (Qh, 0);
  solver_abtb stokes (a.uu(), b.uu(), c.uu(), mp.uu());
  stokes.solve (lh.u(), kh.u(), uh.set_u(), ph.set_u());
  dout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
