#include "rheolef.h"
using namespace rheolef;
using namespace std;

int main(int argc, char** argv) {
  Float lambda;
  field uh;
  cin >> catchmark("lambda") >> lambda
      >> catchmark("u")      >> uh;
  string approx = (uh.get_approx() == "P2") ? "P1d" : "P0";
  space Th  (uh.get_geo(), approx, "tensor");
  space Xh  (uh.get_geo(), approx);
  form two_D  (uh.get_space(), Th, "2D");
  form div    (uh.get_space(), Xh, "div");
  form inv_mt (Th, Th, "inv_mass");
  form inv_m  (Xh, Xh, "inv_mass");
  field q  = inv_m*(div*uh);
  field sh = inv_mt*(two_D*uh);
  for (size_t i = 0; i < uh.dimension(); i++)
      sh(i,i) += lambda*q;
  cout << catchmark("s") << sh;
  return 0;
}
