function flag=xcos_debug_gui(flag,block)
    // Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
    // Copyright (C) 2013 - INRIA - Serge Steer <serge.steer@inria.fr>
    //
// Copyright (C) 2012 - 2016 - Scilab Enterprises
//
// This file is hereby licensed under the terms of the GNU GPL v2.0,
// pursuant to article 5.3.4 of the CeCILL v.2.1.
// This file was originally licensed under the terms of the CeCILL v2.1,
// and continues to be available under such terms.
// For more information, see the COPYING file which you should have received
// along with this program.

    if scicos_debug()==0  then return;end
    gui =  findobj("tag","Xcos_debug_gui");
    init=gui==[]

    if init then
        gui=xcos_debug_create_gui()
        before=%t
        t=0
        cb=curblock()
        f=%cpr.sim.funs(cb)
        path=%cpr.corinv(cb);
    end
    ud=gui.user_data;
    if ~init then
        //at least one flags must be selected
        Flags=find(ud.Flags.value==1)
        if Flags==[] then
            Flags=2
            ud.Flags(2).value=1
        end
        //at least before or after must be selected
        When=find(ud.When.value==1)
        if When==[] then
            When=1
            ud.When(1).value=1
        end

        if and(flag+1<>Flags) then return,end
        t=scicos_time();
        time_to_wait=evstr(ud.Time.string);
        if t< time_to_wait then return,end

        instr=stripblanks(ud.Condition.string);
        if instr<>"" then
            if execstr("Cond="+instr,"errcatch")==0 then
                if ~Cond then return,end
            end
        end

        cb=curblock();// l'index du block dans la structure résultant de la compilation
        f=%cpr.sim.funs(cb);//fonction de calcul

        path=%cpr.corinv(cb);

        before=ud.previous==[];
        if before then
            ud.previous=path
            if and(When<>1) then set(gui,"user_data",ud);return,end
        else
            ud.previous=[]
            if and(When<>2) then set(gui,"user_data",ud);return,end
        end
    end
    //break asked
    handles=ud.handles;
    if before then //before block
        handles(4).string=_("Stopped before block:")
    else //after
        handles(4).string=_("Stopped after block:")
    end
    Actions=[_("State derivative computation")
    _("Regular outputs update")
    _("States update on discrete event")
    _("Output activation dates")
    _("Initialization")
    _("Ending")
    _("ReInitialization")
    _("Continuous states properties update")
    ""
    _("Zero crossing surfaces computation")
    _("Residual computation")];

    handles(1).string=msprintf("%.3g",t);
    handles(2).string=string(cb);
    handles(3).string=string(flag)+" ("+Actions(flag+1)+")"
    handles(5).string=sci2exp(path,0)
    //Highlight current block
    blk=scs_m.objs(path(1));
    uids=blk.model.label;
    for k=2:size(path,"*")
        blk=blk.model.rpar.objs(path(k));
        uids=[uids blk.model.label];
    end
    ud.Buttons.enable="on";
    warnBlockByUID(uids, "Error");
    while %t //To handle pause actions
        realtimeinit(0.01);
        tt=0;
        global ret;
        ret=0;
        while ret==0 then
            //Wait till user select a button
            //slow down the waiting loop
            tt=tt+1;
            realtime(tt);
        end
        for k=size(uids,"*"):-1:1
            warnBlockByUID(uids(1:k), "")
        end

        r=ret;clearglobal ret;clear ret
        select r
        case 1 then //Next
            if xcos_debug_check_time(ud.Time)&xcos_debug_check_cond(ud.Condition) then
                if before then ud.previous=path;end
                ud.Buttons.enable="off"
                set(gui,"user_data",ud)
                return
            end
        case 2 then //End debug
            scicos_debug(0)
            delete(gui.parent)
            return
        case 3 then //pause
            Y=list()
            if block.nout>0 then
                outtb=%cpr.state.outtb
                sz=matrix(block.outsz,block.nout,-1)
                for i=1:block.nout
                    Y($+1)=%cpr.state.outtb(block.outptr(i)+(1:prod(sz(i,1:2))))
                end
            end
            U=list()
            if block.nin>0 then
                outtb=%cpr.state.outtb
                sz=matrix(block.insz,block.nin,-1)
                for i=1:block.nout
                    U($+1)=%cpr.state.outtb(block.inptr(i)+(1:prod(sz(i,1:2))))
                end
            end
            ud.Buttons.enable="off"
            pause
            ud.Buttons.enable="on"
            if before then ud.previous=path;end
            set(gui,"user_data",ud)
            //    end
        end
    end
endfunction

function gui=xcos_debug_create_gui()
    margin_x     = 5;      // Horizontal margin between each elements
    margin_y     = 5;      // Vertical margin between each elements
    button_w     = 80;
    button_h     = 20;
    label_h      = 20;
    label_h1      = 30;
    label_w1      = 200;
    label_w2      = 80;
    frame_w     = max(4*margin_x+label_w1+label_w2,4*margin_x+3*button_w,12*margin_x+10*label_h)
    frame_h     = 16*margin_y+10*label_h+3*label_h1+button_h

    axes_w       = 2*margin_x+frame_w;
    axes_h       = 2*margin_y+frame_h;// Frame height
    defaultfont  = "arial"; // Default Font

    fig_id=max(winsid())+1
    fig = scf(fig_id)
    fig.visible = "off";
    toolbar(fig.figure_id, "off");
    fig.axes_size       = [axes_w axes_h];
    // Remove Scilab graphics menus & toolbar
    delmenu(fig.figure_id, gettext("&File"));
    delmenu(fig.figure_id, gettext("&Tools"));
    delmenu(fig.figure_id, gettext("&Edit"));
    delmenu(fig.figure_id, gettext("&?"));
    fig.figure_size(2)=axes_h
    fig.axes_size       = [axes_w axes_h];
    fig.background      = addcolor([0.8 0.8 0.8]);
    fig.figure_name     = _("Xcos debug");
    fig.closerequestfcn = "xcos_debug_gui_close()"
    ax=fig.children;
    ax.background= fig.background ;

    gui=uicontrol( ...
    "parent"              , fig,...
    "style"               , "frame",...
    "units"               , "pixels",...
    "position"            , [margin_x margin_y frame_w frame_h],...
    "background"          , [1 1 1]*0.8, ...
    "tag"                 , "Xcos_debug_gui",...
    "visible"             , "on");

    yo=axes_h-button_h;


    y=frame_h-margin_y-label_h1
    x=margin_x;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("Break point conditions"),...
    "units"               , "pixels",...
    "position"            , [x y frame_w-2*margin_x label_h1],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 16,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "center", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    y=y-label_h-margin_y;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("Break on selected flags"),...
    "units"               , "pixels",...
    "position"            , [x y frame_w-2*margin_x label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    yl=y-label_h-margin_y;
    y=yl-label_h-margin_y;
    xk=x
    Flags=[]
    for k=0:9
        uicontrol( ...
        "parent"              , gui,...
        "style"               , "text",...
        "string"              , string(k),...
        "units"               , "pixels",...
        "position"            , [xk yl label_h label_h],....
        "fontname"            , defaultfont,...
        "fontunits"           , "points",...
        "fontsize"            , 12,...
        "fontweight"          , "bold", ...
        "horizontalalignment" , "left", ...
        "background"          , [1 1 1]*0.8, ...
        "visible"             , "on");
        Flags=[Flags,uicontrol( ...
        "parent"              , gui,...
        "style"               , "checkbox",...
        "value"               , 0,...
        "units"               , "pixels",...
        "position"            , [xk y label_h label_h],....
        "fontname"            , defaultfont,...
        "fontunits"           , "points",...
        "fontsize"            , 12,...
        "fontweight"          , "bold", ...
        "horizontalalignment" , "left", ...
        "background"          , [1 1 1]*0.8, ...
        "visible"             , "on")];
        xk=xk+label_h+margin_x
    end
    Flags(2).value=1;
    yl=y-label_h-margin_y;
    y=yl-label_h-margin_y;
    xk=x;
    When=[]
    L=[_("Before call"),_("After call")]
    for k=1:2
        uicontrol( ...
        "parent"              , gui,...
        "style"               , "text",...
        "string"              , L(k),...
        "units"               , "pixels",...
        "position"            , [xk yl label_w2 label_h],....
        "fontname"            , defaultfont,...
        "fontunits"           , "points",...
        "fontsize"            , 12,...
        "fontweight"          , "bold", ...
        "horizontalalignment" , "left", ...
        "background"          , [1 1 1]*0.8, ...
        "visible"             , "on");
        When=[When,uicontrol( ...
        "parent"              , gui,...
        "style"               , "checkbox",...
        "value"               , 0,...
        "units"               , "pixels",...
        "position"            , [xk y label_h label_h],....
        "fontname"            , defaultfont,...
        "fontunits"           , "points",...
        "fontsize"            , 12,...
        "fontweight"          , "bold", ...
        "horizontalalignment" , "left", ...
        "background"          , [1 1 1]*0.8, ...
        "visible"             , "on")];
        xk=xk+label_w2+margin_x
    end
    When(1).value=1;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("After date"),...
    "units"               , "pixels",...
    "position"            , [xk yl label_w2 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    Time=uicontrol( ...
    "parent"              , gui,...
    "style"               , "edit",...
    "string"               , "0",...
    "units"               , "pixels",...
    "position"            , [xk y label_w2 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "callback"            , "xcos_debug_check_time();" ,...
    "visible"             , "on");
    y=y-label_h-2*margin_y;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("On the Scilab condition above"),...
    "units"               , "pixels",...
    "position"            , [x y frame_w-2*margin_x label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    y=y-label_h-2*margin_y;
    Condition=uicontrol( ...
    "parent"              , gui,...
    "style"               , "edit",...
    "string"              , "",...
    "units"               , "pixels",...
    "position"            , [x y frame_w-6*margin_x label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "callback"            , "xcos_debug_check_cond();" ,...
    "visible"             , "on");
    y=y-label_h1-margin_y;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("Current simulation state"),...
    "units"               , "pixels",...
    "position"            , [x y frame_w-2*margin_x label_h1],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 16,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "center", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    y=y-label_h-margin_y;
    X=uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , "",...
    "units"               , "pixels",...
    "position"            , [x y label_w1 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "horizontalalignment" , "left", ...
    "fontweight"          , "bold", ..
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");

    B=uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , "0",...
    "units"               , "pixels",...
    "position"            , [x+label_w1+margin_x y label_w2 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "horizontalalignment" , "right", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    y=y-label_h-margin_y;
    //%%%%%%
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("scs_m block path:"),...
    "units"               , "pixels",...
    "position"            , [x y label_w1 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");

    P=uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , "0",...
    "units"               , "pixels",...
    "position"            , [x+label_w1+margin_x y label_w2 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "horizontalalignment" , "right", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");
    y=y-label_h-margin_y;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("Time:"),...
    "units"               , "pixels",...
    "position"            , [x y label_w1 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");

    T=uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , "0",...
    "units"               , "pixels",...
    "position"            , [x+label_w1+margin_x y label_w2 label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "horizontalalignment" , "right", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");

    y=y-label_h-margin_y;
    uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , _("Flag:"),...
    "units"               , "pixels",...
    "position"            , [x y 4*label_h label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "left", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");

    F=uicontrol( ...
    "parent"              , gui,...
    "style"               , "text",...
    "string"              , "6",...
    "units"               , "pixels",...
    "position"            , [x+4*label_h+margin_x y label_w2+label_w1+-4*label_h label_h],....
    "fontname"            , defaultfont,...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "horizontalalignment" , "right", ...
    "background"          , [1 1 1]*0.8, ...
    "visible"             , "on");

    //buttons
    y=y-button_h-margin_y;
    xb=x;
    Next = uicontrol( ...
    "parent"              , gui,...
    "relief"              , "groove",...
    "style"               , "pushbutton",...
    "string"              , _("Next"),...
    "units"               , "pixels",...
    "position"            , [xb,y,button_w button_h],..
    "fontname"            , "arial",...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "center", ...
    "visible"             , "on", ...
    "callback"            , "global ret;ret=1;");
    xb=xb+margin_x+button_w
    Stop = uicontrol( ...
    "parent"              , gui,...
    "relief"              , "groove",...
    "style"               , "pushbutton",...
    "string"              , _("End debug"),...
    "units"               , "pixels",...
    "position"            , [xb,y,button_w button_h],..
    "fontname"            , "arial",...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "center", ...
    "visible"             , "on", ...
    "callback"            , "global ret;ret=2;");
    xb=xb+margin_x+button_w
    Pause = uicontrol( ...
    "parent"              , gui,...
    "relief"              , "groove",...
    "style"               , "pushbutton",...
    "string"              , _("Pause"),...
    "units"               , "pixels",...
    "position"            , [xb,y,button_w button_h],..
    "fontname"            , "arial",...
    "fontunits"           , "points",...
    "fontsize"            , 12,...
    "fontweight"          , "bold", ...
    "horizontalalignment" , "center", ...
    "visible"             , "on", ...
    "callback"            , "global ret;ret=3;");

    set(gui,"user_data",struct("handles",[T,B,F,X,P],"previous",[],...
    "Flags",Flags,"When",When,"Time",Time,...
    "Condition",Condition,...
    "Buttons",[Next,Stop,Pause]))
    fig.visible = "on";
endfunction
function ok=xcos_debug_check_time(Time)
    if argn(2)<1 then Time=gcbo;end
    ud=Time.parent.user_data
    ok=execstr("t="+Time.string,"errcatch")==0
    if ~ok|type(t)<>1|size(t,"*")<>1 then
        Time.ForegroundColor=[1 0 0];
        ud.Buttons.enable="off"
        ok=%f
    else
        Time.ForegroundColor=[0 0 0];
        ud.Buttons.enable="on"
        ok=%t
    end
endfunction
function ok=xcos_debug_check_cond(Condition)
    if argn(2)<1 then Condition=gcbo;end
    ud=Condition.parent.user_data
    Cond=stripblanks(Condition.string)
    if Cond=="" then
        ok=%t
        c=%f
    else
        ok=execstr("c="+Cond,"errcatch")==0
    end
    if ~ok|and(type(c)<>[1 4])|size(c,"*")<>1 then
        Condition.ForegroundColor=[1 0 0];
        ud.Buttons.enable="off"
        ok=%f
    else
        Condition.ForegroundColor=[0 0 0];
        ud.Buttons.enable="on"
        ok=%t
    end

endfunction
function xcos_debug_gui_close()
    messagebox(msprintf(_("Use the ""%s"" button to end the debugging"),_("End debug")),"modal")
endfunction
