/*
 * @(#)DialP.h
 *
 * Copyright 1994 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Dial */

#ifndef _DialP_h
#define _DialP_h

#include "xwin.h"
#include "Dial.h"

#define BG_SHADES 3
#define MAX_SEGMENTS 200

typedef struct _DialPart {
	float       angle;
	int         maxDegree;
	int         minimum, maximum, val;
	int         factor;
	int         markers;
	int         menu, pixmapSize;
	Boolean     mono, reverse, focus;
	Boolean     versionOnly;
	Position    markerLength;
	Position    dialRadius;
	XPoint      pointer, center;
	GC          borderGC;
	GC          markerGC, pointerGC;
	GC          inverseGC[BG_SHADES];
	XSegment    segments[MAX_SEGMENTS];
	Pixel       markerColor, pointerColor;
	Pixel       foreground, background;
	Pixel       borderColor;
	XtCallbackList select;
} DialPart;

typedef struct _DialRec {
	CorePart core;
	DialPart dial;
} DialRec;

typedef struct _DialClassPart {
	int ignore;
} DialClassPart;

typedef struct _DialClassRec {
	CoreClassPart coreClass;
	DialClassPart dialClass;
} DialClassRec;

extern DialClassRec dialClassRec;

void calculateDial(DialWidget w);
#endif /* _DialP_h */
